import os

# hides torchio citation request, see https://github.com/fepegar/torchio/issues/235
os.environ["TORCHIO_HIDE_CITATION_PROMPT"] = "1"

from .imaging import (
    resize_image,
    resample_image,
    perform_sanity_check_on_subject,
    sanity_check_on_file_readers,
    write_training_patches,
    get_correct_padding_size,
    applyCustomColorMap,
    MapSaver,
)

from .tensor import (
    one_hot,
    reverse_one_hot,
    send_model_to_device,
    get_model_dict,
    get_class_imbalance_weights,
    get_class_imbalance_weights_segmentation,
    get_class_imbalance_weights_classification,
    get_linear_interpolation_mode,
    print_model_summary,
    get_ground_truths_and_predictions_tensor,
    get_output_from_calculator,
    get_tensor_from_image,
    get_image_from_tensor,
)

from .write_parse import (
    writeTrainingCSV,
    parseTrainingCSV,
    parseTestingCSV,
    get_dataframe,
    convert_relative_paths_in_dataframe,
)

from .parameter_processing import (
    populate_header_in_parameters,
    find_problem_type,
    find_problem_type_from_parameters,
    populate_channel_keys_in_params,
)

from .generic import (
    get_date_time,
    get_unique_timestamp,
    get_filename_extension_sanitized,
    version_check,
    get_array_from_image_or_tensor,
    suppress_stdout_stderr,
    set_determinism,
    print_and_format_metrics,
    determine_classification_task_type,
    getBase2,
    get_git_hash,
)

from .modelio import (
    BEST_MODEL_PATH_END,
    LATEST_MODEL_PATH_END,
    INITIAL_MODEL_PATH_END,
    load_model,
    load_ov_model,
    save_model,
    optimize_and_save_model,
)

from .data_splitter import split_data
from .gandlf_logging import logger_setup, InfoOnlyFilter
