# Generated by Django 3.2.23 on 2024-10-14 17:40

import uuid

import django.db.models.deletion
from django.db import (
    migrations,
    models,
)

import edu_eldoc_registry.paths


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Certificate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='Создан')),
                ('modified', models.DateTimeField(auto_now=True, db_index=True, verbose_name='Изменен')),
                ('serial', models.CharField(max_length=64, unique=True, verbose_name='Серийный номер')),
                ('name', models.CharField(max_length=255, verbose_name='Название сертификата')),
                ('subject', models.CharField(max_length=255, verbose_name='Владелец')),
                ('issuer', models.CharField(max_length=255, verbose_name='Издатель')),
                ('date_from', models.DateField(verbose_name='Действителен с')),
                ('date_to', models.DateField(verbose_name='Действителен до')),
            ],
            options={
                'verbose_name': 'Информация о сертификате',
                'verbose_name_plural': 'Информация о сертификатах',
            },
        ),
        migrations.CreateModel(
            name='Document',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='Создан')),
                ('modified', models.DateTimeField(auto_now=True, db_index=True, verbose_name='Изменен')),
                ('uuid', models.UUIDField(default=uuid.uuid1, editable=False, unique=True)),
                ('name', models.CharField(max_length=255, verbose_name='Название файла')),
                ('file', models.FileField(max_length=255, upload_to=edu_eldoc_registry.paths.upload_doc_to_path, verbose_name='Файл для подписания')),
                ('status', models.SmallIntegerField(choices=[(0, 'Новый'), (1, 'Готов к подписанию'), (2, 'Подписан'), (3, 'Отклонён')], default=0)),
            ],
            options={
                'verbose_name': 'Электронный документ',
                'verbose_name_plural': 'Электронные документы',
            },
        ),
        migrations.CreateModel(
            name='Sign',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='Создан')),
                ('modified', models.DateTimeField(auto_now=True, db_index=True, verbose_name='Изменен')),
                ('uuid', models.UUIDField(default=uuid.uuid1, editable=False, unique=True)),
                ('sign_file', models.FileField(max_length=255, upload_to=edu_eldoc_registry.paths.upload_sign_to_path, verbose_name='Файл подписи')),
                ('attached', models.BooleanField(verbose_name='Присоединенная подпись')),
                ('certificate', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='edu_eldoc_registry.certificate', verbose_name='Подписан сертификатом')),
                ('document', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='edu_eldoc_registry.document', verbose_name='Подписанный документ')),
            ],
            options={
                'verbose_name': 'Подпись документа',
                'verbose_name_plural': 'Подписи документов',
            },
        ),
    ]
