[![Chaiverse Banner](https://i.imgur.com/HGlydGb.png)](https://www.chaiverse.com/)

[![PyPI version](https://badge.fury.io/py/chaiverse.svg)](https://badge.fury.io/py/chaiverse)
[![first-timers-only Friendly](https://img.shields.io/badge/first--timers--only-friendly-blue.svg)](http://www.firsttimersonly.com/)
[![Pull Requests Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat)](http://makeapullrequest.com)


# $1M LLM Prize Hosted By
![Chai Logo](./resources/chai-logo-black.png#gh-light-mode-only)
![Chai Logo](./resources/chai-logo-white.png#gh-dark-mode-only)

[Chaiverse](https://www.chaiverse.com) is part of the Chai Prize Competition, accelerating community AGI.

It's the world's first open community challenge with real-user evaluations. You models will be directly deployed on the [Chai App](http://tosto.re/chaiapp) where our over 1.4M daily active users will be providing live feedback. Get to top of the leaderboard and share the $1 million cash prize!

## 🚀 Quick Start with Colab
1. Join the [Chaiverse Discord](https://discord.gg/v6dQNmnevt), our bot will greet you and give you a developer key 🥳
2. Submit a model in < 10 minutes with [Chaiverse Jupyter Notebook Quickstart](https://colab.research.google.com/drive/1FyCamT6icUo5Wlt6qqogHbyREHQQkAY8?usp=sharing)
3. Run through our [Chaiverse Prompt Engineering Guide](https://colab.research.google.com/drive/1eMRidYrys3b1mPrhUOJnfAB3Z7tcCNn0?usp=sharing) to submit models with custom prompts
4. Run through our [Chaiverse: Reward Model Guide](https://drive.google.com/file/d/15lWzRoP0RZ7jVxhas_zQaG2OyvqxaxhT/view?usp=sharing) to submit reward models! ❤️
5. Run through our [Chaiverse: Blend Model Guide](https://colab.research.google.com/drive/1HeslM8jq7H-bbThoujhE6zM9twKPuukH?usp=sharing) to submit blended models! 
6. Take a look at our #new-joiners #dataset-sharing and #ai-discussions channels for easter eggs

## 📼 Local Installation
1. Run `pip install chaiverse`
2. Read through examples shown in the "Quick Start with Colab" section

## :keyboard: Chaiverse CLI
You can also interact with Chaiverse directly from your terminal using Chaiverse CLI. Read through our [user guide](https://wild-chatter-b52.notion.site/Chaiverse-CLI-User-Guide-2aba61f9db4a4ac78f26420f4e96ba4c?pvs=4) for instructions.


## 🧠 How Does It Work?

-   The `chaiverse` pip package provides a way to easily submit your language model, all you need to do is ensure it is on HuggingFace 🤗
-   We will automatically **Tritonize** your model for fast inference and host it in our internal GPU cluster 🚀
-   Once deployed, Chai users on our platform who enter the **arena mode** will be rating your model directly, providing you with both quantatitive and verbal feedback 📈
-   Both the public leaderboard and **user feedback** for your model can be directly downloaded via the `chaiverse` package 🧠
-   Cash prizes will be allocated according to your position in the leaderboard 💰

[![Chai Pipeline](https://imgur.com/LtMWOAq.png)](https://www.chaiverse.com)


## Resources
|                                                                        |                                                                                                 |
| ---------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------|
| 🤗 [Chai Huggingface](https://huggingface.co/ChaiML) | Tons of models / datasets for you to finetune on! Including past winner solutions                                                           |
| 📒 [Fine tuning guide](https://huggingface.co/docs/transformers/training) | Guide on language model finetuning                                                           |
| 💾 [Datasets](https://github.com/mlabonne/llm-datasets) | Curated list of open-sourced datasets to get started with finetuning                                                  |
| 💖 [Chaiverse Discord](https://discord.gg/v6dQNmnevt)                   | Our Chaiverse Competition discord                                                          |
|🚀 [Deepspeed Guide](https://huggingface.co/docs/transformers/main_classes/deepspeed)     | Guide for training with Deepspeed (faster training without GPU bottleneck)    |
|💬 [Example Conversations](https://huggingface.co/datasets/ChaiML/100_example_conversations)     | Here you can find 100 example conversations from the Chai Platform     |
| ⚒️ [Build with us](https://www.chai-research.com/jobs/)| If you think what we are building is cool, join us!|
| ❗ [Competition EULA](https://www.chai-research.com/competition-eula.html)| Covers terms of use and competition agreements|


<!-- TODO: fix link to competition eula -->
[CHAI RESEARCH CORP. COMPETITION END USER LICENSE AGREEMENT (EULA)](https://www.chai-research.com/competition-eula.html)
