# mcpacket

![mcpacket logo](https://raw.githubusercontent.com/danohn/mcpacket/main/readme-assets/logo.png)

A modular Python MCP (Model Context Protocol) Server for analyzing PCAP files. mcpacket enables LLMs to read and analyze network packet captures from local or remote sources, providing structured JSON responses about network traffic.

## Overview

mcpacket uses a modular architecture to analyze different network protocols found in PCAP files. Each module focuses on a specific protocol, allowing for targeted analysis and easy extensibility. The server leverages the powerful scapy library for packet parsing and analysis.

### Key Features

- **Modular Architecture**: Easily extensible to support new protocols
- **Local & Remote PCAP Support**: Read files from local directories or HTTP servers
- **Scapy Integration**: Leverages scapy's comprehensive packet parsing capabilities
- **MCP Server**: Integrates seamlessly with LLM clients via Model Context Protocol
- **JSON Responses**: Structured data format for easy LLM consumption

## Installation

mcpacket requires Python 3.10 or greater.

### Using pip

```bash
pip install mcpacket
```

### Using uv

```bash
uv add mcpacket
```

### Using uvx (for one-time usage)

```bash
uvx mcpacket
```

## Quick Start

1. **Start the MCP Server**:

   ```bash
   mcpacket --pcap-path /path/to/pcap/files
   ```

2. **Connect your LLM client** to the MCP server

3. **Ask questions** about your network traffic:
   - "What domain was queried the most in the DNS traffic?"
   - "Show me all DNS queries for example.com"
   - "What are the top 5 queried domains?"

## Modules

### DNS Module

The DNS module analyzes Domain Name System packets in PCAP files.

**Capabilities**:

- Extract DNS queries and responses
- Identify queried domains and subdomains
- Analyze query types (A, AAAA, MX, etc.)
- Track query frequency and patterns
- Identify DNS servers used

**Example Usage**:

```python
# LLM can ask: "What domains were queried in this PCAP?"
# mcpacket will return structured JSON with DNS query information
```

## Configuration

### PCAP Sources

**Local Directory**:

```bash
mcpacket --pcap-path /local/path/to/pcaps
```

**Remote HTTP Server**:

```bash
mcpacket --pcap-url http://example.com/pcaps/
```

### Module Selection

```bash
mcpacket --modules dns --pcap-path /path/to/files
```

## Example

An example PCAP file (`example.pcap`) containing DNS traffic is included with the project to help you get started.

## Architecture

mcpacket's modular design makes it easy to extend support for new protocols:

1. **Core Engine**: Handles PCAP file loading and basic packet processing
2. **Protocol Modules**: Individual modules for specific protocols (DNS, etc.)
3. **MCP Interface**: Translates between LLM queries and packet analysis results
4. **Output Formatter**: Converts analysis results to structured JSON

### Adding New Modules

New protocol modules can be added by:

1. Implementing the module interface
2. Defining scapy display filters for the protocol
3. Creating analysis functions specific to the protocol
4. Registering the module with the core engine

Future modules might include:

- BGP (Border Gateway Protocol)
- HTTP/HTTPS traffic analysis
- TCP connection tracking
- And more!

## Remote Access

mcpacket supports reading PCAP files from remote HTTP servers without authentication. Future versions may include support for Basic Authentication and other security mechanisms.

## Contributing

Contributions are welcome! Whether you want to:

- Add support for new protocols
- Improve existing modules
- Enhance the MCP interface
- Add new features

Please feel free to open issues and submit pull requests.

## License

MIT

## Requirements

- Python 3.10+
- scapy
- MCP server dependencies (automatically installed)

## Support

For questions, issues, or feature requests, please open an issue on GitHub.
