# Publications

## Overview

This maintains a list of publications (journals, conferences, ...) where IESopt was applied as part of the modeling
approach. Entries are in chronological order. If you want to contribute a new publication or project, please follow the
instructions in the [section on contributing](#contributing) below.

## List of references

### Mariuzzo, et al. (2025)

<span>
    <a href="https://doi.org/10.1016/j.rser.2024.115028" target="_blank"><img alt="Citation DOI" src="https://img.shields.io/badge/DOI-10.1016%2Fj.rser.2024.115028-white?style=flat&labelColor=blue" style="display:inline; vertical-align:middle;"/></a>
    &nbsp;
    <a href="https://publications.ait.ac.at/de/publications/grid-friendly-optimization-of-energy-communities-through-enhanced" target="_blank"><img alt="Citation PURE" src="https://img.shields.io/badge/PURE-publications.ait.ac.at-white?style=social&labelColor=blue" style="display:inline; vertical-align:middle;"/></a>
</span>

| **Factsheet** |   |
|---------------|---|
| title         | Grid-friendly optimization of energy communities through enhanced multiple participation |
| project       | - |
| keywords      | Energy communities, Multiple participation, Linear programming, Peak load, Load shedding |
| abstract      | Energy communities have been designed to promote sustainable development in the form of improved and affordable energy access, sustainable generation, and social inclusion. Thus, in this study, an optimization model is proposed to allocate the demand and production of each participant, generation unit, and storage initially belonging to different communities that are implemented under the same distribution transformer and engage in multiple participation. Both energy- and grid-related costs are minimized, and the benchmark independent energy community case is compared with the novel multiple participation. |
| citation      | Mariuzzo, I., Fina, B., Stroemer, S., Corinaldesi, C., & Raugi, M. (2025). Grid-friendly optimization of energy communities through enhanced multiple participation. _Renewable and Sustainable Energy Reviews, 208_, 115028. |

---

### Strömer, et al. (2024)

<span>
    <a href="https://doi.org/10.1109/OSMSES62085.2024.10668965" target="_blank"><img alt="Citation DOI" src="https://img.shields.io/badge/DOI-10.1109%2FOSMSES62085.2024.10668965-white?style=flat&labelColor=blue" style="display:inline; vertical-align:middle;"/></a>
    &nbsp;
    <a href="https://publications.ait.ac.at/en/publications/iesopt-a-modular-framework-for-high-performance-energy-system-opt" target="_blank"><img alt="Citation PURE" src="https://img.shields.io/badge/PURE-publications.ait.ac.at-white?style=social&labelColor=blue" style="display:inline; vertical-align:middle;"/></a>
</span>

| **Factsheet** |   |
|---------------|---|
| title         | IESopt: A Modular Framework for High-Performance Energy System Optimization |
| project       | - |
| keywords      | energy system modeling, optimization framework, Julia, open-source-tool introduction |
| abstract      | Current climatic, political, and societal challenges pose increasingly complex questions, which in turn require comprehensive models of the real world, with rapidly growing complexity, to support decision makers with sound and reliable quantitative analyses. The energy system optimization framework IESopt may constitute one piece in filling this gap, by offering a modular and adaptable tool for modelers, that does not compromise on performance while still being user-friendly. This is enabled by reducing energy system assets to abstract building blocks, that are supported by specialized implementation, and can be combined into complex systems without the need of a detailed understanding of mathematical modeling or proficiency in any coding-language. IESopt's architecture and functionalities are laid out here, and demonstrated by the means of an illustrative example. |
| citation      | Strömer, S., & Maggauer, K. (2024, September). IESopt: A Modular Framework for High-Performance Energy System Optimization. In _2024 Open Source Modelling and Simulation of Energy Systems (OSMSES)_ (pp. 1-6). IEEE. |

---

### Strömer, et al. (2024)

<span>
    <a href="https://publications.ait.ac.at/en/publications/modelling-the-future-hydrogen-system-insights-from-the-hydrogen-v" target="_blank"><img alt="Citation PURE" src="https://img.shields.io/badge/PURE-publications.ait.ac.at-white?style=social&labelColor=blue" style="display:inline; vertical-align:middle;"/></a>
</span>

| **Factsheet** |   |
|---------------|---|
| title         | Modelling the Future Hydrogen System: Insights from the Hydrogen Valley "East Austria" |
| project       | [H2Real](#references-projects-h2real) |
| keywords      | Hydrogen valleys, Infrastructure modelling, Energy system modelling, Optimisation |
| abstract      | The ongoing project H2REAL, "Hydrogen Region East Austria goes Live", aims to combine domain knowledge, existing assets, infrastructure, and real-world demonstrators, with scientific support to further develop the hydrogen infrastructure of Eastern Austria during the upcoming years. This work introduces the systemic modelling approach, undertaken as part of the project, that is used to analyse the emergence, transition, and to-be-achieved ideal design of the Austrian hydrogen infrastructure, that is indispensable to support imports, production, and transportation of hydrogen to wide range of customers. |
| citation      | Strömer, S., Reuter, S., Ortmann, P., & Hasengst, F. (2024). Modelling the Future Hydrogen System: Insights from the Hydrogen Valley "East Austria". _In NEFI Conference New Energy for Industry 2024 Proceedings_ (pp. 26-28) |

---

### Strömer, et al. (2024)

<span>
    <a href="https://doi.org/10.1016/j.segy.2024.100151" target="_blank"><img alt="Citation DOI" src="https://img.shields.io/badge/DOI-10.1016%2Fj.segy.2024.100151-white?style=flat&labelColor=blue" style="display:inline; vertical-align:middle;"/></a>
    &nbsp;
    <a href="https://publications.ait.ac.at/en/publications/transitioning-to-a-renewable-hydrogen-system-optimal-infrastructu" target="_blank"><img alt="Citation PURE" src="https://img.shields.io/badge/PURE-publications.ait.ac.at-white?style=social&labelColor=blue" style="display:inline; vertical-align:middle;"/></a>
</span>

| **Factsheet** |   |
|---------------|---|
| title         | Transitioning to a Renewable Hydrogen System: Optimal Infrastructure for Self-sufficient Hydrogen Supply in Austria by 2030 |
| project       | [HyTechonomy](#references-projects-hytechonomy) |
| keywords      | Hydrogen, Renewable energy, Infrastructure modeling, Energy system modeling, Optimization |
| abstract      | In this study, we employ an optimization model to optimally design a self-sufficient, independent of any imports and exports, hydrogen infrastructure for Austria by 2030. Our approach integrates key hydrogen technologies within a detailed spatial investment and operation model – coupled with a European scale electricity market model. We focus on optimizing diverse infrastructure components including trailers, pipelines, electrolyzers, and storages to meet Austria's projected hydrogen demand. To accurately estimate this demand in hourly resolution, we combine existing hydrogen strategies and projections to account for developments in various industrial sectors, consider demand driven by the transport sector, and integrate hydrogen demand arising from its use in gas-powered plants. Accounting for the inherent uncertainty linked to such projections, we run the analysis for two complementary scenarios. Our approach addresses the challenges of integrating large quantities of renewable hydrogen into a future energy system by recognizing the critical role of domestic production in the early market stages. The main contribution of this work is to address the gap in optimizing hydrogen infrastructure for effective integration of domestic renewable hydrogen production in Austria by 2030, considering sector coupling potentials, optimal electrolyzer placement, and the design of local hydrogen networks. |
| citation      | Strömer, S., Beck, A., Traninger, M., Orsolits, D., Reuter, S. (2024). Transitioning to a renewable hydrogen system: Optimal infrastructure for self-sufficient hydrogen supply in Austria by 2030. In _Smart Energy Volume 15 (2024)_ (pp. 1-17). |

---

### Ortmann, et al. (2024)

<span>
    <a href="https://doi.org/10.1109/EEM60825.2024.10608856" target="_blank"><img alt="Citation DOI" src="https://img.shields.io/badge/DOI-10.1109%2FEEM60825.2024.10608856-white?style=flat&labelColor=blue" style="display:inline; vertical-align:middle;"/></a>
    &nbsp;
    <a href="https://publications.ait.ac.at/en/publications/development-of-a-global-market-model-for-renewable-hydrogen" target="_blank"><img alt="Citation PURE" src="https://img.shields.io/badge/PURE-publications.ait.ac.at-white?style=social&labelColor=blue" style="display:inline; vertical-align:middle;"/></a>
</span>

| **Factsheet** |   |
|---------------|---|
| title         | Development of a Global Market Model for Renewable Hydrogen |
| project       | [H2REAL](#references-projects-h2real) |
| keywords      | Renewable energy sources, Energy Markt Modelling, Hydrogen Market, Hydrogen Price Projections, Renewable Hydrogen |
| abstract      | Considerable effort has been devoted to obtaining price indications for renewable hydrogen, reflecting the high interest in this topic. The focus of the present work is to combine the existing fundamental data into a market model to find a cost-minimizing equilibrium solution for a hypothetical ideal global hydrogen market in 2030. By combining data on planned production projects with LCOH estimations, a supply curve can be constructed for each region. Demand for renewable hydrogen is derived from European regulation such as the Renewable Energy Directive. Equilibrium prices, including marginal costs for transportation via ship or pipeline, range between €2.5 and 3.5 €/kg. The cost-optimal solution of the model also provides insights on the most efficient production sites as well as transport flows. It is observable that anticipated European production is adequate to meet demand, with flows within Europe mainly occurring from the North to the South. |
| citation      | Ortmann, P., Reuter, S., & Strömer, S. (2024). Development of a Global Market Model for Renewable Hydrogen. In _20th International Conference on the European Energy Market (EEM)_(pp. 1-6). |

---

### Ortmann, et al. (2024)

<span>
    <a href="https://publications.ait.ac.at/de/publications/entwicklung-eines-globalen-marktmodells-f%C3%BCr-wasserstoff" target="_blank"><img alt="Citation PURE" src="https://img.shields.io/badge/PURE-publications.ait.ac.at-white?style=social&labelColor=blue" style="display:inline; vertical-align:middle;"/></a>
</span>

| **Factsheet** |   |
|---------------|---|
| title         | Entwicklung eines globalen Marktmodells für Wasserstoff |
| project       | [H2REAL](#references-projects-h2real) |
| keywords      | Wasserstoff, Erzeugungskosten, Marktmodell Wasserstoff |
| abstract      | Wasserstoff wird einen essenziellen Bestandteil des zukünftigen Energiesystems darstellen. Derzeit liegen die Erzeugungskosten von grünem Wasserstoff deutlich über jenen von fossilen Alternativen. Vor allem in Mitteleuropa sind die Erzeugungspotentiale für grünen Wasserstoff beschränkt, weshalb der Import in einem wachsenden Markt eine zunehmende Rolle spielen wird. In vergangenen Arbeiten wurden die Erzeugungskosten an einzelnen Standorten ermittelt, gezielte Importrouten kalkuliert, Transportkosten abgeschätzt, oder das Flächenpotenzial zur H2-Erzeugung beurteilt. Die vorliegende Arbeit führt diese vorhandenen Fundamentaldaten in einem globalen Marktmodell zusammen, um eine kostenminimale Gleichgewichtslösung für den weltweiten Wasserstoffhandel zu finden. |
| citation      | Ortmann, P., Reuter, S., & Strömer, S. (2024). Entwicklung eines globalen Marktmodells für Wasserstoff. _18. Symposium Energieinnovation (EnInnov 2024)_. |

---

### Patha, et al. (2024)

<span>
    <a href="https://doi.org/10.34726/hss.2024.110543" target="_blank"><img alt="Citation DOI" src="https://img.shields.io/badge/DOI-10.34726%2Fhss.2024.110543-white?style=flat&labelColor=blue" style="display:inline; vertical-align:middle;"/></a>
    &nbsp;
    <a href="https://publications.ait.ac.at/de/publications/techno-economic-assessment-of-pumped-storage-hydro-power-in-hybri" target="_blank"><img alt="Citation PURE" src="https://img.shields.io/badge/PURE-publications.ait.ac.at-white?style=social&labelColor=blue" style="display:inline; vertical-align:middle;"/></a>
</span>

| **Factsheet** |   |
|---------------|---|
| title         | Techno-economic assessment of pumped storage hydro power in hybrid operation with floating photovoltaic and battery energy storage |
| project       | - |
| keywords      | Floating PV, Techno-Economic Assessment, Pumped Storage Hydro Power |
| abstract      | This thesis investigates the techno-economic impact of a floating PV system (FPV) and a battery energy storage system (BESS) in hybrid operation with pumped storage hydro power plants (PSHP) traded on the day-ahead market. It is assumed that FPV brings additional benefits to the PSHP by reducing evaporation and thus increasing the overall efficiency of the storage. Other advantages, such as sharing the grid connection and increasing the utilization of FPV generation by reducing curtailment, are also evaluated. A comparison is made between the binary and ternary operation of the PSHP, in which the ternary mode of operation increases operational flexibility. An existing storage power plant in central Sweden, for which Global Hydro provides specific data, is used as a reference for the PSHP. A steady-state simulation is used, which is optimized for trading on the day-ahead market. The simulation framework used for the technical model is the internal TESCA framework of the Austrian Institute of Technology (AIT), which is a Python-based tool for the techno-economic assessment of different technologies. The optimization model is a linearized abstraction implemented with the Julia-based optimization tool IESOpt of the AIT. The simulation is performed for different quantities of nominal FPV power, battery usable energy capacity and BESS storage duration (ratio of usable energy capacity and maximum discharge/charge power) within a parameter study to show the impact on the technical and economic key performance indicators. The levelized cost of energy (LCOE) and net present value (NPV) of the entire hybrid system are calculated for different weighted average costs of capital to assess the economic viability of the entire hybrid system. It is shown that the combined operation of FPV and PSHP can make better use of the limited grid connection capacity, as the FPV electricity can serve as input for the pumps. The BESS adds further storage capacity to store FPV generation and shift it via arbitrage to times of high energy prices. Overall, FPV and BESS increase the LCOE as the additional costs are not compensated by the energy surplus. The NPV is reduced by both technologies and makes the entire system economically nonviable for increasing nominal FPV power and BESS usable energy capacity. |
| citation      | Patha, A., Steinlechner S., Kathan J., Golab, A., Auer, H., (2024). Techno-economic assessment of pumped storage hydro power in hybrid operation with floating photovoltaic and battery energy storage [Diploma Thesis, Technische Universität Wien]. reposiTUm. |

---

### Reuter, et al. (2023)

<span>
    <a href="https://publications.ait.ac.at/en/publications/optimizing-the-domestic-production-and-infrastructure-for-green-h" target="_blank"><img alt="Citation PURE" src="https://img.shields.io/badge/PURE-publications.ait.ac.at-white?style=social&labelColor=blue" style="display:inline; vertical-align:middle;"/></a>
</span>

| **Factsheet** |   |
|---------------|---|
| title         | Optimizing the Domestic Production and Infrastructure for Green Hydrogen in Austria for 2030 |
| project       | [HyTechonomy](#references-projects-hytechonomy) |
| keywords      | Hydrogen infrastructure, Energy system modelling, centralised electrolysis, decentralised electrolysis |
| abstract      | The decarbonisation of the Austrian energy system is expected to be facilitated by the uptake of hydrogen-based technologies, which requires the establishment of a hydrogen infrastructure to meet the rising demand. While large quantities of hydrogen are expected to be imported in the future, current developments in the energy market suggest that domestic production of hydrogen should not be ignored to ensure the security of supply. As domestic production ramps up, locating electrolysers to ensure optimal system integration is still an open question. To address this challenge, the "HyTechonomy" project developed an optimisation model that identifies the most promising domestic locations for green hydrogen production and optimal means of hydrogen transport for the year 2030. |
| citation      | Reuter, S., Strömer, S., Traninger, M., & Beck, A. (2023, September). Optimizing the Domestic Production and Infrastructure for Green Hydrogen in Austria for 2030. In _Book of Abstracts: 9th International Conference on Smart Energy Systems_ (pp. 278-279). |

---

### Marx, et al. (2023)

<span>
    <a href="https://publications.ait.ac.at/en/publications/heat-highway-heat-transmission-network-design-optimization-and-ro" target="_blank"><img alt="Citation PURE" src="https://img.shields.io/badge/PURE-publications.ait.ac.at-white?style=social&labelColor=blue" style="display:inline; vertical-align:middle;"/></a>
</span>

| **Factsheet** |   |
|---------------|---|
| title         | Heat Highway - Heat Transmission Network Design Optimization and Robustness Analysis for a Case Study in Tyrol |
| project       | [Heat Highway](#references-projects-heathighway) |
| keywords      | Future district heating, Waste heat sources, 4th generation DH, Heat transmission networks, Deterministic optimization, Monte Carlo simulation |
| abstract      | The majority of district heating (DH) networks today are fueled by combustion processes based on fossil or biogenic fuels. For the decarbonization of DH networks various uncertainties regarding the future development of key factors, such as energy prices, need to be considered. Within the project "HeatHighway" a hypothetical inter-regional heat transfer network (HTN) in the region of the Inn valley in Tyrol, Austria was investigated. |
| citation      | Marx, N. O., Schmidt, R. R., Blakcori, R., Maggauer, K., Strömer, S., & Forster, T. (2023). Heat Highway - Heat Transmission Network Design Optimization and Robustness Analysis for a Case Study in Tyrol. In _Book of Abstracts: 9th International Conference on Smart Energy Systems_ (pp. 103-104). |

---

## Contributing

To contribute a new reference, either

- fork the [iesopt](https://github.com/ait-energy/iesopt) repository, and directly add to the above list, or
- open an issue with the reference details.

See the template below for the structure of a reference.

### Template

Please stick to APA format here, and always include a link as badge (if possible a DOI, if not other links are okay
too).

`````markdown
### LastnameFirstAuthor, et al. (YYYY)

<span>
    <a href="doi-url-here" target="_blank"><img alt="Citation DOI" src="https://img.shields.io/badge/DOI-10.XXXX%2Fname.YYYY.ZZZZZZ-white?style=flat&labelColor=blue" style="display:inline; vertical-align:middle;"/></a>
    &nbsp;
    <a href="ait-pure-url-here" target="_blank"><img alt="Citation PURE" src="https://img.shields.io/badge/PURE-publications.ait.ac.at-white?style=social&labelColor=blue" style="display:inline; vertical-align:middle;"/></a>
</span>

| **Factsheet** |   |
|---------------|---|
| title         | put the full title here |
| project       | [Project (short) name](#references-projects-shortname) |
| keywords      | put all keywords here |
| abstract      | put the abstract here |
| citation      | put the APA styled citation here |

---
`````

The `project` can be left out if not applicable. Otherwise it should refer to a proper project link target, that is set.

### Creating citation badges

You can use [shields.io](https://shields.io/badges) to create badges, or use standardized ones that you already have
(e.g., from Zenodo), otherwise stick to the ones provided in the template above (DOI and PURE).
