"""
 Copyright 2023. Aubin Ramon and Pietro Sormanni. CC BY-NC-SA 4.0
"""

import numpy


# a variation of the blosum62 matrix that has been normalised so that all elements on the diagonal are the same, in practice this means that this matrix contains information
# on the chemical diversity of amino acids, but not on their frequency (or abundance) as this was normalised out it can thus be used to e.g. calculate a distance in the chemical space. 'ARNDCQEGHILKMFPSTWYVBZX-'
distance_blosum_normalised = numpy.array(
    [
        [
            0,
            12,
            14,
            14,
            10,
            12,
            12,
            10,
            14,
            12,
            12,
            12,
            12,
            14,
            12,
            8,
            10,
            15,
            14,
            10,
            15,
            12,
            10,
            15,
        ],
        [
            12,
            0,
            10,
            14,
            15,
            8,
            10,
            14,
            10,
            17,
            14,
            6,
            12,
            16,
            13,
            12,
            12,
            14,
            13,
            17,
            12,
            10,
            12,
            15,
        ],
        [
            14,
            10,
            0,
            8,
            14,
            10,
            10,
            10,
            9,
            16,
            16,
            10,
            14,
            15,
            13,
            8,
            10,
            15,
            13,
            16,
            4,
            10,
            11,
            15,
        ],
        [
            14,
            14,
            8,
            0,
            14,
            10,
            6,
            12,
            11,
            16,
            18,
            12,
            16,
            15,
            12,
            10,
            12,
            15,
            15,
            16,
            2,
            8,
            11,
            15,
        ],
        [
            10,
            15,
            14,
            14,
            0,
            15,
            16,
            14,
            14,
            12,
            12,
            15,
            12,
            13,
            14,
            12,
            12,
            12,
            13,
            12,
            15,
            15,
            13,
            15,
        ],
        [
            12,
            8,
            10,
            10,
            15,
            0,
            6,
            14,
            10,
            17,
            14,
            8,
            10,
            16,
            12,
            10,
            12,
            13,
            12,
            14,
            10,
            3,
            12,
            15,
        ],
        [
            12,
            10,
            10,
            6,
            16,
            6,
            0,
            14,
            10,
            17,
            17,
            8,
            14,
            16,
            12,
            10,
            12,
            14,
            13,
            14,
            8,
            1,
            12,
            15,
        ],
        [
            10,
            14,
            10,
            12,
            14,
            14,
            14,
            0,
            13,
            18,
            18,
            14,
            16,
            15,
            13,
            10,
            14,
            13,
            15,
            16,
            12,
            14,
            11,
            15,
        ],
        [
            14,
            10,
            9,
            11,
            14,
            10,
            10,
            13,
            0,
            16,
            16,
            12,
            13,
            11,
            13,
            12,
            13,
            12,
            7,
            16,
            10,
            10,
            11,
            15,
        ],
        [
            12,
            17,
            16,
            16,
            12,
            17,
            17,
            18,
            16,
            0,
            5,
            17,
            8,
            10,
            16,
            15,
            12,
            15,
            12,
            2,
            18,
            18,
            12,
            15,
        ],
        [
            12,
            14,
            16,
            18,
            12,
            14,
            17,
            18,
            16,
            5,
            0,
            14,
            6,
            10,
            16,
            15,
            12,
            13,
            12,
            8,
            20,
            18,
            12,
            15,
        ],
        [
            12,
            6,
            10,
            12,
            15,
            8,
            8,
            14,
            12,
            17,
            14,
            0,
            12,
            16,
            12,
            10,
            12,
            14,
            13,
            14,
            10,
            8,
            12,
            15,
        ],
        [
            12,
            12,
            14,
            16,
            12,
            10,
            14,
            16,
            13,
            8,
            6,
            12,
            0,
            10,
            13,
            12,
            12,
            11,
            12,
            8,
            17,
            12,
            12,
            15,
        ],
        [
            14,
            16,
            15,
            15,
            13,
            16,
            16,
            15,
            11,
            10,
            10,
            16,
            10,
            0,
            16,
            14,
            14,
            9,
            5,
            12,
            16,
            16,
            11,
            15,
        ],
        [
            12,
            13,
            13,
            12,
            14,
            12,
            12,
            13,
            13,
            16,
            16,
            12,
            13,
            16,
            0,
            12,
            12,
            15,
            14,
            14,
            14,
            12,
            13,
            15,
        ],
        [
            8,
            12,
            8,
            10,
            12,
            10,
            10,
            10,
            12,
            15,
            15,
            10,
            12,
            14,
            12,
            0,
            8,
            15,
            14,
            15,
            10,
            10,
            10,
            15,
        ],
        [
            10,
            12,
            10,
            12,
            12,
            12,
            12,
            14,
            13,
            12,
            12,
            12,
            12,
            14,
            12,
            8,
            0,
            13,
            13,
            10,
            12,
            12,
            10,
            15,
        ],
        [
            15,
            14,
            15,
            15,
            12,
            13,
            14,
            13,
            12,
            15,
            13,
            14,
            11,
            9,
            15,
            15,
            13,
            0,
            8,
            15,
            17,
            15,
            13,
            15,
        ],
        [
            14,
            13,
            13,
            15,
            13,
            12,
            13,
            15,
            7,
            12,
            12,
            13,
            12,
            5,
            14,
            14,
            13,
            8,
            0,
            12,
            16,
            14,
            11,
            15,
        ],
        [
            10,
            17,
            16,
            16,
            12,
            14,
            14,
            16,
            16,
            2,
            8,
            14,
            8,
            12,
            14,
            15,
            10,
            15,
            12,
            0,
            18,
            15,
            12,
            15,
        ],
        [
            15,
            12,
            4,
            2,
            15,
            10,
            8,
            12,
            10,
            18,
            20,
            10,
            17,
            16,
            14,
            10,
            12,
            17,
            16,
            18,
            0,
            8,
            12,
            15,
        ],
        [
            12,
            10,
            10,
            8,
            15,
            3,
            1,
            14,
            10,
            18,
            18,
            8,
            12,
            16,
            12,
            10,
            12,
            15,
            14,
            15,
            8,
            0,
            12,
            15,
        ],
        [
            10,
            12,
            11,
            11,
            13,
            12,
            12,
            11,
            11,
            12,
            12,
            12,
            12,
            11,
            13,
            10,
            10,
            13,
            11,
            12,
            12,
            12,
            12,
            15,
        ],
        [
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            0,
        ],
    ]
)


blosum_alph = {
    "A": 0,
    "R": 1,
    "N": 2,
    "D": 3,
    "C": 4,
    "Q": 5,
    "E": 6,
    "G": 7,
    "H": 8,
    "I": 9,
    "L": 10,
    "K": 11,
    "M": 12,
    "F": 13,
    "P": 14,
    "S": 15,
    "T": 16,
    "W": 17,
    "Y": 18,
    "V": 19,
    "B": 20,
    "Z": 21,
    "X": 22,
    "*": 23,
    "-": 23,
}  # indices for blosum_normalised and distance_blosum_normalised


distance_blosum_normalised_gap_to_zero = numpy.array(
    [
        [
            0,
            12,
            14,
            14,
            10,
            12,
            12,
            10,
            14,
            12,
            12,
            12,
            12,
            14,
            12,
            8,
            10,
            15,
            14,
            10,
            15,
            12,
            10,
            0,
        ],
        [
            12,
            0,
            10,
            14,
            15,
            8,
            10,
            14,
            10,
            17,
            14,
            6,
            12,
            16,
            13,
            12,
            12,
            14,
            13,
            17,
            12,
            10,
            12,
            0,
        ],
        [
            14,
            10,
            0,
            8,
            14,
            10,
            10,
            10,
            9,
            16,
            16,
            10,
            14,
            15,
            13,
            8,
            10,
            15,
            13,
            16,
            4,
            10,
            11,
            0,
        ],
        [
            14,
            14,
            8,
            0,
            14,
            10,
            6,
            12,
            11,
            16,
            18,
            12,
            16,
            15,
            12,
            10,
            12,
            15,
            15,
            16,
            2,
            8,
            11,
            0,
        ],
        [
            10,
            15,
            14,
            14,
            0,
            15,
            16,
            14,
            14,
            12,
            12,
            15,
            12,
            13,
            14,
            12,
            12,
            12,
            13,
            12,
            15,
            15,
            13,
            0,
        ],
        [
            12,
            8,
            10,
            10,
            15,
            0,
            6,
            14,
            10,
            17,
            14,
            8,
            10,
            16,
            12,
            10,
            12,
            13,
            12,
            14,
            10,
            3,
            12,
            0,
        ],
        [
            12,
            10,
            10,
            6,
            16,
            6,
            0,
            14,
            10,
            17,
            17,
            8,
            14,
            16,
            12,
            10,
            12,
            14,
            13,
            14,
            8,
            1,
            12,
            0,
        ],
        [
            10,
            14,
            10,
            12,
            14,
            14,
            14,
            0,
            13,
            18,
            18,
            14,
            16,
            15,
            13,
            10,
            14,
            13,
            15,
            16,
            12,
            14,
            11,
            0,
        ],
        [
            14,
            10,
            9,
            11,
            14,
            10,
            10,
            13,
            0,
            16,
            16,
            12,
            13,
            11,
            13,
            12,
            13,
            12,
            7,
            16,
            10,
            10,
            11,
            0,
        ],
        [
            12,
            17,
            16,
            16,
            12,
            17,
            17,
            18,
            16,
            0,
            5,
            17,
            8,
            10,
            16,
            15,
            12,
            15,
            12,
            2,
            18,
            18,
            12,
            0,
        ],
        [
            12,
            14,
            16,
            18,
            12,
            14,
            17,
            18,
            16,
            5,
            0,
            14,
            6,
            10,
            16,
            15,
            12,
            13,
            12,
            8,
            20,
            18,
            12,
            0,
        ],
        [
            12,
            6,
            10,
            12,
            15,
            8,
            8,
            14,
            12,
            17,
            14,
            0,
            12,
            16,
            12,
            10,
            12,
            14,
            13,
            14,
            10,
            8,
            12,
            0,
        ],
        [
            12,
            12,
            14,
            16,
            12,
            10,
            14,
            16,
            13,
            8,
            6,
            12,
            0,
            10,
            13,
            12,
            12,
            11,
            12,
            8,
            17,
            12,
            12,
            0,
        ],
        [
            14,
            16,
            15,
            15,
            13,
            16,
            16,
            15,
            11,
            10,
            10,
            16,
            10,
            0,
            16,
            14,
            14,
            9,
            5,
            12,
            16,
            16,
            11,
            0,
        ],
        [
            12,
            13,
            13,
            12,
            14,
            12,
            12,
            13,
            13,
            16,
            16,
            12,
            13,
            16,
            0,
            12,
            12,
            15,
            14,
            14,
            14,
            12,
            13,
            0,
        ],
        [
            8,
            12,
            8,
            10,
            12,
            10,
            10,
            10,
            12,
            15,
            15,
            10,
            12,
            14,
            12,
            0,
            8,
            15,
            14,
            15,
            10,
            10,
            10,
            0,
        ],
        [
            10,
            12,
            10,
            12,
            12,
            12,
            12,
            14,
            13,
            12,
            12,
            12,
            12,
            14,
            12,
            8,
            0,
            13,
            13,
            10,
            12,
            12,
            10,
            0,
        ],
        [
            15,
            14,
            15,
            15,
            12,
            13,
            14,
            13,
            12,
            15,
            13,
            14,
            11,
            9,
            15,
            15,
            13,
            0,
            8,
            15,
            17,
            15,
            13,
            0,
        ],
        [
            14,
            13,
            13,
            15,
            13,
            12,
            13,
            15,
            7,
            12,
            12,
            13,
            12,
            5,
            14,
            14,
            13,
            8,
            0,
            12,
            16,
            14,
            11,
            0,
        ],
        [
            10,
            17,
            16,
            16,
            12,
            14,
            14,
            16,
            16,
            2,
            8,
            14,
            8,
            12,
            14,
            15,
            10,
            15,
            12,
            0,
            18,
            15,
            12,
            0,
        ],
        [
            15,
            12,
            4,
            2,
            15,
            10,
            8,
            12,
            10,
            18,
            20,
            10,
            17,
            16,
            14,
            10,
            12,
            17,
            16,
            18,
            0,
            8,
            12,
            0,
        ],
        [
            12,
            10,
            10,
            8,
            15,
            3,
            1,
            14,
            10,
            18,
            18,
            8,
            12,
            16,
            12,
            10,
            12,
            15,
            14,
            15,
            8,
            0,
            12,
            0,
        ],
        [
            10,
            12,
            11,
            11,
            13,
            12,
            12,
            11,
            11,
            12,
            12,
            12,
            12,
            11,
            13,
            10,
            10,
            13,
            11,
            12,
            12,
            12,
            12,
            0,
        ],
        [
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            15,
            0,
        ],
    ]
)
