"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EthereumNode = exports.Network = exports.InstanceType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const cdk = require("aws-cdk-lib");
const managedblockchain = require("aws-cdk-lib/aws-managedblockchain");
const constructs = require("constructs");
const utilities = require("./utilities");
/**
 * Supported instance types for Managed Blockchain nodes
 */
var InstanceType;
(function (InstanceType) {
    InstanceType["BURSTABLE3_SMALL"] = "bc.t3.small";
    InstanceType["BURSTABLE3_MEDIUM"] = "bc.t3.medium";
    InstanceType["BURSTABLE3_LARGE"] = "bc.t3.large";
    InstanceType["BURSTABLE3_XLARGE"] = "bc.t3.xlarge";
    InstanceType["STANDARD5_LARGE"] = "bc.m5.large";
    InstanceType["STANDARD5_XLARGE"] = "bc.m5.xlarge";
    InstanceType["STANDARD5_XLARGE2"] = "bc.m5.2xlarge";
    InstanceType["STANDARD5_XLARGE4"] = "bc.m5.4xlarge";
    InstanceType["COMPUTE5_LARGE"] = "bc.c5.large";
    InstanceType["COMPUTE5_XLARGE"] = "bc.c5.xlarge";
    InstanceType["COMPUTE5_XLARGE2"] = "bc.c5.2xlarge";
    InstanceType["COMPUTE5_XLARGE4"] = "bc.c5.4xlarge";
})(InstanceType = exports.InstanceType || (exports.InstanceType = {}));
/**
 * Supported Ethereum networks for Managed Blockchain nodes
 */
var Network;
(function (Network) {
    Network["MAINNET"] = "n-ethereum-mainnet";
    Network["ROPSTEN"] = "n-ethereum-ropsten";
    Network["RINKEBY"] = "n-ethereum-rinkeby";
})(Network = exports.Network || (exports.Network = {}));
class EthereumNode extends constructs.Construct {
    /**
     * Creates an Ethereum public network node on an Amazon Managed Blockchain network
    */
    constructor(scope, id, props) {
        super(scope, id);
        const region = cdk.Stack.of(this).region;
        /**
         * Builds out Ethereum node given a list of input property objects,
         * using defaults if values not provided; additionally checks to ensure node deployment
         * is supported given region and availability zone
         */
        if (typeof props === 'undefined')
            props = {};
        // If no node configurations are provided, create one; the empty object
        // will be populated with defaults when passed to the node constructor
        this.network = props.network ?? Network.MAINNET;
        this.instanceType = props.instanceType ?? InstanceType.BURSTABLE3_LARGE;
        this.availabilityZone = props.availabilityZone ?? `${region}a`;
        utilities.validateRegion(region);
        utilities.validateAvailabilityZone(region, this.availabilityZone);
        /**
         * Build out CloudFormation resources populating with input values or defaults if none provided
         */
        new managedblockchain.CfnNode(this, id, {
            networkId: this.network,
            nodeConfiguration: {
                availabilityZone: this.availabilityZone,
                instanceType: this.instanceType,
            },
        });
    }
}
exports.EthereumNode = EthereumNode;
_a = JSII_RTTI_SYMBOL_1;
EthereumNode[_a] = { fqn: "@cdklabs/cdk-ethereum-node.EthereumNode", version: "0.0.27" };
//# sourceMappingURL=data:application/json;base64,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