/**
 * Regions where Managed Blockchain is supported, for details see
 * https://aws.amazon.com/managed-blockchain/pricing/hyperledger/
*/
export declare const SUPPORTED_REGIONS: string[];
/**
 * Map of supported regions to their availability zones
 */
export declare const SUPPORTED_AVAILABILITY_ZONES: Record<string, Array<string>>;
/**
 * Throw an error if provided region is not in the supported list
 */
export declare function validateRegion(region: string): void;
/**
 * Throw an error if provided availability zone is not in the supported list
 */
export declare function validateAvailabilityZone(region: string, availabilityZone?: string): void;
