"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupPlan = exports.BackupPlanProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const dbs_generated_1 = require("./dbs.generated");
Object.defineProperty(exports, "BackupPlanProperty", { enumerable: true, get: function () { return dbs_generated_1.RosBackupPlan; } });
/**
 * This class encapsulates and extends the ROS resource type `DATASOURCE::DBS::BackupPlan`, which is used to query the information about a backup schedule.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosBackupPlan`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/datasource-dbs-backupplan
 */
class BackupPlan extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosBackupPlan = new dbs_generated_1.RosBackupPlan(this, id, {
            backupPlanId: props.backupPlanId,
            refreshOptions: props.refreshOptions === undefined || props.refreshOptions === null ? 'Never' : props.refreshOptions,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosBackupPlan;
        this.attrBackupGatewayId = rosBackupPlan.attrBackupGatewayId;
        this.attrBackupMethod = rosBackupPlan.attrBackupMethod;
        this.attrBackupObjects = rosBackupPlan.attrBackupObjects;
        this.attrBackupPeriod = rosBackupPlan.attrBackupPeriod;
        this.attrBackupPlanId = rosBackupPlan.attrBackupPlanId;
        this.attrBackupPlanName = rosBackupPlan.attrBackupPlanName;
        this.attrBackupRetentionPeriod = rosBackupPlan.attrBackupRetentionPeriod;
        this.attrBackupStartTime = rosBackupPlan.attrBackupStartTime;
        this.attrBackupStorageType = rosBackupPlan.attrBackupStorageType;
        this.attrCreateTime = rosBackupPlan.attrCreateTime;
        this.attrCrossAliyunId = rosBackupPlan.attrCrossAliyunId;
        this.attrCrossRoleName = rosBackupPlan.attrCrossRoleName;
        this.attrDatabaseType = rosBackupPlan.attrDatabaseType;
        this.attrDuplicationArchivePeriod = rosBackupPlan.attrDuplicationArchivePeriod;
        this.attrDuplicationInfrequentAccessPeriod = rosBackupPlan.attrDuplicationInfrequentAccessPeriod;
        this.attrEnableBackupLog = rosBackupPlan.attrEnableBackupLog;
        this.attrInstanceClass = rosBackupPlan.attrInstanceClass;
        this.attrOssBucketName = rosBackupPlan.attrOssBucketName;
        this.attrPaymentType = rosBackupPlan.attrPaymentType;
        this.attrResourceGroupId = rosBackupPlan.attrResourceGroupId;
        this.attrSourceEndpointDatabaseName = rosBackupPlan.attrSourceEndpointDatabaseName;
        this.attrSourceEndpointInstanceId = rosBackupPlan.attrSourceEndpointInstanceId;
        this.attrSourceEndpointInstanceType = rosBackupPlan.attrSourceEndpointInstanceType;
        this.attrSourceEndpointRegion = rosBackupPlan.attrSourceEndpointRegion;
        this.attrSourceEndpointSid = rosBackupPlan.attrSourceEndpointSid;
        this.attrSourceEndpointUserName = rosBackupPlan.attrSourceEndpointUserName;
    }
}
exports.BackupPlan = BackupPlan;
//# sourceMappingURL=data:application/json;base64,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