"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosRestoreTask = exports.RosDownload = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosDownloadProps`
 *
 * @param properties - the TypeScript properties of a `RosDownloadProps`
 *
 * @returns the result of the validation.
 */
function RosDownloadPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('bakSetId', ros.validateString)(properties.bakSetId));
    errors.collect(ros.propertyValidator('instanceName', ros.requiredValidator)(properties.instanceName));
    errors.collect(ros.propertyValidator('instanceName', ros.validateString)(properties.instanceName));
    errors.collect(ros.propertyValidator('downloadPointInTime', ros.validateString)(properties.downloadPointInTime));
    errors.collect(ros.propertyValidator('bakSetType', ros.validateString)(properties.bakSetType));
    errors.collect(ros.propertyValidator('bakSetSize', ros.validateString)(properties.bakSetSize));
    errors.collect(ros.propertyValidator('targetPath', ros.validateString)(properties.targetPath));
    errors.collect(ros.propertyValidator('targetType', ros.validateString)(properties.targetType));
    errors.collect(ros.propertyValidator('targetOssRegion', ros.validateString)(properties.targetOssRegion));
    errors.collect(ros.propertyValidator('deleteBackupSetInOss', ros.validateBoolean)(properties.deleteBackupSetInOss));
    errors.collect(ros.propertyValidator('targetBucket', ros.validateString)(properties.targetBucket));
    errors.collect(ros.propertyValidator('formatType', ros.requiredValidator)(properties.formatType));
    errors.collect(ros.propertyValidator('formatType', ros.validateString)(properties.formatType));
    if (properties.downloadAddressDuration && (typeof properties.downloadAddressDuration) !== 'object') {
        errors.collect(ros.propertyValidator('downloadAddressDuration', ros.validateRange)({
            data: properties.downloadAddressDuration,
            min: 300,
            max: 86400,
        }));
    }
    errors.collect(ros.propertyValidator('downloadAddressDuration', ros.validateNumber)(properties.downloadAddressDuration));
    return errors.wrap('supplied properties not correct for "RosDownloadProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DBS::Download` resource
 *
 * @param properties - the TypeScript properties of a `RosDownloadProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DBS::Download` resource.
 */
// @ts-ignore TS6133
function rosDownloadPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDownloadPropsValidator(properties).assertSuccess();
    }
    return {
        'FormatType': ros.stringToRosTemplate(properties.formatType),
        'InstanceName': ros.stringToRosTemplate(properties.instanceName),
        'BakSetId': ros.stringToRosTemplate(properties.bakSetId),
        'BakSetSize': ros.stringToRosTemplate(properties.bakSetSize),
        'BakSetType': ros.stringToRosTemplate(properties.bakSetType),
        'DeleteBackupSetInOss': ros.booleanToRosTemplate(properties.deleteBackupSetInOss),
        'DownloadAddressDuration': ros.numberToRosTemplate(properties.downloadAddressDuration),
        'DownloadPointInTime': ros.stringToRosTemplate(properties.downloadPointInTime),
        'TargetBucket': ros.stringToRosTemplate(properties.targetBucket),
        'TargetOssRegion': ros.stringToRosTemplate(properties.targetOssRegion),
        'TargetPath': ros.stringToRosTemplate(properties.targetPath),
        'TargetType': ros.stringToRosTemplate(properties.targetType),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::DBS::Download`, which is used to create an advanced download task.
 * @Note This class does not contain additional functions, so it is recommended to use the `Download` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-dbs-download
 */
class RosDownload extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDownload.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrBakSetId = this.getAtt('BakSetId');
        this.attrDownloadAddressInfo = this.getAtt('DownloadAddressInfo');
        this.attrInstanceName = this.getAtt('InstanceName');
        this.attrTaskId = this.getAtt('TaskId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.formatType = props.formatType;
        this.instanceName = props.instanceName;
        this.bakSetId = props.bakSetId;
        this.bakSetSize = props.bakSetSize;
        this.bakSetType = props.bakSetType;
        this.deleteBackupSetInOss = props.deleteBackupSetInOss;
        this.downloadAddressDuration = props.downloadAddressDuration;
        this.downloadPointInTime = props.downloadPointInTime;
        this.targetBucket = props.targetBucket;
        this.targetOssRegion = props.targetOssRegion;
        this.targetPath = props.targetPath;
        this.targetType = props.targetType;
    }
    get rosProperties() {
        return {
            formatType: this.formatType,
            instanceName: this.instanceName,
            bakSetId: this.bakSetId,
            bakSetSize: this.bakSetSize,
            bakSetType: this.bakSetType,
            deleteBackupSetInOss: this.deleteBackupSetInOss,
            downloadAddressDuration: this.downloadAddressDuration,
            downloadPointInTime: this.downloadPointInTime,
            targetBucket: this.targetBucket,
            targetOssRegion: this.targetOssRegion,
            targetPath: this.targetPath,
            targetType: this.targetType,
        };
    }
    renderProperties(props) {
        return rosDownloadPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDownload = RosDownload;
/**
 * The resource type name for this resource class.
 */
RosDownload.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DBS::Download";
/**
 * Determine whether the given properties match those of a `RosRestoreTaskProps`
 *
 * @param properties - the TypeScript properties of a `RosRestoreTaskProps`
 *
 * @returns the result of the validation.
 */
function RosRestoreTaskPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('startTask', ros.validateBoolean)(properties.startTask));
    errors.collect(ros.propertyValidator('restoreDir', ros.validateString)(properties.restoreDir));
    if (properties.duplicateConflict && (typeof properties.duplicateConflict) !== 'object') {
        errors.collect(ros.propertyValidator('duplicateConflict', ros.validateAllowedValues)({
            data: properties.duplicateConflict,
            allowedValues: ["failure", "renamenew"],
        }));
    }
    errors.collect(ros.propertyValidator('duplicateConflict', ros.validateString)(properties.duplicateConflict));
    errors.collect(ros.propertyValidator('restoreHome', ros.validateString)(properties.restoreHome));
    errors.collect(ros.propertyValidator('destinationEndpointPassword', ros.validateString)(properties.destinationEndpointPassword));
    errors.collect(ros.propertyValidator('destinationEndpointIp', ros.validateString)(properties.destinationEndpointIp));
    errors.collect(ros.propertyValidator('destinationEndpointPort', ros.validateNumber)(properties.destinationEndpointPort));
    errors.collect(ros.propertyValidator('destinationEndpointOracleSid', ros.validateString)(properties.destinationEndpointOracleSid));
    errors.collect(ros.propertyValidator('backupSetId', ros.validateString)(properties.backupSetId));
    errors.collect(ros.propertyValidator('destinationEndpointInstanceType', ros.requiredValidator)(properties.destinationEndpointInstanceType));
    errors.collect(ros.propertyValidator('destinationEndpointInstanceType', ros.validateString)(properties.destinationEndpointInstanceType));
    errors.collect(ros.propertyValidator('restoreTime', ros.validateNumber)(properties.restoreTime));
    errors.collect(ros.propertyValidator('destinationEndpointRegion', ros.validateString)(properties.destinationEndpointRegion));
    errors.collect(ros.propertyValidator('destinationEndpointDatabaseName', ros.validateString)(properties.destinationEndpointDatabaseName));
    errors.collect(ros.propertyValidator('destinationEndpointUserName', ros.validateString)(properties.destinationEndpointUserName));
    errors.collect(ros.propertyValidator('restoreObjects', ros.validateString)(properties.restoreObjects));
    errors.collect(ros.propertyValidator('restoreTaskName', ros.requiredValidator)(properties.restoreTaskName));
    errors.collect(ros.propertyValidator('restoreTaskName', ros.validateString)(properties.restoreTaskName));
    errors.collect(ros.propertyValidator('backupPlanId', ros.requiredValidator)(properties.backupPlanId));
    errors.collect(ros.propertyValidator('backupPlanId', ros.validateString)(properties.backupPlanId));
    errors.collect(ros.propertyValidator('backupGatewayId', ros.validateNumber)(properties.backupGatewayId));
    errors.collect(ros.propertyValidator('destinationEndpointInstanceId', ros.validateString)(properties.destinationEndpointInstanceId));
    return errors.wrap('supplied properties not correct for "RosRestoreTaskProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DBS::RestoreTask` resource
 *
 * @param properties - the TypeScript properties of a `RosRestoreTaskProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DBS::RestoreTask` resource.
 */
// @ts-ignore TS6133
function rosRestoreTaskPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosRestoreTaskPropsValidator(properties).assertSuccess();
    }
    return {
        'BackupPlanId': ros.stringToRosTemplate(properties.backupPlanId),
        'DestinationEndpointInstanceType': ros.stringToRosTemplate(properties.destinationEndpointInstanceType),
        'RestoreTaskName': ros.stringToRosTemplate(properties.restoreTaskName),
        'BackupGatewayId': ros.numberToRosTemplate(properties.backupGatewayId),
        'BackupSetId': ros.stringToRosTemplate(properties.backupSetId),
        'DestinationEndpointDatabaseName': ros.stringToRosTemplate(properties.destinationEndpointDatabaseName),
        'DestinationEndpointInstanceID': ros.stringToRosTemplate(properties.destinationEndpointInstanceId),
        'DestinationEndpointIP': ros.stringToRosTemplate(properties.destinationEndpointIp),
        'DestinationEndpointOracleSID': ros.stringToRosTemplate(properties.destinationEndpointOracleSid),
        'DestinationEndpointPassword': ros.stringToRosTemplate(properties.destinationEndpointPassword),
        'DestinationEndpointPort': ros.numberToRosTemplate(properties.destinationEndpointPort),
        'DestinationEndpointRegion': ros.stringToRosTemplate(properties.destinationEndpointRegion),
        'DestinationEndpointUserName': ros.stringToRosTemplate(properties.destinationEndpointUserName),
        'DuplicateConflict': ros.stringToRosTemplate(properties.duplicateConflict),
        'RestoreDir': ros.stringToRosTemplate(properties.restoreDir),
        'RestoreHome': ros.stringToRosTemplate(properties.restoreHome),
        'RestoreObjects': ros.stringToRosTemplate(properties.restoreObjects),
        'RestoreTime': ros.numberToRosTemplate(properties.restoreTime),
        'StartTask': ros.booleanToRosTemplate(properties.startTask),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::DBS::RestoreTask`, which is used to create a restoration task of Data Disaster Recovery.
 * @Note This class does not contain additional functions, so it is recommended to use the `RestoreTask` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-dbs-restoretask
 */
class RosRestoreTask extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosRestoreTask.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrRestoreTaskId = this.getAtt('RestoreTaskId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.backupPlanId = props.backupPlanId;
        this.destinationEndpointInstanceType = props.destinationEndpointInstanceType;
        this.restoreTaskName = props.restoreTaskName;
        this.backupGatewayId = props.backupGatewayId;
        this.backupSetId = props.backupSetId;
        this.destinationEndpointDatabaseName = props.destinationEndpointDatabaseName;
        this.destinationEndpointInstanceId = props.destinationEndpointInstanceId;
        this.destinationEndpointIp = props.destinationEndpointIp;
        this.destinationEndpointOracleSid = props.destinationEndpointOracleSid;
        this.destinationEndpointPassword = props.destinationEndpointPassword;
        this.destinationEndpointPort = props.destinationEndpointPort;
        this.destinationEndpointRegion = props.destinationEndpointRegion;
        this.destinationEndpointUserName = props.destinationEndpointUserName;
        this.duplicateConflict = props.duplicateConflict;
        this.restoreDir = props.restoreDir;
        this.restoreHome = props.restoreHome;
        this.restoreObjects = props.restoreObjects;
        this.restoreTime = props.restoreTime;
        this.startTask = props.startTask;
    }
    get rosProperties() {
        return {
            backupPlanId: this.backupPlanId,
            destinationEndpointInstanceType: this.destinationEndpointInstanceType,
            restoreTaskName: this.restoreTaskName,
            backupGatewayId: this.backupGatewayId,
            backupSetId: this.backupSetId,
            destinationEndpointDatabaseName: this.destinationEndpointDatabaseName,
            destinationEndpointInstanceId: this.destinationEndpointInstanceId,
            destinationEndpointIp: this.destinationEndpointIp,
            destinationEndpointOracleSid: this.destinationEndpointOracleSid,
            destinationEndpointPassword: this.destinationEndpointPassword,
            destinationEndpointPort: this.destinationEndpointPort,
            destinationEndpointRegion: this.destinationEndpointRegion,
            destinationEndpointUserName: this.destinationEndpointUserName,
            duplicateConflict: this.duplicateConflict,
            restoreDir: this.restoreDir,
            restoreHome: this.restoreHome,
            restoreObjects: this.restoreObjects,
            restoreTime: this.restoreTime,
            startTask: this.startTask,
        };
    }
    renderProperties(props) {
        return rosRestoreTaskPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosRestoreTask = RosRestoreTask;
/**
 * The resource type name for this resource class.
 */
RosRestoreTask.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DBS::RestoreTask";
//# sourceMappingURL=data:application/json;base64,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