"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Download = exports.DownloadProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const dbs_generated_1 = require("./dbs.generated");
Object.defineProperty(exports, "DownloadProperty", { enumerable: true, get: function () { return dbs_generated_1.RosDownload; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::DBS::Download`, which is used to create an advanced download task.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDownload`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-dbs-download
 */
class Download extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDownload = new dbs_generated_1.RosDownload(this, id, {
            bakSetId: props.bakSetId,
            instanceName: props.instanceName,
            downloadPointInTime: props.downloadPointInTime,
            bakSetType: props.bakSetType,
            bakSetSize: props.bakSetSize,
            targetPath: props.targetPath,
            targetType: props.targetType,
            targetOssRegion: props.targetOssRegion,
            deleteBackupSetInOss: props.deleteBackupSetInOss === undefined || props.deleteBackupSetInOss === null ? true : props.deleteBackupSetInOss,
            targetBucket: props.targetBucket,
            formatType: props.formatType,
            downloadAddressDuration: props.downloadAddressDuration === undefined || props.downloadAddressDuration === null ? 2700 : props.downloadAddressDuration,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDownload;
        this.attrBakSetId = rosDownload.attrBakSetId;
        this.attrDownloadAddressInfo = rosDownload.attrDownloadAddressInfo;
        this.attrInstanceName = rosDownload.attrInstanceName;
        this.attrTaskId = rosDownload.attrTaskId;
    }
}
exports.Download = Download;
//# sourceMappingURL=data:application/json;base64,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