# Contributing to AFQ-Browser

### How do I contribute to AFQ-Browser development?

Thank you for considering contributing to AFQ-Browser!

Improving documentation, triaging bugs, creating examples, and writing tutorials are all examples of helpful contributions that you can make

If you want to report a bug or another issue with the software, please do so by adding an issue [here](https://github.com/yeatmanlab/AFQ-Browser/issues/new). Please be sure to give us detailed information: what did you do when you ran into an issue? What operating system are you using? What browser? Tell us about the data that you are visualizing.

If you are interested in creating new features, please create an issue for discussion first. Once we've hashed it out together, go ahead and create a Pull Request (see [this post for instructions](https://egghead.io/series/how-to-contribute-to-an-open-source-project-on-github).

>For something that is bigger than a one or two line fix:

>1. Create your own fork of the code
2. Do the changes in your fork
3. If you like the change and think the project could use it:
    * Please be sure that your Python code is formatted according to [PEP8](https://www.python.org/dev/peps/pep-0008/)
    * Make sure to document functions you create. We follow the [Numpy documentation standards](https://github.com/numpy/numpy/blob/master/doc/HOWTO_DOCUMENT.rst.txt) for Python function doc-strings
    * Write tests: we use [pytest](https://docs.pytest.org/en/latest/) to test Python code. [Travis](travis-ci.org) will automatically test your code when you submit a PR.

If you have any questions about any of this, feel free to get in touch through our mailing list: automated-fiber-quantification-afq@googlegroups.com
