"""
Constants for WavespeedMCP.
"""

# Image generation default values
DEFAULT_IMAGE_SIZE = "1024*1024"
DEFAULT_NUM_INFERENCE_STEPS = 28
DEFAULT_GUIDANCE_SCALE = 3.5
DEFAULT_NUM_IMAGES = 1
DEFAULT_SEED = -1
DEFAULT_STRENGTH = 0.8
DEFAULT_IMAGE_LORA = {"path": "linoyts/yarn_art_Flux_LoRA", "scale": 1.0}

# Video generation default values
DEFAULT_VIDEO_SIZE = "832*480"
DEFAULT_VIDEO_DURATION = 5
DEFAULT_VIDEO_GUIDANCE_SCALE = 5
DEFAULT_VIDEO_FLOW_SHIFT = 3
DEFAULT_VIDEO_NUM_INFERENCE_STEPS = 30
DEFAULT_VIDEO_LORA = {"path": "Remade-AI/Deflate", "scale": 1.0}

# Environment variables
ENV_WAVESPEED_API_KEY = "WAVESPEED_API_KEY"
ENV_WAVESPEED_API_HOST = "WAVESPEED_API_HOST"
ENV_WAVESPEED_MCP_BASE_PATH = "WAVESPEED_MCP_BASE_PATH"
# Options: local, url (default)
ENV_RESOURCE_MODE = "WAVESPEED_API_RESOURCE_MODE"

# Resource modes
RESOURCE_MODE_BASE64 = "base64"  # return base64 encoded image
RESOURCE_MODE_LOCAL = "local"  # save resource to local file system
RESOURCE_MODE_URL = "url"  # provide resource url

# API endpoints
API_VERSION = "v3"
API_BASE_PATH = "/api"
API_IMAGE_ENDPOINT = "/wavespeed-ai/flux-dev"
API_IMAGE_TO_IMAGE_ENDPOINT = "/wavespeed-ai/flux-kontext-pro"
API_VIDEO_ENDPOINT = "/wavespeed-ai/wan-2.1/i2v-480p-lora"
ENV_API_TEXT_TO_IMAGE_ENDPOINT = "WAVESPEED_API_TEXT_TO_IMAGE_ENDPOINT"
ENV_API_IMAGE_TO_IMAGE_ENDPOINT = "WAVESPEED_API_IMAGE_TO_IMAGE_ENDPOINT"
ENV_API_VIDEO_ENDPOINT = "WAVESPEED_API_VIDEO_ENDPOINT"
API_PREDICTION_ENDPOINT = "/predictions"

# Logging
DEFAULT_LOG_LEVEL = "INFO"
ENV_FASTMCP_LOG_LEVEL = "WAVESPEED_LOG_LEVEL"
