"""fixed migration [7f603e583dd7].

Revision ID: 7f603e583dd7
Revises: 0.45.0
Create Date: 2023-10-13 14:47:03.477356

"""

import sqlalchemy as sa
import sqlmodel
from alembic import op
from sqlalchemy.dialects import mysql
from sqlalchemy.engine.base import Connection

# revision identifiers, used by Alembic.
revision = "7f603e583dd7"
down_revision = "0.45.0"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("pipeline_deployment", schema=None) as batch_op:
        batch_op.alter_column(
            "client_version",
            existing_type=sa.VARCHAR(length=255),
            nullable=True,
        )
        batch_op.alter_column(
            "server_version",
            existing_type=sa.VARCHAR(length=255),
            nullable=True,
        )

    bind: Connection = op.get_bind()
    column_info = sa.inspect(bind).get_columns("step_run")
    columns = [c["name"] for c in column_info]

    if "step_configuration" not in columns:
        with op.batch_alter_table("step_run", schema=None) as batch_op:
            batch_op.add_column(
                sa.Column(
                    "step_configuration",
                    sa.String(length=16777215).with_variant(
                        mysql.MEDIUMTEXT, "mysql"
                    ),
                    nullable=True,
                )
            )

    column_info = sa.inspect(bind).get_columns("pipeline_run")
    columns = [c["name"] for c in column_info]

    with op.batch_alter_table("pipeline_run", schema=None) as batch_op:
        if "pipeline_configuration" not in columns:
            batch_op.add_column(
                sa.Column("pipeline_configuration", sa.TEXT(), nullable=True)
            )
        else:
            batch_op.alter_column(
                "pipeline_configuration",
                existing_type=sa.TEXT(),
                nullable=True,
            )

        if "client_environment" not in columns:
            batch_op.add_column(
                sa.Column("client_environment", sa.TEXT(), nullable=True)
            )

        if "stack_id" not in columns:
            batch_op.add_column(
                sa.Column(
                    "stack_id", sqlmodel.sql.sqltypes.GUID(), nullable=True
                )
            )
            batch_op.create_foreign_key(
                "fk_pipeline_run_stack_id_stack",
                "stack",
                ["stack_id"],
                ["id"],
                ondelete="SET NULL",
            )

        if "build_id" not in columns:
            batch_op.add_column(
                sa.Column(
                    "build_id", sqlmodel.sql.sqltypes.GUID(), nullable=True
                )
            )
            batch_op.create_foreign_key(
                "fk_pipeline_run_build_id_pipeline_build",
                "pipeline_build",
                ["build_id"],
                ["id"],
                ondelete="SET NULL",
            )

        if "schedule_id" not in columns:
            batch_op.add_column(
                sa.Column(
                    "schedule_id", sqlmodel.sql.sqltypes.GUID(), nullable=True
                )
            )
            batch_op.create_foreign_key(
                "fk_pipeline_run_schedule_id_schedule",
                "schedule",
                ["schedule_id"],
                ["id"],
                ondelete="SET NULL",
            )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision.

    Raises:
        NotImplementedError: Downgrade is not supported for this migration.
    """
    raise NotImplementedError(
        "The downgrade migration is not implemented for this version!"
    )

    # ### end Alembic commands ###
