import { aws_events as events } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export declare enum GuardrailBehaviors {
    DETECTIVE = "DETECTIVE",
    PREVENTATIVE = "PREVENTATIVE"
}
export declare enum EventStates {
    SUCCEEDED = "SUCCEEDED",
    FAILED = "FAILED"
}
export interface BaseRuleProps {
    /**
     * A description of the rule's purpose.
     *
     * @default - A rule for new account creation in Organizations
     */
    readonly description?: string;
    /**
     * A name for the rule.
     *
     * @default - AWS CloudFormation generates a unique physical ID and uses that ID
     * for the rule name. For more information, see Name Type.
     */
    readonly ruleName?: string;
    /**
     * Indicates whether the rule is enabled.
     *
     * @default true
     */
    readonly enabled?: boolean;
    /**
     * Targets to invoke when this rule matches an event.
     *
     * @default - No targets.
     */
    readonly targets?: events.IRuleTarget[];
    /**
      * The event bus to associate with this rule.
      *
      * @default - The default event bus.
      */
    readonly eventBus?: events.IEventBus;
    /**
     * Which event state should this rule trigger for.
     *
     * @default - EventStates.SUCCEEDED
     */
    readonly eventState?: EventStates;
}
export interface AccountRuleProps extends BaseRuleProps {
    /**
     * The account ID to match.
     */
    readonly accountId?: string;
    /**
     * The account name to match.
     */
    readonly accountName?: string;
    /**
     * The OU ID to match.
     */
    readonly ouId?: string;
    /**
     * The OU name to match.
     */
    readonly ouName?: string;
}
export interface GuardrailRuleProps extends BaseRuleProps {
    /**
     * The OU ID to match.
     */
    readonly ouId?: string;
    /**
     * The OU name to match.
     */
    readonly ouName?: string;
    /**
     * The guardrail ID to match
     */
    readonly guardrailId?: string;
    /**
     * The guardrail behavior to match
     */
    readonly guardrailBehavior?: GuardrailBehaviors;
}
export interface OuRuleProps extends BaseRuleProps {
    /**
     * The OU ID to match.
     */
    readonly ouId?: string;
    /**
     * The OU name to match.
     */
    readonly ouName?: string;
}
/**
 * A rule for matching events from CloudTrail where Organizations created a new account.
 */
export declare class CreatedAccountByOrganizationsRule extends events.Rule {
    constructor(scope: Construct, id: string, props: BaseRuleProps);
}
/**
 * A rule for matching events from CloudTrail where Control Tower created a new account.
 */
export declare class CreatedAccountRule extends events.Rule {
    constructor(scope: Construct, id: string, props: OuRuleProps);
}
/**
 * A rule for matching events from CloudTrail where Control Tower updated a managed account
 */
export declare class UpdatedManagedAccountRule extends events.Rule {
    constructor(scope: Construct, id: string, props: AccountRuleProps);
}
/**
 * A rule for matching events from CloudTrail where Control Tower registered a new Organizational Unit
 */
export declare class RegisteredOrganizationalUnitRule extends events.Rule {
    constructor(scope: Construct, id: string, props: BaseRuleProps);
}
/**
 * A rule for matching events from CloudTrail where Control Tower deregistered an Organizational Unit
 */
export declare class DeregisteredOrganizationalUnitRule extends events.Rule {
    constructor(scope: Construct, id: string, props: OuRuleProps);
}
/**
 * A rule for matching events from CloudTrail where a guard rail was disabled via Control Tower for an Organizational Unit
 */
export declare class DisabledGuardrailRule extends events.Rule {
    constructor(scope: Construct, id: string, props: GuardrailRuleProps);
}
/**
 * A rule for matching events from CloudTrail where a guardrail was enabled via Control Tower for an Organizational Unit
 */
export declare class EnabledGuardrailRule extends events.Rule {
    constructor(scope: Construct, id: string, props: GuardrailRuleProps);
}
/**
 * A rule for matching events from CloudTrail where a landing zone was setup via Control Tower
 */
export declare class SetupLandingZoneRule extends events.Rule {
    constructor(scope: Construct, id: string, props: BaseRuleProps);
}
/**
 * A rule for matching events from CloudTrail where a landing zone was updated via Control Tower
 */
export declare class UpdatedLandingZoneRule extends events.Rule {
    constructor(scope: Construct, id: string, props: BaseRuleProps);
}
