"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdatedLandingZoneRule = exports.SetupLandingZoneRule = exports.EnabledGuardrailRule = exports.DisabledGuardrailRule = exports.DeregisteredOrganizationalUnitRule = exports.RegisteredOrganizationalUnitRule = exports.UpdatedManagedAccountRule = exports.CreatedAccountRule = exports.CreatedAccountByOrganizationsRule = exports.EventStates = exports.GuardrailBehaviors = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
var GuardrailBehaviors;
(function (GuardrailBehaviors) {
    GuardrailBehaviors["DETECTIVE"] = "DETECTIVE";
    GuardrailBehaviors["PREVENTATIVE"] = "PREVENTATIVE";
})(GuardrailBehaviors = exports.GuardrailBehaviors || (exports.GuardrailBehaviors = {}));
var EventStates;
(function (EventStates) {
    EventStates["SUCCEEDED"] = "SUCCEEDED";
    EventStates["FAILED"] = "FAILED";
})(EventStates = exports.EventStates || (exports.EventStates = {}));
/**
 * A rule for matching events from CloudTrail where Organizations created a new account.
 */
class CreatedAccountByOrganizationsRule extends aws_cdk_lib_1.aws_events.Rule {
    constructor(scope, id, props) {
        const eventPattern = {
            source: ['aws.organizations'],
            detailType: ['AWS Service Event via CloudTrail'],
            detail: {
                eventName: [
                    'CreateAccountResult',
                ],
                serviceEventDetails: {
                    createAccountStatus: {
                        state: [props.eventState ?? EventStates.SUCCEEDED],
                    },
                },
            },
        };
        const description = props.description ?? 'A rule for new account creation in Organizations.';
        super(scope, id, { eventPattern, description, ...props });
    }
}
exports.CreatedAccountByOrganizationsRule = CreatedAccountByOrganizationsRule;
_a = JSII_RTTI_SYMBOL_1;
CreatedAccountByOrganizationsRule[_a] = { fqn: "@renovosolutions/cdk-library-control-tower-lifecycle-events.CreatedAccountByOrganizationsRule", version: "0.1.114" };
/**
 * A rule for matching events from CloudTrail where Control Tower created a new account.
 */
class CreatedAccountRule extends aws_cdk_lib_1.aws_events.Rule {
    constructor(scope, id, props) {
        let eventPattern = {
            source: ['aws.controltower'],
            detailType: ['AWS Service Event via CloudTrail'],
            detail: {
                eventName: [
                    'CreateManagedAccount',
                ],
                serviceEventDetails: {
                    createManagedAccountStatus: {
                        state: [props.eventState ?? EventStates.SUCCEEDED],
                    },
                },
            },
        };
        if (props.ouId || props.ouName) {
            eventPattern.detail.serviceEventDetails.createManagedAccountStatus.organizationalUnit = {
                organizationalUnitName: props.ouName,
                organizationalUnitId: props.ouId,
            };
        }
        ;
        const description = props.description ?? 'A rule for new account creation in Control Tower.';
        super(scope, id, { eventPattern, description, ...props });
    }
}
exports.CreatedAccountRule = CreatedAccountRule;
_b = JSII_RTTI_SYMBOL_1;
CreatedAccountRule[_b] = { fqn: "@renovosolutions/cdk-library-control-tower-lifecycle-events.CreatedAccountRule", version: "0.1.114" };
/**
 * A rule for matching events from CloudTrail where Control Tower updated a managed account
 */
class UpdatedManagedAccountRule extends aws_cdk_lib_1.aws_events.Rule {
    constructor(scope, id, props) {
        let eventPattern = {
            source: ['aws.organizations'],
            detailType: ['AWS Service Event via CloudTrail'],
            detail: {
                eventName: [
                    'UpdateManagedAccount',
                ],
                serviceEventDetails: {
                    updateManagedAccountStatus: {
                        state: [props.eventState ?? EventStates.SUCCEEDED],
                    },
                },
            },
        };
        if (props.ouId || props.ouName) {
            eventPattern.detail.serviceEventDetails.updateManagedAccountStatus.organizationalUnit = {
                organizationalUnitName: props.ouName,
                organizationalUnitId: props.ouId,
            };
        }
        ;
        if (props.accountId || props.accountName) {
            eventPattern.detail.serviceEventDetails.updateManagedAccountStatus.account = {
                accountName: props.accountName,
                accountId: props.accountId,
            };
        }
        ;
        const description = props.description ?? 'A rule for updated accounts managed by Control Tower.';
        super(scope, id, { eventPattern, description, ...props });
    }
}
exports.UpdatedManagedAccountRule = UpdatedManagedAccountRule;
_c = JSII_RTTI_SYMBOL_1;
UpdatedManagedAccountRule[_c] = { fqn: "@renovosolutions/cdk-library-control-tower-lifecycle-events.UpdatedManagedAccountRule", version: "0.1.114" };
/**
 * A rule for matching events from CloudTrail where Control Tower registered a new Organizational Unit
 */
class RegisteredOrganizationalUnitRule extends aws_cdk_lib_1.aws_events.Rule {
    constructor(scope, id, props) {
        const eventPattern = {
            source: ['aws.organizations'],
            detailType: ['AWS Service Event via CloudTrail'],
            detail: {
                eventName: [
                    'RegisterOrganizationalUnit',
                ],
                serviceEventDetails: {
                    registerOrganizationalUnitStatus: {
                        state: [props.eventState ?? EventStates.SUCCEEDED],
                    },
                },
            },
        };
        const description = props.description ?? 'A rule for registered OUs in Control Tower.';
        super(scope, id, { eventPattern, description, ...props });
    }
}
exports.RegisteredOrganizationalUnitRule = RegisteredOrganizationalUnitRule;
_d = JSII_RTTI_SYMBOL_1;
RegisteredOrganizationalUnitRule[_d] = { fqn: "@renovosolutions/cdk-library-control-tower-lifecycle-events.RegisteredOrganizationalUnitRule", version: "0.1.114" };
/**
 * A rule for matching events from CloudTrail where Control Tower deregistered an Organizational Unit
 */
class DeregisteredOrganizationalUnitRule extends aws_cdk_lib_1.aws_events.Rule {
    constructor(scope, id, props) {
        let eventPattern = {
            source: ['aws.controltower'],
            detailType: ['AWS Service Event via CloudTrail'],
            detail: {
                eventName: [
                    'DeregisterOrganizationalUnit',
                ],
                serviceEventDetails: {
                    deregisterOrganizationalUnitStatus: {
                        state: [props.eventState ?? EventStates.SUCCEEDED],
                    },
                },
            },
        };
        if (props.ouId || props.ouName) {
            eventPattern.detail.serviceEventDetails.deregisterOrganizationalUnitStatus.organizationalUnit = {
                organizationalUnitName: props.ouName,
                organizationalUnitId: props.ouId,
            };
        }
        ;
        const description = props.description ?? 'A rule for deregistered OUs in Control Tower.';
        super(scope, id, { eventPattern, description, ...props });
    }
}
exports.DeregisteredOrganizationalUnitRule = DeregisteredOrganizationalUnitRule;
_e = JSII_RTTI_SYMBOL_1;
DeregisteredOrganizationalUnitRule[_e] = { fqn: "@renovosolutions/cdk-library-control-tower-lifecycle-events.DeregisteredOrganizationalUnitRule", version: "0.1.114" };
/**
 * A rule for matching events from CloudTrail where a guard rail was disabled via Control Tower for an Organizational Unit
 */
class DisabledGuardrailRule extends aws_cdk_lib_1.aws_events.Rule {
    constructor(scope, id, props) {
        let eventPattern = {
            source: ['aws.organizations'],
            detailType: ['AWS Service Event via CloudTrail'],
            detail: {
                eventName: [
                    'DisableGuardrail',
                ],
                serviceEventDetails: {
                    disableGuardrailStatus: {
                        state: [props.eventState ?? EventStates.SUCCEEDED],
                    },
                },
            },
        };
        if (props.ouId || props.ouName) {
            eventPattern.detail.serviceEventDetails.disableGuardrailStatus.organizationalUnits = [
                {
                    organizationalUnitName: props.ouName,
                    organizationalUnitId: props.ouId,
                },
            ];
        }
        ;
        if (props.guardrailId || props.guardrailBehavior) {
            eventPattern.detail.serviceEventDetails.disableGuardrailStatus.guardrails = [
                {
                    guardrailId: props.guardrailId,
                    guardrailBehavior: props.guardrailBehavior,
                },
            ];
        }
        ;
        const description = props.description ?? 'A rule for disabled guardrails in Control Tower.';
        super(scope, id, { eventPattern, description, ...props });
    }
}
exports.DisabledGuardrailRule = DisabledGuardrailRule;
_f = JSII_RTTI_SYMBOL_1;
DisabledGuardrailRule[_f] = { fqn: "@renovosolutions/cdk-library-control-tower-lifecycle-events.DisabledGuardrailRule", version: "0.1.114" };
/**
 * A rule for matching events from CloudTrail where a guardrail was enabled via Control Tower for an Organizational Unit
 */
class EnabledGuardrailRule extends aws_cdk_lib_1.aws_events.Rule {
    constructor(scope, id, props) {
        let eventPattern = {
            source: ['aws.organizations'],
            detailType: ['AWS Service Event via CloudTrail'],
            detail: {
                eventName: [
                    'EnableGuardrail',
                ],
                serviceEventDetails: {
                    enableGuardrailStatus: {
                        organizationalUnits: [
                            {
                                organizationalUnitName: props.ouName,
                                organizationalUnitId: props.ouId,
                            },
                        ],
                        guardrails: [
                            {
                                guardrailId: props.guardrailId,
                                guardrailBehavior: props.guardrailBehavior,
                            },
                        ],
                        state: [props.eventState ?? EventStates.SUCCEEDED],
                    },
                },
            },
        };
        if (props.ouId || props.ouName) {
            eventPattern.detail.serviceEventDetails.enableGuardrailStatus.organizationalUnits = [
                {
                    organizationalUnitName: props.ouName,
                    organizationalUnitId: props.ouId,
                },
            ];
        }
        ;
        if (props.guardrailId || props.guardrailBehavior) {
            eventPattern.detail.serviceEventDetails.enableGuardrailStatus.guardrails = [
                {
                    guardrailId: props.guardrailId,
                    guardrailBehavior: props.guardrailBehavior,
                },
            ];
        }
        ;
        const description = props.description ?? 'A rule for enabled guardrails in Control Tower.';
        super(scope, id, { eventPattern, description, ...props });
    }
}
exports.EnabledGuardrailRule = EnabledGuardrailRule;
_g = JSII_RTTI_SYMBOL_1;
EnabledGuardrailRule[_g] = { fqn: "@renovosolutions/cdk-library-control-tower-lifecycle-events.EnabledGuardrailRule", version: "0.1.114" };
/**
 * A rule for matching events from CloudTrail where a landing zone was setup via Control Tower
 */
class SetupLandingZoneRule extends aws_cdk_lib_1.aws_events.Rule {
    constructor(scope, id, props) {
        const eventPattern = {
            source: ['aws.organizations'],
            detailType: ['AWS Service Event via CloudTrail'],
            detail: {
                eventName: [
                    'SetupLandingZone',
                ],
                serviceEventDetails: {
                    setupLandingZoneStatus: {
                        state: [props.eventState ?? EventStates.SUCCEEDED],
                    },
                },
            },
        };
        const description = props.description ?? 'A rule for landing zone setup in Control Tower.';
        super(scope, id, { eventPattern, description, ...props });
    }
}
exports.SetupLandingZoneRule = SetupLandingZoneRule;
_h = JSII_RTTI_SYMBOL_1;
SetupLandingZoneRule[_h] = { fqn: "@renovosolutions/cdk-library-control-tower-lifecycle-events.SetupLandingZoneRule", version: "0.1.114" };
/**
 * A rule for matching events from CloudTrail where a landing zone was updated via Control Tower
 */
class UpdatedLandingZoneRule extends aws_cdk_lib_1.aws_events.Rule {
    constructor(scope, id, props) {
        const eventPattern = {
            source: ['aws.organizations'],
            detailType: ['AWS Service Event via CloudTrail'],
            detail: {
                eventName: [
                    'UpdateLandingZone',
                ],
                serviceEventDetails: {
                    updateLandingZoneStatus: {
                        state: [props.eventState ?? EventStates.SUCCEEDED],
                    },
                },
            },
        };
        const description = props.description ?? 'A rule for landing zone updates in Control Tower.';
        super(scope, id, { eventPattern, description, ...props });
    }
}
exports.UpdatedLandingZoneRule = UpdatedLandingZoneRule;
_j = JSII_RTTI_SYMBOL_1;
UpdatedLandingZoneRule[_j] = { fqn: "@renovosolutions/cdk-library-control-tower-lifecycle-events.UpdatedLandingZoneRule", version: "0.1.114" };
//# sourceMappingURL=data:application/json;base64,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