# -*- coding: utf-8 -*-
# File generated from our OpenAPI spec
from stripe._list_object import ListObject
from stripe._quote_preview_invoice import QuotePreviewInvoice
from stripe._request_options import RequestOptions
from stripe._stripe_service import StripeService
from stripe._util import sanitize_id
from typing import Optional, cast
from typing_extensions import TYPE_CHECKING

if TYPE_CHECKING:
    from stripe.params._quote_preview_invoice_list_params import (
        QuotePreviewInvoiceListParams,
    )


class QuotePreviewInvoiceService(StripeService):
    def list(
        self,
        quote: str,
        params: Optional["QuotePreviewInvoiceListParams"] = None,
        options: Optional[RequestOptions] = None,
    ) -> ListObject[QuotePreviewInvoice]:
        """
        Preview the invoices that would be generated by accepting the quote.
        """
        return cast(
            ListObject[QuotePreviewInvoice],
            self._request(
                "get",
                "/v1/quotes/{quote}/preview_invoices".format(
                    quote=sanitize_id(quote),
                ),
                base_address="api",
                params=params,
                options=options,
            ),
        )

    async def list_async(
        self,
        quote: str,
        params: Optional["QuotePreviewInvoiceListParams"] = None,
        options: Optional[RequestOptions] = None,
    ) -> ListObject[QuotePreviewInvoice]:
        """
        Preview the invoices that would be generated by accepting the quote.
        """
        return cast(
            ListObject[QuotePreviewInvoice],
            await self._request_async(
                "get",
                "/v1/quotes/{quote}/preview_invoices".format(
                    quote=sanitize_id(quote),
                ),
                base_address="api",
                params=params,
                options=options,
            ),
        )
