# -*- coding: utf-8 -*-
# File generated from our OpenAPI spec
from stripe._list_object import ListObject
from stripe._quote_preview_subscription_schedule import (
    QuotePreviewSubscriptionSchedule,
)
from stripe._request_options import RequestOptions
from stripe._stripe_service import StripeService
from stripe._util import sanitize_id
from typing import Optional, cast
from typing_extensions import TYPE_CHECKING

if TYPE_CHECKING:
    from stripe.params._quote_preview_subscription_schedule_list_params import (
        QuotePreviewSubscriptionScheduleListParams,
    )


class QuotePreviewSubscriptionScheduleService(StripeService):
    def list(
        self,
        quote: str,
        params: Optional["QuotePreviewSubscriptionScheduleListParams"] = None,
        options: Optional[RequestOptions] = None,
    ) -> ListObject[QuotePreviewSubscriptionSchedule]:
        """
        Preview the schedules that would be generated by accepting the quote
        """
        return cast(
            ListObject[QuotePreviewSubscriptionSchedule],
            self._request(
                "get",
                "/v1/quotes/{quote}/preview_subscription_schedules".format(
                    quote=sanitize_id(quote),
                ),
                base_address="api",
                params=params,
                options=options,
            ),
        )

    async def list_async(
        self,
        quote: str,
        params: Optional["QuotePreviewSubscriptionScheduleListParams"] = None,
        options: Optional[RequestOptions] = None,
    ) -> ListObject[QuotePreviewSubscriptionSchedule]:
        """
        Preview the schedules that would be generated by accepting the quote
        """
        return cast(
            ListObject[QuotePreviewSubscriptionSchedule],
            await self._request_async(
                "get",
                "/v1/quotes/{quote}/preview_subscription_schedules".format(
                    quote=sanitize_id(quote),
                ),
                base_address="api",
                params=params,
                options=options,
            ),
        )
