# -*- coding: utf-8 -*-
# File generated from our OpenAPI spec
from stripe._request_options import RequestOptions
from typing import Dict, List
from typing_extensions import Literal, NotRequired, TypedDict


class SubscriptionCreateParams(RequestOptions):
    add_invoice_items: NotRequired[
        List["SubscriptionCreateParamsAddInvoiceItem"]
    ]
    """
    A list of prices and quantities that will generate invoice items appended to the next invoice for this subscription. You may pass up to 20 items.
    """
    application_fee_percent: NotRequired["Literal['']|float"]
    """
    A non-negative decimal between 0 and 100, with at most two decimal places. This represents the percentage of the subscription invoice total that will be transferred to the application owner's Stripe account. The request must be made by a platform account on a connected account in order to set an application fee percentage. For more information, see the application fees [documentation](https://stripe.com/docs/connect/subscriptions#collecting-fees-on-subscriptions).
    """
    automatic_tax: NotRequired["SubscriptionCreateParamsAutomaticTax"]
    """
    Automatic tax settings for this subscription.
    """
    backdate_start_date: NotRequired[int]
    """
    A past timestamp to backdate the subscription's start date to. If set, the first invoice will contain line items for the timespan between the start date and the current time. Can be combined with trials and the billing cycle anchor.
    """
    billing_cadence: NotRequired[str]
    """
    The Billing Cadence which controls the timing of recurring invoice generation for this subscription. If unset, the subscription will bill according to its own configured schedule and create its own invoices. If set, this subscription will be billed by the cadence instead, potentially sharing invoices with the other subscriptions linked to that Cadence.
    """
    billing_cycle_anchor: NotRequired[int]
    """
    A future timestamp in UTC format to anchor the subscription's [billing cycle](https://stripe.com/docs/subscriptions/billing-cycle). The anchor is the reference point that aligns future billing cycle dates. It sets the day of week for `week` intervals, the day of month for `month` and `year` intervals, and the month of year for `year` intervals.
    """
    billing_cycle_anchor_config: NotRequired[
        "SubscriptionCreateParamsBillingCycleAnchorConfig"
    ]
    """
    Mutually exclusive with billing_cycle_anchor and only valid with monthly and yearly price intervals. When provided, the billing_cycle_anchor is set to the next occurrence of the day_of_month at the hour, minute, and second UTC.
    """
    billing_mode: NotRequired["SubscriptionCreateParamsBillingMode"]
    """
    Controls how prorations and invoices for subscriptions are calculated and orchestrated.
    """
    billing_schedules: NotRequired[
        List["SubscriptionCreateParamsBillingSchedule"]
    ]
    """
    Sets the billing schedules for the subscription.
    """
    billing_thresholds: NotRequired[
        "Literal['']|SubscriptionCreateParamsBillingThresholds"
    ]
    """
    Define thresholds at which an invoice will be sent, and the subscription advanced to a new billing period. When updating, pass an empty string to remove previously-defined thresholds.
    """
    cancel_at: NotRequired["int|Literal['max_period_end', 'min_period_end']"]
    """
    A timestamp at which the subscription should cancel. If set to a date before the current period ends, this will cause a proration if prorations have been enabled using `proration_behavior`. If set during a future period, this will always cause a proration for that period.
    """
    cancel_at_period_end: NotRequired[bool]
    """
    Indicate whether this subscription should cancel at the end of the current period (`current_period_end`). Defaults to `false`.
    """
    collection_method: NotRequired[
        Literal["charge_automatically", "send_invoice"]
    ]
    """
    Either `charge_automatically`, or `send_invoice`. When charging automatically, Stripe will attempt to pay this subscription at the end of the cycle using the default source attached to the customer. When sending an invoice, Stripe will email your customer an invoice with payment instructions and mark the subscription as `active`. Defaults to `charge_automatically`.
    """
    currency: NotRequired[str]
    """
    Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
    """
    customer: NotRequired[str]
    """
    The identifier of the customer to subscribe.
    """
    customer_account: NotRequired[str]
    """
    The identifier of the account to subscribe.
    """
    days_until_due: NotRequired[int]
    """
    Number of days a customer has to pay invoices generated by this subscription. Valid only for subscriptions where `collection_method` is set to `send_invoice`.
    """
    default_payment_method: NotRequired[str]
    """
    ID of the default payment method for the subscription. It must belong to the customer associated with the subscription. This takes precedence over `default_source`. If neither are set, invoices will use the customer's [invoice_settings.default_payment_method](https://stripe.com/docs/api/customers/object#customer_object-invoice_settings-default_payment_method) or [default_source](https://stripe.com/docs/api/customers/object#customer_object-default_source).
    """
    default_source: NotRequired[str]
    """
    ID of the default payment source for the subscription. It must belong to the customer associated with the subscription and be in a chargeable state. If `default_payment_method` is also set, `default_payment_method` will take precedence. If neither are set, invoices will use the customer's [invoice_settings.default_payment_method](https://stripe.com/docs/api/customers/object#customer_object-invoice_settings-default_payment_method) or [default_source](https://stripe.com/docs/api/customers/object#customer_object-default_source).
    """
    default_tax_rates: NotRequired["Literal['']|List[str]"]
    """
    The tax rates that will apply to any subscription item that does not have `tax_rates` set. Invoices created will have their `default_tax_rates` populated from the subscription.
    """
    description: NotRequired[str]
    """
    The subscription's description, meant to be displayable to the customer. Use this field to optionally store an explanation of the subscription for rendering in Stripe surfaces and certain local payment methods UIs.
    """
    discounts: NotRequired[
        "Literal['']|List[SubscriptionCreateParamsDiscount]"
    ]
    """
    The coupons to redeem into discounts for the subscription. If not specified or empty, inherits the discount from the subscription's customer.
    """
    expand: NotRequired[List[str]]
    """
    Specifies which fields in the response should be expanded.
    """
    invoice_settings: NotRequired["SubscriptionCreateParamsInvoiceSettings"]
    """
    All invoices will be billed using the specified settings.
    """
    items: NotRequired[List["SubscriptionCreateParamsItem"]]
    """
    A list of up to 20 subscription items, each with an attached price.
    """
    metadata: NotRequired["Literal['']|Dict[str, str]"]
    """
    Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format. Individual keys can be unset by posting an empty value to them. All keys can be unset by posting an empty value to `metadata`.
    """
    off_session: NotRequired[bool]
    """
    Indicates if a customer is on or off-session while an invoice payment is attempted. Defaults to `false` (on-session).
    """
    on_behalf_of: NotRequired["Literal['']|str"]
    """
    The account on behalf of which to charge, for each of the subscription's invoices.
    """
    payment_behavior: NotRequired[
        Literal[
            "allow_incomplete",
            "default_incomplete",
            "error_if_incomplete",
            "pending_if_incomplete",
        ]
    ]
    """
    Only applies to subscriptions with `collection_method=charge_automatically`.

    Use `allow_incomplete` to create Subscriptions with `status=incomplete` if the first invoice can't be paid. Creating Subscriptions with this status allows you to manage scenarios where additional customer actions are needed to pay a subscription's invoice. For example, SCA regulation may require 3DS authentication to complete payment. See the [SCA Migration Guide](https://stripe.com/docs/billing/migration/strong-customer-authentication) for Billing to learn more. This is the default behavior.

    Use `default_incomplete` to create Subscriptions with `status=incomplete` when the first invoice requires payment, otherwise start as active. Subscriptions transition to `status=active` when successfully confirming the PaymentIntent on the first invoice. This allows simpler management of scenarios where additional customer actions are needed to pay a subscription's invoice, such as failed payments, [SCA regulation](https://stripe.com/docs/billing/migration/strong-customer-authentication), or collecting a mandate for a bank debit payment method. If the PaymentIntent is not confirmed within 23 hours Subscriptions transition to `status=incomplete_expired`, which is a terminal state.

    Use `error_if_incomplete` if you want Stripe to return an HTTP 402 status code if a subscription's first invoice can't be paid. For example, if a payment method requires 3DS authentication due to SCA regulation and further customer action is needed, this parameter doesn't create a Subscription and returns an error instead. This was the default behavior for API versions prior to 2019-03-14. See the [changelog](https://stripe.com/docs/upgrades#2019-03-14) to learn more.

    `pending_if_incomplete` is only used with updates and cannot be passed when creating a Subscription.

    Subscriptions with `collection_method=send_invoice` are automatically activated regardless of the first Invoice status.
    """
    payment_settings: NotRequired["SubscriptionCreateParamsPaymentSettings"]
    """
    Payment settings to pass to invoices created by the subscription.
    """
    pending_invoice_item_interval: NotRequired[
        "Literal['']|SubscriptionCreateParamsPendingInvoiceItemInterval"
    ]
    """
    Specifies an interval for how often to bill for any pending invoice items. It is analogous to calling [Create an invoice](https://stripe.com/docs/api#create_invoice) for the given subscription at the specified interval.
    """
    prebilling: NotRequired["SubscriptionCreateParamsPrebilling"]
    """
    If specified, the invoicing for the given billing cycle iterations will be processed now.
    """
    proration_behavior: NotRequired[
        Literal["always_invoice", "create_prorations", "none"]
    ]
    """
    Determines how to handle [prorations](https://stripe.com/docs/billing/subscriptions/prorations) resulting from the `billing_cycle_anchor`. If no value is passed, the default is `create_prorations`.
    """
    transfer_data: NotRequired["SubscriptionCreateParamsTransferData"]
    """
    If specified, the funds from the subscription's invoices will be transferred to the destination and the ID of the resulting transfers will be found on the resulting charges.
    """
    trial_end: NotRequired["Literal['now']|int"]
    """
    Unix timestamp representing the end of the trial period the customer will get before being charged for the first time. If set, trial_end will override the default trial period of the plan the customer is being subscribed to. The special value `now` can be provided to end the customer's trial immediately. Can be at most two years from `billing_cycle_anchor`. See [Using trial periods on subscriptions](https://stripe.com/docs/billing/subscriptions/trials) to learn more.
    """
    trial_from_plan: NotRequired[bool]
    """
    Indicates if a plan's `trial_period_days` should be applied to the subscription. Setting `trial_end` per subscription is preferred, and this defaults to `false`. Setting this flag to `true` together with `trial_end` is not allowed. See [Using trial periods on subscriptions](https://stripe.com/docs/billing/subscriptions/trials) to learn more.
    """
    trial_period_days: NotRequired[int]
    """
    Integer representing the number of trial period days before the customer is charged for the first time. This will always overwrite any trials that might apply via a subscribed plan. See [Using trial periods on subscriptions](https://stripe.com/docs/billing/subscriptions/trials) to learn more.
    """
    trial_settings: NotRequired["SubscriptionCreateParamsTrialSettings"]
    """
    Settings related to subscription trials.
    """


class SubscriptionCreateParamsAddInvoiceItem(TypedDict):
    discounts: NotRequired[
        List["SubscriptionCreateParamsAddInvoiceItemDiscount"]
    ]
    """
    The coupons to redeem into discounts for the item.
    """
    metadata: NotRequired[Dict[str, str]]
    """
    Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format. Individual keys can be unset by posting an empty value to them. All keys can be unset by posting an empty value to `metadata`.
    """
    period: NotRequired["SubscriptionCreateParamsAddInvoiceItemPeriod"]
    """
    The period associated with this invoice item. If not set, `period.start.type` defaults to `max_item_period_start` and `period.end.type` defaults to `min_item_period_end`.
    """
    price: NotRequired[str]
    """
    The ID of the price object. One of `price` or `price_data` is required.
    """
    price_data: NotRequired["SubscriptionCreateParamsAddInvoiceItemPriceData"]
    """
    Data used to generate a new [Price](https://stripe.com/docs/api/prices) object inline. One of `price` or `price_data` is required.
    """
    quantity: NotRequired[int]
    """
    Quantity for this item. Defaults to 1.
    """
    tax_rates: NotRequired["Literal['']|List[str]"]
    """
    The tax rates which apply to the item. When set, the `default_tax_rates` do not apply to this item.
    """


class SubscriptionCreateParamsAddInvoiceItemDiscount(TypedDict):
    coupon: NotRequired[str]
    """
    ID of the coupon to create a new discount for.
    """
    discount: NotRequired[str]
    """
    ID of an existing discount on the object (or one of its ancestors) to reuse.
    """
    discount_end: NotRequired[
        "SubscriptionCreateParamsAddInvoiceItemDiscountDiscountEnd"
    ]
    """
    Details to determine how long the discount should be applied for.
    """
    promotion_code: NotRequired[str]
    """
    ID of the promotion code to create a new discount for.
    """


class SubscriptionCreateParamsAddInvoiceItemDiscountDiscountEnd(TypedDict):
    duration: NotRequired[
        "SubscriptionCreateParamsAddInvoiceItemDiscountDiscountEndDuration"
    ]
    """
    Time span for the redeemed discount.
    """
    timestamp: NotRequired[int]
    """
    A precise Unix timestamp for the discount to end. Must be in the future.
    """
    type: Literal["duration", "timestamp"]
    """
    The type of calculation made to determine when the discount ends.
    """


class SubscriptionCreateParamsAddInvoiceItemDiscountDiscountEndDuration(
    TypedDict,
):
    interval: Literal["day", "month", "week", "year"]
    """
    Specifies a type of interval unit. Either `day`, `week`, `month` or `year`.
    """
    interval_count: int
    """
    The number of intervals, as an whole number greater than 0. Stripe multiplies this by the interval type to get the overall duration.
    """


class SubscriptionCreateParamsAddInvoiceItemPeriod(TypedDict):
    end: "SubscriptionCreateParamsAddInvoiceItemPeriodEnd"
    """
    End of the invoice item period.
    """
    start: "SubscriptionCreateParamsAddInvoiceItemPeriodStart"
    """
    Start of the invoice item period.
    """


class SubscriptionCreateParamsAddInvoiceItemPeriodEnd(TypedDict):
    timestamp: NotRequired[int]
    """
    A precise Unix timestamp for the end of the invoice item period. Must be greater than or equal to `period.start`.
    """
    type: Literal["min_item_period_end", "timestamp"]
    """
    Select how to calculate the end of the invoice item period.
    """


class SubscriptionCreateParamsAddInvoiceItemPeriodStart(TypedDict):
    timestamp: NotRequired[int]
    """
    A precise Unix timestamp for the start of the invoice item period. Must be less than or equal to `period.end`.
    """
    type: Literal["max_item_period_start", "now", "timestamp"]
    """
    Select how to calculate the start of the invoice item period.
    """


class SubscriptionCreateParamsAddInvoiceItemPriceData(TypedDict):
    currency: str
    """
    Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
    """
    product: str
    """
    The ID of the [Product](https://docs.stripe.com/api/products) that this [Price](https://docs.stripe.com/api/prices) will belong to.
    """
    tax_behavior: NotRequired[Literal["exclusive", "inclusive", "unspecified"]]
    """
    Only required if a [default tax behavior](https://stripe.com/docs/tax/products-prices-tax-categories-tax-behavior#setting-a-default-tax-behavior-(recommended)) was not provided in the Stripe Tax settings. Specifies whether the price is considered inclusive of taxes or exclusive of taxes. One of `inclusive`, `exclusive`, or `unspecified`. Once specified as either `inclusive` or `exclusive`, it cannot be changed.
    """
    unit_amount: NotRequired[int]
    """
    A positive integer in cents (or local equivalent) (or 0 for a free price) representing how much to charge or a negative integer representing the amount to credit to the customer.
    """
    unit_amount_decimal: NotRequired[str]
    """
    Same as `unit_amount`, but accepts a decimal value in cents (or local equivalent) with at most 12 decimal places. Only one of `unit_amount` and `unit_amount_decimal` can be set.
    """


class SubscriptionCreateParamsAutomaticTax(TypedDict):
    enabled: bool
    """
    Enabled automatic tax calculation which will automatically compute tax rates on all invoices generated by the subscription.
    """
    liability: NotRequired["SubscriptionCreateParamsAutomaticTaxLiability"]
    """
    The account that's liable for tax. If set, the business address and tax registrations required to perform the tax calculation are loaded from this account. The tax transaction is returned in the report of the connected account.
    """


class SubscriptionCreateParamsAutomaticTaxLiability(TypedDict):
    account: NotRequired[str]
    """
    The connected account being referenced when `type` is `account`.
    """
    type: Literal["account", "self"]
    """
    Type of the account referenced in the request.
    """


class SubscriptionCreateParamsBillingCycleAnchorConfig(TypedDict):
    day_of_month: int
    """
    The day of the month the anchor should be. Ranges from 1 to 31.
    """
    hour: NotRequired[int]
    """
    The hour of the day the anchor should be. Ranges from 0 to 23.
    """
    minute: NotRequired[int]
    """
    The minute of the hour the anchor should be. Ranges from 0 to 59.
    """
    month: NotRequired[int]
    """
    The month to start full cycle periods. Ranges from 1 to 12.
    """
    second: NotRequired[int]
    """
    The second of the minute the anchor should be. Ranges from 0 to 59.
    """


class SubscriptionCreateParamsBillingMode(TypedDict):
    flexible: NotRequired["SubscriptionCreateParamsBillingModeFlexible"]
    """
    Configure behavior for flexible billing mode.
    """
    type: Literal["classic", "flexible"]
    """
    Controls the calculation and orchestration of prorations and invoices for subscriptions. If no value is passed, the default is `flexible`.
    """


class SubscriptionCreateParamsBillingModeFlexible(TypedDict):
    proration_discounts: NotRequired[Literal["included", "itemized"]]
    """
    Controls how invoices and invoice items display proration amounts and discount amounts.
    """


class SubscriptionCreateParamsBillingSchedule(TypedDict):
    applies_to: NotRequired[
        List["SubscriptionCreateParamsBillingScheduleAppliesTo"]
    ]
    """
    Configure billing schedule differently for individual subscription items.
    """
    bill_until: "SubscriptionCreateParamsBillingScheduleBillUntil"
    """
    The end date for the billing schedule.
    """
    key: NotRequired[str]
    """
    Specify a key for the billing schedule. Must be unique to this field, alphanumeric, and up to 200 characters. If not provided, a unique key will be generated.
    """


class SubscriptionCreateParamsBillingScheduleAppliesTo(TypedDict):
    price: NotRequired[str]
    """
    The ID of the price object.
    """
    type: Literal["price"]
    """
    Controls which subscription items the billing schedule applies to.
    """


class SubscriptionCreateParamsBillingScheduleBillUntil(TypedDict):
    duration: NotRequired[
        "SubscriptionCreateParamsBillingScheduleBillUntilDuration"
    ]
    """
    Specifies the billing period.
    """
    timestamp: NotRequired[int]
    """
    The end date of the billing schedule.
    """
    type: Literal["duration", "timestamp"]
    """
    Describes how the billing schedule will determine the end date. Either `duration` or `timestamp`.
    """


class SubscriptionCreateParamsBillingScheduleBillUntilDuration(TypedDict):
    interval: Literal["day", "month", "week", "year"]
    """
    Specifies billing duration. Either `day`, `week`, `month` or `year`.
    """
    interval_count: NotRequired[int]
    """
    The multiplier applied to the interval.
    """


class SubscriptionCreateParamsBillingThresholds(TypedDict):
    amount_gte: NotRequired[int]
    """
    Monetary threshold that triggers the subscription to advance to a new billing period
    """
    reset_billing_cycle_anchor: NotRequired[bool]
    """
    Indicates if the `billing_cycle_anchor` should be reset when a threshold is reached. If true, `billing_cycle_anchor` will be updated to the date/time the threshold was last reached; otherwise, the value will remain unchanged.
    """


class SubscriptionCreateParamsDiscount(TypedDict):
    coupon: NotRequired[str]
    """
    ID of the coupon to create a new discount for.
    """
    discount: NotRequired[str]
    """
    ID of an existing discount on the object (or one of its ancestors) to reuse.
    """
    discount_end: NotRequired["SubscriptionCreateParamsDiscountDiscountEnd"]
    """
    Details to determine how long the discount should be applied for.
    """
    promotion_code: NotRequired[str]
    """
    ID of the promotion code to create a new discount for.
    """


class SubscriptionCreateParamsDiscountDiscountEnd(TypedDict):
    duration: NotRequired[
        "SubscriptionCreateParamsDiscountDiscountEndDuration"
    ]
    """
    Time span for the redeemed discount.
    """
    timestamp: NotRequired[int]
    """
    A precise Unix timestamp for the discount to end. Must be in the future.
    """
    type: Literal["duration", "timestamp"]
    """
    The type of calculation made to determine when the discount ends.
    """


class SubscriptionCreateParamsDiscountDiscountEndDuration(TypedDict):
    interval: Literal["day", "month", "week", "year"]
    """
    Specifies a type of interval unit. Either `day`, `week`, `month` or `year`.
    """
    interval_count: int
    """
    The number of intervals, as an whole number greater than 0. Stripe multiplies this by the interval type to get the overall duration.
    """


class SubscriptionCreateParamsInvoiceSettings(TypedDict):
    account_tax_ids: NotRequired["Literal['']|List[str]"]
    """
    The account tax IDs associated with the subscription. Will be set on invoices generated by the subscription.
    """
    issuer: NotRequired["SubscriptionCreateParamsInvoiceSettingsIssuer"]
    """
    The connected account that issues the invoice. The invoice is presented with the branding and support information of the specified account.
    """


class SubscriptionCreateParamsInvoiceSettingsIssuer(TypedDict):
    account: NotRequired[str]
    """
    The connected account being referenced when `type` is `account`.
    """
    type: Literal["account", "self"]
    """
    Type of the account referenced in the request.
    """


class SubscriptionCreateParamsItem(TypedDict):
    billing_thresholds: NotRequired[
        "Literal['']|SubscriptionCreateParamsItemBillingThresholds"
    ]
    """
    Define thresholds at which an invoice will be sent, and the subscription advanced to a new billing period. Pass an empty string to remove previously-defined thresholds.
    """
    discounts: NotRequired[
        "Literal['']|List[SubscriptionCreateParamsItemDiscount]"
    ]
    """
    The coupons to redeem into discounts for the subscription item.
    """
    metadata: NotRequired[Dict[str, str]]
    """
    Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format. Individual keys can be unset by posting an empty value to them. All keys can be unset by posting an empty value to `metadata`.
    """
    plan: NotRequired[str]
    """
    Plan ID for this item, as a string.
    """
    price: NotRequired[str]
    """
    The ID of the price object.
    """
    price_data: NotRequired["SubscriptionCreateParamsItemPriceData"]
    """
    Data used to generate a new [Price](https://stripe.com/docs/api/prices) object inline.
    """
    quantity: NotRequired[int]
    """
    Quantity for this item.
    """
    tax_rates: NotRequired["Literal['']|List[str]"]
    """
    A list of [Tax Rate](https://stripe.com/docs/api/tax_rates) ids. These Tax Rates will override the [`default_tax_rates`](https://stripe.com/docs/api/subscriptions/create#create_subscription-default_tax_rates) on the Subscription. When updating, pass an empty string to remove previously-defined tax rates.
    """
    trial: NotRequired["SubscriptionCreateParamsItemTrial"]
    """
    Define options to configure the trial on the subscription item.
    """


class SubscriptionCreateParamsItemBillingThresholds(TypedDict):
    usage_gte: int
    """
    Number of units that meets the billing threshold to advance the subscription to a new billing period (e.g., it takes 10 $5 units to meet a $50 [monetary threshold](https://stripe.com/docs/api/subscriptions/update#update_subscription-billing_thresholds-amount_gte))
    """


class SubscriptionCreateParamsItemDiscount(TypedDict):
    coupon: NotRequired[str]
    """
    ID of the coupon to create a new discount for.
    """
    discount: NotRequired[str]
    """
    ID of an existing discount on the object (or one of its ancestors) to reuse.
    """
    discount_end: NotRequired[
        "SubscriptionCreateParamsItemDiscountDiscountEnd"
    ]
    """
    Details to determine how long the discount should be applied for.
    """
    promotion_code: NotRequired[str]
    """
    ID of the promotion code to create a new discount for.
    """


class SubscriptionCreateParamsItemDiscountDiscountEnd(TypedDict):
    duration: NotRequired[
        "SubscriptionCreateParamsItemDiscountDiscountEndDuration"
    ]
    """
    Time span for the redeemed discount.
    """
    timestamp: NotRequired[int]
    """
    A precise Unix timestamp for the discount to end. Must be in the future.
    """
    type: Literal["duration", "timestamp"]
    """
    The type of calculation made to determine when the discount ends.
    """


class SubscriptionCreateParamsItemDiscountDiscountEndDuration(TypedDict):
    interval: Literal["day", "month", "week", "year"]
    """
    Specifies a type of interval unit. Either `day`, `week`, `month` or `year`.
    """
    interval_count: int
    """
    The number of intervals, as an whole number greater than 0. Stripe multiplies this by the interval type to get the overall duration.
    """


class SubscriptionCreateParamsItemPriceData(TypedDict):
    currency: str
    """
    Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
    """
    product: str
    """
    The ID of the [Product](https://docs.stripe.com/api/products) that this [Price](https://docs.stripe.com/api/prices) will belong to.
    """
    recurring: "SubscriptionCreateParamsItemPriceDataRecurring"
    """
    The recurring components of a price such as `interval` and `interval_count`.
    """
    tax_behavior: NotRequired[Literal["exclusive", "inclusive", "unspecified"]]
    """
    Only required if a [default tax behavior](https://stripe.com/docs/tax/products-prices-tax-categories-tax-behavior#setting-a-default-tax-behavior-(recommended)) was not provided in the Stripe Tax settings. Specifies whether the price is considered inclusive of taxes or exclusive of taxes. One of `inclusive`, `exclusive`, or `unspecified`. Once specified as either `inclusive` or `exclusive`, it cannot be changed.
    """
    unit_amount: NotRequired[int]
    """
    A positive integer in cents (or local equivalent) (or 0 for a free price) representing how much to charge.
    """
    unit_amount_decimal: NotRequired[str]
    """
    Same as `unit_amount`, but accepts a decimal value in cents (or local equivalent) with at most 12 decimal places. Only one of `unit_amount` and `unit_amount_decimal` can be set.
    """


class SubscriptionCreateParamsItemPriceDataRecurring(TypedDict):
    interval: Literal["day", "month", "week", "year"]
    """
    Specifies billing frequency. Either `day`, `week`, `month` or `year`.
    """
    interval_count: NotRequired[int]
    """
    The number of intervals between subscription billings. For example, `interval=month` and `interval_count=3` bills every 3 months. Maximum of three years interval allowed (3 years, 36 months, or 156 weeks).
    """


class SubscriptionCreateParamsItemTrial(TypedDict):
    converts_to: NotRequired[List[str]]
    """
    List of price IDs which, if present on the subscription following a paid trial, constitute opting-in to the paid trial. Currently only supports at most 1 price ID.
    """
    type: Literal["free", "paid"]
    """
    Determines the type of trial for this item.
    """


class SubscriptionCreateParamsPaymentSettings(TypedDict):
    payment_method_options: NotRequired[
        "SubscriptionCreateParamsPaymentSettingsPaymentMethodOptions"
    ]
    """
    Payment-method-specific configuration to provide to invoices created by the subscription.
    """
    payment_method_types: NotRequired[
        "Literal['']|List[Literal['ach_credit_transfer', 'ach_debit', 'acss_debit', 'affirm', 'amazon_pay', 'au_becs_debit', 'bacs_debit', 'bancontact', 'boleto', 'card', 'cashapp', 'crypto', 'custom', 'customer_balance', 'eps', 'fpx', 'giropay', 'grabpay', 'id_bank_transfer', 'ideal', 'jp_credit_transfer', 'kakao_pay', 'klarna', 'konbini', 'kr_card', 'link', 'multibanco', 'naver_pay', 'nz_bank_account', 'p24', 'payco', 'paynow', 'paypal', 'pix', 'promptpay', 'revolut_pay', 'sepa_credit_transfer', 'sepa_debit', 'sofort', 'stripe_balance', 'swish', 'upi', 'us_bank_account', 'wechat_pay']]"
    ]
    """
    The list of payment method types (e.g. card) to provide to the invoice's PaymentIntent. If not set, Stripe attempts to automatically determine the types to use by looking at the invoice's default payment method, the subscription's default payment method, the customer's default payment method, and your [invoice template settings](https://dashboard.stripe.com/settings/billing/invoice). Should not be specified with payment_method_configuration
    """
    save_default_payment_method: NotRequired[Literal["off", "on_subscription"]]
    """
    Configure whether Stripe updates `subscription.default_payment_method` when payment succeeds. Defaults to `off` if unspecified.
    """


class SubscriptionCreateParamsPaymentSettingsPaymentMethodOptions(TypedDict):
    acss_debit: NotRequired[
        "Literal['']|SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsAcssDebit"
    ]
    """
    This sub-hash contains details about the Canadian pre-authorized debit payment method options to pass to the invoice's PaymentIntent.
    """
    bancontact: NotRequired[
        "Literal['']|SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsBancontact"
    ]
    """
    This sub-hash contains details about the Bancontact payment method options to pass to the invoice's PaymentIntent.
    """
    card: NotRequired[
        "Literal['']|SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsCard"
    ]
    """
    This sub-hash contains details about the Card payment method options to pass to the invoice's PaymentIntent.
    """
    customer_balance: NotRequired[
        "Literal['']|SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsCustomerBalance"
    ]
    """
    This sub-hash contains details about the Bank transfer payment method options to pass to the invoice's PaymentIntent.
    """
    id_bank_transfer: NotRequired[
        "Literal['']|SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsIdBankTransfer"
    ]
    """
    This sub-hash contains details about the Indonesia bank transfer payment method options to pass to the invoice's PaymentIntent.
    """
    konbini: NotRequired[
        "Literal['']|SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsKonbini"
    ]
    """
    This sub-hash contains details about the Konbini payment method options to pass to the invoice's PaymentIntent.
    """
    pix: NotRequired[
        "Literal['']|SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsPix"
    ]
    """
    This sub-hash contains details about the Pix payment method options to pass to the invoice's PaymentIntent.
    """
    sepa_debit: NotRequired[
        "Literal['']|SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsSepaDebit"
    ]
    """
    This sub-hash contains details about the SEPA Direct Debit payment method options to pass to the invoice's PaymentIntent.
    """
    upi: NotRequired[
        "Literal['']|SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsUpi"
    ]
    """
    This sub-hash contains details about the UPI payment method options to pass to the invoice's PaymentIntent.
    """
    us_bank_account: NotRequired[
        "Literal['']|SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsUsBankAccount"
    ]
    """
    This sub-hash contains details about the ACH direct debit payment method options to pass to the invoice's PaymentIntent.
    """


class SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsAcssDebit(
    TypedDict,
):
    mandate_options: NotRequired[
        "SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsAcssDebitMandateOptions"
    ]
    """
    Additional fields for Mandate creation
    """
    verification_method: NotRequired[
        Literal["automatic", "instant", "microdeposits"]
    ]
    """
    Verification method for the intent
    """


class SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsAcssDebitMandateOptions(
    TypedDict,
):
    transaction_type: NotRequired[Literal["business", "personal"]]
    """
    Transaction type of the mandate.
    """


class SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsBancontact(
    TypedDict,
):
    preferred_language: NotRequired[Literal["de", "en", "fr", "nl"]]
    """
    Preferred language of the Bancontact authorization page that the customer is redirected to.
    """


class SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsCard(
    TypedDict,
):
    mandate_options: NotRequired[
        "SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsCardMandateOptions"
    ]
    """
    Configuration options for setting up an eMandate for cards issued in India.
    """
    network: NotRequired[
        Literal[
            "amex",
            "cartes_bancaires",
            "diners",
            "discover",
            "eftpos_au",
            "girocard",
            "interac",
            "jcb",
            "link",
            "mastercard",
            "unionpay",
            "unknown",
            "visa",
        ]
    ]
    """
    Selected network to process this Subscription on. Depends on the available networks of the card attached to the Subscription. Can be only set confirm-time.
    """
    request_three_d_secure: NotRequired[
        Literal["any", "automatic", "challenge"]
    ]
    """
    We strongly recommend that you rely on our SCA Engine to automatically prompt your customers for authentication based on risk level and [other requirements](https://stripe.com/docs/strong-customer-authentication). However, if you wish to request 3D Secure based on logic from your own fraud engine, provide this option. Read our guide on [manually requesting 3D Secure](https://stripe.com/docs/payments/3d-secure/authentication-flow#manual-three-ds) for more information on how this configuration interacts with Radar and our SCA Engine.
    """


class SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsCardMandateOptions(
    TypedDict,
):
    amount: NotRequired[int]
    """
    Amount to be charged for future payments.
    """
    amount_type: NotRequired[Literal["fixed", "maximum"]]
    """
    One of `fixed` or `maximum`. If `fixed`, the `amount` param refers to the exact amount to be charged in future payments. If `maximum`, the amount charged can be up to the value passed for the `amount` param.
    """
    description: NotRequired[str]
    """
    A description of the mandate or subscription that is meant to be displayed to the customer.
    """


class SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsCustomerBalance(
    TypedDict,
):
    bank_transfer: NotRequired[
        "SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsCustomerBalanceBankTransfer"
    ]
    """
    Configuration for the bank transfer funding type, if the `funding_type` is set to `bank_transfer`.
    """
    funding_type: NotRequired[str]
    """
    The funding method type to be used when there are not enough funds in the customer balance. Permitted values include: `bank_transfer`.
    """


class SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsCustomerBalanceBankTransfer(
    TypedDict,
):
    eu_bank_transfer: NotRequired[
        "SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsCustomerBalanceBankTransferEuBankTransfer"
    ]
    """
    Configuration for eu_bank_transfer funding type.
    """
    type: NotRequired[str]
    """
    The bank transfer type that can be used for funding. Permitted values include: `eu_bank_transfer`, `gb_bank_transfer`, `jp_bank_transfer`, `mx_bank_transfer`, or `us_bank_transfer`.
    """


class SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsCustomerBalanceBankTransferEuBankTransfer(
    TypedDict,
):
    country: str
    """
    The desired country code of the bank account information. Permitted values include: `BE`, `DE`, `ES`, `FR`, `IE`, or `NL`.
    """


class SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsIdBankTransfer(
    TypedDict,
):
    pass


class SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsKonbini(
    TypedDict,
):
    pass


class SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsPix(
    TypedDict
):
    mandate_options: NotRequired[
        "SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsPixMandateOptions"
    ]
    """
    Configuration options for setting up a mandate
    """


class SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsPixMandateOptions(
    TypedDict,
):
    amount: NotRequired[int]
    """
    Amount to be charged for future payments. If not provided, defaults to 40000.
    """
    amount_includes_iof: NotRequired[Literal["always", "never"]]
    """
    Determines if the amount includes the IOF tax. Defaults to `never`.
    """
    end_date: NotRequired[str]
    """
    Date when the mandate expires and no further payments will be charged, in `YYYY-MM-DD`. If not provided, the mandate will be active until canceled.
    """
    payment_schedule: NotRequired[
        Literal["halfyearly", "monthly", "quarterly", "weekly", "yearly"]
    ]
    """
    Schedule at which the future payments will be charged. Defaults to `weekly`.
    """


class SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsSepaDebit(
    TypedDict,
):
    pass


class SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsUpi(
    TypedDict
):
    mandate_options: NotRequired[
        "SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsUpiMandateOptions"
    ]
    """
    Configuration options for setting up an eMandate
    """


class SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsUpiMandateOptions(
    TypedDict,
):
    amount: NotRequired[int]
    """
    Amount to be charged for future payments.
    """
    amount_type: NotRequired[Literal["fixed", "maximum"]]
    """
    One of `fixed` or `maximum`. If `fixed`, the `amount` param refers to the exact amount to be charged in future payments. If `maximum`, the amount charged can be up to the value passed for the `amount` param.
    """
    description: NotRequired[str]
    """
    A description of the mandate or subscription that is meant to be displayed to the customer.
    """
    end_date: NotRequired[int]
    """
    End date of the mandate or subscription. If not provided, the mandate will be active until canceled. If provided, end date should be after start date.
    """


class SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsUsBankAccount(
    TypedDict,
):
    financial_connections: NotRequired[
        "SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsUsBankAccountFinancialConnections"
    ]
    """
    Additional fields for Financial Connections Session creation
    """
    verification_method: NotRequired[
        Literal["automatic", "instant", "microdeposits"]
    ]
    """
    Verification method for the intent
    """


class SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsUsBankAccountFinancialConnections(
    TypedDict,
):
    filters: NotRequired[
        "SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsUsBankAccountFinancialConnectionsFilters"
    ]
    """
    Provide filters for the linked accounts that the customer can select for the payment method.
    """
    permissions: NotRequired[
        List[
            Literal["balances", "ownership", "payment_method", "transactions"]
        ]
    ]
    """
    The list of permissions to request. If this parameter is passed, the `payment_method` permission must be included. Valid permissions include: `balances`, `ownership`, `payment_method`, and `transactions`.
    """
    prefetch: NotRequired[
        List[
            Literal[
                "balances", "inferred_balances", "ownership", "transactions"
            ]
        ]
    ]
    """
    List of data features that you would like to retrieve upon account creation.
    """


class SubscriptionCreateParamsPaymentSettingsPaymentMethodOptionsUsBankAccountFinancialConnectionsFilters(
    TypedDict,
):
    account_subcategories: NotRequired[List[Literal["checking", "savings"]]]
    """
    The account subcategories to use to filter for selectable accounts. Valid subcategories are `checking` and `savings`.
    """
    institution: NotRequired[str]
    """
    ID of the institution to use to filter for selectable accounts.
    """


class SubscriptionCreateParamsPendingInvoiceItemInterval(TypedDict):
    interval: Literal["day", "month", "week", "year"]
    """
    Specifies invoicing frequency. Either `day`, `week`, `month` or `year`.
    """
    interval_count: NotRequired[int]
    """
    The number of intervals between invoices. For example, `interval=month` and `interval_count=3` bills every 3 months. Maximum of one year interval allowed (1 year, 12 months, or 52 weeks).
    """


class SubscriptionCreateParamsPrebilling(TypedDict):
    iterations: int
    """
    This is used to determine the number of billing cycles to prebill.
    """
    update_behavior: NotRequired[Literal["prebill", "reset"]]
    """
    Whether to cancel or preserve `prebilling` if the subscription is updated during the prebilled period. The default value is `reset`.
    """


class SubscriptionCreateParamsTransferData(TypedDict):
    amount_percent: NotRequired[float]
    """
    A non-negative decimal between 0 and 100, with at most two decimal places. This represents the percentage of the subscription invoice total that will be transferred to the destination account. By default, the entire amount is transferred to the destination.
    """
    destination: str
    """
    ID of an existing, connected Stripe account.
    """


class SubscriptionCreateParamsTrialSettings(TypedDict):
    end_behavior: "SubscriptionCreateParamsTrialSettingsEndBehavior"
    """
    Defines how the subscription should behave when the user's free trial ends.
    """


class SubscriptionCreateParamsTrialSettingsEndBehavior(TypedDict):
    missing_payment_method: Literal["cancel", "create_invoice", "pause"]
    """
    Indicates how the subscription should change when the trial ends if the user did not provide a payment method.
    """
