# Generated by Django 4.2.16 on 2024-10-23 10:27

from django.db import migrations, models

import resolwe.flow.models.annotations
import resolwe.flow.models.base
import resolwe.flow.models.fields


def assign_modify_to_created(apps, schema_editor):
    """Assign created date to annotation values."""

    AnnotationValue = apps.get_model("flow", "AnnotationValue")
    for annotation_value in AnnotationValue.objects.iterator():
        annotation_value.created = annotation_value.modified
        annotation_value.save(update_fields=["created"])


class Migration(migrations.Migration):

    dependencies = [
        ("flow", "0030_annotationvalue_contributor"),
    ]

    operations = [
        migrations.RemoveConstraint(
            model_name="annotationvalue",
            name="uniquetogether_entity_field",
        ),
        migrations.AddField(
            model_name="annotationvalue",
            name="created",
            field=models.DateTimeField(auto_now_add=True, db_index=True, null=None),
            preserve_default=False,
        ),
        migrations.RunPython(assign_modify_to_created),
        migrations.AlterField(
            model_name="annotationvalue",
            name="created",
            field=models.DateTimeField(auto_now_add=True, db_index=True, default=None),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="annotationvalue",
            name="name",
            field=models.CharField(default="", max_length=100),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="annotationvalue",
            name="slug",
            field=resolwe.flow.models.fields.ResolweSlugField(
                default="",
                max_length=100,
                populate_from=resolwe.flow.models.annotations._slug_for_annotation_value,
                unique_with=("version",),
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="annotationvalue",
            name="version",
            field=resolwe.flow.models.fields.VersionField(default="0.0.0"),
        ),
        migrations.AlterField(
            model_name="annotationvalue",
            name="_value",
            field=models.JSONField(default=dict, null=True),
        ),
        migrations.AlterField(
            model_name="annotationvalue",
            name="modified",
            field=resolwe.flow.models.base.ModifiedField(auto_now=True, db_index=True),
        ),
        migrations.AddConstraint(
            model_name="annotationvalue",
            constraint=models.UniqueConstraint(
                fields=("entity", "field", "created"),
                name="uniquetogether_entity_field_created",
            ),
        ),
    ]
