# Generated by Django 3.1.7 on 2021-10-12 11:34

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="PermissionGroup",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="PermissionModel",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("value", models.PositiveSmallIntegerField()),
                (
                    "group",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="model_permissions",
                        to="auth.group",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="model_permissions",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "permission_group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="permissions",
                        to="permissions.permissiongroup",
                    ),
                ),
            ],
        ),
        migrations.AddConstraint(
            model_name="permissionmodel",
            constraint=models.UniqueConstraint(
                condition=models.Q(user__isnull=False),
                fields=("permission_group", "value", "user"),
                name="one_permission_per_user",
            ),
        ),
        migrations.AddConstraint(
            model_name="permissionmodel",
            constraint=models.UniqueConstraint(
                condition=models.Q(group__isnull=False),
                fields=("permission_group", "value", "group"),
                name="one_permission_per_group",
            ),
        ),
        migrations.AddConstraint(
            model_name="permissionmodel",
            constraint=models.CheckConstraint(
                check=models.Q(
                    models.Q(("group__isnull", True), ("user__isnull", False)),
                    models.Q(("group__isnull", False), ("user__isnull", True)),
                    _connector="OR",
                ),
                name="exactly_one_of_user_group_must_be_set",
            ),
        ),
    ]
