# coding: utf8
"""  
All wordforms are extracted from Norsk Ordbank in Norwegian Bokmål 2005
(CLARINO NB - Språkbanken), Nasjonalbiblioteket, Norway:
https://www.nb.no/sprakbanken/show?serial=oai%3Anb.no%3Asbr-5&lang=en  
License:
Creative_Commons-BY (CC-BY) (https://creativecommons.org/licenses/by/4.0/)  
"""

from __future__ import unicode_literals

LOOKUP = {
'à': 'à',
'à la': 'à la',
'A/L': 'A/L',
'A/S': 'A/S',
'AD': 'AD',
'a. D': 'AD',
'a.D.': 'AD',
'aD': 'AD',
'ad': 'AD',
'ADB': 'ADB',
'adb': 'ADB',
'A.L.': 'AL',
'A/L': 'AL',
'AL': 'AL',
'a.l.': 'AL',
'a/l': 'AL',
'AM': 'AM',
'A.S': 'AS',
'A/S': 'AS',
'AS': 'AS',
'a.s.': 'AS',
'a/s': 'AS',
'as': 'AS',
'AV': 'AV',
'av': 'AV',
'Ac': 'Ac',
'Ag': 'Ag',
'Al': 'Al',
'Am': 'Am',
'Ar': 'Ar',
'As': 'As',
'At': 'At',
'Au': 'Au',
'Ba': 'Ba',
'Be': 'Be',
'Bi': 'Bi',
'Bk': 'Bk',
'Bq': 'Bq',
'Br': 'Br',
'CP': 'CP',
'cp': 'CP',
'Ca': 'Ca',
'Cd': 'Cd',
'Ce': 'Ce',
'Cf': 'Cf',
'Ci': 'Ci',
'Cl': 'Cl',
'Cm': 'Cm',
'Co': 'Co',
'Co.': 'Co.',
'co.': 'Co.',
'Cr': 'Cr',
'Cs': 'Cs',
'Cu': 'Cu',
'D/S': 'D/S',
'DK': 'DK',
'D/S': 'DS',
'DS': 'DS',
'Dy': 'Dy',
'EDB': 'EDB',
'edb': 'EDB',
'EF': 'EF',
'EKG': 'EKG',
'ekg': 'EKG',
'ES': 'ES',
'es': 'ES',
'Es': 'Es',
'Eu': 'Eu',
'EØS': 'EØS',
'eøs': 'EØS',
'FM': 'FM',
'fm': 'FM',
'FN': 'FN',
'Fe': 'Fe',
'Fm': 'Fm',
'Fr': 'Fr',
'GB': 'GB',
'GHz': 'GHz',
'GMT': 'GMT',
'gmt': 'GMT',
'GT': 'GT',
'GW': 'GW',
'Ga': 'Ga',
'Gb': 'Gb',
'Gy': 'Gy',
'H.K.H.': 'H.K.H.',
'H.k.h.': 'H.K.H.',
'H.M.': 'H.M.',
'H.m.': 'H.M.',
'HB': 'HB',
'hb': 'HB',
'HF': 'HF',
'hf': 'HF',
'HV': 'HV',
'hv': 'HV',
'He': 'He',
'Hf': 'Hf',
'Hg': 'Hg',
'Ho': 'Ho',
'Hz': 'Hz',
'Eder': 'I',
'I': 'I',
'eder': 'I',
'I': 'I',
'I. N. D.': 'I.N.D.',
'I.N.D.': 'I.N.D.',
'IQ': 'IQ',
'In': 'In',
'Ir': 'Ir',
'K/S': 'K/S',
'K/S': 'KS',
'KS': 'KS',
'k.s.': 'KS',
'k/s': 'KS',
'ks': 'KS',
'Kr': 'Kr',
'L': 'L',
'LK': 'LK',
'La': 'La',
'Lg': 'Lg',
'Li': 'Li',
'Lr': 'Lr',
'Lt.': 'Lt.',
'Lu': 'Lu',
'M': 'M',
'M/S': 'M/S',
'M/T': 'M/T',
'MB': 'MB',
'MHz': 'MHz',
'MP': 'MP',
'mp': 'MP',
'MS': 'MS',
'ms': 'MS',
'M/S': 'MS',
'MS': 'MS',
'M/T': 'MT',
'MT': 'MT',
'MV': 'MV',
'MW': 'MW',
'Mg': 'Mg',
'Mlle': 'Mlle',
'mlle': 'Mlle',
'Mme': 'Mme',
'mme': 'Mme',
'Mn': 'Mn',
'Mo': 'Mo',
'Mr.': 'Mr.',
'mr.': 'Mr.',
'Mt': 'Mt',
'NATO': 'NATO',
'Nato': 'NATO',
'NB': 'NB',
'NN': 'NN',
'NRF': 'NRF',
'NS': 'NS',
'ns': 'NS',
'Na': 'Na',
'Nato': 'Nato',
'Nb': 'Nb',
'Ne': 'Ne',
'Ng': 'Ng',
'ng': 'Ng',
'Ni': 'Ni',
'No': 'No',
'Np': 'Np',
'Oe': 'Oe',
'Os': 'Os',
'Ot.': 'Ot.',
'PVC': 'PVC',
'PVRK': 'PVRK',
'pvrk': 'PVRK',
'Pa': 'Pa',
'Pb': 'Pb',
'Pd': 'Pd',
'Pf': 'Pf',
'Pf.': 'Pf',
'Pf': 'Pf',
'Pfg': 'Pfg',
'Pfg.': 'Pfg',
'pfg': 'Pfg',
'pfg.': 'Pfg',
'Pfg': 'Pfg',
'Pm': 'Pm',
'Po': 'Po',
'Pr': 'Pr',
'Pt': 'Pt',
'Pu': 'Pu',
'Ra': 'Ra',
'Rb': 'Rb',
'Re': 'Re',
'Rh': 'Rh',
'Rn': 'Rn',
'Ru': 'Ru',
'S/S': 'S/S',
'SI': 'SI',
'S/S': 'SS',
'SS': 'SS',
'Sa': 'Sa',
'Sb': 'Sb',
'Sc': 'Sc',
'Se': 'Se',
'Sg': 'Sg',
'Si': 'Si',
'Sn': 'Sn',
'Sr': 'Sr',
'St.': 'St.',
'Sv': 'Sv',
'T/S': 'T/S',
'TCDD': 'TCDD',
'TIR': 'TIR',
'TNT': 'TNT',
'T/S': 'TS',
'TS': 'TS',
'TW': 'TW',
'Ta': 'Ta',
'Tb': 'Tb',
'Tc': 'Tc',
'Te': 'Te',
'Th': 'Th',
'Tl': 'Tl',
'Tm': 'Tm',
'V5': 'V5',
'V6': 'V6',
'VA': 'VA',
'VCM': 'VCM',
'VVS': 'VVS',
'Wb': 'Wb',
'Wh': 'Wh',
'Xe': 'Xe',
'Yb': 'Yb',
'Zn': 'Zn',
'Zr': 'Zr',
'a': 'a',
'a': 'a',
'a': 'a',
'a-': 'a-',
'a.D.': 'a.D.',
'ab': 'ab',
'ad': 'ad',
'ad': 'ad',
'adb': 'adb',
'adjø': 'adjø',
'agric.': 'agric.',
'ah': 'ah',
'aha': 'aha',
'ai': 'ai',
'akk': 'akk',
'aktenfor': 'aktenfor',
'aktenfra': 'aktenfra',
'aktenom': 'aktenom',
'akter': 'akter',
'akterinn': 'akterinn',
'akterover': 'akterover',
'akterut': 'akterut',
'all': 'all',
'alle': 'all',
'alt': 'all',
'all verden': 'all verden',
'alle vegne': 'alle vegne',
'allesteds': 'allesteds',
'allestedsfra': 'allestedsfra',
'allestedshen': 'allestedshen',
'allting': 'allting',
'alm.': 'alm.',
'amen': 'amen',
'angående': 'angående',
'andre': 'annen',
'anna': 'annen',
'annen': 'annen',
'annet': 'annen',
'annenhver': 'annenhver',
'annethvert': 'annenhver',
'annensteds': 'annensteds',
'annenstedsfra': 'annenstedsfra',
'annenstedsfra': 'annenstedsfra',
'annenstedshen': 'annenstedshen',
'annetstedsfra': 'annetstedsfra',
'art.': 'art.',
'at': 'at',
'att': 'att',
'atten': 'atten',
'attende': 'attende',
'attpå': 'attpå',
'au': 'au',
'au revoir': 'au revoir',
'aust': 'aust',
'austa': 'austa',
'austafjells': 'austafjells',
'austafor': 'austafor',
'austafra': 'austafra',
'austetter': 'austetter',
'austetter': 'austetter',
'austfra': 'austfra',
'austfra': 'austfra',
'austover': 'austover',
'austover': 'austover',
'austpå': 'austpå',
'austpå': 'austpå',
'av': 'av',
'av dage': 'av dage',
'av garde': 'av garde',
'av gårde': 'av gårde',
'av lage': 'av lage',
'av sted': 'av sted',
'av syne': 'av syne',
'babord': 'babord',
'bak': 'bak',
'bakafor': 'bakafor',
'bakenfor': 'bakenfor',
'bakenifra': 'bakenifra',
'baketter': 'baketter',
'bakfra': 'bakfra',
'bakom': 'bakom',
'bakover': 'bakover',
'bakpå': 'bakpå',
'bakut': 'bakut',
'bang': 'bang',
'basta': 'basta',
'begge': 'begge',
'beint fram': 'beint fram',
'bent fram': 'bent fram',
'bent frem': 'bent frem',
'best som': 'best som',
'best.': 'best.',
'bevares': 'bevares',
'bfr': 'bfr',
'bfr.': 'bfr',
'bl a': 'bl.a.',
'bl. a.': 'bl.a.',
'bl.a.': 'bl.a.',
'blant': 'blant',
'bnr': 'bnr.',
'bnr.': 'bnr.',
'bom': 'bom',
'bort': 'bort',
'bort imot': 'bort imot',
'bort mot': 'bort mot',
'bortafor': 'bortafor',
'borte': 'borte',
'bortefra': 'bortefra',
'bortenfor': 'bortenfor',
'borti': 'borti',
'bortigjennom': 'bortigjennom',
'bortimot': 'bortimot',
'bortom': 'bortom',
'bortover': 'bortover',
'bortpå': 'bortpå',
'borttil': 'borttil',
'bortunder': 'bortunder',
'bortved': 'bortved',
'brakar': 'brakar',
'bravissimo': 'bravissimo',
'bravo': 'bravo',
'bums': 'bums',
'bygdimellom': 'bygdimellom',
'byss': 'byss',
'både': 'både',
'bæ': 'bæ',
'bø': 'bø',
'c/o': 'c/o',
'ca': 'ca.',
'ca.': 'ca.',
'cal': 'cal',
'cand.': 'cand.',
'Cand. act.': 'cand.act.',
'cand. act': 'cand.act.',
'cand. act.': 'cand.act.',
'cand.act': 'cand.act.',
'cand.act.': 'cand.act.',
'Cand. agric.': 'cand.agric.',
'Cand.agric.': 'cand.agric.',
'cand. agric': 'cand.agric.',
'cand. agric.': 'cand.agric.',
'cand.agric': 'cand.agric.',
'cand.agric.': 'cand.agric.',
'Cand. jur.': 'cand.jur.',
'Cand.jur.': 'cand.jur.',
'cand. jur.': 'cand.jur.',
'cand.jur.': 'cand.jur.',
'Cand. Mag.': 'cand.mag.',
'Cand. mag.': 'cand.mag.',
'Cand.mag.': 'cand.mag.',
'cand. mag.': 'cand.mag.',
'cand.mag.': 'cand.mag.',
'Cand. med.': 'cand.med.',
'Cand.med.': 'cand.med.',
'cand. med': 'cand.med.',
'cand. med.': 'cand.med.',
'cand.med': 'cand.med.',
'cand.med.': 'cand.med.',
'Can.med.vet': 'cand.med.vet.',
'Cand. Med. Vet.': 'cand.med.vet.',
'Cand. med. vet': 'cand.med.vet.',
'Cand.med.vet': 'cand.med.vet.',
'Cand.med.vet.': 'cand.med.vet.',
'can.med.vet': 'cand.med.vet.',
'cand. med. vet': 'cand.med.vet.',
'cand.med.vet': 'cand.med.vet.',
'cand.med.vet.': 'cand.med.vet.',
'Cand. min.': 'cand.min.',
'Cand.min.': 'cand.min.',
'cand. min': 'cand.min.',
'cand. min.': 'cand.min.',
'cand.min': 'cand.min.',
'cand.min.': 'cand.min.',
'Cand. Odont.': 'cand.odont.',
'Cand. odont.': 'cand.odont.',
'Cand.odont.': 'cand.odont.',
'cand. odont.': 'cand.odont.',
'cand.odont.': 'cand.odont.',
'Cand. Oecon.': 'cand.oecon.',
'Cand. oecon.': 'cand.oecon.',
'Cand.oecon.': 'cand.oecon.',
'cand. oecon.': 'cand.oecon.',
'cand.oecon.': 'cand.oecon.',
'Cand. Paed.': 'cand.paed.',
'Cand. paed.': 'cand.paed.',
'Cand.paed.': 'cand.paed.',
'cand. paed.': 'cand.paed.',
'cand.paed.': 'cand.paed.',
'Cand. Pharm.': 'cand.pharm.',
'Cand. pharm.': 'cand.pharm.',
'Cand.pharm.': 'cand.pharm.',
'cand. pharm.': 'cand.pharm.',
'cand.pharm.': 'cand.pharm.',
'Cand. Philol.': 'cand.philol.',
'Cand. philol.': 'cand.philol.',
'Cand.philol.': 'cand.philol.',
'cand. philol.': 'cand.philol.',
'cand.philol.': 'cand.philol.',
'Cand. Polit.': 'cand.polit.',
'Cand. polit.': 'cand.polit.',
'Cand.polit.': 'cand.polit.',
'cand. polit.': 'cand.polit.',
'cand.polit.': 'cand.polit.',
'Cand. Psychol.': 'cand.psychol.',
'Cand. psychol.': 'cand.psychol.',
'Cand.psychol.': 'cand.psychol.',
'cand. psychol.': 'cand.psychol.',
'cand.psychol.': 'cand.psychol.',
'Cand. Real.': 'cand.real.',
'Cand. real.': 'cand.real.',
'Cand.real.': 'cand.real.',
'cand. real.': 'cand.real.',
'cand.real.': 'cand.real.',
'Cand. Scient.': 'cand.scient.',
'Cand. scient.': 'cand.scient.',
'cand. scient': 'cand.scient.',
'cand. scient.': 'cand.scient.',
'cand.scient.': 'cand.scient.',
'Cand. Sociol.': 'cand.sociol.',
'Cand. sociol.': 'cand.sociol.',
'Cand.sociol.': 'cand.sociol.',
'cand. sociol.': 'cand.sociol.',
'cand.sociol.': 'cand.sociol.',
'Cand. theol.': 'cand.theol.',
'Cand.theol.': 'cand.theol.',
'cand. theol': 'cand.theol.',
'cand. theol.': 'cand.theol.',
'cand.theol': 'cand.theol.',
'cand.theol.': 'cand.theol.',
'cd': 'cd',
'cg': 'cg',
'cl': 'cl',
'cm': 'cm',
'cm.': 'cm',
'co.': 'co.',
'contra': 'contra',
'cos': 'cos',
'cot': 'cot',
'cp': 'cp',
'd. c.': 'd.c.',
'd.c.': 'd.c.',
'd. d.': 'd.d.',
'd.d.': 'd.d.',
'd. e.': 'd.e.',
'd.e.': 'd.e.',
'd. y.': 'd.y.',
'd.y.': 'd.y.',
'dy.': 'd.y.',
'd. å.': 'd.å.',
'd.å.': 'd.å.',
'dB': 'dB',
'daa': 'daa',
'dat': 'dat.',
'dat.': 'dat.',
'datt': 'datt',
'datten': 'datten',
'db': 'db',
'de': 'de',
'dem': 'de',
'de': 'de',
'degeren': 'degeren',
'degeren': 'degeren',
'degern': 'degern',
'degern': 'degern',
'den': 'den',
'den gang': 'den gang',
'denne': 'denne',
'dept': 'dept.',
'dept.': 'dept.',
'der': 'der',
'der borte': 'der borte',
'der hen': 'der hen',
'der inne': 'der inne',
'der nede': 'der nede',
'der oppe': 'der oppe',
'der ute': 'der ute',
'dere': 'dere',
'deres': 'deres',
'derfra': 'derfra',
'deri': 'deri',
'deriblant': 'deriblant',
'derifra': 'derifra',
'derom': 'derom',
'derpå': 'derpå',
'dersom': 'dersom',
'dertil': 'dertil',
'derved': 'derved',
'det': 'det',
'det': 'det',
'det': 'det',
'dette': 'dette',
'dg': 'dg',
'dikkedikk': 'dikkedikk',
'dim.': 'dim.',
'di': 'din',
'din': 'din',
'dine': 'din',
'ditt': 'din',
'ding-dang': 'ding-dang',
'ding-ding': 'ding-ding',
'diskree': 'diskré',
'diskreere': 'diskré',
'diskreest': 'diskré',
'diskreeste': 'diskré',
'disse': 'disse',
'distree': 'distré',
'distreere': 'distré',
'distreest': 'distré',
'distreeste': 'distré',
'dit': 'dit',
'dit hen': 'dit hen',
'ditover': 'ditover',
'ditt': 'ditt',
'ditten': 'ditten',
'ditto': 'ditto',
'div': 'div.',
'div.': 'div.',
'dl': 'dl',
'dm': 'dm',
'do.': 'do.',
'Dr': 'dr.',
'Dr.': 'dr.',
'dr': 'dr.',
'dr.': 'dr.',
'Dr. agric.': 'dr.agric.',
'Dr.agric.': 'dr.agric.',
'dr. agric': 'dr.agric.',
'dr. agric.': 'dr.agric.',
'dr.agric': 'dr.agric.',
'dr.agric.': 'dr.agric.',
'Dr. Art.': 'dr.art.',
'Dr. art.': 'dr.art.',
'Dr.art.': 'dr.art.',
'dr. art.': 'dr.art.',
'dr.art.': 'dr.art.',
'Dr. ing.': 'dr.ing.',
'Dr.ing.': 'dr.ing.',
'dr. ing': 'dr.ing.',
'dr. ing.': 'dr.ing.',
'dr.ing': 'dr.ing.',
'dr.ing.': 'dr.ing.',
'Dr. Jur.': 'dr.jur.',
'Dr. jur.': 'dr.jur.',
'Dr.jur.': 'dr.jur.',
'dr.jur.': 'dr.jur.',
'Dr. med.': 'dr.med.',
'Dr.med.': 'dr.med.',
'dr. med': 'dr.med.',
'dr. med.': 'dr.med.',
'dr.med': 'dr.med.',
'dr.med.': 'dr.med.',
'Dr. Med. Vet.': 'dr.med.vet.',
'Dr. med. vet.': 'dr.med.vet.',
'Dr.med.vet.': 'dr.med.vet.',
'dr. med. vet.': 'dr.med.vet.',
'dr.med.vet.': 'dr.med.vet.',
'Dr. Odont.': 'dr.odont.',
'Dr. odont.': 'dr.odont.',
'Dr.odont.': 'dr.odont.',
'dr. odont.': 'dr.odont.',
'dr.odont.': 'dr.odont.',
'Dr. Oecon.': 'dr.oecon.',
'Dr. oecon.': 'dr.oecon.',
'Dr.oecon.': 'dr.oecon.',
'dr. oecon.': 'dr.oecon.',
'dr.oecon.': 'dr.oecon.',
'Dr. Philos.': 'dr.philos.',
'Dr. philos.': 'dr.philos.',
'Dr.philos.': 'dr.philos.',
'dr. philos.': 'dr.philos.',
'dr.philos.': 'dr.philos.',
'Dr. techn.': 'dr.techn.',
'Dr.techn.': 'dr.techn.',
'dr. techn': 'dr.techn.',
'dr. techn.': 'dr.techn.',
'dr.techn': 'dr.techn.',
'dr.techn.': 'dr.techn.',
'Dr. theol': 'dr.theol.',
'Dr.theol': 'dr.theol.',
'dr. theol': 'dr.theol.',
'dr. theol.': 'dr.theol.',
'dr.theol': 'dr.theol.',
'dr.theol.': 'dr.theol.',
'ds': 'ds.',
'ds.': 'ds.',
'dss': 'dss.',
'dss.': 'dss.',
'deg': 'du',
'du': 'du',
'dunk': 'dunk',
'duplo': 'duplo',
'dv': 'dv.',
'dv.': 'dv.',
'd. v. s.': 'dvs.',
'd.v.s.': 'dvs.',
'dvs': 'dvs.',
'dvs.': 'dvs.',
'dægeren': 'dægeren',
'dægeren': 'dægeren',
'dægern': 'dægern',
'dægern': 'dægern',
'dæven': 'dæven',
'e': 'e',
'e Kr': 'e.Kr.',
'e. Kr.': 'e.Kr.',
'e.Kr': 'e.Kr.',
'e.Kr.': 'e.Kr.',
'e f': 'e.f.',
'e. f.': 'e.f.',
'e.f.': 'e.f.',
'e l': 'e.l.',
'e. l.': 'e.l.',
'e. lign.': 'e.l.',
'e. likn.': 'e.l.',
'e.l.': 'e.l.',
'e.lign.': 'e.l.',
'e.likn.': 'e.l.',
'ell. lign.': 'e.l.',
'ell. likn.': 'e.l.',
'ell.lign.': 'e.l.',
'ell.likn.': 'e.l.',
'eV': 'eV',
'edb': 'edb',
'eflg.': 'eflg.',
'eg.': 'eg.',
'ei': 'ei',
'eia': 'eia',
'egne': 'eigen',
'eiga': 'eigen',
'eige': 'eigen',
'eigen': 'eigen',
'ekg': 'ekg',
'eksklusiv': 'eksklusiv',
'eksklusive': 'eksklusive',
'el.': 'el.',
'eleison': 'eleison',
'eller': 'eller',
'elleve': 'elleve',
'ei': 'en',
'en': 'en',
'et': 'en',
'ett': 'en',
'en': 'en',
'ei': 'en',
'en': 'en',
'et': 'en',
'ett': 'en',
'ende fram': 'ende fram',
'ende frem': 'ende frem',
'endelangs': 'endelangs',
'eneste': 'eneste',
'enhver': 'enhver',
'ethvert': 'enhver',
'enn': 'enn',
'enn': 'enn',
'enn si': 'enn si',
'enn videre': 'enn videre',
'enn ytterligere': 'enn ytterligere',
'enskjønt': 'enskjønt',
'ensteds': 'ensteds',
'enten': 'enten',
'et.': 'et.',
'etc': 'etc.',
'etc.': 'etc.',
'etsteds': 'etsteds',
'etter': 'etter',
'etter at': 'etter at',
'etter som': 'etter som',
'ettersom': 'ettersom',
'ev': 'ev.',
'ev.': 'ev.',
'evt.': 'ev.',
'ex': 'ex',
'f.': 'f.',
'f Kr': 'f.Kr.',
'f. Kr.': 'f.Kr.',
'f.Kr': 'f.Kr.',
'f.Kr.': 'f.Kr.',
'f eks': 'f.eks.',
'f. eks': 'f.eks.',
'f. eks.': 'f.eks.',
'f.eks': 'f.eks.',
'f.eks.': 'f.eks.',
'feks': 'f.eks.',
'feks.': 'f.eks.',
'f. o. r.': 'f.o.r.',
'f.o.r.': 'f.o.r.',
'face': 'face',
'fallera': 'fallera',
'falleri': 'falleri',
'far vel': 'far vel',
'farken': 'farken',
'fec.': 'fec.',
'fem': 'fem',
'femten': 'femten',
'femti': 'femti',
'ff': 'ff',
'fff': 'fff',
'fhv': 'fhv.',
'fhv.': 'fhv.',
'filiokus': 'filiokus',
'filleren': 'filleren',
'fire': 'fire',
'fjartan': 'fjartan',
'fjorten': 'fjorten',
'fl': 'fl',
'fl.': 'fl',
'fl.': 'fl.',
'fl.': 'fl.',
'flt.': 'fl.',
'flg': 'flg.',
'flg.': 'flg.',
'flt.': 'flt.',
'fol': 'fol.',
'fol.': 'fol.',
'fola': 'fola',
'for': 'for',
'for': 'for',
'for at': 'for at',
'for di': 'for di',
'for hånden': 'for hånden',
'for tida': 'for tida',
'for tiden': 'for tiden',
'foran': 'foran',
'forbi': 'forbi',
'fordi': 'fordi',
'forfra': 'forfra',
'fork': 'fork.',
'fork.': 'fork.',
'formedelst': 'formedelst',
'formødre': 'formødre',
'formødrer': 'formødrer',
'forover': 'forover',
'forrige': 'forrige',
'forut': 'forut',
'foruten': 'foruten',
'fr': 'fr',
'fr.': 'fr',
'fr': 'fr.',
'fr.': 'fr.',
'fra': 'fra',
'fra borde': 'fra borde',
'fram': 'fram',
'frametter': 'frametter',
'framfor': 'framfor',
'framføre': 'framføre',
'frammafor': 'frammafor',
'framme': 'framme',
'frammenfor': 'frammenfor',
'framom': 'framom',
'framover': 'framover',
'frampå': 'frampå',
'frem': 'frem',
'fremad': 'fremad',
'fremetter': 'fremetter',
'fremfor': 'fremfor',
'fremme': 'fremme',
'fremmenfor': 'fremmenfor',
'fremom': 'fremom',
'fremover': 'fremover',
'frempå': 'frempå',
'frk.': 'frk.',
'fut.': 'fut.',
'fy': 'fy',
'fysj': 'fysj',
'før': 'før',
'før enn': 'før enn',
'føre': 'føre',
'føre': 'føre',
'førti': 'førti',
'g': 'g.',
'g.': 'g.',
'gakk': 'gakk',
'gakk-gakk': 'gakk-gakk',
'gal': 'gal',
'gardimellom': 'gardimellom',
'gatelangs': 'gatelangs',
'gen.': 'gen.',
'gett': 'gett',
'gg': 'gg',
'gg.': 'gg',
'gid': 'gid',
'giss': 'giss',
'gitt': 'gitt',
'gjennom': 'gjennom',
'gjøren': 'gjøren',
'gl': 'gl.',
'gl.': 'gl.',
'gml': 'gl.',
'gml.': 'gl.',
'gnr': 'gnr.',
'gnr.': 'gnr.',
'god dag': 'god dag',
'god kveld': 'god kveld',
'god morgen': 'god morgen',
'god natt': 'god natt',
'gros': 'gros',
'gud skje lov': 'gud skje lov',
'går kveld': 'går kveld',
'går morges': 'går morges',
'går natt': 'går natt',
'ha': 'ha',
'ha': 'ha',
'ha-ha': 'ha-ha',
'haha': 'haha',
'halleluja': 'halleluja',
'hallo': 'hallo',
'halloi': 'halloi',
'halloi': 'halloi',
'haloi': 'haloi',
'haloi': 'haloi',
'halvanna': 'halvannen',
'halvannen': 'halvannen',
'halvannet': 'halvannen',
'halvhundre': 'halvhundre',
'halvveges': 'halvveges',
'halvvegs': 'halvvegs',
'ham': 'han',
'han': 'han',
'hands up': 'hands up',
'hans': 'hans',
'hau': 'hau',
'he': 'he',
'hei': 'hei',
'hei sann': 'hei sann',
'heia': 'heia',
'heil': 'heil',
'heim': 'heim',
'heim att': 'heim att',
'heima': 'heima',
'heimafra': 'heimafra',
'heimanfra': 'heimanfra',
'heime': 'heime',
'heimefra': 'heimefra',
'heimefra': 'heimefra',
'heimetter': 'heimetter',
'heimom': 'heimom',
'heimover': 'heimover',
'helledussen': 'helledussen',
'hen': 'hen',
'henad': 'henad',
'henimot': 'henimot',
'henne': 'henne',
'hennes': 'hennes',
'henover': 'henover',
'henved': 'henved',
'hepp': 'hepp',
'her': 'her',
'herav': 'herav',
'heretter': 'heretter',
'herfra': 'herfra',
'heri': 'heri',
'heriblant': 'heriblant',
'herifra': 'herifra',
'herigjennom': 'herigjennom',
'herimot': 'herimot',
'hermed': 'hermed',
'herom': 'herom',
'herover': 'herover',
'herpå': 'herpå',
'herregud': 'herregud',
'hertil': 'hertil',
'herunder': 'herunder',
'herved': 'herved',
'heureka': 'heureka',
'hg': 'hg',
'hhv': 'hhv.',
'hhv.': 'hhv.',
'hill': 'hill',
'hi': 'hin',
'hin': 'hin',
'hine': 'hin',
'hint': 'hin',
'hitt': 'hin',
'hinannen': 'hinannen',
'hinsides': 'hinsides',
'hipp': 'hipp',
'hisset': 'hisset',
'hist': 'hist',
'hit': 'hit',
'hitafor': 'hitafor',
'hitenfor': 'hitenfor',
'hitover': 'hitover',
'hittil': 'hittil',
'hjem': 'hjem',
'hjemad': 'hjemad',
'hjemetter': 'hjemetter',
'hjemme': 'hjemme',
'hjemmefra': 'hjemmefra',
'hjemmefra': 'hjemmefra',
'hjemom': 'hjemom',
'hjemover': 'hjemover',
'hk': 'hk',
'hl': 'hl',
'hm': 'hm',
'ho': 'ho',
'hoho': 'hoho',
'hoi': 'hoi',
'holdt': 'holdt',
'hopp': 'hopp',
'hopp sann': 'hopp sann',
'hoppla': 'hoppla',
'hoppsa': 'hoppsa',
'hoppsasa': 'hoppsasa',
'hos': 'hos',
'hosianna': 'hosianna',
'hu': 'hu',
'huff': 'huff',
'hui': 'hui',
'henne': 'hun',
'hun': 'hun',
'hundre': 'hundre',
'hundreogéi': 'hundreogén',
'hundreogén': 'hundreogén',
'hundreogétt': 'hundreogén',
'hurra': 'hurra',
'hurten': 'hurten',
'husimellom': 'husimellom',
'husj': 'husj',
'hut': 'hut',
'huttemegtu': 'huttemegtu',
'huttetu': 'huttetu',
'hva': 'hva',
'hvem': 'hvem',
'hver': 'hver',
'hvert': 'hver',
'hverandre': 'hverandre',
'hvilke': 'hvilken',
'hvilken': 'hvilken',
'hvilket': 'hvilken',
'hvo': 'hvo',
'hvor hen': 'hvor hen',
'hvoretter': 'hvoretter',
'hvorfra': 'hvorfra',
'hvori': 'hvori',
'hvoriblant': 'hvoriblant',
'hvorimot': 'hvorimot',
'hvorledes': 'hvorledes',
'hvormed': 'hvormed',
'hvorom': 'hvorom',
'hvorpå': 'hvorpå',
'hvorvidt': 'hvorvidt',
'hypp': 'hypp',
'hysj': 'hysj',
'hyss': 'hyss',
'hå': 'hå',
'hæ': 'hæ',
'hø': 'hø',
'hør': 'hør',
'i': 'i',
'i aften': 'i aften',
'i aftes': 'i aftes',
'i dag': 'i dag',
'i fall': 'i fall',
'i fjor': 'i fjor',
'i fleng': 'i fleng',
'i forfjor': 'i forfjor',
'i forgårs': 'i forgårs',
'i gjerde': 'i gjerde',
'i gjære': 'i gjære',
'i grunnen': 'i grunnen',
'i går': 'i går',
'i går kveld': 'i går kveld',
'i hel': 'i hel',
'i hende': 'i hende',
'i hjel': 'i hjel',
'i hop': 'i hop',
'i hug': 'i hug',
'i huleste': 'i huleste',
'i hvert fall': 'i hvert fall',
'i koll': 'i koll',
'i kraft': 'i kraft',
'i kveld': 'i kveld',
'i lag': 'i lag',
'i land': 'i land',
'i like måte': 'i like måte',
'i live': 'i live',
'i mak': 'i mak',
'i mente': 'i mente',
'i miss': 'i miss',
'i mist': 'i mist',
'i morgen': 'i morgen',
'i morges': 'i morges',
'i møte': 'i møte',
'i natt': 'i natt',
'i overmorgen': 'i overmorgen',
'i rette': 'i rette',
'i sammen': 'i sammen',
'i senn': 'i senn',
'i sinne': 'i sinne',
'i stand': 'i stand',
'i sted': 'i sted',
'i stedet for': 'i stedet for',
'i stykker': 'i stykker',
'i stå': 'i stå',
'i sund': 'i sund',
'i svime': 'i svime',
'i så fall': 'i så fall',
'i så måte': 'i så måte',
'i søvne': 'i søvne',
'i tide': 'i tide',
'i tilfelle': 'i tilfelle',
'i tu': 'i tu',
'i utide': 'i utide',
'i vare': 'i vare',
'i veg': 'i veg',
'i vei': 'i vei',
'i vente': 'i vente',
'i verk': 'i verk',
'i år': 'i år',
'i. e.': 'i.e.',
'i.e.': 'i.e.',
'ib.': 'ib.',
'ib.': 'ib.',
'ib.': 'ibid.',
'ib.': 'ibid.',
'ibid': 'ibid.',
'ibid.': 'ibid.',
'iblant': 'iblant',
'idet': 'idet',
'ifra': 'ifra',
'ifølge': 'ifølge',
'igjennom': 'igjennom',
'ikring': 'ikring',
'imellom': 'imellom',
'imot': 'imot',
'inga': 'ingen',
'ingen': 'ingen',
'intet': 'ingen',
'ingenting': 'ingenting',
'inkl.': 'inkl.',
'inklusiv': 'inklusiv',
'inklusive': 'inklusive',
'inn': 'inn',
'inn i': 'inn i',
'inn til': 'inn til',
'innad': 'innad',
'innafor': 'innafor',
'innafra': 'innafra',
'innalands': 'innalands',
'innaskjærs': 'innaskjærs',
'inne': 'inne',
'innefra': 'innefra',
'innen': 'innen',
'innenfor': 'innenfor',
'innenfra': 'innenfra',
'innenifra': 'innenifra',
'innenlands': 'innenlands',
'innenskjærs': 'innenskjærs',
'innetter': 'innetter',
'innfor': 'innfor',
'inni': 'inni',
'inniblant': 'inniblant',
'innimellom': 'innimellom',
'innmed': 'innmed',
'innom': 'innom',
'innomhus': 'innomhus',
'innover': 'innover',
'innpå': 'innpå',
'inntil': 'inntil',
'innunder': 'innunder',
'innved': 'innved',
'innåt': 'innåt',
'intet': 'intet',
'isj': 'isj',
'ist': 'ist',
'istedenfor': 'istedenfor',
'istf': 'istf.',
'istf.': 'istf.',
'ja': 'ja',
'ja vel': 'ja vel',
'ja visst': 'ja visst',
'jadden': 'jadden',
'jaggu': 'jaggu',
'jaha': 'jaha',
'jeg': 'jeg',
'meg': 'jeg',
'jemini': 'jemini',
'jf': 'jf.',
'jf.': 'jf.',
'jfr': 'jf.',
'jfr.': 'jf.',
'jvf': 'jf.',
'jvf.': 'jf.',
'jo': 'jo',
'jo visst': 'jo visst',
'joggu': 'joggu',
'joho': 'joho',
'jr': 'jr.',
'jr.': 'jr.',
'jun': 'jr.',
'jun.': 'jr.',
'jun.': 'jun.',
'jur.': 'jur.',
'juris': 'juris',
'jøss': 'jøss',
'jøsses': 'jøsses',
'jøye': 'jøye',
'kB': 'kB',
'kHz': 'kHz',
'kJ': 'kJ',
'kV': 'kV',
'kW': 'kW',
'kWh': 'kWh',
'Kand.': 'kand.',
'kand.': 'kand.',
'kcal': 'kcal',
'kg': 'kg',
'kg.': 'kg',
'kgl': 'kgl.',
'kgl.': 'kgl.',
'kgl res': 'kgl.res.',
'kgl. res.': 'kgl.res.',
'kgl.res.': 'kgl.res.',
'kiss': 'kiss',
'kl': 'kl.',
'kl.': 'kl.',
'klask': 'klask',
'klikk-klakk': 'klikk-klakk',
'kling': 'kling',
'klingeling': 'klingeling',
'kliss-klass': 'kliss-klass',
'klukk': 'klukk',
'km': 'km',
'km.': 'km',
'ko-ko': 'ko-ko',
'konst.': 'konst.',
'kontra': 'kontra',
'kp': 'kp',
'kpm': 'kpm',
'kr': 'kr',
'kr.': 'kr',
'kra': 'kra',
'kring': 'kring',
'kringom': 'kringom',
'kst.': 'kst.',
'kt': 'kt',
'kurr': 'kurr',
'kvakk': 'kvakk',
'kvekk': 'kvekk',
'kvirrevitt': 'kvirrevitt',
'kykeliky': 'kykeliky',
'kynnere': 'kynnere',
'kyrie eleison': 'kyrie eleison',
'L': 'l',
'l': 'l',
'l.': 'l',
'l\'art pour l\'art': 'l\'art pour l\'art',
'lab': 'lab.',
'lab.': 'lab.',
'landimellom': 'landimellom',
'landverts': 'landverts',
'langs': 'langs',
'langsetter': 'langsetter',
'langsmed': 'langsmed',
'langt fra': 'langt fra',
'langt ifra': 'langt ifra',
'langveges': 'langveges',
'langvegesfra': 'langvegesfra',
'langvegs': 'langvegs',
'langvegsfra': 'langvegsfra',
'langveis': 'langveis',
'langveisfra': 'langveisfra',
'lat.': 'lat.',
'laten': 'laten',
'lev vel': 'lev vel',
'Lg': 'lg',
'lg': 'lg',
'lg.': 'lg',
'log': 'lg',
'log.': 'lg',
'lg': 'lg',
'Lic.': 'lic.',
'lic.': 'lic.',
'Lic. Philos.': 'lic.philos.',
'Lic. philos.': 'lic.philos.',
'Lic.philos': 'lic.philos.',
'lic. philos.': 'lic.philos.',
'lic.philos.': 'lic.philos.',
'lign.': 'lign.',
'like ens': 'like ens',
'like til': 'like til',
'likesom': 'likesom',
'lign.': 'likn.',
'likn.': 'likn.',
'liksom': 'liksom',
'lim.': 'lim.',
'lite grann': 'lite grann',
'lm': 'lm',
'ln': 'ln.',
'ln.': 'ln.',
'log': 'log',
'Lim.': 'ltd.',
'Ltd': 'ltd.',
'Ltd.': 'ltd.',
'lim.': 'ltd.',
'ltd': 'ltd.',
'ltd.': 'ltd.',
'lx': 'lx',
'm': 'm',
'm.': 'm',
'm o.h.': 'm o.h.',
'm. o. h.': 'm o.h.',
'm.o.h.': 'm o.h.',
'moh.': 'm o.h.',
'm u.h.': 'm u.h.',
'm. u. h.': 'm u.h.',
'm.u.h.': 'm u.h.',
'muh.': 'm u.h.',
'M-L': 'm-l',
'm-l': 'm-l',
'm. a. o.': 'm.a.o.',
'm.a.o.': 'm.a.o.',
'm m': 'm.m.',
'm. m.': 'm.m.',
'm.m.': 'm.m.',
'm. o. t.': 'm.o.t.',
'm.o.t.': 'm.o.t.',
'm. p. p.': 'm.p.p.',
'm.p.p.': 'm.p.p.',
'mV': 'mV',
'mW': 'mW',
'mag.': 'mag.',
'Mag. Art.': 'mag.art.',
'Mag. art.': 'mag.art.',
'Mag.art': 'mag.art.',
'Mag.art.': 'mag.art.',
'mag. art.': 'mag.art.',
'mag.art': 'mag.art.',
'mag.art.': 'mag.art.',
'Mag. scient': 'mag.scient.',
'Mag.scient': 'mag.scient.',
'mag. scient': 'mag.scient.',
'mag. scient.': 'mag.scient.',
'mag.scient': 'mag.scient.',
'mag.scient.': 'mag.scient.',
'man': 'man',
'mang': 'mang',
'mangt': 'mang',
'mang ei': 'mang en',
'mang en': 'mang en',
'mangt et': 'mang en',
'mange slags': 'mange slags',
'mang en': 'mangt et',
'mannemellom': 'mannemellom',
'marsj': 'marsj',
'mask.': 'mask.',
'mb': 'mb',
'med': 'med',
'med mindre': 'med mindre',
'med.': 'med.',
'medsols': 'medsols',
'medstrøms': 'medstrøms',
'mek': 'mek.',
'mek.': 'mek.',
'mellom': 'mellom',
'men': 'men',
'mens': 'mens',
'm. fl': 'mfl.',
'm. fl.': 'mfl.',
'm.fl': 'mfl.',
'm.fl.': 'mfl.',
'mfl': 'mfl.',
'mfl.': 'mfl.',
'mg': 'mg',
'm. h. t.': 'mht.',
'm.h.t.': 'mht.',
'mht.': 'mht.',
'midtfjords': 'midtfjords',
'midtskips': 'midtskips',
'midtveges': 'midtveges',
'midtvegs': 'midtvegs',
'midtveis': 'midtveis',
'mill': 'mill.',
'mill.': 'mill.',
'mi': 'min',
'min': 'min',
'mine': 'min',
'mitt': 'min',
'mjau': 'mjau',
'ml': 'ml',
'mm': 'mm',
'mon': 'mon',
'mon tro': 'mon tro',
'mon tru': 'mon tru',
'morn': 'morn',
'mot': 'mot',
'mots': 'mots.',
'mots.': 'mots.',
'mrd': 'mrd.',
'mrd.': 'mrd.',
'ms': 'ms',
'mva': 'mva.',
'mva.': 'mva.',
'må hende': 'må hende',
'må vite': 'må vite',
'mø': 'mø',
'nam': 'nam',
'natura': 'natura',
'ned': 'ned',
'ned i': 'ned i',
'ned på': 'ned på',
'nedad': 'nedad',
'nedafor': 'nedafor',
'nedafra': 'nedafra',
'nedatil': 'nedatil',
'nede': 'nede',
'nedefra': 'nedefra',
'nedenfor': 'nedenfor',
'nedenfra': 'nedenfra',
'nedenifra': 'nedenifra',
'nedenom': 'nedenom',
'nedentil': 'nedentil',
'nedenunder': 'nedenunder',
'nedetter': 'nedetter',
'nedi': 'nedi',
'nedigjennom': 'nedigjennom',
'nedimot': 'nedimot',
'nedmed': 'nedmed',
'nedom': 'nedom',
'nedover': 'nedover',
'nedpå': 'nedpå',
'nedstrøms': 'nedstrøms',
'nedved': 'nedved',
'nei': 'nei',
'neste': 'neste',
'ng': 'ng',
'ni': 'ni',
'nitten': 'nitten',
'nitti': 'nitti',
'nja': 'nja',
'NOK': 'nkr',
'Nkr': 'nkr',
'Nkr.': 'nkr',
'nkr': 'nkr',
'nkr.': 'nkr',
'noe': 'noen',
'noen': 'noen',
'nord': 'nord',
'nord om': 'nord om',
'nordafjells': 'nordafjells',
'nordafor': 'nordafor',
'nordafra': 'nordafra',
'nordaust': 'nordaust',
'nordenfjells': 'nordenfjells',
'nordenfor': 'nordenfor',
'nordenfor': 'nordenfor',
'nordenfra': 'nordenfra',
'nordenom': 'nordenom',
'nordetter': 'nordetter',
'nordfra': 'nordfra',
'nordi': 'nordi',
'nordigjennom': 'nordigjennom',
'nordmed': 'nordmed',
'nordom': 'nordom',
'nordost': 'nordost',
'nordover': 'nordover',
'nordpå': 'nordpå',
'nordvest': 'nordvest',
'nordøst': 'nordøst',
'nr': 'nr.',
'nr.': 'nr.',
'null': 'null',
'nåda': 'nåda',
'nærme': 'nærme',
'nøff': 'nøff',
'nøff-nøff': 'nøff-nøff',
'o. a.': 'o.a.',
'o.a.': 'o.a.',
'o. h.': 'o.h.',
'o.h.': 'o.h.',
'o. l.': 'o.l.',
'o. lign.': 'o.l.',
'o. likn': 'o.l.',
'o.l.': 'o.l.',
'o.lign.': 'o.l.',
'o.likn': 'o.l.',
'o. m.': 'o.m.',
'o.m.': 'o.m.',
'o.m.a': 'o.m.a.',
'o.m.a.': 'o.m.a.',
'obs.': 'obs.',
'odont.': 'odont.',
'oecon.': 'oecon.',
'off': 'off.',
'o. fl': 'ofl.',
'o. fl.': 'ofl.',
'o.fl': 'ofl.',
'o.fl.': 'ofl.',
'ofl.': 'ofl.',
'og': 'og',
'oho': 'oho',
'ohoi': 'ohoi',
'oi': 'oi',
'okk': 'okk',
'om': 'om',
'om': 'om',
'om bord': 'om bord',
'om enn': 'om enn',
'om gangen': 'om gangen',
'om kapp': 'om kapp',
'om kull': 'om kull',
'om lag': 'om lag',
'om senn': 'om senn',
'omenskjønt': 'omenskjønt',
'omfram': 'omfram',
'omframt': 'omframt',
'omkr': 'omkr.',
'omkr.': 'omkr.',
'omkring': 'omkring',
'op': 'op.',
'op.': 'op.',
'op. cit.': 'op.cit.',
'op.cit.': 'op.cit.',
'opp': 'opp',
'opp i': 'opp i',
'opp imot': 'opp imot',
'opp mot': 'opp mot',
'opp på': 'opp på',
'opp til': 'opp til',
'oppe': 'oppe',
'oppetter': 'oppetter',
'oppfor': 'oppfor',
'oppi': 'oppi',
'oppigjennom': 'oppigjennom',
'oppimot': 'oppimot',
'oppmed': 'oppmed',
'oppom': 'oppom',
'oppover': 'oppover',
'opptil': 'opptil',
'oppunder': 'oppunder',
'oppved': 'oppved',
'oppå': 'oppå',
'o. s. fr.': 'osfr.',
'o.s.fr.': 'osfr.',
'osfr': 'osfr.',
'osfr.': 'osfr.',
'ost': 'ost',
'o. s. v.': 'osv.',
'o.s.v.': 'osv.',
'osv': 'osv.',
'osv.': 'osv.',
'Ot prp': 'ot.prp.',
'Ot. prp.': 'ot.prp.',
'Ot.prp.': 'ot.prp.',
'ot prp': 'ot.prp.',
'ot. prp.': 'ot.prp.',
'ot.prp.': 'ot.prp.',
'ovabords': 'ovabords',
'ovafor': 'ovafor',
'ovafra': 'ovafra',
'ovapå': 'ovapå',
'ovatil': 'ovatil',
'ovenbords': 'ovenbords',
'ovenfor': 'ovenfor',
'ovenfra': 'ovenfra',
'ovenom': 'ovenom',
'ovenpå': 'ovenpå',
'oventil': 'oventil',
'over': 'over',
'over bord': 'over bord',
'over ende': 'over ende',
'over kors': 'over kors',
'over lang': 'over lang',
'over skrevs': 'over skrevs',
'over styr': 'over styr',
'over tvert': 'over tvert',
'overfor': 'overfor',
'ovf': 'ovf.',
'ovf.': 'ovf.',
'p': 'p',
'p': 'p.',
'p.': 'p.',
'p a': 'p.a.',
'p. a.': 'p.a.',
'p.a.': 'p.a.',
'p. m.': 'p.m.',
'p.m.': 'p.m.',
'p. p.': 'p.p.',
'p.p.': 'p.p.',
'p. p. m.': 'p.p.m.',
'p.p.m.': 'p.p.m.',
'ppm.': 'p.p.m.',
'p r': 'p.r.',
'p. r.': 'p.r.',
'p.r.': 'p.r.',
'p.t.': 'p.t.',
'pa': 'pa.',
'pa.': 'pa.',
'paed.': 'paed.',
'paff': 'paff',
'passee': 'passé',
'passeere': 'passé',
'passeest': 'passé',
'passeeste': 'passé',
'passant': 'passant',
'per': 'per',
'pereat': 'pereat',
'pers': 'pers',
'pf.': 'pf.',
'p. g. a.': 'pga.',
'p.g.a.': 'pga.',
'pga': 'pga.',
'pga.': 'pga.',
'pharm.': 'pharm.',
'philol.': 'philol.',
'philos.': 'philos.',
'piff': 'piff',
'pinadø': 'pinadø',
'pinede': 'pinede',
'pinedød': 'pinedød',
'pip': 'pip',
'piskadausen': 'piskadausen',
'piskadød': 'piskadød',
'pist': 'pist',
'pl': 'pl.',
'pl.': 'pl.',
'plaff': 'plaff',
'plask': 'plask',
'pling': 'pling',
'plopp': 'plopp',
'plump': 'plump',
'polit.': 'polit.',
'post': 'post',
'poste restante': 'poste restante',
'pr': 'pr.',
'pr.': 'pr.',
'prep': 'prep.',
'prep.': 'prep.',
'pret': 'pret.',
'pret.': 'pret.',
'pro': 'pro',
'pron': 'pron.',
'pron.': 'pron.',
'prosit': 'prosit',
'prositt': 'prositt',
'prp': 'prp.',
'prp.': 'prp.',
'pst': 'pst',
'pst': 'pst.',
'pst.': 'pst.',
'psychol.': 'psychol.',
'ptro': 'ptro',
'ptro': 'ptro',
'puff': 'puff',
'puh': 'puh',
'puss': 'puss',
'pvrk': 'pvrk',
'pytt': 'pytt',
'på': 'på',
'pø': 'pø',
'pøh': 'pøh',
'q. e. d.': 'q.e.d.',
'q.e.d.': 'q.e.d.',
'q. s.': 'q.s.',
'q.s.': 'q.s.',
'qua': 'qua',
'quo vadis': 'quo vadis',
'quod erat demonstrandum': 'quod erat demonstrandum',
'rapp': 'rapp',
'ratsj': 'ratsj',
'real.': 'real.',
'rek.': 'rek.',
'renminbi': 'renminbi',
'Res.kap.': 'res.kap.',
'res.kap.': 'res.kap.',
'resp': 'resp.',
'resp.': 'resp.',
'ritsj': 'ritsj',
'rundt': 'rundt',
'rømmen': 'rømmen',
's a': 's.a.',
's. a.': 's.a.',
's.a.': 's.a.',
'S u': 's.u.',
'S. u.': 's.u.',
'S.u.': 's.u.',
'Su.': 's.u.',
's u': 's.u.',
's. u.': 's.u.',
's.u.': 's.u.',
'su.': 's.u.',
's å': 's.å.',
's. å.': 's.å.',
's.å.': 's.å.',
'salvo': 'salvo',
'samme': 'samme',
'sammesteds': 'sammesteds',
'sammestedsfra': 'sammestedsfra',
'samt': 'samt',
'samtlige': 'samtlige',
'sc': 'sc.',
'sc.': 'sc.',
'scient.': 'scient.',
'seg': 'seg',
'sek': 'sek',
'sek.': 'sek',
'seks': 'seks',
'seksten': 'seksten',
'seksti': 'seksti',
'selv': 'selv',
'selv om': 'selv om',
'selveste': 'selveste',
'sen.': 'sen.',
'sr': 'sen.',
'sr.': 'sen.',
'sen.': 'sen.',
'sesam': 'sesam',
'sg': 'sg.',
'sg.': 'sg.',
'sing': 'sg.',
'sing.': 'sg.',
'sg.': 'sg.',
'sidelangs': 'sidelangs',
'sign.': 'sign.',
'simsalabim': 'simsalabim',
'si': 'sin',
'sin': 'sin',
'sine': 'sin',
'sitt': 'sin',
'sing.': 'sing.',
'sing.': 'sing.',
'singott': 'singott',
'sistpå': 'sistpå',
'sju': 'sju',
'sjøl': 'sjøl',
'sjølveste': 'sjølveste',
'skjønt': 'skjønt',
'skål': 'skål',
'slik': 'slik',
'slike': 'slik',
'slikt': 'slik',
'snapp': 'snapp',
'snart': 'snart',
'snipp': 'snipp',
'som': 'som',
'somme': 'somme',
'sommesteds': 'sommesteds',
'somme': 'somt',
'somt': 'somt',
'sr.': 'sr.',
'sr.': 'sr.',
'st': 'st.',
'st.': 'st.',
'St prp': 'st.prp.',
'St. prp': 'st.prp.',
'St. prp.': 'st.prp.',
'St.prp.': 'st.prp.',
'st prp': 'st.prp.',
'st. prp.': 'st.prp.',
'st.prp.': 'st.prp.',
'stk': 'stk.',
'stk.': 'stk.',
'stud.': 'stud.',
'sturten': 'sturten',
'styrbord': 'styrbord',
'svupp': 'svupp',
'syd': 'syd',
'sydetter': 'sydetter',
'sydfra': 'sydfra',
'sydost': 'sydost',
'sydover': 'sydover',
'sydpå': 'sydpå',
'sydvest': 'sydvest',
'sydvest': 'sydvest',
'sytten': 'sytten',
'sytti': 'sytti',
'så framt': 'så framt',
'så fremt': 'så fremt',
'så menn': 'så menn',
'så nær som': 'så nær som',
'så sant': 'så sant',
'så som': 'så som',
'så vel som': 'så vel som',
'så vidt': 'så vidt',
'sådan': 'sådan',
'sådanne': 'sådan',
'sådant': 'sådan',
'såframt': 'såframt',
'såfremt': 'såfremt',
'sånn': 'sånn',
'sånne': 'sånn',
'sånt': 'sånn',
'sønna': 'sønna',
'sønnafjells': 'sønnafjells',
'sønnafor': 'sønnafor',
'sønnafra': 'sønnafra',
'sønnenfjells': 'sønnenfjells',
'sønnenfor': 'sønnenfor',
'sønnenfra': 'sønnenfra',
'sønnenom': 'sønnenom',
'sør': 'sør',
'søraust': 'søraust',
'søren': 'søren',
'søretter': 'søretter',
'sørfra': 'sørfra',
'sørover': 'sørover',
'sørpå': 'sørpå',
'sørvest': 'sørvest',
'sørvest': 'sørvest',
'sørøst': 'sørøst',
'søtten': 'søtten',
't d': 't.d.',
't. d.': 't.d.',
't.d.': 't.d.',
't. o. m.': 't.o.m.',
't.o.m.': 't.o.m.',
'tbc': 'tbc',
'ti': 'ti',
'tikk': 'tikk',
'tikk-takk': 'tikk-takk',
'til': 'til',
'til dels': 'til dels',
'til dømes': 'til dømes',
'til fals': 'til fals',
'til like': 'til like',
'til live': 'til live',
'til livs': 'til livs',
'til orde': 'til orde',
'til overs': 'til overs',
'til stede': 'til stede',
'tilbake': 'tilbake',
'tillikemed': 'tillikemed',
'tja': 'tja',
'tjo': 'tjo',
'tjue': 'tjue',
'to': 'to',
'tolv': 'tolv',
'tralala': 'tralala',
'trass': 'trass',
'tre': 'tre',
'tretten': 'tretten',
'tretti': 'tretti',
'triplo': 'triplo',
'tripp': 'tripp',
'trommelom': 'trommelom',
'tross': 'tross',
'tupp': 'tupp',
'tusen': 'tusen',
'tvi': 'tvi',
'tyss': 'tyss',
'tøff': 'tøff',
'uaktet': 'uaktet',
'uansett': 'uansett',
'uff': 'uff',
'ult.': 'ult.',
'ultimo': 'ultimo',
'undas': 'undas',
'under': 'under',
'under vær': 'under vær',
'undervegs': 'undervegs',
'underveis': 'underveis',
'unna': 'unna',
'unntagen': 'unntagen',
'unntatt': 'unntatt',
'ut': 'ut',
'ut av': 'ut av',
'ut i': 'ut i',
'ut over': 'ut over',
'ut på': 'ut på',
'utad': 'utad',
'utafor': 'utafor',
'utafra': 'utafra',
'utalands': 'utalands',
'utapå': 'utapå',
'utav': 'utav',
'ute': 'ute',
'utefra': 'utefra',
'uten': 'uten',
'utenfor': 'utenfor',
'utenfra': 'utenfra',
'utenlands': 'utenlands',
'utenom': 'utenom',
'utenpå': 'utenpå',
'utetter': 'utetter',
'utfor': 'utfor',
'uti': 'uti',
'utmed': 'utmed',
'utom': 'utom',
'utomhus': 'utomhus',
'utover': 'utover',
'utpå': 'utpå',
'utved': 'utved',
'v': 'v.',
'v.': 'v.',
'vn.': 'v.',
'van': 'van',
'varsku': 'varsku',
've': 've',
'ved': 'ved',
'ved like': 'ved like',
'veggimellom': 'veggimellom',
'vekk': 'vekk',
'vekke': 'vekke',
'verken': 'verken',
'versus': 'versus',
'vest': 'vest',
'vesta': 'vesta',
'vestafjells': 'vestafjells',
'vestafor': 'vestafor',
'vestafra': 'vestafra',
'vestenfjells': 'vestenfjells',
'vestenfor': 'vestenfor',
'vestenfra': 'vestenfra',
'vestenom': 'vestenom',
'vestfra': 'vestfra',
'vestover': 'vestover',
'vestpå': 'vestpå',
'vet.': 'vet.',
'oss': 'vi',
'vi': 'vi',
'via': 'via',
'vips': 'vips',
'vis-à-vis': 'vis-à-vis',
'Vit. Ass.': 'vit.ass.',
'Vit. ass.': 'vit.ass.',
'vit. ass.': 'vit.ass.',
'vit.ass.': 'vit.ass.',
'vivat': 'vivat',
'voff': 'voff',
'voff-voff': 'voff-voff',
'von': 'von',
'vov': 'vov',
'vov-vov': 'vov-vov',
'v. s. a.': 'vsa.',
'v.s.a.': 'vsa.',
'vsa': 'vsa.',
'vsa.': 'vsa.',
'vår': 'vår',
'våre': 'vår',
'vårt': 'vår',
'yd': 'yd',
'zero': 'zero',
'å': 'å',
'å': 'å',
'åhå': 'åhå',
'åt': 'åt',
'åtte': 'åtte',
'åtti': 'åtti',
'æ': 'æ',
'æsj': 'æsj',
'ørten': 'ørten',
'øst': 'øst',
'østa': 'østa',
'østafjells': 'østafjells',
'østafor': 'østafor',
'østafra': 'østafra',
'østenfjells': 'østenfjells',
'østenfor': 'østenfor',
'østenfra': 'østenfra',
'østenom': 'østenom',
'østetter': 'østetter',
'østetter': 'østetter',
'østfra': 'østfra',
'østfra': 'østfra',
'østover': 'østover',
'østover': 'østover',
'østpå': 'østpå',
'østpå': 'østpå',
'egen': 'egen',
'eget': 'egen',
'egne': 'egen',
'fersken': 'fersken',
'hvis': 'hvis',
'hvis': 'hvis',
'den': 'den',
'det': 'det',
'eder': 'eder',
'enøk': 'enøk',
'frå': 'frå',
'frå': 'frå',
'hundre og éi': 'hundre og én',
'hundre og én': 'hundre og én',
'hundre og étt': 'hundre og én',
'hverken': 'hverken',
'ifrå': 'ifrå',
'i mellomtida': 'i mellomtida',
'i mellomtiden': 'i mellomtiden',
'kille': 'kille',
'min': 'min',
'nere': 'nere',
'nerimot': 'nerimot',
'nere': 'nere',
'pang': 'pang',
'pardong': 'pardong',
'pro': 'pro',
'pro': 'pro',
'restante': 'restante',
'sin': 'sin',
'sjøl om': 'sjøl om',
'svibrent': 'svibrent',
'tan': 'tan',
'tjueei': 'tjueen',
'tjueen': 'tjueen',
'tjueett': 'tjueen',
'trapp': 'trapp',
'tredve': 'tredve',
'trom': 'trom',
'tvibrent': 'tvibrent',
'tyve': 'tyve',
'UHF': 'UHF',
'vilden': 'vilden',
'villen': 'villen',
'villen': 'villen',
'vilden': 'vilden',
'by': 'by',
'de': 'de',
'efter': 'efter',
'et': 'et',
'fyterakkern': 'fyterakkern',
'hi': 'hi',
'ho': 'ho',
'ho': 'ho',
'viss': 'viss',
'kynnerer': 'kynnerer',
'ner': 'ner',
'ner': 'ner',
'nå': 'nå',
'syv': 'syv',
'viss': 'viss',
'frå borde': 'frå borde',
'frå borde': 'frå borde',
'til og med': 'til og med',
'av': 'av',
'c': 'c',
'CD': 'CD',
'E': 'E',
'f': 'f',
'g': 'g',
'g.': 'g',
'gt': 'g',
'gt.': 'g',
'Mrs.': 'Mrs.',
'mrs.': 'Mrs.',
't': 't',
't.': 't',
'U': 'U',
'u': 'U',
'u': 'u',
'v': 'v',
'X': 'X',
'YAP': 'YAP',
'g': 'g',
'gr': 'g',
'gr.': 'g',
's': 's',
'hvems': 'hvems',
'i hu': 'i hu',
'd. s.': 'd.s.',
'd.s.': 'd.s.',
'm. v.': 'mv.',
'm.v.': 'mv.',
'mv': 'mv.',
'mv.': 'mv.',
'n': 'n.',
'n.': 'n.',
'dim.': 'dim.',
'ad-': 'ad-',
'kvitt': 'kvitt',
'innendørs': 'innendørs',
'utendørs': 'utendørs',
'siden': 'siden',
'C.': 'C.',
'M.': 'M.',
'noen': 'noen',
'noen': 'noen',
'begge': 'begge',
'enhver': 'enhver',
'ingen': 'ingen',
'ingen': 'ingen',
'intet': 'intet',
'hvilken': 'hvilken',
'somt': 'somt',
'somme': 'somme',
'u-': 'u-',
'ASA': 'ASA',
'laden': 'laden',
'varsko': 'varsko',
'ennskjønt': 'ennskjønt',
'omennskjønt': 'omennskjønt',
'jepp': 'jepp'
}
