# Changelog (Auto Generated by Claude Code)

## [1.7.2] - 2025-10-06

### Added
- **Agent Mode Support**: Added comprehensive agent mode functionality
  - New `stata-mcp --agent` command line option for interactive AI-driven analysis
  - `StataAgent` class with LangChain integration for AI-powered Stata operations
  - Support for GPT-5, DeepSeek, and other OpenAI-compatible models
  - ReAct (Reasoning + Acting) prompt template for enhanced AI reasoning
  - MultiServerMCPClient integration for seamless Stata command execution
  - Interactive workflow with data source and task input prompts
- **Agent Examples**: Added complete agent implementation examples
  - LangChain and LangGraph integration examples
  - OpenAI-based agent implementation
  - Advanced prompt generation system for agent tasks
  - Comprehensive documentation and README files
- **Agent Startup Script**: Added `agent.sh` automated startup script
  - Auto-detection of uv package manager with fallback to pip
  - Python 3.11+ version validation and environment checking
  - Interactive installation prompts for uv package manager
  - Automatic package installation and version validation
  - Seamless agent mode launch with proper error handling
  - Cross-platform compatibility with colored output for better UX

### Changed
- **Jupyter Dependencies**: Removed unused Jupyter-related dependencies from `pyproject.toml`
  - Commented out `jupyter-client>=8.6.3` and `stata-kernel>=1.12.2`
  - Commented out `notebook>=7.4.5` and `jupyter>=1.1.1`
  - Streamlined installation process and reduced package size
  - No impact on core Stata-MCP functionality

### Technical
- **Dependency Optimization**: Cleaned up unused dependencies for faster installation
- **Agent Mode Integration**: Enhanced CLI with agent mode support via `-a/--agent` flag
- **Version Update**: Updated version from 1.7.1 to 1.7.2

## [1.7.1] - 2025-10-05

### Changed
- **mk_dir Security**: Re-enabled `mk_dir` tool with enhanced security using pathvalidate library
  - Added comprehensive path validation and sanitization
  - Implemented secure directory creation with proper permissions (0o755)
  - Added detailed error handling for invalid paths and permission issues
  - Improved function documentation with comprehensive parameter descriptions

### Technical
- **Dependencies**: Added `pathvalidate>=3.3.1` for secure path validation
- **Version Update**: Updated version from 1.7.0 to 1.7.1


## [1.7.0] - 2025-10-4

### Added
- **AI-Assisted Research**: Added comprehensive AI-assisted empirical research report with latest findings
- **Prompt Engineering**: Introduced comprehensive task prompt guide and examples for better AI interaction
- **Template System**: Added prompt-generator template for standardized AI request formatting
- **Research Documentation**: Added detailed research report on StataMCP usage for social science research
- **Prompt Examples**: Added two practical examples for PromptGenerator usage
- **Load Figure**: Added `load_figure` functionality for image handling
- **Sandbox Infrastructure**: Added sandbox infrastructure for testing
- **Main Entry Point**: Added `main.py` entry point for local development
- **Multilingual Documentation**: Updated Chinese, French, and Spanish README files
- **Agent Mode Support**: Added agent mode support documentation
- **China Users Guide**: Added specialized documentation for China users
- **LLM Integration Guide**: Added comprehensive LLM documentation for AI integration

### Changed
- **MCP Protocol**: Upgraded MCP from version 1.14 to 1.15 for latest features
- **Module Naming**: Renamed `StataFinder` to `stata_finder` for snake_case consistency
- **Directory Structure**: Improved code organization with better directory structure
- **Contributing Guide**: Updated CONTRIBUTING.md documentation
- **Security Policy**: Enhanced security policy with comprehensive privacy disclaimer
- **Git Standards**: Updated CLAUDE.md with git push restrictions and standards
- **App Icon**: Updated app icon to higher resolution image
- **Project Dependencies**: Updated project dependencies and lock files

### Disabled (Commented Out)
- **Directory Creation**: `mk_dir` tool implemented but decorator commented out for safety considerations
- **Data Info Function**: `get_data_info` tool implemented but decorator commented out

### Fixed
- **ValueError Prevention**: Fixed default instructions setting to avoid ValueError
- **macOS Compatibility**: Fixed errors in StataFinder.macos
- **Citation Corrections**: Fixed citation mistakes in research documentation
- **Environment Configuration**: Fixed environment name errors in configuration
- **Debug Cleanup**: Removed leftover debug print statements

### Technical
- **Code Architecture**: Improved code organization and maintainability
- **Function Safety**: Temporarily disabled certain functions via decorator commenting for security
- **Development Environment**: Enhanced development environment setup
- **Data Info Stability**: Temporarily disabled `get_data_info` for stability considerations


## [1.6.3] - 2025-09-12

### Added
- **MCP Resource Support**: Added `@mcp.resource` decorator for `help` function with URI `help://stata/{cmd}`
- **AI Coding Ability Report**: Added comprehensive comparison chart of different AI models' Stata code generation capabilities in source documentation

### Changed
- **Dependency Upgrade**: Upgraded `mcp[cli]` from `>=1.9.0` to `>=1.13.0` for latest MCP protocol features
- **Version Updates**: Updated version numbers across all documentation files and CITATION.cff

### Technical
- **Enhanced MCP Support**: Improved MCP protocol compatibility with resource URI support

## [1.6.2] - 2025-08-15

### Changed
- **CLI Architecture**: Refactored CLI entry point from `__init__.py` to dedicated CLI module
  - Moved CLI functionality to `stata_mcp/cli/_cli.py`
  - Improved code modularity and separation of concerns
  - Updated entry point configuration in `pyproject.toml`
  - Enhanced maintainability following Python packaging best practices

### Technical
- **Code Organization**: Clean separation between package initialization and CLI execution
- **Entry Point**: Updated to use dedicated CLI module instead of `__init__.py`
- **Module Structure**: Reduced complexity in main module initialization

## [1.6.1] - 2025-08-09

### Fixed
- Fixed Excel file reading issue in `get_data_info` function by adding missing `openpyxl` dependency
- Resolved compatibility issues with Excel (.xlsx) file formats

### Added
- Added `openpyxl>=3.1.5` to project dependencies for Excel file support

### Security
- Updated license from MIT to Apache License 2.0 for better legal protection and compatibility

### Changed
- **License**: Migrated from MIT License to Apache License 2.0
  - Updated LICENSE file to Apache 2.0 full text
  - Updated all documentation files (README, README-cn, README-fr, README-sp)
  - Updated CITATION.cff license field
  - Updated pyproject.toml license field
  - Updated Statement.md in all languages (中文, English, Français)
  - Updated all license badges from MIT to Apache 2.0
  - Ensured consistent Apache 2.0 licensing across entire project

## [1.6.0] - 2025-06-28

### Added
- Initial release with core Stata-MCP functionality
- Support for regression analysis via LLM integration
- Multi-language documentation (English, Chinese, French, Spanish)
- PyPI package distribution
- Jupyter integration support
- Web UI interface
- Cross-platform support (macOS, Windows, Linux)

### Features
- Stata command execution via MCP protocol
- Data analysis automation
- Regression model building assistance
- Statistical output interpretation
- Code generation and debugging support