# Stata-MCP: A research report on AI-assisted empirical research

> Authors: [Tan, Song](https://www.sepinetam.com), & Feng, Muyao  
> Date: 2025-09-21  
> Keywords: AI; Social science research; Stata; Empirical Strategy  
> Paper Link: [download](https://reports.statamcp.com/202509/stata_mcp_a_research_report_on_ai_assisted_empirical_research.pdf)

## Abstract
Data analysis is central to social science research, yet technical barriers still limit efficiency. While Stata lowers the learning cost of coding, further simplification is possible. This study develops Stata-MCP to streamline coding via AI and promote automation in empirical work. Using the ReAct agent framework and a custom evaluation set, we systematically assess LLMs across key stages of empirical research. Results show: (1) LLMs perform well in Stata code generation and debugging; (2) models differ notably in econometric understanding and coding, with the Claude series leading; (3) whether LLMs can conduct empirical analysis independently remains open. We also identify two key technical bottlenecks: (1) improving context management and overcoming window limitations through engineering; (2) fine-tuning the ReAct framework to better align with the needs of social science research.


## Citation
```bibtex
@techreport{tan2025stataMCP,
  author = {Tan, Song and Feng, Muyao},
  title = {Stata-MCP: A research report on AI-assisted empirical research},
  year = {2025},
  month = {September},
  day = {21},
  language = {English},
  address = {Shanghai, China},
  institution = {Shanghai Bayes Views Information Technology Co., Ltd.},
  url = {https://www.statamcp.com/reports/2025/09/21/stata_mcp_a_research_report_on_ai_assisted_empirical_research}
}
```
