from pathlib import Path
from typing import Dict, Union

# Define types for better type hints
TokenCosts = Dict[str, float]
ModelPricing = Dict[str, Union[int, str, float]]

token_costs = {
    "sample_spec": {
        "max_tokens": "LEGACY parameter. set to max_output_tokens if provider specifies it. IF not set to max_input_tokens, if provider specifies it.",
        "max_input_tokens": "max input tokens, if the provider specifies it. if not default to max_tokens",
        "max_output_tokens": "max output tokens, if the provider specifies it. if not default to max_tokens",
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "output_cost_per_reasoning_token": 0.0,
        "litellm_provider": "one of https://docs.litellm.ai/docs/providers",
        "mode": "one of: chat, embedding, completion, image_generation, audio_transcription, audio_speech, image_generation, moderation, rerank",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": True,
        "supports_audio_input": True,
        "supports_audio_output": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_system_messages": True,
        "supports_reasoning": True,
        "supports_web_search": True,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.0,
            "search_context_size_medium": 0.0,
            "search_context_size_high": 0.0,
        },
        "supported_regions": [
            "global",
            "us-west-2",
            "eu-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
        ],
        "deprecation_date": "date when the model becomes deprecated in the format YYYY-MM-DD",
    },
    "omni-moderation-latest": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 0,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "openai",
        "mode": "moderation",
    },
    "omni-moderation-latest-intents": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 0,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "openai",
        "mode": "moderation",
    },
    "omni-moderation-2024-09-26": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 0,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "openai",
        "mode": "moderation",
    },
    "gpt-4": {
        "max_tokens": 4096,
        "max_input_tokens": 8192,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-05,
        "output_cost_per_token": 6e-05,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4.1": {
        "max_tokens": 32768,
        "max_input_tokens": 1047576,
        "max_output_tokens": 32768,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 8e-06,
        "input_cost_per_token_batches": 1e-06,
        "output_cost_per_token_batches": 4e-06,
        "cache_read_input_token_cost": 5e-07,
        "litellm_provider": "openai",
        "mode": "chat",
        "supported_endpoints": [
            "/v1/chat/completions",
            "/v1/batch",
            "/v1/responses",
        ],
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
        "supports_native_streaming": True,
    },
    "gpt-4.1-2025-04-14": {
        "max_tokens": 32768,
        "max_input_tokens": 1047576,
        "max_output_tokens": 32768,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 8e-06,
        "input_cost_per_token_batches": 1e-06,
        "output_cost_per_token_batches": 4e-06,
        "cache_read_input_token_cost": 5e-07,
        "litellm_provider": "openai",
        "mode": "chat",
        "supported_endpoints": [
            "/v1/chat/completions",
            "/v1/batch",
            "/v1/responses",
        ],
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
        "supports_native_streaming": True,
    },
    "gpt-4.1-mini": {
        "max_tokens": 32768,
        "max_input_tokens": 1047576,
        "max_output_tokens": 32768,
        "input_cost_per_token": 4e-07,
        "output_cost_per_token": 1.6e-06,
        "input_cost_per_token_batches": 2e-07,
        "output_cost_per_token_batches": 8e-07,
        "cache_read_input_token_cost": 1e-07,
        "litellm_provider": "openai",
        "mode": "chat",
        "supported_endpoints": [
            "/v1/chat/completions",
            "/v1/batch",
            "/v1/responses",
        ],
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
        "supports_native_streaming": True,
    },
    "gpt-4.1-mini-2025-04-14": {
        "max_tokens": 32768,
        "max_input_tokens": 1047576,
        "max_output_tokens": 32768,
        "input_cost_per_token": 4e-07,
        "output_cost_per_token": 1.6e-06,
        "input_cost_per_token_batches": 2e-07,
        "output_cost_per_token_batches": 8e-07,
        "cache_read_input_token_cost": 1e-07,
        "litellm_provider": "openai",
        "mode": "chat",
        "supported_endpoints": [
            "/v1/chat/completions",
            "/v1/batch",
            "/v1/responses",
        ],
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
        "supports_native_streaming": True,
    },
    "gpt-4.1-nano": {
        "max_tokens": 32768,
        "max_input_tokens": 1047576,
        "max_output_tokens": 32768,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 4e-07,
        "input_cost_per_token_batches": 5e-08,
        "output_cost_per_token_batches": 2e-07,
        "cache_read_input_token_cost": 2.5e-08,
        "litellm_provider": "openai",
        "mode": "chat",
        "supported_endpoints": [
            "/v1/chat/completions",
            "/v1/batch",
            "/v1/responses",
        ],
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
        "supports_native_streaming": True,
    },
    "gpt-4.1-nano-2025-04-14": {
        "max_tokens": 32768,
        "max_input_tokens": 1047576,
        "max_output_tokens": 32768,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 4e-07,
        "input_cost_per_token_batches": 5e-08,
        "output_cost_per_token_batches": 2e-07,
        "cache_read_input_token_cost": 2.5e-08,
        "litellm_provider": "openai",
        "mode": "chat",
        "supported_endpoints": [
            "/v1/chat/completions",
            "/v1/batch",
            "/v1/responses",
        ],
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
        "supports_native_streaming": True,
    },
    "gpt-4o": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "input_cost_per_token_batches": 1.25e-06,
        "output_cost_per_token_batches": 5e-06,
        "cache_read_input_token_cost": 1.25e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "watsonx/ibm/granite-3-8b-instruct": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 1024,
        "input_cost_per_token": 0.0002,
        "output_cost_per_token": 0.0002,
        "litellm_provider": "watsonx",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_parallel_function_calling": False,
        "supports_vision": False,
        "supports_audio_input": False,
        "supports_audio_output": False,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_system_messages": True,
    },
    "gpt-4o-search-preview-2025-03-11": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "input_cost_per_token_batches": 1.25e-06,
        "output_cost_per_token_batches": 5e-06,
        "cache_read_input_token_cost": 1.25e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4o-search-preview": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "input_cost_per_token_batches": 1.25e-06,
        "output_cost_per_token_batches": 5e-06,
        "cache_read_input_token_cost": 1.25e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
        "supports_web_search": True,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.03,
            "search_context_size_medium": 0.035,
            "search_context_size_high": 0.05,
        },
    },
    "gpt-4.5-preview": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 7.5e-05,
        "output_cost_per_token": 0.00015,
        "input_cost_per_token_batches": 3.75e-05,
        "output_cost_per_token_batches": 7.5e-05,
        "cache_read_input_token_cost": 3.75e-05,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4.5-preview-2025-02-27": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 7.5e-05,
        "output_cost_per_token": 0.00015,
        "input_cost_per_token_batches": 3.75e-05,
        "output_cost_per_token_batches": 7.5e-05,
        "cache_read_input_token_cost": 3.75e-05,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
        "deprecation_date": "2025-07-14",
    },
    "gpt-4o-audio-preview": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2.5e-06,
        "input_cost_per_audio_token": 0.0001,
        "output_cost_per_token": 1e-05,
        "output_cost_per_audio_token": 0.0002,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_audio_input": True,
        "supports_audio_output": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4o-audio-preview-2024-12-17": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2.5e-06,
        "input_cost_per_audio_token": 4e-05,
        "output_cost_per_token": 1e-05,
        "output_cost_per_audio_token": 8e-05,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_audio_input": True,
        "supports_audio_output": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4o-audio-preview-2024-10-01": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2.5e-06,
        "input_cost_per_audio_token": 0.0001,
        "output_cost_per_token": 1e-05,
        "output_cost_per_audio_token": 0.0002,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_audio_input": True,
        "supports_audio_output": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4o-audio-preview-2025-06-03": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2.5e-06,
        "input_cost_per_audio_token": 4.0e-5,
        "output_cost_per_token": 1e-05,
        "output_cost_per_audio_token": 8.0e-5,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_audio_input": True,
        "supports_audio_output": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4o-mini-audio-preview": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 1.5e-07,
        "input_cost_per_audio_token": 1e-05,
        "output_cost_per_token": 6e-07,
        "output_cost_per_audio_token": 2e-05,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_audio_input": True,
        "supports_audio_output": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4o-mini-audio-preview-2024-12-17": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 1.5e-07,
        "input_cost_per_audio_token": 1e-05,
        "output_cost_per_token": 6e-07,
        "output_cost_per_audio_token": 2e-05,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_audio_input": True,
        "supports_audio_output": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4o-mini": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 6e-07,
        "input_cost_per_token_batches": 7.5e-08,
        "output_cost_per_token_batches": 3e-07,
        "cache_read_input_token_cost": 7.5e-08,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4o-mini-search-preview-2025-03-11": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 6e-07,
        "input_cost_per_token_batches": 7.5e-08,
        "output_cost_per_token_batches": 3e-07,
        "cache_read_input_token_cost": 7.5e-08,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4o-mini-search-preview": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 6e-07,
        "input_cost_per_token_batches": 7.5e-08,
        "output_cost_per_token_batches": 3e-07,
        "cache_read_input_token_cost": 7.5e-08,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
        "supports_web_search": True,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.025,
            "search_context_size_medium": 0.0275,
            "search_context_size_high": 0.03,
        },
    },
    "gpt-4o-mini-2024-07-18": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 6e-07,
        "input_cost_per_token_batches": 7.5e-08,
        "output_cost_per_token_batches": 3e-07,
        "cache_read_input_token_cost": 7.5e-08,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
        "search_context_cost_per_query": {
            "search_context_size_low": 30.0,
            "search_context_size_medium": 35.0,
            "search_context_size_high": 50.0,
        },
    },
    "codex-mini-latest": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 1.5e-06,
        "output_cost_per_token": 6e-06,
        "cache_read_input_token_cost": 0.375e-06,
        "litellm_provider": "openai",
        "mode": "responses",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
        "supported_endpoints": ["/v1/responses"],
    },
    "o1-pro": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 0.00015,
        "output_cost_per_token": 0.0006,
        "input_cost_per_token_batches": 7.5e-05,
        "output_cost_per_token_batches": 0.0003,
        "litellm_provider": "openai",
        "mode": "responses",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "supports_native_streaming": False,
        "supports_reasoning": True,
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
        "supported_endpoints": ["/v1/responses", "/v1/batch"],
    },
    "o1-pro-2025-03-19": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 0.00015,
        "output_cost_per_token": 0.0006,
        "input_cost_per_token_batches": 7.5e-05,
        "output_cost_per_token_batches": 0.0003,
        "litellm_provider": "openai",
        "mode": "responses",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "supports_native_streaming": False,
        "supports_reasoning": True,
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
        "supported_endpoints": ["/v1/responses", "/v1/batch"],
    },
    "o1": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 6e-05,
        "cache_read_input_token_cost": 7.5e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_response_schema": True,
        "supports_reasoning": True,
        "supports_tool_choice": True,
    },
    "o1-mini": {
        "max_tokens": 65536,
        "max_input_tokens": 128000,
        "max_output_tokens": 65536,
        "input_cost_per_token": 1.1e-06,
        "output_cost_per_token": 4.4e-06,
        "cache_read_input_token_cost": 5.5e-07,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
    },
    "computer-use-preview": {
        "max_tokens": 1024,
        "max_input_tokens": 8192,
        "max_output_tokens": 1024,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.2e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supported_endpoints": ["/v1/responses"],
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": False,
        "supports_system_messages": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
    },
    "o3-pro": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 20e-06,
        "input_cost_per_token_batches": 10e-06,
        "output_cost_per_token_batches": 40e-06,
        "output_cost_per_token": 80e-06,
        "litellm_provider": "openai",
        "mode": "responses",
        "supports_function_calling": True,
        "supports_parallel_function_calling": False,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_reasoning": True,
        "supports_tool_choice": True,
        "supported_endpoints": ["/v1/responses", "/v1/batch"],
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
    },
    "o3-pro-2025-06-10": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 20e-06,
        "input_cost_per_token_batches": 10e-06,
        "output_cost_per_token_batches": 40e-06,
        "output_cost_per_token": 80e-06,
        "litellm_provider": "openai",
        "mode": "responses",
        "supports_function_calling": True,
        "supports_parallel_function_calling": False,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_reasoning": True,
        "supports_tool_choice": True,
        "supported_endpoints": ["/v1/responses", "/v1/batch"],
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
    },
    "o3": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 8e-06,
        "cache_read_input_token_cost": 0.5e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": False,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_reasoning": True,
        "supports_tool_choice": True,
        "supported_endpoints": [
            "/v1/responses",
            "/v1/chat/completions",
            "/v1/completions",
            "/v1/batch",
        ],
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
    },
    "o3-2025-04-16": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 8e-06,
        "cache_read_input_token_cost": 0.5e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": False,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_reasoning": True,
        "supports_tool_choice": True,
        "supported_endpoints": [
            "/v1/responses",
            "/v1/chat/completions",
            "/v1/completions",
            "/v1/batch",
        ],
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
    },
    "o3-mini": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 1.1e-06,
        "output_cost_per_token": 4.4e-06,
        "cache_read_input_token_cost": 5.5e-07,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": False,
        "supports_vision": False,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_reasoning": True,
        "supports_tool_choice": True,
    },
    "o3-mini-2025-01-31": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 1.1e-06,
        "output_cost_per_token": 4.4e-06,
        "cache_read_input_token_cost": 5.5e-07,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": False,
        "supports_vision": False,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_reasoning": True,
        "supports_tool_choice": True,
    },
    "o4-mini": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 1.1e-06,
        "output_cost_per_token": 4.4e-06,
        "cache_read_input_token_cost": 2.75e-07,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": False,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_reasoning": True,
        "supports_tool_choice": True,
    },
    "o4-mini-2025-04-16": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 1.1e-06,
        "output_cost_per_token": 4.4e-06,
        "cache_read_input_token_cost": 2.75e-07,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": False,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_reasoning": True,
        "supports_tool_choice": True,
    },
    "o1-mini-2024-09-12": {
        "max_tokens": 65536,
        "max_input_tokens": 128000,
        "max_output_tokens": 65536,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.2e-05,
        "cache_read_input_token_cost": 1.5e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_vision": True,
        "supports_reasoning": True,
        "supports_prompt_caching": True,
    },
    "o1-preview": {
        "max_tokens": 32768,
        "max_input_tokens": 128000,
        "max_output_tokens": 32768,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 6e-05,
        "cache_read_input_token_cost": 7.5e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_vision": True,
        "supports_reasoning": True,
        "supports_prompt_caching": True,
    },
    "o1-preview-2024-09-12": {
        "max_tokens": 32768,
        "max_input_tokens": 128000,
        "max_output_tokens": 32768,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 6e-05,
        "cache_read_input_token_cost": 7.5e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_vision": True,
        "supports_reasoning": True,
        "supports_prompt_caching": True,
    },
    "o1-2024-12-17": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 6e-05,
        "cache_read_input_token_cost": 7.5e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_response_schema": True,
        "supports_reasoning": True,
        "supports_tool_choice": True,
    },
    "chatgpt-4o-latest": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4o-2024-05-13": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5e-06,
        "output_cost_per_token": 1.5e-05,
        "input_cost_per_token_batches": 2.5e-06,
        "output_cost_per_token_batches": 7.5e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4o-2024-08-06": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "input_cost_per_token_batches": 1.25e-06,
        "output_cost_per_token_batches": 5e-06,
        "cache_read_input_token_cost": 1.25e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4o-2024-11-20": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "input_cost_per_token_batches": 1.25e-06,
        "output_cost_per_token_batches": 5e-06,
        "cache_read_input_token_cost": 1.25e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4o-realtime-preview-2024-10-01": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5e-06,
        "input_cost_per_audio_token": 0.0001,
        "cache_read_input_token_cost": 2.5e-06,
        "cache_creation_input_audio_token_cost": 2e-05,
        "output_cost_per_token": 2e-05,
        "output_cost_per_audio_token": 0.0002,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_audio_input": True,
        "supports_audio_output": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4o-realtime-preview": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5e-06,
        "input_cost_per_audio_token": 4e-05,
        "cache_read_input_token_cost": 2.5e-06,
        "output_cost_per_token": 2e-05,
        "output_cost_per_audio_token": 8e-05,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_audio_input": True,
        "supports_audio_output": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4o-realtime-preview-2024-12-17": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5e-06,
        "input_cost_per_audio_token": 4e-05,
        "cache_read_input_token_cost": 2.5e-06,
        "output_cost_per_token": 2e-05,
        "output_cost_per_audio_token": 8e-05,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_audio_input": True,
        "supports_audio_output": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4o-mini-realtime-preview": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 6e-07,
        "input_cost_per_audio_token": 1e-05,
        "cache_read_input_token_cost": 3e-07,
        "cache_creation_input_audio_token_cost": 3e-07,
        "output_cost_per_token": 2.4e-06,
        "output_cost_per_audio_token": 2e-05,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_audio_input": True,
        "supports_audio_output": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4o-mini-realtime-preview-2024-12-17": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 6e-07,
        "input_cost_per_audio_token": 1e-05,
        "cache_read_input_token_cost": 3e-07,
        "cache_creation_input_audio_token_cost": 3e-07,
        "output_cost_per_token": 2.4e-06,
        "output_cost_per_audio_token": 2e-05,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_audio_input": True,
        "supports_audio_output": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4-turbo-preview": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-05,
        "output_cost_per_token": 3e-05,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4-0314": {
        "max_tokens": 4096,
        "max_input_tokens": 8192,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-05,
        "output_cost_per_token": 6e-05,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4-0613": {
        "max_tokens": 4096,
        "max_input_tokens": 8192,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-05,
        "output_cost_per_token": 6e-05,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "deprecation_date": "2025-06-06",
        "supports_tool_choice": True,
    },
    "gpt-4-32k": {
        "max_tokens": 4096,
        "max_input_tokens": 32768,
        "max_output_tokens": 4096,
        "input_cost_per_token": 6e-05,
        "output_cost_per_token": 0.00012,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4-32k-0314": {
        "max_tokens": 4096,
        "max_input_tokens": 32768,
        "max_output_tokens": 4096,
        "input_cost_per_token": 6e-05,
        "output_cost_per_token": 0.00012,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4-32k-0613": {
        "max_tokens": 4096,
        "max_input_tokens": 32768,
        "max_output_tokens": 4096,
        "input_cost_per_token": 6e-05,
        "output_cost_per_token": 0.00012,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4-turbo": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-05,
        "output_cost_per_token": 3e-05,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4-turbo-2024-04-09": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-05,
        "output_cost_per_token": 3e-05,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4-1106-preview": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-05,
        "output_cost_per_token": 3e-05,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4-0125-preview": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-05,
        "output_cost_per_token": 3e-05,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-4-vision-preview": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-05,
        "output_cost_per_token": 3e-05,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "deprecation_date": "2024-12-06",
        "supports_tool_choice": True,
    },
    "gpt-4-1106-vision-preview": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-05,
        "output_cost_per_token": 3e-05,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "deprecation_date": "2024-12-06",
        "supports_tool_choice": True,
    },
    "gpt-3.5-turbo": {
        "max_tokens": 4097,
        "max_input_tokens": 16385,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-06,
        "output_cost_per_token": 2e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-3.5-turbo-0301": {
        "max_tokens": 4097,
        "max_input_tokens": 4097,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-06,
        "output_cost_per_token": 2e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-3.5-turbo-0613": {
        "max_tokens": 4097,
        "max_input_tokens": 4097,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-06,
        "output_cost_per_token": 2e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-3.5-turbo-1106": {
        "max_tokens": 16385,
        "max_input_tokens": 16385,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 2e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-3.5-turbo-0125": {
        "max_tokens": 16385,
        "max_input_tokens": 16385,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5e-07,
        "output_cost_per_token": 1.5e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-3.5-turbo-16k": {
        "max_tokens": 16385,
        "max_input_tokens": 16385,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 4e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "gpt-3.5-turbo-16k-0613": {
        "max_tokens": 16385,
        "max_input_tokens": 16385,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 4e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "ft:gpt-3.5-turbo": {
        "max_tokens": 4096,
        "max_input_tokens": 16385,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 6e-06,
        "input_cost_per_token_batches": 1.5e-06,
        "output_cost_per_token_batches": 3e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "ft:gpt-3.5-turbo-0125": {
        "max_tokens": 4096,
        "max_input_tokens": 16385,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 6e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "ft:gpt-3.5-turbo-1106": {
        "max_tokens": 4096,
        "max_input_tokens": 16385,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 6e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "ft:gpt-3.5-turbo-0613": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 6e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "ft:gpt-4-0613": {
        "max_tokens": 4096,
        "max_input_tokens": 8192,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-05,
        "output_cost_per_token": 6e-05,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "source": "OpenAI needs to add pricing for this ft model, will be updated when added by OpenAI. Defaulting to base model pricing",
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "ft:gpt-4o-2024-08-06": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 3.75e-06,
        "output_cost_per_token": 1.5e-05,
        "input_cost_per_token_batches": 1.875e-06,
        "output_cost_per_token_batches": 7.5e-06,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "ft:gpt-4o-2024-11-20": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 3.75e-06,
        "cache_creation_input_token_cost": 1.875e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "ft:gpt-4o-mini-2024-07-18": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 3e-07,
        "output_cost_per_token": 1.2e-06,
        "input_cost_per_token_batches": 1.5e-07,
        "output_cost_per_token_batches": 6e-07,
        "cache_read_input_token_cost": 1.5e-07,
        "litellm_provider": "openai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "ft:davinci-002": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 2e-06,
        "input_cost_per_token_batches": 1e-06,
        "output_cost_per_token_batches": 1e-06,
        "litellm_provider": "text-completion-openai",
        "mode": "completion",
    },
    "ft:babbage-002": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 4096,
        "input_cost_per_token": 4e-07,
        "output_cost_per_token": 4e-07,
        "input_cost_per_token_batches": 2e-07,
        "output_cost_per_token_batches": 2e-07,
        "litellm_provider": "text-completion-openai",
        "mode": "completion",
    },
    "text-embedding-3-large": {
        "max_tokens": 8191,
        "max_input_tokens": 8191,
        "output_vector_size": 3072,
        "input_cost_per_token": 1.3e-07,
        "output_cost_per_token": 0.0,
        "input_cost_per_token_batches": 6.5e-08,
        "output_cost_per_token_batches": 0.0,
        "litellm_provider": "openai",
        "mode": "embedding",
    },
    "text-embedding-3-small": {
        "max_tokens": 8191,
        "max_input_tokens": 8191,
        "output_vector_size": 1536,
        "input_cost_per_token": 2e-08,
        "output_cost_per_token": 0.0,
        "input_cost_per_token_batches": 1e-08,
        "output_cost_per_token_batches": 0.0,
        "litellm_provider": "openai",
        "mode": "embedding",
    },
    "text-embedding-ada-002": {
        "max_tokens": 8191,
        "max_input_tokens": 8191,
        "output_vector_size": 1536,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "openai",
        "mode": "embedding",
    },
    "text-embedding-ada-002-v2": {
        "max_tokens": 8191,
        "max_input_tokens": 8191,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0.0,
        "input_cost_per_token_batches": 5e-08,
        "output_cost_per_token_batches": 0.0,
        "litellm_provider": "openai",
        "mode": "embedding",
    },
    "text-moderation-stable": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 0,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "openai",
        "mode": "moderation",
    },
    "text-moderation-007": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 0,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "openai",
        "mode": "moderation",
    },
    "text-moderation-latest": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 0,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "openai",
        "mode": "moderation",
    },
    "256-x-256/dall-e-2": {
        "mode": "image_generation",
        "input_cost_per_pixel": 2.4414e-07,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "openai",
    },
    "512-x-512/dall-e-2": {
        "mode": "image_generation",
        "input_cost_per_pixel": 6.86e-08,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "openai",
    },
    "1024-x-1024/dall-e-2": {
        "mode": "image_generation",
        "input_cost_per_pixel": 1.9e-08,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "openai",
    },
    "hd/1024-x-1792/dall-e-3": {
        "mode": "image_generation",
        "input_cost_per_pixel": 6.539e-08,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "openai",
    },
    "hd/1792-x-1024/dall-e-3": {
        "mode": "image_generation",
        "input_cost_per_pixel": 6.539e-08,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "openai",
    },
    "hd/1024-x-1024/dall-e-3": {
        "mode": "image_generation",
        "input_cost_per_pixel": 7.629e-08,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "openai",
    },
    "standard/1024-x-1792/dall-e-3": {
        "mode": "image_generation",
        "input_cost_per_pixel": 4.359e-08,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "openai",
    },
    "standard/1792-x-1024/dall-e-3": {
        "mode": "image_generation",
        "input_cost_per_pixel": 4.359e-08,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "openai",
    },
    "standard/1024-x-1024/dall-e-3": {
        "mode": "image_generation",
        "input_cost_per_pixel": 3.81469e-08,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "openai",
    },
    "gpt-image-1": {
        "mode": "image_generation",
        "input_cost_per_pixel": 4.0054321e-08,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "openai",
        "supported_endpoints": ["/v1/images/generations"],
    },
    "low/1024-x-1024/gpt-image-1": {
        "mode": "image_generation",
        "input_cost_per_pixel": 1.0490417e-08,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "openai",
        "supported_endpoints": ["/v1/images/generations"],
    },
    "medium/1024-x-1024/gpt-image-1": {
        "mode": "image_generation",
        "input_cost_per_pixel": 4.0054321e-08,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "openai",
        "supported_endpoints": ["/v1/images/generations"],
    },
    "high/1024-x-1024/gpt-image-1": {
        "mode": "image_generation",
        "input_cost_per_pixel": 1.59263611e-07,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "openai",
        "supported_endpoints": ["/v1/images/generations"],
    },
    "low/1024-x-1536/gpt-image-1": {
        "mode": "image_generation",
        "input_cost_per_pixel": 1.0172526e-08,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "openai",
        "supported_endpoints": ["/v1/images/generations"],
    },
    "medium/1024-x-1536/gpt-image-1": {
        "mode": "image_generation",
        "input_cost_per_pixel": 4.0054321e-08,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "openai",
        "supported_endpoints": ["/v1/images/generations"],
    },
    "high/1024-x-1536/gpt-image-1": {
        "mode": "image_generation",
        "input_cost_per_pixel": 1.58945719e-07,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "openai",
        "supported_endpoints": ["/v1/images/generations"],
    },
    "low/1536-x-1024/gpt-image-1": {
        "mode": "image_generation",
        "input_cost_per_pixel": 1.0172526e-08,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "openai",
        "supported_endpoints": ["/v1/images/generations"],
    },
    "medium/1536-x-1024/gpt-image-1": {
        "mode": "image_generation",
        "input_cost_per_pixel": 4.0054321e-08,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "openai",
        "supported_endpoints": ["/v1/images/generations"],
    },
    "high/1536-x-1024/gpt-image-1": {
        "mode": "image_generation",
        "input_cost_per_pixel": 1.58945719e-07,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "openai",
        "supported_endpoints": ["/v1/images/generations"],
    },
    "gpt-4o-transcribe": {
        "mode": "audio_transcription",
        "max_input_tokens": 16000,
        "max_output_tokens": 2000,
        "input_cost_per_token": 2.5e-06,
        "input_cost_per_audio_token": 6e-06,
        "output_cost_per_token": 1e-05,
        "litellm_provider": "openai",
        "supported_endpoints": ["/v1/audio/transcriptions"],
    },
    "gpt-4o-mini-transcribe": {
        "mode": "audio_transcription",
        "max_input_tokens": 16000,
        "max_output_tokens": 2000,
        "input_cost_per_token": 1.25e-06,
        "input_cost_per_audio_token": 3e-06,
        "output_cost_per_token": 5e-06,
        "litellm_provider": "openai",
        "supported_endpoints": ["/v1/audio/transcriptions"],
    },
    "whisper-1": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.0001,
        "output_cost_per_second": 0.0001,
        "litellm_provider": "openai",
        "supported_endpoints": ["/v1/audio/transcriptions"],
    },
    "tts-1": {
        "mode": "audio_speech",
        "input_cost_per_character": 1.5e-05,
        "litellm_provider": "openai",
        "supported_endpoints": ["/v1/audio/speech"],
    },
    "tts-1-hd": {
        "mode": "audio_speech",
        "input_cost_per_character": 3e-05,
        "litellm_provider": "openai",
        "supported_endpoints": ["/v1/audio/speech"],
    },
    "gpt-4o-mini-tts": {
        "mode": "audio_speech",
        "input_cost_per_token": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "output_cost_per_audio_token": 1.2e-05,
        "output_cost_per_second": 0.00025,
        "litellm_provider": "openai",
        "supported_modalities": ["text", "audio"],
        "supported_output_modalities": ["audio"],
        "supported_endpoints": ["/v1/audio/speech"],
    },
    "azure/gpt-4o-mini-tts": {
        "mode": "audio_speech",
        "input_cost_per_token": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "output_cost_per_audio_token": 1.2e-05,
        "output_cost_per_second": 0.00025,
        "litellm_provider": "azure",
        "supported_modalities": ["text", "audio"],
        "supported_output_modalities": ["audio"],
        "supported_endpoints": ["/v1/audio/speech"],
    },
    "azure/computer-use-preview": {
        "max_tokens": 1024,
        "max_input_tokens": 8192,
        "max_output_tokens": 1024,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.2e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supported_endpoints": ["/v1/responses"],
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": False,
        "supports_system_messages": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
    },
    "azure/gpt-4o-audio-preview-2024-12-17": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2.5e-06,
        "input_cost_per_audio_token": 4e-05,
        "output_cost_per_token": 1e-05,
        "output_cost_per_audio_token": 8e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supported_endpoints": ["/v1/chat/completions"],
        "supported_modalities": ["text", "audio"],
        "supported_output_modalities": ["text", "audio"],
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": False,
        "supports_vision": False,
        "supports_prompt_caching": False,
        "supports_system_messages": True,
        "supports_tool_choice": True,
        "supports_native_streaming": True,
        "supports_reasoning": False,
    },
    "azure/gpt-4o-mini-audio-preview-2024-12-17": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2.5e-06,
        "input_cost_per_audio_token": 4e-05,
        "output_cost_per_token": 1e-05,
        "output_cost_per_audio_token": 8e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supported_endpoints": ["/v1/chat/completions"],
        "supported_modalities": ["text", "audio"],
        "supported_output_modalities": ["text", "audio"],
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": False,
        "supports_vision": False,
        "supports_prompt_caching": False,
        "supports_system_messages": True,
        "supports_tool_choice": True,
        "supports_native_streaming": True,
        "supports_reasoning": False,
    },
    "azure/gpt-4.1": {
        "max_tokens": 32768,
        "max_input_tokens": 1047576,
        "max_output_tokens": 32768,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 8e-06,
        "input_cost_per_token_batches": 1e-06,
        "output_cost_per_token_batches": 4e-06,
        "cache_read_input_token_cost": 5e-07,
        "litellm_provider": "azure",
        "mode": "chat",
        "supported_endpoints": [
            "/v1/chat/completions",
            "/v1/batch",
            "/v1/responses",
        ],
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
        "supports_native_streaming": True,
        "supports_web_search": True,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.03,
            "search_context_size_medium": 0.035,
            "search_context_size_high": 0.05,
        },
    },
    "azure/gpt-4.1-2025-04-14": {
        "max_tokens": 32768,
        "max_input_tokens": 1047576,
        "max_output_tokens": 32768,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 8e-06,
        "input_cost_per_token_batches": 1e-06,
        "output_cost_per_token_batches": 4e-06,
        "cache_read_input_token_cost": 5e-07,
        "litellm_provider": "azure",
        "mode": "chat",
        "supported_endpoints": [
            "/v1/chat/completions",
            "/v1/batch",
            "/v1/responses",
        ],
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
        "supports_native_streaming": True,
        "supports_web_search": True,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.03,
            "search_context_size_medium": 0.035,
            "search_context_size_high": 0.05,
        },
    },
    "azure/gpt-4.1-mini": {
        "max_tokens": 32768,
        "max_input_tokens": 1047576,
        "max_output_tokens": 32768,
        "input_cost_per_token": 4e-07,
        "output_cost_per_token": 1.6e-06,
        "input_cost_per_token_batches": 2e-07,
        "output_cost_per_token_batches": 8e-07,
        "cache_read_input_token_cost": 1e-07,
        "litellm_provider": "azure",
        "mode": "chat",
        "supported_endpoints": [
            "/v1/chat/completions",
            "/v1/batch",
            "/v1/responses",
        ],
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
        "supports_native_streaming": True,
        "supports_web_search": True,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.025,
            "search_context_size_medium": 0.0275,
            "search_context_size_high": 0.03,
        },
    },
    "azure/gpt-4.1-mini-2025-04-14": {
        "max_tokens": 32768,
        "max_input_tokens": 1047576,
        "max_output_tokens": 32768,
        "input_cost_per_token": 4e-07,
        "output_cost_per_token": 1.6e-06,
        "input_cost_per_token_batches": 2e-07,
        "output_cost_per_token_batches": 8e-07,
        "cache_read_input_token_cost": 1e-07,
        "litellm_provider": "azure",
        "mode": "chat",
        "supported_endpoints": [
            "/v1/chat/completions",
            "/v1/batch",
            "/v1/responses",
        ],
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
        "supports_native_streaming": True,
        "supports_web_search": True,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.025,
            "search_context_size_medium": 0.0275,
            "search_context_size_high": 0.03,
        },
    },
    "azure/gpt-4.1-nano": {
        "max_tokens": 32768,
        "max_input_tokens": 1047576,
        "max_output_tokens": 32768,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 4e-07,
        "input_cost_per_token_batches": 5e-08,
        "output_cost_per_token_batches": 2e-07,
        "cache_read_input_token_cost": 2.5e-08,
        "litellm_provider": "azure",
        "mode": "chat",
        "supported_endpoints": [
            "/v1/chat/completions",
            "/v1/batch",
            "/v1/responses",
        ],
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
        "supports_native_streaming": True,
    },
    "azure/gpt-4.1-nano-2025-04-14": {
        "max_tokens": 32768,
        "max_input_tokens": 1047576,
        "max_output_tokens": 32768,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 4e-07,
        "input_cost_per_token_batches": 5e-08,
        "output_cost_per_token_batches": 2e-07,
        "cache_read_input_token_cost": 2.5e-08,
        "litellm_provider": "azure",
        "mode": "chat",
        "supported_endpoints": [
            "/v1/chat/completions",
            "/v1/batch",
            "/v1/responses",
        ],
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
        "supports_native_streaming": True,
    },
    "azure/o3": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 1e-05,
        "output_cost_per_token": 4e-05,
        "cache_read_input_token_cost": 2.5e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supported_endpoints": [
            "/v1/chat/completions",
            "/v1/batch",
            "/v1/responses",
        ],
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
        "supports_function_calling": True,
        "supports_parallel_function_calling": False,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_reasoning": True,
        "supports_tool_choice": True,
    },
    "azure/o3-2025-04-16": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 1e-05,
        "output_cost_per_token": 4e-05,
        "cache_read_input_token_cost": 2.5e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supported_endpoints": [
            "/v1/chat/completions",
            "/v1/batch",
            "/v1/responses",
        ],
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
        "supports_function_calling": True,
        "supports_parallel_function_calling": False,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_reasoning": True,
        "supports_tool_choice": True,
    },
    "azure/o4-mini": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 1.1e-06,
        "output_cost_per_token": 4.4e-06,
        "cache_read_input_token_cost": 2.75e-07,
        "litellm_provider": "azure",
        "mode": "chat",
        "supported_endpoints": [
            "/v1/chat/completions",
            "/v1/batch",
            "/v1/responses",
        ],
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
        "supports_function_calling": True,
        "supports_parallel_function_calling": False,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_reasoning": True,
        "supports_tool_choice": True,
    },
    "azure/gpt-4o-mini-realtime-preview-2024-12-17": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 6e-07,
        "input_cost_per_audio_token": 1e-05,
        "cache_read_input_token_cost": 3e-07,
        "cache_creation_input_audio_token_cost": 3e-07,
        "output_cost_per_token": 2.4e-06,
        "output_cost_per_audio_token": 2e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_audio_input": True,
        "supports_audio_output": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "azure/eu/gpt-4o-mini-realtime-preview-2024-12-17": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 6.6e-07,
        "input_cost_per_audio_token": 1.1e-05,
        "cache_read_input_token_cost": 3.3e-07,
        "cache_creation_input_audio_token_cost": 3.3e-07,
        "output_cost_per_token": 2.64e-06,
        "output_cost_per_audio_token": 2.2e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_audio_input": True,
        "supports_audio_output": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "azure/us/gpt-4o-mini-realtime-preview-2024-12-17": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 6.6e-07,
        "input_cost_per_audio_token": 1.1e-05,
        "cache_read_input_token_cost": 3.3e-07,
        "cache_creation_input_audio_token_cost": 3.3e-07,
        "output_cost_per_token": 2.64e-06,
        "output_cost_per_audio_token": 2.2e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_audio_input": True,
        "supports_audio_output": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "azure/gpt-4o-realtime-preview-2024-12-17": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5e-06,
        "input_cost_per_audio_token": 4e-05,
        "cache_read_input_token_cost": 2.5e-06,
        "output_cost_per_token": 2e-05,
        "output_cost_per_audio_token": 8e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supported_modalities": ["text", "audio"],
        "supported_output_modalities": ["text", "audio"],
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_audio_input": True,
        "supports_audio_output": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "azure/us/gpt-4o-realtime-preview-2024-12-17": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5.5e-06,
        "input_cost_per_audio_token": 4.4e-05,
        "cache_read_input_token_cost": 2.75e-06,
        "cache_read_input_audio_token_cost": 2.5e-06,
        "output_cost_per_token": 2.2e-05,
        "output_cost_per_audio_token": 8e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supported_modalities": ["text", "audio"],
        "supported_output_modalities": ["text", "audio"],
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_audio_input": True,
        "supports_audio_output": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "azure/eu/gpt-4o-realtime-preview-2024-12-17": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5.5e-06,
        "input_cost_per_audio_token": 4.4e-05,
        "cache_read_input_token_cost": 2.75e-06,
        "cache_read_input_audio_token_cost": 2.5e-06,
        "output_cost_per_token": 2.2e-05,
        "output_cost_per_audio_token": 8e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supported_modalities": ["text", "audio"],
        "supported_output_modalities": ["text", "audio"],
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_audio_input": True,
        "supports_audio_output": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "azure/gpt-4o-realtime-preview-2024-10-01": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5e-06,
        "input_cost_per_audio_token": 0.0001,
        "cache_read_input_token_cost": 2.5e-06,
        "cache_creation_input_audio_token_cost": 2e-05,
        "output_cost_per_token": 2e-05,
        "output_cost_per_audio_token": 0.0002,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_audio_input": True,
        "supports_audio_output": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "azure/us/gpt-4o-realtime-preview-2024-10-01": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5.5e-06,
        "input_cost_per_audio_token": 0.00011,
        "cache_read_input_token_cost": 2.75e-06,
        "cache_creation_input_audio_token_cost": 2.2e-05,
        "output_cost_per_token": 2.2e-05,
        "output_cost_per_audio_token": 0.00022,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_audio_input": True,
        "supports_audio_output": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "azure/eu/gpt-4o-realtime-preview-2024-10-01": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5.5e-06,
        "input_cost_per_audio_token": 0.00011,
        "cache_read_input_token_cost": 2.75e-06,
        "cache_creation_input_audio_token_cost": 2.2e-05,
        "output_cost_per_token": 2.2e-05,
        "output_cost_per_audio_token": 0.00022,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_audio_input": True,
        "supports_audio_output": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "azure/o4-mini-2025-04-16": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 1.1e-06,
        "output_cost_per_token": 4.4e-06,
        "cache_read_input_token_cost": 2.75e-07,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": False,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_reasoning": True,
        "supports_tool_choice": True,
    },
    "azure/o3-mini-2025-01-31": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 1.1e-06,
        "output_cost_per_token": 4.4e-06,
        "cache_read_input_token_cost": 5.5e-07,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_reasoning": True,
        "supports_vision": False,
        "supports_prompt_caching": True,
        "supports_tool_choice": True,
    },
    "azure/us/o3-mini-2025-01-31": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 1.21e-06,
        "input_cost_per_token_batches": 6.05e-07,
        "output_cost_per_token": 4.84e-06,
        "output_cost_per_token_batches": 2.42e-06,
        "cache_read_input_token_cost": 6.05e-07,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_vision": False,
        "supports_reasoning": True,
        "supports_prompt_caching": True,
        "supports_tool_choice": True,
    },
    "azure/eu/o3-mini-2025-01-31": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 1.21e-06,
        "input_cost_per_token_batches": 6.05e-07,
        "output_cost_per_token": 4.84e-06,
        "output_cost_per_token_batches": 2.42e-06,
        "cache_read_input_token_cost": 6.05e-07,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_vision": False,
        "supports_reasoning": True,
        "supports_prompt_caching": True,
        "supports_tool_choice": True,
    },
    "azure/tts-1": {
        "mode": "audio_speech",
        "input_cost_per_character": 1.5e-05,
        "litellm_provider": "azure",
    },
    "azure/tts-1-hd": {
        "mode": "audio_speech",
        "input_cost_per_character": 3e-05,
        "litellm_provider": "azure",
    },
    "azure/whisper-1": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.0001,
        "output_cost_per_second": 0.0001,
        "litellm_provider": "azure",
    },
    "azure/gpt-4o-transcribe": {
        "mode": "audio_transcription",
        "max_input_tokens": 16000,
        "max_output_tokens": 2000,
        "input_cost_per_token": 2.5e-06,
        "input_cost_per_audio_token": 6e-06,
        "output_cost_per_token": 1e-05,
        "litellm_provider": "azure",
        "supported_endpoints": ["/v1/audio/transcriptions"],
    },
    "azure/gpt-4o-mini-transcribe": {
        "mode": "audio_transcription",
        "max_input_tokens": 16000,
        "max_output_tokens": 2000,
        "input_cost_per_token": 1.25e-06,
        "input_cost_per_audio_token": 3e-06,
        "output_cost_per_token": 5e-06,
        "litellm_provider": "azure",
        "supported_endpoints": ["/v1/audio/transcriptions"],
    },
    "azure/o3-mini": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 1.1e-06,
        "output_cost_per_token": 4.4e-06,
        "cache_read_input_token_cost": 5.5e-07,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_vision": False,
        "supports_prompt_caching": True,
        "supports_reasoning": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
    },
    "azure/o1-mini": {
        "max_tokens": 65536,
        "max_input_tokens": 128000,
        "max_output_tokens": 65536,
        "input_cost_per_token": 1.21e-06,
        "output_cost_per_token": 4.84e-06,
        "cache_read_input_token_cost": 6.05e-07,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": False,
        "supports_reasoning": True,
        "supports_prompt_caching": True,
    },
    "azure/o1-mini-2024-09-12": {
        "max_tokens": 65536,
        "max_input_tokens": 128000,
        "max_output_tokens": 65536,
        "input_cost_per_token": 1.1e-06,
        "output_cost_per_token": 4.4e-06,
        "cache_read_input_token_cost": 5.5e-07,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": False,
        "supports_reasoning": True,
        "supports_prompt_caching": True,
    },
    "azure/us/o1-mini-2024-09-12": {
        "max_tokens": 65536,
        "max_input_tokens": 128000,
        "max_output_tokens": 65536,
        "input_cost_per_token": 1.21e-06,
        "input_cost_per_token_batches": 6.05e-07,
        "output_cost_per_token": 4.84e-06,
        "output_cost_per_token_batches": 2.42e-06,
        "cache_read_input_token_cost": 6.05e-07,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": False,
        "supports_prompt_caching": True,
    },
    "azure/eu/o1-mini-2024-09-12": {
        "max_tokens": 65536,
        "max_input_tokens": 128000,
        "max_output_tokens": 65536,
        "input_cost_per_token": 1.21e-06,
        "input_cost_per_token_batches": 6.05e-07,
        "output_cost_per_token": 4.84e-06,
        "output_cost_per_token_batches": 2.42e-06,
        "cache_read_input_token_cost": 6.05e-07,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": False,
        "supports_prompt_caching": True,
    },
    "azure/o1": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 6e-05,
        "cache_read_input_token_cost": 7.5e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": True,
        "supports_reasoning": True,
        "supports_prompt_caching": True,
        "supports_tool_choice": True,
    },
    "azure/o1-2024-12-17": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 6e-05,
        "cache_read_input_token_cost": 7.5e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": True,
        "supports_reasoning": True,
        "supports_prompt_caching": True,
        "supports_tool_choice": True,
    },
    "azure/us/o1-2024-12-17": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 1.65e-05,
        "output_cost_per_token": 6.6e-05,
        "cache_read_input_token_cost": 8.25e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_tool_choice": True,
    },
    "azure/eu/o1-2024-12-17": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 1.65e-05,
        "output_cost_per_token": 6.6e-05,
        "cache_read_input_token_cost": 8.25e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_tool_choice": True,
    },
    "azure/codex-mini-latest": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 1.5e-06,
        "output_cost_per_token": 6e-06,
        "cache_read_input_token_cost": 0.375e-06,
        "litellm_provider": "azure",
        "mode": "responses",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
        "supported_endpoints": ["/v1/responses"],
    },
    "azure/o1-preview": {
        "max_tokens": 32768,
        "max_input_tokens": 128000,
        "max_output_tokens": 32768,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 6e-05,
        "cache_read_input_token_cost": 7.5e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": False,
        "supports_reasoning": True,
        "supports_prompt_caching": True,
    },
    "azure/o1-preview-2024-09-12": {
        "max_tokens": 32768,
        "max_input_tokens": 128000,
        "max_output_tokens": 32768,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 6e-05,
        "cache_read_input_token_cost": 7.5e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": False,
        "supports_reasoning": True,
        "supports_prompt_caching": True,
    },
    "azure/us/o1-preview-2024-09-12": {
        "max_tokens": 32768,
        "max_input_tokens": 128000,
        "max_output_tokens": 32768,
        "input_cost_per_token": 1.65e-05,
        "output_cost_per_token": 6.6e-05,
        "cache_read_input_token_cost": 8.25e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": False,
        "supports_prompt_caching": True,
    },
    "azure/eu/o1-preview-2024-09-12": {
        "max_tokens": 32768,
        "max_input_tokens": 128000,
        "max_output_tokens": 32768,
        "input_cost_per_token": 1.65e-05,
        "output_cost_per_token": 6.6e-05,
        "cache_read_input_token_cost": 8.25e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": False,
        "supports_prompt_caching": True,
    },
    "azure/gpt-4.5-preview": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 7.5e-05,
        "output_cost_per_token": 0.00015,
        "input_cost_per_token_batches": 3.75e-05,
        "output_cost_per_token_batches": 7.5e-05,
        "cache_read_input_token_cost": 3.75e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_tool_choice": True,
    },
    "azure/gpt-4o": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "cache_read_input_token_cost": 1.25e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_tool_choice": True,
    },
    "azure/global/gpt-4o-2024-11-20": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "cache_read_input_token_cost": 1.25e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_tool_choice": True,
    },
    "azure/gpt-4o-2024-08-06": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "cache_read_input_token_cost": 1.25e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_tool_choice": True,
    },
    "azure/global/gpt-4o-2024-08-06": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "cache_read_input_token_cost": 1.25e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_tool_choice": True,
    },
    "azure/gpt-4o-2024-11-20": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2.75e-06,
        "output_cost_per_token": 1.1e-05,
        "cache_read_input_token_cost": 1.25e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_tool_choice": True,
    },
    "azure/us/gpt-4o-2024-11-20": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2.75e-06,
        "cache_creation_input_token_cost": 1.38e-06,
        "output_cost_per_token": 1.1e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_tool_choice": True,
    },
    "azure/eu/gpt-4o-2024-11-20": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2.75e-06,
        "cache_creation_input_token_cost": 1.38e-06,
        "output_cost_per_token": 1.1e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_tool_choice": True,
    },
    "azure/gpt-4o-2024-05-13": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_tool_choice": True,
    },
    "azure/global-standard/gpt-4o-2024-08-06": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "cache_read_input_token_cost": 1.25e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_tool_choice": True,
        "deprecation_date": "2025-08-20",
    },
    "azure/us/gpt-4o-2024-08-06": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2.75e-06,
        "output_cost_per_token": 1.1e-05,
        "cache_read_input_token_cost": 1.375e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_tool_choice": True,
    },
    "azure/eu/gpt-4o-2024-08-06": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2.75e-06,
        "output_cost_per_token": 1.1e-05,
        "cache_read_input_token_cost": 1.375e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_tool_choice": True,
    },
    "azure/global-standard/gpt-4o-2024-11-20": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "cache_read_input_token_cost": 1.25e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_tool_choice": True,
        "deprecation_date": "2025-12-20",
    },
    "azure/global-standard/gpt-4o-mini": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_tool_choice": True,
    },
    "azure/gpt-4o-mini": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 1.65e-07,
        "output_cost_per_token": 6.6e-07,
        "cache_read_input_token_cost": 7.5e-08,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_tool_choice": True,
    },
    "azure/gpt-4o-mini-2024-07-18": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 1.65e-07,
        "output_cost_per_token": 6.6e-07,
        "cache_read_input_token_cost": 7.5e-08,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_tool_choice": True,
    },
    "azure/us/gpt-4o-mini-2024-07-18": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 1.65e-07,
        "output_cost_per_token": 6.6e-07,
        "cache_read_input_token_cost": 8.3e-08,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_tool_choice": True,
    },
    "azure/eu/gpt-4o-mini-2024-07-18": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 1.65e-07,
        "output_cost_per_token": 6.6e-07,
        "cache_read_input_token_cost": 8.3e-08,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_tool_choice": True,
    },
    "azure/gpt-4-turbo-2024-04-09": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-05,
        "output_cost_per_token": 3e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": True,
        "supports_tool_choice": True,
    },
    "azure/gpt-4-0125-preview": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-05,
        "output_cost_per_token": 3e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_tool_choice": True,
    },
    "azure/gpt-4-1106-preview": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-05,
        "output_cost_per_token": 3e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_tool_choice": True,
    },
    "azure/gpt-4-0613": {
        "max_tokens": 4096,
        "max_input_tokens": 8192,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-05,
        "output_cost_per_token": 6e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "azure/gpt-4-32k-0613": {
        "max_tokens": 4096,
        "max_input_tokens": 32768,
        "max_output_tokens": 4096,
        "input_cost_per_token": 6e-05,
        "output_cost_per_token": 0.00012,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "azure/gpt-4-32k": {
        "max_tokens": 4096,
        "max_input_tokens": 32768,
        "max_output_tokens": 4096,
        "input_cost_per_token": 6e-05,
        "output_cost_per_token": 0.00012,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "azure/gpt-4": {
        "max_tokens": 4096,
        "max_input_tokens": 8192,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-05,
        "output_cost_per_token": 6e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "azure/gpt-4-turbo": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-05,
        "output_cost_per_token": 3e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_tool_choice": True,
    },
    "azure/gpt-4-turbo-vision-preview": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-05,
        "output_cost_per_token": 3e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_vision": True,
        "supports_tool_choice": True,
    },
    "azure/gpt-35-turbo-16k-0613": {
        "max_tokens": 4096,
        "max_input_tokens": 16385,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 4e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "azure/gpt-35-turbo-1106": {
        "max_tokens": 4096,
        "max_input_tokens": 16384,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 2e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "deprecation_date": "2025-03-31",
        "supports_tool_choice": True,
    },
    "azure/gpt-35-turbo-0613": {
        "max_tokens": 4097,
        "max_input_tokens": 4097,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-06,
        "output_cost_per_token": 2e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "deprecation_date": "2025-02-13",
        "supports_tool_choice": True,
    },
    "azure/gpt-35-turbo-0301": {
        "max_tokens": 4097,
        "max_input_tokens": 4097,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 2e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "deprecation_date": "2025-02-13",
        "supports_tool_choice": True,
    },
    "azure/gpt-35-turbo-0125": {
        "max_tokens": 4096,
        "max_input_tokens": 16384,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5e-07,
        "output_cost_per_token": 1.5e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "deprecation_date": "2025-05-31",
        "supports_tool_choice": True,
    },
    "azure/gpt-3.5-turbo-0125": {
        "max_tokens": 4096,
        "max_input_tokens": 16384,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5e-07,
        "output_cost_per_token": 1.5e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "deprecation_date": "2025-03-31",
        "supports_tool_choice": True,
    },
    "azure/gpt-35-turbo-16k": {
        "max_tokens": 4096,
        "max_input_tokens": 16385,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 4e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "azure/gpt-35-turbo": {
        "max_tokens": 4096,
        "max_input_tokens": 4097,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5e-07,
        "output_cost_per_token": 1.5e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "azure/gpt-3.5-turbo": {
        "max_tokens": 4096,
        "max_input_tokens": 4097,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5e-07,
        "output_cost_per_token": 1.5e-06,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "azure/gpt-3.5-turbo-instruct-0914": {
        "max_tokens": 4097,
        "max_input_tokens": 4097,
        "input_cost_per_token": 1.5e-06,
        "output_cost_per_token": 2e-06,
        "litellm_provider": "azure_text",
        "mode": "completion",
    },
    "azure/gpt-35-turbo-instruct": {
        "max_tokens": 4097,
        "max_input_tokens": 4097,
        "input_cost_per_token": 1.5e-06,
        "output_cost_per_token": 2e-06,
        "litellm_provider": "azure_text",
        "mode": "completion",
    },
    "azure/gpt-35-turbo-instruct-0914": {
        "max_tokens": 4097,
        "max_input_tokens": 4097,
        "input_cost_per_token": 1.5e-06,
        "output_cost_per_token": 2e-06,
        "litellm_provider": "azure_text",
        "mode": "completion",
    },
    "azure/mistral-large-latest": {
        "max_tokens": 32000,
        "max_input_tokens": 32000,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
    },
    "azure/mistral-large-2402": {
        "max_tokens": 32000,
        "max_input_tokens": 32000,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
    },
    "azure/command-r-plus": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "azure",
        "mode": "chat",
        "supports_function_calling": True,
    },
    "azure/ada": {
        "max_tokens": 8191,
        "max_input_tokens": 8191,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "azure",
        "mode": "embedding",
    },
    "azure/text-embedding-ada-002": {
        "max_tokens": 8191,
        "max_input_tokens": 8191,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "azure",
        "mode": "embedding",
    },
    "azure/text-embedding-3-large": {
        "max_tokens": 8191,
        "max_input_tokens": 8191,
        "input_cost_per_token": 1.3e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "azure",
        "mode": "embedding",
    },
    "azure/text-embedding-3-small": {
        "max_tokens": 8191,
        "max_input_tokens": 8191,
        "input_cost_per_token": 2e-08,
        "output_cost_per_token": 0.0,
        "litellm_provider": "azure",
        "mode": "embedding",
    },
    "azure/gpt-image-1": {
        "mode": "image_generation",
        "input_cost_per_pixel": 4.0054321e-08,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "azure",
        "supported_endpoints": ["/v1/images/generations"],
    },
    "azure/low/1024-x-1024/gpt-image-1": {
        "mode": "image_generation",
        "input_cost_per_pixel": 1.0490417e-08,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "azure",
        "supported_endpoints": ["/v1/images/generations"],
    },
    "azure/medium/1024-x-1024/gpt-image-1": {
        "mode": "image_generation",
        "input_cost_per_pixel": 4.0054321e-08,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "azure",
        "supported_endpoints": ["/v1/images/generations"],
    },
    "azure/high/1024-x-1024/gpt-image-1": {
        "mode": "image_generation",
        "input_cost_per_pixel": 1.59263611e-07,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "azure",
        "supported_endpoints": ["/v1/images/generations"],
    },
    "azure/low/1024-x-1536/gpt-image-1": {
        "mode": "image_generation",
        "input_cost_per_pixel": 1.0172526e-08,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "azure",
        "supported_endpoints": ["/v1/images/generations"],
    },
    "azure/medium/1024-x-1536/gpt-image-1": {
        "mode": "image_generation",
        "input_cost_per_pixel": 4.0054321e-08,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "azure",
        "supported_endpoints": ["/v1/images/generations"],
    },
    "azure/high/1024-x-1536/gpt-image-1": {
        "mode": "image_generation",
        "input_cost_per_pixel": 1.58945719e-07,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "azure",
        "supported_endpoints": ["/v1/images/generations"],
    },
    "azure/low/1536-x-1024/gpt-image-1": {
        "mode": "image_generation",
        "input_cost_per_pixel": 1.0172526e-08,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "azure",
        "supported_endpoints": ["/v1/images/generations"],
    },
    "azure/medium/1536-x-1024/gpt-image-1": {
        "mode": "image_generation",
        "input_cost_per_pixel": 4.0054321e-08,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "azure",
        "supported_endpoints": ["/v1/images/generations"],
    },
    "azure/high/1536-x-1024/gpt-image-1": {
        "mode": "image_generation",
        "input_cost_per_pixel": 1.58945719e-07,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "azure",
        "supported_endpoints": ["/v1/images/generations"],
    },
    "azure/standard/1024-x-1024/dall-e-3": {
        "input_cost_per_pixel": 3.81469e-08,
        "output_cost_per_token": 0.0,
        "litellm_provider": "azure",
        "mode": "image_generation",
    },
    "azure/hd/1024-x-1024/dall-e-3": {
        "input_cost_per_pixel": 7.629e-08,
        "output_cost_per_token": 0.0,
        "litellm_provider": "azure",
        "mode": "image_generation",
    },
    "azure/standard/1024-x-1792/dall-e-3": {
        "input_cost_per_pixel": 4.359e-08,
        "output_cost_per_token": 0.0,
        "litellm_provider": "azure",
        "mode": "image_generation",
    },
    "azure/standard/1792-x-1024/dall-e-3": {
        "input_cost_per_pixel": 4.359e-08,
        "output_cost_per_token": 0.0,
        "litellm_provider": "azure",
        "mode": "image_generation",
    },
    "azure/hd/1024-x-1792/dall-e-3": {
        "input_cost_per_pixel": 6.539e-08,
        "output_cost_per_token": 0.0,
        "litellm_provider": "azure",
        "mode": "image_generation",
    },
    "azure/hd/1792-x-1024/dall-e-3": {
        "input_cost_per_pixel": 6.539e-08,
        "output_cost_per_token": 0.0,
        "litellm_provider": "azure",
        "mode": "image_generation",
    },
    "azure/standard/1024-x-1024/dall-e-2": {
        "input_cost_per_pixel": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "azure",
        "mode": "image_generation",
    },
    "azure_ai/deepseek-r1": {
        "max_tokens": 8192,
        "max_input_tokens": 128000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1.35e-06,
        "output_cost_per_token": 5.4e-06,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "source": "https://techcommunity.microsoft.com/blog/machinelearningblog/deepseek-r1-improved-performance-higher-limits-and-transparent-pricing/4386367",
    },
    "azure_ai/deepseek-v3": {
        "max_tokens": 8192,
        "max_input_tokens": 128000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1.14e-06,
        "output_cost_per_token": 4.56e-06,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "supports_tool_choice": True,
        "source": "https://techcommunity.microsoft.com/blog/machinelearningblog/announcing-deepseek-v3-on-azure-ai-foundry-and-github/4390438",
    },
    "azure_ai/deepseek-v3-0324": {
        "max_tokens": 8192,
        "max_input_tokens": 128000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1.14e-06,
        "output_cost_per_token": 4.56e-06,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "source": "https://techcommunity.microsoft.com/blog/machinelearningblog/announcing-deepseek-v3-on-azure-ai-foundry-and-github/4390438",
    },
    "azure_ai/jamba-instruct": {
        "max_tokens": 4096,
        "max_input_tokens": 70000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5e-07,
        "output_cost_per_token": 7e-07,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "azure_ai/mistral-nemo": {
        "max_tokens": 4096,
        "max_input_tokens": 131072,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 1.5e-07,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "supports_function_calling": True,
        "source": "https://azuremarketplace.microsoft.com/en/marketplace/apps/000-000.mistral-nemo-12b-2407?tab=PlansAndPrice",
    },
    "azure_ai/mistral-medium-2505": {
        "max_tokens": 8191,
        "max_input_tokens": 131072,
        "max_output_tokens": 8191,
        "input_cost_per_token": 4e-07,
        "output_cost_per_token": 2e-06,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "azure_ai/mistral-large": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 4e-06,
        "output_cost_per_token": 1.2e-05,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "azure_ai/mistral-small": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 3e-06,
        "litellm_provider": "azure_ai",
        "supports_function_calling": True,
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "azure_ai/mistral-small-2503": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 3e-06,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_tool_choice": True,
    },
    "azure_ai/mistral-large-2407": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 6e-06,
        "litellm_provider": "azure_ai",
        "supports_function_calling": True,
        "mode": "chat",
        "source": "https://azuremarketplace.microsoft.com/en/marketplace/apps/000-000.mistral-ai-large-2407-offer?tab=Overview",
        "supports_tool_choice": True,
    },
    "azure_ai/mistral-large-latest": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 6e-06,
        "litellm_provider": "azure_ai",
        "supports_function_calling": True,
        "mode": "chat",
        "source": "https://azuremarketplace.microsoft.com/en/marketplace/apps/000-000.mistral-ai-large-2407-offer?tab=Overview",
        "supports_tool_choice": True,
    },
    "azure_ai/ministral-3b": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 4e-08,
        "output_cost_per_token": 4e-08,
        "litellm_provider": "azure_ai",
        "supports_function_calling": True,
        "mode": "chat",
        "source": "https://azuremarketplace.microsoft.com/en/marketplace/apps/000-000.ministral-3b-2410-offer?tab=Overview",
        "supports_tool_choice": True,
    },
    "azure_ai/Llama-3.2-11B-Vision-Instruct": {
        "max_tokens": 2048,
        "max_input_tokens": 128000,
        "max_output_tokens": 2048,
        "input_cost_per_token": 3.7e-07,
        "output_cost_per_token": 3.7e-07,
        "litellm_provider": "azure_ai",
        "supports_function_calling": True,
        "supports_vision": True,
        "mode": "chat",
        "source": "https://azuremarketplace.microsoft.com/en/marketplace/apps/metagenai.meta-llama-3-2-11b-vision-instruct-offer?tab=Overview",
        "supports_tool_choice": True,
    },
    "azure_ai/Llama-3.3-70B-Instruct": {
        "max_tokens": 2048,
        "max_input_tokens": 128000,
        "max_output_tokens": 2048,
        "input_cost_per_token": 7.1e-07,
        "output_cost_per_token": 7.1e-07,
        "litellm_provider": "azure_ai",
        "supports_function_calling": True,
        "mode": "chat",
        "source": "https://azuremarketplace.microsoft.com/en/marketplace/apps/metagenai.llama-3-3-70b-instruct-offer?tab=Overview",
        "supports_tool_choice": True,
    },
    "azure_ai/Llama-4-Scout-17B-16E-Instruct": {
        "max_tokens": 16384,
        "max_input_tokens": 10000000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 7.8e-07,
        "litellm_provider": "azure_ai",
        "supports_function_calling": True,
        "supports_vision": True,
        "mode": "chat",
        "source": "https://azure.microsoft.com/en-us/blog/introducing-the-llama-4-herd-in-azure-ai-foundry-and-azure-databricks/",
        "supports_tool_choice": True,
    },
    "azure_ai/Llama-4-Maverick-17B-128E-Instruct-FP8": {
        "max_tokens": 16384,
        "max_input_tokens": 1000000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 1.41e-06,
        "output_cost_per_token": 3.5e-07,
        "litellm_provider": "azure_ai",
        "supports_function_calling": True,
        "supports_vision": True,
        "mode": "chat",
        "source": "https://azure.microsoft.com/en-us/blog/introducing-the-llama-4-herd-in-azure-ai-foundry-and-azure-databricks/",
        "supports_tool_choice": True,
    },
    "azure_ai/Llama-3.2-90B-Vision-Instruct": {
        "max_tokens": 2048,
        "max_input_tokens": 128000,
        "max_output_tokens": 2048,
        "input_cost_per_token": 2.04e-06,
        "output_cost_per_token": 2.04e-06,
        "litellm_provider": "azure_ai",
        "supports_function_calling": True,
        "supports_vision": True,
        "mode": "chat",
        "source": "https://azuremarketplace.microsoft.com/en/marketplace/apps/metagenai.meta-llama-3-2-90b-vision-instruct-offer?tab=Overview",
        "supports_tool_choice": True,
    },
    "azure_ai/Meta-Llama-3-70B-Instruct": {
        "max_tokens": 2048,
        "max_input_tokens": 8192,
        "max_output_tokens": 2048,
        "input_cost_per_token": 1.1e-06,
        "output_cost_per_token": 3.7e-07,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "azure_ai/Meta-Llama-3.1-8B-Instruct": {
        "max_tokens": 2048,
        "max_input_tokens": 128000,
        "max_output_tokens": 2048,
        "input_cost_per_token": 3e-07,
        "output_cost_per_token": 6.1e-07,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "source": "https://azuremarketplace.microsoft.com/en-us/marketplace/apps/metagenai.meta-llama-3-1-8b-instruct-offer?tab=PlansAndPrice",
        "supports_tool_choice": True,
    },
    "azure_ai/Meta-Llama-3.1-70B-Instruct": {
        "max_tokens": 2048,
        "max_input_tokens": 128000,
        "max_output_tokens": 2048,
        "input_cost_per_token": 2.68e-06,
        "output_cost_per_token": 3.54e-06,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "source": "https://azuremarketplace.microsoft.com/en-us/marketplace/apps/metagenai.meta-llama-3-1-70b-instruct-offer?tab=PlansAndPrice",
        "supports_tool_choice": True,
    },
    "azure_ai/Meta-Llama-3.1-405B-Instruct": {
        "max_tokens": 2048,
        "max_input_tokens": 128000,
        "max_output_tokens": 2048,
        "input_cost_per_token": 5.33e-06,
        "output_cost_per_token": 1.6e-05,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "source": "https://azuremarketplace.microsoft.com/en-us/marketplace/apps/metagenai.meta-llama-3-1-405b-instruct-offer?tab=PlansAndPrice",
        "supports_tool_choice": True,
    },
    "azure_ai/Phi-4-mini-instruct": {
        "max_tokens": 4096,
        "max_input_tokens": 131072,
        "max_output_tokens": 4096,
        "input_cost_per_token": 7.5e-08,
        "output_cost_per_token": 3e-07,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "supports_function_calling": True,
        "source": "https://techcommunity.microsoft.com/blog/Azure-AI-Services-blog/announcing-new-phi-pricing-empowering-your-business-with-small-language-models/4395112",
    },
    "azure_ai/Phi-4-multimodal-instruct": {
        "max_tokens": 4096,
        "max_input_tokens": 131072,
        "max_output_tokens": 4096,
        "input_cost_per_token": 8e-08,
        "input_cost_per_audio_token": 4e-06,
        "output_cost_per_token": 3.2e-07,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "supports_audio_input": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "source": "https://techcommunity.microsoft.com/blog/Azure-AI-Services-blog/announcing-new-phi-pricing-empowering-your-business-with-small-language-models/4395112",
    },
    "azure_ai/Phi-4": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 16384,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 5e-07,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "supports_vision": False,
        "source": "https://techcommunity.microsoft.com/blog/machinelearningblog/affordable-innovation-unveiling-the-pricing-of-phi-3-slms-on-models-as-a-service/4156495",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "azure_ai/Phi-3.5-mini-instruct": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.3e-07,
        "output_cost_per_token": 5.2e-07,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "supports_vision": False,
        "source": "https://azure.microsoft.com/en-us/pricing/details/phi-3/",
        "supports_tool_choice": True,
    },
    "azure_ai/Phi-3.5-vision-instruct": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.3e-07,
        "output_cost_per_token": 5.2e-07,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "supports_vision": True,
        "source": "https://azure.microsoft.com/en-us/pricing/details/phi-3/",
        "supports_tool_choice": True,
    },
    "azure_ai/Phi-3.5-MoE-instruct": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.6e-07,
        "output_cost_per_token": 6.4e-07,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "supports_vision": False,
        "source": "https://azure.microsoft.com/en-us/pricing/details/phi-3/",
        "supports_tool_choice": True,
    },
    "azure_ai/Phi-3-mini-4k-instruct": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.3e-07,
        "output_cost_per_token": 5.2e-07,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "supports_vision": False,
        "source": "https://azure.microsoft.com/en-us/pricing/details/phi-3/",
        "supports_tool_choice": True,
    },
    "azure_ai/Phi-3-mini-128k-instruct": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.3e-07,
        "output_cost_per_token": 5.2e-07,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "supports_vision": False,
        "source": "https://azure.microsoft.com/en-us/pricing/details/phi-3/",
        "supports_tool_choice": True,
    },
    "azure_ai/Phi-3-small-8k-instruct": {
        "max_tokens": 4096,
        "max_input_tokens": 8192,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "supports_vision": False,
        "source": "https://azure.microsoft.com/en-us/pricing/details/phi-3/",
        "supports_tool_choice": True,
    },
    "azure_ai/Phi-3-small-128k-instruct": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "supports_vision": False,
        "source": "https://azure.microsoft.com/en-us/pricing/details/phi-3/",
        "supports_tool_choice": True,
    },
    "azure_ai/Phi-3-medium-4k-instruct": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.7e-07,
        "output_cost_per_token": 6.8e-07,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "supports_vision": False,
        "source": "https://azure.microsoft.com/en-us/pricing/details/phi-3/",
        "supports_tool_choice": True,
    },
    "azure_ai/Phi-3-medium-128k-instruct": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.7e-07,
        "output_cost_per_token": 6.8e-07,
        "litellm_provider": "azure_ai",
        "mode": "chat",
        "supports_vision": False,
        "source": "https://azure.microsoft.com/en-us/pricing/details/phi-3/",
        "supports_tool_choice": True,
    },
    "azure_ai/cohere-rerank-v3-multilingual": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "max_query_tokens": 2048,
        "input_cost_per_token": 0.0,
        "input_cost_per_query": 0.002,
        "output_cost_per_token": 0.0,
        "litellm_provider": "azure_ai",
        "mode": "rerank",
    },
    "azure_ai/cohere-rerank-v3-english": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "max_query_tokens": 2048,
        "input_cost_per_token": 0.0,
        "input_cost_per_query": 0.002,
        "output_cost_per_token": 0.0,
        "litellm_provider": "azure_ai",
        "mode": "rerank",
    },
    "azure_ai/Cohere-embed-v3-english": {
        "max_tokens": 512,
        "max_input_tokens": 512,
        "output_vector_size": 1024,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "azure_ai",
        "mode": "embedding",
        "supports_embedding_image_input": True,
        "source": "https://azuremarketplace.microsoft.com/en-us/marketplace/apps/cohere.cohere-embed-v3-english-offer?tab=PlansAndPrice",
    },
    "azure_ai/Cohere-embed-v3-multilingual": {
        "max_tokens": 512,
        "max_input_tokens": 512,
        "output_vector_size": 1024,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "azure_ai",
        "mode": "embedding",
        "supports_embedding_image_input": True,
        "source": "https://azuremarketplace.microsoft.com/en-us/marketplace/apps/cohere.cohere-embed-v3-english-offer?tab=PlansAndPrice",
    },
    "azure_ai/embed-v-4-0": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "output_vector_size": 3072,
        "input_cost_per_token": 1.2e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "azure_ai",
        "mode": "embedding",
        "supports_embedding_image_input": True,
        "supported_endpoints": ["/v1/embeddings"],
        "supported_modalities": ["text", "image"],
        "source": "https://azuremarketplace.microsoft.com/pt-br/marketplace/apps/cohere.cohere-embed-4-offer?tab=PlansAndPrice",
    },
    "babbage-002": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 4096,
        "input_cost_per_token": 4e-07,
        "output_cost_per_token": 4e-07,
        "litellm_provider": "text-completion-openai",
        "mode": "completion",
    },
    "davinci-002": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 2e-06,
        "litellm_provider": "text-completion-openai",
        "mode": "completion",
    },
    "gpt-3.5-turbo-instruct": {
        "max_tokens": 4096,
        "max_input_tokens": 8192,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-06,
        "output_cost_per_token": 2e-06,
        "litellm_provider": "text-completion-openai",
        "mode": "completion",
    },
    "gpt-3.5-turbo-instruct-0914": {
        "max_tokens": 4097,
        "max_input_tokens": 8192,
        "max_output_tokens": 4097,
        "input_cost_per_token": 1.5e-06,
        "output_cost_per_token": 2e-06,
        "litellm_provider": "text-completion-openai",
        "mode": "completion",
    },
    "claude-instant-1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 1.63e-06,
        "output_cost_per_token": 5.51e-06,
        "litellm_provider": "anthropic",
        "mode": "chat",
    },
    "mistral/mistral-tiny": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 2.5e-07,
        "output_cost_per_token": 2.5e-07,
        "litellm_provider": "mistral",
        "mode": "chat",
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "mistral/mistral-small": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 3e-07,
        "litellm_provider": "mistral",
        "supports_function_calling": True,
        "mode": "chat",
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "mistral/mistral-small-latest": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 3e-07,
        "litellm_provider": "mistral",
        "supports_function_calling": True,
        "mode": "chat",
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "mistral/mistral-medium": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 2.7e-06,
        "output_cost_per_token": 8.1e-06,
        "litellm_provider": "mistral",
        "mode": "chat",
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "mistral/mistral-medium-latest": {
        "max_tokens": 8191,
        "max_input_tokens": 131072,
        "max_output_tokens": 8191,
        "input_cost_per_token": 4e-07,
        "output_cost_per_token": 2e-06,
        "litellm_provider": "mistral",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "mistral/mistral-medium-2505": {
        "max_tokens": 8191,
        "max_input_tokens": 131072,
        "max_output_tokens": 8191,
        "input_cost_per_token": 4e-07,
        "output_cost_per_token": 2e-06,
        "litellm_provider": "mistral",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "mistral/mistral-medium-2312": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 2.7e-06,
        "output_cost_per_token": 8.1e-06,
        "litellm_provider": "mistral",
        "mode": "chat",
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "mistral/mistral-large-latest": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 6e-06,
        "litellm_provider": "mistral",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "mistral/mistral-large-2411": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 6e-06,
        "litellm_provider": "mistral",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "mistral/mistral-large-2402": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 4e-06,
        "output_cost_per_token": 1.2e-05,
        "litellm_provider": "mistral",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "mistral/mistral-large-2407": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 9e-06,
        "litellm_provider": "mistral",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "mistral/pixtral-large-latest": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 6e-06,
        "litellm_provider": "mistral",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_assistant_prefill": True,
        "supports_vision": True,
        "supports_tool_choice": True,
    },
    "mistral/pixtral-large-2411": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 6e-06,
        "litellm_provider": "mistral",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_assistant_prefill": True,
        "supports_vision": True,
        "supports_tool_choice": True,
    },
    "mistral/pixtral-12b-2409": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 1.5e-07,
        "litellm_provider": "mistral",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_assistant_prefill": True,
        "supports_vision": True,
        "supports_tool_choice": True,
    },
    "mistral/open-mistral-7b": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 2.5e-07,
        "output_cost_per_token": 2.5e-07,
        "litellm_provider": "mistral",
        "mode": "chat",
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "mistral/open-mixtral-8x7b": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 7e-07,
        "output_cost_per_token": 7e-07,
        "litellm_provider": "mistral",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "mistral/open-mixtral-8x22b": {
        "max_tokens": 8191,
        "max_input_tokens": 65336,
        "max_output_tokens": 8191,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 6e-06,
        "litellm_provider": "mistral",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "mistral/codestral-latest": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 3e-06,
        "litellm_provider": "mistral",
        "mode": "chat",
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "mistral/codestral-2405": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 3e-06,
        "litellm_provider": "mistral",
        "mode": "chat",
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "mistral/open-mistral-nemo": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 3e-07,
        "output_cost_per_token": 3e-07,
        "litellm_provider": "mistral",
        "mode": "chat",
        "source": "https://mistral.ai/technology/",
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "mistral/open-mistral-nemo-2407": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 3e-07,
        "output_cost_per_token": 3e-07,
        "litellm_provider": "mistral",
        "mode": "chat",
        "source": "https://mistral.ai/technology/",
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "mistral/open-codestral-mamba": {
        "max_tokens": 256000,
        "max_input_tokens": 256000,
        "max_output_tokens": 256000,
        "input_cost_per_token": 2.5e-07,
        "output_cost_per_token": 2.5e-07,
        "litellm_provider": "mistral",
        "mode": "chat",
        "source": "https://mistral.ai/technology/",
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "mistral/codestral-mamba-latest": {
        "max_tokens": 256000,
        "max_input_tokens": 256000,
        "max_output_tokens": 256000,
        "input_cost_per_token": 2.5e-07,
        "output_cost_per_token": 2.5e-07,
        "litellm_provider": "mistral",
        "mode": "chat",
        "source": "https://mistral.ai/technology/",
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "mistral/devstral-small-2505": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 3e-07,
        "litellm_provider": "mistral",
        "mode": "chat",
        "source": "https://mistral.ai/news/devstral",
        "supports_function_calling": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "mistral/magistral-medium-latest": {
        "max_tokens": 40000,
        "max_input_tokens": 40000,
        "max_output_tokens": 40000,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 5e-06,
        "litellm_provider": "mistral",
        "mode": "chat",
        "source": "https://mistral.ai/news/magistral",
        "supports_function_calling": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
    },
    "mistral/magistral-medium-2506": {
        "max_tokens": 40000,
        "max_input_tokens": 40000,
        "max_output_tokens": 40000,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 5e-06,
        "litellm_provider": "mistral",
        "mode": "chat",
        "source": "https://mistral.ai/news/magistral",
        "supports_function_calling": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
    },
    "mistral/magistral-small-latest": {
        "max_tokens": 40000,
        "max_input_tokens": 40000,
        "max_output_tokens": 40000,
        "input_cost_per_token": 0.5e-6,
        "output_cost_per_token": 1.5e-6,
        "litellm_provider": "mistral",
        "mode": "chat",
        "source": "https://mistral.ai/pricing#api-pricing",
        "supports_function_calling": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
    },
    "mistral/magistral-small-2506": {
        "max_tokens": 40000,
        "max_input_tokens": 40000,
        "max_output_tokens": 40000,
        "input_cost_per_token": 0.5e-06,
        "output_cost_per_token": 1.5e-06,
        "litellm_provider": "mistral",
        "mode": "chat",
        "source": "https://mistral.ai/pricing#api-pricing",
        "supports_function_calling": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
    },
    "mistral/mistral-embed": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "input_cost_per_token": 1e-07,
        "litellm_provider": "mistral",
        "mode": "embedding",
    },
    "deepseek/deepseek-reasoner": {
        "max_tokens": 8192,
        "max_input_tokens": 65536,
        "max_output_tokens": 8192,
        "input_cost_per_token": 5.5e-07,
        "input_cost_per_token_cache_hit": 1.4e-07,
        "output_cost_per_token": 2.19e-06,
        "litellm_provider": "deepseek",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supports_prompt_caching": True,
    },
    "deepseek/deepseek-chat": {
        "max_tokens": 8192,
        "max_input_tokens": 65536,
        "max_output_tokens": 8192,
        "input_cost_per_token": 2.7e-07,
        "input_cost_per_token_cache_hit": 7e-08,
        "cache_read_input_token_cost": 7e-08,
        "cache_creation_input_token_cost": 0.0,
        "output_cost_per_token": 1.1e-06,
        "litellm_provider": "deepseek",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
        "supports_prompt_caching": True,
    },
    "codestral/codestral-latest": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "codestral",
        "mode": "chat",
        "source": "https://docs.mistral.ai/capabilities/code_generation/",
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "codestral/codestral-2405": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "codestral",
        "mode": "chat",
        "source": "https://docs.mistral.ai/capabilities/code_generation/",
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "text-completion-codestral/codestral-latest": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "text-completion-codestral",
        "mode": "completion",
        "source": "https://docs.mistral.ai/capabilities/code_generation/",
    },
    "text-completion-codestral/codestral-2405": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "text-completion-codestral",
        "mode": "completion",
        "source": "https://docs.mistral.ai/capabilities/code_generation/",
    },
    "xai/grok-beta": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 5e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "xai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_tool_choice": True,
        "supports_web_search": True,
    },
    "xai/grok-2-vision-1212": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 32768,
        "input_cost_per_token": 2e-06,
        "input_cost_per_image": 2e-06,
        "output_cost_per_token": 1e-05,
        "litellm_provider": "xai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_tool_choice": True,
        "supports_web_search": True,
    },
    "xai/grok-2-vision-latest": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 32768,
        "input_cost_per_token": 2e-06,
        "input_cost_per_image": 2e-06,
        "output_cost_per_token": 1e-05,
        "litellm_provider": "xai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_tool_choice": True,
        "supports_web_search": True,
    },
    "xai/grok-2-vision": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 32768,
        "input_cost_per_token": 2e-06,
        "input_cost_per_image": 2e-06,
        "output_cost_per_token": 1e-05,
        "litellm_provider": "xai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_tool_choice": True,
        "supports_web_search": True,
    },
    "xai/grok-3": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "xai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_response_schema": False,
        "source": "https://x.ai/api#pricing",
        "supports_web_search": True,
    },
    "xai/grok-3-latest": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "xai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_response_schema": False,
        "source": "https://x.ai/api#pricing",
        "supports_web_search": True,
    },
    "xai/grok-3-beta": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "xai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_response_schema": False,
        "source": "https://x.ai/api#pricing",
        "supports_web_search": True,
    },
    "xai/grok-3-fast-beta": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 5e-06,
        "output_cost_per_token": 2.5e-05,
        "litellm_provider": "xai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_response_schema": False,
        "source": "https://x.ai/api#pricing",
        "supports_web_search": True,
    },
    "xai/grok-3-fast-latest": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 5e-06,
        "output_cost_per_token": 2.5e-05,
        "litellm_provider": "xai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_response_schema": False,
        "source": "https://x.ai/api#pricing",
        "supports_web_search": True,
    },
    "xai/grok-3-mini": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 3e-07,
        "output_cost_per_token": 5e-07,
        "litellm_provider": "xai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supports_response_schema": False,
        "source": "https://x.ai/api#pricing",
        "supports_web_search": True,
    },
    "xai/grok-3-mini-latest": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 3e-07,
        "output_cost_per_token": 5e-07,
        "litellm_provider": "xai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supports_response_schema": False,
        "source": "https://x.ai/api#pricing",
        "supports_web_search": True,
    },
    "xai/grok-3-mini-fast": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 6e-07,
        "output_cost_per_token": 4e-06,
        "litellm_provider": "xai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supports_response_schema": False,
        "source": "https://x.ai/api#pricing",
        "supports_web_search": True,
    },
    "xai/grok-3-mini-fast-latest": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 6e-07,
        "output_cost_per_token": 4e-06,
        "litellm_provider": "xai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supports_response_schema": False,
        "source": "https://x.ai/api#pricing",
        "supports_web_search": True,
    },
    "xai/grok-3-mini-beta": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 3e-07,
        "output_cost_per_token": 5e-07,
        "litellm_provider": "xai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supports_response_schema": False,
        "source": "https://x.ai/api#pricing",
        "supports_web_search": True,
    },
    "xai/grok-3-mini-fast-beta": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 6e-07,
        "output_cost_per_token": 4e-06,
        "litellm_provider": "xai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supports_response_schema": False,
        "source": "https://x.ai/api#pricing",
        "supports_web_search": True,
    },
    "xai/grok-3-mini-fast-latest": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 6e-07,
        "output_cost_per_token": 4e-06,
        "litellm_provider": "xai",
        "mode": "chat",
        "supports_reasoning": True,
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_response_schema": False,
        "source": "https://x.ai/api#pricing",
        "supports_web_search": True,
    },
    "xai/grok-vision-beta": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 5e-06,
        "input_cost_per_image": 5e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "xai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_tool_choice": True,
        "supports_web_search": True,
    },
    "xai/grok-2-1212": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 1e-05,
        "litellm_provider": "xai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_web_search": True,
    },
    "xai/grok-2": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 1e-05,
        "litellm_provider": "xai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_web_search": True,
    },
    "xai/grok-2-latest": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 1e-05,
        "litellm_provider": "xai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_web_search": True,
    },
    "deepseek/deepseek-coder": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.4e-07,
        "input_cost_per_token_cache_hit": 1.4e-08,
        "output_cost_per_token": 2.8e-07,
        "litellm_provider": "deepseek",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
        "supports_prompt_caching": True,
    },
    "groq/deepseek-r1-distill-llama-70b": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 7.5e-07,
        "output_cost_per_token": 9.9e-07,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_reasoning": True,
        "supports_tool_choice": True,
    },
    "groq/llama-3.3-70b-versatile": {
        "max_tokens": 32768,
        "max_input_tokens": 128000,
        "max_output_tokens": 32768,
        "input_cost_per_token": 5.9e-07,
        "output_cost_per_token": 7.9e-07,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
    },
    "groq/llama-3.3-70b-specdec": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 5.9e-07,
        "output_cost_per_token": 9.9e-07,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_tool_choice": True,
        "deprecation_date": "2025-04-14",
    },
    "groq/llama-guard-3-8b": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 2e-07,
        "litellm_provider": "groq",
        "mode": "chat",
    },
    "groq/llama2-70b-4096": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 7e-07,
        "output_cost_per_token": 8e-07,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
    },
    "groq/llama3-8b-8192": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 5e-08,
        "output_cost_per_token": 8e-08,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "groq/llama-3.2-1b-preview": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 4e-08,
        "output_cost_per_token": 4e-08,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "deprecation_date": "2025-04-14",
    },
    "groq/llama-3.2-3b-preview": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 6e-08,
        "output_cost_per_token": 6e-08,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "deprecation_date": "2025-04-14",
    },
    "groq/llama-3.2-11b-text-preview": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1.8e-07,
        "output_cost_per_token": 1.8e-07,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "deprecation_date": "2024-10-28",
    },
    "groq/llama-3.2-11b-vision-preview": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1.8e-07,
        "output_cost_per_token": 1.8e-07,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_tool_choice": True,
        "deprecation_date": "2025-04-14",
    },
    "groq/llama-3.2-90b-text-preview": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 9e-07,
        "output_cost_per_token": 9e-07,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "deprecation_date": "2024-11-25",
    },
    "groq/llama-3.2-90b-vision-preview": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 9e-07,
        "output_cost_per_token": 9e-07,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_tool_choice": True,
        "deprecation_date": "2025-04-14",
    },
    "groq/llama3-70b-8192": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 5.9e-07,
        "output_cost_per_token": 7.9e-07,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_response_schema": True,
        "supports_tool_choice": True,
    },
    "groq/llama-3.1-8b-instant": {
        "max_tokens": 8192,
        "max_input_tokens": 128000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 5e-08,
        "output_cost_per_token": 8e-08,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
    },
    "groq/llama-3.1-70b-versatile": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 5.9e-07,
        "output_cost_per_token": 7.9e-07,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "deprecation_date": "2025-01-24",
    },
    "groq/llama-3.1-405b-reasoning": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 5.9e-07,
        "output_cost_per_token": 7.9e-07,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
    },
    "groq/meta-llama/llama-4-scout-17b-16e-instruct": {
        "max_tokens": 8192,
        "max_input_tokens": 131072,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1.1e-07,
        "output_cost_per_token": 3.4e-07,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
    },
    "groq/meta-llama/llama-4-maverick-17b-128e-instruct": {
        "max_tokens": 8192,
        "max_input_tokens": 131072,
        "max_output_tokens": 8192,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
    },
    "groq/mistral-saba-24b": {
        "max_tokens": 32000,
        "max_input_tokens": 32000,
        "max_output_tokens": 32000,
        "input_cost_per_token": 7.9e-07,
        "output_cost_per_token": 7.9e-07,
        "litellm_provider": "groq",
        "mode": "chat",
    },
    "groq/mixtral-8x7b-32768": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 32768,
        "input_cost_per_token": 2.4e-07,
        "output_cost_per_token": 2.4e-07,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "deprecation_date": "2025-03-20",
    },
    "groq/gemma-7b-it": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 7e-08,
        "output_cost_per_token": 7e-08,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "deprecation_date": "2024-12-18",
    },
    "groq/gemma2-9b-it": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 2e-07,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_function_calling": False,
        "supports_response_schema": True,
        "supports_tool_choice": False,
    },
    "groq/llama3-groq-70b-8192-tool-use-preview": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 8.9e-07,
        "output_cost_per_token": 8.9e-07,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "deprecation_date": "2025-01-06",
    },
    "groq/llama3-groq-8b-8192-tool-use-preview": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1.9e-07,
        "output_cost_per_token": 1.9e-07,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "deprecation_date": "2025-01-06",
    },
    "groq/qwen-qwq-32b": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 2.9e-07,
        "output_cost_per_token": 3.9e-07,
        "litellm_provider": "groq",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_reasoning": True,
        "supports_tool_choice": True,
    },
    "groq/playai-tts": {
        "max_tokens": 10000,
        "max_input_tokens": 10000,
        "max_output_tokens": 10000,
        "input_cost_per_character": 5e-05,
        "litellm_provider": "groq",
        "mode": "audio_speech",
    },
    "groq/whisper-large-v3": {
        "input_cost_per_second": 3.083e-05,
        "output_cost_per_second": 0.0,
        "litellm_provider": "groq",
        "mode": "audio_transcription",
    },
    "groq/whisper-large-v3-turbo": {
        "input_cost_per_second": 1.111e-05,
        "output_cost_per_second": 0.0,
        "litellm_provider": "groq",
        "mode": "audio_transcription",
    },
    "groq/distil-whisper-large-v3-en": {
        "input_cost_per_second": 5.56e-06,
        "output_cost_per_second": 0.0,
        "litellm_provider": "groq",
        "mode": "audio_transcription",
    },
    "cerebras/llama3.1-8b": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 1e-07,
        "litellm_provider": "cerebras",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "cerebras/llama3.1-70b": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 6e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "cerebras",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "cerebras/llama-3.3-70b": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 8.5e-07,
        "output_cost_per_token": 1.2e-06,
        "litellm_provider": "cerebras",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "cerebras/qwen-3-32b": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 4e-07,
        "output_cost_per_token": 8e-07,
        "litellm_provider": "cerebras",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "source": "https://inference-docs.cerebras.ai/support/pricing",
    },
    "friendliai/meta-llama-3.1-8b-instruct": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 1e-07,
        "litellm_provider": "friendliai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_system_messages": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
    },
    "friendliai/meta-llama-3.1-70b-instruct": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 6e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "friendliai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_system_messages": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
    },
    "claude-instant-1.2": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 1.63e-07,
        "output_cost_per_token": 5.51e-07,
        "litellm_provider": "anthropic",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "claude-2": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "anthropic",
        "mode": "chat",
    },
    "claude-2.1": {
        "max_tokens": 8191,
        "max_input_tokens": 200000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "anthropic",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "claude-3-haiku-20240307": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2.5e-07,
        "output_cost_per_token": 1.25e-06,
        "cache_creation_input_token_cost": 3e-07,
        "cache_read_input_token_cost": 3e-08,
        "litellm_provider": "anthropic",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 264,
        "supports_assistant_prefill": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "deprecation_date": "2025-03-01",
        "supports_tool_choice": True,
    },
    "claude-3-5-haiku-20241022": {
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 8e-07,
        "output_cost_per_token": 4e-06,
        "cache_creation_input_token_cost": 1e-06,
        "cache_read_input_token_cost": 8e-08,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.01,
            "search_context_size_medium": 0.01,
            "search_context_size_high": 0.01,
        },
        "litellm_provider": "anthropic",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 264,
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "deprecation_date": "2025-10-01",
        "supports_tool_choice": True,
        "supports_web_search": True,
    },
    "claude-3-5-haiku-latest": {
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 5e-06,
        "cache_creation_input_token_cost": 1.25e-06,
        "cache_read_input_token_cost": 1e-07,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.01,
            "search_context_size_medium": 0.01,
            "search_context_size_high": 0.01,
        },
        "litellm_provider": "anthropic",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 264,
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "deprecation_date": "2025-10-01",
        "supports_tool_choice": True,
        "supports_web_search": True,
    },
    "claude-3-opus-latest": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 7.5e-05,
        "cache_creation_input_token_cost": 1.875e-05,
        "cache_read_input_token_cost": 1.5e-06,
        "litellm_provider": "anthropic",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 395,
        "supports_assistant_prefill": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "deprecation_date": "2025-03-01",
        "supports_tool_choice": True,
    },
    "claude-3-opus-20240229": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 7.5e-05,
        "cache_creation_input_token_cost": 1.875e-05,
        "cache_read_input_token_cost": 1.5e-06,
        "litellm_provider": "anthropic",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 395,
        "supports_assistant_prefill": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "deprecation_date": "2025-03-01",
        "supports_tool_choice": True,
    },
    "claude-3-sonnet-20240229": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "anthropic",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "deprecation_date": "2025-07-21",
        "supports_tool_choice": True,
    },
    "claude-3-5-sonnet-latest": {
        "supports_computer_use": True,
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "cache_creation_input_token_cost": 3.75e-06,
        "cache_read_input_token_cost": 3e-07,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.01,
            "search_context_size_medium": 0.01,
            "search_context_size_high": 0.01,
        },
        "litellm_provider": "anthropic",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "deprecation_date": "2025-06-01",
        "supports_tool_choice": True,
        "supports_web_search": True,
    },
    "claude-3-5-sonnet-20240620": {
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "cache_creation_input_token_cost": 3.75e-06,
        "cache_read_input_token_cost": 3e-07,
        "litellm_provider": "anthropic",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "deprecation_date": "2025-06-01",
        "supports_tool_choice": True,
    },
    "claude-opus-4-20250514": {
        "max_tokens": 32000,
        "max_input_tokens": 200000,
        "max_output_tokens": 32000,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 7.5e-05,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.01,
            "search_context_size_medium": 0.01,
            "search_context_size_high": 0.01,
        },
        "cache_creation_input_token_cost": 1.875e-05,
        "cache_read_input_token_cost": 1.5e-06,
        "litellm_provider": "anthropic",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supports_computer_use": True,
    },
    "claude-sonnet-4-20250514": {
        "max_tokens": 64000,
        "max_input_tokens": 200000,
        "max_output_tokens": 64000,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.01,
            "search_context_size_medium": 0.01,
            "search_context_size_high": 0.01,
        },
        "cache_creation_input_token_cost": 3.75e-06,
        "cache_read_input_token_cost": 3e-07,
        "litellm_provider": "anthropic",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supports_computer_use": True,
    },
    "claude-4-opus-20250514": {
        "max_tokens": 32000,
        "max_input_tokens": 200000,
        "max_output_tokens": 32000,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 7.5e-05,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.01,
            "search_context_size_medium": 0.01,
            "search_context_size_high": 0.01,
        },
        "cache_creation_input_token_cost": 1.875e-05,
        "cache_read_input_token_cost": 1.5e-06,
        "litellm_provider": "anthropic",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supports_computer_use": True,
    },
    "claude-4-sonnet-20250514": {
        "max_tokens": 64000,
        "max_input_tokens": 200000,
        "max_output_tokens": 64000,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.01,
            "search_context_size_medium": 0.01,
            "search_context_size_high": 0.01,
        },
        "cache_creation_input_token_cost": 3.75e-06,
        "cache_read_input_token_cost": 3e-07,
        "litellm_provider": "anthropic",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supports_computer_use": True,
    },
    "claude-3-7-sonnet-latest": {
        "supports_computer_use": True,
        "max_tokens": 128000,
        "max_input_tokens": 200000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.01,
            "search_context_size_medium": 0.01,
            "search_context_size_high": 0.01,
        },
        "cache_creation_input_token_cost": 3.75e-06,
        "cache_read_input_token_cost": 3e-07,
        "litellm_provider": "anthropic",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "deprecation_date": "2025-06-01",
        "supports_tool_choice": True,
        "supports_reasoning": True,
    },
    "claude-3-7-sonnet-20250219": {
        "supports_computer_use": True,
        "max_tokens": 128000,
        "max_input_tokens": 200000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "cache_creation_input_token_cost": 3.75e-06,
        "cache_read_input_token_cost": 3e-07,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.01,
            "search_context_size_medium": 0.01,
            "search_context_size_high": 0.01,
        },
        "litellm_provider": "anthropic",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "deprecation_date": "2026-02-01",
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supports_web_search": True,
    },
    "claude-3-5-sonnet-20241022": {
        "supports_computer_use": True,
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "cache_creation_input_token_cost": 3.75e-06,
        "cache_read_input_token_cost": 3e-07,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.01,
            "search_context_size_medium": 0.01,
            "search_context_size_high": 0.01,
        },
        "litellm_provider": "anthropic",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "deprecation_date": "2025-10-01",
        "supports_tool_choice": True,
        "supports_web_search": True,
    },
    "text-bison": {
        "max_tokens": 2048,
        "max_input_tokens": 8192,
        "max_output_tokens": 2048,
        "input_cost_per_character": 2.5e-07,
        "output_cost_per_character": 5e-07,
        "litellm_provider": "vertex_ai-text-models",
        "mode": "completion",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "text-bison@001": {
        "max_tokens": 1024,
        "max_input_tokens": 8192,
        "max_output_tokens": 1024,
        "input_cost_per_character": 2.5e-07,
        "output_cost_per_character": 5e-07,
        "litellm_provider": "vertex_ai-text-models",
        "mode": "completion",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "text-bison@002": {
        "max_tokens": 1024,
        "max_input_tokens": 8192,
        "max_output_tokens": 1024,
        "input_cost_per_character": 2.5e-07,
        "output_cost_per_character": 5e-07,
        "litellm_provider": "vertex_ai-text-models",
        "mode": "completion",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "text-bison32k": {
        "max_tokens": 1024,
        "max_input_tokens": 8192,
        "max_output_tokens": 1024,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "input_cost_per_character": 2.5e-07,
        "output_cost_per_character": 5e-07,
        "litellm_provider": "vertex_ai-text-models",
        "mode": "completion",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "text-bison32k@002": {
        "max_tokens": 1024,
        "max_input_tokens": 8192,
        "max_output_tokens": 1024,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "input_cost_per_character": 2.5e-07,
        "output_cost_per_character": 5e-07,
        "litellm_provider": "vertex_ai-text-models",
        "mode": "completion",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "text-unicorn": {
        "max_tokens": 1024,
        "max_input_tokens": 8192,
        "max_output_tokens": 1024,
        "input_cost_per_token": 1e-05,
        "output_cost_per_token": 2.8e-05,
        "litellm_provider": "vertex_ai-text-models",
        "mode": "completion",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "text-unicorn@001": {
        "max_tokens": 1024,
        "max_input_tokens": 8192,
        "max_output_tokens": 1024,
        "input_cost_per_token": 1e-05,
        "output_cost_per_token": 2.8e-05,
        "litellm_provider": "vertex_ai-text-models",
        "mode": "completion",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "chat-bison": {
        "max_tokens": 4096,
        "max_input_tokens": 8192,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "input_cost_per_character": 2.5e-07,
        "output_cost_per_character": 5e-07,
        "litellm_provider": "vertex_ai-chat-models",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
    },
    "chat-bison@001": {
        "max_tokens": 4096,
        "max_input_tokens": 8192,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "input_cost_per_character": 2.5e-07,
        "output_cost_per_character": 5e-07,
        "litellm_provider": "vertex_ai-chat-models",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
    },
    "chat-bison@002": {
        "max_tokens": 4096,
        "max_input_tokens": 8192,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "input_cost_per_character": 2.5e-07,
        "output_cost_per_character": 5e-07,
        "litellm_provider": "vertex_ai-chat-models",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "deprecation_date": "2025-04-09",
        "supports_tool_choice": True,
    },
    "chat-bison-32k": {
        "max_tokens": 8192,
        "max_input_tokens": 32000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "input_cost_per_character": 2.5e-07,
        "output_cost_per_character": 5e-07,
        "litellm_provider": "vertex_ai-chat-models",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
    },
    "chat-bison-32k@002": {
        "max_tokens": 8192,
        "max_input_tokens": 32000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "input_cost_per_character": 2.5e-07,
        "output_cost_per_character": 5e-07,
        "litellm_provider": "vertex_ai-chat-models",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
    },
    "code-bison": {
        "max_tokens": 1024,
        "max_input_tokens": 6144,
        "max_output_tokens": 1024,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "input_cost_per_character": 2.5e-07,
        "output_cost_per_character": 5e-07,
        "litellm_provider": "vertex_ai-code-text-models",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
    },
    "code-bison@001": {
        "max_tokens": 1024,
        "max_input_tokens": 6144,
        "max_output_tokens": 1024,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "input_cost_per_character": 2.5e-07,
        "output_cost_per_character": 5e-07,
        "litellm_provider": "vertex_ai-code-text-models",
        "mode": "completion",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "code-bison@002": {
        "max_tokens": 1024,
        "max_input_tokens": 6144,
        "max_output_tokens": 1024,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "input_cost_per_character": 2.5e-07,
        "output_cost_per_character": 5e-07,
        "litellm_provider": "vertex_ai-code-text-models",
        "mode": "completion",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "code-bison32k": {
        "max_tokens": 1024,
        "max_input_tokens": 6144,
        "max_output_tokens": 1024,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "input_cost_per_character": 2.5e-07,
        "output_cost_per_character": 5e-07,
        "litellm_provider": "vertex_ai-code-text-models",
        "mode": "completion",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "code-bison-32k@002": {
        "max_tokens": 1024,
        "max_input_tokens": 6144,
        "max_output_tokens": 1024,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "input_cost_per_character": 2.5e-07,
        "output_cost_per_character": 5e-07,
        "litellm_provider": "vertex_ai-code-text-models",
        "mode": "completion",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "code-gecko@001": {
        "max_tokens": 64,
        "max_input_tokens": 2048,
        "max_output_tokens": 64,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "litellm_provider": "vertex_ai-code-text-models",
        "mode": "completion",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "code-gecko@002": {
        "max_tokens": 64,
        "max_input_tokens": 2048,
        "max_output_tokens": 64,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "litellm_provider": "vertex_ai-code-text-models",
        "mode": "completion",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "code-gecko": {
        "max_tokens": 64,
        "max_input_tokens": 2048,
        "max_output_tokens": 64,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "litellm_provider": "vertex_ai-code-text-models",
        "mode": "completion",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "code-gecko-latest": {
        "max_tokens": 64,
        "max_input_tokens": 2048,
        "max_output_tokens": 64,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "litellm_provider": "vertex_ai-code-text-models",
        "mode": "completion",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "codechat-bison@latest": {
        "max_tokens": 1024,
        "max_input_tokens": 6144,
        "max_output_tokens": 1024,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "input_cost_per_character": 2.5e-07,
        "output_cost_per_character": 5e-07,
        "litellm_provider": "vertex_ai-code-chat-models",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
    },
    "codechat-bison": {
        "max_tokens": 1024,
        "max_input_tokens": 6144,
        "max_output_tokens": 1024,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "input_cost_per_character": 2.5e-07,
        "output_cost_per_character": 5e-07,
        "litellm_provider": "vertex_ai-code-chat-models",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
    },
    "codechat-bison@001": {
        "max_tokens": 1024,
        "max_input_tokens": 6144,
        "max_output_tokens": 1024,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "input_cost_per_character": 2.5e-07,
        "output_cost_per_character": 5e-07,
        "litellm_provider": "vertex_ai-code-chat-models",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
    },
    "codechat-bison@002": {
        "max_tokens": 1024,
        "max_input_tokens": 6144,
        "max_output_tokens": 1024,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "input_cost_per_character": 2.5e-07,
        "output_cost_per_character": 5e-07,
        "litellm_provider": "vertex_ai-code-chat-models",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
    },
    "codechat-bison-32k": {
        "max_tokens": 8192,
        "max_input_tokens": 32000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "input_cost_per_character": 2.5e-07,
        "output_cost_per_character": 5e-07,
        "litellm_provider": "vertex_ai-code-chat-models",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
    },
    "codechat-bison-32k@002": {
        "max_tokens": 8192,
        "max_input_tokens": 32000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "input_cost_per_character": 2.5e-07,
        "output_cost_per_character": 5e-07,
        "litellm_provider": "vertex_ai-code-chat-models",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
    },
    "meta_llama/Llama-4-Scout-17B-16E-Instruct-FP8": {
        "max_tokens": 128000,
        "max_input_tokens": 10000000,
        "max_output_tokens": 4028,
        "litellm_provider": "meta_llama",
        "mode": "chat",
        "supports_function_calling": False,
        "source": "https://llama.developer.meta.com/docs/models",
        "supports_tool_choice": False,
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
    },
    "meta_llama/Llama-4-Maverick-17B-128E-Instruct-FP8": {
        "max_tokens": 128000,
        "max_input_tokens": 1000000,
        "max_output_tokens": 4028,
        "litellm_provider": "meta_llama",
        "mode": "chat",
        "supports_function_calling": False,
        "source": "https://llama.developer.meta.com/docs/models",
        "supports_tool_choice": False,
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text"],
    },
    "meta_llama/Llama-3.3-70B-Instruct": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 4028,
        "litellm_provider": "meta_llama",
        "mode": "chat",
        "supports_function_calling": False,
        "source": "https://llama.developer.meta.com/docs/models",
        "supports_tool_choice": False,
        "supported_modalities": ["text"],
        "supported_output_modalities": ["text"],
    },
    "meta_llama/Llama-3.3-8B-Instruct": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 4028,
        "litellm_provider": "meta_llama",
        "mode": "chat",
        "supports_function_calling": False,
        "source": "https://llama.developer.meta.com/docs/models",
        "supports_tool_choice": False,
        "supported_modalities": ["text"],
        "supported_output_modalities": ["text"],
    },
    "gemini-pro": {
        "max_tokens": 8192,
        "max_input_tokens": 32760,
        "max_output_tokens": 8192,
        "input_cost_per_image": 0.0025,
        "input_cost_per_video_per_second": 0.002,
        "input_cost_per_token": 5e-07,
        "input_cost_per_character": 1.25e-07,
        "output_cost_per_token": 1.5e-06,
        "output_cost_per_character": 3.75e-07,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing",
        "supports_tool_choice": True,
    },
    "gemini-1.0-pro": {
        "max_tokens": 8192,
        "max_input_tokens": 32760,
        "max_output_tokens": 8192,
        "input_cost_per_image": 0.0025,
        "input_cost_per_video_per_second": 0.002,
        "input_cost_per_token": 5e-07,
        "input_cost_per_character": 1.25e-07,
        "output_cost_per_token": 1.5e-06,
        "output_cost_per_character": 3.75e-07,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing#google_models",
        "supports_tool_choice": True,
    },
    "gemini-1.0-pro-001": {
        "max_tokens": 8192,
        "max_input_tokens": 32760,
        "max_output_tokens": 8192,
        "input_cost_per_image": 0.0025,
        "input_cost_per_video_per_second": 0.002,
        "input_cost_per_token": 5e-07,
        "input_cost_per_character": 1.25e-07,
        "output_cost_per_token": 1.5e-06,
        "output_cost_per_character": 3.75e-07,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_function_calling": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "deprecation_date": "2025-04-09",
        "supports_tool_choice": True,
        "supports_parallel_function_calling": True,
    },
    "gemini-1.0-ultra": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 2048,
        "input_cost_per_image": 0.0025,
        "input_cost_per_video_per_second": 0.002,
        "input_cost_per_token": 5e-07,
        "input_cost_per_character": 1.25e-07,
        "output_cost_per_token": 1.5e-06,
        "output_cost_per_character": 3.75e-07,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_function_calling": True,
        "source": "As of Jun, 2024. There is no available doc on vertex ai pricing gemini-1.0-ultra-001. Using gemini-1.0-pro pricing. Got max_tokens info here: https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
        "supports_parallel_function_calling": True,
    },
    "gemini-1.0-ultra-001": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 2048,
        "input_cost_per_image": 0.0025,
        "input_cost_per_video_per_second": 0.002,
        "input_cost_per_token": 5e-07,
        "input_cost_per_character": 1.25e-07,
        "output_cost_per_token": 1.5e-06,
        "output_cost_per_character": 3.75e-07,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_function_calling": True,
        "source": "As of Jun, 2024. There is no available doc on vertex ai pricing gemini-1.0-ultra-001. Using gemini-1.0-pro pricing. Got max_tokens info here: https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
        "supports_parallel_function_calling": True,
    },
    "gemini-1.0-pro-002": {
        "max_tokens": 8192,
        "max_input_tokens": 32760,
        "max_output_tokens": 8192,
        "input_cost_per_image": 0.0025,
        "input_cost_per_video_per_second": 0.002,
        "input_cost_per_token": 5e-07,
        "input_cost_per_character": 1.25e-07,
        "output_cost_per_token": 1.5e-06,
        "output_cost_per_character": 3.75e-07,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_function_calling": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "deprecation_date": "2025-04-09",
        "supports_tool_choice": True,
        "supports_parallel_function_calling": True,
    },
    "gemini-1.5-pro": {
        "max_tokens": 8192,
        "max_input_tokens": 2097152,
        "max_output_tokens": 8192,
        "input_cost_per_image": 0.00032875,
        "input_cost_per_audio_per_second": 3.125e-05,
        "input_cost_per_video_per_second": 0.00032875,
        "input_cost_per_token": 1.25e-06,
        "input_cost_per_character": 3.125e-07,
        "input_cost_per_image_above_128k_tokens": 0.0006575,
        "input_cost_per_video_per_second_above_128k_tokens": 0.0006575,
        "input_cost_per_audio_per_second_above_128k_tokens": 6.25e-05,
        "input_cost_per_token_above_128k_tokens": 2.5e-06,
        "input_cost_per_character_above_128k_tokens": 6.25e-07,
        "output_cost_per_token": 5e-06,
        "output_cost_per_character": 1.25e-06,
        "output_cost_per_token_above_128k_tokens": 1e-05,
        "output_cost_per_character_above_128k_tokens": 2.5e-06,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_response_schema": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_parallel_function_calling": True,
    },
    "gemini-1.5-pro-002": {
        "max_tokens": 8192,
        "max_input_tokens": 2097152,
        "max_output_tokens": 8192,
        "input_cost_per_image": 0.00032875,
        "input_cost_per_audio_per_second": 3.125e-05,
        "input_cost_per_video_per_second": 0.00032875,
        "input_cost_per_token": 1.25e-06,
        "input_cost_per_character": 3.125e-07,
        "input_cost_per_image_above_128k_tokens": 0.0006575,
        "input_cost_per_video_per_second_above_128k_tokens": 0.0006575,
        "input_cost_per_audio_per_second_above_128k_tokens": 6.25e-05,
        "input_cost_per_token_above_128k_tokens": 2.5e-06,
        "input_cost_per_character_above_128k_tokens": 6.25e-07,
        "output_cost_per_token": 5e-06,
        "output_cost_per_character": 1.25e-06,
        "output_cost_per_token_above_128k_tokens": 1e-05,
        "output_cost_per_character_above_128k_tokens": 2.5e-06,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_vision": True,
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_response_schema": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#gemini-1.5-pro",
        "deprecation_date": "2025-09-24",
        "supports_parallel_function_calling": True,
    },
    "gemini-1.5-pro-001": {
        "max_tokens": 8192,
        "max_input_tokens": 1000000,
        "max_output_tokens": 8192,
        "input_cost_per_image": 0.00032875,
        "input_cost_per_audio_per_second": 3.125e-05,
        "input_cost_per_video_per_second": 0.00032875,
        "input_cost_per_token": 1.25e-06,
        "input_cost_per_character": 3.125e-07,
        "input_cost_per_image_above_128k_tokens": 0.0006575,
        "input_cost_per_video_per_second_above_128k_tokens": 0.0006575,
        "input_cost_per_audio_per_second_above_128k_tokens": 6.25e-05,
        "input_cost_per_token_above_128k_tokens": 2.5e-06,
        "input_cost_per_character_above_128k_tokens": 6.25e-07,
        "output_cost_per_token": 5e-06,
        "output_cost_per_character": 1.25e-06,
        "output_cost_per_token_above_128k_tokens": 1e-05,
        "output_cost_per_character_above_128k_tokens": 2.5e-06,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_vision": True,
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_response_schema": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "deprecation_date": "2025-05-24",
        "supports_parallel_function_calling": True,
    },
    "gemini-1.5-pro-preview-0514": {
        "max_tokens": 8192,
        "max_input_tokens": 1000000,
        "max_output_tokens": 8192,
        "input_cost_per_image": 0.00032875,
        "input_cost_per_audio_per_second": 3.125e-05,
        "input_cost_per_video_per_second": 0.00032875,
        "input_cost_per_token": 7.8125e-08,
        "input_cost_per_character": 3.125e-07,
        "input_cost_per_image_above_128k_tokens": 0.0006575,
        "input_cost_per_video_per_second_above_128k_tokens": 0.0006575,
        "input_cost_per_audio_per_second_above_128k_tokens": 6.25e-05,
        "input_cost_per_token_above_128k_tokens": 1.5625e-07,
        "input_cost_per_character_above_128k_tokens": 6.25e-07,
        "output_cost_per_token": 3.125e-07,
        "output_cost_per_character": 1.25e-06,
        "output_cost_per_token_above_128k_tokens": 6.25e-07,
        "output_cost_per_character_above_128k_tokens": 2.5e-06,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_response_schema": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_parallel_function_calling": True,
    },
    "gemini-1.5-pro-preview-0215": {
        "max_tokens": 8192,
        "max_input_tokens": 1000000,
        "max_output_tokens": 8192,
        "input_cost_per_image": 0.00032875,
        "input_cost_per_audio_per_second": 3.125e-05,
        "input_cost_per_video_per_second": 0.00032875,
        "input_cost_per_token": 7.8125e-08,
        "input_cost_per_character": 3.125e-07,
        "input_cost_per_image_above_128k_tokens": 0.0006575,
        "input_cost_per_video_per_second_above_128k_tokens": 0.0006575,
        "input_cost_per_audio_per_second_above_128k_tokens": 6.25e-05,
        "input_cost_per_token_above_128k_tokens": 1.5625e-07,
        "input_cost_per_character_above_128k_tokens": 6.25e-07,
        "output_cost_per_token": 3.125e-07,
        "output_cost_per_character": 1.25e-06,
        "output_cost_per_token_above_128k_tokens": 6.25e-07,
        "output_cost_per_character_above_128k_tokens": 2.5e-06,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_response_schema": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_parallel_function_calling": True,
    },
    "gemini-1.5-pro-preview-0409": {
        "max_tokens": 8192,
        "max_input_tokens": 1000000,
        "max_output_tokens": 8192,
        "input_cost_per_image": 0.00032875,
        "input_cost_per_audio_per_second": 3.125e-05,
        "input_cost_per_video_per_second": 0.00032875,
        "input_cost_per_token": 7.8125e-08,
        "input_cost_per_character": 3.125e-07,
        "input_cost_per_image_above_128k_tokens": 0.0006575,
        "input_cost_per_video_per_second_above_128k_tokens": 0.0006575,
        "input_cost_per_audio_per_second_above_128k_tokens": 6.25e-05,
        "input_cost_per_token_above_128k_tokens": 1.5625e-07,
        "input_cost_per_character_above_128k_tokens": 6.25e-07,
        "output_cost_per_token": 3.125e-07,
        "output_cost_per_character": 1.25e-06,
        "output_cost_per_token_above_128k_tokens": 6.25e-07,
        "output_cost_per_character_above_128k_tokens": 2.5e-06,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_response_schema": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_parallel_function_calling": True,
    },
    "gemini-1.5-flash": {
        "max_tokens": 8192,
        "max_input_tokens": 1000000,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_image": 2e-05,
        "input_cost_per_video_per_second": 2e-05,
        "input_cost_per_audio_per_second": 2e-06,
        "input_cost_per_token": 7.5e-08,
        "input_cost_per_character": 1.875e-08,
        "input_cost_per_token_above_128k_tokens": 1e-06,
        "input_cost_per_character_above_128k_tokens": 2.5e-07,
        "input_cost_per_image_above_128k_tokens": 4e-05,
        "input_cost_per_video_per_second_above_128k_tokens": 4e-05,
        "input_cost_per_audio_per_second_above_128k_tokens": 4e-06,
        "output_cost_per_token": 3e-07,
        "output_cost_per_character": 7.5e-08,
        "output_cost_per_token_above_128k_tokens": 6e-07,
        "output_cost_per_character_above_128k_tokens": 1.5e-07,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
        "supports_parallel_function_calling": True,
    },
    "gemini-1.5-flash-exp-0827": {
        "max_tokens": 8192,
        "max_input_tokens": 1000000,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_image": 2e-05,
        "input_cost_per_video_per_second": 2e-05,
        "input_cost_per_audio_per_second": 2e-06,
        "input_cost_per_token": 4.688e-09,
        "input_cost_per_character": 1.875e-08,
        "input_cost_per_token_above_128k_tokens": 1e-06,
        "input_cost_per_character_above_128k_tokens": 2.5e-07,
        "input_cost_per_image_above_128k_tokens": 4e-05,
        "input_cost_per_video_per_second_above_128k_tokens": 4e-05,
        "input_cost_per_audio_per_second_above_128k_tokens": 4e-06,
        "output_cost_per_token": 4.6875e-09,
        "output_cost_per_character": 1.875e-08,
        "output_cost_per_token_above_128k_tokens": 9.375e-09,
        "output_cost_per_character_above_128k_tokens": 3.75e-08,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
        "supports_parallel_function_calling": True,
    },
    "gemini-1.5-flash-002": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_image": 2e-05,
        "input_cost_per_video_per_second": 2e-05,
        "input_cost_per_audio_per_second": 2e-06,
        "input_cost_per_token": 7.5e-08,
        "input_cost_per_character": 1.875e-08,
        "input_cost_per_token_above_128k_tokens": 1e-06,
        "input_cost_per_character_above_128k_tokens": 2.5e-07,
        "input_cost_per_image_above_128k_tokens": 4e-05,
        "input_cost_per_video_per_second_above_128k_tokens": 4e-05,
        "input_cost_per_audio_per_second_above_128k_tokens": 4e-06,
        "output_cost_per_token": 3e-07,
        "output_cost_per_character": 7.5e-08,
        "output_cost_per_token_above_128k_tokens": 6e-07,
        "output_cost_per_character_above_128k_tokens": 1.5e-07,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#gemini-1.5-flash",
        "deprecation_date": "2025-09-24",
        "supports_tool_choice": True,
        "supports_parallel_function_calling": True,
    },
    "gemini-1.5-flash-001": {
        "max_tokens": 8192,
        "max_input_tokens": 1000000,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_image": 2e-05,
        "input_cost_per_video_per_second": 2e-05,
        "input_cost_per_audio_per_second": 2e-06,
        "input_cost_per_token": 7.5e-08,
        "input_cost_per_character": 1.875e-08,
        "input_cost_per_token_above_128k_tokens": 1e-06,
        "input_cost_per_character_above_128k_tokens": 2.5e-07,
        "input_cost_per_image_above_128k_tokens": 4e-05,
        "input_cost_per_video_per_second_above_128k_tokens": 4e-05,
        "input_cost_per_audio_per_second_above_128k_tokens": 4e-06,
        "output_cost_per_token": 3e-07,
        "output_cost_per_character": 7.5e-08,
        "output_cost_per_token_above_128k_tokens": 6e-07,
        "output_cost_per_character_above_128k_tokens": 1.5e-07,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "deprecation_date": "2025-05-24",
        "supports_tool_choice": True,
        "supports_parallel_function_calling": True,
    },
    "gemini-1.5-flash-preview-0514": {
        "max_tokens": 8192,
        "max_input_tokens": 1000000,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_image": 2e-05,
        "input_cost_per_video_per_second": 2e-05,
        "input_cost_per_audio_per_second": 2e-06,
        "input_cost_per_token": 7.5e-08,
        "input_cost_per_character": 1.875e-08,
        "input_cost_per_token_above_128k_tokens": 1e-06,
        "input_cost_per_character_above_128k_tokens": 2.5e-07,
        "input_cost_per_image_above_128k_tokens": 4e-05,
        "input_cost_per_video_per_second_above_128k_tokens": 4e-05,
        "input_cost_per_audio_per_second_above_128k_tokens": 4e-06,
        "output_cost_per_token": 4.6875e-09,
        "output_cost_per_character": 1.875e-08,
        "output_cost_per_token_above_128k_tokens": 9.375e-09,
        "output_cost_per_character_above_128k_tokens": 3.75e-08,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
        "supports_parallel_function_calling": True,
    },
    "gemini-pro-experimental": {
        "max_tokens": 8192,
        "max_input_tokens": 1000000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 0,
        "output_cost_per_token": 0,
        "input_cost_per_character": 0,
        "output_cost_per_character": 0,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_function_calling": False,
        "supports_tool_choice": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/multimodal/gemini-experimental",
        "supports_parallel_function_calling": True,
    },
    "gemini-flash-experimental": {
        "max_tokens": 8192,
        "max_input_tokens": 1000000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 0,
        "output_cost_per_token": 0,
        "input_cost_per_character": 0,
        "output_cost_per_character": 0,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_function_calling": False,
        "supports_tool_choice": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/multimodal/gemini-experimental",
        "supports_parallel_function_calling": True,
    },
    "gemini-pro-vision": {
        "max_tokens": 2048,
        "max_input_tokens": 16384,
        "max_output_tokens": 2048,
        "max_images_per_prompt": 16,
        "max_videos_per_prompt": 1,
        "max_video_length": 2,
        "input_cost_per_token": 5e-07,
        "output_cost_per_token": 1.5e-06,
        "input_cost_per_image": 0.0025,
        "litellm_provider": "vertex_ai-vision-models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
        "supports_parallel_function_calling": True,
    },
    "gemini-1.0-pro-vision": {
        "max_tokens": 2048,
        "max_input_tokens": 16384,
        "max_output_tokens": 2048,
        "max_images_per_prompt": 16,
        "max_videos_per_prompt": 1,
        "max_video_length": 2,
        "input_cost_per_token": 5e-07,
        "output_cost_per_token": 1.5e-06,
        "input_cost_per_image": 0.0025,
        "litellm_provider": "vertex_ai-vision-models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
        "supports_parallel_function_calling": True,
    },
    "gemini-1.0-pro-vision-001": {
        "max_tokens": 2048,
        "max_input_tokens": 16384,
        "max_output_tokens": 2048,
        "max_images_per_prompt": 16,
        "max_videos_per_prompt": 1,
        "max_video_length": 2,
        "input_cost_per_token": 5e-07,
        "output_cost_per_token": 1.5e-06,
        "input_cost_per_image": 0.0025,
        "litellm_provider": "vertex_ai-vision-models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "deprecation_date": "2025-04-09",
        "supports_tool_choice": True,
        "supports_parallel_function_calling": True,
    },
    "medlm-medium": {
        "max_tokens": 8192,
        "max_input_tokens": 32768,
        "max_output_tokens": 8192,
        "input_cost_per_character": 5e-07,
        "output_cost_per_character": 1e-06,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
    },
    "medlm-large": {
        "max_tokens": 1024,
        "max_input_tokens": 8192,
        "max_output_tokens": 1024,
        "input_cost_per_character": 5e-06,
        "output_cost_per_character": 1.5e-05,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
    },
    "gemini-2.5-pro-exp-03-25": {
        "max_tokens": 65535,
        "max_input_tokens": 1048576,
        "max_output_tokens": 65535,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_token": 1.25e-06,
        "input_cost_per_token_above_200k_tokens": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "output_cost_per_token_above_200k_tokens": 1.5e-05,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_audio_input": True,
        "supports_video_input": True,
        "supports_pdf_input": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "supported_endpoints": ["/v1/chat/completions", "/v1/completions"],
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text"],
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing",
        "supports_parallel_function_calling": True,
        "supports_web_search": True,
    },
    "gemini-2.0-pro-exp-02-05": {
        "max_tokens": 8192,
        "max_input_tokens": 2097152,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_token": 1.25e-06,
        "input_cost_per_token_above_200k_tokens": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "output_cost_per_token_above_200k_tokens": 1.5e-05,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_audio_input": True,
        "supports_video_input": True,
        "supports_pdf_input": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "supported_endpoints": ["/v1/chat/completions", "/v1/completions"],
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text"],
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing",
        "supports_parallel_function_calling": True,
        "supports_web_search": True,
    },
    "gemini-2.0-flash-exp": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_image": 0,
        "input_cost_per_video_per_second": 0,
        "input_cost_per_audio_per_second": 0,
        "input_cost_per_token": 1.5e-07,
        "input_cost_per_character": 0,
        "input_cost_per_token_above_128k_tokens": 0,
        "input_cost_per_character_above_128k_tokens": 0,
        "input_cost_per_image_above_128k_tokens": 0,
        "input_cost_per_video_per_second_above_128k_tokens": 0,
        "input_cost_per_audio_per_second_above_128k_tokens": 0,
        "output_cost_per_token": 6e-07,
        "output_cost_per_character": 0,
        "output_cost_per_token_above_128k_tokens": 0,
        "output_cost_per_character_above_128k_tokens": 0,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": True,
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text", "image"],
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing",
        "supports_tool_choice": True,
        "supports_parallel_function_calling": True,
        "supports_web_search": True,
    },
    "gemini-2.0-flash-001": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_audio_token": 1e-06,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": True,
        "supports_tool_choice": True,
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text", "image"],
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing",
        "deprecation_date": "2026-02-05",
        "supports_parallel_function_calling": True,
        "supports_web_search": True,
    },
    "gemini-2.0-flash-thinking-exp": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_image": 0,
        "input_cost_per_video_per_second": 0,
        "input_cost_per_audio_per_second": 0,
        "input_cost_per_token": 0,
        "input_cost_per_character": 0,
        "input_cost_per_token_above_128k_tokens": 0,
        "input_cost_per_character_above_128k_tokens": 0,
        "input_cost_per_image_above_128k_tokens": 0,
        "input_cost_per_video_per_second_above_128k_tokens": 0,
        "input_cost_per_audio_per_second_above_128k_tokens": 0,
        "output_cost_per_token": 0,
        "output_cost_per_character": 0,
        "output_cost_per_token_above_128k_tokens": 0,
        "output_cost_per_character_above_128k_tokens": 0,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": True,
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text", "image"],
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#gemini-2.0-flash",
        "supports_tool_choice": True,
        "supports_parallel_function_calling": True,
        "supports_web_search": True,
    },
    "gemini-2.0-flash-thinking-exp-01-21": {
        "max_tokens": 65536,
        "max_input_tokens": 1048576,
        "max_output_tokens": 65536,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_image": 0,
        "input_cost_per_video_per_second": 0,
        "input_cost_per_audio_per_second": 0,
        "input_cost_per_token": 0,
        "input_cost_per_character": 0,
        "input_cost_per_token_above_128k_tokens": 0,
        "input_cost_per_character_above_128k_tokens": 0,
        "input_cost_per_image_above_128k_tokens": 0,
        "input_cost_per_video_per_second_above_128k_tokens": 0,
        "input_cost_per_audio_per_second_above_128k_tokens": 0,
        "output_cost_per_token": 0,
        "output_cost_per_character": 0,
        "output_cost_per_token_above_128k_tokens": 0,
        "output_cost_per_character_above_128k_tokens": 0,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": False,
        "supports_vision": True,
        "supports_response_schema": False,
        "supports_audio_output": False,
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text", "image"],
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#gemini-2.0-flash",
        "supports_tool_choice": True,
        "supports_parallel_function_calling": True,
        "supports_web_search": True,
    },
    "gemini/gemini-2.5-pro-exp-03-25": {
        "max_tokens": 65535,
        "max_input_tokens": 1048576,
        "max_output_tokens": 65535,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_token": 0.0,
        "input_cost_per_token_above_200k_tokens": 0.0,
        "output_cost_per_token": 0.0,
        "output_cost_per_token_above_200k_tokens": 0.0,
        "litellm_provider": "gemini",
        "mode": "chat",
        "rpm": 5,
        "tpm": 250000,
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_audio_input": True,
        "supports_video_input": True,
        "supports_pdf_input": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "supported_endpoints": ["/v1/chat/completions", "/v1/completions"],
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text"],
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing",
        "supports_web_search": True,
    },
    "gemini/gemini-2.5-flash-preview-tts": {
        "max_tokens": 65535,
        "max_input_tokens": 1048576,
        "max_output_tokens": 65535,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_audio_token": 1e-06,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 6e-07,
        "output_cost_per_reasoning_token": 3.5e-06,
        "litellm_provider": "gemini",
        "mode": "chat",
        "rpm": 10,
        "tpm": 250000,
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_reasoning": True,
        "supports_response_schema": True,
        "supports_audio_output": False,
        "supports_tool_choice": True,
        "supported_endpoints": ["/v1/chat/completions", "/v1/completions"],
        "supported_modalities": ["text"],
        "supported_output_modalities": ["audio"],
        "source": "https://ai.google.dev/gemini-api/docs/models#gemini-2.5-flash-preview",
        "supports_web_search": True,
    },
    "gemini/gemini-2.5-flash-preview-05-20": {
        "max_tokens": 65535,
        "max_input_tokens": 1048576,
        "max_output_tokens": 65535,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_audio_token": 1e-06,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 6e-07,
        "output_cost_per_reasoning_token": 3.5e-06,
        "litellm_provider": "gemini",
        "mode": "chat",
        "rpm": 10,
        "tpm": 250000,
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_reasoning": True,
        "supports_response_schema": True,
        "supports_audio_output": False,
        "supports_tool_choice": True,
        "supported_endpoints": ["/v1/chat/completions", "/v1/completions"],
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text"],
        "source": "https://ai.google.dev/gemini-api/docs/models#gemini-2.5-flash-preview",
        "supports_web_search": True,
        "supports_url_context": True,
    },
    "gemini/gemini-2.5-flash-preview-04-17": {
        "max_tokens": 65535,
        "max_input_tokens": 1048576,
        "max_output_tokens": 65535,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_audio_token": 1e-06,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 6e-07,
        "output_cost_per_reasoning_token": 3.5e-06,
        "litellm_provider": "gemini",
        "mode": "chat",
        "rpm": 10,
        "tpm": 250000,
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_reasoning": True,
        "supports_response_schema": True,
        "supports_audio_output": False,
        "supports_tool_choice": True,
        "supported_endpoints": ["/v1/chat/completions", "/v1/completions"],
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text"],
        "source": "https://ai.google.dev/gemini-api/docs/models#gemini-2.5-flash-preview",
        "supports_web_search": True,
    },
    "gemini-2.5-flash-preview-05-20": {
        "max_tokens": 65535,
        "max_input_tokens": 1048576,
        "max_output_tokens": 65535,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_audio_token": 1e-06,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 6e-07,
        "output_cost_per_reasoning_token": 3.5e-06,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_reasoning": True,
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": False,
        "supports_tool_choice": True,
        "supported_endpoints": [
            "/v1/chat/completions",
            "/v1/completions",
            "/v1/batch",
        ],
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text"],
        "source": "https://ai.google.dev/gemini-api/docs/models#gemini-2.5-flash-preview",
        "supports_parallel_function_calling": True,
        "supports_web_search": True,
        "supports_url_context": True,
    },
    "gemini-2.5-flash-preview-04-17": {
        "max_tokens": 65535,
        "max_input_tokens": 1048576,
        "max_output_tokens": 65535,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_audio_token": 1e-06,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 6e-07,
        "output_cost_per_reasoning_token": 3.5e-06,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_reasoning": True,
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": False,
        "supports_tool_choice": True,
        "supported_endpoints": [
            "/v1/chat/completions",
            "/v1/completions",
            "/v1/batch",
        ],
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text"],
        "source": "https://ai.google.dev/gemini-api/docs/models#gemini-2.5-flash-preview",
        "supports_parallel_function_calling": True,
        "supports_web_search": True,
    },
    "gemini-2.0-flash": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_audio_token": 7e-07,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 4e-07,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": True,
        "supports_audio_input": True,
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text", "image"],
        "supports_tool_choice": True,
        "source": "https://ai.google.dev/pricing#2_0flash",
        "supports_parallel_function_calling": True,
        "supports_web_search": True,
        "supports_url_context": True,
    },
    "gemini-2.0-flash-lite": {
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 50,
        "input_cost_per_audio_token": 7.5e-08,
        "input_cost_per_token": 7.5e-08,
        "output_cost_per_token": 3e-07,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": True,
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text"],
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#gemini-2.0-flash",
        "supports_tool_choice": True,
        "supports_parallel_function_calling": True,
        "supports_web_search": True,
    },
    "gemini-2.0-flash-lite-001": {
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 50,
        "input_cost_per_audio_token": 7.5e-08,
        "input_cost_per_token": 7.5e-08,
        "output_cost_per_token": 3e-07,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": True,
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text"],
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#gemini-2.0-flash",
        "supports_tool_choice": True,
        "deprecation_date": "2026-02-25",
        "supports_parallel_function_calling": True,
        "supports_web_search": True,
    },
    "gemini-2.5-pro-preview-06-05": {
        "max_tokens": 65535,
        "max_input_tokens": 1048576,
        "max_output_tokens": 65535,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_audio_token": 1.25e-06,
        "input_cost_per_token": 1.25e-06,
        "input_cost_per_token_above_200k_tokens": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "output_cost_per_token_above_200k_tokens": 1.5e-05,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_reasoning": True,
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": False,
        "supports_tool_choice": True,
        "supported_endpoints": [
            "/v1/chat/completions",
            "/v1/completions",
            "/v1/batch",
        ],
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text"],
        "source": "https://ai.google.dev/gemini-api/docs/models#gemini-2.5-flash-preview",
        "supports_parallel_function_calling": True,
        "supports_web_search": True,
    },
    "gemini-2.5-pro-preview-05-06": {
        "max_tokens": 65535,
        "max_input_tokens": 1048576,
        "max_output_tokens": 65535,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_audio_token": 1.25e-06,
        "input_cost_per_token": 1.25e-06,
        "input_cost_per_token_above_200k_tokens": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "output_cost_per_token_above_200k_tokens": 1.5e-05,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_reasoning": True,
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": False,
        "supports_tool_choice": True,
        "supported_endpoints": [
            "/v1/chat/completions",
            "/v1/completions",
            "/v1/batch",
        ],
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text"],
        "supported_regions": ["global"],
        "source": "https://ai.google.dev/gemini-api/docs/models#gemini-2.5-flash-preview",
        "supports_parallel_function_calling": True,
        "supports_web_search": True,
    },
    "gemini-2.5-pro-preview-03-25": {
        "max_tokens": 65535,
        "max_input_tokens": 1048576,
        "max_output_tokens": 65535,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_audio_token": 1.25e-06,
        "input_cost_per_token": 1.25e-06,
        "input_cost_per_token_above_200k_tokens": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "output_cost_per_token_above_200k_tokens": 1.5e-05,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_reasoning": True,
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": False,
        "supports_tool_choice": True,
        "supported_endpoints": [
            "/v1/chat/completions",
            "/v1/completions",
            "/v1/batch",
        ],
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text"],
        "source": "https://ai.google.dev/gemini-api/docs/models#gemini-2.5-flash-preview",
        "supports_parallel_function_calling": True,
        "supports_web_search": True,
    },
    "gemini-2.0-flash-preview-image-generation": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_audio_token": 7e-07,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 4e-07,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": True,
        "supports_audio_input": True,
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text", "image"],
        "supports_tool_choice": True,
        "source": "https://ai.google.dev/pricing#2_0flash",
        "supports_parallel_function_calling": True,
        "supports_web_search": True,
    },
    "gemini-2.5-pro-preview-tts": {
        "max_tokens": 65535,
        "max_input_tokens": 1048576,
        "max_output_tokens": 65535,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_audio_token": 7e-07,
        "input_cost_per_token": 1.25e-06,
        "input_cost_per_token_above_200k_tokens": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "output_cost_per_token_above_200k_tokens": 1.5e-05,
        "litellm_provider": "vertex_ai-language-models",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": False,
        "supports_tool_choice": True,
        "supported_modalities": ["text"],
        "supported_output_modalities": ["audio"],
        "source": "https://ai.google.dev/gemini-api/docs/pricing#gemini-2.5-pro-preview",
        "supports_parallel_function_calling": True,
        "supports_web_search": True,
    },
    "gemini/gemini-2.0-pro-exp-02-05": {
        "max_tokens": 8192,
        "max_input_tokens": 2097152,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_image": 0,
        "input_cost_per_video_per_second": 0,
        "input_cost_per_audio_per_second": 0,
        "input_cost_per_token": 0,
        "input_cost_per_character": 0,
        "input_cost_per_token_above_128k_tokens": 0,
        "input_cost_per_character_above_128k_tokens": 0,
        "input_cost_per_image_above_128k_tokens": 0,
        "input_cost_per_video_per_second_above_128k_tokens": 0,
        "input_cost_per_audio_per_second_above_128k_tokens": 0,
        "output_cost_per_token": 0,
        "output_cost_per_character": 0,
        "output_cost_per_token_above_128k_tokens": 0,
        "output_cost_per_character_above_128k_tokens": 0,
        "litellm_provider": "gemini",
        "mode": "chat",
        "rpm": 2,
        "tpm": 1000000,
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_audio_input": True,
        "supports_video_input": True,
        "supports_pdf_input": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing",
        "supports_web_search": True,
    },
    "gemini/gemini-2.0-flash-preview-image-generation": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_audio_token": 7e-07,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 4e-07,
        "litellm_provider": "gemini",
        "mode": "chat",
        "rpm": 10000,
        "tpm": 10000000,
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": True,
        "supports_audio_input": True,
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text", "image"],
        "supports_tool_choice": True,
        "source": "https://ai.google.dev/pricing#2_0flash",
        "supports_web_search": True,
    },
    "gemini/gemini-2.0-flash": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_audio_token": 7e-07,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 4e-07,
        "litellm_provider": "gemini",
        "mode": "chat",
        "rpm": 10000,
        "tpm": 10000000,
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": True,
        "supports_audio_input": True,
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text", "image"],
        "supports_tool_choice": True,
        "source": "https://ai.google.dev/pricing#2_0flash",
        "supports_web_search": True,
        "supports_url_context": True,
    },
    "gemini/gemini-2.0-flash-lite": {
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 50,
        "input_cost_per_audio_token": 7.5e-08,
        "input_cost_per_token": 7.5e-08,
        "output_cost_per_token": 3e-07,
        "litellm_provider": "gemini",
        "mode": "chat",
        "tpm": 4000000,
        "rpm": 4000,
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": True,
        "supports_tool_choice": True,
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text"],
        "source": "https://ai.google.dev/gemini-api/docs/pricing#gemini-2.0-flash-lite",
        "supports_web_search": True,
    },
    "gemini/gemini-2.0-flash-001": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_audio_token": 7e-07,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 4e-07,
        "litellm_provider": "gemini",
        "mode": "chat",
        "rpm": 10000,
        "tpm": 10000000,
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": False,
        "supports_tool_choice": True,
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text", "image"],
        "source": "https://ai.google.dev/pricing#2_0flash",
        "supports_web_search": True,
    },
    "gemini/gemini-2.5-pro-preview-tts": {
        "max_tokens": 65535,
        "max_input_tokens": 1048576,
        "max_output_tokens": 65535,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_audio_token": 7e-07,
        "input_cost_per_token": 1.25e-06,
        "input_cost_per_token_above_200k_tokens": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "output_cost_per_token_above_200k_tokens": 1.5e-05,
        "litellm_provider": "gemini",
        "mode": "chat",
        "rpm": 10000,
        "tpm": 10000000,
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": False,
        "supports_tool_choice": True,
        "supported_modalities": ["text"],
        "supported_output_modalities": ["audio"],
        "source": "https://ai.google.dev/gemini-api/docs/pricing#gemini-2.5-pro-preview",
        "supports_web_search": True,
    },
    "gemini/gemini-2.5-pro-preview-06-05": {
        "max_tokens": 65535,
        "max_input_tokens": 1048576,
        "max_output_tokens": 65535,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_audio_token": 7e-07,
        "input_cost_per_token": 1.25e-06,
        "input_cost_per_token_above_200k_tokens": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "output_cost_per_token_above_200k_tokens": 1.5e-05,
        "litellm_provider": "gemini",
        "mode": "chat",
        "rpm": 10000,
        "tpm": 10000000,
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": False,
        "supports_tool_choice": True,
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text"],
        "source": "https://ai.google.dev/gemini-api/docs/pricing#gemini-2.5-pro-preview",
        "supports_web_search": True,
        "supports_url_context": True,
    },
    "gemini/gemini-2.5-pro-preview-05-06": {
        "max_tokens": 65535,
        "max_input_tokens": 1048576,
        "max_output_tokens": 65535,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_audio_token": 7e-07,
        "input_cost_per_token": 1.25e-06,
        "input_cost_per_token_above_200k_tokens": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "output_cost_per_token_above_200k_tokens": 1.5e-05,
        "litellm_provider": "gemini",
        "mode": "chat",
        "rpm": 10000,
        "tpm": 10000000,
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": False,
        "supports_tool_choice": True,
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text"],
        "source": "https://ai.google.dev/gemini-api/docs/pricing#gemini-2.5-pro-preview",
        "supports_web_search": True,
        "supports_url_context": True,
    },
    "gemini/gemini-2.5-pro-preview-03-25": {
        "max_tokens": 65535,
        "max_input_tokens": 1048576,
        "max_output_tokens": 65535,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_audio_token": 7e-07,
        "input_cost_per_token": 1.25e-06,
        "input_cost_per_token_above_200k_tokens": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "output_cost_per_token_above_200k_tokens": 1.5e-05,
        "litellm_provider": "gemini",
        "mode": "chat",
        "rpm": 10000,
        "tpm": 10000000,
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": False,
        "supports_tool_choice": True,
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text"],
        "source": "https://ai.google.dev/gemini-api/docs/pricing#gemini-2.5-pro-preview",
        "supports_web_search": True,
    },
    "gemini/gemini-2.0-flash-exp": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_image": 0,
        "input_cost_per_video_per_second": 0,
        "input_cost_per_audio_per_second": 0,
        "input_cost_per_token": 0,
        "input_cost_per_character": 0,
        "input_cost_per_token_above_128k_tokens": 0,
        "input_cost_per_character_above_128k_tokens": 0,
        "input_cost_per_image_above_128k_tokens": 0,
        "input_cost_per_video_per_second_above_128k_tokens": 0,
        "input_cost_per_audio_per_second_above_128k_tokens": 0,
        "output_cost_per_token": 0,
        "output_cost_per_character": 0,
        "output_cost_per_token_above_128k_tokens": 0,
        "output_cost_per_character_above_128k_tokens": 0,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": True,
        "tpm": 4000000,
        "rpm": 10,
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text", "image"],
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#gemini-2.0-flash",
        "supports_tool_choice": True,
        "supports_web_search": True,
    },
    "gemini/gemini-2.0-flash-lite-preview-02-05": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_audio_token": 7.5e-08,
        "input_cost_per_token": 7.5e-08,
        "output_cost_per_token": 3e-07,
        "litellm_provider": "gemini",
        "mode": "chat",
        "rpm": 60000,
        "tpm": 10000000,
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": False,
        "supports_tool_choice": True,
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text"],
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#gemini-2.0-flash-lite",
        "supports_web_search": True,
    },
    "gemini/gemini-2.0-flash-thinking-exp": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 65536,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_image": 0,
        "input_cost_per_video_per_second": 0,
        "input_cost_per_audio_per_second": 0,
        "input_cost_per_token": 0,
        "input_cost_per_character": 0,
        "input_cost_per_token_above_128k_tokens": 0,
        "input_cost_per_character_above_128k_tokens": 0,
        "input_cost_per_image_above_128k_tokens": 0,
        "input_cost_per_video_per_second_above_128k_tokens": 0,
        "input_cost_per_audio_per_second_above_128k_tokens": 0,
        "output_cost_per_token": 0,
        "output_cost_per_character": 0,
        "output_cost_per_token_above_128k_tokens": 0,
        "output_cost_per_character_above_128k_tokens": 0,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": True,
        "tpm": 4000000,
        "rpm": 10,
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text", "image"],
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#gemini-2.0-flash",
        "supports_tool_choice": True,
        "supports_web_search": True,
    },
    "gemini/gemini-2.0-flash-thinking-exp-01-21": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 65536,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_image": 0,
        "input_cost_per_video_per_second": 0,
        "input_cost_per_audio_per_second": 0,
        "input_cost_per_token": 0,
        "input_cost_per_character": 0,
        "input_cost_per_token_above_128k_tokens": 0,
        "input_cost_per_character_above_128k_tokens": 0,
        "input_cost_per_image_above_128k_tokens": 0,
        "input_cost_per_video_per_second_above_128k_tokens": 0,
        "input_cost_per_audio_per_second_above_128k_tokens": 0,
        "output_cost_per_token": 0,
        "output_cost_per_character": 0,
        "output_cost_per_token_above_128k_tokens": 0,
        "output_cost_per_character_above_128k_tokens": 0,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": True,
        "tpm": 4000000,
        "rpm": 10,
        "supported_modalities": ["text", "image", "audio", "video"],
        "supported_output_modalities": ["text", "image"],
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#gemini-2.0-flash",
        "supports_tool_choice": True,
        "supports_web_search": True,
    },
    "gemini/gemma-3-27b-it": {
        "max_tokens": 8192,
        "max_input_tokens": 131072,
        "max_output_tokens": 8192,
        "input_cost_per_image": 0,
        "input_cost_per_video_per_second": 0,
        "input_cost_per_audio_per_second": 0,
        "input_cost_per_token": 0,
        "input_cost_per_character": 0,
        "input_cost_per_token_above_128k_tokens": 0,
        "input_cost_per_character_above_128k_tokens": 0,
        "input_cost_per_image_above_128k_tokens": 0,
        "input_cost_per_video_per_second_above_128k_tokens": 0,
        "input_cost_per_audio_per_second_above_128k_tokens": 0,
        "output_cost_per_token": 0,
        "output_cost_per_character": 0,
        "output_cost_per_token_above_128k_tokens": 0,
        "output_cost_per_character_above_128k_tokens": 0,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": False,
        "source": "https://aistudio.google.com",
        "supports_tool_choice": True,
    },
    "gemini/learnlm-1.5-pro-experimental": {
        "max_tokens": 8192,
        "max_input_tokens": 32767,
        "max_output_tokens": 8192,
        "input_cost_per_image": 0,
        "input_cost_per_video_per_second": 0,
        "input_cost_per_audio_per_second": 0,
        "input_cost_per_token": 0,
        "input_cost_per_character": 0,
        "input_cost_per_token_above_128k_tokens": 0,
        "input_cost_per_character_above_128k_tokens": 0,
        "input_cost_per_image_above_128k_tokens": 0,
        "input_cost_per_video_per_second_above_128k_tokens": 0,
        "input_cost_per_audio_per_second_above_128k_tokens": 0,
        "output_cost_per_token": 0,
        "output_cost_per_character": 0,
        "output_cost_per_token_above_128k_tokens": 0,
        "output_cost_per_character_above_128k_tokens": 0,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": False,
        "source": "https://aistudio.google.com",
        "supports_tool_choice": True,
    },
    "vertex_ai/claude-3-sonnet": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "vertex_ai-anthropic_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/claude-3-sonnet@20240229": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "vertex_ai-anthropic_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/claude-3-5-sonnet": {
        "supports_computer_use": True,
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "vertex_ai-anthropic_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_pdf_input": True,
        "supports_vision": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/claude-3-5-sonnet@20240620": {
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "vertex_ai-anthropic_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_pdf_input": True,
        "supports_vision": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/claude-3-5-sonnet-v2": {
        "supports_computer_use": True,
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "vertex_ai-anthropic_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_pdf_input": True,
        "supports_vision": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/claude-3-5-sonnet-v2@20241022": {
        "supports_computer_use": True,
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "vertex_ai-anthropic_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_pdf_input": True,
        "supports_vision": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/claude-3-7-sonnet@20250219": {
        "supports_computer_use": True,
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "cache_creation_input_token_cost": 3.75e-06,
        "cache_read_input_token_cost": 3e-07,
        "litellm_provider": "vertex_ai-anthropic_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_pdf_input": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "deprecation_date": "2025-06-01",
        "supports_reasoning": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/claude-opus-4": {
        "max_tokens": 32000,
        "max_input_tokens": 200000,
        "max_output_tokens": 32000,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 7.5e-05,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.01,
            "search_context_size_medium": 0.01,
            "search_context_size_high": 0.01,
        },
        "cache_creation_input_token_cost": 1.875e-05,
        "cache_read_input_token_cost": 1.5e-06,
        "litellm_provider": "vertex_ai-anthropic_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supports_computer_use": True,
    },
    "vertex_ai/claude-opus-4@20250514": {
        "max_tokens": 32000,
        "max_input_tokens": 200000,
        "max_output_tokens": 32000,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 7.5e-05,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.01,
            "search_context_size_medium": 0.01,
            "search_context_size_high": 0.01,
        },
        "cache_creation_input_token_cost": 1.875e-05,
        "cache_read_input_token_cost": 1.5e-06,
        "litellm_provider": "vertex_ai-anthropic_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supports_computer_use": True,
    },
    "vertex_ai/claude-sonnet-4": {
        "max_tokens": 64000,
        "max_input_tokens": 200000,
        "max_output_tokens": 64000,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.01,
            "search_context_size_medium": 0.01,
            "search_context_size_high": 0.01,
        },
        "cache_creation_input_token_cost": 3.75e-06,
        "cache_read_input_token_cost": 3e-07,
        "litellm_provider": "vertex_ai-anthropic_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supports_computer_use": True,
    },
    "vertex_ai/claude-sonnet-4@20250514": {
        "max_tokens": 64000,
        "max_input_tokens": 200000,
        "max_output_tokens": 64000,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.01,
            "search_context_size_medium": 0.01,
            "search_context_size_high": 0.01,
        },
        "cache_creation_input_token_cost": 3.75e-06,
        "cache_read_input_token_cost": 3e-07,
        "litellm_provider": "vertex_ai-anthropic_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supports_computer_use": True,
    },
    "vertex_ai/claude-3-haiku": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2.5e-07,
        "output_cost_per_token": 1.25e-06,
        "litellm_provider": "vertex_ai-anthropic_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/claude-3-haiku@20240307": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2.5e-07,
        "output_cost_per_token": 1.25e-06,
        "litellm_provider": "vertex_ai-anthropic_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/claude-3-5-haiku": {
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 5e-06,
        "litellm_provider": "vertex_ai-anthropic_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_pdf_input": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/claude-3-5-haiku@20241022": {
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 5e-06,
        "litellm_provider": "vertex_ai-anthropic_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_pdf_input": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/claude-3-opus": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 7.5e-05,
        "litellm_provider": "vertex_ai-anthropic_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/claude-3-opus@20240229": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 7.5e-05,
        "litellm_provider": "vertex_ai-anthropic_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/meta/llama3-405b-instruct-maas": {
        "max_tokens": 32000,
        "max_input_tokens": 32000,
        "max_output_tokens": 32000,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "vertex_ai-llama_models",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing#partner-models",
        "supports_tool_choice": True,
    },
    "vertex_ai/meta/llama-4-scout-17b-16e-instruct-maas": {
        "max_tokens": 10000000.0,
        "max_input_tokens": 10000000.0,
        "max_output_tokens": 10000000.0,
        "input_cost_per_token": 2.5e-07,
        "output_cost_per_token": 7e-07,
        "litellm_provider": "vertex_ai-llama_models",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing#partner-models",
        "supports_tool_choice": True,
        "supports_function_calling": True,
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text", "code"],
    },
    "vertex_ai/meta/llama-4-scout-17b-128e-instruct-maas": {
        "max_tokens": 10000000.0,
        "max_input_tokens": 10000000.0,
        "max_output_tokens": 10000000.0,
        "input_cost_per_token": 2.5e-07,
        "output_cost_per_token": 7e-07,
        "litellm_provider": "vertex_ai-llama_models",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing#partner-models",
        "supports_tool_choice": True,
        "supports_function_calling": True,
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text", "code"],
    },
    "vertex_ai/meta/llama-4-maverick-17b-128e-instruct-maas": {
        "max_tokens": 1000000.0,
        "max_input_tokens": 1000000.0,
        "max_output_tokens": 1000000.0,
        "input_cost_per_token": 3.5e-07,
        "output_cost_per_token": 1.15e-06,
        "litellm_provider": "vertex_ai-llama_models",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing#partner-models",
        "supports_tool_choice": True,
        "supports_function_calling": True,
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text", "code"],
    },
    "vertex_ai/meta/llama-4-maverick-17b-16e-instruct-maas": {
        "max_tokens": 1000000.0,
        "max_input_tokens": 1000000.0,
        "max_output_tokens": 1000000.0,
        "input_cost_per_token": 3.5e-07,
        "output_cost_per_token": 1.15e-06,
        "litellm_provider": "vertex_ai-llama_models",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing#partner-models",
        "supports_tool_choice": True,
        "supports_function_calling": True,
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text", "code"],
    },
    "vertex_ai/meta/llama3-70b-instruct-maas": {
        "max_tokens": 32000,
        "max_input_tokens": 32000,
        "max_output_tokens": 32000,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "vertex_ai-llama_models",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing#partner-models",
        "supports_tool_choice": True,
    },
    "vertex_ai/meta/llama3-8b-instruct-maas": {
        "max_tokens": 32000,
        "max_input_tokens": 32000,
        "max_output_tokens": 32000,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "vertex_ai-llama_models",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing#partner-models",
        "supports_tool_choice": True,
    },
    "vertex_ai/meta/llama-3.2-90b-vision-instruct-maas": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 2048,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "vertex_ai-llama_models",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_vision": True,
        "source": "https://console.cloud.google.com/vertex-ai/publishers/meta/model-garden/llama-3.2-90b-vision-instruct-maas",
        "supports_tool_choice": True,
    },
    "vertex_ai/mistral-large@latest": {
        "max_tokens": 8191,
        "max_input_tokens": 128000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 6e-06,
        "litellm_provider": "vertex_ai-mistral_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/mistral-large@2411-001": {
        "max_tokens": 8191,
        "max_input_tokens": 128000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 6e-06,
        "litellm_provider": "vertex_ai-mistral_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/mistral-large-2411": {
        "max_tokens": 8191,
        "max_input_tokens": 128000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 6e-06,
        "litellm_provider": "vertex_ai-mistral_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/mistral-large@2407": {
        "max_tokens": 8191,
        "max_input_tokens": 128000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 6e-06,
        "litellm_provider": "vertex_ai-mistral_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/mistral-nemo@latest": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 1.5e-07,
        "litellm_provider": "vertex_ai-mistral_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/mistral-small-2503@001": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 3e-06,
        "litellm_provider": "vertex_ai-mistral_models",
        "supports_function_calling": True,
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "vertex_ai/mistral-small-2503": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 3e-06,
        "litellm_provider": "vertex_ai-mistral_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/jamba-1.5-mini@001": {
        "max_tokens": 256000,
        "max_input_tokens": 256000,
        "max_output_tokens": 256000,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 4e-07,
        "litellm_provider": "vertex_ai-ai21_models",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "vertex_ai/jamba-1.5-large@001": {
        "max_tokens": 256000,
        "max_input_tokens": 256000,
        "max_output_tokens": 256000,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 8e-06,
        "litellm_provider": "vertex_ai-ai21_models",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "vertex_ai/jamba-1.5": {
        "max_tokens": 256000,
        "max_input_tokens": 256000,
        "max_output_tokens": 256000,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 4e-07,
        "litellm_provider": "vertex_ai-ai21_models",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "vertex_ai/jamba-1.5-mini": {
        "max_tokens": 256000,
        "max_input_tokens": 256000,
        "max_output_tokens": 256000,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 4e-07,
        "litellm_provider": "vertex_ai-ai21_models",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "vertex_ai/jamba-1.5-large": {
        "max_tokens": 256000,
        "max_input_tokens": 256000,
        "max_output_tokens": 256000,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 8e-06,
        "litellm_provider": "vertex_ai-ai21_models",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "vertex_ai/mistral-nemo@2407": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 3e-06,
        "litellm_provider": "vertex_ai-mistral_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/codestral@latest": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "vertex_ai-mistral_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/codestral@2405": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "vertex_ai-mistral_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/codestral-2501": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "vertex_ai-mistral_models",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "vertex_ai/imagegeneration@006": {
        "output_cost_per_image": 0.02,
        "litellm_provider": "vertex_ai-image-models",
        "mode": "image_generation",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing",
    },
    "vertex_ai/imagen-4.0-generate-preview-06-06": {
        "output_cost_per_image": 0.04,
        "litellm_provider": "vertex_ai-image-models",
        "mode": "image_generation",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing",
    },
    "vertex_ai/imagen-4.0-ultra-generate-preview-06-06": {
        "output_cost_per_image": 0.06,
        "litellm_provider": "vertex_ai-image-models",
        "mode": "image_generation",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing",
    },
    "vertex_ai/imagen-4.0-fast-generate-preview-06-06": {
        "output_cost_per_image": 0.02,
        "litellm_provider": "vertex_ai-image-models",
        "mode": "image_generation",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing",
    },
    "vertex_ai/imagen-3.0-generate-002": {
        "output_cost_per_image": 0.04,
        "litellm_provider": "vertex_ai-image-models",
        "mode": "image_generation",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing",
    },
    "vertex_ai/imagen-3.0-generate-001": {
        "output_cost_per_image": 0.04,
        "litellm_provider": "vertex_ai-image-models",
        "mode": "image_generation",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing",
    },
    "vertex_ai/imagen-3.0-fast-generate-001": {
        "output_cost_per_image": 0.02,
        "litellm_provider": "vertex_ai-image-models",
        "mode": "image_generation",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing",
    },
    "text-embedding-004": {
        "max_tokens": 2048,
        "max_input_tokens": 2048,
        "output_vector_size": 768,
        "input_cost_per_character": 2.5e-08,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0,
        "litellm_provider": "vertex_ai-embedding-models",
        "mode": "embedding",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models",
    },
    "gemini-embedding-001": {
        "max_tokens": 2048,
        "max_input_tokens": 2048,
        "output_vector_size": 3072,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 0,
        "litellm_provider": "vertex_ai-embedding-models",
        "mode": "embedding",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models",
    },
    "text-embedding-005": {
        "max_tokens": 2048,
        "max_input_tokens": 2048,
        "output_vector_size": 768,
        "input_cost_per_character": 2.5e-08,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0,
        "litellm_provider": "vertex_ai-embedding-models",
        "mode": "embedding",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models",
    },
    "text-multilingual-embedding-002": {
        "max_tokens": 2048,
        "max_input_tokens": 2048,
        "output_vector_size": 768,
        "input_cost_per_character": 2.5e-08,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0,
        "litellm_provider": "vertex_ai-embedding-models",
        "mode": "embedding",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models",
    },
    "multimodalembedding": {
        "max_tokens": 2048,
        "max_input_tokens": 2048,
        "output_vector_size": 768,
        "input_cost_per_character": 2e-07,
        "input_cost_per_image": 0.0001,
        "input_cost_per_video_per_second": 0.0005,
        "input_cost_per_video_per_second_above_8s_interval": 0.001,
        "input_cost_per_video_per_second_above_15s_interval": 0.002,
        "input_cost_per_token": 8e-07,
        "output_cost_per_token": 0,
        "litellm_provider": "vertex_ai-embedding-models",
        "mode": "embedding",
        "supported_endpoints": ["/v1/embeddings"],
        "supported_modalities": ["text", "image", "video"],
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models",
    },
    "multimodalembedding@001": {
        "max_tokens": 2048,
        "max_input_tokens": 2048,
        "output_vector_size": 768,
        "input_cost_per_character": 2e-07,
        "input_cost_per_image": 0.0001,
        "input_cost_per_video_per_second": 0.0005,
        "input_cost_per_video_per_second_above_8s_interval": 0.001,
        "input_cost_per_video_per_second_above_15s_interval": 0.002,
        "input_cost_per_token": 8e-07,
        "output_cost_per_token": 0,
        "litellm_provider": "vertex_ai-embedding-models",
        "mode": "embedding",
        "supported_endpoints": ["/v1/embeddings"],
        "supported_modalities": ["text", "image", "video"],
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models",
    },
    "text-embedding-large-exp-03-07": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "output_vector_size": 3072,
        "input_cost_per_character": 2.5e-08,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0,
        "litellm_provider": "vertex_ai-embedding-models",
        "mode": "embedding",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models",
    },
    "textembedding-gecko": {
        "max_tokens": 3072,
        "max_input_tokens": 3072,
        "output_vector_size": 768,
        "input_cost_per_character": 2.5e-08,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0,
        "litellm_provider": "vertex_ai-embedding-models",
        "mode": "embedding",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "textembedding-gecko-multilingual": {
        "max_tokens": 3072,
        "max_input_tokens": 3072,
        "output_vector_size": 768,
        "input_cost_per_character": 2.5e-08,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0,
        "litellm_provider": "vertex_ai-embedding-models",
        "mode": "embedding",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "textembedding-gecko-multilingual@001": {
        "max_tokens": 3072,
        "max_input_tokens": 3072,
        "output_vector_size": 768,
        "input_cost_per_character": 2.5e-08,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0,
        "litellm_provider": "vertex_ai-embedding-models",
        "mode": "embedding",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "textembedding-gecko@001": {
        "max_tokens": 3072,
        "max_input_tokens": 3072,
        "output_vector_size": 768,
        "input_cost_per_character": 2.5e-08,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0,
        "litellm_provider": "vertex_ai-embedding-models",
        "mode": "embedding",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "textembedding-gecko@003": {
        "max_tokens": 3072,
        "max_input_tokens": 3072,
        "output_vector_size": 768,
        "input_cost_per_character": 2.5e-08,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0,
        "litellm_provider": "vertex_ai-embedding-models",
        "mode": "embedding",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "text-embedding-preview-0409": {
        "max_tokens": 3072,
        "max_input_tokens": 3072,
        "output_vector_size": 768,
        "input_cost_per_token": 6.25e-09,
        "input_cost_per_token_batch_requests": 5e-09,
        "output_cost_per_token": 0,
        "litellm_provider": "vertex_ai-embedding-models",
        "mode": "embedding",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/pricing",
    },
    "text-multilingual-embedding-preview-0409": {
        "max_tokens": 3072,
        "max_input_tokens": 3072,
        "output_vector_size": 768,
        "input_cost_per_token": 6.25e-09,
        "output_cost_per_token": 0,
        "litellm_provider": "vertex_ai-embedding-models",
        "mode": "embedding",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "palm/chat-bison": {
        "max_tokens": 4096,
        "max_input_tokens": 8192,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "litellm_provider": "palm",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "palm/chat-bison-001": {
        "max_tokens": 4096,
        "max_input_tokens": 8192,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "litellm_provider": "palm",
        "mode": "chat",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "palm/text-bison": {
        "max_tokens": 1024,
        "max_input_tokens": 8192,
        "max_output_tokens": 1024,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "litellm_provider": "palm",
        "mode": "completion",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "palm/text-bison-001": {
        "max_tokens": 1024,
        "max_input_tokens": 8192,
        "max_output_tokens": 1024,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "litellm_provider": "palm",
        "mode": "completion",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "palm/text-bison-safety-off": {
        "max_tokens": 1024,
        "max_input_tokens": 8192,
        "max_output_tokens": 1024,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "litellm_provider": "palm",
        "mode": "completion",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "palm/text-bison-safety-recitation-off": {
        "max_tokens": 1024,
        "max_input_tokens": 8192,
        "max_output_tokens": 1024,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 1.25e-07,
        "litellm_provider": "palm",
        "mode": "completion",
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
    },
    "gemini/gemini-1.5-flash-002": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "cache_read_input_token_cost": 1.875e-08,
        "cache_creation_input_token_cost": 1e-06,
        "input_cost_per_token": 7.5e-08,
        "input_cost_per_token_above_128k_tokens": 1.5e-07,
        "output_cost_per_token": 3e-07,
        "output_cost_per_token_above_128k_tokens": 6e-07,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_prompt_caching": True,
        "tpm": 4000000,
        "rpm": 2000,
        "source": "https://ai.google.dev/pricing",
        "deprecation_date": "2025-09-24",
        "supports_tool_choice": True,
    },
    "gemini/gemini-1.5-flash-001": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "cache_read_input_token_cost": 1.875e-08,
        "cache_creation_input_token_cost": 1e-06,
        "input_cost_per_token": 7.5e-08,
        "input_cost_per_token_above_128k_tokens": 1.5e-07,
        "output_cost_per_token": 3e-07,
        "output_cost_per_token_above_128k_tokens": 6e-07,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_prompt_caching": True,
        "tpm": 4000000,
        "rpm": 2000,
        "source": "https://ai.google.dev/pricing",
        "deprecation_date": "2025-05-24",
        "supports_tool_choice": True,
    },
    "gemini/gemini-1.5-flash": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_token": 7.5e-08,
        "input_cost_per_token_above_128k_tokens": 1.5e-07,
        "output_cost_per_token": 3e-07,
        "output_cost_per_token_above_128k_tokens": 6e-07,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "tpm": 4000000,
        "rpm": 2000,
        "source": "https://ai.google.dev/pricing",
        "supports_tool_choice": True,
    },
    "gemini/gemini-1.5-flash-latest": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_token": 7.5e-08,
        "input_cost_per_token_above_128k_tokens": 1.5e-07,
        "output_cost_per_token": 3e-07,
        "output_cost_per_token_above_128k_tokens": 6e-07,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_prompt_caching": True,
        "tpm": 4000000,
        "rpm": 2000,
        "source": "https://ai.google.dev/pricing",
        "supports_tool_choice": True,
    },
    "gemini/gemini-1.5-flash-8b": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_token": 0,
        "input_cost_per_token_above_128k_tokens": 0,
        "output_cost_per_token": 0,
        "output_cost_per_token_above_128k_tokens": 0,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_prompt_caching": True,
        "tpm": 4000000,
        "rpm": 4000,
        "source": "https://ai.google.dev/pricing",
        "supports_tool_choice": True,
    },
    "gemini/gemini-1.5-flash-8b-exp-0924": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_token": 0,
        "input_cost_per_token_above_128k_tokens": 0,
        "output_cost_per_token": 0,
        "output_cost_per_token_above_128k_tokens": 0,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_prompt_caching": True,
        "tpm": 4000000,
        "rpm": 4000,
        "source": "https://ai.google.dev/pricing",
        "supports_tool_choice": True,
    },
    "gemini/gemini-exp-1114": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_token": 0,
        "input_cost_per_token_above_128k_tokens": 0,
        "output_cost_per_token": 0,
        "output_cost_per_token_above_128k_tokens": 0,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_tool_choice": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "tpm": 4000000,
        "rpm": 1000,
        "source": "https://ai.google.dev/pricing",
        "metadata": {
            "notes": "Rate limits not documented for gemini-exp-1114. Assuming same as gemini-1.5-pro.",
            "supports_tool_choice": True,
        },
    },
    "gemini/gemini-exp-1206": {
        "max_tokens": 8192,
        "max_input_tokens": 2097152,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_token": 0,
        "input_cost_per_token_above_128k_tokens": 0,
        "output_cost_per_token": 0,
        "output_cost_per_token_above_128k_tokens": 0,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "tpm": 4000000,
        "rpm": 1000,
        "source": "https://ai.google.dev/pricing",
        "metadata": {
            "notes": "Rate limits not documented for gemini-exp-1206. Assuming same as gemini-1.5-pro.",
            "supports_tool_choice": True,
        },
    },
    "gemini/gemini-1.5-flash-exp-0827": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_token": 0,
        "input_cost_per_token_above_128k_tokens": 0,
        "output_cost_per_token": 0,
        "output_cost_per_token_above_128k_tokens": 0,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "tpm": 4000000,
        "rpm": 2000,
        "source": "https://ai.google.dev/pricing",
        "supports_tool_choice": True,
    },
    "gemini/gemini-1.5-flash-8b-exp-0827": {
        "max_tokens": 8192,
        "max_input_tokens": 1000000,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_token": 0,
        "input_cost_per_token_above_128k_tokens": 0,
        "output_cost_per_token": 0,
        "output_cost_per_token_above_128k_tokens": 0,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "tpm": 4000000,
        "rpm": 4000,
        "source": "https://ai.google.dev/pricing",
        "supports_tool_choice": True,
    },
    "gemini/gemini-pro": {
        "max_tokens": 8192,
        "max_input_tokens": 32760,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3.5e-07,
        "input_cost_per_token_above_128k_tokens": 7e-07,
        "output_cost_per_token": 1.05e-06,
        "output_cost_per_token_above_128k_tokens": 2.1e-06,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_function_calling": True,
        "rpd": 30000,
        "tpm": 120000,
        "rpm": 360,
        "source": "https://ai.google.dev/gemini-api/docs/models/gemini",
        "supports_tool_choice": True,
    },
    "gemini/gemini-1.5-pro": {
        "max_tokens": 8192,
        "max_input_tokens": 2097152,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3.5e-06,
        "input_cost_per_token_above_128k_tokens": 7e-06,
        "output_cost_per_token": 1.05e-05,
        "output_cost_per_token_above_128k_tokens": 2.1e-05,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_tool_choice": True,
        "supports_response_schema": True,
        "tpm": 4000000,
        "rpm": 1000,
        "source": "https://ai.google.dev/pricing",
    },
    "gemini/gemini-1.5-pro-002": {
        "max_tokens": 8192,
        "max_input_tokens": 2097152,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3.5e-06,
        "input_cost_per_token_above_128k_tokens": 7e-06,
        "output_cost_per_token": 1.05e-05,
        "output_cost_per_token_above_128k_tokens": 2.1e-05,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_tool_choice": True,
        "supports_response_schema": True,
        "supports_prompt_caching": True,
        "tpm": 4000000,
        "rpm": 1000,
        "source": "https://ai.google.dev/pricing",
        "deprecation_date": "2025-09-24",
    },
    "gemini/gemini-1.5-pro-001": {
        "max_tokens": 8192,
        "max_input_tokens": 2097152,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3.5e-06,
        "input_cost_per_token_above_128k_tokens": 7e-06,
        "output_cost_per_token": 1.05e-05,
        "output_cost_per_token_above_128k_tokens": 2.1e-05,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_tool_choice": True,
        "supports_response_schema": True,
        "supports_prompt_caching": True,
        "tpm": 4000000,
        "rpm": 1000,
        "source": "https://ai.google.dev/pricing",
        "deprecation_date": "2025-05-24",
    },
    "gemini/gemini-1.5-pro-exp-0801": {
        "max_tokens": 8192,
        "max_input_tokens": 2097152,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3.5e-06,
        "input_cost_per_token_above_128k_tokens": 7e-06,
        "output_cost_per_token": 1.05e-05,
        "output_cost_per_token_above_128k_tokens": 2.1e-05,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_tool_choice": True,
        "supports_response_schema": True,
        "tpm": 4000000,
        "rpm": 1000,
        "source": "https://ai.google.dev/pricing",
    },
    "gemini/gemini-1.5-pro-exp-0827": {
        "max_tokens": 8192,
        "max_input_tokens": 2097152,
        "max_output_tokens": 8192,
        "input_cost_per_token": 0,
        "input_cost_per_token_above_128k_tokens": 0,
        "output_cost_per_token": 0,
        "output_cost_per_token_above_128k_tokens": 0,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_tool_choice": True,
        "supports_response_schema": True,
        "tpm": 4000000,
        "rpm": 1000,
        "source": "https://ai.google.dev/pricing",
    },
    "gemini/gemini-1.5-pro-latest": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3.5e-06,
        "input_cost_per_token_above_128k_tokens": 7e-06,
        "output_cost_per_token": 1.05e-06,
        "output_cost_per_token_above_128k_tokens": 2.1e-05,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_tool_choice": True,
        "supports_response_schema": True,
        "tpm": 4000000,
        "rpm": 1000,
        "source": "https://ai.google.dev/pricing",
    },
    "gemini/gemini-pro-vision": {
        "max_tokens": 2048,
        "max_input_tokens": 30720,
        "max_output_tokens": 2048,
        "input_cost_per_token": 3.5e-07,
        "input_cost_per_token_above_128k_tokens": 7e-07,
        "output_cost_per_token": 1.05e-06,
        "output_cost_per_token_above_128k_tokens": 2.1e-06,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "rpd": 30000,
        "tpm": 120000,
        "rpm": 360,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
    },
    "gemini/gemini-gemma-2-27b-it": {
        "max_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3.5e-07,
        "output_cost_per_token": 1.05e-06,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
    },
    "gemini/gemini-gemma-2-9b-it": {
        "max_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3.5e-07,
        "output_cost_per_token": 1.05e-06,
        "litellm_provider": "gemini",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "source": "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#foundation_models",
        "supports_tool_choice": True,
    },
    "command-a-03-2025": {
        "max_tokens": 8000,
        "max_input_tokens": 256000,
        "max_output_tokens": 8000,
        "input_cost_per_token": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "litellm_provider": "cohere_chat",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "command-r": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "cohere_chat",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "command-r-08-2024": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "cohere_chat",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "command-r7b-12-2024": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 3.75e-08,
        "litellm_provider": "cohere_chat",
        "mode": "chat",
        "supports_function_calling": True,
        "source": "https://docs.cohere.com/v2/docs/command-r7b",
        "supports_tool_choice": True,
    },
    "command-light": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "cohere_chat",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "command-r-plus": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "litellm_provider": "cohere_chat",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "command-r-plus-08-2024": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "litellm_provider": "cohere_chat",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "command-nightly": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 2e-06,
        "litellm_provider": "cohere",
        "mode": "completion",
    },
    "command": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 2e-06,
        "litellm_provider": "cohere",
        "mode": "completion",
    },
    "rerank-v3.5": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "max_query_tokens": 2048,
        "input_cost_per_token": 0.0,
        "input_cost_per_query": 0.002,
        "output_cost_per_token": 0.0,
        "litellm_provider": "cohere",
        "mode": "rerank",
    },
    "rerank-english-v3.0": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "max_query_tokens": 2048,
        "input_cost_per_token": 0.0,
        "input_cost_per_query": 0.002,
        "output_cost_per_token": 0.0,
        "litellm_provider": "cohere",
        "mode": "rerank",
    },
    "rerank-multilingual-v3.0": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "max_query_tokens": 2048,
        "input_cost_per_token": 0.0,
        "input_cost_per_query": 0.002,
        "output_cost_per_token": 0.0,
        "litellm_provider": "cohere",
        "mode": "rerank",
    },
    "rerank-english-v2.0": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "max_query_tokens": 2048,
        "input_cost_per_token": 0.0,
        "input_cost_per_query": 0.002,
        "output_cost_per_token": 0.0,
        "litellm_provider": "cohere",
        "mode": "rerank",
    },
    "rerank-multilingual-v2.0": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "max_query_tokens": 2048,
        "input_cost_per_token": 0.0,
        "input_cost_per_query": 0.002,
        "output_cost_per_token": 0.0,
        "litellm_provider": "cohere",
        "mode": "rerank",
    },
    "embed-english-light-v3.0": {
        "max_tokens": 1024,
        "max_input_tokens": 1024,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "cohere",
        "mode": "embedding",
    },
    "embed-multilingual-v3.0": {
        "max_tokens": 1024,
        "max_input_tokens": 1024,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "cohere",
        "supports_embedding_image_input": True,
        "mode": "embedding",
    },
    "embed-english-v2.0": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "cohere",
        "mode": "embedding",
    },
    "embed-english-light-v2.0": {
        "max_tokens": 1024,
        "max_input_tokens": 1024,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "cohere",
        "mode": "embedding",
    },
    "embed-multilingual-v2.0": {
        "max_tokens": 768,
        "max_input_tokens": 768,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "cohere",
        "mode": "embedding",
    },
    "embed-english-v3.0": {
        "max_tokens": 1024,
        "max_input_tokens": 1024,
        "input_cost_per_token": 1e-07,
        "input_cost_per_image": 0.0001,
        "output_cost_per_token": 0.0,
        "litellm_provider": "cohere",
        "mode": "embedding",
        "supports_image_input": True,
        "supports_embedding_image_input": True,
        "metadata": {
            "notes": "'supports_image_input' is a deprecated field. Use 'supports_embedding_image_input' instead."
        },
    },
    "replicate/meta/llama-2-13b": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 5e-07,
        "litellm_provider": "replicate",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "replicate/meta/llama-2-13b-chat": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 5e-07,
        "litellm_provider": "replicate",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "replicate/meta/llama-2-70b": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 6.5e-07,
        "output_cost_per_token": 2.75e-06,
        "litellm_provider": "replicate",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "replicate/meta/llama-2-70b-chat": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 6.5e-07,
        "output_cost_per_token": 2.75e-06,
        "litellm_provider": "replicate",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "replicate/meta/llama-2-7b": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5e-08,
        "output_cost_per_token": 2.5e-07,
        "litellm_provider": "replicate",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "replicate/meta/llama-2-7b-chat": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5e-08,
        "output_cost_per_token": 2.5e-07,
        "litellm_provider": "replicate",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "replicate/meta/llama-3-70b": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 6.5e-07,
        "output_cost_per_token": 2.75e-06,
        "litellm_provider": "replicate",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "replicate/meta/llama-3-70b-instruct": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 6.5e-07,
        "output_cost_per_token": 2.75e-06,
        "litellm_provider": "replicate",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "replicate/meta/llama-3-8b": {
        "max_tokens": 8086,
        "max_input_tokens": 8086,
        "max_output_tokens": 8086,
        "input_cost_per_token": 5e-08,
        "output_cost_per_token": 2.5e-07,
        "litellm_provider": "replicate",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "replicate/meta/llama-3-8b-instruct": {
        "max_tokens": 8086,
        "max_input_tokens": 8086,
        "max_output_tokens": 8086,
        "input_cost_per_token": 5e-08,
        "output_cost_per_token": 2.5e-07,
        "litellm_provider": "replicate",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "replicate/mistralai/mistral-7b-v0.1": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5e-08,
        "output_cost_per_token": 2.5e-07,
        "litellm_provider": "replicate",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "replicate/mistralai/mistral-7b-instruct-v0.2": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5e-08,
        "output_cost_per_token": 2.5e-07,
        "litellm_provider": "replicate",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "replicate/mistralai/mixtral-8x7b-instruct-v0.1": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-07,
        "output_cost_per_token": 1e-06,
        "litellm_provider": "replicate",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/deepseek/deepseek-r1": {
        "max_tokens": 8192,
        "max_input_tokens": 65336,
        "max_output_tokens": 8192,
        "input_cost_per_token": 5.5e-07,
        "input_cost_per_token_cache_hit": 1.4e-07,
        "output_cost_per_token": 2.19e-06,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_assistant_prefill": True,
        "supports_reasoning": True,
        "supports_tool_choice": True,
        "supports_prompt_caching": True,
    },
    "openrouter/deepseek/deepseek-chat": {
        "max_tokens": 8192,
        "max_input_tokens": 65536,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1.4e-07,
        "output_cost_per_token": 2.8e-07,
        "litellm_provider": "openrouter",
        "supports_prompt_caching": True,
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/deepseek/deepseek-coder": {
        "max_tokens": 8192,
        "max_input_tokens": 66000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.4e-07,
        "output_cost_per_token": 2.8e-07,
        "litellm_provider": "openrouter",
        "supports_prompt_caching": True,
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/microsoft/wizardlm-2-8x22b:nitro": {
        "max_tokens": 65536,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 1e-06,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/google/gemini-pro-1.5": {
        "max_tokens": 8192,
        "max_input_tokens": 1000000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 2.5e-06,
        "output_cost_per_token": 7.5e-06,
        "input_cost_per_image": 0.00265,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_tool_choice": True,
    },
    "openrouter/google/gemini-2.0-flash-001": {
        "max_tokens": 8192,
        "max_input_tokens": 1048576,
        "max_output_tokens": 8192,
        "max_images_per_prompt": 3000,
        "max_videos_per_prompt": 10,
        "max_video_length": 1,
        "max_audio_length_hours": 8.4,
        "max_audio_per_prompt": 1,
        "max_pdf_size_mb": 30,
        "input_cost_per_audio_token": 7e-07,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 4e-07,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_system_messages": True,
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_response_schema": True,
        "supports_audio_output": True,
        "supports_tool_choice": True,
    },
    "openrouter/mistralai/mixtral-8x22b-instruct": {
        "max_tokens": 65536,
        "input_cost_per_token": 6.5e-07,
        "output_cost_per_token": 6.5e-07,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/cohere/command-r-plus": {
        "max_tokens": 128000,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/databricks/dbrx-instruct": {
        "max_tokens": 32768,
        "input_cost_per_token": 6e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/anthropic/claude-3-haiku": {
        "max_tokens": 200000,
        "input_cost_per_token": 2.5e-07,
        "output_cost_per_token": 1.25e-06,
        "input_cost_per_image": 0.0004,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_tool_choice": True,
    },
    "openrouter/anthropic/claude-3-5-haiku": {
        "max_tokens": 200000,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 5e-06,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "openrouter/anthropic/claude-3-haiku-20240307": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2.5e-07,
        "output_cost_per_token": 1.25e-06,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 264,
        "supports_tool_choice": True,
    },
    "openrouter/anthropic/claude-3-5-haiku-20241022": {
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 5e-06,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "tool_use_system_prompt_tokens": 264,
        "supports_tool_choice": True,
    },
    "openrouter/anthropic/claude-3.5-sonnet": {
        "supports_computer_use": True,
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "openrouter/anthropic/claude-3.5-sonnet:beta": {
        "supports_computer_use": True,
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_tool_choice": True,
    },
    "openrouter/anthropic/claude-3.7-sonnet": {
        "supports_computer_use": True,
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "input_cost_per_image": 0.0048,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_reasoning": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_tool_choice": True,
    },
    "openrouter/anthropic/claude-3.7-sonnet:beta": {
        "supports_computer_use": True,
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "input_cost_per_image": 0.0048,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_reasoning": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_tool_choice": True,
    },
    "openrouter/anthropic/claude-3-sonnet": {
        "max_tokens": 200000,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "input_cost_per_image": 0.0048,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_tool_choice": True,
    },
    "openrouter/mistralai/mistral-large": {
        "max_tokens": 32000,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "mistralai/mistral-small-3.1-24b-instruct": {
        "max_tokens": 32000,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 3e-07,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/cognitivecomputations/dolphin-mixtral-8x7b": {
        "max_tokens": 32769,
        "input_cost_per_token": 5e-07,
        "output_cost_per_token": 5e-07,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/google/gemini-pro-vision": {
        "max_tokens": 45875,
        "input_cost_per_token": 1.25e-07,
        "output_cost_per_token": 3.75e-07,
        "input_cost_per_image": 0.0025,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_tool_choice": True,
    },
    "openrouter/fireworks/firellava-13b": {
        "max_tokens": 4096,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 2e-07,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/meta-llama/llama-3-8b-instruct:free": {
        "max_tokens": 8192,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/meta-llama/llama-3-8b-instruct:extended": {
        "max_tokens": 16384,
        "input_cost_per_token": 2.25e-07,
        "output_cost_per_token": 2.25e-06,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/meta-llama/llama-3-70b-instruct:nitro": {
        "max_tokens": 8192,
        "input_cost_per_token": 9e-07,
        "output_cost_per_token": 9e-07,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/meta-llama/llama-3-70b-instruct": {
        "max_tokens": 8192,
        "input_cost_per_token": 5.9e-07,
        "output_cost_per_token": 7.9e-07,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/openai/o1": {
        "max_tokens": 100000,
        "max_input_tokens": 200000,
        "max_output_tokens": 100000,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 6e-05,
        "cache_read_input_token_cost": 7.5e-06,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": True,
        "supports_prompt_caching": True,
        "supports_system_messages": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
    },
    "openrouter/openai/o1-mini": {
        "max_tokens": 65536,
        "max_input_tokens": 128000,
        "max_output_tokens": 65536,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.2e-05,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": False,
        "supports_tool_choice": True,
    },
    "openrouter/openai/o1-mini-2024-09-12": {
        "max_tokens": 65536,
        "max_input_tokens": 128000,
        "max_output_tokens": 65536,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.2e-05,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": False,
        "supports_tool_choice": True,
    },
    "openrouter/openai/o1-preview": {
        "max_tokens": 32768,
        "max_input_tokens": 128000,
        "max_output_tokens": 32768,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 6e-05,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": False,
        "supports_tool_choice": True,
    },
    "openrouter/openai/o1-preview-2024-09-12": {
        "max_tokens": 32768,
        "max_input_tokens": 128000,
        "max_output_tokens": 32768,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 6e-05,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": False,
        "supports_tool_choice": True,
    },
    "openrouter/openai/o3-mini": {
        "max_tokens": 65536,
        "max_input_tokens": 128000,
        "max_output_tokens": 65536,
        "input_cost_per_token": 1.1e-06,
        "output_cost_per_token": 4.4e-06,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_reasoning": True,
        "supports_parallel_function_calling": True,
        "supports_vision": False,
        "supports_tool_choice": True,
    },
    "openrouter/openai/o3-mini-high": {
        "max_tokens": 65536,
        "max_input_tokens": 128000,
        "max_output_tokens": 65536,
        "input_cost_per_token": 1.1e-06,
        "output_cost_per_token": 4.4e-06,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_reasoning": True,
        "supports_parallel_function_calling": True,
        "supports_vision": False,
        "supports_tool_choice": True,
    },
    "openrouter/openai/gpt-4o": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2.5e-06,
        "output_cost_per_token": 1e-05,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": True,
        "supports_tool_choice": True,
    },
    "openrouter/openai/gpt-4o-2024-05-13": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_vision": True,
        "supports_tool_choice": True,
    },
    "openrouter/openai/gpt-4-vision-preview": {
        "max_tokens": 130000,
        "input_cost_per_token": 1e-05,
        "output_cost_per_token": 3e-05,
        "input_cost_per_image": 0.01445,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_tool_choice": True,
    },
    "openrouter/openai/gpt-3.5-turbo": {
        "max_tokens": 4095,
        "input_cost_per_token": 1.5e-06,
        "output_cost_per_token": 2e-06,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/openai/gpt-3.5-turbo-16k": {
        "max_tokens": 16383,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 4e-06,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/openai/gpt-4": {
        "max_tokens": 8192,
        "input_cost_per_token": 3e-05,
        "output_cost_per_token": 6e-05,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/anthropic/claude-instant-v1": {
        "max_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 1.63e-06,
        "output_cost_per_token": 5.51e-06,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/anthropic/claude-2": {
        "max_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 1.102e-05,
        "output_cost_per_token": 3.268e-05,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/anthropic/claude-3-opus": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 7.5e-05,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 395,
        "supports_tool_choice": True,
    },
    "openrouter/google/palm-2-chat-bison": {
        "max_tokens": 25804,
        "input_cost_per_token": 5e-07,
        "output_cost_per_token": 5e-07,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/google/palm-2-codechat-bison": {
        "max_tokens": 20070,
        "input_cost_per_token": 5e-07,
        "output_cost_per_token": 5e-07,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/meta-llama/llama-2-13b-chat": {
        "max_tokens": 4096,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 2e-07,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/meta-llama/llama-2-70b-chat": {
        "max_tokens": 4096,
        "input_cost_per_token": 1.5e-06,
        "output_cost_per_token": 1.5e-06,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/meta-llama/codellama-34b-instruct": {
        "max_tokens": 8192,
        "input_cost_per_token": 5e-07,
        "output_cost_per_token": 5e-07,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/nousresearch/nous-hermes-llama2-13b": {
        "max_tokens": 4096,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 2e-07,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/mancer/weaver": {
        "max_tokens": 8000,
        "input_cost_per_token": 5.625e-06,
        "output_cost_per_token": 5.625e-06,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/gryphe/mythomax-l2-13b": {
        "max_tokens": 8192,
        "input_cost_per_token": 1.875e-06,
        "output_cost_per_token": 1.875e-06,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/jondurbin/airoboros-l2-70b-2.1": {
        "max_tokens": 4096,
        "input_cost_per_token": 1.3875e-05,
        "output_cost_per_token": 1.3875e-05,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/undi95/remm-slerp-l2-13b": {
        "max_tokens": 6144,
        "input_cost_per_token": 1.875e-06,
        "output_cost_per_token": 1.875e-06,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/pygmalionai/mythalion-13b": {
        "max_tokens": 4096,
        "input_cost_per_token": 1.875e-06,
        "output_cost_per_token": 1.875e-06,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/mistralai/mistral-7b-instruct": {
        "max_tokens": 8192,
        "input_cost_per_token": 1.3e-07,
        "output_cost_per_token": 1.3e-07,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/mistralai/mistral-7b-instruct:free": {
        "max_tokens": 8192,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "openrouter/qwen/qwen-2.5-coder-32b-instruct": {
        "max_tokens": 33792,
        "max_input_tokens": 33792,
        "max_output_tokens": 33792,
        "input_cost_per_token": 1.8e-07,
        "output_cost_per_token": 1.8e-07,
        "litellm_provider": "openrouter",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "j2-ultra": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "ai21",
        "mode": "completion",
    },
    "jamba-1.5-mini@001": {
        "max_tokens": 256000,
        "max_input_tokens": 256000,
        "max_output_tokens": 256000,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 4e-07,
        "litellm_provider": "ai21",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "jamba-1.5-large@001": {
        "max_tokens": 256000,
        "max_input_tokens": 256000,
        "max_output_tokens": 256000,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 8e-06,
        "litellm_provider": "ai21",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "jamba-1.5": {
        "max_tokens": 256000,
        "max_input_tokens": 256000,
        "max_output_tokens": 256000,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 4e-07,
        "litellm_provider": "ai21",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "jamba-1.5-mini": {
        "max_tokens": 256000,
        "max_input_tokens": 256000,
        "max_output_tokens": 256000,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 4e-07,
        "litellm_provider": "ai21",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "jamba-1.5-large": {
        "max_tokens": 256000,
        "max_input_tokens": 256000,
        "max_output_tokens": 256000,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 8e-06,
        "litellm_provider": "ai21",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "jamba-large-1.6": {
        "max_tokens": 256000,
        "max_input_tokens": 256000,
        "max_output_tokens": 256000,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 8e-06,
        "litellm_provider": "ai21",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "jamba-mini-1.6": {
        "max_tokens": 256000,
        "max_input_tokens": 256000,
        "max_output_tokens": 256000,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 4e-07,
        "litellm_provider": "ai21",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "j2-mid": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1e-05,
        "output_cost_per_token": 1e-05,
        "litellm_provider": "ai21",
        "mode": "completion",
    },
    "j2-light": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 3e-06,
        "litellm_provider": "ai21",
        "mode": "completion",
    },
    "dolphin": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 16384,
        "input_cost_per_token": 5e-07,
        "output_cost_per_token": 5e-07,
        "litellm_provider": "nlp_cloud",
        "mode": "completion",
    },
    "chatdolphin": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 16384,
        "input_cost_per_token": 5e-07,
        "output_cost_per_token": 5e-07,
        "litellm_provider": "nlp_cloud",
        "mode": "chat",
    },
    "luminous-base": {
        "max_tokens": 2048,
        "input_cost_per_token": 3e-05,
        "output_cost_per_token": 3.3e-05,
        "litellm_provider": "aleph_alpha",
        "mode": "completion",
    },
    "luminous-base-control": {
        "max_tokens": 2048,
        "input_cost_per_token": 3.75e-05,
        "output_cost_per_token": 4.125e-05,
        "litellm_provider": "aleph_alpha",
        "mode": "chat",
    },
    "luminous-extended": {
        "max_tokens": 2048,
        "input_cost_per_token": 4.5e-05,
        "output_cost_per_token": 4.95e-05,
        "litellm_provider": "aleph_alpha",
        "mode": "completion",
    },
    "luminous-extended-control": {
        "max_tokens": 2048,
        "input_cost_per_token": 5.625e-05,
        "output_cost_per_token": 6.1875e-05,
        "litellm_provider": "aleph_alpha",
        "mode": "chat",
    },
    "luminous-supreme": {
        "max_tokens": 2048,
        "input_cost_per_token": 0.000175,
        "output_cost_per_token": 0.0001925,
        "litellm_provider": "aleph_alpha",
        "mode": "completion",
    },
    "luminous-supreme-control": {
        "max_tokens": 2048,
        "input_cost_per_token": 0.00021875,
        "output_cost_per_token": 0.000240625,
        "litellm_provider": "aleph_alpha",
        "mode": "chat",
    },
    "ai21.j2-mid-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 8191,
        "max_output_tokens": 8191,
        "input_cost_per_token": 1.25e-05,
        "output_cost_per_token": 1.25e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "ai21.j2-ultra-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 8191,
        "max_output_tokens": 8191,
        "input_cost_per_token": 1.88e-05,
        "output_cost_per_token": 1.88e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "ai21.jamba-instruct-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 70000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5e-07,
        "output_cost_per_token": 7e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_system_messages": True,
    },
    "ai21.jamba-1-5-large-v1:0": {
        "max_tokens": 256000,
        "max_input_tokens": 256000,
        "max_output_tokens": 256000,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 8e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "ai21.jamba-1-5-mini-v1:0": {
        "max_tokens": 256000,
        "max_input_tokens": 256000,
        "max_output_tokens": 256000,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 4e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "amazon.rerank-v1:0": {
        "max_tokens": 32000,
        "max_input_tokens": 32000,
        "max_output_tokens": 32000,
        "max_query_tokens": 32000,
        "max_document_chunks_per_query": 100,
        "max_tokens_per_document_chunk": 512,
        "input_cost_per_token": 0.0,
        "input_cost_per_query": 0.001,
        "output_cost_per_token": 0.0,
        "litellm_provider": "bedrock",
        "mode": "rerank",
    },
    "amazon.titan-text-lite-v1": {
        "max_tokens": 4000,
        "max_input_tokens": 42000,
        "max_output_tokens": 4000,
        "input_cost_per_token": 3e-07,
        "output_cost_per_token": 4e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "amazon.titan-text-express-v1": {
        "max_tokens": 8000,
        "max_input_tokens": 42000,
        "max_output_tokens": 8000,
        "input_cost_per_token": 1.3e-06,
        "output_cost_per_token": 1.7e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "amazon.titan-text-premier-v1:0": {
        "max_tokens": 32000,
        "max_input_tokens": 42000,
        "max_output_tokens": 32000,
        "input_cost_per_token": 5e-07,
        "output_cost_per_token": 1.5e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "amazon.titan-embed-text-v1": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "output_vector_size": 1536,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "bedrock",
        "mode": "embedding",
    },
    "amazon.titan-embed-text-v2:0": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "output_vector_size": 1024,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "bedrock",
        "mode": "embedding",
    },
    "amazon.titan-embed-image-v1": {
        "max_tokens": 128,
        "max_input_tokens": 128,
        "output_vector_size": 1024,
        "input_cost_per_token": 8e-07,
        "input_cost_per_image": 6e-05,
        "output_cost_per_token": 0.0,
        "litellm_provider": "bedrock",
        "supports_image_input": True,
        "supports_embedding_image_input": True,
        "mode": "embedding",
        "source": "https://us-east-1.console.aws.amazon.com/bedrock/home?region=us-east-1#/providers?model=amazon.titan-image-generator-v1",
        "metadata": {
            "notes": "'supports_image_input' is a deprecated field. Use 'supports_embedding_image_input' instead."
        },
    },
    "mistral.mistral-7b-instruct-v0:2": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 2e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "mistral.mixtral-8x7b-instruct-v0:1": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 4.5e-07,
        "output_cost_per_token": 7e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "mistral.mistral-large-2402-v1:0": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "mistral.mistral-large-2407-v1:0": {
        "max_tokens": 8191,
        "max_input_tokens": 128000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 9e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "mistral.mistral-small-2402-v1:0": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 3e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "bedrock/us-west-2/mistral.mixtral-8x7b-instruct-v0:1": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 4.5e-07,
        "output_cost_per_token": 7e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-east-1/mistral.mixtral-8x7b-instruct-v0:1": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 4.5e-07,
        "output_cost_per_token": 7e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/eu-west-3/mistral.mixtral-8x7b-instruct-v0:1": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 5.9e-07,
        "output_cost_per_token": 9.1e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-west-2/mistral.mistral-7b-instruct-v0:2": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 2e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-east-1/mistral.mistral-7b-instruct-v0:2": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 2e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/eu-west-3/mistral.mistral-7b-instruct-v0:2": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 2.6e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-east-1/mistral.mistral-large-2402-v1:0": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "bedrock/us-west-2/mistral.mistral-large-2402-v1:0": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "bedrock/eu-west-3/mistral.mistral-large-2402-v1:0": {
        "max_tokens": 8191,
        "max_input_tokens": 32000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 1.04e-05,
        "output_cost_per_token": 3.12e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
    },
    "amazon.nova-micro-v1:0": {
        "max_tokens": 10000,
        "max_input_tokens": 300000,
        "max_output_tokens": 10000,
        "input_cost_per_token": 3.5e-08,
        "output_cost_per_token": 1.4e-07,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
    },
    "us.amazon.nova-micro-v1:0": {
        "max_tokens": 10000,
        "max_input_tokens": 300000,
        "max_output_tokens": 10000,
        "input_cost_per_token": 3.5e-08,
        "output_cost_per_token": 1.4e-07,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
    },
    "eu.amazon.nova-micro-v1:0": {
        "max_tokens": 10000,
        "max_input_tokens": 300000,
        "max_output_tokens": 10000,
        "input_cost_per_token": 4.6e-08,
        "output_cost_per_token": 1.84e-07,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
    },
    "amazon.nova-lite-v1:0": {
        "max_tokens": 10000,
        "max_input_tokens": 128000,
        "max_output_tokens": 10000,
        "input_cost_per_token": 6e-08,
        "output_cost_per_token": 2.4e-07,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
    },
    "us.amazon.nova-lite-v1:0": {
        "max_tokens": 10000,
        "max_input_tokens": 128000,
        "max_output_tokens": 10000,
        "input_cost_per_token": 6e-08,
        "output_cost_per_token": 2.4e-07,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
    },
    "eu.amazon.nova-lite-v1:0": {
        "max_tokens": 10000,
        "max_input_tokens": 128000,
        "max_output_tokens": 10000,
        "input_cost_per_token": 7.8e-08,
        "output_cost_per_token": 3.12e-07,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
    },
    "amazon.nova-pro-v1:0": {
        "max_tokens": 10000,
        "max_input_tokens": 300000,
        "max_output_tokens": 10000,
        "input_cost_per_token": 8e-07,
        "output_cost_per_token": 3.2e-06,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
    },
    "us.amazon.nova-pro-v1:0": {
        "max_tokens": 10000,
        "max_input_tokens": 300000,
        "max_output_tokens": 10000,
        "input_cost_per_token": 8e-07,
        "output_cost_per_token": 3.2e-06,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
    },
    "1024-x-1024/50-steps/bedrock/amazon.nova-canvas-v1:0": {
        "max_input_tokens": 2600,
        "output_cost_per_image": 0.06,
        "litellm_provider": "bedrock",
        "mode": "image_generation",
    },
    "eu.amazon.nova-pro-v1:0": {
        "max_tokens": 10000,
        "max_input_tokens": 300000,
        "max_output_tokens": 10000,
        "input_cost_per_token": 1.05e-06,
        "output_cost_per_token": 4.2e-06,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "source": "https://aws.amazon.com/bedrock/pricing/",
    },
    "us.amazon.nova-premier-v1:0": {
        "max_tokens": 10000,
        "max_input_tokens": 1000000,
        "max_output_tokens": 10000,
        "input_cost_per_token": 2.5e-06,
        "output_cost_per_token": 1.25e-05,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": False,
        "supports_response_schema": True,
    },
    "anthropic.claude-3-sonnet-20240229-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_tool_choice": True,
    },
    "bedrock/invoke/anthropic.claude-3-5-sonnet-20240620-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_tool_choice": True,
        "metadata": {
            "notes": "Anthropic via Invoke route does not currently support pdf input."
        },
    },
    "anthropic.claude-3-5-sonnet-20240620-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_tool_choice": True,
    },
    "anthropic.claude-opus-4-20250514-v1:0": {
        "max_tokens": 32000,
        "max_input_tokens": 200000,
        "max_output_tokens": 32000,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 7.5e-05,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.01,
            "search_context_size_medium": 0.01,
            "search_context_size_high": 0.01,
        },
        "cache_creation_input_token_cost": 1.875e-05,
        "cache_read_input_token_cost": 1.5e-06,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supports_computer_use": True,
    },
    "anthropic.claude-sonnet-4-20250514-v1:0": {
        "max_tokens": 64000,
        "max_input_tokens": 200000,
        "max_output_tokens": 64000,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.01,
            "search_context_size_medium": 0.01,
            "search_context_size_high": 0.01,
        },
        "cache_creation_input_token_cost": 3.75e-06,
        "cache_read_input_token_cost": 3e-07,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supports_computer_use": True,
    },
    "anthropic.claude-3-7-sonnet-20250219-v1:0": {
        "supports_computer_use": True,
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "cache_creation_input_token_cost": 3.75e-06,
        "cache_read_input_token_cost": 3e-07,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_assistant_prefill": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_pdf_input": True,
        "supports_reasoning": True,
        "supports_tool_choice": True,
    },
    "anthropic.claude-3-5-sonnet-20241022-v2:0": {
        "supports_computer_use": True,
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "cache_creation_input_token_cost": 3.75e-06,
        "cache_read_input_token_cost": 3e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_assistant_prefill": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
    },
    "anthropic.claude-3-haiku-20240307-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2.5e-07,
        "output_cost_per_token": 1.25e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_tool_choice": True,
    },
    "anthropic.claude-3-5-haiku-20241022-v1:0": {
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 8e-07,
        "output_cost_per_token": 4e-06,
        "cache_creation_input_token_cost": 1e-06,
        "cache_read_input_token_cost": 8e-08,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_prompt_caching": True,
        "supports_tool_choice": True,
    },
    "anthropic.claude-3-opus-20240229-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 7.5e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_tool_choice": True,
    },
    "us.anthropic.claude-3-sonnet-20240229-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_tool_choice": True,
    },
    "us.anthropic.claude-3-5-sonnet-20240620-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_tool_choice": True,
    },
    "us.anthropic.claude-3-5-sonnet-20241022-v2:0": {
        "supports_computer_use": True,
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "cache_creation_input_token_cost": 3.75e-06,
        "cache_read_input_token_cost": 3e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_assistant_prefill": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
    },
    "us.anthropic.claude-3-7-sonnet-20250219-v1:0": {
        "supports_computer_use": True,
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "cache_creation_input_token_cost": 3.75e-06,
        "cache_read_input_token_cost": 3e-07,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_assistant_prefill": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_pdf_input": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
    },
    "us.anthropic.claude-opus-4-20250514-v1:0": {
        "max_tokens": 32000,
        "max_input_tokens": 200000,
        "max_output_tokens": 32000,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 7.5e-05,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.01,
            "search_context_size_medium": 0.01,
            "search_context_size_high": 0.01,
        },
        "cache_creation_input_token_cost": 1.875e-05,
        "cache_read_input_token_cost": 1.5e-06,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supports_computer_use": True,
    },
    "us.anthropic.claude-sonnet-4-20250514-v1:0": {
        "max_tokens": 64000,
        "max_input_tokens": 200000,
        "max_output_tokens": 64000,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.01,
            "search_context_size_medium": 0.01,
            "search_context_size_high": 0.01,
        },
        "cache_creation_input_token_cost": 3.75e-06,
        "cache_read_input_token_cost": 3e-07,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supports_computer_use": True,
    },
    "us.anthropic.claude-3-haiku-20240307-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2.5e-07,
        "output_cost_per_token": 1.25e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_tool_choice": True,
    },
    "us.anthropic.claude-3-5-haiku-20241022-v1:0": {
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 8e-07,
        "output_cost_per_token": 4e-06,
        "cache_creation_input_token_cost": 1e-06,
        "cache_read_input_token_cost": 8e-08,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_function_calling": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
    },
    "us.anthropic.claude-3-opus-20240229-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 7.5e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_tool_choice": True,
    },
    "eu.anthropic.claude-3-sonnet-20240229-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_tool_choice": True,
    },
    "eu.anthropic.claude-3-5-sonnet-20240620-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_tool_choice": True,
    },
    "eu.anthropic.claude-3-5-sonnet-20241022-v2:0": {
        "supports_computer_use": True,
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_assistant_prefill": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
    },
    "eu.anthropic.claude-3-7-sonnet-20250219-v1:0": {
        "supports_computer_use": True,
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "supports_assistant_prefill": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_pdf_input": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
    },
    "eu.anthropic.claude-3-haiku-20240307-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2.5e-07,
        "output_cost_per_token": 1.25e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_pdf_input": True,
        "supports_tool_choice": True,
    },
    "eu.anthropic.claude-opus-4-20250514-v1:0": {
        "max_tokens": 32000,
        "max_input_tokens": 200000,
        "max_output_tokens": 32000,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 7.5e-05,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.01,
            "search_context_size_medium": 0.01,
            "search_context_size_high": 0.01,
        },
        "cache_creation_input_token_cost": 1.875e-05,
        "cache_read_input_token_cost": 1.5e-06,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supports_computer_use": True,
    },
    "eu.anthropic.claude-sonnet-4-20250514-v1:0": {
        "max_tokens": 64000,
        "max_input_tokens": 200000,
        "max_output_tokens": 64000,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "search_context_cost_per_query": {
            "search_context_size_low": 0.01,
            "search_context_size_medium": 0.01,
            "search_context_size_high": 0.01,
        },
        "cache_creation_input_token_cost": 3.75e-06,
        "cache_read_input_token_cost": 3e-07,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_vision": True,
        "tool_use_system_prompt_tokens": 159,
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "supports_computer_use": True,
    },
    "eu.anthropic.claude-3-5-haiku-20241022-v1:0": {
        "max_tokens": 8192,
        "max_input_tokens": 200000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 2.5e-07,
        "output_cost_per_token": 1.25e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_assistant_prefill": True,
        "supports_pdf_input": True,
        "supports_prompt_caching": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
    },
    "eu.anthropic.claude-3-opus-20240229-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-05,
        "output_cost_per_token": 7.5e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "supports_tool_choice": True,
    },
    "anthropic.claude-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/us-east-1/anthropic.claude-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-west-2/anthropic.claude-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/ap-northeast-1/anthropic.claude-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/ap-northeast-1/1-month-commitment/anthropic.claude-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.0455,
        "output_cost_per_second": 0.0455,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/ap-northeast-1/6-month-commitment/anthropic.claude-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.02527,
        "output_cost_per_second": 0.02527,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/eu-central-1/anthropic.claude-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/eu-central-1/1-month-commitment/anthropic.claude-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.0415,
        "output_cost_per_second": 0.0415,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/eu-central-1/6-month-commitment/anthropic.claude-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.02305,
        "output_cost_per_second": 0.02305,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/us-east-1/1-month-commitment/anthropic.claude-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.0175,
        "output_cost_per_second": 0.0175,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/us-east-1/6-month-commitment/anthropic.claude-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.00972,
        "output_cost_per_second": 0.00972,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/us-west-2/1-month-commitment/anthropic.claude-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.0175,
        "output_cost_per_second": 0.0175,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/us-west-2/6-month-commitment/anthropic.claude-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.00972,
        "output_cost_per_second": 0.00972,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "anthropic.claude-v2": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-east-1/anthropic.claude-v2": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-west-2/anthropic.claude-v2": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/ap-northeast-1/anthropic.claude-v2": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/ap-northeast-1/1-month-commitment/anthropic.claude-v2": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.0455,
        "output_cost_per_second": 0.0455,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/ap-northeast-1/6-month-commitment/anthropic.claude-v2": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.02527,
        "output_cost_per_second": 0.02527,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/eu-central-1/anthropic.claude-v2": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/eu-central-1/1-month-commitment/anthropic.claude-v2": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.0415,
        "output_cost_per_second": 0.0415,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/eu-central-1/6-month-commitment/anthropic.claude-v2": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.02305,
        "output_cost_per_second": 0.02305,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-east-1/1-month-commitment/anthropic.claude-v2": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.0175,
        "output_cost_per_second": 0.0175,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-east-1/6-month-commitment/anthropic.claude-v2": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.00972,
        "output_cost_per_second": 0.00972,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-west-2/1-month-commitment/anthropic.claude-v2": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.0175,
        "output_cost_per_second": 0.0175,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-west-2/6-month-commitment/anthropic.claude-v2": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.00972,
        "output_cost_per_second": 0.00972,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "anthropic.claude-v2:1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-east-1/anthropic.claude-v2:1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-west-2/anthropic.claude-v2:1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/ap-northeast-1/anthropic.claude-v2:1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/ap-northeast-1/1-month-commitment/anthropic.claude-v2:1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.0455,
        "output_cost_per_second": 0.0455,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/ap-northeast-1/6-month-commitment/anthropic.claude-v2:1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.02527,
        "output_cost_per_second": 0.02527,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/eu-central-1/anthropic.claude-v2:1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-06,
        "output_cost_per_token": 2.4e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/eu-central-1/1-month-commitment/anthropic.claude-v2:1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.0415,
        "output_cost_per_second": 0.0415,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/eu-central-1/6-month-commitment/anthropic.claude-v2:1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.02305,
        "output_cost_per_second": 0.02305,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-east-1/1-month-commitment/anthropic.claude-v2:1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.0175,
        "output_cost_per_second": 0.0175,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-east-1/6-month-commitment/anthropic.claude-v2:1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.00972,
        "output_cost_per_second": 0.00972,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-west-2/1-month-commitment/anthropic.claude-v2:1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.0175,
        "output_cost_per_second": 0.0175,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-west-2/6-month-commitment/anthropic.claude-v2:1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.00972,
        "output_cost_per_second": 0.00972,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "anthropic.claude-instant-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-07,
        "output_cost_per_token": 2.4e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-east-1/anthropic.claude-instant-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-07,
        "output_cost_per_token": 2.4e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-east-1/1-month-commitment/anthropic.claude-instant-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.011,
        "output_cost_per_second": 0.011,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-east-1/6-month-commitment/anthropic.claude-instant-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.00611,
        "output_cost_per_second": 0.00611,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-west-2/1-month-commitment/anthropic.claude-instant-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.011,
        "output_cost_per_second": 0.011,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-west-2/6-month-commitment/anthropic.claude-instant-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.00611,
        "output_cost_per_second": 0.00611,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/us-west-2/anthropic.claude-instant-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 8e-07,
        "output_cost_per_token": 2.4e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/ap-northeast-1/anthropic.claude-instant-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 2.23e-06,
        "output_cost_per_token": 7.55e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/ap-northeast-1/1-month-commitment/anthropic.claude-instant-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.01475,
        "output_cost_per_second": 0.01475,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/ap-northeast-1/6-month-commitment/anthropic.claude-instant-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.008194,
        "output_cost_per_second": 0.008194,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/eu-central-1/anthropic.claude-instant-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_token": 2.48e-06,
        "output_cost_per_token": 8.38e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/eu-central-1/1-month-commitment/anthropic.claude-instant-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.01635,
        "output_cost_per_second": 0.01635,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/eu-central-1/6-month-commitment/anthropic.claude-instant-v1": {
        "max_tokens": 8191,
        "max_input_tokens": 100000,
        "max_output_tokens": 8191,
        "input_cost_per_second": 0.009083,
        "output_cost_per_second": 0.009083,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "cohere.rerank-v3-5:0": {
        "max_tokens": 32000,
        "max_input_tokens": 32000,
        "max_output_tokens": 32000,
        "max_query_tokens": 32000,
        "max_document_chunks_per_query": 100,
        "max_tokens_per_document_chunk": 512,
        "input_cost_per_token": 0.0,
        "input_cost_per_query": 0.002,
        "output_cost_per_token": 0.0,
        "litellm_provider": "bedrock",
        "mode": "rerank",
    },
    "cohere.command-text-v14": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-06,
        "output_cost_per_token": 2e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/*/1-month-commitment/cohere.command-text-v14": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_second": 0.011,
        "output_cost_per_second": 0.011,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/*/6-month-commitment/cohere.command-text-v14": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_second": 0.0066027,
        "output_cost_per_second": 0.0066027,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "cohere.command-light-text-v14": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/*/1-month-commitment/cohere.command-light-text-v14": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_second": 0.001902,
        "output_cost_per_second": 0.001902,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "bedrock/*/6-month-commitment/cohere.command-light-text-v14": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_second": 0.0011416,
        "output_cost_per_second": 0.0011416,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "cohere.command-r-plus-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "cohere.command-r-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5e-07,
        "output_cost_per_token": 1.5e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "cohere.embed-english-v3": {
        "max_tokens": 512,
        "max_input_tokens": 512,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "bedrock",
        "mode": "embedding",
        "supports_embedding_image_input": True,
    },
    "cohere.embed-multilingual-v3": {
        "max_tokens": 512,
        "max_input_tokens": 512,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "bedrock",
        "mode": "embedding",
        "supports_embedding_image_input": True,
    },
    "us.deepseek.r1-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.35e-06,
        "output_cost_per_token": 5.4e-06,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_reasoning": True,
        "supports_function_calling": False,
        "supports_tool_choice": False,
    },
    "meta.llama3-3-70b-instruct-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 7.2e-07,
        "output_cost_per_token": 7.2e-07,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": False,
    },
    "meta.llama2-13b-chat-v1": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 7.5e-07,
        "output_cost_per_token": 1e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "meta.llama2-70b-chat-v1": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.95e-06,
        "output_cost_per_token": 2.56e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "meta.llama3-8b-instruct-v1:0": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/us-east-1/meta.llama3-8b-instruct-v1:0": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/us-west-1/meta.llama3-8b-instruct-v1:0": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/ap-south-1/meta.llama3-8b-instruct-v1:0": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3.6e-07,
        "output_cost_per_token": 7.2e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/ca-central-1/meta.llama3-8b-instruct-v1:0": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3.5e-07,
        "output_cost_per_token": 6.9e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/eu-west-1/meta.llama3-8b-instruct-v1:0": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3.2e-07,
        "output_cost_per_token": 6.5e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/eu-west-2/meta.llama3-8b-instruct-v1:0": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3.9e-07,
        "output_cost_per_token": 7.8e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/sa-east-1/meta.llama3-8b-instruct-v1:0": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 5e-07,
        "output_cost_per_token": 1.01e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "meta.llama3-70b-instruct-v1:0": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 2.65e-06,
        "output_cost_per_token": 3.5e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/us-east-1/meta.llama3-70b-instruct-v1:0": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 2.65e-06,
        "output_cost_per_token": 3.5e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/us-west-1/meta.llama3-70b-instruct-v1:0": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 2.65e-06,
        "output_cost_per_token": 3.5e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/ap-south-1/meta.llama3-70b-instruct-v1:0": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3.18e-06,
        "output_cost_per_token": 4.2e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/ca-central-1/meta.llama3-70b-instruct-v1:0": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3.05e-06,
        "output_cost_per_token": 4.03e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/eu-west-1/meta.llama3-70b-instruct-v1:0": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 2.86e-06,
        "output_cost_per_token": 3.78e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/eu-west-2/meta.llama3-70b-instruct-v1:0": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 3.45e-06,
        "output_cost_per_token": 4.55e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "bedrock/sa-east-1/meta.llama3-70b-instruct-v1:0": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 4.45e-06,
        "output_cost_per_token": 5.88e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
    },
    "meta.llama3-1-8b-instruct-v1:0": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 2048,
        "input_cost_per_token": 2.2e-07,
        "output_cost_per_token": 2.2e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": False,
    },
    "us.meta.llama3-1-8b-instruct-v1:0": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 2048,
        "input_cost_per_token": 2.2e-07,
        "output_cost_per_token": 2.2e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": False,
    },
    "meta.llama3-1-70b-instruct-v1:0": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 2048,
        "input_cost_per_token": 9.9e-07,
        "output_cost_per_token": 9.9e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": False,
    },
    "us.meta.llama3-1-70b-instruct-v1:0": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 2048,
        "input_cost_per_token": 9.9e-07,
        "output_cost_per_token": 9.9e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": False,
    },
    "meta.llama3-1-405b-instruct-v1:0": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5.32e-06,
        "output_cost_per_token": 1.6e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": False,
    },
    "us.meta.llama3-1-405b-instruct-v1:0": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5.32e-06,
        "output_cost_per_token": 1.6e-05,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": False,
    },
    "meta.llama3-2-1b-instruct-v1:0": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 1e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": False,
    },
    "us.meta.llama3-2-1b-instruct-v1:0": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 1e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": False,
    },
    "eu.meta.llama3-2-1b-instruct-v1:0": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.3e-07,
        "output_cost_per_token": 1.3e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": False,
    },
    "meta.llama3-2-3b-instruct-v1:0": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 1.5e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": False,
    },
    "us.meta.llama3-2-3b-instruct-v1:0": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 1.5e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": False,
    },
    "eu.meta.llama3-2-3b-instruct-v1:0": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.9e-07,
        "output_cost_per_token": 1.9e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": False,
    },
    "meta.llama3-2-11b-instruct-v1:0": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3.5e-07,
        "output_cost_per_token": 3.5e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": False,
        "supports_vision": True,
    },
    "us.meta.llama3-2-11b-instruct-v1:0": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 3.5e-07,
        "output_cost_per_token": 3.5e-07,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": False,
        "supports_vision": True,
    },
    "meta.llama3-2-90b-instruct-v1:0": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 2e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": False,
        "supports_vision": True,
    },
    "us.meta.llama3-2-90b-instruct-v1:0": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 2e-06,
        "litellm_provider": "bedrock",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": False,
        "supports_vision": True,
    },
    "us.meta.llama3-3-70b-instruct-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 7.2e-07,
        "output_cost_per_token": 7.2e-07,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": False,
    },
    "meta.llama4-maverick-17b-instruct-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2.4e-07,
        "input_cost_per_token_batches": 1.2e-07,
        "output_cost_per_token": 9.7e-07,
        "output_cost_per_token_batches": 4.85e-07,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": False,
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text", "code"],
    },
    "us.meta.llama4-maverick-17b-instruct-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2.4e-07,
        "input_cost_per_token_batches": 1.2e-07,
        "output_cost_per_token": 9.7e-07,
        "output_cost_per_token_batches": 4.85e-07,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": False,
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text", "code"],
    },
    "meta.llama4-scout-17b-instruct-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.7e-07,
        "input_cost_per_token_batches": 8.5e-08,
        "output_cost_per_token": 6.6e-07,
        "output_cost_per_token_batches": 3.3e-07,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": False,
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text", "code"],
    },
    "us.meta.llama4-scout-17b-instruct-v1:0": {
        "max_tokens": 4096,
        "max_input_tokens": 128000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.7e-07,
        "input_cost_per_token_batches": 8.5e-08,
        "output_cost_per_token": 6.6e-07,
        "output_cost_per_token_batches": 3.3e-07,
        "litellm_provider": "bedrock_converse",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": False,
        "supported_modalities": ["text", "image"],
        "supported_output_modalities": ["text", "code"],
    },
    "512-x-512/50-steps/stability.stable-diffusion-xl-v0": {
        "max_tokens": 77,
        "max_input_tokens": 77,
        "output_cost_per_image": 0.018,
        "litellm_provider": "bedrock",
        "mode": "image_generation",
    },
    "512-x-512/max-steps/stability.stable-diffusion-xl-v0": {
        "max_tokens": 77,
        "max_input_tokens": 77,
        "output_cost_per_image": 0.036,
        "litellm_provider": "bedrock",
        "mode": "image_generation",
    },
    "max-x-max/50-steps/stability.stable-diffusion-xl-v0": {
        "max_tokens": 77,
        "max_input_tokens": 77,
        "output_cost_per_image": 0.036,
        "litellm_provider": "bedrock",
        "mode": "image_generation",
    },
    "max-x-max/max-steps/stability.stable-diffusion-xl-v0": {
        "max_tokens": 77,
        "max_input_tokens": 77,
        "output_cost_per_image": 0.072,
        "litellm_provider": "bedrock",
        "mode": "image_generation",
    },
    "1024-x-1024/50-steps/stability.stable-diffusion-xl-v1": {
        "max_tokens": 77,
        "max_input_tokens": 77,
        "output_cost_per_image": 0.04,
        "litellm_provider": "bedrock",
        "mode": "image_generation",
    },
    "1024-x-1024/max-steps/stability.stable-diffusion-xl-v1": {
        "max_tokens": 77,
        "max_input_tokens": 77,
        "output_cost_per_image": 0.08,
        "litellm_provider": "bedrock",
        "mode": "image_generation",
    },
    "stability.sd3-large-v1:0": {
        "max_tokens": 77,
        "max_input_tokens": 77,
        "output_cost_per_image": 0.08,
        "litellm_provider": "bedrock",
        "mode": "image_generation",
    },
    "stability.sd3-5-large-v1:0": {
        "max_tokens": 77,
        "max_input_tokens": 77,
        "output_cost_per_image": 0.08,
        "litellm_provider": "bedrock",
        "mode": "image_generation",
    },
    "stability.stable-image-core-v1:0": {
        "max_tokens": 77,
        "max_input_tokens": 77,
        "output_cost_per_image": 0.04,
        "litellm_provider": "bedrock",
        "mode": "image_generation",
    },
    "stability.stable-image-core-v1:1": {
        "max_tokens": 77,
        "max_input_tokens": 77,
        "output_cost_per_image": 0.04,
        "litellm_provider": "bedrock",
        "mode": "image_generation",
    },
    "stability.stable-image-ultra-v1:0": {
        "max_tokens": 77,
        "max_input_tokens": 77,
        "output_cost_per_image": 0.14,
        "litellm_provider": "bedrock",
        "mode": "image_generation",
    },
    "stability.stable-image-ultra-v1:1": {
        "max_tokens": 77,
        "max_input_tokens": 77,
        "output_cost_per_image": 0.14,
        "litellm_provider": "bedrock",
        "mode": "image_generation",
    },
    "sagemaker/meta-textgeneration-llama-2-7b": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "sagemaker",
        "mode": "completion",
    },
    "sagemaker/meta-textgeneration-llama-2-7b-f": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "sagemaker",
        "mode": "chat",
    },
    "sagemaker/meta-textgeneration-llama-2-13b": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "sagemaker",
        "mode": "completion",
    },
    "sagemaker/meta-textgeneration-llama-2-13b-f": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "sagemaker",
        "mode": "chat",
    },
    "sagemaker/meta-textgeneration-llama-2-70b": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "sagemaker",
        "mode": "completion",
    },
    "sagemaker/meta-textgeneration-llama-2-70b-b-f": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "sagemaker",
        "mode": "chat",
    },
    "together-ai-up-to-4b": {
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 1e-07,
        "litellm_provider": "together_ai",
        "mode": "chat",
    },
    "together-ai-4.1b-8b": {
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 2e-07,
        "litellm_provider": "together_ai",
        "mode": "chat",
    },
    "together-ai-8.1b-21b": {
        "max_tokens": 1000,
        "input_cost_per_token": 3e-07,
        "output_cost_per_token": 3e-07,
        "litellm_provider": "together_ai",
        "mode": "chat",
    },
    "together-ai-21.1b-41b": {
        "input_cost_per_token": 8e-07,
        "output_cost_per_token": 8e-07,
        "litellm_provider": "together_ai",
        "mode": "chat",
    },
    "together-ai-41.1b-80b": {
        "input_cost_per_token": 9e-07,
        "output_cost_per_token": 9e-07,
        "litellm_provider": "together_ai",
        "mode": "chat",
    },
    "together-ai-81.1b-110b": {
        "input_cost_per_token": 1.8e-06,
        "output_cost_per_token": 1.8e-06,
        "litellm_provider": "together_ai",
        "mode": "chat",
    },
    "together-ai-embedding-up-to-150m": {
        "input_cost_per_token": 8e-09,
        "output_cost_per_token": 0.0,
        "litellm_provider": "together_ai",
        "mode": "embedding",
    },
    "together-ai-embedding-151m-to-350m": {
        "input_cost_per_token": 1.6e-08,
        "output_cost_per_token": 0.0,
        "litellm_provider": "together_ai",
        "mode": "embedding",
    },
    "together_ai/meta-llama/Meta-Llama-3.1-8B-Instruct-Turbo": {
        "input_cost_per_token": 1.8e-07,
        "output_cost_per_token": 1.8e-07,
        "litellm_provider": "together_ai",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "together_ai/meta-llama/Meta-Llama-3.1-70B-Instruct-Turbo": {
        "input_cost_per_token": 8.8e-07,
        "output_cost_per_token": 8.8e-07,
        "litellm_provider": "together_ai",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "together_ai/meta-llama/Meta-Llama-3.1-405B-Instruct-Turbo": {
        "input_cost_per_token": 3.5e-06,
        "output_cost_per_token": 3.5e-06,
        "litellm_provider": "together_ai",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "together_ai/meta-llama/Llama-3.3-70B-Instruct-Turbo": {
        "input_cost_per_token": 8.8e-07,
        "output_cost_per_token": 8.8e-07,
        "litellm_provider": "together_ai",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "together_ai/meta-llama/Llama-3.3-70B-Instruct-Turbo-Free": {
        "input_cost_per_token": 0,
        "output_cost_per_token": 0,
        "litellm_provider": "together_ai",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "together_ai/mistralai/Mixtral-8x7B-Instruct-v0.1": {
        "input_cost_per_token": 6e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "together_ai",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "together_ai/mistralai/Mistral-7B-Instruct-v0.1": {
        "litellm_provider": "together_ai",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_response_schema": True,
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "together_ai/togethercomputer/CodeLlama-34b-Instruct": {
        "litellm_provider": "together_ai",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "together_ai/meta-llama/Llama-4-Maverick-17B-128E-Instruct-FP8": {
        "litellm_provider": "together_ai",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "together_ai/meta-llama/Llama-4-Scout-17B-16E-Instruct": {
        "litellm_provider": "together_ai",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "together_ai/meta-llama/Llama-3.2-3B-Instruct-Turbo": {
        "litellm_provider": "together_ai",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "together_ai/Qwen/Qwen2.5-7B-Instruct-Turbo": {
        "litellm_provider": "together_ai",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "together_ai/Qwen/Qwen2.5-72B-Instruct-Turbo": {
        "litellm_provider": "together_ai",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "together_ai/deepseek-ai/DeepSeek-V3": {
        "litellm_provider": "together_ai",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "together_ai/mistralai/Mistral-Small-24B-Instruct-2501": {
        "litellm_provider": "together_ai",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "ollama/codegemma": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "completion",
    },
    "ollama/codegeex4": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 8192,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "chat",
        "supports_function_calling": False,
    },
    "ollama/deepseek-coder-v2-instruct": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 8192,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "chat",
        "supports_function_calling": True,
    },
    "ollama/deepseek-coder-v2-base": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "completion",
        "supports_function_calling": True,
    },
    "ollama/deepseek-coder-v2-lite-instruct": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 8192,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "chat",
        "supports_function_calling": True,
    },
    "ollama/deepseek-coder-v2-lite-base": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "completion",
        "supports_function_calling": True,
    },
    "ollama/internlm2_5-20b-chat": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 8192,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "chat",
        "supports_function_calling": True,
    },
    "ollama/llama2": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "chat",
    },
    "ollama/llama2:7b": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "chat",
    },
    "ollama/llama2:13b": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "chat",
    },
    "ollama/llama2:70b": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "chat",
    },
    "ollama/llama2-uncensored": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "completion",
    },
    "ollama/llama3": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "chat",
    },
    "ollama/llama3:8b": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "chat",
    },
    "ollama/llama3:70b": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "chat",
    },
    "ollama/llama3.1": {
        "max_tokens": 32768,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "chat",
        "supports_function_calling": True,
    },
    "ollama/mistral-large-instruct-2407": {
        "max_tokens": 65536,
        "max_input_tokens": 65536,
        "max_output_tokens": 8192,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "chat",
        "supports_function_calling": True,
    },
    "ollama/mistral": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "completion",
        "supports_function_calling": True,
    },
    "ollama/mistral-7B-Instruct-v0.1": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "chat",
        "supports_function_calling": True,
    },
    "ollama/mistral-7B-Instruct-v0.2": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 32768,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "chat",
        "supports_function_calling": True,
    },
    "ollama/mixtral-8x7B-Instruct-v0.1": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 32768,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "chat",
        "supports_function_calling": True,
    },
    "ollama/mixtral-8x22B-Instruct-v0.1": {
        "max_tokens": 65536,
        "max_input_tokens": 65536,
        "max_output_tokens": 65536,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "chat",
        "supports_function_calling": True,
    },
    "ollama/codellama": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "completion",
    },
    "ollama/orca-mini": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "completion",
    },
    "ollama/vicuna": {
        "max_tokens": 2048,
        "max_input_tokens": 2048,
        "max_output_tokens": 2048,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "ollama",
        "mode": "completion",
    },
    "deepinfra/lizpreciatior/lzlv_70b_fp16_hf": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 7e-07,
        "output_cost_per_token": 9e-07,
        "litellm_provider": "deepinfra",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "deepinfra/Gryphe/MythoMax-L2-13b": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2.2e-07,
        "output_cost_per_token": 2.2e-07,
        "litellm_provider": "deepinfra",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "deepinfra/mistralai/Mistral-7B-Instruct-v0.1": {
        "max_tokens": 8191,
        "max_input_tokens": 32768,
        "max_output_tokens": 8191,
        "input_cost_per_token": 1.3e-07,
        "output_cost_per_token": 1.3e-07,
        "litellm_provider": "deepinfra",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "deepinfra/meta-llama/Llama-2-70b-chat-hf": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 7e-07,
        "output_cost_per_token": 9e-07,
        "litellm_provider": "deepinfra",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "deepinfra/cognitivecomputations/dolphin-2.6-mixtral-8x7b": {
        "max_tokens": 8191,
        "max_input_tokens": 32768,
        "max_output_tokens": 8191,
        "input_cost_per_token": 2.7e-07,
        "output_cost_per_token": 2.7e-07,
        "litellm_provider": "deepinfra",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "deepinfra/codellama/CodeLlama-34b-Instruct-hf": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 6e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "deepinfra",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "deepinfra/deepinfra/mixtral": {
        "max_tokens": 4096,
        "max_input_tokens": 32000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2.7e-07,
        "output_cost_per_token": 2.7e-07,
        "litellm_provider": "deepinfra",
        "mode": "completion",
    },
    "deepinfra/Phind/Phind-CodeLlama-34B-v2": {
        "max_tokens": 4096,
        "max_input_tokens": 16384,
        "max_output_tokens": 4096,
        "input_cost_per_token": 6e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "deepinfra",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "deepinfra/mistralai/Mixtral-8x7B-Instruct-v0.1": {
        "max_tokens": 8191,
        "max_input_tokens": 32768,
        "max_output_tokens": 8191,
        "input_cost_per_token": 2.7e-07,
        "output_cost_per_token": 2.7e-07,
        "litellm_provider": "deepinfra",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "deepinfra/deepinfra/airoboros-70b": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 7e-07,
        "output_cost_per_token": 9e-07,
        "litellm_provider": "deepinfra",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "deepinfra/01-ai/Yi-34B-Chat": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 6e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "deepinfra",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "deepinfra/01-ai/Yi-6B-200K": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.3e-07,
        "output_cost_per_token": 1.3e-07,
        "litellm_provider": "deepinfra",
        "mode": "completion",
    },
    "deepinfra/jondurbin/airoboros-l2-70b-gpt4-1.4.1": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 7e-07,
        "output_cost_per_token": 9e-07,
        "litellm_provider": "deepinfra",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "deepinfra/meta-llama/Llama-2-13b-chat-hf": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2.2e-07,
        "output_cost_per_token": 2.2e-07,
        "litellm_provider": "deepinfra",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "deepinfra/amazon/MistralLite": {
        "max_tokens": 8191,
        "max_input_tokens": 32768,
        "max_output_tokens": 8191,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 2e-07,
        "litellm_provider": "deepinfra",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "deepinfra/meta-llama/Llama-2-7b-chat-hf": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.3e-07,
        "output_cost_per_token": 1.3e-07,
        "litellm_provider": "deepinfra",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "deepinfra/meta-llama/Meta-Llama-3-8B-Instruct": {
        "max_tokens": 8191,
        "max_input_tokens": 8191,
        "max_output_tokens": 4096,
        "input_cost_per_token": 8e-08,
        "output_cost_per_token": 8e-08,
        "litellm_provider": "deepinfra",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "deepinfra/meta-llama/Meta-Llama-3-70B-Instruct": {
        "max_tokens": 8191,
        "max_input_tokens": 8191,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5.9e-07,
        "output_cost_per_token": 7.9e-07,
        "litellm_provider": "deepinfra",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "deepinfra/meta-llama/Meta-Llama-3.1-405B-Instruct": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 32768,
        "input_cost_per_token": 9e-07,
        "output_cost_per_token": 9e-07,
        "litellm_provider": "deepinfra",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_parallel_function_calling": True,
        "supports_tool_choice": True,
    },
    "deepinfra/01-ai/Yi-34B-200K": {
        "max_tokens": 4096,
        "max_input_tokens": 200000,
        "max_output_tokens": 4096,
        "input_cost_per_token": 6e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "deepinfra",
        "mode": "completion",
    },
    "deepinfra/openchat/openchat_3.5": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.3e-07,
        "output_cost_per_token": 1.3e-07,
        "litellm_provider": "deepinfra",
        "mode": "chat",
        "supports_tool_choice": True,
    },
    "perplexity/codellama-34b-instruct": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 16384,
        "input_cost_per_token": 3.5e-07,
        "output_cost_per_token": 1.4e-06,
        "litellm_provider": "perplexity",
        "mode": "chat",
    },
    "perplexity/codellama-70b-instruct": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 16384,
        "input_cost_per_token": 7e-07,
        "output_cost_per_token": 2.8e-06,
        "litellm_provider": "perplexity",
        "mode": "chat",
    },
    "perplexity/llama-3.1-70b-instruct": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 1e-06,
        "litellm_provider": "perplexity",
        "mode": "chat",
    },
    "perplexity/llama-3.1-8b-instruct": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 2e-07,
        "litellm_provider": "perplexity",
        "mode": "chat",
    },
    "perplexity/llama-3.1-sonar-huge-128k-online": {
        "max_tokens": 127072,
        "max_input_tokens": 127072,
        "max_output_tokens": 127072,
        "input_cost_per_token": 5e-06,
        "output_cost_per_token": 5e-06,
        "litellm_provider": "perplexity",
        "mode": "chat",
        "deprecation_date": "2025-02-22",
    },
    "perplexity/llama-3.1-sonar-large-128k-online": {
        "max_tokens": 127072,
        "max_input_tokens": 127072,
        "max_output_tokens": 127072,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 1e-06,
        "litellm_provider": "perplexity",
        "mode": "chat",
        "deprecation_date": "2025-02-22",
    },
    "perplexity/llama-3.1-sonar-large-128k-chat": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 1e-06,
        "litellm_provider": "perplexity",
        "mode": "chat",
        "deprecation_date": "2025-02-22",
    },
    "perplexity/llama-3.1-sonar-small-128k-chat": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 2e-07,
        "litellm_provider": "perplexity",
        "mode": "chat",
        "deprecation_date": "2025-02-22",
    },
    "perplexity/llama-3.1-sonar-small-128k-online": {
        "max_tokens": 127072,
        "max_input_tokens": 127072,
        "max_output_tokens": 127072,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 2e-07,
        "litellm_provider": "perplexity",
        "mode": "chat",
        "deprecation_date": "2025-02-22",
    },
    "perplexity/pplx-7b-chat": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 7e-08,
        "output_cost_per_token": 2.8e-07,
        "litellm_provider": "perplexity",
        "mode": "chat",
    },
    "perplexity/pplx-70b-chat": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 7e-07,
        "output_cost_per_token": 2.8e-06,
        "litellm_provider": "perplexity",
        "mode": "chat",
    },
    "perplexity/pplx-7b-online": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 2.8e-07,
        "input_cost_per_request": 0.005,
        "litellm_provider": "perplexity",
        "mode": "chat",
    },
    "perplexity/pplx-70b-online": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 2.8e-06,
        "input_cost_per_request": 0.005,
        "litellm_provider": "perplexity",
        "mode": "chat",
    },
    "perplexity/llama-2-70b-chat": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 7e-07,
        "output_cost_per_token": 2.8e-06,
        "litellm_provider": "perplexity",
        "mode": "chat",
    },
    "perplexity/mistral-7b-instruct": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 7e-08,
        "output_cost_per_token": 2.8e-07,
        "litellm_provider": "perplexity",
        "mode": "chat",
    },
    "perplexity/mixtral-8x7b-instruct": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 7e-08,
        "output_cost_per_token": 2.8e-07,
        "litellm_provider": "perplexity",
        "mode": "chat",
    },
    "perplexity/sonar-small-chat": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 16384,
        "input_cost_per_token": 7e-08,
        "output_cost_per_token": 2.8e-07,
        "litellm_provider": "perplexity",
        "mode": "chat",
    },
    "perplexity/sonar-small-online": {
        "max_tokens": 12000,
        "max_input_tokens": 12000,
        "max_output_tokens": 12000,
        "input_cost_per_token": 0,
        "output_cost_per_token": 2.8e-07,
        "input_cost_per_request": 0.005,
        "litellm_provider": "perplexity",
        "mode": "chat",
    },
    "perplexity/sonar-medium-chat": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 16384,
        "input_cost_per_token": 6e-07,
        "output_cost_per_token": 1.8e-06,
        "litellm_provider": "perplexity",
        "mode": "chat",
    },
    "perplexity/sonar-medium-online": {
        "max_tokens": 12000,
        "max_input_tokens": 12000,
        "max_output_tokens": 12000,
        "input_cost_per_token": 0,
        "output_cost_per_token": 1.8e-06,
        "input_cost_per_request": 0.005,
        "litellm_provider": "perplexity",
        "mode": "chat",
    },
    "perplexity/sonar": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 1e-06,
        "litellm_provider": "perplexity",
        "mode": "chat",
        "search_context_cost_per_query": {
            "search_context_size_low": 0.005,
            "search_context_size_medium": 0.008,
            "search_context_size_high": 0.012,
        },
        "supports_web_search": True,
    },
    "perplexity/sonar-pro": {
        "max_tokens": 8000,
        "max_input_tokens": 200000,
        "max_output_tokens": 8000,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 1.5e-05,
        "litellm_provider": "perplexity",
        "mode": "chat",
        "search_context_cost_per_query": {
            "search_context_size_low": 0.006,
            "search_context_size_medium": 0.01,
            "search_context_size_high": 0.014,
        },
        "supports_web_search": True,
    },
    "perplexity/sonar-reasoning": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 5e-06,
        "litellm_provider": "perplexity",
        "mode": "chat",
        "search_context_cost_per_query": {
            "search_context_size_low": 0.005,
            "search_context_size_medium": 0.008,
            "search_context_size_high": 0.014,
        },
        "supports_web_search": True,
        "supports_reasoning": True,
    },
    "perplexity/sonar-reasoning-pro": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 8e-06,
        "litellm_provider": "perplexity",
        "mode": "chat",
        "search_context_cost_per_query": {
            "search_context_size_low": 0.006,
            "search_context_size_medium": 0.01,
            "search_context_size_high": 0.014,
        },
        "supports_web_search": True,
        "supports_reasoning": True,
    },
    "perplexity/sonar-deep-research": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "input_cost_per_token": 2e-06,
        "output_cost_per_token": 8e-06,
        "output_cost_per_reasoning_token": 3e-06,
        "litellm_provider": "perplexity",
        "mode": "chat",
        "search_context_cost_per_query": {
            "search_context_size_low": 0.005,
            "search_context_size_medium": 0.005,
            "search_context_size_high": 0.005,
        },
        "supports_reasoning": True,
        "supports_web_search": True,
    },
    "fireworks_ai/accounts/fireworks/models/llama-v3p2-1b-instruct": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 16384,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 1e-07,
        "litellm_provider": "fireworks_ai",
        "mode": "chat",
        "supports_function_calling": False,
        "supports_response_schema": True,
        "source": "https://fireworks.ai/pricing",
        "supports_tool_choice": False,
    },
    "fireworks_ai/accounts/fireworks/models/llama-v3p2-3b-instruct": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 16384,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 1e-07,
        "litellm_provider": "fireworks_ai",
        "mode": "chat",
        "supports_function_calling": False,
        "supports_response_schema": True,
        "source": "https://fireworks.ai/pricing",
        "supports_tool_choice": False,
    },
    "fireworks_ai/accounts/fireworks/models/llama-v3p1-8b-instruct": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 16384,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 1e-07,
        "litellm_provider": "fireworks_ai",
        "mode": "chat",
        "supports_function_calling": False,
        "supports_response_schema": True,
        "source": "https://fireworks.ai/pricing",
        "supports_tool_choice": False,
    },
    "fireworks_ai/accounts/fireworks/models/llama-v3p2-11b-vision-instruct": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 16384,
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 2e-07,
        "litellm_provider": "fireworks_ai",
        "mode": "chat",
        "supports_function_calling": False,
        "supports_vision": True,
        "supports_response_schema": True,
        "source": "https://fireworks.ai/pricing",
        "supports_tool_choice": False,
    },
    "fireworks_ai/accounts/fireworks/models/llama-v3p2-90b-vision-instruct": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 16384,
        "input_cost_per_token": 9e-07,
        "output_cost_per_token": 9e-07,
        "litellm_provider": "fireworks_ai",
        "mode": "chat",
        "supports_tool_choice": False,
        "supports_vision": True,
        "supports_response_schema": True,
        "source": "https://fireworks.ai/pricing",
    },
    "fireworks_ai/accounts/fireworks/models/firefunction-v2": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 9e-07,
        "output_cost_per_token": 9e-07,
        "litellm_provider": "fireworks_ai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "source": "https://fireworks.ai/pricing",
        "supports_tool_choice": True,
    },
    "fireworks_ai/accounts/fireworks/models/mixtral-8x22b-instruct-hf": {
        "max_tokens": 65536,
        "max_input_tokens": 65536,
        "max_output_tokens": 65536,
        "input_cost_per_token": 1.2e-06,
        "output_cost_per_token": 1.2e-06,
        "litellm_provider": "fireworks_ai",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "source": "https://fireworks.ai/pricing",
        "supports_tool_choice": True,
    },
    "fireworks_ai/accounts/fireworks/models/qwen2-72b-instruct": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 32768,
        "input_cost_per_token": 9e-07,
        "output_cost_per_token": 9e-07,
        "litellm_provider": "fireworks_ai",
        "mode": "chat",
        "supports_function_calling": False,
        "supports_response_schema": True,
        "source": "https://fireworks.ai/pricing",
        "supports_tool_choice": False,
    },
    "fireworks_ai/accounts/fireworks/models/qwen2p5-coder-32b-instruct": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 9e-07,
        "output_cost_per_token": 9e-07,
        "litellm_provider": "fireworks_ai",
        "mode": "chat",
        "supports_function_calling": False,
        "supports_response_schema": True,
        "source": "https://fireworks.ai/pricing",
        "supports_tool_choice": False,
    },
    "fireworks_ai/accounts/fireworks/models/yi-large": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 32768,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 3e-06,
        "litellm_provider": "fireworks_ai",
        "mode": "chat",
        "supports_function_calling": False,
        "supports_response_schema": True,
        "source": "https://fireworks.ai/pricing",
        "supports_tool_choice": False,
    },
    "fireworks_ai/accounts/fireworks/models/deepseek-coder-v2-instruct": {
        "max_tokens": 65536,
        "max_input_tokens": 65536,
        "max_output_tokens": 65536,
        "input_cost_per_token": 1.2e-06,
        "output_cost_per_token": 1.2e-06,
        "litellm_provider": "fireworks_ai",
        "mode": "chat",
        "supports_function_calling": False,
        "supports_response_schema": True,
        "source": "https://fireworks.ai/pricing",
        "supports_tool_choice": False,
    },
    "fireworks_ai/accounts/fireworks/models/deepseek-v3": {
        "max_tokens": 8192,
        "max_input_tokens": 128000,
        "max_output_tokens": 8192,
        "input_cost_per_token": 9e-07,
        "output_cost_per_token": 9e-07,
        "litellm_provider": "fireworks_ai",
        "mode": "chat",
        "supports_response_schema": True,
        "source": "https://fireworks.ai/pricing",
        "supports_tool_choice": False,
    },
    "fireworks_ai/accounts/fireworks/models/deepseek-r1": {
        "max_tokens": 20480,
        "max_input_tokens": 128000,
        "max_output_tokens": 20480,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 8e-06,
        "litellm_provider": "fireworks_ai",
        "mode": "chat",
        "supports_response_schema": True,
        "source": "https://fireworks.ai/pricing",
        "supports_tool_choice": False,
    },
    "fireworks_ai/accounts/fireworks/models/deepseek-r1-basic": {
        "max_tokens": 20480,
        "max_input_tokens": 128000,
        "max_output_tokens": 20480,
        "input_cost_per_token": 5.5e-07,
        "output_cost_per_token": 2.19e-06,
        "litellm_provider": "fireworks_ai",
        "mode": "chat",
        "supports_response_schema": True,
        "source": "https://fireworks.ai/pricing",
        "supports_tool_choice": False,
    },
    "fireworks_ai/accounts/fireworks/models/deepseek-r1-0528": {
        "max_tokens": 160000,
        "max_input_tokens": 160000,
        "max_output_tokens": 160000,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 8e-06,
        "litellm_provider": "fireworks_ai",
        "mode": "chat",
        "source": "https://fireworks.ai/pricing",
        "supports_tool_choice": False,
        "supports_response_schema": True,
    },
    "fireworks_ai/accounts/fireworks/models/llama-v3p1-405b-instruct": {
        "max_tokens": 16384,
        "max_input_tokens": 128000,
        "max_output_tokens": 16384,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 3e-06,
        "litellm_provider": "fireworks_ai",
        "mode": "chat",
        "supports_response_schema": True,
        "source": "https://fireworks.ai/pricing",
        "supports_tool_choice": True,
        "supports_function_calling": True,
    },
    "fireworks_ai/accounts/fireworks/models/llama4-maverick-instruct-basic": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 2.2e-07,
        "output_cost_per_token": 8.8e-07,
        "litellm_provider": "fireworks_ai",
        "mode": "chat",
        "supports_response_schema": True,
        "source": "https://fireworks.ai/pricing",
        "supports_tool_choice": False,
    },
    "fireworks_ai/accounts/fireworks/models/llama4-scout-instruct-basic": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "fireworks_ai",
        "mode": "chat",
        "supports_response_schema": True,
        "source": "https://fireworks.ai/pricing",
        "supports_tool_choice": False,
    },
    "fireworks_ai/nomic-ai/nomic-embed-text-v1.5": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "input_cost_per_token": 8e-09,
        "output_cost_per_token": 0.0,
        "litellm_provider": "fireworks_ai-embedding-models",
        "mode": "embedding",
        "source": "https://fireworks.ai/pricing",
    },
    "fireworks_ai/nomic-ai/nomic-embed-text-v1": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "input_cost_per_token": 8e-09,
        "output_cost_per_token": 0.0,
        "litellm_provider": "fireworks_ai-embedding-models",
        "mode": "embedding",
        "source": "https://fireworks.ai/pricing",
    },
    "fireworks_ai/WhereIsAI/UAE-Large-V1": {
        "max_tokens": 512,
        "max_input_tokens": 512,
        "input_cost_per_token": 1.6e-08,
        "output_cost_per_token": 0.0,
        "litellm_provider": "fireworks_ai-embedding-models",
        "mode": "embedding",
        "source": "https://fireworks.ai/pricing",
    },
    "fireworks_ai/thenlper/gte-large": {
        "max_tokens": 512,
        "max_input_tokens": 512,
        "input_cost_per_token": 1.6e-08,
        "output_cost_per_token": 0.0,
        "litellm_provider": "fireworks_ai-embedding-models",
        "mode": "embedding",
        "source": "https://fireworks.ai/pricing",
    },
    "fireworks_ai/thenlper/gte-base": {
        "max_tokens": 512,
        "max_input_tokens": 512,
        "input_cost_per_token": 8e-09,
        "output_cost_per_token": 0.0,
        "litellm_provider": "fireworks_ai-embedding-models",
        "mode": "embedding",
        "source": "https://fireworks.ai/pricing",
    },
    "fireworks-ai-up-to-4b": {
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 2e-07,
        "litellm_provider": "fireworks_ai",
    },
    "fireworks-ai-4.1b-to-16b": {
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 2e-07,
        "litellm_provider": "fireworks_ai",
    },
    "fireworks-ai-above-16b": {
        "input_cost_per_token": 9e-07,
        "output_cost_per_token": 9e-07,
        "litellm_provider": "fireworks_ai",
    },
    "fireworks-ai-moe-up-to-56b": {
        "input_cost_per_token": 5e-07,
        "output_cost_per_token": 5e-07,
        "litellm_provider": "fireworks_ai",
    },
    "fireworks-ai-56b-to-176b": {
        "input_cost_per_token": 1.2e-06,
        "output_cost_per_token": 1.2e-06,
        "litellm_provider": "fireworks_ai",
    },
    "fireworks-ai-default": {
        "input_cost_per_token": 0.0,
        "output_cost_per_token": 0.0,
        "litellm_provider": "fireworks_ai",
    },
    "fireworks-ai-embedding-up-to-150m": {
        "input_cost_per_token": 8e-09,
        "output_cost_per_token": 0.0,
        "litellm_provider": "fireworks_ai-embedding-models",
    },
    "fireworks-ai-embedding-150m-to-350m": {
        "input_cost_per_token": 1.6e-08,
        "output_cost_per_token": 0.0,
        "litellm_provider": "fireworks_ai-embedding-models",
    },
    "anyscale/mistralai/Mistral-7B-Instruct-v0.1": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 16384,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 1.5e-07,
        "litellm_provider": "anyscale",
        "mode": "chat",
        "supports_function_calling": True,
        "source": "https://docs.anyscale.com/preview/endpoints/text-generation/supported-models/mistralai-Mistral-7B-Instruct-v0.1",
    },
    "anyscale/mistralai/Mixtral-8x7B-Instruct-v0.1": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 16384,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 1.5e-07,
        "litellm_provider": "anyscale",
        "mode": "chat",
        "supports_function_calling": True,
        "source": "https://docs.anyscale.com/preview/endpoints/text-generation/supported-models/mistralai-Mixtral-8x7B-Instruct-v0.1",
    },
    "anyscale/mistralai/Mixtral-8x22B-Instruct-v0.1": {
        "max_tokens": 65536,
        "max_input_tokens": 65536,
        "max_output_tokens": 65536,
        "input_cost_per_token": 9e-07,
        "output_cost_per_token": 9e-07,
        "litellm_provider": "anyscale",
        "mode": "chat",
        "supports_function_calling": True,
        "source": "https://docs.anyscale.com/preview/endpoints/text-generation/supported-models/mistralai-Mixtral-8x22B-Instruct-v0.1",
    },
    "anyscale/HuggingFaceH4/zephyr-7b-beta": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 16384,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 1.5e-07,
        "litellm_provider": "anyscale",
        "mode": "chat",
    },
    "anyscale/google/gemma-7b-it": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 1.5e-07,
        "litellm_provider": "anyscale",
        "mode": "chat",
        "source": "https://docs.anyscale.com/preview/endpoints/text-generation/supported-models/google-gemma-7b-it",
    },
    "anyscale/meta-llama/Llama-2-7b-chat-hf": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 1.5e-07,
        "litellm_provider": "anyscale",
        "mode": "chat",
    },
    "anyscale/meta-llama/Llama-2-13b-chat-hf": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 2.5e-07,
        "output_cost_per_token": 2.5e-07,
        "litellm_provider": "anyscale",
        "mode": "chat",
    },
    "anyscale/meta-llama/Llama-2-70b-chat-hf": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 1e-06,
        "litellm_provider": "anyscale",
        "mode": "chat",
    },
    "anyscale/codellama/CodeLlama-34b-Instruct-hf": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 1e-06,
        "litellm_provider": "anyscale",
        "mode": "chat",
    },
    "anyscale/codellama/CodeLlama-70b-Instruct-hf": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 1e-06,
        "litellm_provider": "anyscale",
        "mode": "chat",
        "source": "https://docs.anyscale.com/preview/endpoints/text-generation/supported-models/codellama-CodeLlama-70b-Instruct-hf",
    },
    "anyscale/meta-llama/Meta-Llama-3-8B-Instruct": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 1.5e-07,
        "litellm_provider": "anyscale",
        "mode": "chat",
        "source": "https://docs.anyscale.com/preview/endpoints/text-generation/supported-models/meta-llama-Meta-Llama-3-8B-Instruct",
    },
    "anyscale/meta-llama/Meta-Llama-3-70B-Instruct": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1e-06,
        "output_cost_per_token": 1e-06,
        "litellm_provider": "anyscale",
        "mode": "chat",
        "source": "https://docs.anyscale.com/preview/endpoints/text-generation/supported-models/meta-llama-Meta-Llama-3-70B-Instruct",
    },
    "cloudflare/@cf/meta/llama-2-7b-chat-fp16": {
        "max_tokens": 3072,
        "max_input_tokens": 3072,
        "max_output_tokens": 3072,
        "input_cost_per_token": 1.923e-06,
        "output_cost_per_token": 1.923e-06,
        "litellm_provider": "cloudflare",
        "mode": "chat",
    },
    "cloudflare/@cf/meta/llama-2-7b-chat-int8": {
        "max_tokens": 2048,
        "max_input_tokens": 2048,
        "max_output_tokens": 2048,
        "input_cost_per_token": 1.923e-06,
        "output_cost_per_token": 1.923e-06,
        "litellm_provider": "cloudflare",
        "mode": "chat",
    },
    "cloudflare/@cf/mistral/mistral-7b-instruct-v0.1": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 1.923e-06,
        "output_cost_per_token": 1.923e-06,
        "litellm_provider": "cloudflare",
        "mode": "chat",
    },
    "cloudflare/@hf/thebloke/codellama-7b-instruct-awq": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 1.923e-06,
        "output_cost_per_token": 1.923e-06,
        "litellm_provider": "cloudflare",
        "mode": "chat",
    },
    "voyage/voyage-01": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "voyage",
        "mode": "embedding",
    },
    "voyage/voyage-lite-01": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "voyage",
        "mode": "embedding",
    },
    "voyage/voyage-large-2": {
        "max_tokens": 16000,
        "max_input_tokens": 16000,
        "input_cost_per_token": 1.2e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "voyage",
        "mode": "embedding",
    },
    "voyage/voyage-finance-2": {
        "max_tokens": 32000,
        "max_input_tokens": 32000,
        "input_cost_per_token": 1.2e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "voyage",
        "mode": "embedding",
    },
    "voyage/voyage-lite-02-instruct": {
        "max_tokens": 4000,
        "max_input_tokens": 4000,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "voyage",
        "mode": "embedding",
    },
    "voyage/voyage-law-2": {
        "max_tokens": 16000,
        "max_input_tokens": 16000,
        "input_cost_per_token": 1.2e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "voyage",
        "mode": "embedding",
    },
    "voyage/voyage-code-2": {
        "max_tokens": 16000,
        "max_input_tokens": 16000,
        "input_cost_per_token": 1.2e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "voyage",
        "mode": "embedding",
    },
    "voyage/voyage-2": {
        "max_tokens": 4000,
        "max_input_tokens": 4000,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "voyage",
        "mode": "embedding",
    },
    "voyage/voyage-3-large": {
        "max_tokens": 32000,
        "max_input_tokens": 32000,
        "input_cost_per_token": 1.8e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "voyage",
        "mode": "embedding",
    },
    "voyage/voyage-3": {
        "max_tokens": 32000,
        "max_input_tokens": 32000,
        "input_cost_per_token": 6e-08,
        "output_cost_per_token": 0.0,
        "litellm_provider": "voyage",
        "mode": "embedding",
    },
    "voyage/voyage-3-lite": {
        "max_tokens": 32000,
        "max_input_tokens": 32000,
        "input_cost_per_token": 2e-08,
        "output_cost_per_token": 0.0,
        "litellm_provider": "voyage",
        "mode": "embedding",
    },
    "voyage/voyage-code-3": {
        "max_tokens": 32000,
        "max_input_tokens": 32000,
        "input_cost_per_token": 1.8e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "voyage",
        "mode": "embedding",
    },
    "voyage/voyage-multimodal-3": {
        "max_tokens": 32000,
        "max_input_tokens": 32000,
        "input_cost_per_token": 1.2e-07,
        "output_cost_per_token": 0.0,
        "litellm_provider": "voyage",
        "mode": "embedding",
    },
    "voyage/rerank-2": {
        "max_tokens": 16000,
        "max_input_tokens": 16000,
        "max_output_tokens": 16000,
        "max_query_tokens": 16000,
        "input_cost_per_token": 5e-08,
        "input_cost_per_query": 5e-08,
        "output_cost_per_token": 0.0,
        "litellm_provider": "voyage",
        "mode": "rerank",
    },
    "voyage/rerank-2-lite": {
        "max_tokens": 8000,
        "max_input_tokens": 8000,
        "max_output_tokens": 8000,
        "max_query_tokens": 8000,
        "input_cost_per_token": 2e-08,
        "input_cost_per_query": 2e-08,
        "output_cost_per_token": 0.0,
        "litellm_provider": "voyage",
        "mode": "rerank",
    },
    "databricks/databricks-claude-3-7-sonnet": {
        "max_tokens": 200000,
        "max_input_tokens": 200000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 2.5e-06,
        "input_dbu_cost_per_token": 3.571e-05,
        "output_cost_per_token": 1.7857e-05,
        "output_db_cost_per_token": 0.000214286,
        "litellm_provider": "databricks",
        "mode": "chat",
        "source": "https://www.databricks.com/product/pricing/foundation-model-serving",
        "metadata": {
            "notes": "Input/output cost per token is dbu cost * $0.070, based on databricks Claude 3.7 conversion. Number provided for reference, '*_dbu_cost_per_token' used in actual calculation."
        },
        "supports_assistant_prefill": True,
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
    },
    "databricks/databricks-meta-llama-3-1-405b-instruct": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 5e-06,
        "input_dbu_cost_per_token": 7.1429e-05,
        "output_cost_per_token": 1.500002e-05,
        "output_db_cost_per_token": 0.000214286,
        "litellm_provider": "databricks",
        "mode": "chat",
        "source": "https://www.databricks.com/product/pricing/foundation-model-serving",
        "metadata": {
            "notes": "Input/output cost per token is dbu cost * $0.070, based on databricks Llama 3.1 70B conversion. Number provided for reference, '*_dbu_cost_per_token' used in actual calculation."
        },
        "supports_tool_choice": True,
    },
    "databricks/databricks-meta-llama-3-1-70b-instruct": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 1.00002e-06,
        "input_dbu_cost_per_token": 1.4286e-05,
        "output_cost_per_token": 2.99999e-06,
        "output_dbu_cost_per_token": 4.2857e-05,
        "litellm_provider": "databricks",
        "mode": "chat",
        "source": "https://www.databricks.com/product/pricing/foundation-model-serving",
        "metadata": {
            "notes": "Input/output cost per token is dbu cost * $0.070, based on databricks Llama 3.1 70B conversion. Number provided for reference, '*_dbu_cost_per_token' used in actual calculation."
        },
        "supports_tool_choice": True,
    },
    "databricks/databricks-meta-llama-3-3-70b-instruct": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 1.00002e-06,
        "input_dbu_cost_per_token": 1.4286e-05,
        "output_cost_per_token": 2.99999e-06,
        "output_dbu_cost_per_token": 4.2857e-05,
        "litellm_provider": "databricks",
        "mode": "chat",
        "source": "https://www.databricks.com/product/pricing/foundation-model-serving",
        "metadata": {
            "notes": "Input/output cost per token is dbu cost * $0.070, based on databricks Llama 3.1 70B conversion. Number provided for reference, '*_dbu_cost_per_token' used in actual calculation."
        },
        "supports_tool_choice": True,
    },
    "databricks/databricks-llama-4-maverick": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 5e-06,
        "input_dbu_cost_per_token": 7.143e-05,
        "output_cost_per_token": 1.5e-05,
        "output_dbu_cost_per_token": 0.00021429,
        "litellm_provider": "databricks",
        "mode": "chat",
        "source": "https://www.databricks.com/product/pricing/foundation-model-serving",
        "metadata": {
            "notes": "Databricks documentation now provides both DBU costs (_dbu_cost_per_token) and dollar costs(_cost_per_token)."
        },
        "supports_tool_choice": True,
    },
    "databricks/databricks-dbrx-instruct": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 32768,
        "input_cost_per_token": 7.4998e-07,
        "input_dbu_cost_per_token": 1.0714e-05,
        "output_cost_per_token": 2.24901e-06,
        "output_dbu_cost_per_token": 3.2143e-05,
        "litellm_provider": "databricks",
        "mode": "chat",
        "source": "https://www.databricks.com/product/pricing/foundation-model-serving",
        "metadata": {
            "notes": "Input/output cost per token is dbu cost * $0.070, based on databricks Llama 3.1 70B conversion. Number provided for reference, '*_dbu_cost_per_token' used in actual calculation."
        },
        "supports_tool_choice": True,
    },
    "databricks/databricks-meta-llama-3-70b-instruct": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 128000,
        "input_cost_per_token": 1.00002e-06,
        "input_dbu_cost_per_token": 1.4286e-05,
        "output_cost_per_token": 2.99999e-06,
        "output_dbu_cost_per_token": 4.2857e-05,
        "litellm_provider": "databricks",
        "mode": "chat",
        "source": "https://www.databricks.com/product/pricing/foundation-model-serving",
        "metadata": {
            "notes": "Input/output cost per token is dbu cost * $0.070, based on databricks Llama 3.1 70B conversion. Number provided for reference, '*_dbu_cost_per_token' used in actual calculation."
        },
        "supports_tool_choice": True,
    },
    "databricks/databricks-llama-2-70b-chat": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5.0001e-07,
        "input_dbu_cost_per_token": 7.143e-06,
        "output_cost_per_token": 1.5e-06,
        "output_dbu_cost_per_token": 2.1429e-05,
        "litellm_provider": "databricks",
        "mode": "chat",
        "source": "https://www.databricks.com/product/pricing/foundation-model-serving",
        "metadata": {
            "notes": "Input/output cost per token is dbu cost * $0.070, based on databricks Llama 3.1 70B conversion. Number provided for reference, '*_dbu_cost_per_token' used in actual calculation."
        },
        "supports_tool_choice": True,
    },
    "databricks/databricks-mixtral-8x7b-instruct": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5.0001e-07,
        "input_dbu_cost_per_token": 7.143e-06,
        "output_cost_per_token": 9.9902e-07,
        "output_dbu_cost_per_token": 1.4286e-05,
        "litellm_provider": "databricks",
        "mode": "chat",
        "source": "https://www.databricks.com/product/pricing/foundation-model-serving",
        "metadata": {
            "notes": "Input/output cost per token is dbu cost * $0.070, based on databricks Llama 3.1 70B conversion. Number provided for reference, '*_dbu_cost_per_token' used in actual calculation."
        },
        "supports_tool_choice": True,
    },
    "databricks/databricks-mpt-30b-instruct": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 9.9902e-07,
        "input_dbu_cost_per_token": 1.4286e-05,
        "output_cost_per_token": 9.9902e-07,
        "output_dbu_cost_per_token": 1.4286e-05,
        "litellm_provider": "databricks",
        "mode": "chat",
        "source": "https://www.databricks.com/product/pricing/foundation-model-serving",
        "metadata": {
            "notes": "Input/output cost per token is dbu cost * $0.070, based on databricks Llama 3.1 70B conversion. Number provided for reference, '*_dbu_cost_per_token' used in actual calculation."
        },
        "supports_tool_choice": True,
    },
    "databricks/databricks-mpt-7b-instruct": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 5.0001e-07,
        "input_dbu_cost_per_token": 7.143e-06,
        "output_cost_per_token": 0.0,
        "output_dbu_cost_per_token": 0.0,
        "litellm_provider": "databricks",
        "mode": "chat",
        "source": "https://www.databricks.com/product/pricing/foundation-model-serving",
        "metadata": {
            "notes": "Input/output cost per token is dbu cost * $0.070, based on databricks Llama 3.1 70B conversion. Number provided for reference, '*_dbu_cost_per_token' used in actual calculation."
        },
        "supports_tool_choice": True,
    },
    "databricks/databricks-bge-large-en": {
        "max_tokens": 512,
        "max_input_tokens": 512,
        "output_vector_size": 1024,
        "input_cost_per_token": 1.0003e-07,
        "input_dbu_cost_per_token": 1.429e-06,
        "output_cost_per_token": 0.0,
        "output_dbu_cost_per_token": 0.0,
        "litellm_provider": "databricks",
        "mode": "embedding",
        "source": "https://www.databricks.com/product/pricing/foundation-model-serving",
        "metadata": {
            "notes": "Input/output cost per token is dbu cost * $0.070, based on databricks Llama 3.1 70B conversion. Number provided for reference, '*_dbu_cost_per_token' used in actual calculation."
        },
    },
    "databricks/databricks-gte-large-en": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "output_vector_size": 1024,
        "input_cost_per_token": 1.2999e-07,
        "input_dbu_cost_per_token": 1.857e-06,
        "output_cost_per_token": 0.0,
        "output_dbu_cost_per_token": 0.0,
        "litellm_provider": "databricks",
        "mode": "embedding",
        "source": "https://www.databricks.com/product/pricing/foundation-model-serving",
        "metadata": {
            "notes": "Input/output cost per token is dbu cost * $0.070, based on databricks Llama 3.1 70B conversion. Number provided for reference, '*_dbu_cost_per_token' used in actual calculation."
        },
    },
    "sambanova/Meta-Llama-3.1-8B-Instruct": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 16384,
        "input_cost_per_token": 1e-07,
        "output_cost_per_token": 2e-07,
        "litellm_provider": "sambanova",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_response_schema": True,
        "source": "https://cloud.sambanova.ai/plans/pricing",
    },
    "sambanova/Meta-Llama-3.1-405B-Instruct": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 16384,
        "input_cost_per_token": 5e-06,
        "output_cost_per_token": 1e-05,
        "litellm_provider": "sambanova",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_response_schema": True,
        "source": "https://cloud.sambanova.ai/plans/pricing",
    },
    "sambanova/Meta-Llama-3.2-1B-Instruct": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 16384,
        "input_cost_per_token": 4e-08,
        "output_cost_per_token": 8e-08,
        "litellm_provider": "sambanova",
        "mode": "chat",
        "source": "https://cloud.sambanova.ai/plans/pricing",
    },
    "sambanova/Meta-Llama-3.2-3B-Instruct": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 8e-08,
        "output_cost_per_token": 1.6e-07,
        "litellm_provider": "sambanova",
        "mode": "chat",
        "source": "https://cloud.sambanova.ai/plans/pricing",
    },
    "sambanova/Llama-4-Maverick-17B-128E-Instruct": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 6.3e-07,
        "output_cost_per_token": 1.8e-06,
        "litellm_provider": "sambanova",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_response_schema": True,
        "supports_vision": True,
        "source": "https://cloud.sambanova.ai/plans/pricing",
        "metadata": {
            "notes": "For vision models, images are converted to 6432 input tokens and are billed at that amount"
        },
    },
    "sambanova/Llama-4-Scout-17B-16E-Instruct": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 4e-07,
        "output_cost_per_token": 7e-07,
        "litellm_provider": "sambanova",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_response_schema": True,
        "source": "https://cloud.sambanova.ai/plans/pricing",
        "metadata": {
            "notes": "For vision models, images are converted to 6432 input tokens and are billed at that amount"
        },
    },
    "sambanova/Meta-Llama-3.3-70B-Instruct": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 6e-07,
        "output_cost_per_token": 1.2e-06,
        "litellm_provider": "sambanova",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_response_schema": True,
        "supports_tool_choice": True,
        "source": "https://cloud.sambanova.ai/plans/pricing",
    },
    "sambanova/Meta-Llama-Guard-3-8B": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 16384,
        "input_cost_per_token": 3e-07,
        "output_cost_per_token": 3e-07,
        "litellm_provider": "sambanova",
        "mode": "chat",
        "source": "https://cloud.sambanova.ai/plans/pricing",
    },
    "sambanova/Qwen3-32B": {
        "max_tokens": 8192,
        "max_input_tokens": 8192,
        "max_output_tokens": 8192,
        "input_cost_per_token": 4e-07,
        "output_cost_per_token": 8e-07,
        "litellm_provider": "sambanova",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "mode": "chat",
        "source": "https://cloud.sambanova.ai/plans/pricing",
    },
    "sambanova/QwQ-32B": {
        "max_tokens": 16384,
        "max_input_tokens": 16384,
        "max_output_tokens": 16384,
        "input_cost_per_token": 5e-07,
        "output_cost_per_token": 1e-06,
        "litellm_provider": "sambanova",
        "mode": "chat",
        "source": "https://cloud.sambanova.ai/plans/pricing",
    },
    "sambanova/Qwen2-Audio-7B-Instruct": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 4096,
        "input_cost_per_token": 5e-07,
        "output_cost_per_token": 0.0001,
        "litellm_provider": "sambanova",
        "mode": "chat",
        "supports_audio_input": True,
        "source": "https://cloud.sambanova.ai/plans/pricing",
    },
    "sambanova/DeepSeek-R1-Distill-Llama-70B": {
        "max_tokens": 131072,
        "max_input_tokens": 131072,
        "max_output_tokens": 131072,
        "input_cost_per_token": 7e-07,
        "output_cost_per_token": 1.4e-06,
        "litellm_provider": "sambanova",
        "mode": "chat",
        "source": "https://cloud.sambanova.ai/plans/pricing",
    },
    "sambanova/DeepSeek-R1": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 32768,
        "input_cost_per_token": 5e-06,
        "output_cost_per_token": 7e-06,
        "litellm_provider": "sambanova",
        "mode": "chat",
        "source": "https://cloud.sambanova.ai/plans/pricing",
    },
    "sambanova/DeepSeek-V3-0324": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 32768,
        "input_cost_per_token": 3e-06,
        "output_cost_per_token": 4.5e-06,
        "litellm_provider": "sambanova",
        "mode": "chat",
        "supports_function_calling": True,
        "supports_tool_choice": True,
        "supports_reasoning": True,
        "source": "https://cloud.sambanova.ai/plans/pricing",
    },
    "assemblyai/nano": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00010278,
        "output_cost_per_second": 0.0,
        "litellm_provider": "assemblyai",
    },
    "assemblyai/best": {
        "mode": "audio_transcription",
        "input_cost_per_second": 3.333e-05,
        "output_cost_per_second": 0.0,
        "litellm_provider": "assemblyai",
    },
    "jina-reranker-v2-base-multilingual": {
        "max_tokens": 1024,
        "max_input_tokens": 1024,
        "max_output_tokens": 1024,
        "max_document_chunks_per_query": 2048,
        "input_cost_per_token": 1.8e-08,
        "output_cost_per_token": 1.8e-08,
        "litellm_provider": "jina_ai",
        "mode": "rerank",
    },
    "snowflake/deepseek-r1": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "supports_reasoning": True,
        "mode": "chat",
    },
    "snowflake/snowflake-arctic": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "snowflake/claude-3-5-sonnet": {
        "supports_computer_use": True,
        "max_tokens": 18000,
        "max_input_tokens": 18000,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "snowflake/mistral-large": {
        "max_tokens": 32000,
        "max_input_tokens": 32000,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "snowflake/mistral-large2": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "snowflake/reka-flash": {
        "max_tokens": 100000,
        "max_input_tokens": 100000,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "snowflake/reka-core": {
        "max_tokens": 32000,
        "max_input_tokens": 32000,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "snowflake/jamba-instruct": {
        "max_tokens": 256000,
        "max_input_tokens": 256000,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "snowflake/jamba-1.5-mini": {
        "max_tokens": 256000,
        "max_input_tokens": 256000,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "snowflake/jamba-1.5-large": {
        "max_tokens": 256000,
        "max_input_tokens": 256000,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "snowflake/mixtral-8x7b": {
        "max_tokens": 32000,
        "max_input_tokens": 32000,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "snowflake/llama2-70b-chat": {
        "max_tokens": 4096,
        "max_input_tokens": 4096,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "snowflake/llama3-8b": {
        "max_tokens": 8000,
        "max_input_tokens": 8000,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "snowflake/llama3-70b": {
        "max_tokens": 8000,
        "max_input_tokens": 8000,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "snowflake/llama3.1-8b": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "snowflake/llama3.1-70b": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "snowflake/llama3.3-70b": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "snowflake/snowflake-llama-3.3-70b": {
        "max_tokens": 8000,
        "max_input_tokens": 8000,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "snowflake/llama3.1-405b": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "snowflake/snowflake-llama-3.1-405b": {
        "max_tokens": 8000,
        "max_input_tokens": 8000,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "snowflake/llama3.2-1b": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "snowflake/llama3.2-3b": {
        "max_tokens": 128000,
        "max_input_tokens": 128000,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "snowflake/mistral-7b": {
        "max_tokens": 32000,
        "max_input_tokens": 32000,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "snowflake/gemma-7b": {
        "max_tokens": 8000,
        "max_input_tokens": 8000,
        "max_output_tokens": 8192,
        "litellm_provider": "snowflake",
        "mode": "chat",
    },
    "nscale/meta-llama/Llama-4-Scout-17B-16E-Instruct": {
        "input_cost_per_token": 9e-08,
        "output_cost_per_token": 2.9e-07,
        "litellm_provider": "nscale",
        "mode": "chat",
        "source": "https://docs.nscale.com/docs/inference/serverless-models/current#chat-models",
    },
    "nscale/Qwen/Qwen2.5-Coder-3B-Instruct": {
        "input_cost_per_token": 1e-08,
        "output_cost_per_token": 3e-08,
        "litellm_provider": "nscale",
        "mode": "chat",
        "source": "https://docs.nscale.com/docs/inference/serverless-models/current#chat-models",
    },
    "nscale/Qwen/Qwen2.5-Coder-7B-Instruct": {
        "input_cost_per_token": 1e-08,
        "output_cost_per_token": 3e-08,
        "litellm_provider": "nscale",
        "mode": "chat",
        "source": "https://docs.nscale.com/docs/inference/serverless-models/current#chat-models",
    },
    "nscale/Qwen/Qwen2.5-Coder-32B-Instruct": {
        "input_cost_per_token": 6e-08,
        "output_cost_per_token": 2e-07,
        "litellm_provider": "nscale",
        "mode": "chat",
        "source": "https://docs.nscale.com/docs/inference/serverless-models/current#chat-models",
    },
    "nscale/Qwen/QwQ-32B": {
        "input_cost_per_token": 1.8e-07,
        "output_cost_per_token": 2e-07,
        "litellm_provider": "nscale",
        "mode": "chat",
        "source": "https://docs.nscale.com/docs/inference/serverless-models/current#chat-models",
    },
    "nscale/deepseek-ai/DeepSeek-R1-Distill-Llama-70B": {
        "input_cost_per_token": 3.75e-07,
        "output_cost_per_token": 3.75e-07,
        "litellm_provider": "nscale",
        "mode": "chat",
        "source": "https://docs.nscale.com/docs/inference/serverless-models/current#chat-models",
        "metadata": {
            "notes": "Pricing listed as $0.75/1M tokens total. Assumed 50/50 split for input/output."
        },
    },
    "nscale/deepseek-ai/DeepSeek-R1-Distill-Llama-8B": {
        "input_cost_per_token": 2.5e-08,
        "output_cost_per_token": 2.5e-08,
        "litellm_provider": "nscale",
        "mode": "chat",
        "source": "https://docs.nscale.com/docs/inference/serverless-models/current#chat-models",
        "metadata": {
            "notes": "Pricing listed as $0.05/1M tokens total. Assumed 50/50 split for input/output."
        },
    },
    "nscale/deepseek-ai/DeepSeek-R1-Distill-Qwen-1.5B": {
        "input_cost_per_token": 9e-08,
        "output_cost_per_token": 9e-08,
        "litellm_provider": "nscale",
        "mode": "chat",
        "source": "https://docs.nscale.com/docs/inference/serverless-models/current#chat-models",
        "metadata": {
            "notes": "Pricing listed as $0.18/1M tokens total. Assumed 50/50 split for input/output."
        },
    },
    "nscale/deepseek-ai/DeepSeek-R1-Distill-Qwen-7B": {
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 2e-07,
        "litellm_provider": "nscale",
        "mode": "chat",
        "source": "https://docs.nscale.com/docs/inference/serverless-models/current#chat-models",
        "metadata": {
            "notes": "Pricing listed as $0.40/1M tokens total. Assumed 50/50 split for input/output."
        },
    },
    "nscale/deepseek-ai/DeepSeek-R1-Distill-Qwen-14B": {
        "input_cost_per_token": 7e-08,
        "output_cost_per_token": 7e-08,
        "litellm_provider": "nscale",
        "mode": "chat",
        "source": "https://docs.nscale.com/docs/inference/serverless-models/current#chat-models",
        "metadata": {
            "notes": "Pricing listed as $0.14/1M tokens total. Assumed 50/50 split for input/output."
        },
    },
    "nscale/deepseek-ai/DeepSeek-R1-Distill-Qwen-32B": {
        "input_cost_per_token": 1.5e-07,
        "output_cost_per_token": 1.5e-07,
        "litellm_provider": "nscale",
        "mode": "chat",
        "source": "https://docs.nscale.com/docs/inference/serverless-models/current#chat-models",
        "metadata": {
            "notes": "Pricing listed as $0.30/1M tokens total. Assumed 50/50 split for input/output."
        },
    },
    "nscale/mistralai/mixtral-8x22b-instruct-v0.1": {
        "input_cost_per_token": 6e-07,
        "output_cost_per_token": 6e-07,
        "litellm_provider": "nscale",
        "mode": "chat",
        "source": "https://docs.nscale.com/docs/inference/serverless-models/current#chat-models",
        "metadata": {
            "notes": "Pricing listed as $1.20/1M tokens total. Assumed 50/50 split for input/output."
        },
    },
    "nscale/meta-llama/Llama-3.1-8B-Instruct": {
        "input_cost_per_token": 3e-08,
        "output_cost_per_token": 3e-08,
        "litellm_provider": "nscale",
        "mode": "chat",
        "source": "https://docs.nscale.com/docs/inference/serverless-models/current#chat-models",
        "metadata": {
            "notes": "Pricing listed as $0.06/1M tokens total. Assumed 50/50 split for input/output."
        },
    },
    "nscale/meta-llama/Llama-3.3-70B-Instruct": {
        "input_cost_per_token": 2e-07,
        "output_cost_per_token": 2e-07,
        "litellm_provider": "nscale",
        "mode": "chat",
        "source": "https://docs.nscale.com/docs/inference/serverless-models/current#chat-models",
        "metadata": {
            "notes": "Pricing listed as $0.40/1M tokens total. Assumed 50/50 split for input/output."
        },
    },
    "nscale/black-forest-labs/FLUX.1-schnell": {
        "mode": "image_generation",
        "input_cost_per_pixel": 1.3e-09,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "nscale",
        "supported_endpoints": ["/v1/images/generations"],
        "source": "https://docs.nscale.com/docs/inference/serverless-models/current#image-models",
    },
    "nscale/stabilityai/stable-diffusion-xl-base-1.0": {
        "mode": "image_generation",
        "input_cost_per_pixel": 3e-09,
        "output_cost_per_pixel": 0.0,
        "litellm_provider": "nscale",
        "supported_endpoints": ["/v1/images/generations"],
        "source": "https://docs.nscale.com/docs/inference/serverless-models/current#image-models",
    },
    "featherless_ai/featherless-ai/Qwerky-72B": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 4096,
        "litellm_provider": "featherless_ai",
        "mode": "chat",
    },
    "featherless_ai/featherless-ai/Qwerky-QwQ-32B": {
        "max_tokens": 32768,
        "max_input_tokens": 32768,
        "max_output_tokens": 4096,
        "litellm_provider": "featherless_ai",
        "mode": "chat",
    },
    "deepgram/nova-3": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00007167,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0043,
            "calculation": "$0.0043/60 seconds = $0.00007167 per second",
        },
    },
    "deepgram/nova-3-general": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00007167,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0043,
            "calculation": "$0.0043/60 seconds = $0.00007167 per second",
        },
    },
    "deepgram/nova-3-medical": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00008667,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0052,
            "calculation": "$0.0052/60 seconds = $0.00008667 per second (multilingual)",
        },
    },
    "deepgram/nova-2": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00007167,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0043,
            "calculation": "$0.0043/60 seconds = $0.00007167 per second",
        },
    },
    "deepgram/nova-2-general": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00007167,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0043,
            "calculation": "$0.0043/60 seconds = $0.00007167 per second",
        },
    },
    "deepgram/nova-2-meeting": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00007167,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0043,
            "calculation": "$0.0043/60 seconds = $0.00007167 per second",
        },
    },
    "deepgram/nova-2-phonecall": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00007167,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0043,
            "calculation": "$0.0043/60 seconds = $0.00007167 per second",
        },
    },
    "deepgram/nova-2-voicemail": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00007167,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0043,
            "calculation": "$0.0043/60 seconds = $0.00007167 per second",
        },
    },
    "deepgram/nova-2-finance": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00007167,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0043,
            "calculation": "$0.0043/60 seconds = $0.00007167 per second",
        },
    },
    "deepgram/nova-2-conversationalai": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00007167,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0043,
            "calculation": "$0.0043/60 seconds = $0.00007167 per second",
        },
    },
    "deepgram/nova-2-video": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00007167,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0043,
            "calculation": "$0.0043/60 seconds = $0.00007167 per second",
        },
    },
    "deepgram/nova-2-drivethru": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00007167,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0043,
            "calculation": "$0.0043/60 seconds = $0.00007167 per second",
        },
    },
    "deepgram/nova-2-automotive": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00007167,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0043,
            "calculation": "$0.0043/60 seconds = $0.00007167 per second",
        },
    },
    "deepgram/nova-2-atc": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00007167,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0043,
            "calculation": "$0.0043/60 seconds = $0.00007167 per second",
        },
    },
    "deepgram/nova": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00007167,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0043,
            "calculation": "$0.0043/60 seconds = $0.00007167 per second",
        },
    },
    "deepgram/nova-general": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00007167,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0043,
            "calculation": "$0.0043/60 seconds = $0.00007167 per second",
        },
    },
    "deepgram/nova-phonecall": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00007167,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0043,
            "calculation": "$0.0043/60 seconds = $0.00007167 per second",
        },
    },
    "deepgram/enhanced": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00024167,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0145,
            "calculation": "$0.0145/60 seconds = $0.00024167 per second",
        },
    },
    "deepgram/enhanced-general": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00024167,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0145,
            "calculation": "$0.0145/60 seconds = $0.00024167 per second",
        },
    },
    "deepgram/enhanced-meeting": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00024167,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0145,
            "calculation": "$0.0145/60 seconds = $0.00024167 per second",
        },
    },
    "deepgram/enhanced-phonecall": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00024167,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0145,
            "calculation": "$0.0145/60 seconds = $0.00024167 per second",
        },
    },
    "deepgram/enhanced-finance": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00024167,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0145,
            "calculation": "$0.0145/60 seconds = $0.00024167 per second",
        },
    },
    "deepgram/base": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00020833,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0125,
            "calculation": "$0.0125/60 seconds = $0.00020833 per second",
        },
    },
    "deepgram/base-general": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00020833,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0125,
            "calculation": "$0.0125/60 seconds = $0.00020833 per second",
        },
    },
    "deepgram/base-meeting": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00020833,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0125,
            "calculation": "$0.0125/60 seconds = $0.00020833 per second",
        },
    },
    "deepgram/base-phonecall": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00020833,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0125,
            "calculation": "$0.0125/60 seconds = $0.00020833 per second",
        },
    },
    "deepgram/base-voicemail": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00020833,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0125,
            "calculation": "$0.0125/60 seconds = $0.00020833 per second",
        },
    },
    "deepgram/base-finance": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00020833,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0125,
            "calculation": "$0.0125/60 seconds = $0.00020833 per second",
        },
    },
    "deepgram/base-conversationalai": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00020833,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0125,
            "calculation": "$0.0125/60 seconds = $0.00020833 per second",
        },
    },
    "deepgram/base-video": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.00020833,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "original_pricing_per_minute": 0.0125,
            "calculation": "$0.0125/60 seconds = $0.00020833 per second",
        },
    },
    "deepgram/whisper": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.0001,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "notes": "Deepgram's hosted OpenAI Whisper models - pricing may differ from native Deepgram models"
        },
    },
    "deepgram/whisper-tiny": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.0001,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "notes": "Deepgram's hosted OpenAI Whisper models - pricing may differ from native Deepgram models"
        },
    },
    "deepgram/whisper-base": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.0001,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "notes": "Deepgram's hosted OpenAI Whisper models - pricing may differ from native Deepgram models"
        },
    },
    "deepgram/whisper-small": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.0001,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "notes": "Deepgram's hosted OpenAI Whisper models - pricing may differ from native Deepgram models"
        },
    },
    "deepgram/whisper-medium": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.0001,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "notes": "Deepgram's hosted OpenAI Whisper models - pricing may differ from native Deepgram models"
        },
    },
    "deepgram/whisper-large": {
        "mode": "audio_transcription",
        "input_cost_per_second": 0.0001,
        "output_cost_per_second": 0.0,
        "litellm_provider": "deepgram",
        "supported_endpoints": ["/v1/audio/transcriptions"],
        "source": "https://deepgram.com/pricing",
        "metadata": {
            "notes": "Deepgram's hosted OpenAI Whisper models - pricing may differ from native Deepgram models"
        },
    },
}


def get_token_costs(model: str, provider: str) -> TokenCosts:
    """
    Get token costs for a given model and provider.

    Args:
        model: The model name (e.g., 'gpt-4-turbo')
        provider: The provider name (e.g., 'openai')

    Returns:
        Dict containing input_cost_per_token and output_cost_per_token

    Raises:
        ValueError: If provider or model is not found in pricing configuration
    """
    # Get the path to the pricing JSON file
    pricing_file = (
        Path(__file__).parent.parent
        / "constants"
        / "provider_model_pricing.json"
    )

    # Read and parse the pricing data
    # with open(pricing_file, "r") as f:
    model_pricing = token_costs

    # Try different model key patterns to find pricing data
    model_price = model_pricing.get(model)
    if not model_price:
        model_price = model_pricing.get(f"{provider}/{model}")
        if not model_price:
            model_price = model_pricing.get(f"openrouter/{provider}/{model}")
            if not model_price:
                # Try to find any key containing the model name
                matching_key = next(
                    (key for key in model_pricing.keys() if model in key), None
                )
                if matching_key:
                    model_price = model_pricing[matching_key]
                else:
                    raise ValueError(
                        f"Model '{model}' with provider '{provider}' not found in pricing configuration"
                    )

    result = {
        "input_cost_per_token": float(
            model_price.get("input_cost_per_token", 0.0)
        ),
        "output_cost_per_token": float(
            model_price.get("output_cost_per_token", 0.0)
        ),
    }

    # Add cache-related pricing if available
    if "cache_creation_input_token_cost" in model_price:
        result["cache_creation_input_token_cost"] = float(
            model_price.get("cache_creation_input_token_cost", 0.0)
        )

    if "cache_read_input_token_cost" in model_price:
        result["cache_read_input_token_cost"] = float(
            model_price.get("cache_read_input_token_cost", 0.0)
        )

    return result
