# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Mapping, cast
from typing_extensions import Literal

import httpx

from ..._types import NOT_GIVEN, Body, Query, Headers, NotGiven, FileTypes
from ..._utils import extract_files, maybe_transform, deepcopy_minimal, async_maybe_transform
from ..._compat import cached_property
from ..._resource import SyncAPIResource, AsyncAPIResource
from ..._response import (
    to_raw_response_wrapper,
    to_streamed_response_wrapper,
    async_to_raw_response_wrapper,
    async_to_streamed_response_wrapper,
)
from ..._base_client import make_request_options
from ...types.individuals import document_upload_params
from ...types.individuals.generic_document import GenericDocument
from ...types.individuals.document_response import DocumentResponse

__all__ = ["DocumentsResource", "AsyncDocumentsResource"]


class DocumentsResource(SyncAPIResource):
    @cached_property
    def with_raw_response(self) -> DocumentsResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/dataleonlabs/dataleon-python#accessing-raw-response-data-eg-headers
        """
        return DocumentsResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> DocumentsResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/dataleonlabs/dataleon-python#with_streaming_response
        """
        return DocumentsResourceWithStreamingResponse(self)

    def list(
        self,
        individual_id: str,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> DocumentResponse:
        """
        Get documents to an individuals

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not individual_id:
            raise ValueError(f"Expected a non-empty value for `individual_id` but received {individual_id!r}")
        return self._get(
            f"/individuals/{individual_id}/documents",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=DocumentResponse,
        )

    def upload(
        self,
        individual_id: str,
        *,
        document_type: Literal[
            "liasse_fiscale",
            "amortised_loan_schedule",
            "invoice",
            "receipt",
            "company_statuts",
            "registration_company_certificate",
            "kbis",
            "rib",
            "livret_famille",
            "birth_certificate",
            "payslip",
            "social_security_card",
            "vehicle_registration_certificate",
            "carte_grise",
            "criminal_record_extract",
            "proof_of_address",
            "identity_card_front",
            "identity_card_back",
            "driver_license_front",
            "driver_license_back",
            "identity_document",
            "driver_license",
            "passport",
            "tax",
            "certificate_of_incorporation",
            "certificate_of_good_standing",
            "lcb_ft_lab_aml_policies",
            "niu_entreprise",
            "financial_statements",
            "rccm",
            "proof_of_source_funds",
            "organizational_chart",
            "risk_policies",
        ],
        file: FileTypes | NotGiven = NOT_GIVEN,
        url: str | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> GenericDocument:
        """
        Upload documents to an individual

        Args:
          document_type: Filter by document type for upload (must be one of the allowed values)

          file: File to upload (required)

          url: URL of the file to upload (either `file` or `url` is required)

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not individual_id:
            raise ValueError(f"Expected a non-empty value for `individual_id` but received {individual_id!r}")
        body = deepcopy_minimal(
            {
                "document_type": document_type,
                "file": file,
                "url": url,
            }
        )
        files = extract_files(cast(Mapping[str, object], body), paths=[["file"]])
        # It should be noted that the actual Content-Type header that will be
        # sent to the server will contain a `boundary` parameter, e.g.
        # multipart/form-data; boundary=---abc--
        extra_headers = {"Content-Type": "multipart/form-data", **(extra_headers or {})}
        return self._post(
            f"/individuals/{individual_id}/documents",
            body=maybe_transform(body, document_upload_params.DocumentUploadParams),
            files=files,
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=GenericDocument,
        )


class AsyncDocumentsResource(AsyncAPIResource):
    @cached_property
    def with_raw_response(self) -> AsyncDocumentsResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/dataleonlabs/dataleon-python#accessing-raw-response-data-eg-headers
        """
        return AsyncDocumentsResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AsyncDocumentsResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/dataleonlabs/dataleon-python#with_streaming_response
        """
        return AsyncDocumentsResourceWithStreamingResponse(self)

    async def list(
        self,
        individual_id: str,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> DocumentResponse:
        """
        Get documents to an individuals

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not individual_id:
            raise ValueError(f"Expected a non-empty value for `individual_id` but received {individual_id!r}")
        return await self._get(
            f"/individuals/{individual_id}/documents",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=DocumentResponse,
        )

    async def upload(
        self,
        individual_id: str,
        *,
        document_type: Literal[
            "liasse_fiscale",
            "amortised_loan_schedule",
            "invoice",
            "receipt",
            "company_statuts",
            "registration_company_certificate",
            "kbis",
            "rib",
            "livret_famille",
            "birth_certificate",
            "payslip",
            "social_security_card",
            "vehicle_registration_certificate",
            "carte_grise",
            "criminal_record_extract",
            "proof_of_address",
            "identity_card_front",
            "identity_card_back",
            "driver_license_front",
            "driver_license_back",
            "identity_document",
            "driver_license",
            "passport",
            "tax",
            "certificate_of_incorporation",
            "certificate_of_good_standing",
            "lcb_ft_lab_aml_policies",
            "niu_entreprise",
            "financial_statements",
            "rccm",
            "proof_of_source_funds",
            "organizational_chart",
            "risk_policies",
        ],
        file: FileTypes | NotGiven = NOT_GIVEN,
        url: str | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> GenericDocument:
        """
        Upload documents to an individual

        Args:
          document_type: Filter by document type for upload (must be one of the allowed values)

          file: File to upload (required)

          url: URL of the file to upload (either `file` or `url` is required)

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not individual_id:
            raise ValueError(f"Expected a non-empty value for `individual_id` but received {individual_id!r}")
        body = deepcopy_minimal(
            {
                "document_type": document_type,
                "file": file,
                "url": url,
            }
        )
        files = extract_files(cast(Mapping[str, object], body), paths=[["file"]])
        # It should be noted that the actual Content-Type header that will be
        # sent to the server will contain a `boundary` parameter, e.g.
        # multipart/form-data; boundary=---abc--
        extra_headers = {"Content-Type": "multipart/form-data", **(extra_headers or {})}
        return await self._post(
            f"/individuals/{individual_id}/documents",
            body=await async_maybe_transform(body, document_upload_params.DocumentUploadParams),
            files=files,
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=GenericDocument,
        )


class DocumentsResourceWithRawResponse:
    def __init__(self, documents: DocumentsResource) -> None:
        self._documents = documents

        self.list = to_raw_response_wrapper(
            documents.list,
        )
        self.upload = to_raw_response_wrapper(
            documents.upload,
        )


class AsyncDocumentsResourceWithRawResponse:
    def __init__(self, documents: AsyncDocumentsResource) -> None:
        self._documents = documents

        self.list = async_to_raw_response_wrapper(
            documents.list,
        )
        self.upload = async_to_raw_response_wrapper(
            documents.upload,
        )


class DocumentsResourceWithStreamingResponse:
    def __init__(self, documents: DocumentsResource) -> None:
        self._documents = documents

        self.list = to_streamed_response_wrapper(
            documents.list,
        )
        self.upload = to_streamed_response_wrapper(
            documents.upload,
        )


class AsyncDocumentsResourceWithStreamingResponse:
    def __init__(self, documents: AsyncDocumentsResource) -> None:
        self._documents = documents

        self.list = async_to_streamed_response_wrapper(
            documents.list,
        )
        self.upload = async_to_streamed_response_wrapper(
            documents.upload,
        )
