# 🚀 Быстрый старт - VW2PX

## Установка (30 секунд)

```bash
# 1. Установите зависимости
pip3 install -r requirements.txt

# 2. Сделайте скрипт исполняемым (только для Unix/Mac)
chmod +x run_converter.sh
```

## Использование (3 способа)

### Способ 1: Установка через pip (рекомендуется)
```bash
# Установка
pip install vw2px

# Использование
vw2px --path /путь/к/проекту --dry-run
vw2px --path /путь/к/проекту --viewport 1920
```

### Способ 2: Быстрый скрипт
```bash
# Предварительный просмотр
./run_converter.sh /путь/к/проекту

# Выполнение конвертации
./run_converter.sh /путь/к/проекту 1920
```

### Способ 3: Прямой запуск Python
```bash
# Предварительный просмотр
python3 vw2px/converter.py --path /путь/к/проекту --dry-run

# Конвертация с viewport 1440px
python3 vw2px/converter.py --path /путь/к/проекту --viewport 1440
```

## Примеры viewport

| Устройство | Viewport | Команда |
|------------|----------|---------|
| Desktop 4K | 3840px | `--viewport 3840` |
| Desktop Full HD | 1920px | `--viewport 1920` |
| Desktop HD | 1440px | `--viewport 1440` |
| Tablet | 768px | `--viewport 768` |
| Mobile | 375px | `--viewport 375` |

## Безопасность

✅ **Всегда используйте `--dry-run` сначала!**

```bash
# 1. Предварительный просмотр
vw2px --path ./my-project --dry-run

# 2. Если результат устраивает, выполняйте конвертацию
vw2px --path ./my-project
```

## Поддерживаемые файлы

- ✅ JavaScript: `.js`, `.jsx`
- ✅ TypeScript: `.ts`, `.tsx`
- ✅ Vue: `.vue`
- ✅ HTML: `.html`
- ✅ CSS: `.css`, `.scss`, `.sass`, `.less`
- ✅ JSON: `.json`
- ✅ Markdown: `.md`

## Исключения

Автоматически исключаются:
- `node_modules/`
- `.git/`
- `dist/`, `build/`
- `.next/`, `.nuxt/`
- `.vscode/`, `.idea/`

## Пример вывода

```
🚀 VW2PX - Конвертер VW в PX
==================================================
📁 Проект: ./my-project
🖥️  Viewport: 1920px
🔄 Тип конвертации: vw-to-px
🔍 Режим: Предварительный просмотр
==================================================
🔍 Поиск VW значений в проекте: ./my-project
✅ Найдено 15 VW значений
[ПРЕДПРОСМОТР] ./src/Header.vue:25 | 10vw → 192px
[ПРЕДПРОСМОТР] ./src/styles.css:12 | 5.5vw → 105.6px

📋 Предварительный просмотр завершен. Найдено 15 замен в 2 файлах.
```

## Нужна помощь?

- 📖 Полная документация: `README.md`
- 🐛 Проблемы: Проверьте, что Python3 установлен
- 💡 Идеи: Создайте issue в репозитории

---

**Готово! Теперь вы можете конвертировать VW в PX за секунды! 🎉**
