# VW2PX - Конвертер VW в PX

Конвертер размеров из VW в PX для проектов Vue, React, Next.js и других веб-проектов.

## Возможности

- 🔍 Автоматический поиск всех VW значений в проекте
- 🖥️ Конвертация с настраиваемым viewport (1920, 1440, 720, 440 и другие)
- 📁 Поддержка множества форматов файлов (JS, TS, Vue, CSS, SCSS и др.)
- 🔒 Безопасный режим предварительного просмотра
- 📊 Подробная статистика обработки
- 🎨 Цветной вывод в терминале

## Установка

### Через pip (рекомендуется)

```bash
pip install vw2px
```

### Из исходного кода

1. Клонируйте репозиторий или скачайте файлы
2. Установите зависимости:

```bash
pip install -r requirements.txt
```

## Использование

### Базовое использование

```bash
vw2px --path /путь/к/вашему/проекту
```

### С настройкой viewport

```bash
vw2px --path /путь/к/проекту --viewport 1440
```

### Предварительный просмотр (без внесения изменений)

```bash
vw2px --path /путь/к/проекту --dry-run
```

### Полный пример

```bash
vw2px \
  --path ./my-react-project \
  --viewport 1920 \
  --type vw-to-px \
  --dry-run
```

## Параметры

| Параметр | Сокращение | Описание | По умолчанию |
|----------|------------|----------|--------------|
| `--path` | `-p` | Путь к проекту | Обязательный |
| `--viewport` | `-v` | Ширина viewport для конвертации | 1920 |
| `--dry-run` | `-d` | Только предварительный просмотр | False |
| `--type` | `-t` | Тип конвертации (vw-to-px/px-to-vw) | vw-to-px |

## Поддерживаемые форматы файлов

- JavaScript: `.js`, `.jsx`
- TypeScript: `.ts`, `.tsx`
- Vue: `.vue`
- HTML: `.html`
- CSS: `.css`, `.scss`, `.sass`, `.less`, `.styl`
- JSON: `.json`
- Markdown: `.md`
- Текстовые файлы: `.txt`

## Исключаемые директории

Автоматически исключаются следующие директории:
- `node_modules`
- `.git`
- `.next`
- `dist`
- `build`
- `.nuxt`
- `.cache`
- `coverage`
- `.vscode`
- `.idea`

## Примеры конвертации

### VW в PX (viewport 1920px)

| VW | PX |
|----|----|
| 1vw | 19.2px |
| 10vw | 192px |
| 50vw | 960px |
| 100vw | 1920px |

### VW в PX (viewport 1440px)

| VW | PX |
|----|----|
| 1vw | 14.4px |
| 10vw | 144px |
| 50vw | 720px |
| 100vw | 1440px |

## Пример вывода

```
🚀 VW to PX Converter
==================================================
📁 Проект: ./my-project
🖥️  Viewport: 1920px
🔄 Тип конвертации: vw-to-px
🔍 Режим: Предварительный просмотр
==================================================
🔍 Поиск VW значений в проекте: ./my-project
✅ Найдено 15 VW значений
[ПРЕДПРОСМОТР] ./src/components/Header.vue:25 | 10vw → 192px
[ПРЕДПРОСМОТР] ./src/styles/main.css:12 | 5.5vw → 105.6px
[ПРЕДПРОСМОТР] ./src/components/Button.jsx:8 | 2vw → 38.4px

📋 Предварительный просмотр завершен. Найдено 15 замен в 3 файлах.

📊 Статистика:
   📁 Файлов обработано: 0
   🔄 Замен выполнено: 0
   ❌ Ошибок: 0

💡 Для выполнения замен запустите команду без флага --dry-run
```

## Безопасность

- Всегда используйте `--dry-run` для предварительного просмотра
- Создайте резервную копию проекта перед выполнением конвертации
- Программа автоматически исключает системные директории

## Поддерживаемые паттерны

Программа ищет VW значения в следующих форматах:
- `10vw`
- `5.5vw`
- `100vw`
- `0.5vw`

## Ограничения

- Пока поддерживается только конвертация VW в PX
- Конвертация PX в VW будет добавлена в будущих версиях
- Программа не обрабатывает сложные CSS-выражения

## Лицензия

MIT License
