"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CDK8sProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
const provider_kubernetes_1 = require("@cdktf/provider-kubernetes");
const cdktf_1 = require("cdktf");
const yaml = require("yaml");
// TODO: Offer option that base64 encodes the strings and wraps them in btoa
// TODO: Order Terraform Manifests
function wrapLeafStringKeys(object) {
    if (typeof object === "string") {
        return object
            .replace(/\n/g, "\\n") // escape newlines
            .replace(/\${/g, "$$${"); // escape ${ to $${;
    }
    const ret = Object.entries(object).reduce((acc, [key, value]) => {
        if (typeof value === "string") {
            return {
                ...acc,
                [key]: wrapLeafStringKeys(value),
            };
        }
        if (typeof value === "object") {
            if (Array.isArray(value)) {
                return {
                    ...acc,
                    [key]: value.map(wrapLeafStringKeys),
                };
            }
            else {
                return {
                    ...acc,
                    [key]: wrapLeafStringKeys(value),
                };
            }
        }
        return { ...acc, [key]: value };
    }, {});
    return ret;
}
class CDK8sProvider extends provider_kubernetes_1.provider.KubernetesProvider {
    constructor(scope, id, config) {
        super(scope, id, config);
        this.alias = `cdktf-cdk8s-${id}`;
        cdktf_1.Aspects.of(scope).add({
            visit: (node) => {
                // Only run once
                if (node !== this)
                    return;
                const yamlManifests = yaml.parseAllDocuments(config.cdk8sApp.synthYaml());
                yamlManifests.forEach((yamlManifest) => {
                    const jsonManifest = yamlManifest.toJSON();
                    const type = `${jsonManifest.apiVersion}-${jsonManifest.kind}`;
                    const namespace = jsonManifest.metadata.namespace || "default";
                    const uniqueId = `${jsonManifest.metadata.name || jsonManifest.metadata.generateName}-${namespace}`;
                    const manifestContent = wrapLeafStringKeys(jsonManifest);
                    new provider_kubernetes_1.manifest.Manifest(this, `${id}-${type}-${uniqueId}`, {
                        provider: this,
                        manifest: manifestContent,
                    });
                });
            },
        });
    }
}
exports.CDK8sProvider = CDK8sProvider;
_a = JSII_RTTI_SYMBOL_1;
CDK8sProvider[_a] = { fqn: "cdktf-cdk8s.CDK8sProvider", version: "0.10.45" };
//# sourceMappingURL=data:application/json;base64,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