# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetSecureCredentialResult',
    'AwaitableGetSecureCredentialResult',
    'get_secure_credential',
    'get_secure_credential_output',
]

@pulumi.output_type
class GetSecureCredentialResult:
    """
    A collection of values returned by getSecureCredential.
    """
    def __init__(__self__, account_id=None, description=None, id=None, key=None, last_updated=None):
        if account_id and not isinstance(account_id, int):
            raise TypeError("Expected argument 'account_id' to be a int")
        pulumi.set(__self__, "account_id", account_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if last_updated and not isinstance(last_updated, str):
            raise TypeError("Expected argument 'last_updated' to be a str")
        pulumi.set(__self__, "last_updated", last_updated)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> int:
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The secure credential's description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> str:
        """
        The time the secure credential was last updated.
        """
        return pulumi.get(self, "last_updated")


class AwaitableGetSecureCredentialResult(GetSecureCredentialResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecureCredentialResult(
            account_id=self.account_id,
            description=self.description,
            id=self.id,
            key=self.key,
            last_updated=self.last_updated)


def get_secure_credential(account_id: Optional[int] = None,
                          key: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecureCredentialResult:
    """
    Use this data source to get information about a specific Synthetics secure credential in New Relic that already exists.

    Note that the secure credential's value is not returned as an attribute for security reasons.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_newrelic as newrelic

    foo = newrelic.synthetics.get_secure_credential(key="MY_KEY")
    ```


    :param int account_id: The account in New Relic associated with the secure credential. Defaults to the account associated with the API key used.
    :param str key: The secure credential's key name.  Regardless of the case used in the configuration, the provider will provide an upcased key to the underlying API.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['key'] = key
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('newrelic:synthetics/getSecureCredential:getSecureCredential', __args__, opts=opts, typ=GetSecureCredentialResult).value

    return AwaitableGetSecureCredentialResult(
        account_id=__ret__.account_id,
        description=__ret__.description,
        id=__ret__.id,
        key=__ret__.key,
        last_updated=__ret__.last_updated)


@_utilities.lift_output_func(get_secure_credential)
def get_secure_credential_output(account_id: Optional[pulumi.Input[Optional[int]]] = None,
                                 key: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSecureCredentialResult]:
    """
    Use this data source to get information about a specific Synthetics secure credential in New Relic that already exists.

    Note that the secure credential's value is not returned as an attribute for security reasons.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_newrelic as newrelic

    foo = newrelic.synthetics.get_secure_credential(key="MY_KEY")
    ```


    :param int account_id: The account in New Relic associated with the secure credential. Defaults to the account associated with the API key used.
    :param str key: The secure credential's key name.  Regardless of the case used in the configuration, the provider will provide an upcased key to the underlying API.
    """
    ...
