# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScriptMonitorArgs', 'ScriptMonitor']

@pulumi.input_type
class ScriptMonitorArgs:
    def __init__(__self__, *,
                 period: pulumi.Input[str],
                 status: pulumi.Input[str],
                 type: pulumi.Input[str],
                 account_id: Optional[pulumi.Input[int]] = None,
                 device_orientation: Optional[pulumi.Input[str]] = None,
                 device_type: Optional[pulumi.Input[str]] = None,
                 enable_screenshot_on_failure_and_script: Optional[pulumi.Input[bool]] = None,
                 location_privates: Optional[pulumi.Input[Sequence[pulumi.Input['ScriptMonitorLocationPrivateArgs']]]] = None,
                 locations_publics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 runtime_type: Optional[pulumi.Input[str]] = None,
                 runtime_type_version: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input[str]] = None,
                 script_language: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ScriptMonitorTagArgs']]]] = None):
        """
        The set of arguments for constructing a ScriptMonitor resource.
        :param pulumi.Input[str] period: The interval at which this monitor should run. Valid values are EVERY_MINUTE, EVERY_5_MINUTES, EVERY_10_MINUTES, EVERY_15_MINUTES, EVERY_30_MINUTES, EVERY_HOUR, EVERY_6_HOURS, EVERY_12_HOURS, or EVERY_DAY.
        :param pulumi.Input[str] status: The run state of the monitor: `ENABLED` or `DISABLED`
        :param pulumi.Input[str] type: The plaintext representing the monitor script. Valid values are SCRIPT_BROWSER or SCRIPT_API
        :param pulumi.Input[int] account_id: The account in which the Synthetics monitor will be created.
        :param pulumi.Input[str] device_orientation: The device orientation the user would like to represent. Valid values are LANDSCAPE, PORTRAIT, or NONE.
        :param pulumi.Input[str] device_type: The device type that a user can select. Valid values are MOBILE, TABLET, or NONE.
        :param pulumi.Input[bool] enable_screenshot_on_failure_and_script: Capture a screenshot during job execution
        :param pulumi.Input[Sequence[pulumi.Input['ScriptMonitorLocationPrivateArgs']]] location_privates: The location the monitor will run from. See Nested location_private blocks below for details. **At least one of either** `locations_public` **or** `location_private` **is required**.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations_publics: The location the monitor will run from. Check out [this page](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/administration/synthetic-public-minion-ips/) for a list of valid public locations. The `AWS_` prefix is not needed, as the provider uses NerdGraph. **At least one of either** `locations_public` **or** `location_private` **is required**.
        :param pulumi.Input[str] name: The name for the monitor.
        :param pulumi.Input[str] runtime_type: The runtime that the monitor will use to run jobs.
        :param pulumi.Input[str] runtime_type_version: The specific version of the runtime type selected.
        :param pulumi.Input[str] script: The script that the monitor runs.
        :param pulumi.Input[str] script_language: The programing language that should execute the script.
        :param pulumi.Input[Sequence[pulumi.Input['ScriptMonitorTagArgs']]] tags: The tags that will be associated with the monitor. See Nested tag blocks below for details.
               
               The `SCRIPTED_BROWSER` monitor type supports the following additional argument:
        """
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if device_orientation is not None:
            pulumi.set(__self__, "device_orientation", device_orientation)
        if device_type is not None:
            pulumi.set(__self__, "device_type", device_type)
        if enable_screenshot_on_failure_and_script is not None:
            pulumi.set(__self__, "enable_screenshot_on_failure_and_script", enable_screenshot_on_failure_and_script)
        if location_privates is not None:
            pulumi.set(__self__, "location_privates", location_privates)
        if locations_publics is not None:
            pulumi.set(__self__, "locations_publics", locations_publics)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if runtime_type is not None:
            pulumi.set(__self__, "runtime_type", runtime_type)
        if runtime_type_version is not None:
            pulumi.set(__self__, "runtime_type_version", runtime_type_version)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if script_language is not None:
            pulumi.set(__self__, "script_language", script_language)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def period(self) -> pulumi.Input[str]:
        """
        The interval at which this monitor should run. Valid values are EVERY_MINUTE, EVERY_5_MINUTES, EVERY_10_MINUTES, EVERY_15_MINUTES, EVERY_30_MINUTES, EVERY_HOUR, EVERY_6_HOURS, EVERY_12_HOURS, or EVERY_DAY.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: pulumi.Input[str]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        """
        The run state of the monitor: `ENABLED` or `DISABLED`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The plaintext representing the monitor script. Valid values are SCRIPT_BROWSER or SCRIPT_API
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[int]]:
        """
        The account in which the Synthetics monitor will be created.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="deviceOrientation")
    def device_orientation(self) -> Optional[pulumi.Input[str]]:
        """
        The device orientation the user would like to represent. Valid values are LANDSCAPE, PORTRAIT, or NONE.
        """
        return pulumi.get(self, "device_orientation")

    @device_orientation.setter
    def device_orientation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_orientation", value)

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> Optional[pulumi.Input[str]]:
        """
        The device type that a user can select. Valid values are MOBILE, TABLET, or NONE.
        """
        return pulumi.get(self, "device_type")

    @device_type.setter
    def device_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_type", value)

    @property
    @pulumi.getter(name="enableScreenshotOnFailureAndScript")
    def enable_screenshot_on_failure_and_script(self) -> Optional[pulumi.Input[bool]]:
        """
        Capture a screenshot during job execution
        """
        return pulumi.get(self, "enable_screenshot_on_failure_and_script")

    @enable_screenshot_on_failure_and_script.setter
    def enable_screenshot_on_failure_and_script(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_screenshot_on_failure_and_script", value)

    @property
    @pulumi.getter(name="locationPrivates")
    def location_privates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScriptMonitorLocationPrivateArgs']]]]:
        """
        The location the monitor will run from. See Nested location_private blocks below for details. **At least one of either** `locations_public` **or** `location_private` **is required**.
        """
        return pulumi.get(self, "location_privates")

    @location_privates.setter
    def location_privates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScriptMonitorLocationPrivateArgs']]]]):
        pulumi.set(self, "location_privates", value)

    @property
    @pulumi.getter(name="locationsPublics")
    def locations_publics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The location the monitor will run from. Check out [this page](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/administration/synthetic-public-minion-ips/) for a list of valid public locations. The `AWS_` prefix is not needed, as the provider uses NerdGraph. **At least one of either** `locations_public` **or** `location_private` **is required**.
        """
        return pulumi.get(self, "locations_publics")

    @locations_publics.setter
    def locations_publics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "locations_publics", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for the monitor.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="runtimeType")
    def runtime_type(self) -> Optional[pulumi.Input[str]]:
        """
        The runtime that the monitor will use to run jobs.
        """
        return pulumi.get(self, "runtime_type")

    @runtime_type.setter
    def runtime_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_type", value)

    @property
    @pulumi.getter(name="runtimeTypeVersion")
    def runtime_type_version(self) -> Optional[pulumi.Input[str]]:
        """
        The specific version of the runtime type selected.
        """
        return pulumi.get(self, "runtime_type_version")

    @runtime_type_version.setter
    def runtime_type_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_type_version", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input[str]]:
        """
        The script that the monitor runs.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script", value)

    @property
    @pulumi.getter(name="scriptLanguage")
    def script_language(self) -> Optional[pulumi.Input[str]]:
        """
        The programing language that should execute the script.
        """
        return pulumi.get(self, "script_language")

    @script_language.setter
    def script_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_language", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScriptMonitorTagArgs']]]]:
        """
        The tags that will be associated with the monitor. See Nested tag blocks below for details.

        The `SCRIPTED_BROWSER` monitor type supports the following additional argument:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScriptMonitorTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ScriptMonitorState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[int]] = None,
                 device_orientation: Optional[pulumi.Input[str]] = None,
                 device_type: Optional[pulumi.Input[str]] = None,
                 enable_screenshot_on_failure_and_script: Optional[pulumi.Input[bool]] = None,
                 guid: Optional[pulumi.Input[str]] = None,
                 location_privates: Optional[pulumi.Input[Sequence[pulumi.Input['ScriptMonitorLocationPrivateArgs']]]] = None,
                 locations_publics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 period_in_minutes: Optional[pulumi.Input[int]] = None,
                 runtime_type: Optional[pulumi.Input[str]] = None,
                 runtime_type_version: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input[str]] = None,
                 script_language: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ScriptMonitorTagArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ScriptMonitor resources.
        :param pulumi.Input[int] account_id: The account in which the Synthetics monitor will be created.
        :param pulumi.Input[str] device_orientation: The device orientation the user would like to represent. Valid values are LANDSCAPE, PORTRAIT, or NONE.
        :param pulumi.Input[str] device_type: The device type that a user can select. Valid values are MOBILE, TABLET, or NONE.
        :param pulumi.Input[bool] enable_screenshot_on_failure_and_script: Capture a screenshot during job execution
        :param pulumi.Input[str] guid: The unique identifier for the Synthetics private location in New Relic.
        :param pulumi.Input[Sequence[pulumi.Input['ScriptMonitorLocationPrivateArgs']]] location_privates: The location the monitor will run from. See Nested location_private blocks below for details. **At least one of either** `locations_public` **or** `location_private` **is required**.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations_publics: The location the monitor will run from. Check out [this page](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/administration/synthetic-public-minion-ips/) for a list of valid public locations. The `AWS_` prefix is not needed, as the provider uses NerdGraph. **At least one of either** `locations_public` **or** `location_private` **is required**.
        :param pulumi.Input[str] name: The name for the monitor.
        :param pulumi.Input[str] period: The interval at which this monitor should run. Valid values are EVERY_MINUTE, EVERY_5_MINUTES, EVERY_10_MINUTES, EVERY_15_MINUTES, EVERY_30_MINUTES, EVERY_HOUR, EVERY_6_HOURS, EVERY_12_HOURS, or EVERY_DAY.
        :param pulumi.Input[int] period_in_minutes: The interval in minutes at which Synthetic monitor should run.
        :param pulumi.Input[str] runtime_type: The runtime that the monitor will use to run jobs.
        :param pulumi.Input[str] runtime_type_version: The specific version of the runtime type selected.
        :param pulumi.Input[str] script: The script that the monitor runs.
        :param pulumi.Input[str] script_language: The programing language that should execute the script.
        :param pulumi.Input[str] status: The run state of the monitor: `ENABLED` or `DISABLED`
        :param pulumi.Input[Sequence[pulumi.Input['ScriptMonitorTagArgs']]] tags: The tags that will be associated with the monitor. See Nested tag blocks below for details.
               
               The `SCRIPTED_BROWSER` monitor type supports the following additional argument:
        :param pulumi.Input[str] type: The plaintext representing the monitor script. Valid values are SCRIPT_BROWSER or SCRIPT_API
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if device_orientation is not None:
            pulumi.set(__self__, "device_orientation", device_orientation)
        if device_type is not None:
            pulumi.set(__self__, "device_type", device_type)
        if enable_screenshot_on_failure_and_script is not None:
            pulumi.set(__self__, "enable_screenshot_on_failure_and_script", enable_screenshot_on_failure_and_script)
        if guid is not None:
            pulumi.set(__self__, "guid", guid)
        if location_privates is not None:
            pulumi.set(__self__, "location_privates", location_privates)
        if locations_publics is not None:
            pulumi.set(__self__, "locations_publics", locations_publics)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_in_minutes is not None:
            pulumi.set(__self__, "period_in_minutes", period_in_minutes)
        if runtime_type is not None:
            pulumi.set(__self__, "runtime_type", runtime_type)
        if runtime_type_version is not None:
            pulumi.set(__self__, "runtime_type_version", runtime_type_version)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if script_language is not None:
            pulumi.set(__self__, "script_language", script_language)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[int]]:
        """
        The account in which the Synthetics monitor will be created.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="deviceOrientation")
    def device_orientation(self) -> Optional[pulumi.Input[str]]:
        """
        The device orientation the user would like to represent. Valid values are LANDSCAPE, PORTRAIT, or NONE.
        """
        return pulumi.get(self, "device_orientation")

    @device_orientation.setter
    def device_orientation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_orientation", value)

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> Optional[pulumi.Input[str]]:
        """
        The device type that a user can select. Valid values are MOBILE, TABLET, or NONE.
        """
        return pulumi.get(self, "device_type")

    @device_type.setter
    def device_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_type", value)

    @property
    @pulumi.getter(name="enableScreenshotOnFailureAndScript")
    def enable_screenshot_on_failure_and_script(self) -> Optional[pulumi.Input[bool]]:
        """
        Capture a screenshot during job execution
        """
        return pulumi.get(self, "enable_screenshot_on_failure_and_script")

    @enable_screenshot_on_failure_and_script.setter
    def enable_screenshot_on_failure_and_script(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_screenshot_on_failure_and_script", value)

    @property
    @pulumi.getter
    def guid(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier for the Synthetics private location in New Relic.
        """
        return pulumi.get(self, "guid")

    @guid.setter
    def guid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "guid", value)

    @property
    @pulumi.getter(name="locationPrivates")
    def location_privates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScriptMonitorLocationPrivateArgs']]]]:
        """
        The location the monitor will run from. See Nested location_private blocks below for details. **At least one of either** `locations_public` **or** `location_private` **is required**.
        """
        return pulumi.get(self, "location_privates")

    @location_privates.setter
    def location_privates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScriptMonitorLocationPrivateArgs']]]]):
        pulumi.set(self, "location_privates", value)

    @property
    @pulumi.getter(name="locationsPublics")
    def locations_publics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The location the monitor will run from. Check out [this page](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/administration/synthetic-public-minion-ips/) for a list of valid public locations. The `AWS_` prefix is not needed, as the provider uses NerdGraph. **At least one of either** `locations_public` **or** `location_private` **is required**.
        """
        return pulumi.get(self, "locations_publics")

    @locations_publics.setter
    def locations_publics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "locations_publics", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for the monitor.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[str]]:
        """
        The interval at which this monitor should run. Valid values are EVERY_MINUTE, EVERY_5_MINUTES, EVERY_10_MINUTES, EVERY_15_MINUTES, EVERY_30_MINUTES, EVERY_HOUR, EVERY_6_HOURS, EVERY_12_HOURS, or EVERY_DAY.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodInMinutes")
    def period_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The interval in minutes at which Synthetic monitor should run.
        """
        return pulumi.get(self, "period_in_minutes")

    @period_in_minutes.setter
    def period_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period_in_minutes", value)

    @property
    @pulumi.getter(name="runtimeType")
    def runtime_type(self) -> Optional[pulumi.Input[str]]:
        """
        The runtime that the monitor will use to run jobs.
        """
        return pulumi.get(self, "runtime_type")

    @runtime_type.setter
    def runtime_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_type", value)

    @property
    @pulumi.getter(name="runtimeTypeVersion")
    def runtime_type_version(self) -> Optional[pulumi.Input[str]]:
        """
        The specific version of the runtime type selected.
        """
        return pulumi.get(self, "runtime_type_version")

    @runtime_type_version.setter
    def runtime_type_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_type_version", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input[str]]:
        """
        The script that the monitor runs.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script", value)

    @property
    @pulumi.getter(name="scriptLanguage")
    def script_language(self) -> Optional[pulumi.Input[str]]:
        """
        The programing language that should execute the script.
        """
        return pulumi.get(self, "script_language")

    @script_language.setter
    def script_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_language", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The run state of the monitor: `ENABLED` or `DISABLED`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScriptMonitorTagArgs']]]]:
        """
        The tags that will be associated with the monitor. See Nested tag blocks below for details.

        The `SCRIPTED_BROWSER` monitor type supports the following additional argument:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScriptMonitorTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The plaintext representing the monitor script. Valid values are SCRIPT_BROWSER or SCRIPT_API
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class ScriptMonitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[int]] = None,
                 device_orientation: Optional[pulumi.Input[str]] = None,
                 device_type: Optional[pulumi.Input[str]] = None,
                 enable_screenshot_on_failure_and_script: Optional[pulumi.Input[bool]] = None,
                 location_privates: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScriptMonitorLocationPrivateArgs']]]]] = None,
                 locations_publics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 runtime_type: Optional[pulumi.Input[str]] = None,
                 runtime_type_version: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input[str]] = None,
                 script_language: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScriptMonitorTagArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Use this resource to create update, and delete a Script API or Script Browser Synthetics Monitor in New Relic.

        ## Example Usage

        ##### Type: `SCRIPT_API`

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        monitor = newrelic.synthetics.ScriptMonitor("monitor",
            locations_publics=[
                "AP_SOUTH_1",
                "AP_EAST_1",
            ],
            period="EVERY_6_HOURS",
            runtime_type="NODE_API",
            runtime_type_version="16.10",
            script="console.log('it works!')",
            script_language="JAVASCRIPT",
            status="ENABLED",
            tags=[newrelic.synthetics.ScriptMonitorTagArgs(
                key="some_key",
                values=["some_value"],
            )],
            type="SCRIPT_API")
        ```
        ##### Type: `SCRIPT_BROWSER`

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        monitor = newrelic.synthetics.ScriptMonitor("monitor",
            enable_screenshot_on_failure_and_script=False,
            locations_publics=[
                "AP_SOUTH_1",
                "AP_EAST_1",
            ],
            period="EVERY_HOUR",
            runtime_type="CHROME_BROWSER",
            runtime_type_version="100",
            script="$browser.get('https://one.newrelic.com')",
            script_language="JAVASCRIPT",
            status="ENABLED",
            tags=[newrelic.synthetics.ScriptMonitorTagArgs(
                key="some_key",
                values=["some_value"],
            )],
            type="SCRIPT_BROWSER")
        ```
        See additional examples.
        ## Additional Examples

        ### Create a monitor with a private location

        The below example shows how you can define a private location and attach it to a monitor.

        > **NOTE:** It can take up to 10 minutes for a private location to become available.

        ##### Type: `SCRIPT_API`

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        location = newrelic.synthetics.PrivateLocation("location",
            description="Example private location",
            verified_script_execution=True)
        monitor = newrelic.synthetics.ScriptMonitor("monitor",
            status="ENABLED",
            type="SCRIPT_API",
            location_privates=[newrelic.synthetics.ScriptMonitorLocationPrivateArgs(
                guid=location.id,
                vse_password="secret",
            )],
            period="EVERY_6_HOURS",
            script="console.log('terraform integration test updated')",
            script_language="JAVASCRIPT",
            runtime_type="NODE_API",
            runtime_type_version="16.10",
            tags=[newrelic.synthetics.ScriptMonitorTagArgs(
                key="some_key",
                values=["some_value"],
            )])
        ```
        ##### Type: `SCRIPT_BROWSER`

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        location = newrelic.synthetics.PrivateLocation("location",
            description="Test Description",
            verified_script_execution=True)
        monitor = newrelic.synthetics.ScriptMonitor("monitor",
            status="ENABLED",
            type="SCRIPT_BROWSER",
            period="EVERY_HOUR",
            script="$browser.get('https://one.newrelic.com')",
            enable_screenshot_on_failure_and_script=False,
            location_privates=[newrelic.synthetics.ScriptMonitorLocationPrivateArgs(
                guid=location.id,
                vse_password="secret",
            )],
            runtime_type_version="100",
            runtime_type="CHROME_BROWSER",
            script_language="JAVASCRIPT",
            tags=[newrelic.synthetics.ScriptMonitorTagArgs(
                key="some_key",
                values=["some_value"],
            )])
        ```

        ## Import

        Synthetics monitor scripts can be imported using the `guid`, e.g. bash

        ```sh
         $ pulumi import newrelic:synthetics/scriptMonitor:ScriptMonitor monitor <guid>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] account_id: The account in which the Synthetics monitor will be created.
        :param pulumi.Input[str] device_orientation: The device orientation the user would like to represent. Valid values are LANDSCAPE, PORTRAIT, or NONE.
        :param pulumi.Input[str] device_type: The device type that a user can select. Valid values are MOBILE, TABLET, or NONE.
        :param pulumi.Input[bool] enable_screenshot_on_failure_and_script: Capture a screenshot during job execution
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScriptMonitorLocationPrivateArgs']]]] location_privates: The location the monitor will run from. See Nested location_private blocks below for details. **At least one of either** `locations_public` **or** `location_private` **is required**.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations_publics: The location the monitor will run from. Check out [this page](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/administration/synthetic-public-minion-ips/) for a list of valid public locations. The `AWS_` prefix is not needed, as the provider uses NerdGraph. **At least one of either** `locations_public` **or** `location_private` **is required**.
        :param pulumi.Input[str] name: The name for the monitor.
        :param pulumi.Input[str] period: The interval at which this monitor should run. Valid values are EVERY_MINUTE, EVERY_5_MINUTES, EVERY_10_MINUTES, EVERY_15_MINUTES, EVERY_30_MINUTES, EVERY_HOUR, EVERY_6_HOURS, EVERY_12_HOURS, or EVERY_DAY.
        :param pulumi.Input[str] runtime_type: The runtime that the monitor will use to run jobs.
        :param pulumi.Input[str] runtime_type_version: The specific version of the runtime type selected.
        :param pulumi.Input[str] script: The script that the monitor runs.
        :param pulumi.Input[str] script_language: The programing language that should execute the script.
        :param pulumi.Input[str] status: The run state of the monitor: `ENABLED` or `DISABLED`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScriptMonitorTagArgs']]]] tags: The tags that will be associated with the monitor. See Nested tag blocks below for details.
               
               The `SCRIPTED_BROWSER` monitor type supports the following additional argument:
        :param pulumi.Input[str] type: The plaintext representing the monitor script. Valid values are SCRIPT_BROWSER or SCRIPT_API
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScriptMonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to create update, and delete a Script API or Script Browser Synthetics Monitor in New Relic.

        ## Example Usage

        ##### Type: `SCRIPT_API`

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        monitor = newrelic.synthetics.ScriptMonitor("monitor",
            locations_publics=[
                "AP_SOUTH_1",
                "AP_EAST_1",
            ],
            period="EVERY_6_HOURS",
            runtime_type="NODE_API",
            runtime_type_version="16.10",
            script="console.log('it works!')",
            script_language="JAVASCRIPT",
            status="ENABLED",
            tags=[newrelic.synthetics.ScriptMonitorTagArgs(
                key="some_key",
                values=["some_value"],
            )],
            type="SCRIPT_API")
        ```
        ##### Type: `SCRIPT_BROWSER`

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        monitor = newrelic.synthetics.ScriptMonitor("monitor",
            enable_screenshot_on_failure_and_script=False,
            locations_publics=[
                "AP_SOUTH_1",
                "AP_EAST_1",
            ],
            period="EVERY_HOUR",
            runtime_type="CHROME_BROWSER",
            runtime_type_version="100",
            script="$browser.get('https://one.newrelic.com')",
            script_language="JAVASCRIPT",
            status="ENABLED",
            tags=[newrelic.synthetics.ScriptMonitorTagArgs(
                key="some_key",
                values=["some_value"],
            )],
            type="SCRIPT_BROWSER")
        ```
        See additional examples.
        ## Additional Examples

        ### Create a monitor with a private location

        The below example shows how you can define a private location and attach it to a monitor.

        > **NOTE:** It can take up to 10 minutes for a private location to become available.

        ##### Type: `SCRIPT_API`

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        location = newrelic.synthetics.PrivateLocation("location",
            description="Example private location",
            verified_script_execution=True)
        monitor = newrelic.synthetics.ScriptMonitor("monitor",
            status="ENABLED",
            type="SCRIPT_API",
            location_privates=[newrelic.synthetics.ScriptMonitorLocationPrivateArgs(
                guid=location.id,
                vse_password="secret",
            )],
            period="EVERY_6_HOURS",
            script="console.log('terraform integration test updated')",
            script_language="JAVASCRIPT",
            runtime_type="NODE_API",
            runtime_type_version="16.10",
            tags=[newrelic.synthetics.ScriptMonitorTagArgs(
                key="some_key",
                values=["some_value"],
            )])
        ```
        ##### Type: `SCRIPT_BROWSER`

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        location = newrelic.synthetics.PrivateLocation("location",
            description="Test Description",
            verified_script_execution=True)
        monitor = newrelic.synthetics.ScriptMonitor("monitor",
            status="ENABLED",
            type="SCRIPT_BROWSER",
            period="EVERY_HOUR",
            script="$browser.get('https://one.newrelic.com')",
            enable_screenshot_on_failure_and_script=False,
            location_privates=[newrelic.synthetics.ScriptMonitorLocationPrivateArgs(
                guid=location.id,
                vse_password="secret",
            )],
            runtime_type_version="100",
            runtime_type="CHROME_BROWSER",
            script_language="JAVASCRIPT",
            tags=[newrelic.synthetics.ScriptMonitorTagArgs(
                key="some_key",
                values=["some_value"],
            )])
        ```

        ## Import

        Synthetics monitor scripts can be imported using the `guid`, e.g. bash

        ```sh
         $ pulumi import newrelic:synthetics/scriptMonitor:ScriptMonitor monitor <guid>
        ```

        :param str resource_name: The name of the resource.
        :param ScriptMonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScriptMonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[int]] = None,
                 device_orientation: Optional[pulumi.Input[str]] = None,
                 device_type: Optional[pulumi.Input[str]] = None,
                 enable_screenshot_on_failure_and_script: Optional[pulumi.Input[bool]] = None,
                 location_privates: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScriptMonitorLocationPrivateArgs']]]]] = None,
                 locations_publics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 runtime_type: Optional[pulumi.Input[str]] = None,
                 runtime_type_version: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input[str]] = None,
                 script_language: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScriptMonitorTagArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScriptMonitorArgs.__new__(ScriptMonitorArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["device_orientation"] = device_orientation
            __props__.__dict__["device_type"] = device_type
            __props__.__dict__["enable_screenshot_on_failure_and_script"] = enable_screenshot_on_failure_and_script
            __props__.__dict__["location_privates"] = location_privates
            __props__.__dict__["locations_publics"] = locations_publics
            __props__.__dict__["name"] = name
            if period is None and not opts.urn:
                raise TypeError("Missing required property 'period'")
            __props__.__dict__["period"] = period
            __props__.__dict__["runtime_type"] = runtime_type
            __props__.__dict__["runtime_type_version"] = runtime_type_version
            __props__.__dict__["script"] = script
            __props__.__dict__["script_language"] = script_language
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["guid"] = None
            __props__.__dict__["period_in_minutes"] = None
        super(ScriptMonitor, __self__).__init__(
            'newrelic:synthetics/scriptMonitor:ScriptMonitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[int]] = None,
            device_orientation: Optional[pulumi.Input[str]] = None,
            device_type: Optional[pulumi.Input[str]] = None,
            enable_screenshot_on_failure_and_script: Optional[pulumi.Input[bool]] = None,
            guid: Optional[pulumi.Input[str]] = None,
            location_privates: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScriptMonitorLocationPrivateArgs']]]]] = None,
            locations_publics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[str]] = None,
            period_in_minutes: Optional[pulumi.Input[int]] = None,
            runtime_type: Optional[pulumi.Input[str]] = None,
            runtime_type_version: Optional[pulumi.Input[str]] = None,
            script: Optional[pulumi.Input[str]] = None,
            script_language: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScriptMonitorTagArgs']]]]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'ScriptMonitor':
        """
        Get an existing ScriptMonitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] account_id: The account in which the Synthetics monitor will be created.
        :param pulumi.Input[str] device_orientation: The device orientation the user would like to represent. Valid values are LANDSCAPE, PORTRAIT, or NONE.
        :param pulumi.Input[str] device_type: The device type that a user can select. Valid values are MOBILE, TABLET, or NONE.
        :param pulumi.Input[bool] enable_screenshot_on_failure_and_script: Capture a screenshot during job execution
        :param pulumi.Input[str] guid: The unique identifier for the Synthetics private location in New Relic.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScriptMonitorLocationPrivateArgs']]]] location_privates: The location the monitor will run from. See Nested location_private blocks below for details. **At least one of either** `locations_public` **or** `location_private` **is required**.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations_publics: The location the monitor will run from. Check out [this page](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/administration/synthetic-public-minion-ips/) for a list of valid public locations. The `AWS_` prefix is not needed, as the provider uses NerdGraph. **At least one of either** `locations_public` **or** `location_private` **is required**.
        :param pulumi.Input[str] name: The name for the monitor.
        :param pulumi.Input[str] period: The interval at which this monitor should run. Valid values are EVERY_MINUTE, EVERY_5_MINUTES, EVERY_10_MINUTES, EVERY_15_MINUTES, EVERY_30_MINUTES, EVERY_HOUR, EVERY_6_HOURS, EVERY_12_HOURS, or EVERY_DAY.
        :param pulumi.Input[int] period_in_minutes: The interval in minutes at which Synthetic monitor should run.
        :param pulumi.Input[str] runtime_type: The runtime that the monitor will use to run jobs.
        :param pulumi.Input[str] runtime_type_version: The specific version of the runtime type selected.
        :param pulumi.Input[str] script: The script that the monitor runs.
        :param pulumi.Input[str] script_language: The programing language that should execute the script.
        :param pulumi.Input[str] status: The run state of the monitor: `ENABLED` or `DISABLED`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScriptMonitorTagArgs']]]] tags: The tags that will be associated with the monitor. See Nested tag blocks below for details.
               
               The `SCRIPTED_BROWSER` monitor type supports the following additional argument:
        :param pulumi.Input[str] type: The plaintext representing the monitor script. Valid values are SCRIPT_BROWSER or SCRIPT_API
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScriptMonitorState.__new__(_ScriptMonitorState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["device_orientation"] = device_orientation
        __props__.__dict__["device_type"] = device_type
        __props__.__dict__["enable_screenshot_on_failure_and_script"] = enable_screenshot_on_failure_and_script
        __props__.__dict__["guid"] = guid
        __props__.__dict__["location_privates"] = location_privates
        __props__.__dict__["locations_publics"] = locations_publics
        __props__.__dict__["name"] = name
        __props__.__dict__["period"] = period
        __props__.__dict__["period_in_minutes"] = period_in_minutes
        __props__.__dict__["runtime_type"] = runtime_type
        __props__.__dict__["runtime_type_version"] = runtime_type_version
        __props__.__dict__["script"] = script
        __props__.__dict__["script_language"] = script_language
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        return ScriptMonitor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[int]:
        """
        The account in which the Synthetics monitor will be created.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="deviceOrientation")
    def device_orientation(self) -> pulumi.Output[Optional[str]]:
        """
        The device orientation the user would like to represent. Valid values are LANDSCAPE, PORTRAIT, or NONE.
        """
        return pulumi.get(self, "device_orientation")

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> pulumi.Output[Optional[str]]:
        """
        The device type that a user can select. Valid values are MOBILE, TABLET, or NONE.
        """
        return pulumi.get(self, "device_type")

    @property
    @pulumi.getter(name="enableScreenshotOnFailureAndScript")
    def enable_screenshot_on_failure_and_script(self) -> pulumi.Output[Optional[bool]]:
        """
        Capture a screenshot during job execution
        """
        return pulumi.get(self, "enable_screenshot_on_failure_and_script")

    @property
    @pulumi.getter
    def guid(self) -> pulumi.Output[str]:
        """
        The unique identifier for the Synthetics private location in New Relic.
        """
        return pulumi.get(self, "guid")

    @property
    @pulumi.getter(name="locationPrivates")
    def location_privates(self) -> pulumi.Output[Optional[Sequence['outputs.ScriptMonitorLocationPrivate']]]:
        """
        The location the monitor will run from. See Nested location_private blocks below for details. **At least one of either** `locations_public` **or** `location_private` **is required**.
        """
        return pulumi.get(self, "location_privates")

    @property
    @pulumi.getter(name="locationsPublics")
    def locations_publics(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The location the monitor will run from. Check out [this page](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/administration/synthetic-public-minion-ips/) for a list of valid public locations. The `AWS_` prefix is not needed, as the provider uses NerdGraph. **At least one of either** `locations_public` **or** `location_private` **is required**.
        """
        return pulumi.get(self, "locations_publics")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name for the monitor.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[str]:
        """
        The interval at which this monitor should run. Valid values are EVERY_MINUTE, EVERY_5_MINUTES, EVERY_10_MINUTES, EVERY_15_MINUTES, EVERY_30_MINUTES, EVERY_HOUR, EVERY_6_HOURS, EVERY_12_HOURS, or EVERY_DAY.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodInMinutes")
    def period_in_minutes(self) -> pulumi.Output[int]:
        """
        The interval in minutes at which Synthetic monitor should run.
        """
        return pulumi.get(self, "period_in_minutes")

    @property
    @pulumi.getter(name="runtimeType")
    def runtime_type(self) -> pulumi.Output[Optional[str]]:
        """
        The runtime that the monitor will use to run jobs.
        """
        return pulumi.get(self, "runtime_type")

    @property
    @pulumi.getter(name="runtimeTypeVersion")
    def runtime_type_version(self) -> pulumi.Output[Optional[str]]:
        """
        The specific version of the runtime type selected.
        """
        return pulumi.get(self, "runtime_type_version")

    @property
    @pulumi.getter
    def script(self) -> pulumi.Output[Optional[str]]:
        """
        The script that the monitor runs.
        """
        return pulumi.get(self, "script")

    @property
    @pulumi.getter(name="scriptLanguage")
    def script_language(self) -> pulumi.Output[Optional[str]]:
        """
        The programing language that should execute the script.
        """
        return pulumi.get(self, "script_language")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The run state of the monitor: `ENABLED` or `DISABLED`
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.ScriptMonitorTag']]]:
        """
        The tags that will be associated with the monitor. See Nested tag blocks below for details.

        The `SCRIPTED_BROWSER` monitor type supports the following additional argument:
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The plaintext representing the monitor script. Valid values are SCRIPT_BROWSER or SCRIPT_API
        """
        return pulumi.get(self, "type")

