# Opvious Python SDK  [![CI](https://github.com/opvious/sdk.py/actions/workflows/ci.yml/badge.svg)](https://github.com/opvious/sdk.py/actions/workflows/ci.yml) [![Pypi badge](https://badge.fury.io/py/opvious.svg)](https://pypi.python.org/pypi/opvious/)

<div align="center">
  <p>
    Define and deploy optimization models in minutes with <a href="https://www.opvious.io">Opvious</a>.
  </p>
  <a href="https://www.opvious.io/notebooks/retro/notebooks/?path=guides/welcome.ipynb"><img src="https://www.opvious.io/opvious-steps.png" style="height: 600px;"/></a>
    <p>
    <a href="https://www.opvious.io/notebooks/retro/notebooks/?path=guides/welcome.ipynb">Try it out!</a>
  </p>
</div>


## Highlights

+ Declarative modeling API with __extensive static checks and automatic LaTeX generation__
+ Remote solves with __real-time progress notifications__
+ __Flexible data import/export__ via `pandas`
+ __Advanced multi-objective support__: weighted sums, epsilon constraints, ...
+ __Smart debugging capabilities__: semantic constraint relaxations, annotated LP formatting, ...


## Documentation

+ [Getting started guide](https://www.opvious.io/notebooks/retro/notebooks/?path=guides/welcome.ipynb)
+ [SDK API reference](https://opvious.readthedocs.io)
+ [Interactive optimization notebooks](https://github.com/opvious/notebooks)


## Licensing

The SDK is licensed under Apache 2.0. The Opvious platform is available as a self-hosted service, free for small projects. See our [plans page](https://www.opvious.io/plans) for more information.
