# -*- coding: utf-8 -*-
# Generated by Django 1.11.27 on 2020-01-20 15:28
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_countries.fields
import minidebconf.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('schedule', '0010_cleanup_old_data'),
    ]

    operations = [
        migrations.CreateModel(
            name='Registration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateTimeField(auto_now_add=True)),
                ('involvement', models.IntegerField(blank=True, choices=[(0, 'Beginner'), (1, 'User'), (2, 'Contributor'), (4, 'Debian Maintainer (DM)'), (5, 'Debian Developer (DD)')], null=True, verbose_name='Level of involvement with Debian')),
                ('gender', models.CharField(blank=True, choices=[('m', 'Male'), ('f', 'Female'), ('n', 'Non-Binary')], max_length=1, null=True, verbose_name='Gender')),
                ('country', django_countries.fields.CountryField(blank=True, countries=minidebconf.models.Countries, max_length=2, null=True, verbose_name='Country')),
                ('city_state', models.CharField(blank=True, max_length=128, verbose_name='City/State or Province')),
                ('days', models.ManyToManyField(to='schedule.ScheduleBlock', verbose_name='Which days you will attend')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
