# -*- coding: utf-8 -*-
# Generated by Django 1.11.18 on 2019-07-16 12:50
from __future__ import unicode_literals

from django.db import migrations

from register.views import STEPS


def backfill_registration_timestamps(apps, schema_editor):
    last_step = len(STEPS) - 1
    Attendee = apps.get_model('register', 'Attendee')

    for attendee in Attendee.objects.all():
        user = attendee.user
        update = {
            'created_timestamp': user.date_joined,
            'updated_timestamp': user.date_joined,
        }
        if attendee.completed_register_steps == last_step:
            update['completed_timestamp'] = user.date_joined
        # Avoid using .save() so we can set an old updated_timestamp
        Attendee.objects.filter(id=attendee.id).update(**update)


def noop(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('register', '0007_add_registration_timestamps'),
    ]

    operations = [
        migrations.RunPython(backfill_registration_timestamps, noop),
    ]
