# -*- coding: utf-8 -*-
# Generated by Django 1.11.18 on 2019-02-04 19:33
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('schedule', '0007_venue_add_video'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Task',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=1024, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('nbr_volunteers_min', models.IntegerField(blank=True, default=1, null=True)),
                ('nbr_volunteers_max', models.IntegerField(blank=True, default=1, null=True)),
                ('start', models.DateTimeField(blank=True)),
                ('end', models.DateTimeField(blank=True)),
            ],
            options={
                'ordering': ['start', '-end', 'schedule_item', 'template__name', 'name'],
            },
        ),
        migrations.CreateModel(
            name='TaskCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=1024)),
                ('description', models.TextField()),
            ],
            options={
                'verbose_name': 'task category',
                'verbose_name_plural': 'task categories',
            },
        ),
        migrations.CreateModel(
            name='TaskTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=1024, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('nbr_volunteers_min', models.IntegerField(blank=True, default=1, null=True)),
                ('nbr_volunteers_max', models.IntegerField(blank=True, default=1, null=True)),
                ('video_task', models.BooleanField(default=False)),
                ('category', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='volunteers.TaskCategory')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Volunteer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('staff_rating', models.IntegerField(blank=True, choices=[(0, 'No longer welcome'), (1, 'Poor'), (2, 'Not great'), (3, 'Average'), (4, 'Good'), (5, 'Superb')], null=True)),
                ('staff_notes', models.TextField(blank=True, null=True)),
                ('preferred_categories', models.ManyToManyField(blank=True, to='volunteers.TaskCategory')),
                ('preferred_task_types', models.ManyToManyField(blank=True, to='volunteers.TaskTemplate')),
                ('tasks', models.ManyToManyField(blank=True, to='volunteers.Task')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='volunteer', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='task',
            name='category',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='volunteers.TaskCategory'),
        ),
        migrations.AddField(
            model_name='task',
            name='schedule_item',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='schedule.ScheduleItem'),
        ),
        migrations.AddField(
            model_name='task',
            name='template',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='volunteers.TaskTemplate'),
        ),
        migrations.AddField(
            model_name='task',
            name='venue',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='schedule.Venue'),
        ),
        migrations.AddField(
            model_name='task',
            name='volunteers',
            field=models.ManyToManyField(blank=True, to='volunteers.Volunteer'),
        ),
    ]
