from pathlib import Path

from setuptools import find_packages, setup


def get_version() -> str:
    version: dict[str, str] = {}
    with open(Path(__file__).parent / "dagster_ge/version.py", encoding="utf8") as fp:
        exec(fp.read(), version)

    return version["__version__"]


ver = get_version()
# dont pin dev installs to avoid pip dep resolver issues
pin = "" if ver == "1!0+dev" else f"=={ver}"
setup(
    name="dagster-ge",
    version=ver,
    author="Dagster Labs",
    license="Apache-2.0",
    description="Package for GE-specific Dagster framework op and resource components.",
    url="https://github.com/dagster-io/dagster/tree/master/python_modules/libraries/dagster-ge",
    classifiers=[
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "License :: OSI Approved :: Apache Software License",
        "Operating System :: OS Independent",
    ],
    packages=find_packages(exclude=["dagster_ge_tests*"]),
    include_package_data=True,
    python_requires=">=3.10,<3.14",
    install_requires=[
        "dagster==1.11.4",
        "dagster-pandas==0.27.4",
        "pandas",
        "great_expectations>=0.17.15,<1.0.0",  # need to migrate from DataContext
    ],
    extras_require={
        "test": [
            "great-expectations>=0.18.22",  # lower bound to test version for consistent snapshots
        ],
    },
    zip_safe=False,
)
