dtype_dic={
 'SNPID'             : 'string'   ,
 'rsID'              : 'string'   ,
 'CHR'               : 'Int64'    ,
 'POS'               : 'Int64'    ,
 'EA'                : 'category' ,
 'NEA'               : 'category' ,
 'STATUS'            : 'category' ,
 'REF'               : 'category' ,
 'ALT'               : 'category' ,
 'EAF'               : 'float64'  ,
 'NEAF'              : 'float64'  ,
 'MAF'               : 'float64'  ,
 'INFO'              : 'float32'  ,
 'BETA'              : 'float64'  ,
 'SE'                : 'float64'  ,
 'BETA_95U'          : 'float64'  ,
 'BETA_95L'          : 'float64'  ,
 'OR'                : 'float64'  ,
 'OR_95U'            : 'float64'  ,
 'OR_95L'            : 'float64'  ,
 'HR'                : 'float64'  ,
 'HR_95U'            : 'float64'  ,
 'HR_95L'            : 'float64'  ,
 'CHISQ'             : 'float64'  ,
 'Z'                 : 'float64'  ,
 'T'                 : 'float64'  ,
 'F'                 : 'float64'  ,
 'P'                 : 'float64'  ,
 'P_MANTISSA'        : 'float64'  ,
 'P_EXPONENT'        : 'float64'  ,
 'MLOG10P'           : 'float64'  ,
 'SNPR2'             : 'float64'  ,
 'DOF'               : 'Int64'    ,
 'P_HET'             : 'float64'  ,
 'I2'            : 'float64'  ,
 'DENSITY'           : 'Int64'    ,
 'N'                 : 'Int64'    ,
 'N_EFF'             : 'float64'  ,
 'N_CASE'            : 'Int64'    ,
 'N_CONTROL'         : 'Int64'    ,
 'GENENAME'          : 'string'   ,
 'CIS/TRANS'         : 'string'   ,
 'DISTANCE_TO_KNOWN' : 'Int64'    ,
 'LOCATION_OF_KNOWN' : 'string'   ,
 'KNOWN_ID'          : 'string'   ,
 'KNOWN_PUBMED_ID'   : 'string'   ,
 'KNOWN_AUTHOR'      : 'string'   ,
 'KNOWN_SET_VARIANT' : 'string'   ,
 'KNOWN_VARIANT'     : 'string'   ,
 'KNOWN_SET'         : 'string'   ,
 'NOVEL'             : 'string'   ,
 'PIP'               :' float64   ',
 'CREDIBLE_SET_INDEX': 'Int64'    ,
 'N_SNP'             : 'Int64'    ,
 'LOCUS'             : 'string'   ,
 'STUDY'             : 'string'   ,
}


description_dic={
 'SNPID'             :' variant ID (CHR:POS:NEA:EA)                    ',
 'rsID'              :' dbSNP rsID                                     ',
 'CHR'               :' chromosome number (X 23, Y 24, MT 25)          ',
 'POS'               :' base pair position                             ',
 'EA'                :' effect allele                                  ',
 'NEA'               :' non-effect allele                              ',
 'STATUS'            :' variant standardization & harmonization status ',
 'REF'               :' reference allele in reference genome           ',
 'ALT'               :' alternative allele                             ',
 'EAF'               :' effect allele frequency                        ',
 'NEAF'              :' non-effect allele frequency                    ',
 'MAF'               :' minor allele frequency                         ',
 'INFO'              :' imputation INFO/RSQ                            ',
 'BETA'              :' effect size beta                               ',
 'SE'                :' standard error of beta                         ',
 'BETA_95U'          :' upper bound of beta 95% condidence interval    ',
 'BETA_95L'          :' lower bound of beta 95% condidence interval    ',
 'OR'                :' odds ratio                                     ',
 'OR_95U'            :' upper bound of OR 95% condidence interval      ',
 'OR_95L'            :' lower bound of OR 95% condidence interval      ',
 'HR'                :' hazard ratio                                   ',
 'HR_95U'            :' upper bound of HR 95% condidence interval      ',
 'HR_95L'            :' lower bound of HR 95% condidence interval      ',
 'CHISQ'             :' chi square                                     ',
 'Z'                 :' z score                                        ',
 'T'                 :' t statistics                                   ',
 'F'                 :' F statistics                                   ',
 'P'                 :' P value                                        ',
 'P_MANTISSA'        :' P mantissa                                     ',
 'P_EXPONENT'        :' P exponent                                     ',
 'MLOG10P'           :' $-log_{10}(P)$                                 ',
 'SNPR2'             :' per variant R2                                 ',
 'DOF'               :' degree of freedom                              ',
 'P_HET'             :' heterogeneity test P value                     ',
 'I2'            :' heterogeneity I2                               ',
 'DENSITY'           :' signal density                                 ',
 'N'                 :' total sample size                              ',
 'N_EFF'             :' Effective sample size                          ',
 'N_CASE'            :' number of cases                                ',
 'N_CONTROL'         :' number of controls                             ',
 'GENENAME'          :' nearest gene symbol                            ',
 'CIS/TRANS'         :' whether the variant is in cis or trans region  ',
 'DISTANCE_TO_KNOWN' :' distance to nearest known variants             ',
 'LOCATION_OF_KNOWN' :' relative location to nearest known variants    ',
 'KNOWN_ID'          :' nearest known variant ID                       ',
 'KNOWN_PUBMED_ID'   :' pubmed ID of the known variant                 ',
 'KNOWN_AUTHOR'      :' author of the study                            ',
 'KNOWN_SET_VARIANT' :' known set and overlapping variant              ',
 'KNOWN_VARIANT'     :' known variant overlapping with the variant     ',
 'KNOWN_SET'         :' variant set of the known variant               ',
 'PIP'               :' Posterior Inclusion Probability                ',
 'CREDIBLE_SET_INDEX':' credible sets index           ',
 'N_SNP'             :' number of variants included in this locus for finemapping           ',
 'LOCUS'             :' locus name, usually the lead variant of the locus           ',
 'STUDY'             :' study name           '}

def _get_headers(mode="all"):
    if mode=="info":
        return ["SNPID","rsID","CHR","POS","EA","NEA","STATUS"]
    elif mode=="stats":
        return ["BETA","SE","P","MLOG10P",
                "N","N_CASE","N_CONTROL","N_EFF",
                "Z","T","F",
                "OR","OR_95L","OR_95U",
                "HR","HR_95L","HR_95U",
                "MAF","EAF",
                "BETA_95L","BETA_95U",
                "P_HET","I2"]
    else:
        return description_dic.keys()

def _check_overlap_with_reserved_keys(other):
    overlapped=[]
    for i in other:
        if i in _get_headers():
            overlapped.append(i)
    return overlapped


