var schemaString = `<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:lx="lixi.org.au/schema/appinfo_elements" xmlns:li="lixi.org.au/schema/appinfo_instructions" elementFormDefault="qualified" attributeFormDefault="unqualified" version="1.0">
  <xs:annotation>
    <xs:documentation>IMPORTANT: Copyright in this schema is owned by LIXI Limited and use of the schema is controlled by the LIXI End User Licence Agreement (EULA) which can be downloaded from http://www.lixi.org.au. The EULA does not permit you to extend the schema through the addition of new elements or attributes, or modify the content model or any data values in a manner that would be inconsistent with the Standard. However you are permitted to restrict the schema such that it specifies the structures for capturing only the information you wish to receive. This statement in no way limits or modifies the terms of the EULA, and you should ensure that you are familiar with your rights and obligations under the EULA before using the schema.</xs:documentation>
    <xs:documentation>This schema is the LIXI Master Schema WIP for next release. This field gets autopopulated by the process that creates the Transaction Schema from the LIXI Master Schema.</xs:documentation>
    <xs:appinfo>
      <lx:schemadetail type="Master" version="2.2.28" annotation="Full" lifecyclestage="Autopopulated by distribution process" timestamp="Autopopulated by distribution process"/>
      <li:subschema transactiontype="CAL" version="2.6.28"/>
      <li:subschema transactiontype="DAS" version="2.2.28"/>
      <li:subschema transactiontype="CNZ" version="2.1.1"/>
      <li:subschema transactiontype="CDA" version="2.0.26"/>
      <li:subschema transactiontype="SVC" version="2.0.17"/>
      <li:subschema transactiontype="LMI" version="0.0.13"/>
      <li:subschema transactiontype="VAL" version="0.0.13"/>
      <li:subschema transactiontype="ACC" version="0.0.10"/>
    </xs:appinfo>
  </xs:annotation>
  <xs:element name="Package">
    <xs:annotation>
      <xs:documentation>The root element that contains a message for exchange between two end-points involved in the workflow related to the processing of an application for a new financial product or change management of an existing financial product. The message contains instructions to the recipient requesting some workflow activity along with data related to: the applicant and the financial product involved; the publisher; one or more recipients; schema version information; and any related attachments.</xs:documentation>
      <xs:appinfo>
        <lx:path>Package</lx:path>
        <lx:label>Package</lx:label>
        <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,VAL,ACC</li:transactions>
      </xs:appinfo>
    </xs:annotation>
    <xs:complexType>
      <xs:sequence>
        <xs:element name="Attachment" minOccurs="0" maxOccurs="unbounded">
          <xs:annotation>
            <xs:documentation>Contains information about a document that is attached to the application, either by being embedded or by reference to a URL, or both.</xs:documentation>
            <xs:appinfo>
              <lx:path>Package.Attachment</lx:path>
              <lx:label>Attachment</lx:label>
              <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,VAL</li:transactions>
            </xs:appinfo>
          </xs:annotation>
          <xs:complexType>
            <xs:sequence>
              <xs:element name="InlineAttachment" type="base64BinaryType" minOccurs="0" maxOccurs="1">
                <xs:annotation>
                  <xs:documentation>For each attachment, the document itself can be embedded in the XML in a text encoded format.</xs:documentation>
                  <xs:appinfo>
                    <lx:path>Package.Attachment.InlineAttachment</lx:path>
                    <lx:label>Inline Attachment</lx:label>
                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,VAL</li:transactions>
                  </xs:appinfo>
                </xs:annotation>
              </xs:element>
            </xs:sequence>
            <xs:attribute name="Filename" type="stringType" use="optional">
              <xs:annotation>
                <xs:documentation>For each attachment, the name for the attached file, including filename extension may be provided</xs:documentation>
                <xs:appinfo>
                  <lx:path>Package.Attachment.Filename</lx:path>
                  <lx:label>Filename</lx:label>
                  <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,VAL</li:transactions>
                </xs:appinfo>
              </xs:annotation>
            </xs:attribute>
            <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
              <xs:annotation>
                <xs:documentation>System assigned unique identifier</xs:documentation>
                <xs:appinfo>
                  <lx:path>Package.Attachment.UniqueID</lx:path>
                  <lx:label>Unique ID</lx:label>
                  <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,VAL</li:transactions>
                </xs:appinfo>
              </xs:annotation>
            </xs:attribute>
            <xs:attribute name="URI" type="stringType" use="optional">
              <xs:annotation>
                <xs:documentation>For each attachment, the URI that identifies where the attached file might be accessed from. While it is anticipated that it will generally be of the form "http://" or "ftp://", there is no requirement for this to be the case.</xs:documentation>
                <xs:appinfo>
                  <lx:path>Package.Attachment.URI</lx:path>
                  <lx:label>URI</lx:label>
                  <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,VAL</li:transactions>
                </xs:appinfo>
              </xs:annotation>
            </xs:attribute>
          </xs:complexType>
        </xs:element>
        <xs:element name="Content" minOccurs="0" maxOccurs="1">
          <xs:annotation>
            <xs:documentation>Wrapper element for the actual data, the payload of the message</xs:documentation>
            <xs:appinfo>
              <lx:path>Package.Content</lx:path>
              <lx:label>Content</lx:label>
              <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,VAL,ACC</li:transactions>
            </xs:appinfo>
          </xs:annotation>
          <xs:complexType>
            <xs:sequence>
              <xs:element name="Application" minOccurs="0" maxOccurs="1">
                <xs:annotation>
                  <xs:documentation>The set of borrower- and broker-provided data for a single loan application.</xs:documentation>
                  <xs:appinfo>
                    <lx:path>Package.Content.Application</lx:path>
                    <lx:label>Application</lx:label>
                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,VAL,ACC</li:transactions>
                  </xs:appinfo>
                </xs:annotation>
                <xs:complexType>
                  <xs:sequence>
                    <xs:element name="AccountVariation" minOccurs="0" maxOccurs="unbounded">
                      <xs:annotation>
                        <xs:documentation>A request to vary an existing loan account. More than one request can be made on a single account, such as increase limit and add security. Not all requests are compatible, for instance increase limit and decrease limit.</xs:documentation>
                        <xs:appinfo>
                          <lx:path>Package.Content.Application.AccountVariation</lx:path>
                          <lx:label>Account Variation</lx:label>
                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                        </xs:appinfo>
                      </xs:annotation>
                      <xs:complexType>
                        <xs:sequence>
                          <xs:element name="AddBorrower" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A request to add a borrower to an existing loan account</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.AddBorrower</lx:path>
                                <lx:label>Add Borrower</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="x_Borrower" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The specific uniquely identifiable borrower to add to an existing loan account</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.AddBorrower.x_Borrower</lx:path>
                                    <lx:label>Borrower</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.CompanyApplicant</lx:target>
				                              <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                      <lx:target>Package.Content.Application.TrustApplicant</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="AddGuarantee" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A request to add a guarantee to an existing loan account.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.AddGuarantee</lx:path>
                                <lx:label>Add Guarantee</lx:label>
                                <li:transactions>CAL</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="x_LendingGuarantee" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A cross reference to the Lending Guarantee.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.AddGuarantee.x_LendingGuarantee</lx:path>
                                    <lx:label>Lending Guarantee</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.LendingGuarantee</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="AddGuaranteeSecurity" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A request to add a security to an existing lending guarantee.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.AddGuaranteeSecurity</lx:path>
                                <lx:label>Add Guarantee Security</lx:label>
                                <li:transactions>CAL,DAS</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="ActionDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The date that the security is to be added.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.AddGuaranteeSecurity.ActionDate</lx:path>
                                    <lx:label>Action Date</lx:label>
                                    <li:transactions>CAL,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_Security" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The specific uniquely identifiable security to add to an existing lending guarantee.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.AddGuaranteeSecurity.x_Security</lx:path>
                                    <lx:label>Security</lx:label>
                                    <li:transactions>CAL,DAS</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.NonRealEstateAsset</lx:target>
                                      <lx:target>Package.Content.Application.RealEstateAsset</lx:target>
                                      <lx:target>Package.Content.Application.GeneralSecurityAgreement</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="AddGuarantor" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A request to add a guarantor to an existing loan account, generally in conjunction with a limit increase and an additional security</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.AddGuarantor</lx:path>
                                <lx:label>Add Guarantor</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="x_Guarantor" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The specific uniquely identifiable guarantor to add to an existing loan account</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.AddGuarantor.x_Guarantor</lx:path>
                                    <lx:label>Guarantor</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.CompanyApplicant</lx:target>
                                      <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                      <lx:target>Package.Content.Application.TrustApplicant</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="AddSecurity" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A request to add a security to an existing loan account, generally in conjunction with a limit increase</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.AddSecurity</lx:path>
                                <lx:label>Add Security</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="ActionDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The date that the security is to be added.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.AddSecurity.ActionDate</lx:path>
                                    <lx:label>Action Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_Security" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The specific uniquely identifiable security to add to an existing loan account</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.AddSecurity.x_Security</lx:path>
                                    <lx:label>Security</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.NonRealEstateAsset</lx:target>
                                      <lx:target>Package.Content.Application.RealEstateAsset</lx:target>
                                      <lx:target>Package.Content.Application.GeneralSecurityAgreement</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="BalanceIncrease" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A request to increase the balance on an existing loan account.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.BalanceIncrease</lx:path>
                                <lx:label>Balance Increase</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="ActionDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The date on which the balance is to be increased.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.BalanceIncrease.ActionDate</lx:path>
                                    <lx:label>Action Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="IncreaseAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The amount by which the balance is to be increased.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.BalanceIncrease.IncreaseAmount</lx:path>
                                    <lx:label>Increase Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="NewBalance" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The amount to which the balance is to be increased.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.BalanceIncrease.NewBalance</lx:path>
                                    <lx:label>New Balance</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="ChangeLoanTerm" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A request to change the term of the loan, either the fixed term, the total term, or both.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.ChangeLoanTerm</lx:path>
                                <lx:label>Change Loan Term</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="ActionDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Date from which the loan term is to be changed</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.ChangeLoanTerm.ActionDate</lx:path>
                                    <lx:label>Action Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="NewFixedLoanTerm" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The number of months for the new fixed rate term, if the fixed rate term can be changed</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.ChangeLoanTerm.NewFixedLoanTerm</lx:path>
                                    <lx:label>New Fixed Loan Term</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="NewTotalLoanTerm" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The number of months for the total term of the loan, from the action date</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.ChangeLoanTerm.NewTotalLoanTerm</lx:path>
                                    <lx:label>New Total Loan Term</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="ChangeRepaymentAmount" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Request to change the amount of the periodic repayment</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.ChangeRepaymentAmount</lx:path>
                                <lx:label>Change Repayment Amount</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="RepaymentAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The requested periodic repayment amount. It will be up to the lender to determine whether the repayment funds are all applied against the principal or whether some goes into redraw.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.ChangeRepaymentAmount.RepaymentAmount</lx:path>
                                    <lx:label>Repayment Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="ChangeRepaymentFrequency" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Request to change the repayment frequency (e.g. monthly, fortnightly) for the existing account</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.ChangeRepaymentFrequency</lx:path>
                                <lx:label>Change Repayment Frequency</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="RepaymentFrequency" type="frequencyFullList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The requested repayment frequency (e.g. monthly, fortnightly)</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.ChangeRepaymentFrequency.RepaymentFrequency</lx:path>
                                    <lx:label>Repayment Frequency</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="ChangeRepaymentType" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Request to change the repayment type, e.g. interest only, principal and interest</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.ChangeRepaymentType</lx:path>
                                <lx:label>Change Repayment Type</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="RepaymentType" type="paymentTypeList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The requested repayment type, e.g. interest only, principal and interest</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.ChangeRepaymentType.RepaymentType</lx:path>
                                    <lx:label>Repayment Type</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="CloseAccount" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A request to close the existing loan account</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.CloseAccount</lx:path>
                                <lx:label>Close Account</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="DestroyCard" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>If a card is attached to the account, should the card account also be terminated and the card destroyed</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.CloseAccount.DestroyCard</lx:path>
                                    <lx:label>Destroy Card</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PayoutAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>An estimate of the amount required to be transferred to clear the account balance and exit fees</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.CloseAccount.PayoutAmount</lx:path>
                                    <lx:label>Payout Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="InterestRateDiscount" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A request for a discount on the existing loan account interest rate</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.InterestRateDiscount</lx:path>
                                <lx:label>Interest Rate Discount</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="DiscountRate" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The discount being requested, as a delta from the base rate for the product</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.InterestRateDiscount.DiscountRate</lx:path>
                                    <lx:label>Discount Rate</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="LendingGuaranteeLimitDecrease" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A request to reduce the limit on an existing lending guarantee.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.LendingGuaranteeLimitDecrease</lx:path>
                                <lx:label>Lending Guarantee Limit Decrease</lx:label>
                                <li:transactions>CAL</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="DecreaseAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The amount that the lending guarantee limit is to be reduced by.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.LendingGuaranteeLimitDecrease.DecreaseAmount</lx:path>
                                    <lx:label>Decrease Amount</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="NewLimit" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The amount that the lending guarantee limit is to be reduced to.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.LendingGuaranteeLimitDecrease.NewLimit</lx:path>
                                    <lx:label>New Limit</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="LendingGuaranteeLimitIncrease" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A request to increase the limit on an existing lending guarantee.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.LendingGuaranteeLimitIncrease</lx:path>
                                <lx:label>Lending Guarantee Limit Increase</lx:label>
                                <li:transactions>CAL</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="IncreaseAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The amount that the lending guarantee limit is to be increased by.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.LendingGuaranteeLimitIncrease.IncreaseAmount</lx:path>
                                    <lx:label>Increase Amount</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="NewLimit" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The amount that the lending guarantee limit is to be increased to.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.LendingGuaranteeLimitIncrease.NewLimit</lx:path>
                                    <lx:label>New Limit</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="LimitIncrease" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A request to increase the limit on an existing loan account</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.LimitIncrease</lx:path>
                                <lx:label>Limit Increase</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="NewLimitRequestedInForeignCurrency" type="amountInForeignCurrencyType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The amount that the credit limit is to be increased to, as requested in a foreign currency.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.AccountVariation.LimitIncrease.NewLimitRequestedInForeignCurrency</lx:path>
                                      <lx:label>New Limit Requested In Foreign Currency</lx:label>
                                      <li:transactions>CAL</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="ActionDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The date on which the limit is to be increased</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.LimitIncrease.ActionDate</lx:path>
                                    <lx:label>Action Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="IncreaseAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The amount that the credit limit is to be increased by</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.LimitIncrease.IncreaseAmount</lx:path>
                                    <lx:label>Increase Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="IsNewLimitRequestedInForeignCurrency" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A flag to indicate that the new credit limit amount was requested in a foreign currency.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.LimitIncrease.IsNewLimitRequestedInForeignCurrency</lx:path>
                                    <lx:label>Is New Limit Requested In Foreign Currency</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="NewLimit" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The amount that the credit limit is to be increased to</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.LimitIncrease.NewLimit</lx:path>
                                    <lx:label>New Limit</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="ReduceBalance" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A request to reduce the balance on an existing loan account.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.ReduceBalance</lx:path>
                                <lx:label>Reduce Balance</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="ActionDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The date on which the balance is to be reduced.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.ReduceBalance.ActionDate</lx:path>
                                    <lx:label>Action Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="NewBalance" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The amount to which the balance is to be reduced.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.ReduceBalance.NewBalance</lx:path>
                                    <lx:label>New Balance</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="ReductionAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The amount by which the balance is to be decreased.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.ReduceBalance.ReductionAmount</lx:path>
                                    <lx:label>Reduction Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="ReduceLimit" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A request to reduce the limit of an existing loan account</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.ReduceLimit</lx:path>
                                <lx:label>Reduce Limit</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="NewLimitRequestedInForeignCurrency" type="amountInForeignCurrencyType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The amount that the credit limit is to be reduced to, as requested in a foreign currency.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.AccountVariation.ReduceLimit.NewLimitRequestedInForeignCurrency</lx:path>
                                      <lx:label>New Limit Requested In Foreign Currency</lx:label>
                                      <li:transactions>CAL</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="IsNewLimitRequestedInForeignCurrency" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A flag to indicate that the new credit limit amount was requested in a foreign currency.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.ReduceLimit.IsNewLimitRequestedInForeignCurrency</lx:path>
                                    <lx:label>Is New Limit Requested In Foreign Currency</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="LimitReduction" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The amount to reduce the existing account limit by. For example to reduce a $50,000 line of credit to $40,000, the Limit Reduction would be $10,000</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.ReduceLimit.LimitReduction</lx:path>
                                    <lx:label>Limit Reduction</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="NewLimit" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The new (reduced) limit for the loan account</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.ReduceLimit.NewLimit</lx:path>
                                    <lx:label>New Limit</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="ReleaseGuarantee" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A request to release a guarantee from an existing loan account.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.ReleaseGuarantee</lx:path>
                                <lx:label>Release Guarantee</lx:label>
                                <li:transactions>CAL</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="x_LendingGuarantee" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A cross reference to the Lending Guarantee.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.ReleaseGuarantee.x_LendingGuarantee</lx:path>
                                    <lx:label>Lending Guarantee</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.LendingGuarantee</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="ReleaseGuaranteeSecurity" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A request to release a security from an existing lending guarantee.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.ReleaseGuaranteeSecurity</lx:path>
                                <lx:label>Release Guarantee Security</lx:label>
                                <li:transactions>CAL,DAS</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="ActionDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The date that the security is to be released.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.ReleaseGuaranteeSecurity.ActionDate</lx:path>
                                    <lx:label>Action Date</lx:label>
                                    <li:transactions>CAL,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Reason" type="releaseSecurityReasonList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A reason for the request to release the security</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.ReleaseGuaranteeSecurity.Reason</lx:path>
                                    <lx:label>Reason</lx:label>
                                    <li:transactions>CAL,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_Security" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The specific uniquely identifiable security to remove from an existing lending guarantee.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.ReleaseGuaranteeSecurity.x_Security</lx:path>
                                    <lx:label>Security</lx:label>
                                    <li:transactions>CAL,DAS</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.NonRealEstateAsset</lx:target>
                                      <lx:target>Package.Content.Application.RealEstateAsset</lx:target>
                                      <lx:target>Package.Content.Application.GeneralSecurityAgreement</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="ReleaseGuarantor" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A request to release a guarantor from an existing loan account</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.ReleaseGuarantor</lx:path>
                                <lx:label>Release Guarantor</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="x_Guarantor" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The specific uniquely identifiable guarantor to remove from an existing loan account</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.ReleaseGuarantor.x_Guarantor</lx:path>
                                    <lx:label>Guarantor</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.CompanyApplicant</lx:target>
                                      <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                      <lx:target>Package.Content.Application.TrustApplicant</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="ReleaseSecurity" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A request to release a security from an existing loan account</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.ReleaseSecurity</lx:path>
                                <lx:label>Release Security</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="ActionDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The date that the security is to be released.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.ReleaseSecurity.ActionDate</lx:path>
                                    <lx:label>Action Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Reason" type="releaseSecurityReasonList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A reason for the request to release the security</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.ReleaseSecurity.Reason</lx:path>
                                    <lx:label>Reason</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_Security" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The specific uniquely identifiable security to remove from an existing loan account</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.ReleaseSecurity.x_Security</lx:path>
                                    <lx:label>Security</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.NonRealEstateAsset</lx:target>
                                      <lx:target>Package.Content.Application.RealEstateAsset</lx:target>
                                      <lx:target>Package.Content.Application.GeneralSecurityAgreement</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="RemoveBorrower" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A request to remove a borrower from an existing loan account</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.RemoveBorrower</lx:path>
                                <lx:label>Remove Borrower</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="x_Borrower" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The specific uniquely identifiable borrower to remove from an existing loan account</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.RemoveBorrower.x_Borrower</lx:path>
                                    <lx:label>Borrower</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.CompanyApplicant</lx:target>
                                      <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                      <lx:target>Package.Content.Application.TrustApplicant</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="SplitAccount" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Changing a loan from single loan product to two or more products, generally within the same approved limit</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.SplitAccount</lx:path>
                                <lx:label>Split Account</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="Account" minOccurs="0" maxOccurs="unbounded">
                                  <xs:annotation>
                                    <xs:documentation>The set of new account details for each split, including (as required) information such as loan product, loan term, loan amount, etc.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.AccountVariation.SplitAccount.Account</lx:path>
                                      <lx:label>Account</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="x_AccountDetails" type="referenceType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The set of new account details for each split, including (as required) information such as loan product, loan term, loan amount, etc.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.AccountVariation.SplitAccount.Account.x_AccountDetails</lx:path>
                                          <lx:label>Account Details</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                          <lx:references>
                                            <lx:target>Package.Content.Application.LoanDetails</lx:target>
                                          </lx:references>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="ActionDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The date that the account is to be split</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.SplitAccount.ActionDate</lx:path>
                                    <lx:label>Action Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="SwitchProduct" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A request to switch an existing loan account to a new product</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.SwitchProduct</lx:path>
                                <lx:label>Switch Product</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="x_ProductDetails" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The set of loan product details for the new product, including (as required) information such as loan product, repayment type, loan term etc.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.SwitchProduct.x_ProductDetails</lx:path>
                                    <lx:label>Product Details</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.LoanDetails</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="UpdatePartyDetails" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A request to change details, such as contact details, for a party on the account</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.AccountVariation.UpdatePartyDetails</lx:path>
                                <lx:label>Update Party Details</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="x_LoanParty" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The specific uniquely identifiable party whose details are being changed</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.AccountVariation.UpdatePartyDetails.x_LoanParty</lx:path>
                                    <lx:label>Loan Party</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.CompanyApplicant</lx:target>
                                      <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                      <lx:target>Package.Content.Application.TrustApplicant</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                        </xs:sequence>
                        <xs:attribute name="SequenceNumber" type="integerType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The order of this account variation within the sequence.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.AccountVariation.SequenceNumber</lx:path>
                              <lx:label>Sequence Number</lx:label>
                              <li:transactions>CAL,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="Type" type="variationTypeList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Flag to indicate the type of variation being specified</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.AccountVariation.Type</lx:path>
                              <lx:label>Type</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                          <xs:annotation>
                            <xs:documentation>System assigned unique identifier</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.AccountVariation.UniqueID</lx:path>
                              <lx:label>Unique ID</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="VariationDescription" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>A financial institution's specific description that further describes the type of account variation.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.AccountVariation.VariationDescription</lx:path>
                              <lx:label>Variation Description</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="x_AccountToVary" type="referenceType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The existing loan account (i.e. liability) that is being varied.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.AccountVariation.x_AccountToVary</lx:path>
                              <lx:label>Account To Vary</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                              <lx:references>
                                <lx:target>Package.Content.Application.Liability</lx:target>
                              </lx:references>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="x_LendingGuaranteeToVary" type="referenceType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The existing guarantee that is being varied.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.AccountVariation.x_LendingGuaranteeToVary</lx:path>
                              <lx:label>Guarantee To Vary</lx:label>
                              <li:transactions>CAL,DAS</li:transactions>
                              <lx:references>
                                <lx:target>Package.Content.Application.LendingGuarantee</lx:target>
                              </lx:references>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="x_PostVariationAccount" type="referenceType" use="optional">
                          <xs:annotation>
                            <xs:documentation>A cross reference to the loan account after it has been varied (a Loan Details element).</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.AccountVariation.x_PostVariationAccount</lx:path>
                              <lx:label>Post Variation Account</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              <lx:references>
                                <lx:target>Package.Content.Application.LoanDetails</lx:target>
                              </lx:references>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                      </xs:complexType>
                    </xs:element>
                    <xs:element name="Address" type="addressType" minOccurs="0" maxOccurs="unbounded">
                      <xs:annotation>
                        <xs:documentation>Any real or postal address, used by reference</xs:documentation>
                        <xs:appinfo>
                          <lx:path>Package.Content.Application.Address</lx:path>
                          <lx:label>Address</lx:label>
                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,VAL,ACC</li:transactions>
                        </xs:appinfo>
                      </xs:annotation>
                    </xs:element>
                    <xs:element name="BusinessChannel" minOccurs="0" maxOccurs="1">
                      <xs:annotation>
                        <xs:documentation>Captures information about the organisation that the loan application is being submitted to. Typically, the business channel is the lender. For an application being submitted to a mortgage manager, the mortgage manager is the business channel.</xs:documentation>
                        <xs:appinfo>
                          <lx:path>Package.Content.Application.BusinessChannel</lx:path>
                          <lx:label>Business Channel</lx:label>
                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                        </xs:appinfo>
                      </xs:annotation>
                      <xs:complexType>
                        <xs:sequence>
                          <xs:element name="Contact" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Contains contact details for the business channel</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.BusinessChannel.Contact</lx:path>
                                <lx:label>Contact</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="ContactPerson" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Contact person for the business channel.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.BusinessChannel.Contact.ContactPerson</lx:path>
                                      <lx:label>Contact Person</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="Email" type="emailPattern" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The email address of the contact person.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.BusinessChannel.Contact.ContactPerson.Email</lx:path>
                                          <lx:label>Email</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="FirstName" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>A person's first name.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.BusinessChannel.Contact.ContactPerson.FirstName</lx:path>
                                          <lx:label>First Name</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="NameTitle" type="nameTitleList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The name title this person uses when they are formally addressed should be captured.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.BusinessChannel.Contact.ContactPerson.NameTitle</lx:path>
                                          <lx:label>Name Title</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Role" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The role or job position of the contact person in the business channel.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.BusinessChannel.Contact.ContactPerson.Role</lx:path>
                                          <lx:label>Role</lx:label>
                                          <li:transactions>CAL,LMI</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Surname" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>A person's surname.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.BusinessChannel.Contact.ContactPerson.Surname</lx:path>
                                          <lx:label>Surname</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="OfficeFax" type="phoneType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Contains a contact fax number for the business channel.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.BusinessChannel.Contact.OfficeFax</lx:path>
                                      <lx:label>Office Fax</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                                <xs:element name="OfficePhone" type="phoneType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Contains a contact phone number for the business channel.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.BusinessChannel.Contact.OfficePhone</lx:path>
                                      <lx:label>Office Phone</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="Email" type="emailPattern" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures an email address for the distribution channel to which the loan application is being submitted.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.BusinessChannel.Contact.Email</lx:path>
                                    <lx:label>Email</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="WebAddress" type="urlPattern" use="optional">
                                <xs:annotation>
                                  <xs:documentation>An internet address for web content associated with the business channel.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.BusinessChannel.Contact.WebAddress</lx:path>
                                    <lx:label>Web Address</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_Address" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Address should capture the lender's address .</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.BusinessChannel.Contact.x_Address</lx:path>
                                    <lx:label>Address</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.Address</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="CreditAssessor" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>The credit assessor that is associated with this application. The credit assessor works for the lender. They are responsible for evaluating whether the loan application complies with the lender's credit compliance rules. A loan may be assessed by more than one credit assessor.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.BusinessChannel.CreditAssessor</lx:path>
                                <lx:label>Credit Assessor</lx:label>
                                <li:transactions>ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="Contact" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The credit assessor's contact details.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.BusinessChannel.CreditAssessor.Contact</lx:path>
                                      <lx:label>Contact</lx:label>
                                      <li:transactions>ACC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:sequence>
                                      <xs:element name="EmailAddress" minOccurs="0" maxOccurs="unbounded">
                                        <xs:annotation>
                                          <xs:documentation>A contact email address.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.BusinessChannel.CreditAssessor.Contact.EmailAddress</lx:path>
                                            <lx:label>Email Address</lx:label>
                                            <li:transactions>ACC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                        <xs:complexType>
                                          <xs:attribute name="Email" type="emailPattern" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>The email address.</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.BusinessChannel.CreditAssessor.Contact.EmailAddress.Email</lx:path>
                                                <lx:label>Email</lx:label>
                                                <li:transactions>ACC</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                        </xs:complexType>
                                      </xs:element>
                                      <xs:element name="Mobile" type="phoneType" minOccurs="0" maxOccurs="1">
                                        <xs:annotation>
                                          <xs:documentation>A contact mobile phone number.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.BusinessChannel.CreditAssessor.Contact.Mobile</lx:path>
                                            <lx:label>Mobile</lx:label>
                                            <li:transactions>ACC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                      </xs:element>
                                      <xs:element name="OfficePhone" type="phoneType" minOccurs="0" maxOccurs="1">
                                        <xs:annotation>
                                          <xs:documentation>A contact office phone number.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.BusinessChannel.CreditAssessor.Contact.OfficePhone</lx:path>
                                            <lx:label>Office Phone</lx:label>
                                            <li:transactions>ACC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                      </xs:element>
                                    </xs:sequence>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="PersonName" type="personNameType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The name of the credit assessor.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.BusinessChannel.CreditAssessor.PersonName</lx:path>
                                      <lx:label>Person Name</lx:label>
                                      <li:transactions>ACC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="PositionTitle" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The job position title of the credit assessor.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.BusinessChannel.CreditAssessor.PositionTitle</lx:path>
                                    <lx:label>Position Title</lx:label>
                                    <li:transactions>ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>System assigned unique identifier.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.BusinessChannel.CreditAssessor.UniqueID</lx:path>
                                    <lx:label>Unique ID</lx:label>
                                    <li:transactions>ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="CreditManager" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>The credit manager that is associated with this application. The credit manager is a senior credit assessor. They are ultimately responsible for approving the loan based on the lender's credit compliance rules, and the assessments given by the credit assessors.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.BusinessChannel.CreditManager</lx:path>
                                <lx:label>Credit Manager</lx:label>
                                <li:transactions>ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="Contact" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The credit manager's contact details.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.BusinessChannel.CreditManager.Contact</lx:path>
                                      <lx:label>Contact</lx:label>
                                      <li:transactions>ACC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:sequence>
                                      <xs:element name="EmailAddress" minOccurs="0" maxOccurs="unbounded">
                                        <xs:annotation>
                                          <xs:documentation>A contact email address.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.BusinessChannel.CreditManager.Contact.EmailAddress</lx:path>
                                            <lx:label>Email Address</lx:label>
                                            <li:transactions>ACC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                        <xs:complexType>
                                          <xs:attribute name="Email" type="emailPattern" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>The email address.</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.BusinessChannel.CreditManager.Contact.EmailAddress.Email</lx:path>
                                                <lx:label>Email</lx:label>
                                                <li:transactions>ACC</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                        </xs:complexType>
                                      </xs:element>
                                      <xs:element name="Mobile" type="phoneType" minOccurs="0" maxOccurs="1">
                                        <xs:annotation>
                                          <xs:documentation>A contact mobile phone number.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.BusinessChannel.CreditManager.Contact.Mobile</lx:path>
                                            <lx:label>Mobile</lx:label>
                                            <li:transactions>ACC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                      </xs:element>
                                      <xs:element name="OfficePhone" type="phoneType" minOccurs="0" maxOccurs="1">
                                        <xs:annotation>
                                          <xs:documentation>A contact office phone number.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.BusinessChannel.CreditManager.Contact.OfficePhone</lx:path>
                                            <lx:label>Office Phone</lx:label>
                                            <li:transactions>ACC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                      </xs:element>
                                    </xs:sequence>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="PersonName" type="personNameType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The name of the credit manager.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.BusinessChannel.CreditManager.PersonName</lx:path>
                                      <lx:label>Person Name</lx:label>
                                      <li:transactions>ACC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="PositionTitle" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The job position title of the credit manager.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.BusinessChannel.CreditManager.PositionTitle</lx:path>
                                    <lx:label>Position Title</lx:label>
                                    <li:transactions>ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>System assigned unique identifier.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.BusinessChannel.CreditManager.UniqueID</lx:path>
                                    <lx:label>Unique ID</lx:label>
                                    <li:transactions>ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="PanelSolicitor" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Lender's approved panel solicitor</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.BusinessChannel.PanelSolicitor</lx:path>
                                <lx:label>Panel Solicitor</lx:label>
                                <li:transactions>CAL,ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="x_Solicitor" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Solicitor or the company who is approved to act on behalf of the lender. Panel Solicitor associated with the lender for a given loan.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.BusinessChannel.PanelSolicitor.x_Solicitor</lx:path>
                                    <lx:label>Solicitor</lx:label>
                                    <li:transactions>CAL,ACC</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.RelatedPerson</lx:target>
                                      <lx:target>Package.Content.Application.RelatedCompany</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="RelationshipManager" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>The relationship manager that is associated with this application. The relationship manager works for the lender and is responsible for negotiating policy with brokers. The relationship manager negotiates a given loan application with the broker and then passes the loan application to the credit assessment team.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.BusinessChannel.RelationshipManager</lx:path>
                                <lx:label>Relationship Manager</lx:label>
                                <li:transactions>ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="Contact" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The relationship manager contact details.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.BusinessChannel.RelationshipManager.Contact</lx:path>
                                      <lx:label>Contact</lx:label>
                                      <li:transactions>ACC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:sequence>
                                      <xs:element name="EmailAddress" minOccurs="0" maxOccurs="unbounded">
                                        <xs:annotation>
                                          <xs:documentation>A contact email address.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.BusinessChannel.RelationshipManager.Contact.EmailAddress</lx:path>
                                            <lx:label>Email Address</lx:label>
                                            <li:transactions>ACC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                        <xs:complexType>
                                          <xs:attribute name="Email" type="emailPattern" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>The email address.</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.BusinessChannel.RelationshipManager.Contact.EmailAddress.Email</lx:path>
                                                <lx:label>Email</lx:label>
                                                <li:transactions>ACC</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                        </xs:complexType>
                                      </xs:element>
                                      <xs:element name="Mobile" type="phoneType" minOccurs="0" maxOccurs="1">
                                        <xs:annotation>
                                          <xs:documentation>A contact mobile phone number.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.BusinessChannel.RelationshipManager.Contact.Mobile</lx:path>
                                            <lx:label>Mobile</lx:label>
                                            <li:transactions>ACC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                      </xs:element>
                                      <xs:element name="OfficePhone" type="phoneType" minOccurs="0" maxOccurs="1">
                                        <xs:annotation>
                                          <xs:documentation>A contact office phone number.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.BusinessChannel.RelationshipManager.Contact.OfficePhone</lx:path>
                                            <lx:label>Office Phone</lx:label>
                                            <li:transactions>ACC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                      </xs:element>
                                    </xs:sequence>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="PersonName" type="personNameType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The name of the relationship manager.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.BusinessChannel.RelationshipManager.PersonName</lx:path>
                                      <lx:label>Person Name</lx:label>
                                      <li:transactions>ACC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="PositionTitle" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The job position title of the relationship manager.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.BusinessChannel.RelationshipManager.PositionTitle</lx:path>
                                    <lx:label>Position Title</lx:label>
                                    <li:transactions>ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>System assigned unique identifier.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.BusinessChannel.RelationshipManager.UniqueID</lx:path>
                                    <lx:label>Unique ID</lx:label>
                                    <li:transactions>ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="SalesConsultant" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>The sales consultant that is associated with this application.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.BusinessChannel.SalesConsultant</lx:path>
                                <lx:label>Sales Consultant</lx:label>
                                <li:transactions>ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="Contact" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The sales consultant contact details.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.BusinessChannel.SalesConsultant.Contact</lx:path>
                                      <lx:label>Contact</lx:label>
                                      <li:transactions>ACC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:sequence>
                                      <xs:element name="EmailAddress" minOccurs="0" maxOccurs="unbounded">
                                        <xs:annotation>
                                          <xs:documentation>A contact email address.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.BusinessChannel.SalesConsultant.Contact.EmailAddress</lx:path>
                                            <lx:label>Email Address</lx:label>
                                            <li:transactions>ACC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                        <xs:complexType>
                                          <xs:attribute name="Email" type="emailPattern" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>The email address.</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.BusinessChannel.SalesConsultant.Contact.EmailAddress.Email</lx:path>
                                                <lx:label>Email</lx:label>
                                                <li:transactions>ACC</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                        </xs:complexType>
                                      </xs:element>
                                      <xs:element name="Mobile" type="phoneType" minOccurs="0" maxOccurs="1">
                                        <xs:annotation>
                                          <xs:documentation>A contact mobile phone number.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.BusinessChannel.SalesConsultant.Contact.Mobile</lx:path>
                                            <lx:label>Mobile</lx:label>
                                            <li:transactions>ACC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                      </xs:element>
                                      <xs:element name="OfficePhone" type="phoneType" minOccurs="0" maxOccurs="1">
                                        <xs:annotation>
                                          <xs:documentation>A contact office phone number.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.BusinessChannel.SalesConsultant.Contact.OfficePhone</lx:path>
                                            <lx:label>Office Phone</lx:label>
                                            <li:transactions>ACC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                      </xs:element>
                                    </xs:sequence>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="PersonName" type="personNameType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The name of the sales consultant.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.BusinessChannel.SalesConsultant.PersonName</lx:path>
                                      <lx:label>Person Name</lx:label>
                                      <li:transactions>ACC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="PositionTitle" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The job position title of the sales consultant.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.BusinessChannel.SalesConsultant.PositionTitle</lx:path>
                                    <lx:label>Position Title</lx:label>
                                    <li:transactions>ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>System assigned unique identifier.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.BusinessChannel.SalesConsultant.UniqueID</lx:path>
                                    <lx:label>Unique ID</lx:label>
                                    <li:transactions>ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="SettlementSupportManager" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>The settlement support manager that is associated with this application. The settlement support manager is a senior settlement support officer. They are responsible for authorising that the loan application can be submitted to the servicer.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.BusinessChannel.SettlementSupportManager</lx:path>
                                <lx:label>settlement support manager</lx:label>
                                <li:transactions>ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="Contact" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The settlement support manager contact details.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.BusinessChannel.SettlementSupportManager.Contact</lx:path>
                                      <lx:label>Contact</lx:label>
                                      <li:transactions>ACC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:sequence>
                                      <xs:element name="EmailAddress" minOccurs="0" maxOccurs="unbounded">
                                        <xs:annotation>
                                          <xs:documentation>A contact email address.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.BusinessChannel.SettlementSupportManager.Contact.EmailAddress</lx:path>
                                            <lx:label>Email Address</lx:label>
                                            <li:transactions>ACC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                        <xs:complexType>
                                          <xs:attribute name="Email" type="emailPattern" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>The email address.</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.BusinessChannel.SettlementSupportManager.Contact.EmailAddress.Email</lx:path>
                                                <lx:label>Email</lx:label>
                                                <li:transactions>ACC</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                        </xs:complexType>
                                      </xs:element>
                                      <xs:element name="Mobile" type="phoneType" minOccurs="0" maxOccurs="1">
                                        <xs:annotation>
                                          <xs:documentation>A contact mobile phone number.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.BusinessChannel.SettlementSupportManager.Contact.Mobile</lx:path>
                                            <lx:label>Mobile</lx:label>
                                            <li:transactions>ACC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                      </xs:element>
                                      <xs:element name="OfficePhone" type="phoneType" minOccurs="0" maxOccurs="1">
                                        <xs:annotation>
                                          <xs:documentation>A contact office phone number.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.BusinessChannel.SettlementSupportManager.Contact.OfficePhone</lx:path>
                                            <lx:label>Office Phone</lx:label>
                                            <li:transactions>ACC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                      </xs:element>
                                    </xs:sequence>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="PersonName" type="personNameType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The name of the settlement support manager.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.BusinessChannel.SettlementSupportManager.PersonName</lx:path>
                                      <lx:label>Person Name</lx:label>
                                      <li:transactions>ACC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="PositionTitle" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The job position title of the settlement support manager.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.BusinessChannel.SettlementSupportManager.PositionTitle</lx:path>
                                    <lx:label>Position Title</lx:label>
                                    <li:transactions>ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>System assigned unique identifier.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.BusinessChannel.SettlementSupportManager.UniqueID</lx:path>
                                    <lx:label>Unique ID</lx:label>
                                    <li:transactions>ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="SettlementSupportOfficer" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>The settlement support officer that is associated with this application. The settlement support officer works for the lender. They receive a loan application that has been approved by the lender's credit assessment team. They work to ensure that the loan application has all the required paperwork complete and is ready to submit to the servicer.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.BusinessChannel.SettlementSupportOfficer</lx:path>
                                <lx:label>settlement support officer</lx:label>
                                <li:transactions>ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="Contact" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The settlement support officer contact details.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.BusinessChannel.SettlementSupportOfficer.Contact</lx:path>
                                      <lx:label>Contact</lx:label>
                                      <li:transactions>ACC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:sequence>
                                      <xs:element name="EmailAddress" minOccurs="0" maxOccurs="unbounded">
                                        <xs:annotation>
                                          <xs:documentation>A contact email address.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.BusinessChannel.SettlementSupportOfficer.Contact.EmailAddress</lx:path>
                                            <lx:label>Email Address</lx:label>
                                            <li:transactions>ACC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                        <xs:complexType>
                                          <xs:attribute name="Email" type="emailPattern" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>The email address.</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.BusinessChannel.SettlementSupportOfficer.Contact.EmailAddress.Email</lx:path>
                                                <lx:label>Email</lx:label>
                                                <li:transactions>ACC</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                        </xs:complexType>
                                      </xs:element>
                                      <xs:element name="Mobile" type="phoneType" minOccurs="0" maxOccurs="1">
                                        <xs:annotation>
                                          <xs:documentation>A contact mobile phone number.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.BusinessChannel.SettlementSupportOfficer.Contact.Mobile</lx:path>
                                            <lx:label>Mobile</lx:label>
                                            <li:transactions>ACC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                      </xs:element>
                                      <xs:element name="OfficePhone" type="phoneType" minOccurs="0" maxOccurs="1">
                                        <xs:annotation>
                                          <xs:documentation>A contact office phone number.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.BusinessChannel.SettlementSupportOfficer.Contact.OfficePhone</lx:path>
                                            <lx:label>Office Phone</lx:label>
                                            <li:transactions>ACC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                      </xs:element>
                                    </xs:sequence>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="PersonName" type="personNameType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The name of the settlement support officer.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.BusinessChannel.SettlementSupportOfficer.PersonName</lx:path>
                                      <lx:label>Person Name</lx:label>
                                      <li:transactions>ACC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="PositionTitle" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The job position title of the settlement support officer.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.BusinessChannel.SettlementSupportOfficer.PositionTitle</lx:path>
                                    <lx:label>Position Title</lx:label>
                                    <li:transactions>ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>System assigned unique identifier.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.BusinessChannel.SettlementSupportOfficer.UniqueID</lx:path>
                                    <lx:label>Unique ID</lx:label>
                                    <li:transactions>ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                        </xs:sequence>
                        <xs:attribute name="ABN" type="abnPattern" use="optional">
                          <xs:annotation>
                            <xs:documentation>The lender ABN.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.BusinessChannel.ABN</lx:path>
                              <lx:label>ABN</lx:label>
                              <li:transactions>CAL,CDA,DAS,SVC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ACN" type="acnPattern" use="optional">
                          <xs:annotation>
                            <xs:documentation>The lender ACN.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.BusinessChannel.ACN</lx:path>
                              <lx:label>ACN</lx:label>
                              <li:transactions>CAL,CDA,DAS</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="CompanyName" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The company name of the lender or mortgage manager.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.BusinessChannel.CompanyName</lx:path>
                              <lx:label>Company Name</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="LenderID" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures a unique identifier that has been assigned by the lender.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.BusinessChannel.LenderID</lx:path>
                              <lx:label>Lender ID</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="LicenceNumber" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The licence number.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.BusinessChannel.LicenceNumber</lx:path>
                              <lx:label>Licence Number</lx:label>
                              <li:transactions>CAL,CDA,DAS,SVC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="LicenceType" type="licenceTypeList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The type of credit or other licence that the lender operates under.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.BusinessChannel.LicenceType</lx:path>
                              <lx:label>Licence Type</lx:label>
                              <li:transactions>CAL,CDA,DAS,SVC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="NZBN" type="nzbnPattern" use="optional">
                          <xs:annotation>
                            <xs:documentation>The lenders NZBN.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.BusinessChannel.NZBN</lx:path>
                              <lx:label>NZBN</lx:label>
                              <li:transactions>CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="OtherIdentifier" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures an alternative identifier by which the business channel is known, typically issued by the originating organisation rather than the lender.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.BusinessChannel.OtherIdentifier</lx:path>
                              <lx:label>Other Identifier</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="Type" type="businessChannelTypeList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Type of organisation that is the recipient of the application, typically a type of lender.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.BusinessChannel.Type</lx:path>
                              <lx:label>Type</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                          <xs:annotation>
                            <xs:documentation>System assigned unique identifier.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.BusinessChannel.UniqueID</lx:path>
                              <lx:label>Unique ID</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                      </xs:complexType>
                    </xs:element>
                    <xs:element name="CompanyApplicant" minOccurs="0" maxOccurs="unbounded">
                      <xs:annotation>
                        <xs:documentation>Contains applicant details for business enterprises (including company, sole trader, partnership or government department) being either a borrower or a guarantor, and may be acting for a Trust.</xs:documentation>
                        <xs:appinfo>
                          <lx:path>Package.Content.Application.CompanyApplicant</lx:path>
                          <lx:label>Company Applicant</lx:label>
                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,VAL,ACC</li:transactions>
                        </xs:appinfo>
                      </xs:annotation>
                      <xs:complexType>
                        <xs:sequence>
                          <xs:element name="AuthorisedSignatory" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>Contains a reference to an applicant or related party that is an authorised signatory of the company.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CompanyApplicant.AuthorisedSignatory</lx:path>
                                <lx:label>Authorised Signatory</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="PositionTitle" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The position or job title of the person that is a signatory</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.AuthorisedSignatory.PositionTitle</lx:path>
                                    <lx:label>Position Title</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_Signatory" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Contains a reference to an applicant or related party that is an authorised signatory of the company.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.AuthorisedSignatory.x_Signatory</lx:path>
                                    <lx:label>Signatory</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                      <lx:target>Package.Content.Application.RelatedPerson</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="BeneficialOwner" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>A beneficial owner of the company. All beneficial owners of the company should be captured (even persons captured elsewhere as directors, shareholders, beneficiaries etc.)</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CompanyApplicant.BeneficialOwner</lx:path>
                                <lx:label>Beneficial Owner</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="x_BeneficialOwner" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A cross reference to the beneficial owner.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.BeneficialOwner.x_BeneficialOwner</lx:path>
                                    <lx:label>Beneficial Owner</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                      <lx:target>Package.Content.Application.RelatedPerson</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="Business" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Contains information about the business of the company</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CompanyApplicant.Business</lx:path>
                                <lx:label>Business</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="ConcentrationRisk" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The company is at risk because of customer concentration, product concentration, industry concentration, economic-sector concentration, supplier concentration, or finance concentration.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.CompanyApplicant.Business.ConcentrationRisk</lx:path>
                                      <lx:label>Concentration Risk</lx:label>
                                      <li:transactions>CAL</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="ConcentrationRiskDetails" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Details of the concentration risk.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.Business.ConcentrationRisk.ConcentrationRiskDetails</lx:path>
                                          <lx:label>Concentration Risk Details</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="CustomerOrSupplierConcentration" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The company is at risk because it does more than 25 percent of business with one customer or supplier.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.Business.ConcentrationRisk.CustomerOrSupplierConcentration</lx:path>
                                          <lx:label>Customer or Supplier Concentration</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="Diversification" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The diversification of the company with respect to it's suppliers and customers.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.CompanyApplicant.Business.Diversification</lx:path>
                                      <lx:label>Diversification</lx:label>
                                      <li:transactions>CAL</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="Details" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The nature of the diversification of the diversified company.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.Business.Diversification.Details</lx:path>
                                          <lx:label>Details</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="DiversifiedDate" type="dateType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The date when the business diversified.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.Business.Diversification.DiversifiedDate</lx:path>
                                          <lx:label>Diversified Date</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="IsDiversified" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Indicates that the company is a diversified company.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.Business.Diversification.IsDiversified</lx:path>
                                          <lx:label>Is Diversified</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="ImportExport" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Information regarding a company's involvement in import and/or export.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.CompanyApplicant.Business.ImportExport</lx:path>
                                      <lx:label>Import Export</lx:label>
                                      <li:transactions>CAL</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="Details" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Captures a free text description the nature of the involvement in import and/or export.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.Business.ImportExport.Details</lx:path>
                                          <lx:label>Details</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="IsInvolved" type="yesNoIntentList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Indicates if the company is involved in import and/or export, or intends to become involved in import and/or export.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.Business.ImportExport.IsInvolved</lx:path>
                                          <lx:label>Is Involved</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="PropertyInvestment" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Information regarding a company's involvement in property investment.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.CompanyApplicant.Business.PropertyInvestment</lx:path>
                                      <lx:label>Property Investment</lx:label>
                                      <li:transactions>CAL</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="Details" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Captures a free text description the nature of the involvement in property investment.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.Business.PropertyInvestment.Details</lx:path>
                                          <lx:label>Details</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="IsInvolved" type="yesNoIntentList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Indicates if the company is involved in property investment, or intends to become involved in property investment.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.Business.PropertyInvestment.IsInvolved</lx:path>
                                          <lx:label>Is Involved</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="AustralianBIC" type="aubicPattern" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A Business Industry Code.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Business.AustralianBIC</lx:path>
                                    <lx:label>Australian BIC</lx:label>
                                    <li:transactions>CAL,CDA,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="CustomIndustryCode" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>An industry code, from a customised list supported by the lender where the lender requires a code that is not within ANZSIC, BIC or GICS.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Business.CustomIndustryCode</lx:path>
                                    <lx:label>Custom Industry Code</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="FranchiseDetails" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Details of the franchise.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Business.FranchiseDetails</lx:path>
                                    <lx:label>Franchise Details</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="GICSCode" type="gicsCodePattern" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A Global Industry Classification Standard (GICS) code.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Business.GICSCode</lx:path>
                                    <lx:label>GICS Code</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Industry" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures a free text description of the Industry Code.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Business.Industry</lx:path>
                                    <lx:label>Industry</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="IndustryCode" type="anzsicIndustryCodeList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The four digit industry code, from the ANZSIC list of codes. If the nominal code is two or three digits, add '0's to the end to make the four digit code.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Business.IndustryCode</lx:path>
                                    <lx:label>Industry Code</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="IsAFranchise" type="yesNoIntentList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Flag to indicate whether this business is a franchise or has a future intention to become a franchise.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Business.IsAFranchise</lx:path>
                                    <lx:label>Is A Franchise</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="MainBusinessActivity" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The main activity of the business</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Business.MainBusinessActivity</lx:path>
                                    <lx:label>Main Business Activity</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="NewZealandBICCode" type="nzbicPattern" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A Business Industry Classification Code.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Business.NewZealandBICCode</lx:path>
                                    <lx:label>New Zealand BIC Code</lx:label>
                                    <li:transactions>CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="NumberOfEmployees" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The number of employees the company has in the business.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Business.NumberOfEmployees</lx:path>
                                    <lx:label>Number Of Employees</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="NumberOfLocations" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The number of locations where the business operates should be captured.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Business.NumberOfLocations</lx:path>
                                    <lx:label>Number Of Locations</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="OwnPremises" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the company owns the premises from which it operates the business.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Business.OwnPremises</lx:path>
                                    <lx:label>Own Premises</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PrincipalTradingAddressLeaseAgreementDetails" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The details of the Lease Agreement.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Business.PrincipalTradingAddressLeaseAgreementDetails</lx:path>
                                    <lx:label>Principal Trading Address Lease Agreement Details</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PrincipalTradingAddressLeased" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the premises from which the company operates its business is leased.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Business.PrincipalTradingAddressLeased</lx:path>
                                    <lx:label>Principal Trading Address Leased</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="StartDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The date that the company started operating the business described.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Business.StartDate</lx:path>
                                    <lx:label>Business Start Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="Contact" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Contains contact details for the company applicant.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CompanyApplicant.Contact</lx:path>
                                <lx:label>Contact</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,VAL,ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="ContactPerson" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>A contact person at the company</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.CompanyApplicant.Contact.ContactPerson</lx:path>
                                      <lx:label>Contact Person</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ,VAL</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="FirstName" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>A person's first name.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.Contact.ContactPerson.FirstName</lx:path>
                                          <lx:label>First Name</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,VAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="NameTitle" type="nameTitleList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The name title this person uses when they are formally addressed should be captured.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.Contact.ContactPerson.NameTitle</lx:path>
                                          <lx:label>Name Title</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,VAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Role" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The role or job position of the contact person</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.Contact.ContactPerson.Role</lx:path>
                                          <lx:label>Role</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,VAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Surname" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>A person's surname.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.Contact.ContactPerson.Surname</lx:path>
                                          <lx:label>Surname</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,VAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="x_ContactPerson" type="referenceType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>A contact person at the company</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.Contact.ContactPerson.x_ContactPerson</lx:path>
                                          <lx:label>Contact Person</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,VAL</li:transactions>
                                          <lx:references>
                                            <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                            <lx:target>Package.Content.Application.RelatedPerson</lx:target>
                                          </lx:references>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="OfficeFax" type="phoneType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Fax number for the company</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.CompanyApplicant.Contact.OfficeFax</lx:path>
                                      <lx:label>Office Fax</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ,VAL</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                                <xs:element name="OfficeMobile" type="phoneType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Mobile phone number for the company.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.CompanyApplicant.Contact.OfficeMobile</lx:path>
                                      <lx:label>Office Mobile</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ,VAL</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                                <xs:element name="OfficePhone" type="phoneType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Office number for the company</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.CompanyApplicant.Contact.OfficePhone</lx:path>
                                      <lx:label>Office Phone</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ,VAL,ACC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                                <xs:element name="PreviousRegisteredAddressDuration" type="durationType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The duration the company applicant was registered at this address.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.CompanyApplicant.Contact.PreviousRegisteredAddressDuration</lx:path>
                                      <lx:label>Previous Registered Address Duration</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                                <xs:element name="PrincipalTradingAddressDuration" type="durationType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The duration of the company applicant trading at this address.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.CompanyApplicant.Contact.PrincipalTradingAddressDuration</lx:path>
                                      <lx:label>Principal Trading Address Duration</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                                <xs:element name="RegisteredAddressDuration" type="durationType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The duration the company applicant has been registered at this address.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.CompanyApplicant.Contact.RegisteredAddressDuration</lx:path>
                                      <lx:label>Registered Address Duration</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="Email" type="emailPattern" use="optional">
                                <xs:annotation>
                                  <xs:documentation>An email address for the company</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Contact.Email</lx:path>
                                    <lx:label>Email</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,VAL,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PreferredContact" type="preferredContactCompanyList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Specifies the preferred method for contacting this applicant</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Contact.PreferredContact</lx:path>
                                    <lx:label>Preferred Contact</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,VAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PreviousRegisteredAddressEndDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The date the company applicant ended registration at this address.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Contact.PreviousRegisteredAddressEndDate</lx:path>
                                    <lx:label>Previous Registered Address End Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PreviousRegisteredAddressStartDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The date the company applicant registered this address.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Contact.PreviousRegisteredAddressStartDate</lx:path>
                                    <lx:label>Previous Registered Address Start Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PrincipalTradingAddressStartDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The date the company applicant started trading at this address.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Contact.PrincipalTradingAddressStartDate</lx:path>
                                    <lx:label>Principal Trading Address Start Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="RegisteredAddressStartDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The date the company applicant registered at this address.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Contact.RegisteredAddressStartDate</lx:path>
                                    <lx:label>Registered Address Start Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="WebAddress" type="urlPattern" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A URL for the company's public accessible web site.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Contact.WebAddress</lx:path>
                                    <lx:label>Web Address</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,VAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_MailingAddress" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Mailing address of the company</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Contact.x_MailingAddress</lx:path>
                                    <lx:label>Mailing Address</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,VAL,ACC</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.Address</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_PreviousRegisteredAddress" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Previous registered address of the company</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Contact.x_PreviousRegisteredAddress</lx:path>
                                    <lx:label>Previous Registered Address</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,VAL</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.Address</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_PrincipalTradingAddress" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The official address of the company applicant where business is carried out.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Contact.x_PrincipalTradingAddress</lx:path>
                                    <lx:label>Principal Trading Address</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,VAL</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.Address</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_RegisteredAddress" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Registered address of the company</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Contact.x_RegisteredAddress</lx:path>
                                    <lx:label>Registered Address</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,VAL</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.Address</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="CreditHistory" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>Contains details of an applicant's credit history as provided both by credit reference bureaus and/or by the applicant themselves.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CompanyApplicant.CreditHistory</lx:path>
                                <lx:label>Credit History</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="Details" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A comment about the applicant's credit history, possibly in mitigation or explanation of credit issues.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.CreditHistory.Details</lx:path>
                                    <lx:label>Details</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="EndDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The date when the credit issue ended.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.CreditHistory.EndDate</lx:path>
                                    <lx:label>End Date</lx:label>
                                    <li:transactions>ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="IsCurrent" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Flag to indicate whether the credit issue is current. Selecting "No" means the issue described is a past credit issue.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.CreditHistory.IsCurrent</lx:path>
                                    <lx:label>Is Current</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Issue" type="creditHistoryIssueList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Describes the type of Credit Issues the applicant has experienced.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.CreditHistory.Issue</lx:path>
                                    <lx:label>Issue</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="StartDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The date when the credit issue started.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.CreditHistory.StartDate</lx:path>
                                    <lx:label>Start Date</lx:label>
                                    <li:transactions>ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Unique Identifier for this Credit History Element</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.CreditHistory.UniqueID</lx:path>
                                    <lx:label>Unique ID</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="DeclaredIncome" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Wrapper element for the amount of income declared by the applicant. Used for Low Doc applications when full financial years for income are not provided.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CompanyApplicant.DeclaredIncome</lx:path>
                                <lx:label>Declared Income</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="IncomeAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The amount of income declared by the applicant.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.DeclaredIncome.IncomeAmount</lx:path>
                                    <lx:label>Income Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="NetIncomeAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The net amount of income declared by the applicant.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.DeclaredIncome.NetIncomeAmount</lx:path>
                                    <lx:label>Net Income Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="Director" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>Contains a reference to an applicant or related party that is a director of the company.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CompanyApplicant.Director</lx:path>
                                <lx:label>Director</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="x_Director" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Contains a reference to an applicant or related party that is a director of the company.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Director.x_Director</lx:path>
                                    <lx:label>Director</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                      <lx:target>Package.Content.Application.RelatedPerson</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="ExistingCustomer" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Indicates whether the applicant is an existing customer of the lender being applied to.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CompanyApplicant.ExistingCustomer</lx:path>
                                <lx:label>Existing Customer</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="AccountNumber" type="financialAccountType" minOccurs="0" maxOccurs="unbounded">
                                  <xs:annotation>
                                    <xs:documentation>Account details for an account held that identifies the party as an existing customer</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.CompanyApplicant.ExistingCustomer.AccountNumber</lx:path>
                                      <lx:label>Account Number</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="CustomerNumber" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A unique number assigned by the lender used to identify the customer</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.ExistingCustomer.CustomerNumber</lx:path>
                                    <lx:label>Customer Number</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="CustomerSince" type="gYearType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The approximate year that the applicant became a customer</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.ExistingCustomer.CustomerSince</lx:path>
                                    <lx:label>Customer Since</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="CustomerSinceMonth" type="mmMonthList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The month (if known) that the company applicant became a customer (only if the year is also provided in 'CustomerSince').</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.ExistingCustomer.CustomerSinceMonth</lx:path>
                                    <lx:label>Customer Since Month</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="FinancialAnalysis" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Container element for the detailed financial analysis of the company</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CompanyApplicant.FinancialAnalysis</lx:path>
                                <lx:label>Financial Analysis</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="CompanyFinancials" minOccurs="0" maxOccurs="unbounded">
                                  <xs:annotation>
                                    <xs:documentation>Container for the reference to the financial data</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.CompanyApplicant.FinancialAnalysis.CompanyFinancials</lx:path>
                                      <lx:label>Company Financials</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="x_CompanyFinancials" type="referenceType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Reference to the element containing the financial analysis for each financial year, to be provided when Complete Financial Analysis = "Yes"</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.FinancialAnalysis.CompanyFinancials.x_CompanyFinancials</lx:path>
                                          <lx:label>Company Financials</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                          <lx:references>
                                            <lx:target>Package.Content.Application.CompanyFinancials</lx:target>
                                          </lx:references>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="AnnualPaymentOnCommitments" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Total Principle and Interest payments on borrowings due to be paid in the next 12 months</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.FinancialAnalysis.AnnualPaymentOnCommitments</lx:path>
                                    <lx:label>Annual Payment On Commitments</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="CompleteFinancialAnalysis" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Flag to indicate whether a complete financial analysis will be provided electronically, or only a summary view</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.FinancialAnalysis.CompleteFinancialAnalysis</lx:path>
                                    <lx:label>Complete Financial Analysis</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="ForeignTaxAssociation" type="foreignTaxAssociationType" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Wrapper element for Foreign Tax Associations.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CompanyApplicant.ForeignTaxAssociation</lx:path>
                                <lx:label>Foreign Tax Association</lx:label>
                                <li:transactions>CAL,CDA,DAS</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                          </xs:element>
                          <xs:element name="IncomePrevious" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Details of the share of the gross (pre-tax) income or income-related amounts in the previous financial year (immediately preceding the most recent full financial year), attributable to this applicant (for year = current year -2).</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious</lx:path>
                                <lx:label>Income Previous</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="Addback" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Container element for Addback detail</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.Addback</lx:path>
                                      <lx:label>Addback</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:sequence>
                                      <xs:element name="OtherAddback" minOccurs="0" maxOccurs="unbounded">
                                        <xs:annotation>
                                          <xs:documentation>Other addback that cannot otherwise be captured under a specific addback category.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.Addback.OtherAddback</lx:path>
                                            <lx:label>Other Add Back</lx:label>
                                            <li:transactions>CAL,CDA,SVC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                        <xs:complexType>
                                          <xs:attribute name="Amount" type="currencyType" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>Amount that can be an addback to the income.</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.Addback.OtherAddback.Amount</lx:path>
                                                <lx:label>Amount</lx:label>
                                                <li:transactions>CAL,CDA,SVC</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                          <xs:attribute name="Description" type="stringType" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>Decription of the other addback.</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.Addback.OtherAddback.Description</lx:path>
                                                <lx:label>Description</lx:label>
                                                <li:transactions>CAL,CDA,SVC</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                        </xs:complexType>
                                      </xs:element>
                                    </xs:sequence>
                                    <xs:attribute name="Allowances" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Allowances amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.Addback.Allowances</lx:path>
                                          <lx:label>Allowances</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="AmortisationOfGoodwill" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Amortisation Of Goodwill amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.Addback.AmortisationOfGoodwill</lx:path>
                                          <lx:label>Amortisation Of Goodwill</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Bonus" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Bonus amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.Addback.Bonus</lx:path>
                                          <lx:label>Bonus</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="CarExpense" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Car expense amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.Addback.CarExpense</lx:path>
                                          <lx:label>Car Expense</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="CarryForwardLosses" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Carry Forward Losses amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.Addback.CarryForwardLosses</lx:path>
                                          <lx:label>Carry Forward Losses</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Depreciation" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Depreciation amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.Addback.Depreciation</lx:path>
                                          <lx:label>Depreciation</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="HomeOffice" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Home Office amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.Addback.HomeOffice</lx:path>
                                          <lx:label>Home Office</lx:label>
                                          <li:transactions>CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Interest" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Interest amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.Addback.Interest</lx:path>
                                          <lx:label>Interest</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Lease" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Lease amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.Addback.Lease</lx:path>
                                          <lx:label>Lease</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="NonCashBenefits" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Non-cash benefits amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.Addback.NonCashBenefits</lx:path>
                                          <lx:label>Non Cash Benefits</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="NonRecurringExpenses" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Non-recurring expense amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.Addback.NonRecurringExpenses</lx:path>
                                          <lx:label>Non Recurring Expenses</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="PaymentToDirector" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The payment to director that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.Addback.PaymentToDirector</lx:path>
                                          <lx:label>Payment To Director</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Salary" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Salary amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.Addback.Salary</lx:path>
                                          <lx:label>Salary</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="SuperannuationExcess" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Superannuation Excess amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.Addback.SuperannuationExcess</lx:path>
                                          <lx:label>Superannuation Excess</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="CompanyProfitAfterTax" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the company profit after tax for the specified financial year.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.CompanyProfitAfterTax</lx:path>
                                    <lx:label>Company Profit After Tax</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="CompanyProfitBeforeTax" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the company net profit/profit before tax for the specified financial year.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.CompanyProfitBeforeTax</lx:path>
                                    <lx:label>Company Profit Before Tax</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="EndDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The end date for the stated income, generally the end of a financial year</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.EndDate</lx:path>
                                    <lx:label>End Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="IncomeGreaterThanPreviousYear" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>When comparing past Tax Office Assessments, indicate whether the past return has improved on the previous year.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.IncomeGreaterThanPreviousYear</lx:path>
                                    <lx:label>Income Greater Than Previous Year</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="StartDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The start date for the stated income, generally the start of a financial year</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.StartDate</lx:path>
                                    <lx:label>Start Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TaxOfficeAssessments" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Are Tax Office Assessments for at least the past two years available as supporting evidence for this application</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.TaxOfficeAssessments</lx:path>
                                    <lx:label>Tax Office Assessments</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_Accountant" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Link to the company's accountant for the full previous financial year. This should be populated when the accountant for the specified period is different to that declared as the current accountant.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomePrevious.x_Accountant</lx:path>
                                    <lx:label>Accountant</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.RelatedCompany</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="IncomePrior" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Details of the share of the gross (pre-tax) income or income-related amounts in the prior financial year (two years prior to the most recent full financial year), attributable to this applicant (for year = current year -3).</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior</lx:path>
                                <lx:label>Income Prior</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="Addback" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Container element for Addback detail</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.Addback</lx:path>
                                      <lx:label>Addback</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:sequence>
                                      <xs:element name="OtherAddback" minOccurs="0" maxOccurs="unbounded">
                                        <xs:annotation>
                                          <xs:documentation>Other addback that cannot otherwise be captured under a specific addback category.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.Addback.OtherAddback</lx:path>
                                            <lx:label>Other Add Back</lx:label>
                                            <li:transactions>CAL,CDA,SVC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                        <xs:complexType>
                                          <xs:attribute name="Amount" type="currencyType" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>Amount that can be an addback to the income.</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.Addback.OtherAddback.Amount</lx:path>
                                                <lx:label>Amount</lx:label>
                                                <li:transactions>CAL,CDA,SVC</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                          <xs:attribute name="Description" type="stringType" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>Decription of the other addback.</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.Addback.OtherAddback.Description</lx:path>
                                                <lx:label>Description</lx:label>
                                                <li:transactions>CAL,CDA,SVC</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                        </xs:complexType>
                                      </xs:element>
                                    </xs:sequence>
                                    <xs:attribute name="Allowances" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Allowances amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.Addback.Allowances</lx:path>
                                          <lx:label>Allowances</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="AmortisationOfGoodwill" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Amortisation Of Goodwill amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.Addback.AmortisationOfGoodwill</lx:path>
                                          <lx:label>Amortisation Of Goodwill</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Bonus" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Bonus amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.Addback.Bonus</lx:path>
                                          <lx:label>Bonus</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="CarExpense" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Car expense amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.Addback.CarExpense</lx:path>
                                          <lx:label>Car Expense</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="CarryForwardLosses" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Carry Forward Losses amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.Addback.CarryForwardLosses</lx:path>
                                          <lx:label>Carry Forward Losses</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Depreciation" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Depreciation amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.Addback.Depreciation</lx:path>
                                          <lx:label>Depreciation</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="HomeOffice" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Home Office amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.Addback.HomeOffice</lx:path>
                                          <lx:label>Home Office</lx:label>
                                          <li:transactions>CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Interest" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Interest amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.Addback.Interest</lx:path>
                                          <lx:label>Interest</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Lease" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Lease amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.Addback.Lease</lx:path>
                                          <lx:label>Lease</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="NonCashBenefits" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Non-cash benefits amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.Addback.NonCashBenefits</lx:path>
                                          <lx:label>Non Cash Benefits</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="NonRecurringExpenses" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Non-recurring expense amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.Addback.NonRecurringExpenses</lx:path>
                                          <lx:label>Non Recurring Expenses</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="PaymentToDirector" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The payment to director that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.Addback.PaymentToDirector</lx:path>
                                          <lx:label>Payment To Director</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Salary" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Salary amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.Addback.Salary</lx:path>
                                          <lx:label>Salary</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="SuperannuationExcess" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Superannuation Excess amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.Addback.SuperannuationExcess</lx:path>
                                          <lx:label>Superannuation Excess</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="CompanyProfitAfterTax" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the company profit after tax for the specified financial year.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.CompanyProfitAfterTax</lx:path>
                                    <lx:label>Company Profit After Tax</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="CompanyProfitBeforeTax" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the company net profit/profit before tax for the specified financial year.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.CompanyProfitBeforeTax</lx:path>
                                    <lx:label>Company Profit Before Tax</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="EndDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The end date for the stated income, generally the end of a financial year</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.EndDate</lx:path>
                                    <lx:label>End Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="IncomeGreaterThanPreviousYear" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>When comparing past Tax Office Assessments, indicate whether the past return has improved on the Prior year.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.IncomeGreaterThanPreviousYear</lx:path>
                                    <lx:label>Income Greater Than Previous Year</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="StartDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The start date for the stated income, generally the start of a financial year</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.StartDate</lx:path>
                                    <lx:label>Start Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TaxOfficeAssessments" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Are Tax Office Assessments for at least the past two years available as supporting evidence for this application</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.TaxOfficeAssessments</lx:path>
                                    <lx:label>Tax Office Assessments</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_Accountant" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Link to the company's accountant for the full prior financial year. This should be populated when the accountant for the specified period is different to that declared as the current accountant.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomePrior.x_Accountant</lx:path>
                                    <lx:label>Accountant</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.RelatedCompany</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="IncomeRecent" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Details of the share of the gross (pre-tax) income or income-related amounts in the most recent full financial year, attributable to this applicant (year = current year -1).</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent</lx:path>
                                <lx:label>Income Recent</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="Addback" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Container element for Addback detail</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.Addback</lx:path>
                                      <lx:label>Addback</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:sequence>
                                      <xs:element name="OtherAddback" minOccurs="0" maxOccurs="unbounded">
                                        <xs:annotation>
                                          <xs:documentation>Other addback that cannot otherwise be captured under a specific addback category.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.Addback.OtherAddback</lx:path>
                                            <lx:label>Other Add Back</lx:label>
                                            <li:transactions>CAL,CDA,SVC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                        <xs:complexType>
                                          <xs:attribute name="Amount" type="currencyType" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>Amount that can be an addback to the income.</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.Addback.OtherAddback.Amount</lx:path>
                                                <lx:label>Amount</lx:label>
                                                <li:transactions>CAL,CDA,SVC</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                          <xs:attribute name="Description" type="stringType" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>Decription of the other addback.</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.Addback.OtherAddback.Description</lx:path>
                                                <lx:label>Description</lx:label>
                                                <li:transactions>CAL,CDA,SVC</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                        </xs:complexType>
                                      </xs:element>
                                    </xs:sequence>
                                    <xs:attribute name="Allowances" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Allowances amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.Addback.Allowances</lx:path>
                                          <lx:label>Allowances</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="AmortisationOfGoodwill" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Amortisation Of Goodwill amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.Addback.AmortisationOfGoodwill</lx:path>
                                          <lx:label>Amortisation Of Goodwill</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Bonus" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Bonus amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.Addback.Bonus</lx:path>
                                          <lx:label>Bonus</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="CarExpense" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Car expense amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.Addback.CarExpense</lx:path>
                                          <lx:label>Car Expense</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="CarryForwardLosses" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Carry Forward Losses amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.Addback.CarryForwardLosses</lx:path>
                                          <lx:label>Carry Forward Losses</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Depreciation" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Depreciation amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.Addback.Depreciation</lx:path>
                                          <lx:label>Depreciation</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="HomeOffice" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Home Office amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.Addback.HomeOffice</lx:path>
                                          <lx:label>Home Office</lx:label>
                                          <li:transactions>CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Interest" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Interest amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.Addback.Interest</lx:path>
                                          <lx:label>Interest</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Lease" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Lease amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.Addback.Lease</lx:path>
                                          <lx:label>Lease</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="NonCashBenefits" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Non-cash benefits amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.Addback.NonCashBenefits</lx:path>
                                          <lx:label>Non Cash Benefits</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="NonRecurringExpenses" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Non-recurring expense amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.Addback.NonRecurringExpenses</lx:path>
                                          <lx:label>Non Recurring Expenses</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="PaymentToDirector" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The payment to director that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.Addback.PaymentToDirector</lx:path>
                                          <lx:label>Payment To Director</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Salary" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Salary amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.Addback.Salary</lx:path>
                                          <lx:label>Salary</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="SuperannuationExcess" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Superannuation Excess amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.Addback.SuperannuationExcess</lx:path>
                                          <lx:label>Superannuation Excess</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="CompanyProfitAfterTax" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the company profit after tax for the specified financial year.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.CompanyProfitAfterTax</lx:path>
                                    <lx:label>Company Profit After Tax</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="CompanyProfitBeforeTax" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the company net profit/profit before tax for the specified financial year.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.CompanyProfitBeforeTax</lx:path>
                                    <lx:label>Company Profit Before Tax</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="EndDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The end date for the stated income, generally the end of a financial year</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.EndDate</lx:path>
                                    <lx:label>End Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="IncomeGreaterThanPreviousYear" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>When comparing past Tax Office Assessments, indicate whether the past return has improved on the previous year.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.IncomeGreaterThanPreviousYear</lx:path>
                                    <lx:label>Income Greater Than Previous Year</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="ProofCode" type="proofCodeCompanyList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Code to indicate the type of evidence of the income</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.ProofCode</lx:path>
                                    <lx:label>Proof Code</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="ProofSighted" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Has the Income evidence been sighted b the loan writer or assessor</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.ProofSighted</lx:path>
                                    <lx:label>Proof Sighted</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="StartDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The start date for the stated income, generally the start of a financial year</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.StartDate</lx:path>
                                    <lx:label>Start Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TaxOfficeAssessments" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Are Tax Office Assessments for at least the past two years available as supporting evidence for this application where the applicant is self-employed.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.TaxOfficeAssessments</lx:path>
                                    <lx:label>Tax Office Assessments</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_Accountant" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Link to the company's accountant for the full most recent financial year. This should be populated when the accountant for the specified period is different to that declared as the current accountant.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomeRecent.x_Accountant</lx:path>
                                    <lx:label>Accountant</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.RelatedCompany</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="IncomeYearToDate" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Details of the current year to date share of the gross (pre-tax) income or income-related amounts, attributable to this applicant.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate</lx:path>
                                <lx:label>Income Year To Date</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="Addback" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Container element for Addback detail</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate.Addback</lx:path>
                                      <lx:label>Addback</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:sequence>
                                      <xs:element name="OtherAddback" minOccurs="0" maxOccurs="unbounded">
                                        <xs:annotation>
                                          <xs:documentation>Other addback that cannot otherwise be captured under a specific addback category.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate.Addback.OtherAddback</lx:path>
                                            <lx:label>Other Add Back</lx:label>
                                            <li:transactions>CAL,CDA,SVC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                        <xs:complexType>
                                          <xs:attribute name="Amount" type="currencyType" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>Amount that can be an addback to the income.</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate.Addback.OtherAddback.Amount</lx:path>
                                                <lx:label>Amount</lx:label>
                                                <li:transactions>CAL,CDA,SVC</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                          <xs:attribute name="Description" type="stringType" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>Decription of the other addback.</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate.Addback.OtherAddback.Description</lx:path>
                                                <lx:label>Description</lx:label>
                                                <li:transactions>CAL,CDA,SVC</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                        </xs:complexType>
                                      </xs:element>
                                    </xs:sequence>
                                    <xs:attribute name="Allowances" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Allowances amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate.Addback.Allowances</lx:path>
                                          <lx:label>Allowances</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="AmortisationOfGoodwill" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Amortisation Of Goodwill amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate.Addback.AmortisationOfGoodwill</lx:path>
                                          <lx:label>Amortisation Of Goodwill</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Bonus" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Bonus amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate.Addback.Bonus</lx:path>
                                          <lx:label>Bonus</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="CarExpense" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Car expense amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate.Addback.CarExpense</lx:path>
                                          <lx:label>Car Expense</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="CarryForwardLosses" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Carry Forward Losses amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate.Addback.CarryForwardLosses</lx:path>
                                          <lx:label>Carry Forward Losses</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Depreciation" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Depreciation amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate.Addback.Depreciation</lx:path>
                                          <lx:label>Depreciation</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="HomeOffice" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Home Office amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate.Addback.HomeOffice</lx:path>
                                          <lx:label>Home Office</lx:label>
                                          <li:transactions>CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Interest" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Interest amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate.Addback.Interest</lx:path>
                                          <lx:label>Interest</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Lease" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Lease amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate.Addback.Lease</lx:path>
                                          <lx:label>Lease</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="NonCashBenefits" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Non-cash benefits amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate.Addback.NonCashBenefits</lx:path>
                                          <lx:label>Non Cash Benefits</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="NonRecurringExpenses" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Non-recurring expense amount that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate.Addback.NonRecurringExpenses</lx:path>
                                          <lx:label>Non Recurring Expenses</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="PaymentToDirector" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The payment to director that can be an addback to the income</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate.Addback.PaymentToDirector</lx:path>
                                          <lx:label>Payment To Director</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Salary" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Salary amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate.Addback.Salary</lx:path>
                                          <lx:label>Salary</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="SuperannuationExcess" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Superannuation Excess amount that can be an addback to the income.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate.Addback.SuperannuationExcess</lx:path>
                                          <lx:label>Superannuation Excess</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="CompanyProfitAfterTax" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the company profit after tax for the specified financial year.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate.CompanyProfitAfterTax</lx:path>
                                    <lx:label>Company Profit After Tax</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="CompanyProfitBeforeTax" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the company net profit/profit before tax for the specified financial year.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate.CompanyProfitBeforeTax</lx:path>
                                    <lx:label>Company Profit Before Tax</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="EndDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The end date for the stated income, generally the end of a financial year</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate.EndDate</lx:path>
                                    <lx:label>End Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="StartDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The start date for the stated income, generally the start of a financial year</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.IncomeYearToDate.StartDate</lx:path>
                                    <lx:label>Start Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="Partner" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>Container element for details of the partners that constitute this partnership.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CompanyApplicant.Partner</lx:path>
                                <lx:label>Partner</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="PartnerType" type="partnerTypeList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The Partner Type describes whether the partner is a general or limited partner.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Partner.PartnerType</lx:path>
                                    <lx:label>Partner Type</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PercentOwned" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The ownership percentage for the specified partner.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Partner.PercentOwned</lx:path>
                                    <lx:label>Percent Owned</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_Partner" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Contains a reference to an applicant or related party that is a partner of the business. These can be a person, a business enterprise or a trust.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Partner.x_Partner</lx:path>
                                    <lx:label>Partner</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.CompanyApplicant</lx:target>
                                      <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                      <lx:target>Package.Content.Application.RelatedCompany</lx:target>
                                      <lx:target>Package.Content.Application.RelatedPerson</lx:target>
                                      <lx:target>Package.Content.Application.TrustApplicant</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="RelatedLegalEntities" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Details of the related legal entities.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CompanyApplicant.RelatedLegalEntities</lx:path>
                                <lx:label>Related Legal Entities</lx:label>
                                <li:transactions>CAL</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="CurrentCustomers" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Free text to capture information about the related legal entites that are already customers of the lender.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.RelatedLegalEntities.CurrentCustomers</lx:path>
                                    <lx:label>Current Customers</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="EntityCount" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The number of related legal entities.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.RelatedLegalEntities.EntityCount</lx:path>
                                    <lx:label>Entity Count</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="ResponsibleLending" type="responsibleLendingType" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Captures information about any significant changes in circumstances that will adversely affect the applicants' ability to make contracted loan repayments; the nature of the change, and how they will collectively continue to make repayments.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CompanyApplicant.ResponsibleLending</lx:path>
                                <lx:label>Responsible Lending</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                          </xs:element>
                          <xs:element name="Shareholder" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>Contains a reference to an applicant or related party that is a shareholder of the company.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CompanyApplicant.Shareholder</lx:path>
                                <lx:label>Shareholder</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="PercentOwned" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The ownership percentage for the specified shareholder</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Shareholder.PercentOwned</lx:path>
                                    <lx:label>Percent Owned</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_Shareholder" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Contains a reference to an applicant or related party that is a shareholder of the company.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.Shareholder.x_Shareholder</lx:path>
                                    <lx:label>Shareholder</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.CompanyApplicant</lx:target>
                                      <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                      <lx:target>Package.Content.Application.RelatedCompany</lx:target>
                                      <lx:target>Package.Content.Application.RelatedPerson</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="SourceOfWealth" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>The source of the applicant's entire body of wealth.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CompanyApplicant.SourceOfWealth</lx:path>
                                <lx:label>Source Of Wealth</lx:label>
                                <li:transactions>CAL,CDA,DAS</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="Detail" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The details of the source of wealth.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.SourceOfWealth.Detail</lx:path>
                                    <lx:label>Detail</lx:label>
                                    <li:transactions>CAL,CDA,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Percentage" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The percentage of the wealth from this source.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.SourceOfWealth.Percentage</lx:path>
                                    <lx:label>Percentage</lx:label>
                                    <li:transactions>CAL,CDA,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Type" type="sourceOfFundsTypeList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The type of source of wealth.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyApplicant.SourceOfWealth.Type</lx:path>
                                    <lx:label>Type</lx:label>
                                    <li:transactions>CAL,CDA,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                        </xs:sequence>
                        <xs:attribute name="ABN" type="abnPattern" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the ABN of the company applicant</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.ABN</lx:path>
                              <lx:label>ABN</lx:label>
                              <li:transactions>CAL,CDA,DAS,LMI,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ABNVerified" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Flag to indicate that the business number has been verified by a search</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.ABNVerified</lx:path>
                              <lx:label>ABN Verified</lx:label>
                              <li:transactions>CAL,CDA,DAS,LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ACN" type="acnPattern" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the ACN of the company applicant</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.ACN</lx:path>
                              <lx:label>ACN</lx:label>
                              <li:transactions>CAL,CDA,DAS,SVC,LMI,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="AllowDirectMarketing" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates whether this Party will allow their details to be used for direct marketing purposes.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.AllowDirectMarketing</lx:path>
                              <lx:label>Allow Direct Marketing</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="AllowThirdPartyDisclosure" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates whether this Party will allow their details to be disclosed to third parties affiliated with this lender.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.AllowThirdPartyDisclosure</lx:path>
                              <lx:label>Allow Third Party Disclosure</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ApplicantType" type="applicantTypeList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Whether the loan party is a borrower or guarantor</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.ApplicantType</lx:path>
                              <lx:label>Applicant Type</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ARBN" type="arbnPattern" use="optional">
                          <xs:annotation>
                            <xs:documentation>The Australian Registered Body Number (ARBN) of the company applicant.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.ARBN</lx:path>
                              <lx:label>ARBN</lx:label>
                              <li:transactions>CAL,CDA,DAS</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ARSN" type="arsnPattern" use="optional">
                          <xs:annotation>
                            <xs:documentation>The Australian Registered Scheme Number (ARSN) of the company applicant.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.ARSN</lx:path>
                              <lx:label>ARSN</lx:label>
                              <li:transactions>CAL,CDA,DAS</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="BusinessName" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The business name or trading name of the company should be captured.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.BusinessName</lx:path>
                              <lx:label>Business Name</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="BusinessNameSameAsCompanyName" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates if the Business Name is the same as the Company Name.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.BusinessNameSameAsCompanyName</lx:path>
                              <lx:label>Business Name Same As Company Name</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="BusinessStructure" type="businessStructureExcludingTrustList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Legal structure of this business (only populated where this applicant is a Business Enterprise). Trust is not a valid entry as trust entity applicants need to be entered as a Trust Applicant.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.BusinessStructure</lx:path>
                              <lx:label>Business Structure</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="CompanyName" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The legal name of the company should be captured.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.CompanyName</lx:path>
                              <lx:label>Company Name</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="CompanyNumber" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the registered Company Number of the company applicant</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.CompanyNumber</lx:path>
                              <lx:label>Company Number</lx:label>
                              <li:transactions>CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="CreditStatus" type="creditStatusList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Summarises whether there are any issues indicated the credit history of the applicant.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.CreditStatus</lx:path>
                              <lx:label>Credit Status</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="CustomerTypeCode" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>A lender assigned code for the customer type.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.CustomerTypeCode</lx:path>
                              <lx:label>Customer Type Code</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="CustomerTypeDescription" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>A lender assigned description of the customer type.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.CustomerTypeDescription</lx:path>
                              <lx:label>Customer Type Description</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="DateRegistered" type="dateType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates the date when the company was registered.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.DateRegistered</lx:path>
                              <lx:label>Date Registered</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ExchangeListedOn" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Contains the name of the stock exchange that a public company is listed on. Is only relevant where company is of a publicly listed type.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.ExchangeListedOn</lx:path>
                              <lx:label>Exchange Listed On</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ExemptStatus" type="exemptStatusList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates whether the company status is exempt or non-exempt.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.ExemptStatus</lx:path>
                              <lx:label>Exempt Status</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="GovernmentOrganisation" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The applicant is a government organisation.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.GovernmentOrganisation</lx:path>
                              <lx:label>Government Organisation</lx:label>
                              <li:transactions>CAL,CDA,DAS,SVC,LMI,VAL,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="GSTRegisteredDate" type="dateType" use="optional">
                          <xs:annotation>
                            <xs:documentation>If registered for GST, the date from which the company is registered</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.GSTRegisteredDate</lx:path>
                              <lx:label>GST Registered Date</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="IRDNumber" type="irdNumberPattern" use="optional">
                          <xs:annotation>
                            <xs:documentation>The IRD Number of this Company Applicant.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.IRDNumber</lx:path>
                              <lx:label>IRD Number</lx:label>
                              <li:transactions>CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="IsExistingCustomer" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates whether the applicant is an existing customer of the lender being applied to.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.IsExistingCustomer</lx:path>
                              <lx:label>Is Existing Customer</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="IsHoldingCompany" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicate if the company is a holding company</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.IsHoldingCompany</lx:path>
                              <lx:label>Is Holding Company</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="LicenceNumber" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The licence number of the company should be captured.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.LicenceNumber</lx:path>
                              <lx:label>Licence Number</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="LocalAgentOfForeignCompany" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The applicant is a local agent of a foreign company.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.LocalAgentOfForeignCompany</lx:path>
                              <lx:label>Local Agent Of Foreign Company</lx:label>
                              <li:transactions>CAL,CDA,DAS,SVC,LMI,VAL,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="NumberOfCreditHistoryIssues" type="integerType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The number of credit history issues associated with this applicant.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.NumberOfCreditHistoryIssues</lx:path>
                              <lx:label>Number Of Credit History Issues</lx:label>
                              <li:transactions>ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="NumberOfDirectors" type="integerType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The number of directors that company has on its Board of Directors.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.NumberOfDirectors</lx:path>
                              <lx:label>Number Of Directors</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="NumberOfPartners" type="integerType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The number of partners that make up the partnership.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.NumberOfPartners</lx:path>
                              <lx:label>Number Of Partners</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="NumberOfShareholders" type="integerType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The approximate number of shareholders of the company</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.NumberOfShareholders</lx:path>
                              <lx:label>Number Of Shareholders</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="NZBN" type="nzbnPattern" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the NZBN of the company applicant</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.NZBN</lx:path>
                              <lx:label>NZBN</lx:label>
                              <li:transactions>CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="NZBNVerified" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Flag to indicate that the business number has been verified by a search</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.NZBNVerified</lx:path>
                              <lx:label>NZBN Verified</lx:label>
                              <li:transactions>CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="OECDCRSStatus" type="oecdCRSStatusList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates whether the company is considered Active or Passive for OECD Common Reporting Standard purposes.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.OECDCRSStatus</lx:path>
                              <lx:label>OECD CRS Status</lx:label>
                              <li:transactions>CAL,CDA,DAS</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="PrimaryApplicant" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates whether the lender should consider the party to be the primary applicant when processing the loan application. The significance of the primary applicant to the application varies from lender to lender.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.PrimaryApplicant</lx:path>
                              <lx:label>Primary Applicant</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="PublicAuthority" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates whether a company is a public authority like a council or government department.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.PublicAuthority</lx:path>
                              <lx:label>Public Authority</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ReasonForObtainingLoan" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>A field to indicate what is the reason for requesting or obtaining the loan.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.ReasonForObtainingLoan</lx:path>
                              <lx:label>Reason For Obtaining Loan</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="RegisteredForGST" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Flag to indicate whether the company is registered for GST</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.RegisteredForGST</lx:path>
                              <lx:label>Registered For GST</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="RegisteredForLTC" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The company is registered to use Look Through Company (LTC) rules for an income year.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.RegisteredForLTC</lx:path>
                              <lx:label>Registered For LTC</lx:label>
                              <li:transactions>CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="RegisteredInCountry" type="countryCodeList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates the country where the company is registered.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.RegisteredInCountry</lx:path>
                              <lx:label>Registered In Country</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="RegisteredInState" type="auStateList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates the Australian state where the company is registered.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.RegisteredInState</lx:path>
                              <lx:label>Registered In State</lx:label>
                              <li:transactions>CAL,CDA,DAS</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="SequenceNumber" type="integerType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The order of this company applicant within the sequence.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.SequenceNumber</lx:path>
                              <lx:label>Sequence Number</lx:label>
                              <li:transactions>CAL,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="TradingMoreThanTwoYears" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicate if the business has been trading more than 2 years</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.TradingMoreThanTwoYears</lx:path>
                              <lx:label>Trading More Than Two Years</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="TypeOfIncorporation" type="typeOfIncorporationList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The company structure, in the form of the type of incorporation.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.TypeOfIncorporation</lx:path>
                              <lx:label>Type Of Incorporation</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                          <xs:annotation>
                            <xs:documentation>System assigned unique identifier</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.UniqueID</lx:path>
                              <lx:label>Unique ID</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,VAL,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="x_Accountant" type="referenceType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Link to the company's current accountant.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.x_Accountant</lx:path>
                              <lx:label>Accountant</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              <lx:references>
                                <lx:target>Package.Content.Application.RelatedCompany</lx:target>
                              </lx:references>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="x_SoleTrader" type="referenceType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Link to the natural person that is the sole trader legally liable for this business enterprise.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.x_SoleTrader</lx:path>
                              <lx:label>Sole Trader</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              <lx:references>
                                <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                <lx:target>Package.Content.Application.RelatedPerson</lx:target>
                              </lx:references>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="x_Solicitor" type="referenceType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Link to the applicant's solicitor.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.x_Solicitor</lx:path>
                              <lx:label>Solicitor</lx:label>
                              <li:transactions>CAL,DAS,ACC</li:transactions>
                              <lx:references>
                                <lx:target>Package.Content.Application.RelatedCompany</lx:target>
                              </lx:references>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="x_TradeReference" type="referenceType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Link to the related company that is providing a trade reference.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyApplicant.x_TradeReference</lx:path>
                              <lx:label>Trade Reference</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              <lx:references>
                                <lx:target>Package.Content.Application.RelatedCompany</lx:target>
                              </lx:references>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                      </xs:complexType>
                    </xs:element>
                    <xs:element name="CompanyFinancials" minOccurs="0" maxOccurs="unbounded">
                      <xs:annotation>
                        <xs:documentation>Contain element for company or self-employed financial report data</xs:documentation>
                        <xs:appinfo>
                          <lx:path>Package.Content.Application.CompanyFinancials</lx:path>
                          <lx:label>Company Financials</lx:label>
                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                        </xs:appinfo>
                      </xs:annotation>
                      <xs:complexType>
                        <xs:sequence>
                          <xs:element name="BalanceSheet" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Balance sheet financials</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CompanyFinancials.BalanceSheet</lx:path>
                                <lx:label>Balance Sheet</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="Assets" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Asset items from the financial report</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.CompanyFinancials.BalanceSheet.Assets</lx:path>
                                      <lx:label>Assets</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="Cash" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Cash at bank</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyFinancials.BalanceSheet.Assets.Cash</lx:path>
                                          <lx:label>Cash</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="CashAndCashEquivalents" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>As listed in financial report</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyFinancials.BalanceSheet.Assets.CashAndCashEquivalents</lx:path>
                                          <lx:label>Cash And Cash Equivalents</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Intangibles" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Intangible assets, or goodwill</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyFinancials.BalanceSheet.Assets.Intangibles</lx:path>
                                          <lx:label>Intangibles</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Inventory" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Value of inventory, being materials, work in progress, and stock on hand</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyFinancials.BalanceSheet.Assets.Inventory</lx:path>
                                          <lx:label>Inventory</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="TangibleAssets" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>(Total Assets - Intangibles)</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyFinancials.BalanceSheet.Assets.TangibleAssets</lx:path>
                                          <lx:label>Tangible Assets</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="TotalAssets" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Total assets</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyFinancials.BalanceSheet.Assets.TotalAssets</lx:path>
                                          <lx:label>Total Assets</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="TotalCurrentAssets" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Total current assets</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyFinancials.BalanceSheet.Assets.TotalCurrentAssets</lx:path>
                                          <lx:label>Total Current Assets</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="TradeDebtors" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Value of the trade debtors (receivables)</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyFinancials.BalanceSheet.Assets.TradeDebtors</lx:path>
                                          <lx:label>Trade Debtors</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="Liabilities" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Liability items from the financial report</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.CompanyFinancials.BalanceSheet.Liabilities</lx:path>
                                      <lx:label>Liabilities</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="DebtAtNominalValue" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Total Borrowings</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyFinancials.BalanceSheet.Liabilities.DebtAtNominalValue</lx:path>
                                          <lx:label>Debt At Nominal Value</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="TotalCurrentLiabilities" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Total current liabilities</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyFinancials.BalanceSheet.Liabilities.TotalCurrentLiabilities</lx:path>
                                          <lx:label>Total Current Liabilities</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="TotalLiabilities" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Total liabilities</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyFinancials.BalanceSheet.Liabilities.TotalLiabilities</lx:path>
                                          <lx:label>Total Liabilities</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="TradeCreditors" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Value of the trade creditors (accounts payable)</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CompanyFinancials.BalanceSheet.Liabilities.TradeCreditors</lx:path>
                                          <lx:label>Trade Creditors</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="Equity" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Equity on this balance sheet.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyFinancials.BalanceSheet.Equity</lx:path>
                                    <lx:label>Equity</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="NetAssets" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>(Total Assets - Total Liabilities)</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyFinancials.BalanceSheet.NetAssets</lx:path>
                                    <lx:label>Net Assets</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PaidUpCapital" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Paid Up Capital</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyFinancials.BalanceSheet.PaidUpCapital</lx:path>
                                    <lx:label>Paid Up Capital</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="RetainedEarnings" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The amount of retained earnings</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyFinancials.BalanceSheet.RetainedEarnings</lx:path>
                                    <lx:label>Retained Earnings</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="ShareholderFunds" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Shareholder Funds on this balance sheet.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyFinancials.BalanceSheet.ShareholderFunds</lx:path>
                                    <lx:label>Shareholder Funds</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="CurrentMarketData" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Equity data from the financial report</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CompanyFinancials.CurrentMarketData</lx:path>
                                <lx:label>Current Market Data</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="ValueOfCommonEquity" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Number of Common Shares x current Market Price</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyFinancials.CurrentMarketData.ValueOfCommonEquity</lx:path>
                                    <lx:label>Value Of Common Equity</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="ValueOfMinorityInterests" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Market Value of any shares held by a minority shareholder (if any)</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyFinancials.CurrentMarketData.ValueOfMinorityInterests</lx:path>
                                    <lx:label>Value Of Minority Interests</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="ValueOfPreferredEquity" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Number of Preference Shares x current Market Price</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyFinancials.CurrentMarketData.ValueOfPreferredEquity</lx:path>
                                    <lx:label>Value Of Preferred Equity</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="ProfitAndLoss" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Profit and Loss (income and expense) financials</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CompanyFinancials.ProfitAndLoss</lx:path>
                                <lx:label>Profit And Loss</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="AmortisationExpense" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Amortisation as recorded in the financial report</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyFinancials.ProfitAndLoss.AmortisationExpense</lx:path>
                                    <lx:label>Amortisation Expense</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="CostOfGoodsSold" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Cost of goods sold on this profit and loss statement.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyFinancials.ProfitAndLoss.CostOfGoodsSold</lx:path>
                                    <lx:label>Cost of Goods Sold</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="DepreciationExpense" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Depreciation as recorded in the financial report</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyFinancials.ProfitAndLoss.DepreciationExpense</lx:path>
                                    <lx:label>Depreciation Expense</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="EBIT" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Earnings before interest and tax</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyFinancials.ProfitAndLoss.EBIT</lx:path>
                                    <lx:label>EBIT</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="EBITDA" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Earnings before interest, tax, depreciation and amortisation</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyFinancials.ProfitAndLoss.EBITDA</lx:path>
                                    <lx:label>EBITDA</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="GrossProfit" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Sales less cost of goods sold (COGS)</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyFinancials.ProfitAndLoss.GrossProfit</lx:path>
                                    <lx:label>Gross Profit</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="IncomeTax" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Income tax paid or refunded for the financial year. A positive number indicates tax paid, a negative number indicates tax refunded.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyFinancials.ProfitAndLoss.IncomeTax</lx:path>
                                    <lx:label>Income Tax</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="InterestExpense" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Total interest expense as listed in the financial report, including leasing expenses</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyFinancials.ProfitAndLoss.InterestExpense</lx:path>
                                    <lx:label>Interest Expense</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="NetProfitBeforeTax" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Net profit before tax</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyFinancials.ProfitAndLoss.NetProfitBeforeTax</lx:path>
                                    <lx:label>Net Profit Before Tax</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PaymentsToDirectors" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Gross payments paid to the directors of the company</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyFinancials.ProfitAndLoss.PaymentsToDirectors</lx:path>
                                    <lx:label>Payments To Directors</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Sales" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Total sales revenue</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyFinancials.ProfitAndLoss.Sales</lx:path>
                                    <lx:label>Sales</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TotalExpenses" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Total Expenses on this profit and loss statement.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CompanyFinancials.ProfitAndLoss.TotalExpenses</lx:path>
                                    <lx:label>TotalExpenses</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                        </xs:sequence>
                        <xs:attribute name="EndDate" type="dateType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The end date of the financials, generally a financial year end</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyFinancials.EndDate</lx:path>
                              <lx:label>End Date</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="SequenceNumber" type="integerType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The order of this company financials within the sequence.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyFinancials.SequenceNumber</lx:path>
                              <lx:label>Sequence Number</lx:label>
                              <li:transactions>CAL,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="StartDate" type="dateType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The start date of the financials, generally a financial year start</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyFinancials.StartDate</lx:path>
                              <lx:label>Start Date</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                          <xs:annotation>
                            <xs:documentation>System assigned unique identifier</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CompanyFinancials.UniqueID</lx:path>
                              <lx:label>Unique ID</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                      </xs:complexType>
                    </xs:element>
                    <xs:element name="ContributionFunds" minOccurs="0" maxOccurs="unbounded">
                      <xs:annotation>
                        <xs:documentation>Details the amounts and sources of funds that will be contributed by the applicant to complete the contemplated transaction, generally a property purchase but may also be a refinance or other purchase. There may be 0 or more contributions.</xs:documentation>
                        <xs:appinfo>
                          <lx:path>Package.Content.Application.ContributionFunds</lx:path>
                          <lx:label>Contribution Funds</lx:label>
                          <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                        </xs:appinfo>
                      </xs:annotation>
                      <xs:complexType>
                        <xs:attribute name="Amount" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The amount of the particular contribution.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.ContributionFunds.Amount</lx:path>
                              <lx:label>Amount</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="Description" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>A free form description of the contribution used when the selected Contribution Fund Type = "Other"</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.ContributionFunds.Description</lx:path>
                              <lx:label>Description</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="Loan" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates whether the contribution is borrowed from a third party.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.ContributionFunds.Loan</lx:path>
                              <lx:label>Loan</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="SequenceNumber" type="integerType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The order of this contribution funds within the sequence.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.ContributionFunds.SequenceNumber</lx:path>
                              <lx:label>Sequence Number</lx:label>
                              <li:transactions>CAL,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="Type" type="contributionFundsTypeList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The type of the particular contribution.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.ContributionFunds.Type</lx:path>
                              <lx:label>Type</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                          <xs:annotation>
                            <xs:documentation>System assigned unique identifier.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.ContributionFunds.UniqueID</lx:path>
                              <lx:label>Unique ID</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="x_AssociatedLoanAccount" type="referenceType" use="optional">
                          <xs:annotation>
                            <xs:documentation>A cross reference to the loan account (Loan Details element) to which the contribution funds belong.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.ContributionFunds.x_AssociatedLoanAccount</lx:path>
                              <lx:label>Associated Loan Account</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                              <lx:references>
                                <lx:target>Package.Content.Application.LoanDetails</lx:target>
                              </lx:references>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="x_FundsHeldInAccount" type="referenceType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Reference to capture the bank account details for funds held with a financial institution.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.ContributionFunds.x_FundsHeldInAccount</lx:path>
                              <lx:label>Funds Held In Account</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                              <lx:references>
                                <lx:target>Package.Content.Application.Liability</lx:target>
                                <lx:target>Package.Content.Application.NonRealEstateAsset</lx:target>
                              </lx:references>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                      </xs:complexType>
                    </xs:element>
                    <xs:element name="CustomerTransactionAnalysis" minOccurs="0" maxOccurs="unbounded">
                      <xs:annotation>
                        <xs:documentation>Analysis of customer bank account transaction data.</xs:documentation>
                        <xs:appinfo>
                          <lx:path>Package.Content.Application.CustomerTransactionAnalysis</lx:path>
                          <lx:label>Customer Transaction Analysis</lx:label>
                          <li:transactions>CAL</li:transactions>
                        </xs:appinfo>
                      </xs:annotation>
                      <xs:complexType>
                        <xs:sequence>
                          <xs:element name="CategorySet" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>A set of customer bank account transaction data classified into aggregated categories.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CustomerTransactionAnalysis.CategorySet</lx:path>
                                <lx:label>Category Set</lx:label>
                                <li:transactions>CAL</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="AggregatedTransactions" minOccurs="0" maxOccurs="unbounded">
                                  <xs:annotation>
                                    <xs:documentation>A category of customer bank account transaction data.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.CustomerTransactionAnalysis.CategorySet.AggregatedTransactions</lx:path>
                                      <lx:label>Aggregated Transactions</lx:label>
                                      <li:transactions>CAL</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="Amount" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The dollar amount in this category of aggregated transaction data.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CustomerTransactionAnalysis.CategorySet.AggregatedTransactions.Amount</lx:path>
                                          <lx:label>Amount</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="AmountOnMonthlyBasis" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The dollar amount on a monthly basis in this category of aggregated transaction data.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CustomerTransactionAnalysis.CategorySet.AggregatedTransactions.AmountOnMonthlyBasis</lx:path>
                                          <lx:label>Amount On Monthly Basis</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Category" type="aggregatedTransactionsCategoryTypeList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The name of the category of aggregated transaction data.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CustomerTransactionAnalysis.CategorySet.AggregatedTransactions.Category</lx:path>
                                          <lx:label>Category</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="OtherCategory" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>A description of the category of aggregated transaction data, to be used when the category is 'Other'.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CustomerTransactionAnalysis.CategorySet.AggregatedTransactions.OtherCategory</lx:path>
                                          <lx:label>Other Category</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="OtherCategoryCode" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>A code indicating the category of this aggregate transaction, to be used when the category is 'Other'.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CustomerTransactionAnalysis.CategorySet.AggregatedTransactions.OtherCategoryCode</lx:path>
                                          <lx:label>Other Category Code</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Type" type="transactionTypeList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The type of transaction: Debit or Credit.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CustomerTransactionAnalysis.CategorySet.AggregatedTransactions.Type</lx:path>
                                          <lx:label>Type</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>System assigned unique identifier.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.CustomerTransactionAnalysis.CategorySet.AggregatedTransactions.UniqueID</lx:path>
                                          <lx:label>Unique ID</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="CategorySetName" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The name of the set of categorised data.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CustomerTransactionAnalysis.CategorySet.CategorySetName</lx:path>
                                    <lx:label>CategorySetName</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>System assigned unique identifier.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CustomerTransactionAnalysis.CategorySet.UniqueID</lx:path>
                                    <lx:label>UniqueID</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="Result" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>The results of the customer transaction analysis.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.CustomerTransactionAnalysis.Result</lx:path>
                                <lx:label>Result</lx:label>
                                <li:transactions>CAL</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="ManualCheckDetails" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A description of the manual check that the analysis has determined to be required.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CustomerTransactionAnalysis.Result.ManualCheckDetails</lx:path>
                                    <lx:label>Manual Check Details</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="ReferForManualCheck" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The analysis has determined a manual check by the lender is required.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.CustomerTransactionAnalysis.Result.ReferForManualCheck</lx:path>
                                    <lx:label>Refer For Manual Check</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                        </xs:sequence>
                        <xs:attribute name="AnalysisID" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>An identifier for the customer transaction analysis provided by the data aggregator.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CustomerTransactionAnalysis.AnalysisID</lx:path>
                              <lx:label>Analysis ID</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="DataAggregator" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The provider of the aggregated results of the customer transaction analysis.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CustomerTransactionAnalysis.DataAggregator</lx:path>
                              <lx:label>Data Aggregator</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="EndDate" type="dateType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The end date of the period of the transaction analysis.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CustomerTransactionAnalysis.EndDate</lx:path>
                              <lx:label>End Date</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="SequenceNumber" type="integerType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The order of this customer transaction analysis within the sequence.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CustomerTransactionAnalysis.SequenceNumber</lx:path>
                              <lx:label>Sequence Number</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="StartDate" type="dateType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The start date of the period of the transaction analysis.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CustomerTransactionAnalysis.StartDate</lx:path>
                              <lx:label>Start Date</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                          <xs:annotation>
                            <xs:documentation>System assigned unique identifier.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.CustomerTransactionAnalysis.UniqueID</lx:path>
                              <lx:label>Unique ID</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                      </xs:complexType>
                    </xs:element>
                    <xs:element name="Declarations" minOccurs="0" maxOccurs="1">
                      <xs:annotation>
                        <xs:documentation>Captures declarations such as Broker Declarations that apply to the whole application.</xs:documentation>
                        <xs:appinfo>
                          <lx:path>Package.Content.Application.Declarations</lx:path>
                          <lx:label>Declarations</lx:label>
                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                        </xs:appinfo>
                      </xs:annotation>
                      <xs:complexType>
                        <xs:sequence>
                          <xs:element name="BrokerDeclarations" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Wrapper element for Broker Declarations.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Declarations.BrokerDeclarations</lx:path>
                                <lx:label>Broker Declarations</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="ApplicantIsTheSamePersonShownInThePhotograph" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Declaration from the broker that the applicant is the same as the person shown in the photograph in the documents provided with this application.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Declarations.BrokerDeclarations.ApplicantIsTheSamePersonShownInThePhotograph</lx:path>
                                    <lx:label>Applicant Is The Same Person Shown In The Photograph</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="AssetIncomeLiabilityAndExpenseObtained" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Declaration from the broker that the applicant's assets, income, liability and expense information provided within the application are those obtained from the applicant(s) during the preliminary assessment.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Declarations.BrokerDeclarations.AssetIncomeLiabilityAndExpenseObtained</lx:path>
                                    <lx:label>Asset Income Liability And Expense Obtained</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="AwareThatWilfulBreachOfIdentificationIsPunishable" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Declaration from the broker that they are aware that any wilful breach of identification obligations is made punishable under the Anti-Money Laundering/ Counter-Terrorism Financing Act 2006.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Declarations.BrokerDeclarations.AwareThatWilfulBreachOfIdentificationIsPunishable</lx:path>
                                    <lx:label>Aware That Wilful Breach Of Identification Is Punishable</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="BeenShareholderOrOfficerOfACompanyInDifficulties" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Declaration from the broker that they have asked whether applicant/s has been a shareholder or an officer of any company in difficulties (including bankruptcy).</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Declarations.BrokerDeclarations.BeenShareholderOrOfficerOfACompanyInDifficulties</lx:path>
                                    <lx:label>Been Shareholder Or Officer Of A Company In Difficulties</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="CompletedOriginalDocumentsAndSightedInThePresenceOfApplicant" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Declaration from the broker that they have completed the original documents detailed in this application and sighted it in the presence of all applicants.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Declarations.BrokerDeclarations.CompletedOriginalDocumentsAndSightedInThePresenceOfApplicant</lx:path>
                                    <lx:label>Completed Original Documents And Sighted In The Presence Of Applicant</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="DateAndTimeOfDeclaration" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Date and time of the broker's declaration.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Declarations.BrokerDeclarations.DateAndTimeOfDeclaration</lx:path>
                                    <lx:label>Date And Time Of Declaration</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="DetailsOfConflictsOfInterestProvided" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Declaration from the broker that they have provided details of any conflicts of interest relating to this application(s).</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Declarations.BrokerDeclarations.DetailsOfConflictsOfInterestProvided</lx:path>
                                    <lx:label>Details Of Conflicts Of Interest Provided</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="HaveNoConcernsAboutApplicantIdentity" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Declaration from the broker that they have no concern about applicant's identity and believe them to be who they say they are despite not being successfully electronically verified.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Declarations.BrokerDeclarations.HaveNoConcernsAboutApplicantIdentity</lx:path>
                                    <lx:label>Have No Concerns About Applicant Identity</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="InterestOnlyMeetsRequirements" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Declaration from the broker that the interest only period aligns with the applicant's requirements.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Declarations.BrokerDeclarations.InterestOnlyMeetsRequirements</lx:path>
                                    <lx:label>Declaration from the broker that the interest only period aligns with the applicant's requirements.</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="InterestOnlyMeetsRequirementsDescription" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The text of the declaration from the broker stating that the interest only period aligns with the applicant's requirements.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Declarations.BrokerDeclarations.InterestOnlyMeetsRequirementsDescription</lx:path>
                                    <lx:label>The text of the declaration from the broker stating that the interest only period aligns with the applicant's requirements.</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="InterestOnlyRisksExplained" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Declaration from the broker that the applicant has had the additional risks and costs of an interest only term explained to them. The applicant has had the following explained: interest only loan repayments will not pay off any principal during the interest only term; the repayments required to pay out the loan will increase after the interest only period ends to cover both interest and principal reductions; and the applicant may pay more over the life of their loan than if there was no interest only term.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Declarations.BrokerDeclarations.InterestOnlyRisksExplained</lx:path>
                                    <lx:label>Declaration from the broker that the applicant has had the additional risks and costs of an interest only term explained to them.</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="InterestOnlyRisksExplainedDescription" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The text of the declaration from the broker explaining the applicant has had the additional risks and costs of an interest only term explained to them.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Declarations.BrokerDeclarations.InterestOnlyRisksExplainedDescription</lx:path>
                                    <lx:label>The text of the declaration from the broker explaining that the applicant has had the additional risks and costs of an interest only term explained to them.</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="LenderInformedAboutAdditionalRequirementAndInformation" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Declaration from the broker that they have informed the lender of any additional information, requirements and objectives of which they have been informed or have identified.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Declarations.BrokerDeclarations.LenderInformedAboutAdditionalRequirementAndInformation</lx:path>
                                    <lx:label>Lender Informed About Additional Requirement And Information</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="LMIApplicableAndExplainedToTheApplicant" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Declaration from the broker that they have explained Lenders Mortgage Insurance (LMI) to the applicant(s) where is applicable.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Declarations.BrokerDeclarations.LMIApplicableAndExplainedToTheApplicant</lx:path>
                                    <lx:label>LMI Applicable And Explained To The Applicant</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="ProductMeetsApplicantRequirements" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Declaration from the broker that they made reasonable inquiries and can state that the product meets the applicant(s) requirements and objectives as outlined by the applicant(s) in this application form and consider the loan as not unsuitable.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Declarations.BrokerDeclarations.ProductMeetsApplicantRequirements</lx:path>
                                    <lx:label>Product Meets Applicant Requirements</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="RefinancingAndDebtConsolidationMeetsObjectives" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Declaration from the broker that they have considered the costs, risks and benefits for the applicant(s) of the refinancing/debt consolidation, including: fees payable as a result of the refinancing/debt consolidation (both in ending the old loan and in establishing the new loan); a comparison of the interest rate of the current loan and the proposed new loan; a comparison of the loan term and repayment amount of the current loan and the proposed new loan and whether the applicant(s) would get improved cash flow as a result of the refinancing; whether any debt consolidation involved would achieve administrative convenience for the applicant(s); whether the applicant can afford to make the change to the product and meet the new payments without substantial hardship; and whether the applicant will end up paying more interest if debt is refinanced/ consolidated. I am satisfied that the refinancing/debt consolidation meets the applicant(s) requirements and objectives.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Declarations.BrokerDeclarations.RefinancingAndDebtConsolidationMeetsObjectives</lx:path>
                                    <lx:label>Refinancing And Debt Consolidation Meets Objectives</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="SubmittedSimilarApplicationToOtherLenders" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Declaration from the broker that they have asked whether applicant/s has submitted similar application to other lenders.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Declarations.BrokerDeclarations.SubmittedSimilarApplicationToOtherLenders</lx:path>
                                    <lx:label>Submitted Similar Application To Other Lenders</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="UnsatisfiedJudgmentAgainstAnyApplicantOrCompany" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Declaration from the broker that they have asked whether there is any unsatisfied judgement entered in any court against any applicant, or any company of which any applicant is or was a shareholder or officer.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Declarations.BrokerDeclarations.UnsatisfiedJudgmentAgainstAnyApplicantOrCompany</lx:path>
                                    <lx:label>Unsatisfied Judgment Against Any Applicant Or Company</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="VerifyThatTheDataCapturedIsCorrect" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Declaration from the broker that they are verifying that the data captured is correct.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Declarations.BrokerDeclarations.VerifyThatTheDataCapturedIsCorrect</lx:path>
                                    <lx:label>Verify That The Data Captured Is Correct</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                        </xs:sequence>
                      </xs:complexType>
                    </xs:element>
                    <xs:element name="DepositAccountDetails" minOccurs="0" maxOccurs="unbounded">
                      <xs:annotation>
                        <xs:documentation>Carries the details of a deposit account being opened.</xs:documentation>
                        <xs:appinfo>
                          <lx:path>Package.Content.Application.DepositAccountDetails</lx:path>
                          <lx:label>Deposit Account Details</lx:label>
                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                        </xs:appinfo>
                      </xs:annotation>
                      <xs:complexType>
                        <xs:sequence>
                          <xs:element name="AccountOwners" type="percentOwnedType" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Identifies the parties that are prospective owners of this account.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.DepositAccountDetails.AccountOwners</lx:path>
                                <lx:label>Account Owners</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                          </xs:element>
                          <xs:element name="Commission" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Contains information relating to the commission to be paid to the business partner that has sourced the deposit account application for the lender. This partner is typically a third party.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.DepositAccountDetails.Commission</lx:path>
                                <lx:label>Commission</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="CommissionAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The amount of upfront commission to be paid to the sales channel in the event that deposit account application is successful.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.Commission.CommissionAmount</lx:path>
                                    <lx:label>Commission Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="CommissionPaid" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether a commission is payable to the sales channel in respect of the deposit account application.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.Commission.CommissionPaid</lx:path>
                                    <lx:label>Commission Paid</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="CommissionStructure" type="commissionStructureList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the commission plan involves payment of an upfront commission only, an upfront commission and a trail commission, a trail commission only, or another type of structure.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.Commission.CommissionStructure</lx:path>
                                    <lx:label>Commission Structure</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="OtherCommissionStructureDescription" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A description of the commission structure if an accurate description is not specified in the enumerated values. Must be provided when Commission Structure = "Other"</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.Commission.OtherCommissionStructureDescription</lx:path>
                                    <lx:label>Other Commission Structure Description</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PromotionCode" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A code that specifies a particular promotion or special commission offer that applies to the deposit account application, specified by the submitting sales channel in order to tag the deal with the promotion code.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.Commission.PromotionCode</lx:path>
                                    <lx:label>Promotion Code</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="ThirdPartyReferee" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the sales channel is a third party referrer of business for the purpose of commission disclosure requirements.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.Commission.ThirdPartyReferee</lx:path>
                                    <lx:label>Third Party Referee</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Trail" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates the trail commission percentage.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.Commission.Trail</lx:path>
                                    <lx:label>Trail</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="DocumentationInstructions" type="documentationInstructionsType" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Contains information specifying where the lender is to send the account documents once the deposit account has been approved. This nomination over-rides an equivalent one at the Application level.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.DepositAccountDetails.DocumentationInstructions</lx:path>
                                <lx:label>Documentation Instructions</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                          </xs:element>
                          <xs:element name="FeaturesSelected" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>Contains information about the product features requested by the applicant or applicants.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.DepositAccountDetails.FeaturesSelected</lx:path>
                                <lx:label>Features Selected</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="ExtraFeature" minOccurs="0" maxOccurs="unbounded">
                                  <xs:annotation>
                                    <xs:documentation>Information about a product feature that is requested on the deposit account.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.DepositAccountDetails.FeaturesSelected.ExtraFeature</lx:path>
                                      <lx:label>Extra Feature</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="Description" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Specific information, value or enumeration related to the specific feature (name).</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.DepositAccountDetails.FeaturesSelected.ExtraFeature.Description</lx:path>
                                          <lx:label>Description</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Name" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The name of the specific feature being requested. Free text field although deposit taking institutions may provide enumerations.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.DepositAccountDetails.FeaturesSelected.ExtraFeature.Name</lx:path>
                                          <lx:label>Name</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Unique Identifier for this Extra Feature Element</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.DepositAccountDetails.FeaturesSelected.ExtraFeature.UniqueID</lx:path>
                                          <lx:label>Unique ID</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="ChequeBook" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant requests that a cheque book be issued for the deposit account.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.FeaturesSelected.ChequeBook</lx:path>
                                    <lx:label>Cheque Book</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="CreditCard" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant has requested a credit card.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.FeaturesSelected.CreditCard</lx:path>
                                    <lx:label>Credit Card</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="DebitCard" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant has requested a debit card.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.FeaturesSelected.DebitCard</lx:path>
                                    <lx:label>Debit Card</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="DepositBook" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant has requested a deposit book</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.FeaturesSelected.DepositBook</lx:path>
                                    <lx:label>Deposit Book</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="EFTPOSCard" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant has requested an EFTPOS card.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.FeaturesSelected.EFTPOSCard</lx:path>
                                    <lx:label>EFTPOS Card</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="StatementEmailDelivery" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant has requested statements be delivered by email</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.FeaturesSelected.StatementEmailDelivery</lx:path>
                                    <lx:label>Statement Email Delivery</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="StatementPaperDelivery" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant has requested to receive paper statements.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.FeaturesSelected.StatementPaperDelivery</lx:path>
                                    <lx:label>Statement Paper Delivery</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_Applicant" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The applicant that has selected these features (when this attribute is not populated, the selected features apply to the entire account).</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.FeaturesSelected.x_Applicant</lx:path>
                                    <lx:label>Applicant</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.CompanyApplicant</lx:target>
                                      <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                      <lx:target>Package.Content.Application.TrustApplicant</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="Package" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Contains information about a package option that may be available for the individual deposit account.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.DepositAccountDetails.Package</lx:path>
                                <lx:label>Package</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="Category" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures a deposit taking institution's defined category to which the requested package belongs.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.Package.Category</lx:path>
                                    <lx:label>Category</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Code" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A unique code representing the product package being requested by the applicant.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.Package.Code</lx:path>
                                    <lx:label>Code</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="MemberID" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Membership Identifier of the applicant issued by the Organisation the applicant claims to belong to and therefore qualify for the package associated with that Organisation. May be provided when Organisation is specified.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.Package.MemberID</lx:path>
                                    <lx:label>Member ID</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Name" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the name of a package that the applicant is applying for. A package commonly gives the applicants certain benefits, such as an interest rate bonus. There may be rules that determine whether the applicants qualify for the package.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.Package.Name</lx:path>
                                    <lx:label>Name</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="OptionCode" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A unique code identifying an option that applies to a package.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.Package.OptionCode</lx:path>
                                    <lx:label>Option Code</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Organisation" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A code or name that identifies the organisation under which the package is offered.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.Package.Organisation</lx:path>
                                    <lx:label>Organisation</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="SourceOfInitialDeposit" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>The source of the funds to be used for the initial deposit.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.DepositAccountDetails.SourceOfInitialDeposit</lx:path>
                                <lx:label>Source Of Initial Deposit</lx:label>
                                <li:transactions>CAL</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="Details" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The details of the source of funds if the type is 'Other'.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.SourceOfInitialDeposit.Details</lx:path>
                                    <lx:label>Details</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Percentage" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The percentage of the funds from this source.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.SourceOfInitialDeposit.Percentage</lx:path>
                                    <lx:label>Percentage</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Type" type="sourceOfFundsTypeList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A general description of the source of funds for the initial deposit.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.DepositAccountDetails.SourceOfInitialDeposit.Type</lx:path>
                                    <lx:label>Type</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                        </xs:sequence>
                        <xs:attribute name="InitialDepositAmount" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The dollar amount that will be deposited in the initial deposit.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.DepositAccountDetails.InitialDepositAmount</lx:path>
                              <lx:label>Initial Deposit Amount</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="OriginatorReferenceID" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Unique identifier assigned to the deposit account detail by the originator system.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.DepositAccountDetails.OriginatorReferenceID</lx:path>
                              <lx:label>Originator Reference ID</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ProductCode" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures an identifying code for the deposit account product applied for. This code is typically issued by the Organisation and enables the Organisation's systems to uniquely identify the product.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.DepositAccountDetails.ProductCode</lx:path>
                              <lx:label>Product Code</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ProductName" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the name of the deposit account product applied for.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.DepositAccountDetails.ProductName</lx:path>
                              <lx:label>Product Name</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ProposedAnnualInterestRate" type="percentType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The interest rate that applies to the deposit account. Typically expressed as an annual interest rate.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.DepositAccountDetails.ProposedAnnualInterestRate</lx:path>
                              <lx:label>Proposed Annual Interest Rate</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="SequenceNumber" type="integerType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The order of this deposit account details within the sequence.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.DepositAccountDetails.SequenceNumber</lx:path>
                              <lx:label>Sequence Number</lx:label>
                              <li:transactions>CAL,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="StatementCycle" type="statementCycleList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates preferred frequency for statements</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.DepositAccountDetails.StatementCycle</lx:path>
                              <lx:label>Statement Cycle</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="Type" type="depositAccountTypeList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Specifies the type of the deposit account such as transactional or term.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.DepositAccountDetails.Type</lx:path>
                              <lx:label>Type</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                          <xs:annotation>
                            <xs:documentation>System assigned unique identifier</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.DepositAccountDetails.UniqueID</lx:path>
                              <lx:label>Unique ID</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                      </xs:complexType>
                    </xs:element>
                    <xs:element name="DetailedComment" minOccurs="0" maxOccurs="unbounded">
                      <xs:annotation>
                        <xs:documentation>Complex element containing comments related to any section of the application. By default, absent any reference to a Context, comments relate to the Application overall.</xs:documentation>
                        <xs:appinfo>
                          <lx:path>Package.Content.Application.DetailedComment</lx:path>
                          <lx:label>Detailed Comment</lx:label>
                          <li:transactions>CAL,CDA,DAS,CNZ,LMI,ACC</li:transactions>
                        </xs:appinfo>
                      </xs:annotation>
                      <xs:complexType>
                        <xs:sequence>
                          <xs:element name="Comment" type="stringType" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A free text comment</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.DetailedComment.Comment</lx:path>
                                <lx:label>Comment</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,LMI,ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                          </xs:element>
                        </xs:sequence>
                        <xs:attribute name="ContextDescription" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Text description of the item the comment refers to</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.DetailedComment.ContextDescription</lx:path>
                              <lx:label>Context Description</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="CreatedDate" type="dateTimeType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The date that the comment was added to the file</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.DetailedComment.CreatedDate</lx:path>
                              <lx:label>Created Date</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="SequenceNumber" type="integerType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The order of this detailed comment within the sequence.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.DetailedComment.SequenceNumber</lx:path>
                              <lx:label>Sequence Number</lx:label>
                              <li:transactions>CAL,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                          <xs:annotation>
                            <xs:documentation>System assigned unique identifier</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.DetailedComment.UniqueID</lx:path>
                              <lx:label>Unique ID</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="x_Author" type="referenceType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Reference to the author of the comment</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.DetailedComment.x_Author</lx:path>
                              <lx:label>Author</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                              <lx:references>
                                <lx:target>Package.Content.Application.RelatedPerson</lx:target>
                                <lx:target>Package.Content.RealEstateValuation.Instructor</lx:target>
                                <lx:target>Package.Content.RealEstateValuation.PrimaryValuer</lx:target>
                                <lx:target>Package.Content.Application.SalesChannel.LoanWriter</lx:target>
                                <lx:target>Package.Content.Application.BusinessChannel.Contact</lx:target>
                              </lx:references>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="x_Context" type="referenceType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Pointer to the item that the comment refers to</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.DetailedComment.x_Context</lx:path>
                              <lx:label>Context</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                      </xs:complexType>
                    </xs:element>
                    <xs:element name="GeneralSecurityAgreement" minOccurs="0" maxOccurs="unbounded">
                      <xs:annotation>
                        <xs:documentation>General security agreement is used in commercial transactions and is a legal right granted by the grantor to a lender over the all existing and future assets of the grantor.</xs:documentation>
                        <xs:appinfo>
                          <lx:path>Package.Content.Application.GeneralSecurityAgreement</lx:path>
                          <lx:label>General Security Agreement</lx:label>
                          <li:transactions>ACC</li:transactions>
                        </xs:appinfo>
                      </xs:annotation>
                      <xs:complexType>
                        <xs:sequence>
                          <xs:element name="Duration" type="durationType" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Duration of general security agreement.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.GeneralSecurityAgreement.Duration</lx:path>
                                <lx:label>Duration</lx:label>
                                <li:transactions>ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                          </xs:element>
                          <xs:element name="Grantor" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>The grantor is the party (individual or organisation) who owns or has an interest in the personal property to which the security interest is attached.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.GeneralSecurityAgreement.Grantor</lx:path>
                                <lx:label>Grantor</lx:label>
                                <li:transactions>ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="x_Grantor" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The cross reference to the party (individual or organisation) who owns or has an interest in the personal property to which the security interest is attached.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.GeneralSecurityAgreement.Grantor.x_Grantor</lx:path>
                                    <lx:label>Grantor</lx:label>
                                    <li:transactions>ACC</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.CompanyApplicant</lx:target>
                                      <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                      <lx:target>Package.Content.Application.TrustApplicant</lx:target>
                                      <lx:target>Package.Content.Application.RelatedPerson</lx:target>
                                      <lx:target>Package.Content.Application.RelatedCompany</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                        </xs:sequence>
                        <xs:attribute name="Type" type="generalSecurityAgreementTypeList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The type of general security agreement.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.GeneralSecurityAgreement.Type</lx:path>
                              <lx:label>Type</lx:label>
                              <li:transactions>ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                          <xs:annotation>
                            <xs:documentation>System assigned unique identifier for this general security agreement.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.GeneralSecurityAgreement.UniqueID</lx:path>
                              <lx:label>UniqueID</lx:label>
                              <li:transactions>ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                      </xs:complexType>
                    </xs:element>
                    <xs:element name="Household" minOccurs="0" maxOccurs="unbounded">
                      <xs:annotation>
                        <xs:documentation>A household to which one or more person applicants belong, used in relation to the calculation of household living expenses</xs:documentation>
                        <xs:appinfo>
                          <lx:path>Package.Content.Application.Household</lx:path>
                          <lx:label>Household</lx:label>
                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                        </xs:appinfo>
                      </xs:annotation>
                      <xs:complexType>
                        <xs:sequence>
                          <xs:element name="Dependant" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>A person who depends on the applicant(s) for financial or other support</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Household.Dependant</lx:path>
                                <lx:label>Dependant</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="FinancialProvider" minOccurs="0" maxOccurs="unbounded">
                                  <xs:annotation>
                                    <xs:documentation>A party that provides financial support to the dependant.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.Household.Dependant.FinancialProvider</lx:path>
                                      <lx:label>Financial Provider</lx:label>
                                      <li:transactions>CAL,CDA,SVC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="x_Party" type="referenceType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>A cross reference to the party that provides financial support to the dependant.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Household.Dependant.FinancialProvider.x_Party</lx:path>
                                          <lx:label>Party</lx:label>
                                          <li:transactions>CAL,CDA,SVC</li:transactions>
                                          <lx:references>
                                            <lx:target>Package.Content.Application.RelatedPerson</lx:target>
                                            <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                          </lx:references>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="Age" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The age of the dependant at the time of submitting the application</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Household.Dependant.Age</lx:path>
                                    <lx:label>Age</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="DateOfBirth" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The dependant's date of birth</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Household.Dependant.DateOfBirth</lx:path>
                                    <lx:label>Date Of Birth</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Name" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The name of the dependant.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Household.Dependant.Name</lx:path>
                                    <lx:label>Dependant Name</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Unique Identifier for this Dependant Element</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Household.Dependant.UniqueID</lx:path>
                                    <lx:label>Unique ID</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="EducationExpenses" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Education expenses contains information about the number and type of students attending school or otherwise participating in study. May be used as an input into the calculation of deemed education expenses in the lender's of living expense allowance.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Household.EducationExpenses</lx:path>
                                <lx:label>Education Expenses</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="NumberOfAdultsInFullTimeStudy" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the number of adults participating in full-time study.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Household.EducationExpenses.NumberOfAdultsInFullTimeStudy</lx:path>
                                    <lx:label>Number Of Adults In Full Time Study</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="NumberOfAdultsInPartTimeStudy" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the number of adults participating in part-time study.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Household.EducationExpenses.NumberOfAdultsInPartTimeStudy</lx:path>
                                    <lx:label>Number Of Adults In Part Time Study</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="NumberOfChildrenInPrivateSchool" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the number of dependants (children) attending private school.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Household.EducationExpenses.NumberOfChildrenInPrivateSchool</lx:path>
                                    <lx:label>Number Of Children In Private School</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="NumberOfChildrenInPublicSchool" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the number of dependants (children) attending public school.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Household.EducationExpenses.NumberOfChildrenInPublicSchool</lx:path>
                                    <lx:label>Number Of Children In Public School</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="ExpenseDetails" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>The set of expenses declared for the household, including Living Expenses and Other Commitments.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Household.ExpenseDetails</lx:path>
                                <lx:label>Living Expenses</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="LivingExpense" minOccurs="0" maxOccurs="unbounded">
                                  <xs:annotation>
                                    <xs:documentation>Contains the details of a single line item that forms part of the household's declared living expenses.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.Household.ExpenseDetails.LivingExpense</lx:path>
                                      <lx:label>Living Expense Line Item</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:sequence>
                                      <xs:element name="PercentResponsible" type="percentOwnedType" minOccurs="0" maxOccurs="1">
                                        <xs:annotation>
                                          <xs:documentation>Where the party responsible for the expense needs to be established at an individual level, this element identifies the party that is responsible for the split and corresponding percentages. Each expense may be 'owned' by one or more parties, typically the applicants, so there may be more than one owner referenced. An expense may also be partially owned by a non-applicant, such as an applicant's spouse, in which case the third party owner may be referenced, or less than 100% ownership of the expense may be assigned.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.Household.ExpenseDetails.LivingExpense.PercentResponsible</lx:path>
                                            <lx:label>Percent Responsible</lx:label>
                                            <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                      </xs:element>
                                    </xs:sequence>
                                    <xs:attribute name="Amount" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The dollar amount of this particular living expense for the household as declared by the applicant.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Household.ExpenseDetails.LivingExpense.Amount</lx:path>
                                          <lx:label>Amount</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Category" type="livingExpenseCategoryList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The category that this declared living expense falls under.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Household.ExpenseDetails.LivingExpense.Category</lx:path>
                                          <lx:label>Living Expense Category</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Description" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>A plain text description that provides additional detail supporting the Living Expense for the household as declared by the applicant.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Household.ExpenseDetails.LivingExpense.Description</lx:path>
                                          <lx:label>Description</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="EndDate" type="dateType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Where this living expense has an end date, this attribute contains that anticipated end date.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Household.ExpenseDetails.LivingExpense.EndDate</lx:path>
                                          <lx:label>End Date</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Frequency" type="frequencyFullList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The frequency that corresponds to the declared amount for this particular Living Expense.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Household.ExpenseDetails.LivingExpense.Frequency</lx:path>
                                          <lx:label>Frequency</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="StartDate" type="dateType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Where this living expense starts in the future, this attribute contains the anticipated future start date.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Household.ExpenseDetails.LivingExpense.StartDate</lx:path>
                                          <lx:label>Start Date</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Unique Identifier for this living expense.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Household.ExpenseDetails.LivingExpense.UniqueID</lx:path>
                                          <lx:label>Unique ID</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="OtherCommitment" minOccurs="0" maxOccurs="unbounded">
                                  <xs:annotation>
                                    <xs:documentation>Contains the details of a single line item that forms part of the household's commitments other than living expenses.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.Household.ExpenseDetails.OtherCommitment</lx:path>
                                      <lx:label>Other Commitment Line Item</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:sequence>
                                      <xs:element name="PercentResponsible" type="percentOwnedType" minOccurs="0" maxOccurs="1">
                                        <xs:annotation>
                                          <xs:documentation>Where the party responsible for the commitment needs to be established at an individual level, this element identifies the party that is responsible for the split and corresponding percentages. Each commitment may be 'owned' by one or more parties, typically the applicants, so there may be more than one owner referenced. A commitment may also be partially owned by a non-applicant, such as an applicant's spouse, in which case the third party owner may be referenced, or less than 100% ownership of the commitment may be assigned.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.Household.ExpenseDetails.OtherCommitment.PercentResponsible</lx:path>
                                            <lx:label>Percent Responsible</lx:label>
                                            <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                      </xs:element>
                                    </xs:sequence>
                                    <xs:attribute name="Amount" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The dollar amount of this particular commitment for the household as declared by the applicant.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Household.ExpenseDetails.OtherCommitment.Amount</lx:path>
                                          <lx:label>Amount</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Category" type="otherCommitmentCategoryList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The category that this declared other commitment falls under.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Household.ExpenseDetails.OtherCommitment.Category</lx:path>
                                          <lx:label>Category</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Description" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>A plain text description that provides additional detail supporting the commitment for the household as declared by the applicant.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Household.ExpenseDetails.OtherCommitment.Description</lx:path>
                                          <lx:label>Description</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="EndDate" type="dateType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Where this commitment has an end date, this attribute contains that anticipated end date.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Household.ExpenseDetails.OtherCommitment.EndDate</lx:path>
                                          <lx:label>End Date</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Frequency" type="frequencyFullList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The frequency that corresponds to the declared amount for this particular commitment.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Household.ExpenseDetails.OtherCommitment.Frequency</lx:path>
                                          <lx:label>Frequency</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="IsContinuing" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Indicates that this commitment is continuing.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Household.ExpenseDetails.OtherCommitment.IsContinuing</lx:path>
                                          <lx:label>Is Continuing</lx:label>
                                          <li:transactions>CDA,SVC,LMI</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="StartDate" type="dateType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Where this commitment starts in the future, this attribute contains the anticipated future start date.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Household.ExpenseDetails.OtherCommitment.StartDate</lx:path>
                                          <lx:label>Business Start Date</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Unique Identifier for this commitment.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Household.ExpenseDetails.OtherCommitment.UniqueID</lx:path>
                                          <lx:label>Unique ID</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="TotalSystemCalculatedLivingExpenses" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The total system calculated living expenses. This may be calculated using the Household Expenditure Measure (HEM) or calculated using a different method.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.Household.ExpenseDetails.TotalSystemCalculatedLivingExpenses</lx:path>
                                      <lx:label>Total System Calculated Living Expenses</lx:label>
                                      <li:transactions>CAL,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="Amount" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The dollar amount of the total system calculated living expenses.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Household.ExpenseDetails.TotalSystemCalculatedLivingExpenses.Amount</lx:path>
                                          <lx:label>Amount</lx:label>
                                          <li:transactions>CAL,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Frequency" type="frequencyShortList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The frequency that corresponds to the amount for the total system calculated living expenses.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Household.ExpenseDetails.TotalSystemCalculatedLivingExpenses.Frequency</lx:path>
                                          <lx:label>Frequency</lx:label>
                                          <li:transactions>CAL,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="TotalUserStatedLivingExpenses" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The total living expenses declared by the application parties.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.Household.ExpenseDetails.TotalUserStatedLivingExpenses</lx:path>
                                      <lx:label>Total User Stated Living Expenses</lx:label>
                                      <li:transactions>CAL,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="Amount" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The dollar amount of the total user stated living expenses.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Household.ExpenseDetails.TotalUserStatedLivingExpenses.Amount</lx:path>
                                          <lx:label>Amount</lx:label>
                                          <li:transactions>CAL,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Frequency" type="frequencyShortList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The frequency that corresponds to the amount for total user stated living expenses.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Household.ExpenseDetails.TotalUserStatedLivingExpenses.Frequency</lx:path>
                                          <lx:label>Frequency</lx:label>
                                          <li:transactions>CAL,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="BrokerVerifiedExpense" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The broker has verified the expense amount.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Household.ExpenseDetails.BrokerVerifiedExpense</lx:path>
                                    <lx:label>Broker Verified Expense</lx:label>
                                    <li:transactions>CAL,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="BrokerVerifiedExpenseDetails" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Details given of the expenses and sources used to verify the expenses.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Household.ExpenseDetails.BrokerVerifiedExpenseDetails</lx:path>
                                    <lx:label>Broker Verified Expense Details</lx:label>
                                    <li:transactions>CAL,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="StatedLessThanCalculatedLivingExpensesDetails" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Details given when stated living expenses are less than calculated living expenses.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Household.ExpenseDetails.StatedLessThanCalculatedLivingExpensesDetails</lx:path>
                                    <lx:label>Stated Less Than Calculated Living Expenses Details</lx:label>
                                    <li:transactions>CAL,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                        </xs:sequence>
                        <xs:attribute name="Name" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>A descriptive name for the household</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Household.Name</lx:path>
                              <lx:label>Name</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="NumberOfAdults" type="integerType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The number of adults in the household</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Household.NumberOfAdults</lx:path>
                              <lx:label>Number Of Adults</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="NumberOfDependants" type="integerType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The number of dependants in this applicant household.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Household.NumberOfDependants</lx:path>
                              <lx:label>Number Of Dependants</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="SequenceNumber" type="integerType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The order of this household within the sequence.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Household.SequenceNumber</lx:path>
                              <lx:label>Sequence Number</lx:label>
                              <li:transactions>CAL,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Unique identification for the household</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Household.UniqueID</lx:path>
                              <lx:label>Unique ID</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                      </xs:complexType>
                    </xs:element>
                    <xs:element name="Insurance" minOccurs="0" maxOccurs="unbounded">
                      <xs:annotation>
                        <xs:documentation>Central insurance element capturing insurance details.</xs:documentation>
                        <xs:appinfo>
                          <lx:path>Package.Content.Application.Insurance</lx:path>
                          <lx:label>Insurance</lx:label>
                          <li:transactions>CAL,CDA,DAS,CNZ,LMI,VAL,ACC</li:transactions>
                        </xs:appinfo>
                      </xs:annotation>
                      <xs:complexType>
                        <xs:sequence>
                          <xs:element name="AssociatedLoanAccount" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>Wrapper element for the loan accounts associated with the insurance.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Insurance.AssociatedLoanAccount</lx:path>
                                <lx:label>Associated Loan Account</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="x_AssociatedLoanAccount" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The loan account that the insurance applies to</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Insurance.AssociatedLoanAccount.x_AssociatedLoanAccount</lx:path>
                                    <lx:label>Associated Loan Account</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.LoanDetails</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="CommissionPayable" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Wrapper element for the commission payable to the party writing the insurance policy.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Insurance.CommissionPayable</lx:path>
                                <lx:label>Commission Payable</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,LMI,VAL</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="Amount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The amount of commission to be paid to the party writing the insurance</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Insurance.CommissionPayable.Amount</lx:path>
                                    <lx:label>Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI,VAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Percentage" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates the percentage of commission payable</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Insurance.CommissionPayable.Percentage</lx:path>
                                    <lx:label>Percentage</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI,VAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_Payer" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A reference to the Lender who pays the commission</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Insurance.CommissionPayable.x_Payer</lx:path>
                                    <lx:label>Payer</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI,VAL</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.SalesChannel.Company</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="InsuredParty" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>Wrapper element for the insured party reference</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Insurance.InsuredParty</lx:path>
                                <lx:label>Insured Party</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,LMI,VAL</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="x_InsuredParty" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Contains a reference to an applicant or related party that is the insured party</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Insurance.InsuredParty.x_InsuredParty</lx:path>
                                    <lx:label>Insured Party</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI,VAL</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.CompanyApplicant</lx:target>
                                      <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                      <lx:target>Package.Content.Application.TrustApplicant</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="Premium" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Container element to capture insurance premium</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Insurance.Premium</lx:path>
                                <lx:label>Premium</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,LMI,VAL,ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="Amount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the insurance premium amount</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Insurance.Premium.Amount</lx:path>
                                    <lx:label>Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI,VAL,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Frequency" type="frequencyShortList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the insurance premium payment frequency</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Insurance.Premium.Frequency</lx:path>
                                    <lx:label>Frequency</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI,VAL,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="Term" type="durationType" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>The term of insurance cover. Applicable for limited term cover.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Insurance.Term</lx:path>
                                <lx:label>Term</lx:label>
                                <li:transactions>LMI</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                          </xs:element>
                        </xs:sequence>
                        <xs:attribute name="ApprovedDate" type="dateType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The date that the policy was approved.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Insurance.ApprovedDate</lx:path>
                              <lx:label>Approved Date</lx:label>
                              <li:transactions>LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="CustomerCode" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The customer code for this lenders mortgage insurance policy.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Insurance.CustomerCode</lx:path>
                              <lx:label>Customer Code</lx:label>
                              <li:transactions>LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="DeclinedByOther" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>This application for lenders mortgage insurance has been declined by another insurer.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Insurance.DeclinedByOther</lx:path>
                              <lx:label>Declined By Other</lx:label>
                              <li:transactions>LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="Description" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures a plain text description of the insurance when the selected Insurance Type = "Other"</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Insurance.Description</lx:path>
                              <lx:label>Description</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI,VAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="EffectiveDate" type="dateType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the date that the policy is effective from</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Insurance.EffectiveDate</lx:path>
                              <lx:label>Effective Date</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI,VAL,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="EquityAcceptable" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The conditions regarding the source of equity have been met.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Insurance.EquityAcceptable</lx:path>
                              <lx:label>Equity Acceptable</lx:label>
                              <li:transactions>LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ExpiryDate" type="dateType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the date that the policy expires</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Insurance.ExpiryDate</lx:path>
                              <lx:label>Expiry Date</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI,VAL,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="InsuranceType" type="insuranceTypeList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Defines the type of insurance held</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Insurance.InsuranceType</lx:path>
                              <lx:label>Insurance Type</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI,VAL,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="InsuredAmount" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Defines the amount insured</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Insurance.InsuredAmount</lx:path>
                              <lx:label>Insured Amount</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI,VAL,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="Insurer" type="insurerList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the name of insurer</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Insurance.Insurer</lx:path>
                              <lx:label>Insurer</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI,VAL,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="OtherInsurerName" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>For an Insurer not listed, the name of the Insurer</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Insurance.OtherInsurerName</lx:path>
                              <lx:label>Other Insurer Name</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI,VAL,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="PercentCoverRequired" type="percentType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The amount that is covered as a percentage of the total loan amount.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Insurance.PercentCoverRequired</lx:path>
                              <lx:label>Percent Cover Required</lx:label>
                              <li:transactions>LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="PolicyNumber" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the policy number</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Insurance.PolicyNumber</lx:path>
                              <lx:label>Policy Number</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI,VAL,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="PremiumInsured" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The premium amount will be covered by the insurance.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Insurance.PremiumInsured</lx:path>
                              <lx:label>Premium Insured</lx:label>
                              <li:transactions>LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ProductCode" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The product code for this lenders mortgage insurance policy.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Insurance.ProductCode</lx:path>
                              <lx:label>Product Code</lx:label>
                              <li:transactions>LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ProductName" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The name of the insurance product being offered by the provider.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Insurance.ProductName</lx:path>
                              <lx:label>Product Name</lx:label>
                              <li:transactions>LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="SequenceNumber" type="integerType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The order of this insurance within the sequence.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Insurance.SequenceNumber</lx:path>
                              <lx:label>Sequence Number</lx:label>
                              <li:transactions>CAL,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="UnderwritingType" type="underwritingTypeList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The underwriting type for this lenders mortgage insurance policy.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Insurance.UnderwritingType</lx:path>
                              <lx:label>Underwriting Type</lx:label>
                              <li:transactions>LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                          <xs:annotation>
                            <xs:documentation>System assigned unique identifier</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Insurance.UniqueID</lx:path>
                              <lx:label>Unique ID</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI,VAL,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                      </xs:complexType>
                    </xs:element>
                    <xs:element name="LendingGuarantee" minOccurs="0" maxOccurs="unbounded">
                      <xs:annotation>
                        <xs:documentation>A loan guarantee offered by one or more guarantors against one or more loan accounts, with or without security.</xs:documentation>
                        <xs:appinfo>
                          <lx:path>Package.Content.Application.LendingGuarantee</lx:path>
                          <lx:label>Lending Guarantee</lx:label>
                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,ACC</li:transactions>
                        </xs:appinfo>
                      </xs:annotation>
                      <xs:complexType>
                        <xs:sequence>
                          <xs:element name="AssociatedLoanAccount" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>The loan account(s) being secured with this guarantee</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LendingGuarantee.AssociatedLoanAccount</lx:path>
                                <lx:label>Associated Loan Account</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="x_AssociatedLoanAccount" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The loan account(s) being secured with this guarantee</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LendingGuarantee.AssociatedLoanAccount.x_AssociatedLoanAccount</lx:path>
                                    <lx:label>Associated Loan Account</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.LoanDetails</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="Guarantor" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>Wrapper element for the loan party providing the guarantee</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LendingGuarantee.Guarantor</lx:path>
                                <lx:label>Guarantor</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC,ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="Interview" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Information about the interview with the guarantor. Used to capture metadata about the interview itself rather than any content.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.Interview</lx:path>
                                      <lx:label>Interview</lx:label>
                                      <li:transactions>CAL</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="Date" type="dateType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The date that the guarantor interview takes place.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.Interview.Date</lx:path>
                                          <lx:label>Interview Date</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="IsFaceToFace" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The interview was conducted face to face with the guarantor.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.Interview.IsFaceToFace</lx:path>
                                          <lx:label>Face to Face</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="IsOnlyPersonPresent" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The guarantor was the only person present at the interview.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.Interview.IsOnlyPersonPresent</lx:path>
                                          <lx:label>Only Person Present</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="LoanWriterConfirmations" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Confirmation that the loan-writer has completed specific tasks with respect to the guarantor.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.LoanWriterConfirmations</lx:path>
                                      <lx:label>Loan Writer Confirmations</lx:label>
                                      <li:transactions>CAL</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="AdvisedDocumentsImminentIfSuccessful" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Confirmation that the loan-writer has advised the Guarantor that if this assessment is successful, they will receive their Guarantee documents shortly.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.LoanWriterConfirmations.AdvisedDocumentsImminentIfSuccessful</lx:path>
                                          <lx:label>Advised Documents Imminent If Successful</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="AdvisedIdentificationProcessRequired" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Confirmation that the loan-writer has advised the Guarantor that they must complete the applicable Customer Identification Process.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.LoanWriterConfirmations.AdvisedIdentificationProcessRequired</lx:path>
                                          <lx:label>Advised Identification Process Required</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="AdvisedInformationUsedInAssessment" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Confirmation that the loan-writer has advised the Guarantor that the information collected during the interview will now be as part of the final assessment of the loan application.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.LoanWriterConfirmations.AdvisedInformationUsedInAssessment</lx:path>
                                          <lx:label>Advised Information Used In Assessment</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="AdvisedOfWithdrawalInstructions" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Confirmation that the loan-writer has advised the Guarantor that if they wish to withdraw from this transaction before the funds are drawn, then they need to advise the lender as soon as possible.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.LoanWriterConfirmations.AdvisedOfWithdrawalInstructions</lx:path>
                                          <lx:label>Advised Of Withdrawal Instructions</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="CompletedStatementOfPosition" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Confirmation that the loan-writer has completed a Statement of Financial Position for the Guarantor.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.LoanWriterConfirmations.CompletedStatementOfPosition</lx:path>
                                          <lx:label>Completed Statement Of Position</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="ObtainedAgreementForJointStatementOfPosition" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Confirmation that the loan-writer has obtained agreement from both the borrower and the guarantor for the completion of a joint Statement of Position and that and each party has consented to the disclosure of his/her financial information to the other party.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.LoanWriterConfirmations.ObtainedAgreementForJointStatementOfPosition</lx:path>
                                          <lx:label>Obtained Agreement For Joint Statement Of Position</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="ObtainedElectronicCommunicationConsent" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Confirmation that the loan writer has obtained the completed and signed guarantor document electronic communication consent form.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.LoanWriterConfirmations.ObtainedElectronicCommunicationConsent</lx:path>
                                          <lx:label>Obtained Electronic Communication Consent</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="ObtainedSignedDeclaration" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Confirmation that the loan-writer has Obtained the Guarantor's signed Declaration.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.LoanWriterConfirmations.ObtainedSignedDeclaration</lx:path>
                                          <lx:label>Obtained Signed Declaration</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="VerifiedGuarantorIncome" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Confirmation that the loan-writer has verified the Guarantor's income according to the lender's policy.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.LoanWriterConfirmations.VerifiedGuarantorIncome</lx:path>
                                          <lx:label>Verified Guarantor Income</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="SecurityGuarantee" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Information about guarantor that relates specifically to a security guarantee.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.SecurityGuarantee</lx:path>
                                      <lx:label>Security Guarantee</lx:label>
                                      <li:transactions>CAL</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="ConfirmCouldMeetLoanRepayments" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Confirmation from the guarantor that if they were required to repay the guaranteed amount by borrowing funds, that they would be in a position to meet the loan repayments from their income in addition to reasonable living expenses.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.SecurityGuarantee.ConfirmCouldMeetLoanRepayments</lx:path>
                                          <lx:label>Confirmation that Guarantor Could Meet Loan Repayments</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="ConfirmWouldSellFamilyHome" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Confirmation from the guarantor that if they were required to repay the guaranteed amount, they would need to sell the family home to meet the commitment.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.SecurityGuarantee.ConfirmWouldSellFamilyHome</lx:path>
                                          <lx:label>Confirmation that Guarantor Would Need to Sell the Family Home</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="UnderstandsSecurityGuarantee" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Confirmation from the guarantor that they understand that should the borrower be unable to meet the commitments of the loan or fails to meet those commitments for any reason, that they may be required to pay the guaranteed amount.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.SecurityGuarantee.UnderstandsSecurityGuarantee</lx:path>
                                          <lx:label>Confirmation that Guarantor Understands the Security Guarantee</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="ServicingGuarantee" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Information about guarantor that relates specifically to a servicing guarantee.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.ServicingGuarantee</lx:path>
                                      <lx:label>Servicing Guarantee</lx:label>
                                      <li:transactions>CAL</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="ConfirmIsBenefitToFamily" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Confirmation from the loan writer that (where the guarantor is a parent or step-parent) by making funds available to the borrower to meet loan repayments there is some benefit for the guarantor or the family (for example by enabling the borrower to leave the family home and/or assisting in making the borrower more financially independent).</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.ServicingGuarantee.ConfirmIsBenefitToFamily</lx:path>
                                          <lx:label>Confirm Is Benefit To Family</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="ConfirmRelationshipToBorrower" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Confirmation from the loan writer that the relationship between the borrower (primary applicant) and the Guarantor captured at the Person level was specified correctly.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.ServicingGuarantee.ConfirmRelationshipToBorrower</lx:path>
                                          <lx:label>Confirm Relationship To Borrower</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="ConfirmUnderstandsBorrowerReliance" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Confirmation from the guarantor that they understand that the borrower is relying on payments from you to meet repayments for the proposed loan, and that the borrower's other independent income will not be sufficient to service the loan repayments.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.ServicingGuarantee.ConfirmUnderstandsBorrowerReliance</lx:path>
                                          <lx:label>Confirm Understands the Borrowers Reliance</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="ConfirmUnderstandsRepaymentsRequired" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Confirmation that the guarantor understands that throughout the term of the proposed loan they are expected to make repayments for the borrower, and that they are willing to do so.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.ServicingGuarantee.ConfirmUnderstandsRepaymentsRequired</lx:path>
                                          <lx:label>Confirm Understands that Repayments are Required</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="AccessType" type="guarantorAccessList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Specifies the level of access for each Guarantor.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.AccessType</lx:path>
                                    <lx:label>Access Type</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="AdvisedToSeekIndependentAdvice" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The loan writer confirms whether:the guarantor has been advised to seek independent legal and/or financial advice.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.AdvisedToSeekIndependentAdvice</lx:path>
                                    <lx:label>Advised To Seek Independent Advice</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="ConfirmNotUnderPressure" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The guarantor confirms that they are not under any pressure to provide this guarantee.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.ConfirmNotUnderPressure</lx:path>
                                    <lx:label>Confirm Not Under Pressure</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="DemonstratesReadingEnglish" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The guarantor can demonstrate that they read and speak English.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.DemonstratesReadingEnglish</lx:path>
                                    <lx:label>Understands English</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="DocumentationDeliveryMethod" type="documentationDeliveryMethodList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The guarantor's preferred method for the guarantee documents to be issued.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.DocumentationDeliveryMethod</lx:path>
                                    <lx:label>Documentation Delivery Method</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="IndependentAdviceTypeRequired" type="independentAdviceTypeRequiredList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The loan writer confirms the nature of the independent advice that the guarantor requires.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.IndependentAdviceTypeRequired</lx:path>
                                    <lx:label>Independent Advice Type Required</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="IsUnderPowerOfAttorney" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The guarantee is to be executed under power of attorney on behalf of an individual.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.IsUnderPowerOfAttorney</lx:path>
                                    <lx:label>Is Under Power Of Attorney</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PreferredCorrespondence" type="preferredCorrespondenceList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The preferred method for this guarantor to receive correspondence relating to this loan such as welcome letters, loan statements, arrears notifications, changes of interest rate notifications, and other notifications.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.PreferredCorrespondence</lx:path>
                                    <lx:label>Preferred Correspondence</lx:label>
                                    <li:transactions>ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="SuspectDifficultyUnderstandingEnglish" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The loan writer suspects that the guarantor does not understand the effect of the Guarantee because of language or literacy difficulties.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.SuspectDifficultyUnderstandingEnglish</lx:path>
                                    <lx:label>Suspect Difficulty Understanding English</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="SuspectDifficultyUnderstandingObligations" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The loan writer suspects that the guarantor is having difficulty understanding their obligations as Guarantor (for example if they are under the influence of alcohol, have impaired mental capacity, or have poor English).</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.SuspectDifficultyUnderstandingObligations</lx:path>
                                    <lx:label>Suspect Difficulty Understanding Obligations</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="SuspectMisrepresentation" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The loan writer suspects that the guarantor may be subject to misrepresentation as to why the Guarantee is needed.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.SuspectMisrepresentation</lx:path>
                                    <lx:label>Suspect Misrepresentation</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="SuspectUnderBorrowerInfluence" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The loan writer suspects that, due to the nature of the relationship between the Guarantor and the Borrower, the guarantor may be under the Borrower's influence to provide the Guarantee.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.SuspectUnderBorrowerInfluence</lx:path>
                                    <lx:label>Suspect Under Borrower Influence</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="SuspectUnderPressure" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The loan writer suspects that the guarantor is under pressure to give this Guarantee.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.SuspectUnderPressure</lx:path>
                                    <lx:label>Suspect Under Pressure</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="SuspectUnfairConduct" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The loan writer suspects that the guarantor is subject to unreasonable or unfair conduct by someone involved in this transaction.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.SuspectUnfairConduct</lx:path>
                                    <lx:label>Suspect Unfair Conduct</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="UnderstandsGuaranteeSigningPeriod" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The guarantor confirms that they understand that under the Banking Code of Practice they have at least three days to read and review the guarantee and other documents that are required to provide before returning the signed guarantee to the lender. If independent legal advice is obtained or another exception in the Banking Code of Practice applies, documents can be returned earlier.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.UnderstandsGuaranteeSigningPeriod</lx:path>
                                    <lx:label>Understands Guarantee Signing Period</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="UnderstandsGuarantorObligations" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The guarantor confirms that they understand the guarantee and their obligations as guarantor.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.UnderstandsGuarantorObligations</lx:path>
                                    <lx:label>Understands Guarantor Obligations</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_Guarantor" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The loan party providing the guarantee</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LendingGuarantee.Guarantor.x_Guarantor</lx:path>
                                    <lx:label>Guarantor</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,ACC</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.CompanyApplicant</lx:target>
                                      <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                      <lx:target>Package.Content.Application.TrustApplicant</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="Security" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>Wrapper element for the security offered</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LendingGuarantee.Security</lx:path>
                                <lx:label>Security</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="SecurityAgreement" type="securityAgreementType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Security agreement details for this security.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LendingGuarantee.Security.SecurityAgreement</lx:path>
                                      <lx:label>Security Agreement</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="Priority" type="securityPriorityList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The priority of this lender's mortgage on the security property.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LendingGuarantee.Security.Priority</lx:path>
                                    <lx:label>Priority</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>System assigned unique identifier.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LendingGuarantee.Security.UniqueID</lx:path>
                                    <lx:label>Unique ID</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_Security" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Security being offered, if any</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LendingGuarantee.Security.x_Security</lx:path>
                                    <lx:label>Security</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.NonRealEstateAsset</lx:target>
                                      <lx:target>Package.Content.Application.RealEstateAsset</lx:target>
                                      <lx:target>Package.Content.Application.GeneralSecurityAgreement</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                        </xs:sequence>
                        <xs:attribute name="CrossGuarantee" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The lending guarantee is a cross guarantee.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LendingGuarantee.CrossGuarantee</lx:path>
                              <lx:label>Cross Guarantee</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="IncomeLimitAmount" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>A dollar limit on the income amount that can be used as a servicing guarantee a for loan.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LendingGuarantee.IncomeLimitAmount</lx:path>
                              <lx:label>Income Limit Amount</lx:label>
                              <li:transactions>CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="IncomeLimitFrequency" type="frequencyShortList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The frequency of the income amount that can be used as a servicing guarantee a for loan.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LendingGuarantee.IncomeLimitFrequency</lx:path>
                              <lx:label>Income Limit Frequency</lx:label>
                              <li:transactions>CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="Limit" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The dollar limit on the portion of the guarantor security property that can be used as a lending guarantee for the loan.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LendingGuarantee.Limit</lx:path>
                              <lx:label>Limit</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="Limited" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The lending guarantee is a limited guarantee. The guarantor is not liable for the full amount of the loans covered by the lending guarantee.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LendingGuarantee.Limited</lx:path>
                              <lx:label>Limited</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="LimitedToFacilityAmount" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The guarantee is limited to the outstanding facility amount.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LendingGuarantee.LimitedToFacilityAmount</lx:path>
                              <lx:label>Limited To Facility Amount</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="SequenceNumber" type="integerType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The order of this lending guarantee within the sequence.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LendingGuarantee.SequenceNumber</lx:path>
                              <lx:label>Sequence Number</lx:label>
                              <li:transactions>CAL,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="Type" type="lendingGuaranteeTypeList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The type of guarantee that will be offered by the Guarantors in the application (security, income for serviceability or both).</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LendingGuarantee.Type</lx:path>
                              <lx:label>Type</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                          <xs:annotation>
                            <xs:documentation>System assigned unique identifier</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LendingGuarantee.UniqueID</lx:path>
                              <lx:label>Unique ID</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                      </xs:complexType>
                    </xs:element>
                    <xs:element name="Liability" minOccurs="0" maxOccurs="unbounded">
                      <xs:annotation>
                        <xs:documentation>A liability item is a debt owed to a creditor or lender - such as a loan, line of credit, or tax bill.</xs:documentation>
                        <xs:appinfo>
                          <lx:path>Package.Content.Application.Liability</lx:path>
                          <lx:label>Liability</lx:label>
                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                        </xs:appinfo>
                      </xs:annotation>
                      <xs:complexType>
                        <xs:sequence>
                          <xs:element name="AccountNumber" type="financialAccountType" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Account details of the liability</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Liability.AccountNumber</lx:path>
                                <lx:label>Account Number</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                          </xs:element>
                          <xs:element name="Arrears" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Container element for capturing Arrears detail</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Liability.Arrears</lx:path>
                                <lx:label>Arrears</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="Amount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the amount in arrears</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Arrears.Amount</lx:path>
                                    <lx:label>Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="NumberOfMissedPayments" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the number of missed payments</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Arrears.NumberOfMissedPayments</lx:path>
                                    <lx:label>Number Of Missed Payments</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="ContinuingRepayment" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>Details of the continuing repayment expense associated with this liability where it differs from the current repayment expense.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Liability.ContinuingRepayment</lx:path>
                                <lx:label>Continuing Repayment</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="LoanPaymentScheduleType" type="loanPaymentScheduleTypeList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The type of loan payment schedule.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.ContinuingRepayment.LoanPaymentScheduleType</lx:path>
                                    <lx:label>Loan Payment Schedule Type</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="MinimumAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The minimum amount that must be paid.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.ContinuingRepayment.MinimumAmount</lx:path>
                                    <lx:label>Minimum Amount</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PaymentTiming" type="paymentTimingList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates the timing of payments with respect to their payment period.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.ContinuingRepayment.PaymentTiming</lx:path>
                                    <lx:label>Payment Timing</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PaymentType" type="paymentTypeList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The type of repayment.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.ContinuingRepayment.PaymentType</lx:path>
                                    <lx:label>Payment Type</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="RemainingRepayments" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The total number of loan repayments.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.ContinuingRepayment.RemainingRepayments</lx:path>
                                    <lx:label>Total Repayments</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="RepaymentAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The repayment expense amount associated with repaying this liability.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.ContinuingRepayment.RepaymentAmount</lx:path>
                                    <lx:label>Repayment Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="RepaymentFrequency" type="repaymentFrequencyList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The payment frequency of the repayment associated with this liability.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.ContinuingRepayment.RepaymentFrequency</lx:path>
                                    <lx:label>Repayment Frequency</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TaxDeductible" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the expenses associated with this liability are tax deductible.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.ContinuingRepayment.TaxDeductible</lx:path>
                                    <lx:label>Tax Deductible</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>System assigned unique identifier.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.ContinuingRepayment.UniqueID</lx:path>
                                    <lx:label>Unique ID</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="DiscountMargin" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>The interest rate discount margin on the liability.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Liability.DiscountMargin</lx:path>
                                <lx:label>Discount Margin</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="DiscountedAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The interest rate discount margin as a dollar amount.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.DiscountMargin.DiscountedAmount</lx:path>
                                    <lx:label>Discounted Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="DiscountRate" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The interest rate discount margin as a percentage.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.DiscountMargin.DiscountRate</lx:path>
                                    <lx:label>Discount Rate</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="DiscountReason" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>An explanation of why the applicant qualifies for or is entitled to the discount claimed.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.DiscountMargin.DiscountReason</lx:path>
                                    <lx:label>Discount Reason</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Duration" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The duration over which the discount is to be applied.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.DiscountMargin.Duration</lx:path>
                                    <lx:label>Duration</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="DurationUnits" type="durationUnitsList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The units of time of the specified duration.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.DiscountMargin.DurationUnits</lx:path>
                                    <lx:label>Duration Units</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="SequenceNumber" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The order of this discount margin within the sequence.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.DiscountMargin.SequenceNumber</lx:path>
                                    <lx:label>Sequence Number</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="DocumentationInstructions" type="documentationInstructionsType" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Information specifying where correspondence is sent regarding this liability.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Liability.DocumentationInstructions</lx:path>
                                <lx:label>Documentation Instructions</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                          </xs:element>
                          <xs:element name="DSH" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Indicates whether this loan is a Defence Service Housing loan under the program between the Commonwealth Government and Westpac Banking Corporation.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Liability.DSH</lx:path>
                                <lx:label>DSH</lx:label>
                                <li:transactions>CAL,CDA,DAS</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="AssignmentCertificate" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Under the DSH loan program, a certificate of assignment assigns the subsidy that is paid by the Commonwealth to a credit provider if, in accordance with the certificate, the credit provider makes an advance to another person (the assignee). If there is an assignment certificate, the details of the certificate are captured here.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.DSH.AssignmentCertificate</lx:path>
                                    <lx:label>Assignment Certificate</lx:label>
                                    <li:transactions>CAL,CDA,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="EntitlementCertificate" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Under the Defence Services Housing loan program, a certificate of entitlement certifies that a subsidy is payable by the Commonwealth to the credit provider if, in accordance with the agreement, the credit provider makes that advance to the applicant or the assignee of the applicant. If there is an entitlement certificate, details of the certificate must be provided.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.DSH.EntitlementCertificate</lx:path>
                                    <lx:label>Entitlement Certificate</lx:label>
                                    <li:transactions>CAL,CDA,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="FileNumber" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Under the Defence Services Housing loan program, the Commonwealth's file number for the qualifying applicant.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.DSH.FileNumber</lx:path>
                                    <lx:label>File Number</lx:label>
                                    <li:transactions>CAL,CDA,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Subsidised" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates that the DSH loan being applied for is subsidised.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.DSH.Subsidised</lx:path>
                                    <lx:label>Subsidised</lx:label>
                                    <li:transactions>CAL,CDA,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Supplement" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates that the DSH loan being applied for is a supplement to an existing DSH loan, whereby additional available DSH loan funds are advanced to the applicant.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.DSH.Supplement</lx:path>
                                    <lx:label>Supplement</lx:label>
                                    <li:transactions>CAL,CDA,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="FeaturesSelected" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Contains information about the product features of the liability.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Liability.FeaturesSelected</lx:path>
                                <lx:label>Features Selected</lx:label>
                                <li:transactions>CAL</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="ExtraFeature" minOccurs="0" maxOccurs="unbounded">
                                  <xs:annotation>
                                    <xs:documentation>Information about a product feature of the liability.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.Liability.FeaturesSelected.ExtraFeature</lx:path>
                                      <lx:label>Extra Feature</lx:label>
                                      <li:transactions>CAL</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="Description" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Specific information, value or enumeration related to the specific feature (name).</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.FeaturesSelected.ExtraFeature.Description</lx:path>
                                          <lx:label>Description</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Name" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The name of the specific feature of the liability. Free text field although lenders may provide enumerations</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.FeaturesSelected.ExtraFeature.Name</lx:path>
                                          <lx:label>Name</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Unique Identifier for this Extra Feature Element</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.FeaturesSelected.ExtraFeature.UniqueID</lx:path>
                                          <lx:label>Unique ID</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="OffsetAccount" minOccurs="0" maxOccurs="unbounded">
                                  <xs:annotation>
                                    <xs:documentation>Identifies the BSB, Account Number and Account Name for the offset account.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.Liability.FeaturesSelected.OffsetAccount</lx:path>
                                      <lx:label>Offset Account</lx:label>
                                      <li:transactions>CAL</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:sequence>
                                      <xs:element name="AccountNumber" type="financialAccountType" minOccurs="0" maxOccurs="1">
                                        <xs:annotation>
                                          <xs:documentation>Account number details such as BSB, Account Number and Account Name for the offset account</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.Liability.FeaturesSelected.OffsetAccount.AccountNumber</lx:path>
                                            <lx:label>Account Number</lx:label>
                                            <li:transactions>CAL</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                      </xs:element>
                                    </xs:sequence>
                                    <xs:attribute name="IsExisting" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Indicates whether the Offset Account detailed is an existing Offset Account or not</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.FeaturesSelected.OffsetAccount.IsExisting</lx:path>
                                          <lx:label>Is Existing</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Unique Identifier for this Offset Account Element</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.FeaturesSelected.OffsetAccount.UniqueID</lx:path>
                                          <lx:label>Unique ID</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="x_Account" type="referenceType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>A cross reference to an account (a Non Real Estate Asset element) to be used as the offset account.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.FeaturesSelected.OffsetAccount.x_Account</lx:path>
                                          <lx:label>Account</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                          <lx:references>
                                            <lx:target>Package.Content.Application.NonRealEstateAsset</lx:target>
                                          </lx:references>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="ChequeBook" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant requests that a cheque book be issued for the loan account.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.FeaturesSelected.ChequeBook</lx:path>
                                    <lx:label>Cheque Book</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="CreditCard" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant has requested a credit card.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.FeaturesSelected.CreditCard</lx:path>
                                    <lx:label>Credit Card</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="DebitCard" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant has requested a debit card.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.FeaturesSelected.DebitCard</lx:path>
                                    <lx:label>Debit Card</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="DepositBook" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant has requested a deposit book</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.FeaturesSelected.DepositBook</lx:path>
                                    <lx:label>Deposit Book</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="HolidayLeave" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant requests that the loan product allows them to temporarily pause making repayments while they are not earning a regular income or for some other acceptable reason.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.FeaturesSelected.HolidayLeave</lx:path>
                                    <lx:label>Holiday Leave</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Offset" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant requests that a 100% offset account facility be established for the loan account.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.FeaturesSelected.Offset</lx:path>
                                    <lx:label>Offset</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="OffsetPercentage" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Specifies the percentage of the balance in the offset account that should be used to reduce the outstanding balance on the loan account when calculating interest payable. Typically 100%, but some lenders offer partial offset accounts.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.FeaturesSelected.OffsetPercentage</lx:path>
                                    <lx:label>Offset Percentage</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="ParentalLeave" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant requests that the loan product allows them to reduce their repayments while they are not earning a regular income because they are taking maternity/parental leave.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.FeaturesSelected.ParentalLeave</lx:path>
                                    <lx:label>Parental Leave</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PartialOffset" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant requests that an offset account be established for the loan account with less than 100% offset of the balance in the offset account against the outstanding loan balance.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.FeaturesSelected.PartialOffset</lx:path>
                                    <lx:label>Partial Offset</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Portability" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant requests that the loan facility be portable between security properties.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.FeaturesSelected.Portability</lx:path>
                                    <lx:label>Portability</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="ProgressiveDraw" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant requests that the loan funds be drawn down progressively, typically against progress of stages under a construction contract.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.FeaturesSelected.ProgressiveDraw</lx:path>
                                    <lx:label>Progressive Draw</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="RateLock" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant requests that the interest rate for a fixed rate product be 'locked' until settlement</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.FeaturesSelected.RateLock</lx:path>
                                    <lx:label>Rate Lock</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Redraw" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant requests that the loan product permit the redraw of loan principal that has been repaid in advance of the amortisation schedule for the loan.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.FeaturesSelected.Redraw</lx:path>
                                    <lx:label>Redraw</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="SplitLoan" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates that the applicant requests that the loan amount be split between two or more separate accounts or split facilities.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.FeaturesSelected.SplitLoan</lx:path>
                                    <lx:label>Split Loan</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="LendingPurpose" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>The purpose for which the applicant intends to use the loan funds.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Liability.LendingPurpose</lx:path>
                                <lx:label>Lending Purpose</lx:label>
                                <li:transactions>CAL,CDA,DAS</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="ABSLendingPurpose" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The free text description of the ABS Lending Purpose Code.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.LendingPurpose.ABSLendingPurpose</lx:path>
                                    <lx:label>ABS Lending Purpose</lx:label>
                                    <li:transactions>CAL,CDA,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="ABSLendingPurposeCode" type="absLendingPurposeCodeList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The ABS code for this purpose for which the loan funds will be used by the applicant.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.LendingPurpose.ABSLendingPurposeCode</lx:path>
                                    <lx:label>ABS Lending Purpose Code</lx:label>
                                    <li:transactions>CAL,CDA,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Description" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A description of the purpose if none of the purposes specified in the lender's enumerated list of purposes adequately described the true purpose.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.LendingPurpose.Description</lx:path>
                                    <lx:label>Description</lx:label>
                                    <li:transactions>CAL,CDA,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="LenderCode" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The lender-specified code for this purpose for which the loan funds will be used by the applicant.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.LendingPurpose.LenderCode</lx:path>
                                    <lx:label>Lender Code</lx:label>
                                    <li:transactions>CAL,CDA,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="OriginalAmountRequestedInForeignCurrency" type="amountInForeignCurrencyType" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>The original loan amount as requested in a foreign currency, being the credit limit for a line of credit, or the fully drawn principal amount for an amortising loan.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Liability.OriginalAmountRequestedInForeignCurrency</lx:path>
                                <lx:label>Original Amount Requested In Foreign Currency</lx:label>
                                <li:transactions>CAL</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                          </xs:element>
                          <xs:element name="OriginalTerm" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Details of the original term of the credit product and any introductory terms, such as an interest only term or a fixed rate term that applies for an initial period at the start of the product.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Liability.OriginalTerm</lx:path>
                                <lx:label>OriginalTerm</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="DistinctLoanPeriod" minOccurs="0" maxOccurs="unbounded">
                                  <xs:annotation>
                                    <xs:documentation>A distinct loan period, where each period may have a different payment type, interest type, rate composition.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.Liability.OriginalTerm.DistinctLoanPeriod</lx:path>
                                      <lx:label>Distinct Loan Period</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:sequence>
                                      <xs:element name="Duration" type="durationType" minOccurs="0" maxOccurs="1">
                                        <xs:annotation>
                                          <xs:documentation>The duration of the distinct loan period.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.Liability.OriginalTerm.DistinctLoanPeriod.Duration</lx:path>
                                            <lx:label>Duration</lx:label>
                                            <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                      </xs:element>
                                      <xs:element name="Repayment" minOccurs="0" maxOccurs="unbounded">
                                        <xs:annotation>
                                          <xs:documentation>A repayment that is made during this period.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.Liability.OriginalTerm.DistinctLoanPeriod.Repayment</lx:path>
                                            <lx:label>Repayment</lx:label>
                                            <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                        <xs:complexType>
                                          <xs:attribute name="x_ContinuingRepayment" type="referenceType" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>A cross reference to the continuing repayment.</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.Liability.OriginalTerm.DistinctLoanPeriod.Repayment.x_ContinuingRepayment</lx:path>
                                                <lx:label>Repayment</lx:label>
                                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                                <lx:references>
                                                  <lx:target>Package.Content.Application.Liability.ContinuingRepayment</lx:target>
                                                </lx:references>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                          <xs:attribute name="x_Repayment" type="referenceType" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>A cross reference to the repayment.</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.Liability.OriginalTerm.DistinctLoanPeriod.Repayment.x_Repayment</lx:path>
                                                <lx:label>Repayment</lx:label>
                                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                                <lx:references>
                                                  <lx:target>Package.Content.Application.Liability.Repayment</lx:target>
                                                </lx:references>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                        </xs:complexType>
                                      </xs:element>
                                    </xs:sequence>
                                    <xs:attribute name="EndDate" type="dateType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The end date of the distinct loan period.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.OriginalTerm.DistinctLoanPeriod.EndDate</lx:path>
                                          <lx:label>End Date</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="InterestType" type="interestTypeList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The type of interest that is to be paid during the distinct loan period.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.OriginalTerm.DistinctLoanPeriod.InterestType</lx:path>
                                          <lx:label>Interest Type</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="PaymentType" type="paymentTypeList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The type of repayment that is to be made during the distinct loan period.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.OriginalTerm.DistinctLoanPeriod.PaymentType</lx:path>
                                          <lx:label>Payment Type</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="SequenceNumber" type="integerType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The order of this distinct loan period within the sequence.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.OriginalTerm.DistinctLoanPeriod.SequenceNumber</lx:path>
                                          <lx:label>Sequence Number</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="StartDate" type="dateType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The start date of the distinct loan period.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.OriginalTerm.DistinctLoanPeriod.StartDate</lx:path>
                                          <lx:label>Start Date</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>System assigned unique identifier.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.OriginalTerm.DistinctLoanPeriod.UniqueID</lx:path>
                                          <lx:label>Unique ID</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="x_RateComposition" type="referenceType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>A cross reference to the rate composition for this distinct loan period.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.OriginalTerm.DistinctLoanPeriod.x_RateComposition</lx:path>
                                          <lx:label>Rate Composition</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                          <lx:references>
                                            <lx:target>Package.Content.Application.Liability.RateComposition</lx:target>
                                          </lx:references>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="InterestOnlyEndDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The date when the applicant will stop/stopped making Interest Only repayments on this liability.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.OriginalTerm.InterestOnlyEndDate</lx:path>
                                    <lx:label>Interest Only End Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="InterestType" type="interestTypeList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the original type of interest of the liability.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.OriginalTerm.InterestType</lx:path>
                                    <lx:label>Interest Type</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="InterestTypeDuration" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The original duration of the fixed interest rate period, as a whole number multiple of the Units.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.OriginalTerm.InterestTypeDuration</lx:path>
                                    <lx:label>Interest Type Duration</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="InterestTypeUnits" type="loanTermUnitsList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The units of time that are used to define the duration of the fixed interest rate period.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.OriginalTerm.InterestTypeUnits</lx:path>
                                    <lx:label>Interest Type Units</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PaymentType" type="paymentTypeList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the original type of repayment of the liability.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.OriginalTerm.PaymentType</lx:path>
                                    <lx:label>Payment Type</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PaymentTypeDuration" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The original duration of the interest only period, as a whole number multiple of the Units.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.OriginalTerm.PaymentTypeDuration</lx:path>
                                    <lx:label>Payment Type Duration</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PaymentTypeUnits" type="loanTermUnitsList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The units of time that are used to define the duration of the interest only period.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.OriginalTerm.PaymentTypeUnits</lx:path>
                                    <lx:label>Payment Type Units</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="RolloverPeriodDuration" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The duration of the rollover period for a commercial bill.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.OriginalTerm.RolloverPeriodDuration</lx:path>
                                    <lx:label>RolloverPeriodDuration</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="RolloverPeriodUnits" type="loanTermUnitsList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The units of time that are used to define the rollover period for a commercial bill.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.OriginalTerm.RolloverPeriodUnits</lx:path>
                                    <lx:label>RolloverPeriodUnits</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TotalTermDuration" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the original duration of the total term, as a multiple of the units.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.OriginalTerm.TotalTermDuration</lx:path>
                                    <lx:label>Total Term Duration</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TotalTermUnits" type="loanTermUnitsList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The units of time that are used to define the duration of the total term.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.OriginalTerm.TotalTermUnits</lx:path>
                                    <lx:label>Total Term Units</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="Package" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Contains information about a package option that previously was part of the lender's offer.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Liability.Package</lx:path>
                                <lx:label>Package</lx:label>
                                <li:transactions>CAL,CDA,CNZ,DAS</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="Category" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Category in which the package was offered by the lender.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Package.Category</lx:path>
                                    <lx:label>Category</lx:label>
                                    <li:transactions>CAL,CDA,CNZ,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Code" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A unique code representing the product package that was offered by the lender.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Package.Code</lx:path>
                                    <lx:label>Code</lx:label>
                                    <li:transactions>CAL,CDA,CNZ,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="MemberID" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Membership identifier of the applicant issued by the Organisation the applicant claims to belong to.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Package.MemberID</lx:path>
                                    <lx:label>Member ID</lx:label>
                                    <li:transactions>CAL,CDA,CNZ,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Name" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Name of a package that the applicant previously applied for.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Package.Name</lx:path>
                                    <lx:label>Name</lx:label>
                                    <li:transactions>CAL,CDA,CNZ,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="OptionCode" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A unique code identifying an option that previously applied to a package.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Package.OptionCode</lx:path>
                                    <lx:label>Option Code</lx:label>
                                    <li:transactions>CAL,CDA,CNZ,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Organisation" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A code or name that identifies the organisation under which the package was offered.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Package.Organisation</lx:path>
                                    <lx:label>Organisation</lx:label>
                                    <li:transactions>CAL,CDA,CNZ,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="PercentOwned" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Identifies the party/s that are responsible for the liability and the amount they are responsible for, either as a borrower or guarantor.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Liability.PercentOwned</lx:path>
                                <lx:label>Percent Owned</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="Owner" minOccurs="0" maxOccurs="unbounded">
                                  <xs:annotation>
                                    <xs:documentation>The details of the ownership of this liability, either as borrower or guarantor.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.Liability.PercentOwned.Owner</lx:path>
                                      <lx:label>Owner</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="OwnerType" type="applicantTypeList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Describes whether the linked party is a borrower or guarantor on this liability.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.PercentOwned.Owner.OwnerType</lx:path>
                                          <lx:label>Owner Type</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Percent" type="percentType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Captures the percentage of the liability that the linked party is responsible for.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.PercentOwned.Owner.Percent</lx:path>
                                          <lx:label>Percent</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="x_Party" type="referenceType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>A reference to a party that is an responsible for the liability.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.PercentOwned.Owner.x_Party</lx:path>
                                          <lx:label>Party</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                          <lx:references>
                                            <lx:target>Package.Content.Application.CompanyApplicant</lx:target>
                                            <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                            <lx:target>Package.Content.Application.TrustApplicant</lx:target>
                                          </lx:references>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="Proportions" type="proportionsList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Flag to indicate whether the ownership proportions are equal across all owners, specified individually for each one, or not specified.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.PercentOwned.Proportions</lx:path>
                                    <lx:label>Proportions</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="RateComposition" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>The structure of the interest rate to the borrower, based on the delivery rate with applied margins</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Liability.RateComposition</lx:path>
                                <lx:label>Rate Composition</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="BaseRate" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The base rate on which other rates are calculated.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.Liability.RateComposition.BaseRate</lx:path>
                                      <lx:label>Base Rate</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="Code" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The base rate code.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.RateComposition.BaseRate.Code</lx:path>
                                          <lx:label>Code</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Name" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The base rate name.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.RateComposition.BaseRate.Name</lx:path>
                                          <lx:label>Name</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Rate" type="percentType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The base rate as a percentage.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.RateComposition.BaseRate.Rate</lx:path>
                                          <lx:label>Rate</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="CustomerRiskMargin" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The customer risk margin added (as a percentage) based on the risk the customer presents to the bank.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.RateComposition.CustomerRiskMargin</lx:path>
                                    <lx:label>Customer Risk Margin</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="DisclosedToCustomer" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The details of the rate are disclosed to the customer.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.RateComposition.DisclosedToCustomer</lx:path>
                                    <lx:label>Disclosed To Customer</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="IntroductoryMargin" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The introductory margin added (as a percentage) during the introductory period or honeymoon period.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.RateComposition.IntroductoryMargin</lx:path>
                                    <lx:label>Introductory Margin</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="NetCustomerRiskMargin" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The customer risk margin minus the discount margin (as a percentage).</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.RateComposition.NetCustomerRiskMargin</lx:path>
                                    <lx:label>Net Customer Risk Margin</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PaymentTypeMargin" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The payment type margin added (as a percentage) based on the payment type.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.RateComposition.PaymentTypeMargin</lx:path>
                                    <lx:label>Payment Type Margin</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PricingConstruct" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The pricing construct used to calculate the Total Interest Rate. For example, Base Rate + Term Premium + Product Margin + Customer Risk Margin.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.RateComposition.PricingConstruct</lx:path>
                                    <lx:label>Pricing Construct</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="ProductMargin" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The product margin added (as a percentage) based on the specific product type.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.RateComposition.ProductMargin</lx:path>
                                    <lx:label>Product Margin</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TermPremium" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The term premium added (as a percentage) based on the loan term.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.RateComposition.TermPremium</lx:path>
                                    <lx:label>Term Premium</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TotalInterestRate" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The total interest rate for this rate composition scheme.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.RateComposition.TotalInterestRate</lx:path>
                                    <lx:label>Total Interest Rate</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>System assigned unique identifier.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.RateComposition.UniqueID</lx:path>
                                    <lx:label>Unique ID</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="RemainingTerm" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Container element for capturing the remaining term of liabilities not being refinanced.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Liability.RemainingTerm</lx:path>
                                <lx:label>Remaining Term</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="Duration" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The duration of the remaining term.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.RemainingTerm.Duration</lx:path>
                                    <lx:label>Duration</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Units" type="loanTermUnitsList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The units used to define the duration of the remaining term.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.RemainingTerm.Units</lx:path>
                                    <lx:label>Units of Remaining Term Duration</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="Repayment" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>Details of the repayment expense associated with this loan</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Liability.Repayment</lx:path>
                                <lx:label>Repayment</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="InterestPayment" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>This payment covers the interest amount.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Repayment.InterestPayment</lx:path>
                                    <lx:label>Interest Payment</lx:label>
                                    <li:transactions>CAL,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="LoanPaymentScheduleType" type="loanPaymentScheduleTypeList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The type of loan payment schedule.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Repayment.LoanPaymentScheduleType</lx:path>
                                    <lx:label>Loan Payment Schedule Type</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="MinimumAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The minimum amount that must be paid.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Repayment.MinimumAmount</lx:path>
                                    <lx:label>Minimum Amount</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PaymentTiming" type="paymentTimingList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates the timing of payments with respect to their payment period.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Repayment.PaymentTiming</lx:path>
                                    <lx:label>Payment Timing</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PaymentType" type="paymentTypeList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the type of repayment that is to be made during the specified term</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Repayment.PaymentType</lx:path>
                                    <lx:label>Payment Type</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PrincipalPayment" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>This payment reduces the principal amount.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Repayment.PrincipalPayment</lx:path>
                                    <lx:label>Principal Payment</lx:label>
                                    <li:transactions>CAL,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Regular" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Flag to indicate whether payments are regular (same amount on regular intervals) or structured (irregular intervals and/or amounts).</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Repayment.Regular</lx:path>
                                    <lx:label>Regular</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="RemainingRepayments" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The total number of loan repayments.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Repayment.RemainingRepayments</lx:path>
                                    <lx:label>Total Repayments</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="RepaymentAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The repayment expense amount associated with repaying this loan</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Repayment.RepaymentAmount</lx:path>
                                    <lx:label>Repayment Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="RepaymentFrequency" type="repaymentFrequencyList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The payment frequency of the repayment associated with this loan</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Repayment.RepaymentFrequency</lx:path>
                                    <lx:label>Repayment Frequency</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TaxDeductible" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the expenses associated with a liability are tax deductible (yes) or not tax deductible (no)</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Repayment.TaxDeductible</lx:path>
                                    <lx:label>Tax Deductible</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>System assigned unique identifier.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Repayment.UniqueID</lx:path>
                                    <lx:label>Unique ID</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="Security" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>Details to identify the security property for the loan</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Liability.Security</lx:path>
                                <lx:label>Security</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="MortgagorDetails" minOccurs="0" maxOccurs="unbounded">
                                  <xs:annotation>
                                    <xs:documentation>Details of the mortgagor(s) for the security for the liability</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.Liability.Security.MortgagorDetails</lx:path>
                                      <lx:label>Mortgagor Details</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="ChangeNameFormRequired" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Flag to indicate whether a change of name form is required for the mortgage document</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.Security.MortgagorDetails.ChangeNameFormRequired</lx:path>
                                          <lx:label>Change Name Form Required</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Name" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The name of the mortgagor matching the existing name on the record</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.Security.MortgagorDetails.Name</lx:path>
                                          <lx:label>Name</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="ReasonForDifferentName" type="reasonForDifferentNameList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The reason the name of the mortgagor does not match the name on the certificate of title. Only applicable in Victoria.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.Security.MortgagorDetails.ReasonForDifferentName</lx:path>
                                          <lx:label>Reason For Different Name</lx:label>
                                          <li:transactions>CAL,CDA,DAS</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="x_Mortgagor" type="referenceType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Reference link to a mortgagor for the security. If a change of name is required, the new name will be constructed from the granular name fields of the linked Party</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.Liability.Security.MortgagorDetails.x_Mortgagor</lx:path>
                                          <lx:label>Mortgagor</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                          <lx:references>
                                            <lx:target>Package.Content.Application.CompanyApplicant</lx:target>
                                            <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                            <lx:target>Package.Content.Application.RelatedCompany</lx:target>
                                            <lx:target>Package.Content.Application.RelatedPerson</lx:target>
                                            <lx:target>Package.Content.Application.TrustApplicant</lx:target>
                                          </lx:references>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="SecurityAgreement" type="securityAgreementType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Security agreement details for this security.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.Liability.Security.SecurityAgreement</lx:path>
                                      <lx:label>Security Agreement</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="MortgageNumber" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The identifying number of the mortgage that links the security to the loan</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Security.MortgageNumber</lx:path>
                                    <lx:label>Mortgage Number</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Priority" type="securityPriorityList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The priority of this lender's mortgage on the security property</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Security.Priority</lx:path>
                                    <lx:label>Priority</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PriorityAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The maximum dollar amount that the mortgagee is entitled to recover under the mortgage, to repay loaned funds including principal, interest and fees.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Security.PriorityAmount</lx:path>
                                    <lx:label>Priority Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="RequiresOriginalMortgageDocument" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates that the original mortgage document will be required for the mortgage to be discharged.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Security.RequiresOriginalMortgageDocument</lx:path>
                                    <lx:label>Requires Original Mortgage Document</lx:label>
                                    <li:transactions>CAL,CDA,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="SignedDocumentsRequired" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Signed documents will be required for this security.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Security.SignedDocumentsRequired</lx:path>
                                    <lx:label>Signed Documents Required</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>System assigned unique identifier.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Security.UniqueID</lx:path>
                                    <lx:label>Unique ID</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_Security" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Contains a reference link to the security (real estate or non real estate asset)</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Security.x_Security</lx:path>
                                    <lx:label>Security</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.NonRealEstateAsset</lx:target>
                                      <lx:target>Package.Content.Application.RealEstateAsset</lx:target>
                                      <lx:target>Package.Content.Application.GeneralSecurityAgreement</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="Software" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>The software application used by the liability originator.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Liability.Software</lx:path>
                                <lx:label>Software</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="Description" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A description of the software provider, for example the company name.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Software.Description</lx:path>
                                    <lx:label>Description</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Name" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The name of the software application used by the liability originator.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.Software.Name</lx:path>
                                    <lx:label>Name</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="TermsAndConditions" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>The terms and conditions of a loan contract or loan application.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.Liability.TermsAndConditions</lx:path>
                                <lx:label>Terms And Conditions</lx:label>
                                <li:transactions>CAL,DAS</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="TermsCode" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The code used to identify the terms and conditions in the lender's system.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.TermsAndConditions.TermsCode</lx:path>
                                    <lx:label>TermsCode</lx:label>
                                    <li:transactions>CAL,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TermsName" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The name used by the lender for this set of terms and conditions.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.Liability.TermsAndConditions.TermsName</lx:path>
                                    <lx:label>TermsName</lx:label>
                                    <li:transactions>CAL,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                        </xs:sequence>
                        <xs:attribute name="AccelerationPercentage" type="percentType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The amount that is provided to the borrower as a percentage of the total amount that is provided from the invoices for an invoice financing loan.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.AccelerationPercentage</lx:path>
                              <lx:label>Acceleration Percentage</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="AnnualInterestRate" type="percentType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the annual interest rate that applies to the liability</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.AnnualInterestRate</lx:path>
                              <lx:label>Annual Interest Rate</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="AvailableForRedrawAmount" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Advance or additional repayments that reduce the balance on a loan that are available to be redrawn at a later date.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.AvailableForRedrawAmount</lx:path>
                              <lx:label>Available For Redraw Amount</lx:label>
                              <li:transactions>CAL,CDA,SVC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="BalloonRepaymentAmount" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The nominated balloon repayment amount.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.BalloonRepaymentAmount</lx:path>
                              <lx:label>Balloon Repayment Amount</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="BalloonRepaymentDate" type="dateType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The expected date of the balloon repayment.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.BalloonRepaymentDate</lx:path>
                              <lx:label>Balloon Repayment Date</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ClearingFromOtherSource" type="clearingFromOtherSourceList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates whether the existing liability will be cleared, in whole or in part, using funds from a third party institution.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.ClearingFromOtherSource</lx:path>
                              <lx:label>Clearing From Other Source</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ClearingFromOtherSourceAmount" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the exact amount that will be refinanced for this liability using funds from a source that is not the new loan.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.ClearingFromOtherSourceAmount</lx:path>
                              <lx:label>Clearing from Other Source Amount</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ClearingFromThisLoan" type="clearingFromThisLoanList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates whether the existing loan will be cleared, in whole or in part, using funds from the loan being applied for.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.ClearingFromThisLoan</lx:path>
                              <lx:label>Clearing From This Loan</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ClearingFromThisLoanAmount" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the exact amount that will be refinanced for this liability using funds sourced from a new loan.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.ClearingFromThisLoanAmount</lx:path>
                              <lx:label>Clearing from This Loan Amount</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ClosingOnSettlement" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>This revolving liability will be closed on settlement.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.ClosingOnSettlement</lx:path>
                              <lx:label>Closing On Settlement</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="CreditCardType" type="creditCardTypeList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates the type of credit card</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.CreditCardType</lx:path>
                              <lx:label>Credit Card Type</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="CreditLimit" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the limit for a credit card or a line of credit, or the scheduled balance for an amortising loan. This is typically the balance that the lender uses to assess the liability as the borrower is likely able to draw funds up to the limit, or to redraw principal repaid ahead of the scheduled balance.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.CreditLimit</lx:path>
                              <lx:label>Credit Limit</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="CreditRiskGrade" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>A credit risk grade can be used to specify how likely the liability is to experience events such as payment defaults based on its history. A higher risk grade generally indicates higher risk.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.CreditRiskGrade</lx:path>
                              <lx:label>Credit Risk Grade</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="Description" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures a free text description of the liability when the selected Liability Type = "Other".</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.Description</lx:path>
                              <lx:label>Description</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="HasArrears" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The applicant or financial system has declared a current arrears credit issue on this liability.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.HasArrears</lx:path>
                              <lx:label>Has Arrears</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="HasPreviousArrears" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Used to indicate if the applicant or financial system has declared a previous arrears Credit Issue against this liability.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.HasPreviousArrears</lx:path>
                              <lx:label>Has Previous Arrears</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="HasUndrawnFunds" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates whether the liability has any undrawn funds.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.HasUndrawnFunds</lx:path>
                              <lx:label>Has Undrawn Funds</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="InAdvanceAmount" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Advance or additional repayments that reduce the balance on a loan.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.InAdvanceAmount</lx:path>
                              <lx:label>In Advance Amount</lx:label>
                              <li:transactions>CAL,CDA</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="InterestCalculationFrequency" type="interestChargeFrequencyList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The frequency at which interest is calculated on the loan.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.InterestCalculationFrequency</lx:path>
                              <lx:label>Interest Calculation Frequency</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="InterestChargeFrequency" type="interestChargeFrequencyList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The frequency at which interest is charged on the loan.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.InterestChargeFrequency</lx:path>
                              <lx:label>Interest Charge Frequency</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="IsOriginalAmountRequestedInForeignCurrency" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>A flag to indicate that the original amount was requested in a foreign currency.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.IsOriginalAmountRequestedInForeignCurrency</lx:path>
                              <lx:label>Is New Limit Requested In Foreign Currency</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="LenderAssessmentReason" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>A free text description of the reason the liability record requires assessment by the lender.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.LenderAssessmentReason</lx:path>
                              <lx:label>Lender Assessment Reason</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="LenderAssessmentRequired" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>A flag to indicate the liability record requires assessment by the lender.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.LenderAssessmentRequired</lx:path>
                              <lx:label>Lender Assessment Required</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="LimitExceededCurrently" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates whether the liability's limit is currently exceeded.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.LimitExceededCurrently</lx:path>
                              <lx:label>Limit Exceeded Currently</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="LimitExceededPreviously" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates whether the liability's limit previously been exceeded.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.LimitExceededPreviously</lx:path>
                              <lx:label>Limit Exceeded Previously</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="LVR" type="percentType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Liability's loan to value ratio.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.LVR</lx:path>
                              <lx:label>LVR</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI,VAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="MaturityDate" type="dateType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The maturity date of the loan.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.MaturityDate</lx:path>
                              <lx:label>Maturity Date</lx:label>
                              <li:transactions>CAL,CDA,DAS</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="MinimumRepaymentRate" type="percentType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The percentage rate used to calculate the minimum repayment for the liability.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.MinimumRepaymentRate</lx:path>
                              <lx:label>Minimum Repayment Rate</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="NCCPStatus" type="nccpStatusList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The status of the liability as regulated or unregulated under the NCCP.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.NCCPStatus</lx:path>
                              <lx:label>NCCP Status</lx:label>
                              <li:transactions>CAL,CDA,DAS</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="NegativelyGeared" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures if the Liability is used to a negatively geared tax liability.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.NegativelyGeared</lx:path>
                              <lx:label>Negatively Geared</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="NegativelyGearedPercentage" type="percentType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the percentage of the liability used for negative gearing.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.NegativelyGearedPercentage</lx:path>
                              <lx:label>Negatively Geared Percentage</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="NewLimit" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the new limit of the liability when the applicant proposes that they will reduce the limit prior to or at settlement of the loan application.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.NewLimit</lx:path>
                              <lx:label>New Limit</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="NonCapitalisedInterest" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The dollar amount of the interest that has been accrued for the loan but has not yet been charged.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.NonCapitalisedInterest</lx:path>
                              <lx:label>Non Capitalised Interest</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="OriginalAmount" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the original loan amount, being the credit limit for a line of credit, or the fully drawn principal amount for an amortising loan.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.OriginalAmount</lx:path>
                              <lx:label>Original Amount</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="OriginalLoanPurpose" type="primaryPurposeLoanPurposeList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the original loan purpose</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.OriginalLoanPurpose</lx:path>
                              <lx:label>Original Loan Purpose</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="OriginationDate" type="dateType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The origination date of the liability.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.OriginationDate</lx:path>
                              <lx:label>Origination Date</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="OriginatorReferenceID" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Unique identifier assigned to the liability by the originator system.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.OriginatorReferenceID</lx:path>
                              <lx:label>Originator Reference ID</lx:label>
                              <li:transactions>CAL,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="OutstandingBalance" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the outstanding, current or unpaid balance of the liability.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.OutstandingBalance</lx:path>
                              <lx:label>Outstanding Balance</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="Overdrawn" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates whether the liability is currently overdrawn.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.Overdrawn</lx:path>
                              <lx:label>Overdrawn</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ProductCode" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures an identifying code for the existing liability. This code is typically issued by the lender and enables the lender's systems to uniquely identify the product.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.ProductCode</lx:path>
                              <lx:label>Product Code</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ProductName" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The product name of the existing liability.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.ProductName</lx:path>
                              <lx:label>Product Name</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="RefinanceAmount" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the exact amount that will be refinanced for existing liabilities.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.RefinanceAmount</lx:path>
                              <lx:label>Refinance Amount</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="RefinanceCosts" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Borrowers must state the estimated cost associated with closing a credit facility. For each liability being refinanced the applicants will provide the Estimated Exit and Break Costs payable to the outgoing finance institution.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.RefinanceCosts</lx:path>
                              <lx:label>Refinance Costs</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="RepaidDate" type="dateType" use="optional">
                          <xs:annotation>
                            <xs:documentation>For a loan that has recently been repaid, the date that it was paid out</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.RepaidDate</lx:path>
                              <lx:label>Repaid Date</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="RevertInterestRate" type="percentType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Estimate of the interest rate at the end of the fixed rate period or the end of the interest only period (whichever is longer). The revert interest rate will be an estimate based on the current variable rate.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.RevertInterestRate</lx:path>
                              <lx:label>Revert Interest Rate</lx:label>
                              <li:transactions>CAL,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="Secured" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The liability is secured.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.Secured</lx:path>
                              <lx:label>Secured</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="SequenceNumber" type="integerType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The order of this liability within the sequence.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.SequenceNumber</lx:path>
                              <lx:label>Sequence Number</lx:label>
                              <li:transactions>CAL,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="SMSFLoan" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Flag to note whether the liability belongs to a self-managed super fund.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.SMSFLoan</lx:path>
                              <lx:label>SMSF Loan</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="Suspended" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates that interest accrual and payments on the liability are currently suspended.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.Suspended</lx:path>
                              <lx:label>Suspended</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="Type" type="liabilityTypeList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Specifies the type of liability that is being described. Types include credit card limits, HECS debt, existing loans, etc.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.Type</lx:path>
                              <lx:label>Type</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="UndrawnAmount" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The maximum amount available to be drawn under a Credit agreement. Captures difference between the future credit limit less the Current Outstanding Balance.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.UndrawnAmount</lx:path>
                              <lx:label>Undrawn Amount</lx:label>
                              <li:transactions>CAL,CDA,SVC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                          <xs:annotation>
                            <xs:documentation>System assigned unique identifier</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.UniqueID</lx:path>
                              <lx:label>Unique ID</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="Verified" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>A flag to indicate that this liability data has been verified.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.Verified</lx:path>
                              <lx:label>Verified</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="WrittenOff" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>This liability has been written off.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.WrittenOff</lx:path>
                              <lx:label>Written Off</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="x_CustomerTransactionAnalysis" type="referenceType" use="optional">
                          <xs:annotation>
                            <xs:documentation>A cross reference to the customer transaction analysis element from which the liability data was verified.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.Liability.x_CustomerTransactionAnalysis</lx:path>
                              <lx:label>Customer Transaction Analysis</lx:label>
                              <li:transactions>CAL</li:transactions>
                              <lx:references>
                                <lx:target>Package.Content.Application.CustomerTransactionAnalysis</lx:target>
                              </lx:references>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                      </xs:complexType>
                    </xs:element>
                    <xs:element name="LoanDetails" minOccurs="0" maxOccurs="unbounded">
                      <xs:annotation>
                        <xs:documentation>Information about an individual credit facility that is being applied for including but not limited to: term loans; revolving credit facilities; overdrafts; credit cards; equipment finance; commercial bills; margin loans; personal loans; and reverse mortgages.</xs:documentation>
                        <xs:appinfo>
                          <lx:path>Package.Content.Application.LoanDetails</lx:path>
                          <lx:label>Loan Details</lx:label>
                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,VAL,ACC</li:transactions>
                        </xs:appinfo>
                      </xs:annotation>
                      <xs:complexType>
                        <xs:sequence>
                          <xs:element name="AccountNumber" type="financialAccountType" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Account details of this loan account.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.AccountNumber</lx:path>
                                <lx:label>Account Number</lx:label>
                                <li:transactions>CDA</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                          </xs:element>
                          <xs:element name="AmountRequestedInForeignCurrency" type="amountInForeignCurrencyType" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>The loan amount as requested in a foreign currency by the applicant for this loan account, exclusive of to-be-capitalised fees and/or LMI.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.AmountRequestedInForeignCurrency</lx:path>
                                <lx:label>Amount Requested In Foreign Currency</lx:label>
                                <li:transactions>CAL</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                          </xs:element>
                          <xs:element name="Borrowers" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Identifies the parties that are prospective borrowers on this loan account.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.Borrowers</lx:path>
                                <lx:label>Borrowers</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="Owner" minOccurs="0" maxOccurs="unbounded">
                                  <xs:annotation>
                                    <xs:documentation>Container that associates a reference to an owner or other responsible party with the percentage of the item that they own or are responsible for.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LoanDetails.Borrowers.Owner</lx:path>
                                      <lx:label>Owner</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="AccessType" type="accessTypeList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Specifies the level of access for this borrower.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.Borrowers.Owner.AccessType</lx:path>
                                          <lx:label>Access Type</lx:label>
                                          <li:transactions>ACC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Percent" type="percentType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Captures the percentage of the item that referenced party owns or is responsible for.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.Borrowers.Owner.Percent</lx:path>
                                          <lx:label>Percent</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="PreferredCorrespondence" type="preferredCorrespondenceList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The preferred method for this borrower to receive correspondence relating to this loan such as welcome letters, loan statements, arrears notifications, changes of interest rate notifications, and other notifications.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.Borrowers.Owner.PreferredCorrespondence</lx:path>
                                          <lx:label>Preferred Correspondence</lx:label>
                                          <li:transactions>ACC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="PrimaryBorrower" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The lender should consider this borrower to be the primary borrower when processing the loan. The significance of the primary borrower to the loan varies from lender to lender.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.Borrowers.Owner.PrimaryBorrower</lx:path>
                                          <lx:label>Primary Borrower</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="x_Party" type="referenceType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Contains a reference to a party that is an owner of the item, or has a similar relationship such as a borrower or beneficiary.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.Borrowers.Owner.x_Party</lx:path>
                                          <lx:label>Party</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                                          <lx:references>
                                            <lx:target>Package.Content.Application.CompanyApplicant</lx:target>
                                            <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                            <lx:target>Package.Content.Application.TrustApplicant</lx:target>
                                          </lx:references>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="Proportions" type="proportionsList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Flag to indicate whether the ownership proportions are equal across all owners, specified individually for each one, or not specified.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Borrowers.Proportions</lx:path>
                                    <lx:label>Proportions</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="BulkReduction" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>A bulk reduction is a scheduled future lump sum principal repayment. For example, the applicant may be yet to sell their home so take out bridging finance in order to fund the purchase of their new home pending the sale of their existing home. When the existing home is sold, they will make a lump sum payment in reduction of the loan. This payment is the bulk reduction. Another example would be where the applicant is expecting a superannuation payout.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.BulkReduction</lx:path>
                                <lx:label>Bulk Reduction</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="Amount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The amount of the future bulk reduction repayment.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.BulkReduction.Amount</lx:path>
                                    <lx:label>Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="EstimatedDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The date on which it is anticipated that the bulk reduction repayment will be made.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.BulkReduction.EstimatedDate</lx:path>
                                    <lx:label>Estimated Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="Commission" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Contains information relating to the commission to be paid to the business partner that has sourced the loan application for the lender. This partner is typically a third party such as a mortgage aggregator or brokerage.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.Commission</lx:path>
                                <lx:label>Commission</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="CommissionAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The amount of upfront commission to be paid to the sales channel in the event that loan application settles.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Commission.CommissionAmount</lx:path>
                                    <lx:label>Commission Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="CommissionPaid" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether a commission is payable to the sales channel in respect of the loan application.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Commission.CommissionPaid</lx:path>
                                    <lx:label>Commission Paid</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="CommissionStructure" type="commissionStructureList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the commission plan involves payment of an upfront commission only, an upfront commission and a trail commission, a trail commission only, or another type of structure.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Commission.CommissionStructure</lx:path>
                                    <lx:label>Commission Structure</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="GSTAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The portion of the commission amount that is paid in goods and services tax (GST).</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Commission.GSTAmount</lx:path>
                                    <lx:label>GST Amount</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="ITCAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The portion of the commission amount that is claimed as input tax credit (ITC).</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Commission.ITCAmount</lx:path>
                                    <lx:label>ITC Amount</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="OtherCommissionStructureDescription" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A description of the commission structure if an accurate description is not specified in the enumerated values. Must be provided when Commission Structure = "Other"</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Commission.OtherCommissionStructureDescription</lx:path>
                                    <lx:label>Other Commission Structure Description</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PromotionCode" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A code that specifies a particular promotion or special commission offer that applies to the loan application, specified by the submitting sales channel in order to tag the deal with the promotion code.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Commission.PromotionCode</lx:path>
                                    <lx:label>Promotion Code</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="ThirdPartyReferee" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the sales channel is a third party referrer of business for the purpose of commission disclosure requirements.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Commission.ThirdPartyReferee</lx:path>
                                    <lx:label>Third Party Referee</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Trail" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates the trail commission percentage.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Commission.Trail</lx:path>
                                    <lx:label>Trail</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="UpfrontPayment" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates the upfront commission percentage.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Commission.UpfrontPayment</lx:path>
                                    <lx:label>Upfront Payment</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="DiscountMargin" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>Contains information about a discount in relation to the loan facility that the applicant claims they are entitled to. The discount claimed may be in the form of either a rate reduction margin or a dollar amount. The discount claimed is different from, and therefore may be in addition to, a general special offer that applies to all applicants, or discount that is available under a product package.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.DiscountMargin</lx:path>
                                <lx:label>Discount Margin</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="DiscountedAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the dollar amount of the discount the applicant claims they qualify for or are entitled to. The dollar amount is to be deducted from the calculated periodic repayment.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.DiscountMargin.DiscountedAmount</lx:path>
                                    <lx:label>Discounted Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="DiscountRate" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the percentage rate discount the applicant claims they qualify for or are entitled to. If the discount is for 0.6% off the variable rate which is 6.5%, the value to be entered in this field should be '0.6'. If the borrower gets 0.5 in addition to 0.2, then the net Discount Rate will be 0.7</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.DiscountMargin.DiscountRate</lx:path>
                                    <lx:label>Discount Rate</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="DiscountReason" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures an explanation of why the applicant qualifies for or is entitled to the discount claimed.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.DiscountMargin.DiscountReason</lx:path>
                                    <lx:label>Discount Reason</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Duration" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The duration over which the discount is to be applied</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.DiscountMargin.Duration</lx:path>
                                    <lx:label>Duration</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="DurationUnits" type="durationUnitsList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The units of time of the specified duration</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.DiscountMargin.DurationUnits</lx:path>
                                    <lx:label>Duration Units</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="SequenceNumber" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The order of this discount margin within the sequence.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.DiscountMargin.SequenceNumber</lx:path>
                                    <lx:label>Sequence Number</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="DocumentationInstructions" type="documentationInstructionsType" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Contains information specifying where the lender is to send the loan documents once the loan has been approved. This nomination over-rides an equivalent one at the Application level.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.DocumentationInstructions</lx:path>
                                <lx:label>Documentation Instructions</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                          </xs:element>
                          <xs:element name="DSH" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Indicates whether this loan is a Defence Service Housing loan under the program between the Commonwealth Government and Westpac Banking Corporation.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.DSH</lx:path>
                                <lx:label>DSH</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="AssignmentCertificate" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Under the DSH loan program, a certificate of assignment assigns the subsidy that is paid by the Commonwealth to a credit provider if, in accordance with the certificate, the credit provider makes an advance to another person (the assignee). If there is an assignment certificate, the details of the certificate are captured here.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.DSH.AssignmentCertificate</lx:path>
                                    <lx:label>Assignment Certificate</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="EntitlementCertificate" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Under the Defence Services Housing loan program, a certificate of entitlement certifies that a subsidy is payable by the Commonwealth to the credit provider if, in accordance with the agreement, the credit provider makes that advance to the applicant or the assignee of the applicant. If there is an entitlement certificate, details of the certificate must be provided.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.DSH.EntitlementCertificate</lx:path>
                                    <lx:label>Entitlement Certificate</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="FileNumber" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Under the Defence Services Housing loan program, the Commonwealth's file number for the qualifying applicant.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.DSH.FileNumber</lx:path>
                                    <lx:label>File Number</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Subsidised" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates that the DSH loan being applied for is subsidised</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.DSH.Subsidised</lx:path>
                                    <lx:label>Subsidised</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Supplement" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates that the DSH loan being applied for is a supplement to an existing DSH loan, whereby additional available DSH loan funds are advanced to the applicant.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.DSH.Supplement</lx:path>
                                    <lx:label>Supplement</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="EquityRelease" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Contains information about the loan amount requested that applies only when the loan product being applied for is a reverse mortgage, or equity release.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.EquityRelease</lx:path>
                                <lx:label>Equity Release</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="AccommodationBond" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Captures information about the bond that the applicant intends to deposit with an aged-care facility when they taking up residence.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LoanDetails.EquityRelease.AccommodationBond</lx:path>
                                      <lx:label>Accommodation Bond</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="ExpectedAdmissionDate" type="dateType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>For an accommodation bond, the expected date that the aged person will take up residence in the aged care facility must be provided.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.EquityRelease.AccommodationBond.ExpectedAdmissionDate</lx:path>
                                          <lx:label>Expected Admission Date</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="ServiceProviderName" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>For an accommodation bond, the name of the aged care facility that will receive the accommodation bond must be provided - the "aged care facility name";</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.EquityRelease.AccommodationBond.ServiceProviderName</lx:path>
                                          <lx:label>Service Provider Name</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="ServiceProviderNumber" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>For an accommodation bond, the service provider number of the aged care facility, probably the unique RACS ID (Residential Aged Care Service) allocated by the Department of Health and Ageing must be provided</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.EquityRelease.AccommodationBond.ServiceProviderNumber</lx:path>
                                          <lx:label>Service Provider Number</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="Amount" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>For a reverse mortgage, contains information about the way that the applicant wants the loan funds to be advanced. The loan amount requested may be advanced in combinations of the following: 1. a lump sum paid at settlement; 2. instalment amounts paid periodically; and/or 3) a cash reserve amount that may be drawn down at will.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LoanDetails.EquityRelease.Amount</lx:path>
                                      <lx:label>Amount</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="CalculateAsPercentage" type="percentType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>For a reverse mortgage, captures the percentage of the value of the security property that the applicant requests to borrow. This is provided as an as an alternative to specifying an absolute loan amount. The actual loan amount will be calculated once the valuation of the security property has been completed.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.EquityRelease.Amount.CalculateAsPercentage</lx:path>
                                          <lx:label>Calculate As Percentage</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="CashReserve" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Captures the amount of the total loan amount requested that is to be advanced to the applicant as a cash reserve. Also known as a line of credit.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.EquityRelease.Amount.CashReserve</lx:path>
                                          <lx:label>Cash Reserve</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="InstalmentsAmount" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Captures the amount of the total loan amount requested that is to be advanced to the applicant in instalments. This amount is the sum of the instalment payments.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.EquityRelease.Amount.InstalmentsAmount</lx:path>
                                          <lx:label>Instalments Amount</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="LumpSum" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Captures the amount of the total loan amount requested that is to be advanced to the applicant as a lump sum at settlement.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.EquityRelease.Amount.LumpSum</lx:path>
                                          <lx:label>Lump Sum</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="VaryOnValuation" type="varyOnValuationList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The amount of the loan advanced may vary if the amount the security property is valued at differs from the applicant's estimate of its value. The applicant may be able to specify what component of the payment should be varied in this situation. The applicant may specify that one of the lump sum amount OR the cash reserve amount OR the periodic payment be varied by any shortfall or surplus when the valuation amount differs from the applicant's estimate.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.EquityRelease.Amount.VaryOnValuation</lx:path>
                                          <lx:label>Vary On Valuation</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="Instalments" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Contains information about instalment payments, including the amount, number and regularity, and start date for the payments.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LoanDetails.EquityRelease.Instalments</lx:path>
                                      <lx:label>Instalments</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="AmountPerInstalment" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>For instalment payments with a specified amount, the amount of the monthly (or other period ) payments must be provided.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.EquityRelease.Instalments.AmountPerInstalment</lx:path>
                                          <lx:label>Amount Per Instalment</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Frequency" type="instalmentsFrequencyList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The frequency of instalment payments</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.EquityRelease.Instalments.Frequency</lx:path>
                                          <lx:label>Frequency</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Indexed" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The applicant may elect to have their instalment payments indexed in order to adjust for inflation. The applicant must be able to specify if their instalment payments are to be indexed, and if so the rate of indexation to be applied.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.EquityRelease.Instalments.Indexed</lx:path>
                                          <lx:label>Indexed</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="IndexRate" type="percentType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>If instalment payments are to be indexed, specifies the percentage rate of indexation to be applied.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.EquityRelease.Instalments.IndexRate</lx:path>
                                          <lx:label>Index Rate</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="NumberOfInstalments" type="integerType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>For instalment payments without a specified amount, the number of instalment payments to be made must be provided</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.EquityRelease.Instalments.NumberOfInstalments</lx:path>
                                          <lx:label>Number Of Instalments</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="ProtectedEquity" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>An applicant for a reverse mortgage may specify that a percentage of the equity in the security property be protected against the increasing balance of the loan, to preserve it for the borrower's future needs. The lender cannot use proceeds of sale of the property that relate to the protected equity portion of the loan to repay the outstanding balance of the loan.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.EquityRelease.ProtectedEquity</lx:path>
                                    <lx:label>Protected Equity</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="ProtectedEquityPercentage" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>If a percentage of the applicant's equity in the security property is to be protected, specifies the percentage of equity protected.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.EquityRelease.ProtectedEquityPercentage</lx:path>
                                    <lx:label>Protected Equity Percentage</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="FeaturesSelected" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Contains information about the product features requested by the applicant.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected</lx:path>
                                <lx:label>Features Selected</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="DepositAccount" minOccurs="0" maxOccurs="unbounded">
                                  <xs:annotation>
                                    <xs:documentation>The features selected for this deposit account associated with the loan account.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.DepositAccount</lx:path>
                                      <lx:label>Deposit Account</lx:label>
                                      <li:transactions>CAL</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="Holding" type="accountHoldingList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Indicates whether the applicant has requested a deposit account held by a sole account holder or held by joint account holders.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.DepositAccount.Holding</lx:path>
                                          <lx:label>Holding</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="ExtraFeature" minOccurs="0" maxOccurs="unbounded">
                                  <xs:annotation>
                                    <xs:documentation>Information about a product feature that is requested on the loan account.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.ExtraFeature</lx:path>
                                      <lx:label>Extra Feature</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="Description" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Specific information, value or enumeration related to the specific feature (name).</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.ExtraFeature.Description</lx:path>
                                          <lx:label>Description</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Name" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The name of the specific feature being requested. Free text field although lenders may provide enumerations</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.ExtraFeature.Name</lx:path>
                                          <lx:label>Name</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Unique Identifier for this Extra Feature Element</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.ExtraFeature.UniqueID</lx:path>
                                          <lx:label>Unique ID</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="OffsetAccount" minOccurs="0" maxOccurs="unbounded">
                                  <xs:annotation>
                                    <xs:documentation>Identifies the BSB, Account Number and Account Name for the offset account.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.OffsetAccount</lx:path>
                                      <lx:label>Offset Account</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:sequence>
                                      <xs:element name="AccountNumber" type="financialAccountType" minOccurs="0" maxOccurs="1">
                                        <xs:annotation>
                                          <xs:documentation>Account number details such as BSB, Account Number and Account Name for the offset account</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.OffsetAccount.AccountNumber</lx:path>
                                            <lx:label>Account Number</lx:label>
                                            <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                      </xs:element>
                                    </xs:sequence>
                                    <xs:attribute name="Holding" type="accountHoldingList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The offest account is held by a sole account holder or is held by joint account holders.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.OffsetAccount.Holding</lx:path>
                                          <lx:label>Holding</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="IsExisting" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Indicates whether the Offset Account detailed is an existing Offset Account or not</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.OffsetAccount.IsExisting</lx:path>
                                          <lx:label>Is Existing</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Unique Identifier for this Offset Account Element</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.OffsetAccount.UniqueID</lx:path>
                                          <lx:label>Unique ID</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="x_Account" type="referenceType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>A cross reference to an account (a Non Real Estate Asset element) to be used as the offset account.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.OffsetAccount.x_Account</lx:path>
                                          <lx:label>Account</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                          <lx:references>
                                            <lx:target>Package.Content.Application.NonRealEstateAsset</lx:target>
                                          </lx:references>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="ChequeBook" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant requests that a cheque book be issued for the loan account.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.ChequeBook</lx:path>
                                    <lx:label>Cheque Book</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="CreditCard" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant has requested a credit card.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.CreditCard</lx:path>
                                    <lx:label>Credit Card</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="DebitCard" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant has requested a debit card.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.DebitCard</lx:path>
                                    <lx:label>Debit Card</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="DepositAccountRequested" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant has requested one or more deposit accounts be established for the loan account.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.DepositAccountRequested</lx:path>
                                    <lx:label>Deposit Account Requested</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="DepositBook" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant has requested a deposit book</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.DepositBook</lx:path>
                                    <lx:label>Deposit Book</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="HolidayLeave" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant requests that the loan product allows them to temporarily pause making repayments while they are not earning a regular income or for some other acceptable reason.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.HolidayLeave</lx:path>
                                    <lx:label>Holiday Leave</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Offset" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant requests that a 100% offset account facility be established for the loan account.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.Offset</lx:path>
                                    <lx:label>Offset</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="OffsetPercentage" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Specifies the percentage of the balance in the offset account that should be used to reduce the outstanding balance on the loan account when calculating interest payable. Typically 100%, but some lenders offer partial offset accounts.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.OffsetPercentage</lx:path>
                                    <lx:label>Offset Percentage</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="ParentalLeave" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant requests that the loan product allows them to reduce their repayments while they are not earning a regular income because they are taking maternity/parental leave.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.ParentalLeave</lx:path>
                                    <lx:label>Parental Leave</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PartialOffset" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant requests that an offset account be established for the loan account with less than 100% offset of the balance in the offset account against the outstanding loan balance.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.PartialOffset</lx:path>
                                    <lx:label>Partial Offset</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Portability" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant requests that the loan facility be portable between security properties.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.Portability</lx:path>
                                    <lx:label>Portability</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="ProgressiveDraw" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant requests that the loan funds be drawn down progressively, typically against progress of stages under a construction contract.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.ProgressiveDraw</lx:path>
                                    <lx:label>Progressive Draw</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="RateLock" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant requests that the interest rate for a fixed rate product be 'locked' until settlement</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.RateLock</lx:path>
                                    <lx:label>Rate Lock</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Redraw" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant requests that the loan product permit the redraw of loan principal that has been repaid in advance of the amortisation schedule for the loan.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.Redraw</lx:path>
                                    <lx:label>Redraw</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="SplitLoan" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates that the applicant requests that the loan amount be split between two or more separate accounts or split facilities.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.FeaturesSelected.SplitLoan</lx:path>
                                    <lx:label>Split Loan</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="FundsDisbursement" type="fundsDisbursementType" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>Specification of how funds are to be distributed.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.FundsDisbursement</lx:path>
                                <lx:label>Funds Disbursement</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                          </xs:element>
                          <xs:element name="Guarantor" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>A reference to the party that is applying to be a guarantor on this loan account.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.Guarantor</lx:path>
                                <lx:label>Guarantor</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="x_Guarantor" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A reference to the party that is applying to be a guarantor on this loan account.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Guarantor.x_Guarantor</lx:path>
                                    <lx:label>Guarantor</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.CompanyApplicant</lx:target>
                                      <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                      <lx:target>Package.Content.Application.TrustApplicant</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="InterestPayable" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Interest that will be paid over the term of the loan.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.InterestPayable</lx:path>
                                <lx:label>Interest Payable</lx:label>
                                <li:transactions>DAS</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="TotalAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The total interest amount that will be paid over the term of the loan.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.InterestPayable.TotalAmount</lx:path>
                                    <lx:label>Total Amount</lx:label>
                                    <li:transactions>DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="LendingPurpose" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>Details of the purpose for which the applicant intends to use the loan funds.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.LendingPurpose</lx:path>
                                <lx:label>Lending Purpose</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,VAL,ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="PercentBenefit" type="percentOwnedType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Identifies the parties that will benefit from this lending purpose.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LoanDetails.LendingPurpose.PercentBenefit</lx:path>
                                      <lx:label>Percent Benefit</lx:label>
                                      <li:transactions>CAL</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="ABSLendingPurpose" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the free text description of the ABS Lending Purpose Code.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.LendingPurpose.ABSLendingPurpose</lx:path>
                                    <lx:label>ABS Lending Purpose</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="ABSLendingPurposeCode" type="absLendingPurposeCodeList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the ABS code for this purpose for which the loan funds will be used by the applicant.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.LendingPurpose.ABSLendingPurposeCode</lx:path>
                                    <lx:label>ABS Lending Purpose Code</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Description" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures a description of the purpose if none of the purposes specified in the lender's enumerated list of purposes adequately described the true purpose.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.LendingPurpose.Description</lx:path>
                                    <lx:label>Description</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="IncludesRefinancing" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Whether all or part of this credit facility will be used to refinance in full or in part one or many existing credit facilities.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.LendingPurpose.IncludesRefinancing</lx:path>
                                    <lx:label>Includes Refinancing</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="LenderCode" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the lender-specified code for this purpose for which the loan funds will be used by the applicant.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.LendingPurpose.LenderCode</lx:path>
                                    <lx:label>Lender Code</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PayoutQuoteObtained" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Confirmation that a payout quote has been obtained with respect to all facilities to be refinanced using this facility.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.LendingPurpose.PayoutQuoteObtained</lx:path>
                                    <lx:label>Payout Quote Obtained</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PurposeAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The amount of the loan funds that will be used for the specified purpose.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.LendingPurpose.PurposeAmount</lx:path>
                                    <lx:label>Purpose Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PurposeOfFunds" type="purposeOfFundsList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The purpose for which the loan funds will be used.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.LendingPurpose.PurposeOfFunds</lx:path>
                                    <lx:label>Purpose of Funds</lx:label>
                                    <li:transactions>CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="RefinancingReason" type="principalRefinancingReasonList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Borrowers should inform the lender of the reason for refinancing liabilities</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.LendingPurpose.RefinancingReason</lx:path>
                                    <lx:label>Refinancing Reason</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="SecurityForMarginLoan" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicate if shares or an investment purchased using this loan are to be used as security for a margin loan.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.LendingPurpose.SecurityForMarginLoan</lx:path>
                                    <lx:label>Security For Margin Loan</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Unique Identifier for this Lending Purpose Element</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.LendingPurpose.UniqueID</lx:path>
                                    <lx:label>Unique ID</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="LoanPurpose" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Contains information about the main purpose for which the applicant intends to use the loan funds.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.LoanPurpose</lx:path>
                                <lx:label>Loan Purpose</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="NCCPStatus" type="nccpStatusList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures whether the loan is regulated by the NCCP. This determination is made by the lender based on information provided by the applicant about the purpose for which the loan funds will be used, so this field is unlikely to be requested from the applicant.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.LoanPurpose.NCCPStatus</lx:path>
                                    <lx:label>NCCP Status</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Occupancy" type="occupancyList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The applicant's intention as to who will occupy the dwelling after the purchase completes.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.LoanPurpose.Occupancy</lx:path>
                                    <lx:label>Occupancy</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="OwnerBuilderApplication" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates whether the applicant intends to use the loan funds to fund the building of an owner/builder constructed property.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.LoanPurpose.OwnerBuilderApplication</lx:path>
                                    <lx:label>Owner Builder Application</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PrimaryPurpose" type="primaryPurposeLoanPurposeList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the primary purpose for which the loan funds will be used by the applicant. Categories reflect the categories used in classifying a loan as regulated or unregulated under the NCCP.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.LoanPurpose.PrimaryPurpose</lx:path>
                                    <lx:label>Primary Purpose</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="RBALendingPurpose" type="rbaLendingPurposeList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the RBA specific lending purpose for which the loan funds will be used by the applicant.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.LoanPurpose.RBALendingPurpose</lx:path>
                                    <lx:label>RBA Lending Purpose</lx:label>
                                    <li:transactions>CAL,CDA,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="Package" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Contains information about a package option that may be available for the individual loan account.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.Package</lx:path>
                                <lx:label>Package</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="Category" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures a lender defined category to which the requested package belongs.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Package.Category</lx:path>
                                    <lx:label>Category</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Code" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A unique code representing the product package being requested by the applicant.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Package.Code</lx:path>
                                    <lx:label>Code</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="MemberID" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Membership Identifier of the applicant issued by the Organisation the applicant claims to belong to and therefore qualify for the package associated with that Organisation. May be provided when Organisation is specified.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Package.MemberID</lx:path>
                                    <lx:label>Member ID</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Name" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the name of a package that the applicant is applying for. A package commonly gives the borrowers certain benefits, such as an interest rate and fee discounts, for a fee. There may be rules that determine whether the applicants qualify for the package.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Package.Name</lx:path>
                                    <lx:label>Name</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="OptionCode" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A unique code identifying an option that applies to a package.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Package.OptionCode</lx:path>
                                    <lx:label>Option Code</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Organisation" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A code or name that identifies the organisation under which the package is offered.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Package.Organisation</lx:path>
                                    <lx:label>Organisation</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="PortfolioFund" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>The portfolio fund to which this loan is assigned.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.PortfolioFund</lx:path>
                                <lx:label>Portfolio Fund</lx:label>
                                <li:transactions>ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="PortfolioFundID" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>An identifier that can be used to uniquely identify the portfolio fund.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.PortfolioFund.PortfolioFundID</lx:path>
                                    <lx:label>Portfolio Fund ID</lx:label>
                                    <li:transactions>ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PortfolioFundName" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The name of the portfolio fund.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.PortfolioFund.PortfolioFundName</lx:path>
                                    <lx:label>Portfolio Fund Name</lx:label>
                                    <li:transactions>ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="PreferredCorrespondent" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>A party who will be receiving correspondence on behalf of the applicant.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.PreferredCorrespondent</lx:path>
                                <lx:label>Preferred Correspondent</lx:label>
                                <li:transactions>ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="AccessType" type="accessTypeList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Specifies the level of access for this correspondent.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.PreferredCorrespondent.AccessType</lx:path>
                                    <lx:label>Access Type</lx:label>
                                    <li:transactions>ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PreferredCorrespondence" type="preferredCorrespondenceList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The preferred method for this correspondent to receive correspondence relating to this loan such as welcome letters, loan statements, arrears notifications, changes of interest rate notifications, and other notifications.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.PreferredCorrespondent.PreferredCorrespondence</lx:path>
                                    <lx:label>Preferred Correspondence</lx:label>
                                    <li:transactions>ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_Correspondent" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A cross reference to the party who will be receiving correspondence on behalf of the applicant.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.PreferredCorrespondent.x_Correspondent</lx:path>
                                    <lx:label>Correspondent</lx:label>
                                    <li:transactions>ACC</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.CompanyApplicant</lx:target>
                                      <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                      <lx:target>Package.Content.Application.RelatedCompany</lx:target>
                                      <lx:target>Package.Content.Application.RelatedPerson</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="ProposedRepayment" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Contains information that specifies how the borrower(s) intend to make regular or structured repayments.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment</lx:path>
                                <lx:label>Proposed Repayment</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC,ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="Authoriser" minOccurs="0" maxOccurs="unbounded">
                                  <xs:annotation>
                                    <xs:documentation>A party that has authorised the proposed repayment.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.Authoriser</lx:path>
                                      <lx:label>Authoriser</lx:label>
                                      <li:transactions>CAL</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="Authorised" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The authoriser has authorised the proposed repayment.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.Authoriser.Authorised</lx:path>
                                          <lx:label>Authorised</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="AuthorityVerified" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The authority of the authorising party has been verified.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.Authoriser.AuthorityVerified</lx:path>
                                          <lx:label>Authority Verified</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="x_Party" type="referenceType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>A cross reference to the authorising party.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.Authoriser.x_Party</lx:path>
                                          <lx:label>x_Party</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                          <lx:references>
                                            <lx:target>Package.Content.Application.CompanyApplicant</lx:target>
                                            <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                            <lx:target>Package.Content.Application.RelatedCompany</lx:target>
                                            <lx:target>Package.Content.Application.RelatedPerson</lx:target>
                                            <lx:target>Package.Content.Application.TrustApplicant</lx:target>
                                          </lx:references>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="CreditCard" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Details of the credit card to be used for repayments</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.CreditCard</lx:path>
                                      <lx:label>Credit Card</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="CardHolderName" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Cardholder name on the credit card to be used for repayments</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.CreditCard.CardHolderName</lx:path>
                                          <lx:label>Card Holder Name</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="ExpiryMonth" type="mmMonthList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Month of expiry date of the credit card to be used for repayments</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.CreditCard.ExpiryMonth</lx:path>
                                          <lx:label>Expiry Month</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="ExpiryYear" type="yyYearList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Year of expiry date of the credit card to be used for repayments</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.CreditCard.ExpiryYear</lx:path>
                                          <lx:label>Expiry Year</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Number" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Credit card number to be used for repayments</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.CreditCard.Number</lx:path>
                                          <lx:label>Number</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Type" type="creditCardTypeList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Type of credit card to be used for repayments</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.CreditCard.Type</lx:path>
                                          <lx:label>Type</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="FromAccount" type="financialAccountType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Captures BSB, Account Number and Account Name for the account from which the repayments will be made.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.FromAccount</lx:path>
                                      <lx:label>From Account</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                                <xs:element name="RegularRepayment" minOccurs="0" maxOccurs="unbounded">
                                  <xs:annotation>
                                    <xs:documentation>Container element for information associated with regular repayments</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.RegularRepayment</lx:path>
                                      <lx:label>Regular Repayment</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="Amount" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Preferred or nominated total regular repayment amount (incorporating any GST or Stamp Duty in the case of Equipment Finance Transactions)</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.RegularRepayment.Amount</lx:path>
                                          <lx:label>Amount</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="DayOfMonth" type="dayOfMonthPattern" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The day of the month that the regular repayment will be made.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.RegularRepayment.DayOfMonth</lx:path>
                                          <lx:label>Day Of Month</lx:label>
                                          <li:transactions>CAL,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="DayOfWeek" type="dayOfWeekList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The day of the week that the regular repayment will be made.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.RegularRepayment.DayOfWeek</lx:path>
                                          <lx:label>Day Of Week</lx:label>
                                          <li:transactions>CAL,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="EndOfPeriod" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The payment will be made at the end of the end of the period e.g. end of month (EOM), end of quarter (EOQ), or end of year (EOY).</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.RegularRepayment.EndOfPeriod</lx:path>
                                          <lx:label>End Of Period</lx:label>
                                          <li:transactions>CAL,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="FirstRepaymentDate" type="dateType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The date that the first repayment of this regular repayment will occur.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.RegularRepayment.FirstRepaymentDate</lx:path>
                                          <lx:label>First Repayment Date</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Frequency" type="frequencyFullList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Captures the applicants' preferred period for making loan repayments for the loan account. Captured when the loan product selected offers a range of repayment periods, enabling the applicant to nominate a period which best suits their needs in terms of income and the desire to reduce interest over the life of the loan by accelerating the reduction of the principal balance.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.RegularRepayment.Frequency</lx:path>
                                          <lx:label>Frequency</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="FrequencyInterval" type="integerType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The time interval at which the repayment is repeated. Expressed as a multiple of the specified frequency.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.RegularRepayment.FrequencyInterval</lx:path>
                                          <lx:label>Frequency Interval</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="GSTAmount" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The dollar amount of the GST incorporated into the Regular Payment (typically used in Equipment Finance Transactions).</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.RegularRepayment.GSTAmount</lx:path>
                                          <lx:label>GST Amount</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="InterestPayment" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>This payment covers the interest amount.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.RegularRepayment.InterestPayment</lx:path>
                                          <lx:label>Interest Payment</lx:label>
                                          <li:transactions>CAL,DAS</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="LastRepaymentDate" type="dateType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The date that the last repayment of this regular repayment will occur.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.RegularRepayment.LastRepaymentDate</lx:path>
                                          <lx:label>Last Repayment Date</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="LoanPaymentScheduleType" type="loanPaymentScheduleTypeList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The type of loan payment schedule.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.RegularRepayment.LoanPaymentScheduleType</lx:path>
                                          <lx:label>Loan Payment Schedule Type</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="MinimumAmount" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The minimum amount that must be paid.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.RegularRepayment.MinimumAmount</lx:path>
                                          <lx:label>Minimum Amount</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="PrincipalPayment" type="yesNoList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>This payment reduces the principal amount.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.RegularRepayment.PrincipalPayment</lx:path>
                                          <lx:label>Principal Payment</lx:label>
                                          <li:transactions>CAL,DAS</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="StampDutyAmount" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The dollar amount of the Stamp Duty incorporated into the Regular Payment (typically used in Equipment Finance Transactions).</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.RegularRepayment.StampDutyAmount</lx:path>
                                          <lx:label>Stamp Duty Amount</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="TotalRepayments" type="integerType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Captures the total number of loan repayments.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.RegularRepayment.TotalRepayments</lx:path>
                                          <lx:label>Total Repayments</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>System assigned unique identifier.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.RegularRepayment.UniqueID</lx:path>
                                          <lx:label>Unique ID</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Week" type="weekList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The week within the period that the regular repayment will be made.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.RegularRepayment.Week</lx:path>
                                          <lx:label>Week</lx:label>
                                          <li:transactions>CAL,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="StructuredPayments" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Container element used when structured repayments rather than regular repayments are proposed or advised</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.StructuredPayments</lx:path>
                                      <lx:label>Structured Payments</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ,SVC,ACC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:sequence>
                                      <xs:element name="Payment" minOccurs="0" maxOccurs="unbounded">
                                        <xs:annotation>
                                          <xs:documentation>Details of itemised proposed payments. A given loan may have differing payment regimes at different periods in its total term (e.g. a fixed rate IO loan may have an initial Fixed Rate IO period, followed by a Variable Rate Interest Only period, followed by a Variable Rate Principal and Interest period.)</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.StructuredPayments.Payment</lx:path>
                                            <lx:label>Payment</lx:label>
                                            <li:transactions>CAL,CDA,DAS,CNZ,SVC,ACC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                        <xs:complexType>
                                          <xs:attribute name="Amount" type="currencyType" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>Captures the total amount of the payment in the payment period, being the calculated repayment amount plus any service fee, GST or Stamp Duty.</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.StructuredPayments.Payment.Amount</lx:path>
                                                <lx:label>Amount</lx:label>
                                                <li:transactions>CAL,CDA,DAS,CNZ,SVC,ACC</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                          <xs:attribute name="Date" type="dateType" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>The date of the specified payment</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.StructuredPayments.Payment.Date</lx:path>
                                                <lx:label>Date</lx:label>
                                                <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                          <xs:attribute name="GSTAmount" type="currencyType" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>The dollar amount of the GST incorporated into this Structured Payment (typically used in Equipment Finance Transactions).</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.StructuredPayments.Payment.GSTAmount</lx:path>
                                                <lx:label>GST Amount</lx:label>
                                                <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                          <xs:attribute name="GSTOnTermChargesIncluded" type="yesNoList" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>The GST on term charges is included in this payment. The GST amount for this payment includes both the GST charged on this payment amount, and the GST on term charges for the full term of the loan.</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.StructuredPayments.Payment.GSTOnTermChargesIncluded</lx:path>
                                                <lx:label>GSTOnTermChargesIncluded</lx:label>
                                                <li:transactions>CAL,CDA,DAS</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                          <xs:attribute name="GSTRebateAmount" type="currencyType" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>An input tax credit (ITC) amount that the applicant can claim on an eligible purchase.</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.StructuredPayments.Payment.GSTRebateAmount</lx:path>
                                                <lx:label>GST Rebate Amount</lx:label>
                                                <li:transactions>CAL,CDA,DAS,SVC</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                          <xs:attribute name="GSTRebateAmountReplacingPayment" type="yesNoList" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>The payment will only consist of the GST rebate amount.</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.StructuredPayments.Payment.GSTRebateAmountReplacingPayment</lx:path>
                                                <lx:label>GST Rebate Amount Replacing Payment</lx:label>
                                                <li:transactions>CAL,CDA,DAS,SVC</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                          <xs:attribute name="SequenceNumber" type="integerType" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>Captures the sequence number of the payment or payment period.</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.StructuredPayments.Payment.SequenceNumber</lx:path>
                                                <lx:label>Sequence Number</lx:label>
                                                <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                          <xs:attribute name="StampDutyAmount" type="currencyType" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>The dollar amount of the Stamp Duty incorporated into this Structured Payment (typically used in Equipment Finance Transactions).</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.StructuredPayments.Payment.StampDutyAmount</lx:path>
                                                <lx:label>Stamp Duty Amount</lx:label>
                                                <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                          <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>Unique Identifier for this Payment Element</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.StructuredPayments.Payment.UniqueID</lx:path>
                                                <lx:label>Unique ID</lx:label>
                                                <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                        </xs:complexType>
                                      </xs:element>
                                    </xs:sequence>
                                    <xs:attribute name="BaseFrequency" type="frequencyFullList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Although structured payments may have arbitrary payment dates, the base frequency defines the fundamental unit of time used for determining payment dates and interest payment calculations.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.StructuredPayments.BaseFrequency</lx:path>
                                          <lx:label>Base Frequency</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,SVC,ACC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="AnniversaryDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The preferred start (anniversary) date for regular repayments</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.AnniversaryDate</lx:path>
                                    <lx:label>Anniversary Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Description" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A description of the repayment method that will be used to repay the loan when Method = "Other"</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.Description</lx:path>
                                    <lx:label>Description</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Method" type="proposedRepaymentMethodList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Specifies the payment method that will be used to effect the transfer of repayments on the loan to the lender. Examples include salary sacrifice, direct debit and Bpay.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.Method</lx:path>
                                    <lx:label>Method</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PaymentTiming" type="paymentTimingList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates the timing of payments with respect to their payment period.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.PaymentTiming</lx:path>
                                    <lx:label>Payment Timing</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PerDiemPaymentAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>An optional partial-period payment to bring payment periods for several loans onto a common anniversary date (this is a total amount, so it includes GST and Stamp Duty).</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.PerDiemPaymentAmount</lx:path>
                                    <lx:label>Per Diem Payment Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PerDiemPaymentDate" type="dateType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The proposed date of the per diem payment</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.PerDiemPaymentDate</lx:path>
                                    <lx:label>Per Diem Payment Date</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PerDiemPaymentGSTAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The dollar amount of the GST portion of within the Per Diem Payment Amount</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.PerDiemPaymentGSTAmount</lx:path>
                                    <lx:label>Per Diem Payment GST Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PerDiemPaymentStampDutyAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The dollar amount of the Stamp Duty portion of the Per Diem Payment Amount</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.PerDiemPaymentStampDutyAmount</lx:path>
                                    <lx:label>Per Diem Payment StampDuty Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Regular" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Flag to indicate whether payments are regular (same amount on regular intervals) or structured (irregular intervals and/or amounts)</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.Regular</lx:path>
                                    <lx:label>Regular</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_Account" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A cross reference to the account (a Non Real Estate Asset element) from which the repayments will be made.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.ProposedRepayment.x_Account</lx:path>
                                    <lx:label>Account</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.NonRealEstateAsset</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="RateComposition" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>The structure of the interest rate to the borrower, based on the delivery rate with applied margins</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.RateComposition</lx:path>
                                <lx:label>Rate Composition</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="BaseRate" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>The base rate on which other rates are calculated.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LoanDetails.RateComposition.BaseRate</lx:path>
                                      <lx:label>Base Rate</lx:label>
                                      <li:transactions>CAL,DAS,ACC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="Code" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The base rate code.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.RateComposition.BaseRate.Code</lx:path>
                                          <lx:label>Code</lx:label>
                                          <li:transactions>CAL,DAS,ACC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Name" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The base rate name.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.RateComposition.BaseRate.Name</lx:path>
                                          <lx:label>Name</lx:label>
                                          <li:transactions>CAL,DAS,ACC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Rate" type="percentType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The base rate as a percentage.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.RateComposition.BaseRate.Rate</lx:path>
                                          <lx:label>Rate</lx:label>
                                          <li:transactions>CAL,DAS,ACC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="CustomerRiskMargin" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The customer risk margin added (as a percentage) based on the risk the customer presents to the bank.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.RateComposition.CustomerRiskMargin</lx:path>
                                    <lx:label>Customer Risk Margin</lx:label>
                                    <li:transactions>CAL,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="DisclosedToCustomer" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The details of the rate are disclosed to the customer.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.RateComposition.DisclosedToCustomer</lx:path>
                                    <lx:label>Disclosed To Customer</lx:label>
                                    <li:transactions>CAL,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="IntroducerMargin" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates the introducer margin percentage</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.RateComposition.IntroducerMargin</lx:path>
                                    <lx:label>Introducer Margin</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="IntroductoryMargin" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The introductory margin added (as a percentage) during the introductory period or honeymoon period.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.RateComposition.IntroductoryMargin</lx:path>
                                    <lx:label>Introductory Margin</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="NetCustomerRiskMargin" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The customer risk margin minus the discount margin (as a percentage).</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.RateComposition.NetCustomerRiskMargin</lx:path>
                                    <lx:label>Net Customer Risk Margin</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="OriginatorMargin" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Indicates the originator margin percentage</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.RateComposition.OriginatorMargin</lx:path>
                                    <lx:label>Originator Margin</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PaymentTypeMargin" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The payment type margin added (as a percentage) based on the payment type.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.RateComposition.PaymentTypeMargin</lx:path>
                                    <lx:label>Payment Type Margin</lx:label>
                                    <li:transactions>CAL,DAS,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PricingConstruct" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The pricing construct used to calculate the rate i.e. Base Rate + Term Premium.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.RateComposition.PricingConstruct</lx:path>
                                    <lx:label>Pricing Construct</lx:label>
                                    <li:transactions>CAL,DAS,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="ProductMargin" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The product margin added (as a percentage) based on the specific product type.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.RateComposition.ProductMargin</lx:path>
                                    <lx:label>Product Margin</lx:label>
                                    <li:transactions>CAL,DAS,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="SubsidyBaseAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Upfront fixed amount</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.RateComposition.SubsidyBaseAmount</lx:path>
                                    <lx:label>Subsidy Base Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="SubsidyBasePercent" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Upfront commission percent</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.RateComposition.SubsidyBasePercent</lx:path>
                                    <lx:label>Subsidy Base Percent</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="SubsidyRateSacrifice" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Rate added to the borrower rate</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.RateComposition.SubsidyRateSacrifice</lx:path>
                                    <lx:label>Subsidy Rate Sacrifice</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TermPremium" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The term premium added (as a percentage) based on the loan term.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.RateComposition.TermPremium</lx:path>
                                    <lx:label>Term Premium</lx:label>
                                    <li:transactions>CAL,DAS,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TotalInterestRate" type="percentType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The total interest rate for this rate composition scheme.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.RateComposition.TotalInterestRate</lx:path>
                                    <lx:label>Total Interest Rate</lx:label>
                                    <li:transactions>CAL,DAS,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>System assigned unique identifier.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.RateComposition.UniqueID</lx:path>
                                    <lx:label>Unique ID</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="Security" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>Contains a reference to a security property that is submitted with the loan application, and information about the relationship between the subject loan account and that security property.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.Security</lx:path>
                                <lx:label>Security</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="SecurityAgreement" type="securityAgreementType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Security agreement details for this security.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LoanDetails.Security.SecurityAgreement</lx:path>
                                      <lx:label>Security Agreement</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="AllocatedAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The portion of the loan amount that is allocated to this security property.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Security.AllocatedAmount</lx:path>
                                    <lx:label>Allocated Amount</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Priority" type="securityPriorityList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Specifies the priority of the new mortgage that is offered as security for the loans being applied for. When the mortgage is already held by the lender being applied to, this is the priority of that existing mortgage.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Security.Priority</lx:path>
                                    <lx:label>Priority</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>System assigned unique identifier.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Security.UniqueID</lx:path>
                                    <lx:label>Unique ID</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_Security" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Contains a reference to a security (real estate or non real estate asset) that is submitted with the loan application, and information about the relationship between the subject loan account and that security.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Security.x_Security</lx:path>
                                    <lx:label>Security</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.NonRealEstateAsset</lx:target>
                                      <lx:target>Package.Content.Application.RealEstateAsset</lx:target>
                                      <lx:target>Package.Content.Application.GeneralSecurityAgreement</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="Software" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>The software application used by the loan originator.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.Software</lx:path>
                                <lx:label>Software</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="Description" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A description of the software provider, for example the company name.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Software.Description</lx:path>
                                    <lx:label>Description</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="Name" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The name of the software application used by the loan originator.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Software.Name</lx:path>
                                    <lx:label>Name</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="StatementInstructions" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Information specifying where loan statements should be sent regarding this loan.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.StatementInstructions</lx:path>
                                <lx:label>Statement Instructions</lx:label>
                                <li:transactions>CAL</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="NameOnStatement" minOccurs="0" maxOccurs="unbounded">
                                  <xs:annotation>
                                    <xs:documentation>An applicant whose name should be included on the loan statement.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LoanDetails.StatementInstructions.NameOnStatement</lx:path>
                                      <lx:label>NameOnStatement</lx:label>
                                      <li:transactions>CAL</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="x_Applicant" type="referenceType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>A cross reference to the applicant whose name should be included on the loan statement.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.StatementInstructions.NameOnStatement.x_Applicant</lx:path>
                                          <lx:label>Applicant</lx:label>
                                          <li:transactions>CAL</li:transactions>
                                          <lx:references>
                                            <lx:target>Package.Content.Application.CompanyApplicant</lx:target>
                                            <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                            <lx:target>Package.Content.Application.TrustApplicant</lx:target>
                                          </lx:references>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="SupplementaryCardholder" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>Contains a link to a supplementary (non liable) cardholder.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.SupplementaryCardholder</lx:path>
                                <lx:label>Supplementary Cardholder</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="x_SupplementaryCardholder" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Link to the loan party, related party or household dependant that will be a supplementary (non liable) cardholder.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.SupplementaryCardholder.x_SupplementaryCardholder</lx:path>
                                    <lx:label>Supplementary Cardholder</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.CompanyApplicant</lx:target>
                                      <lx:target>Package.Content.Application.PersonApplicant</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="Term" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Details of the total term of the credit product and any introductory terms, such as an interest only term (including interest only reasons) or a fixed rate term that applies for an initial period at the start of the product.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.Term</lx:path>
                                <lx:label>Term</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="DistinctLoanPeriod" minOccurs="0" maxOccurs="unbounded">
                                  <xs:annotation>
                                    <xs:documentation>A distinct loan period, where each period may have a different payment type, interest type, rate composition.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LoanDetails.Term.DistinctLoanPeriod</lx:path>
                                      <lx:label>Distinct Loan Period</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:sequence>
                                      <xs:element name="Duration" type="durationType" minOccurs="0" maxOccurs="1">
                                        <xs:annotation>
                                          <xs:documentation>The duration of the distinct loan period.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.LoanDetails.Term.DistinctLoanPeriod.Duration</lx:path>
                                            <lx:label>Duration</lx:label>
                                            <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                      </xs:element>
                                      <xs:element name="Repayment" minOccurs="0" maxOccurs="unbounded">
                                        <xs:annotation>
                                          <xs:documentation>A repayment that is made during this period.</xs:documentation>
                                          <xs:appinfo>
                                            <lx:path>Package.Content.Application.LoanDetails.Term.DistinctLoanPeriod.Repayment</lx:path>
                                            <lx:label>Repayment</lx:label>
                                            <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                          </xs:appinfo>
                                        </xs:annotation>
                                        <xs:complexType>
                                          <xs:attribute name="x_Repayment" type="referenceType" use="optional">
                                            <xs:annotation>
                                              <xs:documentation>A cross reference to the repayment.</xs:documentation>
                                              <xs:appinfo>
                                                <lx:path>Package.Content.Application.LoanDetails.Term.DistinctLoanPeriod.Repayment.x_Repayment</lx:path>
                                                <lx:label>Repayment</lx:label>
                                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                                <lx:references>
                                                  <lx:target>Package.Content.Application.LoanDetails.ProposedRepayment.StructuredPayments.Payment</lx:target>
                                                  <lx:target>Package.Content.Application.LoanDetails.ProposedRepayment.RegularRepayment</lx:target>
                                                </lx:references>
                                              </xs:appinfo>
                                            </xs:annotation>
                                          </xs:attribute>
                                        </xs:complexType>
                                      </xs:element>
                                    </xs:sequence>
                                    <xs:attribute name="EndDate" type="dateType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The end date of the distinct loan period.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.Term.DistinctLoanPeriod.EndDate</lx:path>
                                          <lx:label>End Date</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="InterestType" type="interestTypeList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The type of interest that is to be paid during the distinct loan period.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.Term.DistinctLoanPeriod.InterestType</lx:path>
                                          <lx:label>Interest Type</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="PaymentType" type="paymentTypeList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The type of repayment that is to be made during the distinct loan period.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.Term.DistinctLoanPeriod.PaymentType</lx:path>
                                          <lx:label>Payment Type</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="SequenceNumber" type="integerType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The order of this distinct loan period within the sequence.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.Term.DistinctLoanPeriod.SequenceNumber</lx:path>
                                          <lx:label>Sequence Number</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="StartDate" type="dateType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The start date of the distinct loan period.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.Term.DistinctLoanPeriod.StartDate</lx:path>
                                          <lx:label>Start Date</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="TotalFeesAmount" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The anticipated total dollar amount of all fees paid during this distinct loan period.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.Term.DistinctLoanPeriod.TotalFeesAmount</lx:path>
                                          <lx:label>Total Fees Amount</lx:label>
                                          <li:transactions>CAL,CDA,DAS</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="TotalInterestAmount" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The anticipated total dollar amount of interest paid during this distinct loan period.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.Term.DistinctLoanPeriod.TotalInterestAmount</lx:path>
                                          <lx:label>Total Interest Amount</lx:label>
                                          <li:transactions>CAL,CDA,DAS</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="TotalRepayments" type="integerType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The anticipated total number of repayments during this distinct loan period.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.Term.DistinctLoanPeriod.TotalRepayments</lx:path>
                                          <lx:label>Total Repayments</lx:label>
                                          <li:transactions>CAL,CDA,DAS</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="TotalRepaymentsAmount" type="currencyType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The anticipated total dollar amount of all repayments including interest paid during this distinct loan period.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.Term.DistinctLoanPeriod.TotalRepaymentsAmount</lx:path>
                                          <lx:label>Total Repayments Amount</lx:label>
                                          <li:transactions>CAL,CDA,DAS</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>System assigned unique identifier.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.Term.DistinctLoanPeriod.UniqueID</lx:path>
                                          <lx:label>Unique ID</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="x_RateComposition" type="referenceType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>A cross reference to the rate composition for this distinct loan period.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.Term.DistinctLoanPeriod.x_RateComposition</lx:path>
                                          <lx:label>Rate Composition</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                                          <lx:references>
                                            <lx:target>Package.Content.Application.LoanDetails.RateComposition</lx:target>
                                          </lx:references>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                                <xs:element name="InterestOnlyReason" minOccurs="0" maxOccurs="unbounded">
                                  <xs:annotation>
                                    <xs:documentation>Wrapper element for the applicant/s reasons for applying for an interest-only term within this this loan.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.LoanDetails.Term.InterestOnlyReason</lx:path>
                                      <lx:label>Interest Only Reason</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                  <xs:complexType>
                                    <xs:attribute name="Description" type="stringType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>A free-text description provided by the applicant/s that provides further detail regarding this reason for applying for an interest-only term within this loan.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.Term.InterestOnlyReason.Description</lx:path>
                                          <lx:label>Description</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="Reason" type="interestOnlyReasonList" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>The reason that the applicant is applying for an interest-only term within this loan.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.Term.InterestOnlyReason.Reason</lx:path>
                                          <lx:label>Reason</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                    <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                      <xs:annotation>
                                        <xs:documentation>Unique Identifier for this interest-only reason.</xs:documentation>
                                        <xs:appinfo>
                                          <lx:path>Package.Content.Application.LoanDetails.Term.InterestOnlyReason.UniqueID</lx:path>
                                          <lx:label>Unique ID</lx:label>
                                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                        </xs:appinfo>
                                      </xs:annotation>
                                    </xs:attribute>
                                  </xs:complexType>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="GSTOnTermCharges" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The GST component of the term charges amount.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Term.GSTOnTermCharges</lx:path>
                                    <lx:label>GST On Term Charges</lx:label>
                                    <li:transactions>CAL,CDA,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="GSTOnTermChargesCapitalised" type="yesNoList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The GST component of the term charges will be added to the total amount financed for the loan.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Term.GSTOnTermChargesCapitalised</lx:path>
                                    <lx:label>GST On Term Charges Capitalised</lx:label>
                                    <li:transactions>CAL,CDA,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="InterestType" type="interestTypeList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the type of interest that is to be paid during the specified term.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Term.InterestType</lx:path>
                                    <lx:label>Interest Type</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="InterestTypeDuration" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The duration of the fixed interest rate period, as a whole number multiple of the Units.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Term.InterestTypeDuration</lx:path>
                                    <lx:label>Interest Type Duration</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="InterestTypeUnits" type="loanTermUnitsList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The units of time that are used to define the duration of the fixed interest rate period.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Term.InterestTypeUnits</lx:path>
                                    <lx:label>Interest Type Units</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PaymentType" type="paymentTypeList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the type of repayment that is to be made during the specified term</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Term.PaymentType</lx:path>
                                    <lx:label>Payment Type</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PaymentTypeDuration" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The duration of the interest only period, as a whole number multiple of the Units.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Term.PaymentTypeDuration</lx:path>
                                    <lx:label>Payment Type Duration</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="PaymentTypeUnits" type="loanTermUnitsList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The units of time that are used to define the duration of the interest only period.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Term.PaymentTypeUnits</lx:path>
                                    <lx:label>Payment Type Units</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="RolloverPeriodDuration" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The duration of the rollover period for a commercial bill.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Term.RolloverPeriodDuration</lx:path>
                                    <lx:label>RolloverPeriodDuration</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="RolloverPeriodUnits" type="loanTermUnitsList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The units of time that are used to define the rollover period for a commercial bill.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Term.RolloverPeriodUnits</lx:path>
                                    <lx:label>RolloverPeriodUnits</lx:label>
                                    <li:transactions>CAL</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TermChargesAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The dollar amount of the term charges over the full term of the loan. Term charges are the total interest amount charged, plus any undisclosed capitalised fees, plus brokerage fees.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Term.TermChargesAmount</lx:path>
                                    <lx:label>Term Charges Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TotalFeesAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The anticipated total dollar amount of all fees paid over the full term of the loan.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Term.TotalFeesAmount</lx:path>
                                    <lx:label>Total Fees Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TotalInterestAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The anticipated total dollar amount of interest paid over the full term of the loan.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Term.TotalInterestAmount</lx:path>
                                    <lx:label>Total Interest Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TotalRepayments" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The anticipated total number of repayments over the full term of the loan.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Term.TotalRepayments</lx:path>
                                    <lx:label>Total Repayments</lx:label>
                                    <li:transactions>CAL,CDA,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TotalRepaymentsAmount" type="currencyType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The anticipated total dollar amount of all repayments including interest paid over the full term of the loan.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Term.TotalRepaymentsAmount</lx:path>
                                    <lx:label>Total Repayments Amount</lx:label>
                                    <li:transactions>CAL,CDA,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TotalTermDuration" type="integerType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The Duration of the specified loan term, as a multiple of the Units</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Term.TotalTermDuration</lx:path>
                                    <lx:label>Total Term Duration</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TotalTermType" type="totalTermTypeList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The type of loan term should indicate that the loan term is either the total length of the term or the amortised term as required by the lender.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Term.TotalTermType</lx:path>
                                    <lx:label>Total Term Type</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TotalTermUnits" type="loanTermUnitsList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>Captures the period described by the number specified for term.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.Term.TotalTermUnits</lx:path>
                                    <lx:label>Total Term Units</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="TermsAndConditions" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>The terms and conditions of a loan contract or loan application.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.LoanDetails.TermsAndConditions</lx:path>
                                <lx:label>Terms And Conditions</lx:label>
                                <li:transactions>CAL,DAS</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="TermsCode" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The code used to identify the terms and conditions in the lender's system.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.TermsAndConditions.TermsCode</lx:path>
                                    <lx:label>TermsCode</lx:label>
                                    <li:transactions>CAL,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TermsName" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The name used by the lender for this set of terms and conditions.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.TermsAndConditions.TermsName</lx:path>
                                    <lx:label>TermsName</lx:label>
                                    <li:transactions>CAL,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="TermsVersion" type="stringType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The version used by the lender for this set of terms and conditions.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.LoanDetails.TermsAndConditions.TermsVersion</lx:path>
                                    <lx:label>Terms Version</lx:label>
                                    <li:transactions>CAL,DAS</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                        </xs:sequence>
                        <xs:attribute name="AccelerationPercentage" type="percentType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The amount that is provided to the borrower as a percentage of the total amount that is provided from the invoices for an invoice financing loan.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.AccelerationPercentage</lx:path>
                              <lx:label>Acceleration Percentage</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="AmountRequested" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the loan amount as requested by the applicant for this loan account, exclusive of to-be-capitalised fees and/or LMI.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.AmountRequested</lx:path>
                              <lx:label>Amount Requested</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,VAL,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="AmountRequestedInclusive" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The loan amount as requested by the applicant for this loan account, inclusive of to-be-capitalised fees and LMI.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.AmountRequestedInclusive</lx:path>
                              <lx:label>Amount Requested Inclusive</lx:label>
                              <li:transactions>CAL,CDA,DAS</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="AmountToBeFinanced" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the amount to be financed for this loan account, inclusive of any capitalised fees and/or LMI. This is the limit for limit based products.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.AmountToBeFinanced</lx:path>
                              <lx:label>Amount to Be Financed</lx:label>
                              <li:transactions>CDA,SVC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="BalloonRepaymentAmount" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The proposed nominated balloon repayment amount</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.BalloonRepaymentAmount</lx:path>
                              <lx:label>Balloon Repayment Amount</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="BalloonRepaymentDate" type="dateType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The expected date of the proposed balloon repayment</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.BalloonRepaymentDate</lx:path>
                              <lx:label>Balloon Repayment Date</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="BuyNowPayLater" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The loan is a buy now pay later facility according to the lender's policy.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.BuyNowPayLater</lx:path>
                              <lx:label>Buy Now Pay Later</lx:label>
                              <li:transactions>CAL,CDA,DAS,SVC,LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ConformsWithUnderwritingStandards" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Mortgage conforms to the underwriting standards of the mortgage insurer.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.ConformsWithUnderwritingStandards</lx:path>
                              <lx:label>Conforms With Underwriting Standards</lx:label>
                              <li:transactions>ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ConsiderLowerLimitIfNotEligible" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates that the applicant would like a lower limit to be considered if not eligible for the requested amount.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.ConsiderLowerLimitIfNotEligible</lx:path>
                              <lx:label>Consider Lower Limit If Not Eligible</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="DocType" type="applicationDocTypeList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the level of income verification documentation for each loan provided to the lender.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.DocType</lx:path>
                              <lx:label>Doc Type</lx:label>
                              <li:transactions>ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="EstimatedSettlementDate" type="dateType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the date that the applicant estimates that the application will settle.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.EstimatedSettlementDate</lx:path>
                              <lx:label>Estimated Settlement Date</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="Funder" type="funderList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the name of the loan funder.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.Funder</lx:path>
                              <lx:label>Funder</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="Grade" type="gradeList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Grade of the loan.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.Grade</lx:path>
                              <lx:label>Grade</lx:label>
                              <li:transactions>ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="InterestCalculationFrequency" type="interestChargeFrequencyList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The frequency at which interest will be calculated on the loan.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.InterestCalculationFrequency</lx:path>
                              <lx:label>Interest Calculation Frequency</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="InterestChargeFrequency" type="interestChargeFrequencyList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The frequency at which interest will be charged on the loan.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.InterestChargeFrequency</lx:path>
                              <lx:label>Interest Charge Frequency</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="IsAmountRequestedInForeignCurrency" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>A flag to indicate that the amount is requested in a foreign currency.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.IsAmountRequestedInForeignCurrency</lx:path>
                              <lx:label>Is Amount Requested In Foreign Currency</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="LenderLoanApprovalDate" type="dateType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The date on which the loan was approved by the lender.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.LenderLoanApprovalDate</lx:path>
                              <lx:label>Lender Loan Approval Date</lx:label>
                              <li:transactions>LMI,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="LoanType" type="loanTypeList" use="optional">
                          <xs:annotation>
                            <xs:documentation>The type of credit facility.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.LoanType</lx:path>
                              <lx:label>Credit Facility Type</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="LVR" type="percentType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Loan to value ratio.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.LVR</lx:path>
                              <lx:label>LVR</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI,VAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="MainProduct" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Where a lender requires that the applicant nominate one loan account/product as being the primary or main account within a package or portfolio or accounts, indicates whether this is the main account.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.MainProduct</lx:path>
                              <lx:label>Main Product</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="MaturityDate" type="dateType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The maturity date of the loan.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.MaturityDate</lx:path>
                              <lx:label>Maturity Date</lx:label>
                              <li:transactions>CAL,CDA,DAS</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="MinimumRepaymentRate" type="percentType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The percentage rate used to calculate the minimum repayment for the loan account.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.MinimumRepaymentRate</lx:path>
                              <lx:label>Minimum Repayment Rate</lx:label>
                              <li:transactions>CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="NegativelyGeared" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates whether the interest and maintenance expense will be greater than the rental income</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.NegativelyGeared</lx:path>
                              <lx:label>Negatively Geared</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,LMI</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="NominateBalloonRepayment" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Flag to indicate whether a balloon repayment is proposed (yes) or not proposed (no)</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.NominateBalloonRepayment</lx:path>
                              <lx:label>Nominate Balloon Repayment</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="OriginatorReferenceID" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Unique identifier assigned to the loan detail by the originator system</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.OriginatorReferenceID</lx:path>
                              <lx:label>Originator Reference ID</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ProductCode" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures an identifying code for the loan product applied for. This code is typically issued by the lender and enables the lender's systems to uniquely identify the product.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.ProductCode</lx:path>
                              <lx:label>Product Code</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ProductName" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures the name of the loan product applied for.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.ProductName</lx:path>
                              <lx:label>Product Name</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ProposedAnnualInterestRate" type="percentType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The interest rate that applies to the loan account. Typically expressed as an annual interest rate.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.ProposedAnnualInterestRate</lx:path>
                              <lx:label>Proposed Annual Interest Rate</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="RevertInterestRate" type="percentType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Estimate of the interest rate at the end of the fixed rate period or the end of the interest only period (whichever is longer). The revert interest rate will be an estimate based on the current variable rate.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.RevertInterestRate</lx:path>
                              <lx:label>Revert Interest Rate</lx:label>
                              <li:transactions>CAL,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="Secured" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Whether the credit product is to be secured or not.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.Secured</lx:path>
                              <lx:label>Secured</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="SequenceNumber" type="integerType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The order of this loan details within the sequence.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.SequenceNumber</lx:path>
                              <lx:label>Sequence Number</lx:label>
                              <li:transactions>CAL,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="SMSFLoan" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Flag to note whether the loan is for a self-managed super fund.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.SMSFLoan</lx:path>
                              <lx:label>SMSF Loan</lx:label>
                              <li:transactions>ACC,CAL</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="SpecialConcessionCode" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Captures a lender issued code that identifies a program of the lender that provides certain specified concessions for the loan applied for.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.SpecialConcessionCode</lx:path>
                              <lx:label>Special Concession Code</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="StatementCycle" type="statementCycleList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Indicates preferred frequency for statements</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.StatementCycle</lx:path>
                              <lx:label>Statement Cycle</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="TaxDeductible" type="yesNoList" use="optional">
                          <xs:annotation>
                            <xs:documentation>Flag to indicate if the loan repayments are tax deductible</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.TaxDeductible</lx:path>
                              <lx:label>Tax Deductible</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="TemplateID" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Allow user to preconfigured the Loan attributes at the message receiving end</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.TemplateID</lx:path>
                              <lx:label>Template ID</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                          <xs:annotation>
                            <xs:documentation>System assigned unique identifier</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.UniqueID</lx:path>
                              <lx:label>Unique ID</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ,SVC,LMI,VAL,ACC</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="x_MasterAgreement" type="referenceType" use="optional">
                          <xs:annotation>
                            <xs:documentation>For a loan application under a master agreement, the link to the agreement details</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.LoanDetails.x_MasterAgreement</lx:path>
                              <lx:label>Master Agreement</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              <lx:references>
                                <lx:target>Package.Content.Application.MasterAgreement</lx:target>
                              </lx:references>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                      </xs:complexType>
                    </xs:element>
                    <xs:element name="MasterAgreement" minOccurs="0" maxOccurs="unbounded">
                      <xs:annotation>
                        <xs:documentation>A Master Agreement finance facility is a contractual document under which supplementary agreements for loans can be executed, and existing loans can be brought in.</xs:documentation>
                        <xs:appinfo>
                          <lx:path>Package.Content.Application.MasterAgreement</lx:path>
                          <lx:label>Master Agreement</lx:label>
                          <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                        </xs:appinfo>
                      </xs:annotation>
                      <xs:complexType>
                        <xs:sequence>
                          <xs:element name="AccountToIncorporate" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>For a new agreement that will incorporate existing loan accounts, container for the existing account(s)</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.MasterAgreement.AccountToIncorporate</lx:path>
                                <lx:label>Account To Incorporate</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:attribute name="x_ExistingAccount" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>For a new agreement that will incorporate existing loan accounts, pointer to the existing account(s)</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.MasterAgreement.AccountToIncorporate.x_ExistingAccount</lx:path>
                                    <lx:label>Existing Account</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.Liability</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_NewAccount" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A cross reference to a new account that is being incorporated into the master agreement.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.MasterAgreement.AccountToIncorporate.x_NewAccount</lx:path>
                                    <lx:label>New Account</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.LoanDetails</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                          <xs:element name="PercentOwned" type="percentOwnedType" minOccurs="0" maxOccurs="1">
                            <xs:annotation>
                              <xs:documentation>Identifies the parties that are owners on this master agreement.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.MasterAgreement.PercentOwned</lx:path>
                                <lx:label>Percent Owned</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                          </xs:element>
                          <xs:element name="Security" minOccurs="0" maxOccurs="unbounded">
                            <xs:annotation>
                              <xs:documentation>The security offered under the master agreement finance facility.</xs:documentation>
                              <xs:appinfo>
                                <lx:path>Package.Content.Application.MasterAgreement.Security</lx:path>
                                <lx:label>Security</lx:label>
                                <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                              </xs:appinfo>
                            </xs:annotation>
                            <xs:complexType>
                              <xs:sequence>
                                <xs:element name="PercentOwned" type="percentOwnedType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>This item is now deprecated and will be deleted in a future release. Identifies the parties that are owners on this master agreement.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.MasterAgreement.Security.PercentOwned</lx:path>
                                      <lx:label>Percent Owned</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                                <xs:element name="SecurityAgreement" type="securityAgreementType" minOccurs="0" maxOccurs="1">
                                  <xs:annotation>
                                    <xs:documentation>Security agreement details for this security.</xs:documentation>
                                    <xs:appinfo>
                                      <lx:path>Package.Content.Application.MasterAgreement.Security.SecurityAgreement</lx:path>
                                      <lx:label>Security Agreement</lx:label>
                                      <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    </xs:appinfo>
                                  </xs:annotation>
                                </xs:element>
                              </xs:sequence>
                              <xs:attribute name="Priority" type="securityPriorityList" use="optional">
                                <xs:annotation>
                                  <xs:documentation>The priority of this lender's mortgage on the security property.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.MasterAgreement.Security.Priority</lx:path>
                                    <lx:label>Priority</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="UniqueID" type="uniqueIDType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>System assigned unique identifier.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.MasterAgreement.Security.UniqueID</lx:path>
                                    <lx:label>UniqueID</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                              <xs:attribute name="x_Security" type="referenceType" use="optional">
                                <xs:annotation>
                                  <xs:documentation>A cross reference to the security being offered.</xs:documentation>
                                  <xs:appinfo>
                                    <lx:path>Package.Content.Application.MasterAgreement.Security.x_Security</lx:path>
                                    <lx:label>Security</lx:label>
                                    <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                                    <lx:references>
                                      <lx:target>Package.Content.Application.NonRealEstateAsset</lx:target>
                                      <lx:target>Package.Content.Application.RealEstateAsset</lx:target>
                                      <lx:target>Package.Content.Application.GeneralSecurityAgreement</lx:target>
                                    </lx:references>
                                  </xs:appinfo>
                                </xs:annotation>
                              </xs:attribute>
                            </xs:complexType>
                          </xs:element>
                        </xs:sequence>
                        <xs:attribute name="ApprovedLimit" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>Total approved loan amount.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.MasterAgreement.ApprovedLimit</lx:path>
                              <lx:label>Approved Limit</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="DateOfExecution" type="dateType" use="optional">
                          <xs:annotation>
                            <xs:documentation>For an existing agreement, the date of the agreement</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.MasterAgreement.DateOfExecution</lx:path>
                              <lx:label>Date Of Execution</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="Description" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>A name or description of the facility</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.MasterAgreement.Description</lx:path>
                              <lx:label>Description</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="EndDate" type="dateType" use="optional">
                          <xs:annotation>
                            <xs:documentation>For an existing agreement, the end date of the agreement</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.MasterAgreement.EndDate</lx:path>
                              <lx:label>End Date</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="LenderAgreementNumber" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>For an existing agreement, the lender's identifier of the agreement</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.MasterAgreement.LenderAgreementNumber</lx:path>
                              <lx:label>Lender Agreement Number</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="MasterFacilityLimit" type="currencyType" use="optional">
                          <xs:annotation>
                            <xs:documentation>For a master facility, the requested total umbrella limit</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.MasterAgreement.MasterFacilityLimit</lx:path>
                              <lx:label>Master Facility Limit</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ProductCode" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>An identifying code for the master agreement finance facility product. This code is typically issued by the lender and enables the lender's systems to uniquely identify the product.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.MasterAgreement.ProductCode</lx:path>
                              <lx:label>Product Code</lx:label>
                              <li:transactions>CAL,CDA,DAS,CNZ</li:transactions>
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:attribute>
                        <xs:attribute name="ProductName" type="stringType" use="optional">
                          <xs:annotation>
                            <xs:documentation>The name of the master agreement finance facility product.</xs:documentation>
                            <xs:appinfo>
                              <lx:path>Package.Content.Application.MasterAgreement.ProductName</lx:path>
                              <lx:label>Product Name</lx:label>
                