"""Visual effects for graphic clips"""

from .fade import FadeIn, FadeOut
from .blur import Blur, BlurIn, BlurOut
from .color import Saturation, Brightness, Contrast, BlackAndWhite, Grayscale, Sepia
from .vignette import Vignette
from .zoom import ZoomIn, ZoomOut, KenBurns
from .glitch import Glitch, ChromaticAberration, Pixelate

__all__ = [
    # Fade effects
    'FadeIn',
    'FadeOut',
    # Blur effects
    'Blur',
    'BlurIn',
    'BlurOut',
    # Color effects
    'Saturation',
    'Brightness',
    'Contrast',
    'BlackAndWhite',
    'Grayscale',
    'Sepia',
    # Vignette
    'Vignette',
    # Zoom and motion effects
    'ZoomIn',
    'ZoomOut',
    'KenBurns',
    # Glitch and distortion effects
    'Glitch',
    'ChromaticAberration',
    'Pixelate',
]
