#!/usr/bin/env python3
from setuptools import setup, find_packages

setup(
    name="reasonflow",
    version="0.2.1",
    description="Reasonflow - Workflow Orchestration Framework",
    long_description=open("README.md", encoding="utf-8").read(),
    long_description_content_type="text/markdown",
    author="Sunny Bedi",
    author_email="sunnybedi990@gmail.com",
    url="https://github.com/sunnybedi990/reasonflow",
    packages=find_packages(exclude=["tests*"]),
    install_requires=[
        "reasonchain>=0.1.0",
        "networkx>=3.1",
        "pyyaml>=6.0",
        "requests>=2.31.0",
        "aiohttp>=3.8.5",
        "playwright>=1.40.0",
        "beautifulsoup4>=4.12.0",
        "lxml>=4.9.0",
        "nltk>=3.8.1",
        "textblob>=0.17.1",
        "readability-lxml>=0.8.1",
        "axe-selenium-python>=2.1.6"
    ],
    extras_require={
        "observability": [
            "prometheus-client>=0.17.1",
            "opentelemetry-api>=1.20.0",
            "opentelemetry-sdk>=1.20.0",
            "opentelemetry-exporter-otlp>=1.20.0",
            "influxdb-client>=1.38.0",
            "elasticsearch>=8.10.1",
            "elasticsearch-async>=6.2.0",
            "confluent-kafka>=2.2.0",
            "redis>=5.0.1",
            "aioredis>=2.0.1",
            "aiosmtplib>=2.0.0",
        ],
        "ai": [
            "sentence-transformers>=2.2.2",
            "faiss-cpu>=1.7.4",
            "torch>=2.1.0",
            "transformers>=4.36.0",
            "numpy>=1.24.0",
            "pandas>=2.1.0",
            "scikit-learn>=1.3.0",
        ],
        "docs": [
            "python-docx>=1.0.0",
            "PyPDF2>=3.0.0",
            "pdfplumber>=0.10.0",
            "pytesseract>=0.3.10",
            "pdf2image>=1.16.3",
            "pillow>=10.0.0",
        ],
        "vectors": [
            "pinecone-client>=2.2.4",
            "pymilvus>=2.3.1",
            "qdrant-client>=1.7.0",
            "weaviate-client>=3.25.0",
        ],
        "llm": [
            "openai>=1.3.0",
            "anthropic>=0.7.0",
            "groq>=0.4.0",
        ],
        "api": [
            "fastapi>=0.105.0",
            "uvicorn>=0.24.0",
            "httpx>=0.25.0",
            "requests>=2.31.0",
            "aiohttp>=3.9.0",
            "websockets>=12.0",
        ],
        "storage": [
            "firebase-admin>=6.2.0",
            "boto3>=1.34.0",
            "minio>=7.2.0",
            "cachetools>=5.3.0",
        ],
        "dev": [
            "pytest>=7.4.0",
            "pytest-asyncio>=0.23.0",
            "pytest-cov>=4.1.0",
            "black>=23.12.0",
            "isort>=5.13.0",
            "flake8>=6.1.0",
            "mypy>=1.7.0",
            "pre-commit>=3.6.0",
        ],
        "docs-build": [
            "sphinx>=7.1.0",
            "sphinx-rtd-theme>=1.3.0",
            "mkdocs>=1.5.0",
            "mkdocs-material>=9.5.0",
        ],
        "web": [
            "playwright>=1.40.0",
            "beautifulsoup4>=4.12.0",
            "lxml>=4.9.0",
            "nltk>=3.8.1",
            "textblob>=0.17.1",
            "readability-lxml>=0.8.1",
            "axe-selenium-python>=2.1.6",
            "aiofiles>=23.2.1",
            "html5lib>=1.1",
        ],
    },
    python_requires=">=3.9",
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Topic :: Software Development :: Libraries :: Python Modules",
    ],
    project_urls={
        "Homepage": "https://github.com/sunnybedi990/reasonflow",
        "Documentation": "https://reasonflow.readthedocs.io",
        "Repository": "https://github.com/sunnybedi990/reasonflow.git",
        "Issues": "https://github.com/sunnybedi990/reasonflow/issues",
    },
    include_package_data=True,
    zip_safe=False,
) 