"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Platform = exports.CustomRule = exports.RedirectStatus = exports.App = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const core_1 = require("aws-cdk-lib/core");
const aws_amplify_1 = require("aws-cdk-lib/aws-amplify");
const branch_1 = require("./branch");
const domain_1 = require("./domain");
const utils_1 = require("./utils");
/**
 * An Amplify Console application
 */
class App extends core_1.Resource {
    /**
     * Import an existing application
     */
    static fromAppId(scope, id, appId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.appId = appId;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_AppProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, App);
            }
            throw error;
        }
        this.customRules = props.customRules || [];
        this.environmentVariables = props.environmentVariables || {};
        this.autoBranchEnvironmentVariables = props.autoBranchCreation && props.autoBranchCreation.environmentVariables || {};
        const role = props.role || new iam.Role(this, 'Role', {
            assumedBy: new iam.ServicePrincipal('amplify.amazonaws.com'),
        });
        this.grantPrincipal = role;
        const sourceCodeProviderOptions = props.sourceCodeProvider?.bind(this);
        const app = new aws_amplify_1.CfnApp(this, 'Resource', {
            accessToken: sourceCodeProviderOptions?.accessToken?.unsafeUnwrap(),
            autoBranchCreationConfig: props.autoBranchCreation && {
                autoBranchCreationPatterns: props.autoBranchCreation.patterns,
                basicAuthConfig: props.autoBranchCreation.basicAuth
                    ? props.autoBranchCreation.basicAuth.bind(this, 'BranchBasicAuth')
                    : { enableBasicAuth: false },
                buildSpec: props.autoBranchCreation.buildSpec && props.autoBranchCreation.buildSpec.toBuildSpec(),
                enableAutoBranchCreation: true,
                enableAutoBuild: props.autoBranchCreation.autoBuild ?? true,
                environmentVariables: core_1.Lazy.any({ produce: () => (0, utils_1.renderEnvironmentVariables)(this.autoBranchEnvironmentVariables) }, { omitEmptyArray: true }),
                enablePullRequestPreview: props.autoBranchCreation.pullRequestPreview ?? true,
                pullRequestEnvironmentName: props.autoBranchCreation.pullRequestEnvironmentName,
                stage: props.autoBranchCreation.stage,
            },
            enableBranchAutoDeletion: props.autoBranchDeletion,
            basicAuthConfig: props.basicAuth
                ? props.basicAuth.bind(this, 'AppBasicAuth')
                : { enableBasicAuth: false },
            buildSpec: props.buildSpec && props.buildSpec.toBuildSpec(),
            customRules: core_1.Lazy.any({ produce: () => this.customRules }, { omitEmptyArray: true }),
            description: props.description,
            environmentVariables: core_1.Lazy.any({ produce: () => (0, utils_1.renderEnvironmentVariables)(this.environmentVariables) }, { omitEmptyArray: true }),
            iamServiceRole: role.roleArn,
            name: props.appName || this.node.id,
            oauthToken: sourceCodeProviderOptions?.oauthToken?.unsafeUnwrap(),
            repository: sourceCodeProviderOptions?.repository,
            customHeaders: props.customResponseHeaders ? renderCustomResponseHeaders(props.customResponseHeaders) : undefined,
            platform: props.platform || Platform.WEB,
        });
        this.appId = app.attrAppId;
        this.appName = app.attrAppName;
        this.arn = app.attrArn;
        this.defaultDomain = app.attrDefaultDomain;
    }
    /**
     * Adds a custom rewrite/redirect rule to this application
     */
    addCustomRule(rule) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_CustomRule(rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addCustomRule);
            }
            throw error;
        }
        this.customRules.push(rule);
        return this;
    }
    /**
     * Adds an environment variable to this application.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     */
    addEnvironment(name, value) {
        this.environmentVariables[name] = value;
        return this;
    }
    /**
     * Adds an environment variable to the auto created branch.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     */
    addAutoBranchEnvironment(name, value) {
        this.autoBranchEnvironmentVariables[name] = value;
        return this;
    }
    /**
     * Adds a branch to this application
     */
    addBranch(id, options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_BranchOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addBranch);
            }
            throw error;
        }
        return new branch_1.Branch(this, id, {
            ...options,
            app: this,
        });
    }
    /**
     * Adds a domain to this application
     */
    addDomain(id, options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_DomainOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addDomain);
            }
            throw error;
        }
        return new domain_1.Domain(this, id, {
            ...options,
            app: this,
            autoSubDomainIamRole: this.grantPrincipal,
        });
    }
}
exports.App = App;
_a = JSII_RTTI_SYMBOL_1;
App[_a] = { fqn: "@aws-cdk/aws-amplify-alpha.App", version: "2.100.0-alpha.0" };
/**
 * The status code for a URL rewrite or redirect rule.
 */
var RedirectStatus;
(function (RedirectStatus) {
    /**
     * Rewrite (200)
     */
    RedirectStatus["REWRITE"] = "200";
    /**
     * Permanent redirect (301)
     */
    RedirectStatus["PERMANENT_REDIRECT"] = "301";
    /**
     * Temporary redirect (302)
     */
    RedirectStatus["TEMPORARY_REDIRECT"] = "302";
    /**
     * Not found (404)
     */
    RedirectStatus["NOT_FOUND"] = "404";
    /**
     * Not found rewrite (404)
     */
    RedirectStatus["NOT_FOUND_REWRITE"] = "404-200";
})(RedirectStatus || (exports.RedirectStatus = RedirectStatus = {}));
/**
 * Custom rewrite/redirect rule for an Amplify App.
 *
 * @see https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html
 */
class CustomRule {
    constructor(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_CustomRuleOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CustomRule);
            }
            throw error;
        }
        this.source = options.source;
        this.target = options.target;
        this.status = options.status;
        this.condition = options.condition;
    }
}
exports.CustomRule = CustomRule;
_b = JSII_RTTI_SYMBOL_1;
CustomRule[_b] = { fqn: "@aws-cdk/aws-amplify-alpha.CustomRule", version: "2.100.0-alpha.0" };
/**
 * Sets up a 200 rewrite for all paths to `index.html` except for path
 * containing a file extension.
 */
CustomRule.SINGLE_PAGE_APPLICATION_REDIRECT = new CustomRule({
    source: '</^[^.]+$/>',
    target: '/index.html',
    status: RedirectStatus.REWRITE,
});
function renderCustomResponseHeaders(customHeaders) {
    const yaml = [
        'customHeaders:',
    ];
    for (const customHeader of customHeaders) {
        yaml.push(`  - pattern: "${customHeader.pattern}"`);
        yaml.push('    headers:');
        for (const [key, value] of Object.entries(customHeader.headers)) {
            yaml.push(`      - key: "${key}"`);
            yaml.push(`        value: "${value}"`);
        }
    }
    return `${yaml.join('\n')}\n`;
}
var Platform;
(function (Platform) {
    /**
     * WEB - Used to indicate that the app is hosted using only static assets.
     */
    Platform["WEB"] = "WEB";
    /**
     * WEB_COMPUTE - Used to indicate the app is hosted using a combination of
     * server side rendered and static assets.
     */
    Platform["WEB_COMPUTE"] = "WEB_COMPUTE";
})(Platform || (exports.Platform = Platform = {}));
//# sourceMappingURL=data:application/json;base64,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