"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourceHandler = void 0;
;
class ResourceHandler {
    constructor(event) {
        this.requestType = event.RequestType;
        this.requestId = event.RequestId;
        this.logicalResourceId = event.LogicalResourceId;
        this.physicalResourceId = event.PhysicalResourceId;
        this.event = event;
    }
    onEvent() {
        switch (this.requestType) {
            case 'Create':
                return this.onCreate();
            case 'Update':
                return this.onUpdate();
            case 'Delete':
                return this.onDelete();
        }
        throw new Error(`Invalid request type ${this.requestType}`);
    }
    isComplete() {
        switch (this.requestType) {
            case 'Create':
                return this.isCreateComplete();
            case 'Update':
                return this.isUpdateComplete();
            case 'Delete':
                return this.isDeleteComplete();
        }
        throw new Error(`Invalid request type ${this.requestType}`);
    }
    log(x) {
        // eslint-disable-next-line no-console
        console.log(JSON.stringify(x, undefined, 2));
    }
}
exports.ResourceHandler = ResourceHandler;
//# sourceMappingURL=data:application/json;base64,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