import { Amplify } from '@aws-sdk/client-amplify';
import { S3 } from '@aws-sdk/client-s3';
import { AmplifyJobId, IsCompleteResponse, ResourceEvent, ResourceHandler } from './common';
export interface AmplifyAssetDeploymentProps {
    AppId: string;
    BranchName: string;
    S3BucketName: string;
    S3ObjectKey: string;
    TimeoutSeconds: number;
}
export declare class AmplifyAssetDeploymentHandler extends ResourceHandler {
    private readonly props;
    protected readonly amplify: Amplify;
    protected readonly s3: S3;
    constructor(amplify: Amplify, s3: S3, event: ResourceEvent);
    protected onCreate(): Promise<AmplifyJobId>;
    protected isCreateComplete(): Promise<IsCompleteResponse>;
    protected onDelete(): Promise<void>;
    protected isDeleteComplete(): Promise<IsCompleteResponse>;
    protected onUpdate(): Promise<AmplifyJobId>;
    protected isUpdateComplete(): Promise<IsCompleteResponse>;
    private isActive;
}
