"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isComplete = exports.onEvent = void 0;
// @aws-sdk/* modules available at runtime for lambdas >= Node18
// eslint-disable-next-line import/no-extraneous-dependencies
const client_amplify_1 = require("@aws-sdk/client-amplify");
const client_s3_1 = require("@aws-sdk/client-s3");
const handler_1 = require("./handler");
const AMPLIFY_ASSET_DEPLOYMENT_RESOURCE_TYPE = 'Custom::AmplifyAssetDeployment';
const sdkConfig = { logger: console };
const amplify = new client_amplify_1.Amplify(sdkConfig);
const s3 = new client_s3_1.S3(sdkConfig);
async function onEvent(event) {
    const provider = createResourceHandler(event);
    return provider.onEvent();
}
exports.onEvent = onEvent;
async function isComplete(event) {
    const provider = createResourceHandler(event);
    return provider.isComplete();
}
exports.isComplete = isComplete;
function createResourceHandler(event) {
    switch (event.ResourceType) {
        case AMPLIFY_ASSET_DEPLOYMENT_RESOURCE_TYPE:
            return new handler_1.AmplifyAssetDeploymentHandler(amplify, s3, event);
        default:
            throw new Error(`Unsupported resource type "${event.ResourceType}"`);
    }
}
//# sourceMappingURL=data:application/json;base64,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