# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    The version of the OpenAPI document: 1.1.100
    Contact: info@finbourne.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lusid.api_client import ApiClient
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.models.batch_upsert_instrument_properties_response import BatchUpsertInstrumentPropertiesResponse
from lusid.models.delete_instrument_properties_response import DeleteInstrumentPropertiesResponse
from lusid.models.delete_instrument_response import DeleteInstrumentResponse
from lusid.models.delete_instruments_response import DeleteInstrumentsResponse
from lusid.models.get_instruments_response import GetInstrumentsResponse
from lusid.models.instrument import Instrument
from lusid.models.instrument_definition import InstrumentDefinition
from lusid.models.instrument_models import InstrumentModels
from lusid.models.instrument_properties import InstrumentProperties
from lusid.models.lusid_problem_details import LusidProblemDetails
from lusid.models.lusid_validation_problem_details import LusidValidationProblemDetails
from lusid.models.paged_resource_list_of_instrument import PagedResourceListOfInstrument
from lusid.models.resource_list_of_instrument_id_type_descriptor import ResourceListOfInstrumentIdTypeDescriptor
from lusid.models.resource_list_of_property import ResourceListOfProperty
from lusid.models.resource_list_of_property_interval import ResourceListOfPropertyInterval
from lusid.models.resource_list_of_relationship import ResourceListOfRelationship
from lusid.models.update_instrument_identifier_request import UpdateInstrumentIdentifierRequest
from lusid.models.upsert_instrument_properties_response import UpsertInstrumentPropertiesResponse
from lusid.models.upsert_instrument_property_request import UpsertInstrumentPropertyRequest
from lusid.models.upsert_instruments_response import UpsertInstrumentsResponse


class InstrumentsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def batch_upsert_instrument_properties(self, request_body, **kwargs):  # noqa: E501
        """[EARLY ACCESS] BatchUpsertInstrumentProperties: Batch upsert instruments properties  # noqa: E501

        Create or update one or more properties for particular instruments.    Each instrument property is updated if it exists and created if it does not. For any failures, a reason  is provided.    Properties have an <i>effectiveFrom</i> datetime from which the property is valid, and an <i>effectiveUntil</i>  datetime until which the property is valid. Not supplying an <i>effectiveUntil</i> datetime results in the property being  valid indefinitely, or until the next <i>effectiveFrom</i> datetime of the property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.batch_upsert_instrument_properties(request_body, async_req=True)
        >>> result = thread.get()

        :param request_body: A list of instruments and associated instrument properties to create or update. (required)
        :type request_body: dict(str, UpsertInstrumentPropertyRequest)
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param identifier_effective_at: The effective datetime used to resolve each instrument from the provided identifiers. Defaults to the current LUSID system datetime if not specified.
        :type identifier_effective_at: str
        :param success_mode: Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial.
        :type success_mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: BatchUpsertInstrumentPropertiesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_upsert_instrument_properties_with_http_info(request_body, **kwargs)  # noqa: E501

    def batch_upsert_instrument_properties_with_http_info(self, request_body, **kwargs):  # noqa: E501
        """[EARLY ACCESS] BatchUpsertInstrumentProperties: Batch upsert instruments properties  # noqa: E501

        Create or update one or more properties for particular instruments.    Each instrument property is updated if it exists and created if it does not. For any failures, a reason  is provided.    Properties have an <i>effectiveFrom</i> datetime from which the property is valid, and an <i>effectiveUntil</i>  datetime until which the property is valid. Not supplying an <i>effectiveUntil</i> datetime results in the property being  valid indefinitely, or until the next <i>effectiveFrom</i> datetime of the property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.batch_upsert_instrument_properties_with_http_info(request_body, async_req=True)
        >>> result = thread.get()

        :param request_body: A list of instruments and associated instrument properties to create or update. (required)
        :type request_body: dict(str, UpsertInstrumentPropertyRequest)
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param identifier_effective_at: The effective datetime used to resolve each instrument from the provided identifiers. Defaults to the current LUSID system datetime if not specified.
        :type identifier_effective_at: str
        :param success_mode: Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial.
        :type success_mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (BatchUpsertInstrumentPropertiesResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'request_body',
            'scope',
            'identifier_effective_at',
            'success_mode'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_upsert_instrument_properties" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'request_body' is set
        if self.api_client.client_side_validation and ('request_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_body` when calling `batch_upsert_instrument_properties`")  # noqa: E501

        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `batch_upsert_instrument_properties`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `batch_upsert_instrument_properties`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `batch_upsert_instrument_properties`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('success_mode' in local_var_params and  # noqa: E501
                                                        len(local_var_params['success_mode']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `success_mode` when calling `batch_upsert_instrument_properties`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('success_mode' in local_var_params and  # noqa: E501
                                                        len(local_var_params['success_mode']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `success_mode` when calling `batch_upsert_instrument_properties`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501
        if 'identifier_effective_at' in local_var_params and local_var_params['identifier_effective_at'] is not None:  # noqa: E501
            query_params.append(('identifierEffectiveAt', local_var_params['identifier_effective_at']))  # noqa: E501
        if 'success_mode' in local_var_params and local_var_params['success_mode'] is not None:  # noqa: E501
            query_params.append(('successMode', local_var_params['success_mode']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in local_var_params:
            body_params = local_var_params['request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.100'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            201: "BatchUpsertInstrumentPropertiesResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/$batchupsertproperties', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_instrument(self, identifier_type, identifier, **kwargs):  # noqa: E501
        """[EARLY ACCESS] DeleteInstrument: Soft delete a single instrument  # noqa: E501

        Soft delete a particular instrument, as identified by a particular instrument identifier.                Once deleted, an instrument is marked as inactive and can no longer be referenced when creating or updating  transactions or holdings. You can still query existing transactions and holdings related to the  deleted instrument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_instrument(identifier_type, identifier, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeleteInstrumentResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_instrument_with_http_info(identifier_type, identifier, **kwargs)  # noqa: E501

    def delete_instrument_with_http_info(self, identifier_type, identifier, **kwargs):  # noqa: E501
        """[EARLY ACCESS] DeleteInstrument: Soft delete a single instrument  # noqa: E501

        Soft delete a particular instrument, as identified by a particular instrument identifier.                Once deleted, an instrument is marked as inactive and can no longer be referenced when creating or updating  transactions or holdings. You can still query existing transactions and holdings related to the  deleted instrument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_instrument_with_http_info(identifier_type, identifier, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (DeleteInstrumentResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'identifier_type',
            'identifier',
            'scope'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_instrument" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'identifier_type' is set
        if self.api_client.client_side_validation and ('identifier_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_type` when calling `delete_instrument`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `delete_instrument`")  # noqa: E501

        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `delete_instrument`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `delete_instrument`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `delete_instrument`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier_type' in local_var_params:
            path_params['identifierType'] = local_var_params['identifier_type']  # noqa: E501
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501

        query_params = []
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.100'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "DeleteInstrumentResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/{identifierType}/{identifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_instrument_properties(self, identifier_type, identifier, request_body, **kwargs):  # noqa: E501
        """[EARLY ACCESS] DeleteInstrumentProperties: Delete instrument properties  # noqa: E501

        Delete one or more properties from a particular instrument. If the properties are time-variant then an effective datetime from which  to delete properties must be specified. If the properties are perpetual then it is invalid to specify an effective datetime for deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_instrument_properties(identifier_type, identifier, request_body, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param request_body: A list of property keys from the 'Instruments' domain whose properties to delete. (required)
        :type request_body: list[str]
        :param effective_at: The effective datetime or cut label at which to delete time-variant properties from.              The property must exist at the specified 'effectiveAt' datetime. If the 'effectiveAt' is not provided or is              before the time-variant property exists then a failure is returned. Do not specify this parameter if any of              the properties to delete are perpetual.
        :type effective_at: str
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeleteInstrumentPropertiesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_instrument_properties_with_http_info(identifier_type, identifier, request_body, **kwargs)  # noqa: E501

    def delete_instrument_properties_with_http_info(self, identifier_type, identifier, request_body, **kwargs):  # noqa: E501
        """[EARLY ACCESS] DeleteInstrumentProperties: Delete instrument properties  # noqa: E501

        Delete one or more properties from a particular instrument. If the properties are time-variant then an effective datetime from which  to delete properties must be specified. If the properties are perpetual then it is invalid to specify an effective datetime for deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_instrument_properties_with_http_info(identifier_type, identifier, request_body, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param request_body: A list of property keys from the 'Instruments' domain whose properties to delete. (required)
        :type request_body: list[str]
        :param effective_at: The effective datetime or cut label at which to delete time-variant properties from.              The property must exist at the specified 'effectiveAt' datetime. If the 'effectiveAt' is not provided or is              before the time-variant property exists then a failure is returned. Do not specify this parameter if any of              the properties to delete are perpetual.
        :type effective_at: str
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (DeleteInstrumentPropertiesResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'identifier_type',
            'identifier',
            'request_body',
            'effective_at',
            'scope'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_instrument_properties" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'identifier_type' is set
        if self.api_client.client_side_validation and ('identifier_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_type` when calling `delete_instrument_properties`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `delete_instrument_properties`")  # noqa: E501
        # verify the required parameter 'request_body' is set
        if self.api_client.client_side_validation and ('request_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_body` when calling `delete_instrument_properties`")  # noqa: E501

        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `delete_instrument_properties`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `delete_instrument_properties`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `delete_instrument_properties`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier_type' in local_var_params:
            path_params['identifierType'] = local_var_params['identifier_type']  # noqa: E501
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params and local_var_params['effective_at'] is not None:  # noqa: E501
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in local_var_params:
            body_params = local_var_params['request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.100'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "DeleteInstrumentPropertiesResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/{identifierType}/{identifier}/properties/$delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_instruments(self, request_body, **kwargs):  # noqa: E501
        """[EARLY ACCESS] DeleteInstruments: Soft or hard delete multiple instruments  # noqa: E501

        Deletes a number of instruments identified by LusidInstrumentId.                Soft deletion marks the instrument as inactive so it can no longer be referenced when creating or updating transactions or holdings. You can still query existing transactions and holdings related to the inactive instrument.                In addition to the above behaviour, hard deletion: (i) completely removes all external identifiers from the instrument; (ii) marks the instrument as 'Deleted'; (iii) prepends the instrument's name with 'DELETED '; (iv) prevents the instrument from being returned in list instruments queries.                Following hard deletion, an instrument may only be retrieved by making a direct get instrument request for the LusidInstrumentId. Instrument deletion cannot be undone. Please note that currency instruments cannot currently be deleted.  The maximum number of instruments that this method can delete per request is 2,000.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_instruments(request_body, async_req=True)
        >>> result = thread.get()

        :param request_body: The list of lusidInstrumentId's to delete. (required)
        :type request_body: list[str]
        :param delete_mode: The delete mode to use (defaults to 'Soft').
        :type delete_mode: str
        :param scope: The scope in which the instruments lie. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeleteInstrumentsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_instruments_with_http_info(request_body, **kwargs)  # noqa: E501

    def delete_instruments_with_http_info(self, request_body, **kwargs):  # noqa: E501
        """[EARLY ACCESS] DeleteInstruments: Soft or hard delete multiple instruments  # noqa: E501

        Deletes a number of instruments identified by LusidInstrumentId.                Soft deletion marks the instrument as inactive so it can no longer be referenced when creating or updating transactions or holdings. You can still query existing transactions and holdings related to the inactive instrument.                In addition to the above behaviour, hard deletion: (i) completely removes all external identifiers from the instrument; (ii) marks the instrument as 'Deleted'; (iii) prepends the instrument's name with 'DELETED '; (iv) prevents the instrument from being returned in list instruments queries.                Following hard deletion, an instrument may only be retrieved by making a direct get instrument request for the LusidInstrumentId. Instrument deletion cannot be undone. Please note that currency instruments cannot currently be deleted.  The maximum number of instruments that this method can delete per request is 2,000.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_instruments_with_http_info(request_body, async_req=True)
        >>> result = thread.get()

        :param request_body: The list of lusidInstrumentId's to delete. (required)
        :type request_body: list[str]
        :param delete_mode: The delete mode to use (defaults to 'Soft').
        :type delete_mode: str
        :param scope: The scope in which the instruments lie. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (DeleteInstrumentsResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'request_body',
            'delete_mode',
            'scope'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_instruments" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'request_body' is set
        if self.api_client.client_side_validation and ('request_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_body` when calling `delete_instruments`")  # noqa: E501

        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `delete_instruments`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `delete_instruments`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `delete_instruments`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'delete_mode' in local_var_params and local_var_params['delete_mode'] is not None:  # noqa: E501
            query_params.append(('deleteMode', local_var_params['delete_mode']))  # noqa: E501
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in local_var_params:
            body_params = local_var_params['request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.100'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "DeleteInstrumentsResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/$delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_existing_instrument_models(self, identifier, **kwargs):  # noqa: E501
        """GetExistingInstrumentModels: Retrieve supported pricing models for an existing instrument identified by LUID.  # noqa: E501

        Get the supported pricing models of a single instrument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_existing_instrument_models(identifier, async_req=True)
        >>> result = thread.get()

        :param identifier: A lusid instrument id identifying the instrument. (required)
        :type identifier: str
        :param effective_at: The effective datetime or cut label at which to retrieve the instrument.              Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the instrument. Defaults to              returning the latest version if not specified.
        :type as_at: datetime
        :param instrument_scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type instrument_scope: str
        :param recipe_scope: The scope in which the recipe lies. When not supplied the scope is 'default'.
        :type recipe_scope: str
        :param recipe_code: A unique identifier for an entity, used to obtain configuration recipe details. Default configuration recipe is used if not provided.
        :type recipe_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InstrumentModels
        """
        kwargs['_return_http_data_only'] = True
        return self.get_existing_instrument_models_with_http_info(identifier, **kwargs)  # noqa: E501

    def get_existing_instrument_models_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """GetExistingInstrumentModels: Retrieve supported pricing models for an existing instrument identified by LUID.  # noqa: E501

        Get the supported pricing models of a single instrument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_existing_instrument_models_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param identifier: A lusid instrument id identifying the instrument. (required)
        :type identifier: str
        :param effective_at: The effective datetime or cut label at which to retrieve the instrument.              Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the instrument. Defaults to              returning the latest version if not specified.
        :type as_at: datetime
        :param instrument_scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type instrument_scope: str
        :param recipe_scope: The scope in which the recipe lies. When not supplied the scope is 'default'.
        :type recipe_scope: str
        :param recipe_code: A unique identifier for an entity, used to obtain configuration recipe details. Default configuration recipe is used if not provided.
        :type recipe_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (InstrumentModels, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'identifier',
            'effective_at',
            'as_at',
            'instrument_scope',
            'recipe_scope',
            'recipe_code'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_existing_instrument_models" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `get_existing_instrument_models`")  # noqa: E501

        if self.api_client.client_side_validation and ('identifier' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier` when calling `get_existing_instrument_models`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier` when calling `get_existing_instrument_models`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier` when calling `get_existing_instrument_models`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('instrument_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['instrument_scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `instrument_scope` when calling `get_existing_instrument_models`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('instrument_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['instrument_scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `instrument_scope` when calling `get_existing_instrument_models`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'instrument_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['instrument_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `instrument_scope` when calling `get_existing_instrument_models`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('recipe_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['recipe_scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `recipe_scope` when calling `get_existing_instrument_models`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('recipe_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['recipe_scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `recipe_scope` when calling `get_existing_instrument_models`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'recipe_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['recipe_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `recipe_scope` when calling `get_existing_instrument_models`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('recipe_code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['recipe_code']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `recipe_code` when calling `get_existing_instrument_models`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('recipe_code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['recipe_code']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `recipe_code` when calling `get_existing_instrument_models`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'recipe_code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['recipe_code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `recipe_code` when calling `get_existing_instrument_models`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params and local_var_params['effective_at'] is not None:  # noqa: E501
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'instrument_scope' in local_var_params and local_var_params['instrument_scope'] is not None:  # noqa: E501
            query_params.append(('instrumentScope', local_var_params['instrument_scope']))  # noqa: E501
        if 'recipe_scope' in local_var_params and local_var_params['recipe_scope'] is not None:  # noqa: E501
            query_params.append(('recipeScope', local_var_params['recipe_scope']))  # noqa: E501
        if 'recipe_code' in local_var_params and local_var_params['recipe_code'] is not None:  # noqa: E501
            query_params.append(('recipeCode', local_var_params['recipe_code']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.100'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "InstrumentModels",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/{identifier}/models', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_instrument(self, identifier_type, identifier, **kwargs):  # noqa: E501
        """GetInstrument: Get instrument  # noqa: E501

        Retrieve the definition of a particular instrument, as identified by a particular unique identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument(identifier_type, identifier, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to use, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param effective_at: The effective datetime or cut label at which to retrieve the instrument.              Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the instrument. Defaults to              returning the latest version if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Instrument' domain to decorate onto              the instrument, or from any domain that supports relationships to decorate onto related entities.              These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.
        :type property_keys: list[str]
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param relationship_definition_ids: A list of relationship definitions that are used to decorate related entities              onto the instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.
        :type relationship_definition_ids: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Instrument
        """
        kwargs['_return_http_data_only'] = True
        return self.get_instrument_with_http_info(identifier_type, identifier, **kwargs)  # noqa: E501

    def get_instrument_with_http_info(self, identifier_type, identifier, **kwargs):  # noqa: E501
        """GetInstrument: Get instrument  # noqa: E501

        Retrieve the definition of a particular instrument, as identified by a particular unique identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument_with_http_info(identifier_type, identifier, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to use, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param effective_at: The effective datetime or cut label at which to retrieve the instrument.              Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the instrument. Defaults to              returning the latest version if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Instrument' domain to decorate onto              the instrument, or from any domain that supports relationships to decorate onto related entities.              These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.
        :type property_keys: list[str]
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param relationship_definition_ids: A list of relationship definitions that are used to decorate related entities              onto the instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.
        :type relationship_definition_ids: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (Instrument, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'identifier_type',
            'identifier',
            'effective_at',
            'as_at',
            'property_keys',
            'scope',
            'relationship_definition_ids'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrument" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'identifier_type' is set
        if self.api_client.client_side_validation and ('identifier_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_type` when calling `get_instrument`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `get_instrument`")  # noqa: E501

        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_instrument`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_instrument`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_instrument`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier_type' in local_var_params:
            path_params['identifierType'] = local_var_params['identifier_type']  # noqa: E501
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params and local_var_params['effective_at'] is not None:  # noqa: E501
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'property_keys' in local_var_params and local_var_params['property_keys'] is not None:  # noqa: E501
            query_params.append(('propertyKeys', local_var_params['property_keys']))  # noqa: E501
            collection_formats['propertyKeys'] = 'multi'  # noqa: E501
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501
        if 'relationship_definition_ids' in local_var_params and local_var_params['relationship_definition_ids'] is not None:  # noqa: E501
            query_params.append(('relationshipDefinitionIds', local_var_params['relationship_definition_ids']))  # noqa: E501
            collection_formats['relationshipDefinitionIds'] = 'multi'  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.100'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "Instrument",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/{identifierType}/{identifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_instrument_identifier_types(self, **kwargs):  # noqa: E501
        """GetInstrumentIdentifierTypes: Get instrument identifier types  # noqa: E501

        Retrieve a list of all valid instrument identifier types and whether they are unique or not.                An instrument must have a value for at least one unique identifier type (it can have more than one unique type and value).  In addition, a value is automatically generated for a LUSID Instrument ID (LUID) unique type by the system.                An instrument can have values for multiple non-unique identifier types (or it can have zero non-unique types and values).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument_identifier_types(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfInstrumentIdTypeDescriptor
        """
        kwargs['_return_http_data_only'] = True
        return self.get_instrument_identifier_types_with_http_info(**kwargs)  # noqa: E501

    def get_instrument_identifier_types_with_http_info(self, **kwargs):  # noqa: E501
        """GetInstrumentIdentifierTypes: Get instrument identifier types  # noqa: E501

        Retrieve a list of all valid instrument identifier types and whether they are unique or not.                An instrument must have a value for at least one unique identifier type (it can have more than one unique type and value).  In addition, a value is automatically generated for a LUSID Instrument ID (LUID) unique type by the system.                An instrument can have values for multiple non-unique identifier types (or it can have zero non-unique types and values).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument_identifier_types_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (ResourceListOfInstrumentIdTypeDescriptor, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrument_identifier_types" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.100'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "ResourceListOfInstrumentIdTypeDescriptor",
        }

        return self.api_client.call_api(
            '/api/instruments/identifierTypes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_instrument_properties(self, identifier_type, identifier, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetInstrumentProperties: Get instrument properties  # noqa: E501

        List all the properties of a particular instrument, as identified by a particular unique identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument_properties(identifier_type, identifier, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param effective_at: The effective datetime or cut label at which to list the instrument's properties.              Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the instrument's properties. Defaults to returning              the latest version of each property if not specified.
        :type as_at: datetime
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InstrumentProperties
        """
        kwargs['_return_http_data_only'] = True
        return self.get_instrument_properties_with_http_info(identifier_type, identifier, **kwargs)  # noqa: E501

    def get_instrument_properties_with_http_info(self, identifier_type, identifier, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetInstrumentProperties: Get instrument properties  # noqa: E501

        List all the properties of a particular instrument, as identified by a particular unique identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument_properties_with_http_info(identifier_type, identifier, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param effective_at: The effective datetime or cut label at which to list the instrument's properties.              Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the instrument's properties. Defaults to returning              the latest version of each property if not specified.
        :type as_at: datetime
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (InstrumentProperties, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'identifier_type',
            'identifier',
            'effective_at',
            'as_at',
            'scope'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrument_properties" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'identifier_type' is set
        if self.api_client.client_side_validation and ('identifier_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_type` when calling `get_instrument_properties`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `get_instrument_properties`")  # noqa: E501

        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_instrument_properties`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_instrument_properties`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_instrument_properties`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier_type' in local_var_params:
            path_params['identifierType'] = local_var_params['identifier_type']  # noqa: E501
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params and local_var_params['effective_at'] is not None:  # noqa: E501
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.100'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "InstrumentProperties",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/{identifierType}/{identifier}/properties', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_instrument_property_time_series(self, identifier_type, identifier, property_key, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetInstrumentPropertyTimeSeries: Get instrument property time series  # noqa: E501

        Retrieve the complete time series (history) for a particular property of an instrument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument_property_time_series(identifier_type, identifier, property_key, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param property_key: The property key of a property from the 'Instrument' domain whose history to retrieve.              This must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'. (required)
        :type property_key: str
        :param identifier_effective_at: The effective datetime used to resolve the instrument from the identifier.              Defaults to the current LUSID system datetime if not specified.
        :type identifier_effective_at: str
        :param as_at: The asAt datetime at which to retrieve the instrument's property history. Defaults to              returning the current datetime if not supplied.
        :type as_at: datetime
        :param filter: Expression to filter the results. For more information about filtering,              see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param page: The pagination token to use to continue listing properties; this value is returned from              the previous call. If a pagination token is provided, the <i>filter</i>, <i>effectiveAt</i> and              <i>asAt</i> fields must not have changed since the original request. For more information, see              https://support.lusid.com/knowledgebase/article/KA-01915.
        :type page: str
        :param limit: When paginating, limit the results to this number.
        :type limit: int
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfPropertyInterval
        """
        kwargs['_return_http_data_only'] = True
        return self.get_instrument_property_time_series_with_http_info(identifier_type, identifier, property_key, **kwargs)  # noqa: E501

    def get_instrument_property_time_series_with_http_info(self, identifier_type, identifier, property_key, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetInstrumentPropertyTimeSeries: Get instrument property time series  # noqa: E501

        Retrieve the complete time series (history) for a particular property of an instrument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument_property_time_series_with_http_info(identifier_type, identifier, property_key, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param property_key: The property key of a property from the 'Instrument' domain whose history to retrieve.              This must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'. (required)
        :type property_key: str
        :param identifier_effective_at: The effective datetime used to resolve the instrument from the identifier.              Defaults to the current LUSID system datetime if not specified.
        :type identifier_effective_at: str
        :param as_at: The asAt datetime at which to retrieve the instrument's property history. Defaults to              returning the current datetime if not supplied.
        :type as_at: datetime
        :param filter: Expression to filter the results. For more information about filtering,              see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param page: The pagination token to use to continue listing properties; this value is returned from              the previous call. If a pagination token is provided, the <i>filter</i>, <i>effectiveAt</i> and              <i>asAt</i> fields must not have changed since the original request. For more information, see              https://support.lusid.com/knowledgebase/article/KA-01915.
        :type page: str
        :param limit: When paginating, limit the results to this number.
        :type limit: int
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (ResourceListOfPropertyInterval, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'identifier_type',
            'identifier',
            'property_key',
            'identifier_effective_at',
            'as_at',
            'filter',
            'page',
            'limit',
            'scope'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrument_property_time_series" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'identifier_type' is set
        if self.api_client.client_side_validation and ('identifier_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_type` when calling `get_instrument_property_time_series`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `get_instrument_property_time_series`")  # noqa: E501
        # verify the required parameter 'property_key' is set
        if self.api_client.client_side_validation and ('property_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['property_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `property_key` when calling `get_instrument_property_time_series`")  # noqa: E501

        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) > 16384):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `get_instrument_property_time_series`, length must be less than or equal to `16384`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) < 0):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `get_instrument_property_time_series`, length must be greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'filter' in local_var_params and not re.search(r'^[\s\S]*$', local_var_params['filter']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `get_instrument_property_time_series`, must conform to the pattern `/^[\s\S]*$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('page' in local_var_params and  # noqa: E501
                                                        len(local_var_params['page']) > 500):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `get_instrument_property_time_series`, length must be less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and ('page' in local_var_params and  # noqa: E501
                                                        len(local_var_params['page']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `get_instrument_property_time_series`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'page' in local_var_params and not re.search(r'^[a-zA-Z0-9\+\/]*={0,3}$', local_var_params['page']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `get_instrument_property_time_series`, must conform to the pattern `/^[a-zA-Z0-9\+\/]*={0,3}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 5000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_instrument_property_time_series`, must be a value less than or equal to `5000`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_instrument_property_time_series`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_instrument_property_time_series`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_instrument_property_time_series`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_instrument_property_time_series`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier_type' in local_var_params:
            path_params['identifierType'] = local_var_params['identifier_type']  # noqa: E501
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501

        query_params = []
        if 'property_key' in local_var_params and local_var_params['property_key'] is not None:  # noqa: E501
            query_params.append(('propertyKey', local_var_params['property_key']))  # noqa: E501
        if 'identifier_effective_at' in local_var_params and local_var_params['identifier_effective_at'] is not None:  # noqa: E501
            query_params.append(('identifierEffectiveAt', local_var_params['identifier_effective_at']))  # noqa: E501
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.100'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "ResourceListOfPropertyInterval",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/{identifierType}/{identifier}/properties/time-series', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_instrument_relationships(self, identifier_type, identifier, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetInstrumentRelationships: Get Instrument relationships  # noqa: E501

        Get relationships for a particular Instrument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument_relationships(identifier_type, identifier, async_req=True)
        >>> result = thread.get()

        :param identifier_type: An identifier type attached to the Instrument. (required)
        :type identifier_type: str
        :param identifier: The identifier value. (required)
        :type identifier: str
        :param effective_at: The effective datetime or cut label at which to get relationships. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve relationships. Defaults to return the latest LUSID AsAt time if not specified.
        :type as_at: datetime
        :param filter: Expression to filter relationships. Users should provide null or empty string for this field until further notice.
        :type filter: str
        :param identifier_types: Identifier types (as property keys) used for referencing Persons or Legal Entities.              These can be specified from the 'Person' or 'LegalEntity' domains and have the format {domain}/{scope}/{code}, for example              'Person/CompanyDetails/Role'. An Empty array may be used to return all related Entities.
        :type identifier_types: list[str]
        :param scope: The entity scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfRelationship
        """
        kwargs['_return_http_data_only'] = True
        return self.get_instrument_relationships_with_http_info(identifier_type, identifier, **kwargs)  # noqa: E501

    def get_instrument_relationships_with_http_info(self, identifier_type, identifier, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetInstrumentRelationships: Get Instrument relationships  # noqa: E501

        Get relationships for a particular Instrument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument_relationships_with_http_info(identifier_type, identifier, async_req=True)
        >>> result = thread.get()

        :param identifier_type: An identifier type attached to the Instrument. (required)
        :type identifier_type: str
        :param identifier: The identifier value. (required)
        :type identifier: str
        :param effective_at: The effective datetime or cut label at which to get relationships. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve relationships. Defaults to return the latest LUSID AsAt time if not specified.
        :type as_at: datetime
        :param filter: Expression to filter relationships. Users should provide null or empty string for this field until further notice.
        :type filter: str
        :param identifier_types: Identifier types (as property keys) used for referencing Persons or Legal Entities.              These can be specified from the 'Person' or 'LegalEntity' domains and have the format {domain}/{scope}/{code}, for example              'Person/CompanyDetails/Role'. An Empty array may be used to return all related Entities.
        :type identifier_types: list[str]
        :param scope: The entity scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (ResourceListOfRelationship, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'identifier_type',
            'identifier',
            'effective_at',
            'as_at',
            'filter',
            'identifier_types',
            'scope'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrument_relationships" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'identifier_type' is set
        if self.api_client.client_side_validation and ('identifier_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_type` when calling `get_instrument_relationships`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `get_instrument_relationships`")  # noqa: E501

        if self.api_client.client_side_validation and ('identifier_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_type']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `get_instrument_relationships`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_type']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `get_instrument_relationships`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_type' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_type']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `get_instrument_relationships`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier` when calling `get_instrument_relationships`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier` when calling `get_instrument_relationships`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier` when calling `get_instrument_relationships`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('effective_at' in local_var_params and  # noqa: E501
                                                        len(local_var_params['effective_at']) > 256):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `get_instrument_relationships`, length must be less than or equal to `256`")  # noqa: E501
        if self.api_client.client_side_validation and ('effective_at' in local_var_params and  # noqa: E501
                                                        len(local_var_params['effective_at']) < 0):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `get_instrument_relationships`, length must be greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'effective_at' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_\+:\.]+$', local_var_params['effective_at']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `get_instrument_relationships`, must conform to the pattern `/^[a-zA-Z0-9\-_\+:\.]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) > 16384):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `get_instrument_relationships`, length must be less than or equal to `16384`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) < 0):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `get_instrument_relationships`, length must be greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'filter' in local_var_params and not re.search(r'^[\s\S]*$', local_var_params['filter']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `get_instrument_relationships`, must conform to the pattern `/^[\s\S]*$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_instrument_relationships`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_instrument_relationships`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_instrument_relationships`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier_type' in local_var_params:
            path_params['identifierType'] = local_var_params['identifier_type']  # noqa: E501
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params and local_var_params['effective_at'] is not None:  # noqa: E501
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'identifier_types' in local_var_params and local_var_params['identifier_types'] is not None:  # noqa: E501
            query_params.append(('identifierTypes', local_var_params['identifier_types']))  # noqa: E501
            collection_formats['identifierTypes'] = 'multi'  # noqa: E501
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.100'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "ResourceListOfRelationship",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/{identifierType}/{identifier}/relationships', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_instruments(self, identifier_type, request_body, **kwargs):  # noqa: E501
        """GetInstruments: Get instruments  # noqa: E501

        Retrieve the definition of one or more instruments, as identified by a collection of unique identifiers.                Note that to retrieve all the instruments in the instrument master, use the List instruments endpoint instead.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instruments(identifier_type, request_body, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to use, for example 'Figi'. (required)
        :type identifier_type: str
        :param request_body: A list of one or more <i>identifierType</i> values to use to identify instruments. (required)
        :type request_body: list[str]
        :param effective_at: The effective datetime or cut label at which to retrieve the instrument definitions.               Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the instrument definitions.               Defaults to returning the latest version of each instrument definition if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Instrument' domain to decorate onto               each instrument, or from any domain that supports relationships to decorate onto related entities.               These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.
        :type property_keys: list[str]
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param relationship_definition_ids: A list of relationship definitions that are used to decorate related entities               onto each instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.
        :type relationship_definition_ids: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetInstrumentsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_instruments_with_http_info(identifier_type, request_body, **kwargs)  # noqa: E501

    def get_instruments_with_http_info(self, identifier_type, request_body, **kwargs):  # noqa: E501
        """GetInstruments: Get instruments  # noqa: E501

        Retrieve the definition of one or more instruments, as identified by a collection of unique identifiers.                Note that to retrieve all the instruments in the instrument master, use the List instruments endpoint instead.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instruments_with_http_info(identifier_type, request_body, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to use, for example 'Figi'. (required)
        :type identifier_type: str
        :param request_body: A list of one or more <i>identifierType</i> values to use to identify instruments. (required)
        :type request_body: list[str]
        :param effective_at: The effective datetime or cut label at which to retrieve the instrument definitions.               Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the instrument definitions.               Defaults to returning the latest version of each instrument definition if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Instrument' domain to decorate onto               each instrument, or from any domain that supports relationships to decorate onto related entities.               These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.
        :type property_keys: list[str]
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param relationship_definition_ids: A list of relationship definitions that are used to decorate related entities               onto each instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.
        :type relationship_definition_ids: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (GetInstrumentsResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'identifier_type',
            'request_body',
            'effective_at',
            'as_at',
            'property_keys',
            'scope',
            'relationship_definition_ids'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instruments" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'identifier_type' is set
        if self.api_client.client_side_validation and ('identifier_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_type` when calling `get_instruments`")  # noqa: E501
        # verify the required parameter 'request_body' is set
        if self.api_client.client_side_validation and ('request_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_body` when calling `get_instruments`")  # noqa: E501

        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_instruments`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_instruments`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_instruments`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'identifier_type' in local_var_params and local_var_params['identifier_type'] is not None:  # noqa: E501
            query_params.append(('identifierType', local_var_params['identifier_type']))  # noqa: E501
        if 'effective_at' in local_var_params and local_var_params['effective_at'] is not None:  # noqa: E501
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'property_keys' in local_var_params and local_var_params['property_keys'] is not None:  # noqa: E501
            query_params.append(('propertyKeys', local_var_params['property_keys']))  # noqa: E501
            collection_formats['propertyKeys'] = 'multi'  # noqa: E501
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501
        if 'relationship_definition_ids' in local_var_params and local_var_params['relationship_definition_ids'] is not None:  # noqa: E501
            query_params.append(('relationshipDefinitionIds', local_var_params['relationship_definition_ids']))  # noqa: E501
            collection_formats['relationshipDefinitionIds'] = 'multi'  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in local_var_params:
            body_params = local_var_params['request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.100'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "GetInstrumentsResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/$get', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_instrument_properties(self, identifier_type, identifier, **kwargs):  # noqa: E501
        """[EARLY ACCESS] ListInstrumentProperties: Get instrument properties (with Pagination)  # noqa: E501

        List all the properties of a particular instrument, as identified by a particular unique identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_instrument_properties(identifier_type, identifier, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param effective_at: The effective datetime or cut label at which to list the instrument's properties.              Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the instrument's properties. Defaults to returning              the latest version of each property if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing commands; this value is returned from the previous call.
        :type page: str
        :param limit: When paginating, limit the results per page to this number.
        :type limit: int
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfProperty
        """
        kwargs['_return_http_data_only'] = True
        return self.list_instrument_properties_with_http_info(identifier_type, identifier, **kwargs)  # noqa: E501

    def list_instrument_properties_with_http_info(self, identifier_type, identifier, **kwargs):  # noqa: E501
        """[EARLY ACCESS] ListInstrumentProperties: Get instrument properties (with Pagination)  # noqa: E501

        List all the properties of a particular instrument, as identified by a particular unique identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_instrument_properties_with_http_info(identifier_type, identifier, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param effective_at: The effective datetime or cut label at which to list the instrument's properties.              Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the instrument's properties. Defaults to returning              the latest version of each property if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing commands; this value is returned from the previous call.
        :type page: str
        :param limit: When paginating, limit the results per page to this number.
        :type limit: int
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (ResourceListOfProperty, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'identifier_type',
            'identifier',
            'effective_at',
            'as_at',
            'page',
            'limit',
            'scope'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_instrument_properties" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'identifier_type' is set
        if self.api_client.client_side_validation and ('identifier_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_type` when calling `list_instrument_properties`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `list_instrument_properties`")  # noqa: E501

        if self.api_client.client_side_validation and ('effective_at' in local_var_params and  # noqa: E501
                                                        len(local_var_params['effective_at']) > 256):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `list_instrument_properties`, length must be less than or equal to `256`")  # noqa: E501
        if self.api_client.client_side_validation and ('effective_at' in local_var_params and  # noqa: E501
                                                        len(local_var_params['effective_at']) < 0):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `list_instrument_properties`, length must be greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'effective_at' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_\+:\.]+$', local_var_params['effective_at']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `list_instrument_properties`, must conform to the pattern `/^[a-zA-Z0-9\-_\+:\.]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('page' in local_var_params and  # noqa: E501
                                                        len(local_var_params['page']) > 500):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_instrument_properties`, length must be less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and ('page' in local_var_params and  # noqa: E501
                                                        len(local_var_params['page']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_instrument_properties`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'page' in local_var_params and not re.search(r'^[a-zA-Z0-9\+\/]*={0,3}$', local_var_params['page']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_instrument_properties`, must conform to the pattern `/^[a-zA-Z0-9\+\/]*={0,3}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 5000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_instrument_properties`, must be a value less than or equal to `5000`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_instrument_properties`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `list_instrument_properties`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `list_instrument_properties`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `list_instrument_properties`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier_type' in local_var_params:
            path_params['identifierType'] = local_var_params['identifier_type']  # noqa: E501
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params and local_var_params['effective_at'] is not None:  # noqa: E501
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.100'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "ResourceListOfProperty",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/{identifierType}/{identifier}/properties/list', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_instruments(self, **kwargs):  # noqa: E501
        """ListInstruments: List instruments  # noqa: E501

        List all the instruments in the instrument master.                To retrieve a particular set of instruments instead, use the Get instruments endpoint.  The maximum number of instruments that this method can list per request is 2,000.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_instruments(async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to list instruments. Defaults to returning the latest               version of each instrument if not specified.
        :type as_at: datetime
        :param effective_at: The effective datetime or cut label at which to list instruments.               Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param page: The pagination token to use to continue listing instruments; this value is returned from               the previous call. If a pagination token is provided, the <i>sortBy</i>, <i>filter</i>, <i>effectiveAt</i> and               <i>asAt</i> fields must not have changed since the original request.               For more information, see https://support.lusid.com/knowledgebase/article/KA-01915.
        :type page: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: list[str]
        :param limit: When paginating, limit the results to this number.
        :type limit: int
        :param filter: Expression to filter the result set. Defaults to filtering out inactive instruments               (that is, those that have been deleted). For more information about filtering results,               see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param instrument_property_keys: A list of property keys from the 'Instrument' domain to decorate onto               instruments, or from any domain that supports relationships to decorate onto related entities.               These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.
        :type instrument_property_keys: list[str]
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param relationship_definition_ids: A list of relationship definitions that are used to decorate related entities               onto each instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.
        :type relationship_definition_ids: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfInstrument
        """
        kwargs['_return_http_data_only'] = True
        return self.list_instruments_with_http_info(**kwargs)  # noqa: E501

    def list_instruments_with_http_info(self, **kwargs):  # noqa: E501
        """ListInstruments: List instruments  # noqa: E501

        List all the instruments in the instrument master.                To retrieve a particular set of instruments instead, use the Get instruments endpoint.  The maximum number of instruments that this method can list per request is 2,000.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_instruments_with_http_info(async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to list instruments. Defaults to returning the latest               version of each instrument if not specified.
        :type as_at: datetime
        :param effective_at: The effective datetime or cut label at which to list instruments.               Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param page: The pagination token to use to continue listing instruments; this value is returned from               the previous call. If a pagination token is provided, the <i>sortBy</i>, <i>filter</i>, <i>effectiveAt</i> and               <i>asAt</i> fields must not have changed since the original request.               For more information, see https://support.lusid.com/knowledgebase/article/KA-01915.
        :type page: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: list[str]
        :param limit: When paginating, limit the results to this number.
        :type limit: int
        :param filter: Expression to filter the result set. Defaults to filtering out inactive instruments               (that is, those that have been deleted). For more information about filtering results,               see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param instrument_property_keys: A list of property keys from the 'Instrument' domain to decorate onto               instruments, or from any domain that supports relationships to decorate onto related entities.               These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.
        :type instrument_property_keys: list[str]
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param relationship_definition_ids: A list of relationship definitions that are used to decorate related entities               onto each instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.
        :type relationship_definition_ids: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (PagedResourceListOfInstrument, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'as_at',
            'effective_at',
            'page',
            'sort_by',
            'limit',
            'filter',
            'instrument_property_keys',
            'scope',
            'relationship_definition_ids'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_instruments" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and ('page' in local_var_params and  # noqa: E501
                                                        len(local_var_params['page']) > 500):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_instruments`, length must be less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and ('page' in local_var_params and  # noqa: E501
                                                        len(local_var_params['page']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_instruments`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'page' in local_var_params and not re.search(r'^[a-zA-Z0-9\+\/]*={0,3}$', local_var_params['page']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_instruments`, must conform to the pattern `/^[a-zA-Z0-9\+\/]*={0,3}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 5000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_instruments`, must be a value less than or equal to `5000`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_instruments`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) > 16384):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_instruments`, length must be less than or equal to `16384`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) < 0):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_instruments`, length must be greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'filter' in local_var_params and not re.search(r'^[\s\S]*$', local_var_params['filter']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_instruments`, must conform to the pattern `/^[\s\S]*$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `list_instruments`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `list_instruments`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `list_instruments`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'effective_at' in local_var_params and local_var_params['effective_at'] is not None:  # noqa: E501
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
            collection_formats['sortBy'] = 'multi'  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'instrument_property_keys' in local_var_params and local_var_params['instrument_property_keys'] is not None:  # noqa: E501
            query_params.append(('instrumentPropertyKeys', local_var_params['instrument_property_keys']))  # noqa: E501
            collection_formats['instrumentPropertyKeys'] = 'multi'  # noqa: E501
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501
        if 'relationship_definition_ids' in local_var_params and local_var_params['relationship_definition_ids'] is not None:  # noqa: E501
            query_params.append(('relationshipDefinitionIds', local_var_params['relationship_definition_ids']))  # noqa: E501
            collection_formats['relationshipDefinitionIds'] = 'multi'  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.100'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "PagedResourceListOfInstrument",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_instrument_identifier(self, identifier_type, identifier, update_instrument_identifier_request, **kwargs):  # noqa: E501
        """UpdateInstrumentIdentifier: Update instrument identifier  # noqa: E501

        Create, update or delete a particular instrument identifier for an instrument.                To delete the identifier, leave the value unspecified in the request. If not being deleted, the  identifier is updated if it exists and created if it does not.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_instrument_identifier(identifier_type, identifier, update_instrument_identifier_request, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param update_instrument_identifier_request: The identifier to update or delete. This need not be the same value as the               'identifier' parameter used to retrieve the instrument. (required)
        :type update_instrument_identifier_request: UpdateInstrumentIdentifierRequest
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Instrument
        """
        kwargs['_return_http_data_only'] = True
        return self.update_instrument_identifier_with_http_info(identifier_type, identifier, update_instrument_identifier_request, **kwargs)  # noqa: E501

    def update_instrument_identifier_with_http_info(self, identifier_type, identifier, update_instrument_identifier_request, **kwargs):  # noqa: E501
        """UpdateInstrumentIdentifier: Update instrument identifier  # noqa: E501

        Create, update or delete a particular instrument identifier for an instrument.                To delete the identifier, leave the value unspecified in the request. If not being deleted, the  identifier is updated if it exists and created if it does not.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_instrument_identifier_with_http_info(identifier_type, identifier, update_instrument_identifier_request, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param update_instrument_identifier_request: The identifier to update or delete. This need not be the same value as the               'identifier' parameter used to retrieve the instrument. (required)
        :type update_instrument_identifier_request: UpdateInstrumentIdentifierRequest
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (Instrument, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'identifier_type',
            'identifier',
            'update_instrument_identifier_request',
            'scope'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_instrument_identifier" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'identifier_type' is set
        if self.api_client.client_side_validation and ('identifier_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_type` when calling `update_instrument_identifier`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `update_instrument_identifier`")  # noqa: E501
        # verify the required parameter 'update_instrument_identifier_request' is set
        if self.api_client.client_side_validation and ('update_instrument_identifier_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_instrument_identifier_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_instrument_identifier_request` when calling `update_instrument_identifier`")  # noqa: E501

        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `update_instrument_identifier`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `update_instrument_identifier`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `update_instrument_identifier`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier_type' in local_var_params:
            path_params['identifierType'] = local_var_params['identifier_type']  # noqa: E501
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501

        query_params = []
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_instrument_identifier_request' in local_var_params:
            body_params = local_var_params['update_instrument_identifier_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.100'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "Instrument",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/{identifierType}/{identifier}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def upsert_instruments(self, request_body, **kwargs):  # noqa: E501
        """UpsertInstruments: Upsert instruments  # noqa: E501

        Create or update one or more instruments in the instrument master. An instrument is updated  if it already exists and created if it does not.                In the request, each instrument definition should be keyed by a unique correlation ID. This ID is ephemeral  and not stored by LUSID. It serves only to easily identify each instrument in the response.                Note that an instrument must have at least one unique identifier, which is a combination of a type  (such as 'Figi') and a value (such as 'BBG000BS1N49'). In addition, a random value is automatically  generated for a LUSID Instrument ID (LUID) unique type by the system. For more information, see  https://support.lusid.com/knowledgebase/article/KA-01862.                The response returns both the collection of successfully created or updated instruments, as well as those  that failed. For each failure, a reason is provided. It is important to check the failed set for  unsuccessful results.  The maximum number of instruments that this method can upsert per request is 2,000.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_instruments(request_body, async_req=True)
        >>> result = thread.get()

        :param request_body: The definitions of the instruments to create or update. (required)
        :type request_body: dict(str, InstrumentDefinition)
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpsertInstrumentsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.upsert_instruments_with_http_info(request_body, **kwargs)  # noqa: E501

    def upsert_instruments_with_http_info(self, request_body, **kwargs):  # noqa: E501
        """UpsertInstruments: Upsert instruments  # noqa: E501

        Create or update one or more instruments in the instrument master. An instrument is updated  if it already exists and created if it does not.                In the request, each instrument definition should be keyed by a unique correlation ID. This ID is ephemeral  and not stored by LUSID. It serves only to easily identify each instrument in the response.                Note that an instrument must have at least one unique identifier, which is a combination of a type  (such as 'Figi') and a value (such as 'BBG000BS1N49'). In addition, a random value is automatically  generated for a LUSID Instrument ID (LUID) unique type by the system. For more information, see  https://support.lusid.com/knowledgebase/article/KA-01862.                The response returns both the collection of successfully created or updated instruments, as well as those  that failed. For each failure, a reason is provided. It is important to check the failed set for  unsuccessful results.  The maximum number of instruments that this method can upsert per request is 2,000.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_instruments_with_http_info(request_body, async_req=True)
        >>> result = thread.get()

        :param request_body: The definitions of the instruments to create or update. (required)
        :type request_body: dict(str, InstrumentDefinition)
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (UpsertInstrumentsResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'request_body',
            'scope'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_instruments" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'request_body' is set
        if self.api_client.client_side_validation and ('request_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_body` when calling `upsert_instruments`")  # noqa: E501

        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `upsert_instruments`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `upsert_instruments`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `upsert_instruments`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in local_var_params:
            body_params = local_var_params['request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.100'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            201: "UpsertInstrumentsResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def upsert_instruments_properties(self, upsert_instrument_property_request, **kwargs):  # noqa: E501
        """UpsertInstrumentsProperties: Upsert instruments properties  # noqa: E501

        Create or update one or more properties for particular instruments.                Each instrument property is updated if it exists and created if it does not. For any failures, a reason  is provided.                Properties have an <i>effectiveFrom</i> datetime from which the property is valid, and an <i>effectiveUntil</i>  datetime until which the property is valid. Not supplying an <i>effectiveUntil</i> datetime results in the property being  valid indefinitely, or until the next <i>effectiveFrom</i> datetime of the property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_instruments_properties(upsert_instrument_property_request, async_req=True)
        >>> result = thread.get()

        :param upsert_instrument_property_request: A list of instruments and associated instrument properties to create or update. (required)
        :type upsert_instrument_property_request: list[UpsertInstrumentPropertyRequest]
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpsertInstrumentPropertiesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.upsert_instruments_properties_with_http_info(upsert_instrument_property_request, **kwargs)  # noqa: E501

    def upsert_instruments_properties_with_http_info(self, upsert_instrument_property_request, **kwargs):  # noqa: E501
        """UpsertInstrumentsProperties: Upsert instruments properties  # noqa: E501

        Create or update one or more properties for particular instruments.                Each instrument property is updated if it exists and created if it does not. For any failures, a reason  is provided.                Properties have an <i>effectiveFrom</i> datetime from which the property is valid, and an <i>effectiveUntil</i>  datetime until which the property is valid. Not supplying an <i>effectiveUntil</i> datetime results in the property being  valid indefinitely, or until the next <i>effectiveFrom</i> datetime of the property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_instruments_properties_with_http_info(upsert_instrument_property_request, async_req=True)
        >>> result = thread.get()

        :param upsert_instrument_property_request: A list of instruments and associated instrument properties to create or update. (required)
        :type upsert_instrument_property_request: list[UpsertInstrumentPropertyRequest]
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (UpsertInstrumentPropertiesResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'upsert_instrument_property_request',
            'scope'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_instruments_properties" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'upsert_instrument_property_request' is set
        if self.api_client.client_side_validation and ('upsert_instrument_property_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['upsert_instrument_property_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `upsert_instrument_property_request` when calling `upsert_instruments_properties`")  # noqa: E501

        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `upsert_instruments_properties`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `upsert_instruments_properties`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `upsert_instruments_properties`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'upsert_instrument_property_request' in local_var_params:
            body_params = local_var_params['upsert_instrument_property_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.100'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            201: "UpsertInstrumentPropertiesResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/$upsertproperties', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
