# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetServersResult',
    'AwaitableGetServersResult',
    'get_servers',
    'get_servers_output',
]

@pulumi.output_type
class GetServersResult:
    """
    A collection of values returned by getServers.
    """
    def __init__(__self__, id=None, servers=None, with_selector=None, with_statuses=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if servers and not isinstance(servers, list):
            raise TypeError("Expected argument 'servers' to be a list")
        pulumi.set(__self__, "servers", servers)
        if with_selector and not isinstance(with_selector, str):
            raise TypeError("Expected argument 'with_selector' to be a str")
        pulumi.set(__self__, "with_selector", with_selector)
        if with_statuses and not isinstance(with_statuses, list):
            raise TypeError("Expected argument 'with_statuses' to be a list")
        pulumi.set(__self__, "with_statuses", with_statuses)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def servers(self) -> Sequence['outputs.GetServersServerResult']:
        """
        (list) List of all matching servers. See `data.hcloud_server` for schema.
        """
        return pulumi.get(self, "servers")

    @property
    @pulumi.getter(name="withSelector")
    def with_selector(self) -> Optional[str]:
        return pulumi.get(self, "with_selector")

    @property
    @pulumi.getter(name="withStatuses")
    def with_statuses(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "with_statuses")


class AwaitableGetServersResult(GetServersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServersResult(
            id=self.id,
            servers=self.servers,
            with_selector=self.with_selector,
            with_statuses=self.with_statuses)


def get_servers(with_selector: Optional[str] = None,
                with_statuses: Optional[Sequence[str]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServersResult:
    """
    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    s3 = hcloud.get_servers(with_selector="key=value")
    ```
    <!--End PulumiCodeChooser -->


    :param str with_selector: Label Selector. For more information about possible values, visit the [Hetzner Cloud Documentation](https://docs.hetzner.cloud/#overview-label-selector).
    :param Sequence[str] with_statuses: List only servers with the specified status, could contain `initializing`, `starting`, `running`, `stopping`, `off`, `deleting`, `rebuilding`, `migrating`, `unknown`.
    """
    __args__ = dict()
    __args__['withSelector'] = with_selector
    __args__['withStatuses'] = with_statuses
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('hcloud:index/getServers:getServers', __args__, opts=opts, typ=GetServersResult).value

    return AwaitableGetServersResult(
        id=pulumi.get(__ret__, 'id'),
        servers=pulumi.get(__ret__, 'servers'),
        with_selector=pulumi.get(__ret__, 'with_selector'),
        with_statuses=pulumi.get(__ret__, 'with_statuses'))


@_utilities.lift_output_func(get_servers)
def get_servers_output(with_selector: Optional[pulumi.Input[Optional[str]]] = None,
                       with_statuses: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServersResult]:
    """
    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    s3 = hcloud.get_servers(with_selector="key=value")
    ```
    <!--End PulumiCodeChooser -->


    :param str with_selector: Label Selector. For more information about possible values, visit the [Hetzner Cloud Documentation](https://docs.hetzner.cloud/#overview-label-selector).
    :param Sequence[str] with_statuses: List only servers with the specified status, could contain `initializing`, `starting`, `running`, `stopping`, `off`, `deleting`, `rebuilding`, `migrating`, `unknown`.
    """
    ...
