# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetSshKeyResult',
    'AwaitableGetSshKeyResult',
    'get_ssh_key',
    'get_ssh_key_output',
]

@pulumi.output_type
class GetSshKeyResult:
    """
    A collection of values returned by getSshKey.
    """
    def __init__(__self__, fingerprint=None, id=None, labels=None, name=None, public_key=None, selector=None, with_selector=None):
        if fingerprint and not isinstance(fingerprint, str):
            raise TypeError("Expected argument 'fingerprint' to be a str")
        pulumi.set(__self__, "fingerprint", fingerprint)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_key and not isinstance(public_key, str):
            raise TypeError("Expected argument 'public_key' to be a str")
        pulumi.set(__self__, "public_key", public_key)
        if selector and not isinstance(selector, str):
            raise TypeError("Expected argument 'selector' to be a str")
        pulumi.set(__self__, "selector", selector)
        if with_selector and not isinstance(with_selector, str):
            raise TypeError("Expected argument 'with_selector' to be a str")
        pulumi.set(__self__, "with_selector", with_selector)

    @property
    @pulumi.getter
    def fingerprint(self) -> str:
        """
        (string) Fingerprint of the SSH Key.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        (int) Unique ID of the SSH Key.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (string) Name of the SSH Key.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        """
        (string) Public Key of the SSH Key.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def selector(self) -> Optional[str]:
        warnings.warn("""Please use the with_selector property instead.""", DeprecationWarning)
        pulumi.log.warn("""selector is deprecated: Please use the with_selector property instead.""")

        return pulumi.get(self, "selector")

    @property
    @pulumi.getter(name="withSelector")
    def with_selector(self) -> Optional[str]:
        return pulumi.get(self, "with_selector")


class AwaitableGetSshKeyResult(GetSshKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSshKeyResult(
            fingerprint=self.fingerprint,
            id=self.id,
            labels=self.labels,
            name=self.name,
            public_key=self.public_key,
            selector=self.selector,
            with_selector=self.with_selector)


def get_ssh_key(fingerprint: Optional[str] = None,
                id: Optional[int] = None,
                labels: Optional[Mapping[str, str]] = None,
                name: Optional[str] = None,
                public_key: Optional[str] = None,
                selector: Optional[str] = None,
                with_selector: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSshKeyResult:
    """
    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    ssh_key1 = hcloud.get_ssh_key(id=1234)
    ssh_key2 = hcloud.get_ssh_key(name="my-ssh-key")
    ssh_key3 = hcloud.get_ssh_key(fingerprint="43:51:43:a1:b5:fc:8b:b7:0a:3a:a9:b1:0f:66:73:a8")
    ssh_key4 = hcloud.get_ssh_key(with_selector="key=value")
    main = hcloud.Server("main", ssh_keys=[
        ssh_key1.id,
        ssh_key2.id,
        ssh_key3.id,
    ])
    ```
    <!--End PulumiCodeChooser -->


    :param str fingerprint: Fingerprint of the SSH Key.
    :param int id: ID of the SSH Key.
    :param str name: Name of the SSH Key.
    :param str public_key: (string) Public Key of the SSH Key.
    :param str with_selector: [Label selector](https://docs.hetzner.cloud/#overview-label-selector)
    """
    __args__ = dict()
    __args__['fingerprint'] = fingerprint
    __args__['id'] = id
    __args__['labels'] = labels
    __args__['name'] = name
    __args__['publicKey'] = public_key
    __args__['selector'] = selector
    __args__['withSelector'] = with_selector
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('hcloud:index/getSshKey:getSshKey', __args__, opts=opts, typ=GetSshKeyResult).value

    return AwaitableGetSshKeyResult(
        fingerprint=pulumi.get(__ret__, 'fingerprint'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        public_key=pulumi.get(__ret__, 'public_key'),
        selector=pulumi.get(__ret__, 'selector'),
        with_selector=pulumi.get(__ret__, 'with_selector'))


@_utilities.lift_output_func(get_ssh_key)
def get_ssh_key_output(fingerprint: Optional[pulumi.Input[Optional[str]]] = None,
                       id: Optional[pulumi.Input[Optional[int]]] = None,
                       labels: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                       name: Optional[pulumi.Input[Optional[str]]] = None,
                       public_key: Optional[pulumi.Input[Optional[str]]] = None,
                       selector: Optional[pulumi.Input[Optional[str]]] = None,
                       with_selector: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSshKeyResult]:
    """
    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    ssh_key1 = hcloud.get_ssh_key(id=1234)
    ssh_key2 = hcloud.get_ssh_key(name="my-ssh-key")
    ssh_key3 = hcloud.get_ssh_key(fingerprint="43:51:43:a1:b5:fc:8b:b7:0a:3a:a9:b1:0f:66:73:a8")
    ssh_key4 = hcloud.get_ssh_key(with_selector="key=value")
    main = hcloud.Server("main", ssh_keys=[
        ssh_key1.id,
        ssh_key2.id,
        ssh_key3.id,
    ])
    ```
    <!--End PulumiCodeChooser -->


    :param str fingerprint: Fingerprint of the SSH Key.
    :param int id: ID of the SSH Key.
    :param str name: Name of the SSH Key.
    :param str public_key: (string) Public Key of the SSH Key.
    :param str with_selector: [Label selector](https://docs.hetzner.cloud/#overview-label-selector)
    """
    ...
