# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerArgs', 'Server']

@pulumi.input_type
class ServerArgs:
    def __init__(__self__, *,
                 server_type: pulumi.Input[str],
                 allow_deprecated_images: Optional[pulumi.Input[bool]] = None,
                 backups: Optional[pulumi.Input[bool]] = None,
                 datacenter: Optional[pulumi.Input[str]] = None,
                 delete_protection: Optional[pulumi.Input[bool]] = None,
                 firewall_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 ignore_remote_firewall_ids: Optional[pulumi.Input[bool]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 iso: Optional[pulumi.Input[str]] = None,
                 keep_disk: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['ServerNetworkArgs']]]] = None,
                 placement_group_id: Optional[pulumi.Input[int]] = None,
                 public_nets: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPublicNetArgs']]]] = None,
                 rebuild_protection: Optional[pulumi.Input[bool]] = None,
                 rescue: Optional[pulumi.Input[str]] = None,
                 shutdown_before_deletion: Optional[pulumi.Input[bool]] = None,
                 ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Server resource.
        :param pulumi.Input[str] server_type: Name of the server type this server should be created with.
        :param pulumi.Input[bool] allow_deprecated_images: Enable the use of deprecated images (default: false). **Note** Deprecated images will be removed after three months. Using them is then no longer possible.
        :param pulumi.Input[bool] backups: Enable or disable backups.
        :param pulumi.Input[str] datacenter: The datacenter name to create the server in. `nbg1-dc3`, `fsn1-dc14`, `hel1-dc2`, `ash-dc1` or `hil-dc1`
        :param pulumi.Input[bool] delete_protection: Enable or disable delete protection (Needs to be the same as `rebuild_protection`). See "Delete Protection" in the Provider Docs for details.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] firewall_ids: Firewall IDs the server should be attached to on creation.
        :param pulumi.Input[bool] ignore_remote_firewall_ids: Ignores any updates
               to the `firewall_ids` argument which were received from the server.
               This should not be used in normal cases. See the documentation of the
               `FirewallAttachment` resource for a reason to use this
               argument.
        :param pulumi.Input[str] iso: ID or Name of an ISO image to mount.
        :param pulumi.Input[bool] keep_disk: If true, do not upgrade the disk. This allows downgrading the server type later.
        :param pulumi.Input[Mapping[str, Any]] labels: User-defined labels (key-value pairs) should be created with.
        :param pulumi.Input[str] location: The location name to create the server in. `nbg1`, `fsn1`, `hel1`, `ash` or `hil`
        :param pulumi.Input[str] name: Name of the server to create (must be unique per project and a valid hostname as per RFC 1123).
        :param pulumi.Input[Sequence[pulumi.Input['ServerNetworkArgs']]] networks: Network the server should be attached to on creation. (Can be specified multiple times)
        :param pulumi.Input[int] placement_group_id: Placement Group ID the server added to on creation.
        :param pulumi.Input[Sequence[pulumi.Input['ServerPublicNetArgs']]] public_nets: In this block you can either enable / disable ipv4 and ipv6 or link existing primary IPs (checkout the examples).
               If this block is not defined, two primary (ipv4 & ipv6) ips getting auto generated.
        :param pulumi.Input[bool] rebuild_protection: Enable or disable rebuild protection (Needs to be the same as `delete_protection`).
        :param pulumi.Input[str] rescue: Enable and boot in to the specified rescue system. This enables simple installation of custom operating systems. `linux64` or `linux32`
        :param pulumi.Input[bool] shutdown_before_deletion: Whether to try shutting the server down gracefully before deleting it.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_keys: SSH key IDs or names which should be injected into the server at creation time. Once the server is created, you can not update the list of SSH Keys. If you do change this, you will be prompted to destroy and recreate the server. You can avoid this by setting lifecycle.ignore_changes to `[ ssh_keys ]`.
        :param pulumi.Input[str] user_data: Cloud-Init user data to use during server creation
        """
        pulumi.set(__self__, "server_type", server_type)
        if allow_deprecated_images is not None:
            pulumi.set(__self__, "allow_deprecated_images", allow_deprecated_images)
        if backups is not None:
            pulumi.set(__self__, "backups", backups)
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if delete_protection is not None:
            pulumi.set(__self__, "delete_protection", delete_protection)
        if firewall_ids is not None:
            pulumi.set(__self__, "firewall_ids", firewall_ids)
        if ignore_remote_firewall_ids is not None:
            pulumi.set(__self__, "ignore_remote_firewall_ids", ignore_remote_firewall_ids)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if iso is not None:
            pulumi.set(__self__, "iso", iso)
        if keep_disk is not None:
            pulumi.set(__self__, "keep_disk", keep_disk)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if placement_group_id is not None:
            pulumi.set(__self__, "placement_group_id", placement_group_id)
        if public_nets is not None:
            pulumi.set(__self__, "public_nets", public_nets)
        if rebuild_protection is not None:
            pulumi.set(__self__, "rebuild_protection", rebuild_protection)
        if rescue is not None:
            pulumi.set(__self__, "rescue", rescue)
        if shutdown_before_deletion is not None:
            pulumi.set(__self__, "shutdown_before_deletion", shutdown_before_deletion)
        if ssh_keys is not None:
            pulumi.set(__self__, "ssh_keys", ssh_keys)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @property
    @pulumi.getter(name="serverType")
    def server_type(self) -> pulumi.Input[str]:
        """
        Name of the server type this server should be created with.
        """
        return pulumi.get(self, "server_type")

    @server_type.setter
    def server_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_type", value)

    @property
    @pulumi.getter(name="allowDeprecatedImages")
    def allow_deprecated_images(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable the use of deprecated images (default: false). **Note** Deprecated images will be removed after three months. Using them is then no longer possible.
        """
        return pulumi.get(self, "allow_deprecated_images")

    @allow_deprecated_images.setter
    def allow_deprecated_images(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_deprecated_images", value)

    @property
    @pulumi.getter
    def backups(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable backups.
        """
        return pulumi.get(self, "backups")

    @backups.setter
    def backups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backups", value)

    @property
    @pulumi.getter
    def datacenter(self) -> Optional[pulumi.Input[str]]:
        """
        The datacenter name to create the server in. `nbg1-dc3`, `fsn1-dc14`, `hel1-dc2`, `ash-dc1` or `hil-dc1`
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datacenter", value)

    @property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable delete protection (Needs to be the same as `rebuild_protection`). See "Delete Protection" in the Provider Docs for details.
        """
        return pulumi.get(self, "delete_protection")

    @delete_protection.setter
    def delete_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_protection", value)

    @property
    @pulumi.getter(name="firewallIds")
    def firewall_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Firewall IDs the server should be attached to on creation.
        """
        return pulumi.get(self, "firewall_ids")

    @firewall_ids.setter
    def firewall_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "firewall_ids", value)

    @property
    @pulumi.getter(name="ignoreRemoteFirewallIds")
    def ignore_remote_firewall_ids(self) -> Optional[pulumi.Input[bool]]:
        """
        Ignores any updates
        to the `firewall_ids` argument which were received from the server.
        This should not be used in normal cases. See the documentation of the
        `FirewallAttachment` resource for a reason to use this
        argument.
        """
        return pulumi.get(self, "ignore_remote_firewall_ids")

    @ignore_remote_firewall_ids.setter
    def ignore_remote_firewall_ids(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_remote_firewall_ids", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def iso(self) -> Optional[pulumi.Input[str]]:
        """
        ID or Name of an ISO image to mount.
        """
        return pulumi.get(self, "iso")

    @iso.setter
    def iso(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iso", value)

    @property
    @pulumi.getter(name="keepDisk")
    def keep_disk(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, do not upgrade the disk. This allows downgrading the server type later.
        """
        return pulumi.get(self, "keep_disk")

    @keep_disk.setter
    def keep_disk(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "keep_disk", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        User-defined labels (key-value pairs) should be created with.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location name to create the server in. `nbg1`, `fsn1`, `hel1`, `ash` or `hil`
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the server to create (must be unique per project and a valid hostname as per RFC 1123).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerNetworkArgs']]]]:
        """
        Network the server should be attached to on creation. (Can be specified multiple times)
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> Optional[pulumi.Input[int]]:
        """
        Placement Group ID the server added to on creation.
        """
        return pulumi.get(self, "placement_group_id")

    @placement_group_id.setter
    def placement_group_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "placement_group_id", value)

    @property
    @pulumi.getter(name="publicNets")
    def public_nets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerPublicNetArgs']]]]:
        """
        In this block you can either enable / disable ipv4 and ipv6 or link existing primary IPs (checkout the examples).
        If this block is not defined, two primary (ipv4 & ipv6) ips getting auto generated.
        """
        return pulumi.get(self, "public_nets")

    @public_nets.setter
    def public_nets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPublicNetArgs']]]]):
        pulumi.set(self, "public_nets", value)

    @property
    @pulumi.getter(name="rebuildProtection")
    def rebuild_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable rebuild protection (Needs to be the same as `delete_protection`).
        """
        return pulumi.get(self, "rebuild_protection")

    @rebuild_protection.setter
    def rebuild_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "rebuild_protection", value)

    @property
    @pulumi.getter
    def rescue(self) -> Optional[pulumi.Input[str]]:
        """
        Enable and boot in to the specified rescue system. This enables simple installation of custom operating systems. `linux64` or `linux32`
        """
        return pulumi.get(self, "rescue")

    @rescue.setter
    def rescue(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rescue", value)

    @property
    @pulumi.getter(name="shutdownBeforeDeletion")
    def shutdown_before_deletion(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to try shutting the server down gracefully before deleting it.
        """
        return pulumi.get(self, "shutdown_before_deletion")

    @shutdown_before_deletion.setter
    def shutdown_before_deletion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "shutdown_before_deletion", value)

    @property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        SSH key IDs or names which should be injected into the server at creation time. Once the server is created, you can not update the list of SSH Keys. If you do change this, you will be prompted to destroy and recreate the server. You can avoid this by setting lifecycle.ignore_changes to `[ ssh_keys ]`.
        """
        return pulumi.get(self, "ssh_keys")

    @ssh_keys.setter
    def ssh_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ssh_keys", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud-Init user data to use during server creation
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)


@pulumi.input_type
class _ServerState:
    def __init__(__self__, *,
                 allow_deprecated_images: Optional[pulumi.Input[bool]] = None,
                 backup_window: Optional[pulumi.Input[str]] = None,
                 backups: Optional[pulumi.Input[bool]] = None,
                 datacenter: Optional[pulumi.Input[str]] = None,
                 delete_protection: Optional[pulumi.Input[bool]] = None,
                 firewall_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 ignore_remote_firewall_ids: Optional[pulumi.Input[bool]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 ipv4_address: Optional[pulumi.Input[str]] = None,
                 ipv6_address: Optional[pulumi.Input[str]] = None,
                 ipv6_network: Optional[pulumi.Input[str]] = None,
                 iso: Optional[pulumi.Input[str]] = None,
                 keep_disk: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['ServerNetworkArgs']]]] = None,
                 placement_group_id: Optional[pulumi.Input[int]] = None,
                 primary_disk_size: Optional[pulumi.Input[int]] = None,
                 public_nets: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPublicNetArgs']]]] = None,
                 rebuild_protection: Optional[pulumi.Input[bool]] = None,
                 rescue: Optional[pulumi.Input[str]] = None,
                 server_type: Optional[pulumi.Input[str]] = None,
                 shutdown_before_deletion: Optional[pulumi.Input[bool]] = None,
                 ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Server resources.
        :param pulumi.Input[bool] allow_deprecated_images: Enable the use of deprecated images (default: false). **Note** Deprecated images will be removed after three months. Using them is then no longer possible.
        :param pulumi.Input[str] backup_window: (string) The backup window of the server, if enabled.
        :param pulumi.Input[bool] backups: Enable or disable backups.
        :param pulumi.Input[str] datacenter: The datacenter name to create the server in. `nbg1-dc3`, `fsn1-dc14`, `hel1-dc2`, `ash-dc1` or `hil-dc1`
        :param pulumi.Input[bool] delete_protection: Enable or disable delete protection (Needs to be the same as `rebuild_protection`). See "Delete Protection" in the Provider Docs for details.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] firewall_ids: Firewall IDs the server should be attached to on creation.
        :param pulumi.Input[bool] ignore_remote_firewall_ids: Ignores any updates
               to the `firewall_ids` argument which were received from the server.
               This should not be used in normal cases. See the documentation of the
               `FirewallAttachment` resource for a reason to use this
               argument.
        :param pulumi.Input[str] ipv4_address: (string) The IPv4 address.
        :param pulumi.Input[str] ipv6_address: (string) The first IPv6 address of the assigned network.
        :param pulumi.Input[str] ipv6_network: (string) The IPv6 network.
        :param pulumi.Input[str] iso: ID or Name of an ISO image to mount.
        :param pulumi.Input[bool] keep_disk: If true, do not upgrade the disk. This allows downgrading the server type later.
        :param pulumi.Input[Mapping[str, Any]] labels: User-defined labels (key-value pairs) should be created with.
        :param pulumi.Input[str] location: The location name to create the server in. `nbg1`, `fsn1`, `hel1`, `ash` or `hil`
        :param pulumi.Input[str] name: Name of the server to create (must be unique per project and a valid hostname as per RFC 1123).
        :param pulumi.Input[Sequence[pulumi.Input['ServerNetworkArgs']]] networks: Network the server should be attached to on creation. (Can be specified multiple times)
        :param pulumi.Input[int] placement_group_id: Placement Group ID the server added to on creation.
        :param pulumi.Input[int] primary_disk_size: (int) The size of the primary disk in GB.
        :param pulumi.Input[Sequence[pulumi.Input['ServerPublicNetArgs']]] public_nets: In this block you can either enable / disable ipv4 and ipv6 or link existing primary IPs (checkout the examples).
               If this block is not defined, two primary (ipv4 & ipv6) ips getting auto generated.
        :param pulumi.Input[bool] rebuild_protection: Enable or disable rebuild protection (Needs to be the same as `delete_protection`).
        :param pulumi.Input[str] rescue: Enable and boot in to the specified rescue system. This enables simple installation of custom operating systems. `linux64` or `linux32`
        :param pulumi.Input[str] server_type: Name of the server type this server should be created with.
        :param pulumi.Input[bool] shutdown_before_deletion: Whether to try shutting the server down gracefully before deleting it.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_keys: SSH key IDs or names which should be injected into the server at creation time. Once the server is created, you can not update the list of SSH Keys. If you do change this, you will be prompted to destroy and recreate the server. You can avoid this by setting lifecycle.ignore_changes to `[ ssh_keys ]`.
        :param pulumi.Input[str] status: (string) The status of the server.
        :param pulumi.Input[str] user_data: Cloud-Init user data to use during server creation
        """
        if allow_deprecated_images is not None:
            pulumi.set(__self__, "allow_deprecated_images", allow_deprecated_images)
        if backup_window is not None:
            warnings.warn("""You should remove this property from your terraform configuration.""", DeprecationWarning)
            pulumi.log.warn("""backup_window is deprecated: You should remove this property from your terraform configuration.""")
        if backup_window is not None:
            pulumi.set(__self__, "backup_window", backup_window)
        if backups is not None:
            pulumi.set(__self__, "backups", backups)
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if delete_protection is not None:
            pulumi.set(__self__, "delete_protection", delete_protection)
        if firewall_ids is not None:
            pulumi.set(__self__, "firewall_ids", firewall_ids)
        if ignore_remote_firewall_ids is not None:
            pulumi.set(__self__, "ignore_remote_firewall_ids", ignore_remote_firewall_ids)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if ipv6_network is not None:
            pulumi.set(__self__, "ipv6_network", ipv6_network)
        if iso is not None:
            pulumi.set(__self__, "iso", iso)
        if keep_disk is not None:
            pulumi.set(__self__, "keep_disk", keep_disk)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if placement_group_id is not None:
            pulumi.set(__self__, "placement_group_id", placement_group_id)
        if primary_disk_size is not None:
            pulumi.set(__self__, "primary_disk_size", primary_disk_size)
        if public_nets is not None:
            pulumi.set(__self__, "public_nets", public_nets)
        if rebuild_protection is not None:
            pulumi.set(__self__, "rebuild_protection", rebuild_protection)
        if rescue is not None:
            pulumi.set(__self__, "rescue", rescue)
        if server_type is not None:
            pulumi.set(__self__, "server_type", server_type)
        if shutdown_before_deletion is not None:
            pulumi.set(__self__, "shutdown_before_deletion", shutdown_before_deletion)
        if ssh_keys is not None:
            pulumi.set(__self__, "ssh_keys", ssh_keys)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @property
    @pulumi.getter(name="allowDeprecatedImages")
    def allow_deprecated_images(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable the use of deprecated images (default: false). **Note** Deprecated images will be removed after three months. Using them is then no longer possible.
        """
        return pulumi.get(self, "allow_deprecated_images")

    @allow_deprecated_images.setter
    def allow_deprecated_images(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_deprecated_images", value)

    @property
    @pulumi.getter(name="backupWindow")
    def backup_window(self) -> Optional[pulumi.Input[str]]:
        """
        (string) The backup window of the server, if enabled.
        """
        warnings.warn("""You should remove this property from your terraform configuration.""", DeprecationWarning)
        pulumi.log.warn("""backup_window is deprecated: You should remove this property from your terraform configuration.""")

        return pulumi.get(self, "backup_window")

    @backup_window.setter
    def backup_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_window", value)

    @property
    @pulumi.getter
    def backups(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable backups.
        """
        return pulumi.get(self, "backups")

    @backups.setter
    def backups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backups", value)

    @property
    @pulumi.getter
    def datacenter(self) -> Optional[pulumi.Input[str]]:
        """
        The datacenter name to create the server in. `nbg1-dc3`, `fsn1-dc14`, `hel1-dc2`, `ash-dc1` or `hil-dc1`
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datacenter", value)

    @property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable delete protection (Needs to be the same as `rebuild_protection`). See "Delete Protection" in the Provider Docs for details.
        """
        return pulumi.get(self, "delete_protection")

    @delete_protection.setter
    def delete_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_protection", value)

    @property
    @pulumi.getter(name="firewallIds")
    def firewall_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Firewall IDs the server should be attached to on creation.
        """
        return pulumi.get(self, "firewall_ids")

    @firewall_ids.setter
    def firewall_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "firewall_ids", value)

    @property
    @pulumi.getter(name="ignoreRemoteFirewallIds")
    def ignore_remote_firewall_ids(self) -> Optional[pulumi.Input[bool]]:
        """
        Ignores any updates
        to the `firewall_ids` argument which were received from the server.
        This should not be used in normal cases. See the documentation of the
        `FirewallAttachment` resource for a reason to use this
        argument.
        """
        return pulumi.get(self, "ignore_remote_firewall_ids")

    @ignore_remote_firewall_ids.setter
    def ignore_remote_firewall_ids(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_remote_firewall_ids", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[str]]:
        """
        (string) The IPv4 address.
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_address", value)

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[str]]:
        """
        (string) The first IPv6 address of the assigned network.
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_address", value)

    @property
    @pulumi.getter(name="ipv6Network")
    def ipv6_network(self) -> Optional[pulumi.Input[str]]:
        """
        (string) The IPv6 network.
        """
        return pulumi.get(self, "ipv6_network")

    @ipv6_network.setter
    def ipv6_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_network", value)

    @property
    @pulumi.getter
    def iso(self) -> Optional[pulumi.Input[str]]:
        """
        ID or Name of an ISO image to mount.
        """
        return pulumi.get(self, "iso")

    @iso.setter
    def iso(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iso", value)

    @property
    @pulumi.getter(name="keepDisk")
    def keep_disk(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, do not upgrade the disk. This allows downgrading the server type later.
        """
        return pulumi.get(self, "keep_disk")

    @keep_disk.setter
    def keep_disk(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "keep_disk", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        User-defined labels (key-value pairs) should be created with.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location name to create the server in. `nbg1`, `fsn1`, `hel1`, `ash` or `hil`
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the server to create (must be unique per project and a valid hostname as per RFC 1123).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerNetworkArgs']]]]:
        """
        Network the server should be attached to on creation. (Can be specified multiple times)
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> Optional[pulumi.Input[int]]:
        """
        Placement Group ID the server added to on creation.
        """
        return pulumi.get(self, "placement_group_id")

    @placement_group_id.setter
    def placement_group_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "placement_group_id", value)

    @property
    @pulumi.getter(name="primaryDiskSize")
    def primary_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        (int) The size of the primary disk in GB.
        """
        return pulumi.get(self, "primary_disk_size")

    @primary_disk_size.setter
    def primary_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "primary_disk_size", value)

    @property
    @pulumi.getter(name="publicNets")
    def public_nets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerPublicNetArgs']]]]:
        """
        In this block you can either enable / disable ipv4 and ipv6 or link existing primary IPs (checkout the examples).
        If this block is not defined, two primary (ipv4 & ipv6) ips getting auto generated.
        """
        return pulumi.get(self, "public_nets")

    @public_nets.setter
    def public_nets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPublicNetArgs']]]]):
        pulumi.set(self, "public_nets", value)

    @property
    @pulumi.getter(name="rebuildProtection")
    def rebuild_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable rebuild protection (Needs to be the same as `delete_protection`).
        """
        return pulumi.get(self, "rebuild_protection")

    @rebuild_protection.setter
    def rebuild_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "rebuild_protection", value)

    @property
    @pulumi.getter
    def rescue(self) -> Optional[pulumi.Input[str]]:
        """
        Enable and boot in to the specified rescue system. This enables simple installation of custom operating systems. `linux64` or `linux32`
        """
        return pulumi.get(self, "rescue")

    @rescue.setter
    def rescue(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rescue", value)

    @property
    @pulumi.getter(name="serverType")
    def server_type(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the server type this server should be created with.
        """
        return pulumi.get(self, "server_type")

    @server_type.setter
    def server_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_type", value)

    @property
    @pulumi.getter(name="shutdownBeforeDeletion")
    def shutdown_before_deletion(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to try shutting the server down gracefully before deleting it.
        """
        return pulumi.get(self, "shutdown_before_deletion")

    @shutdown_before_deletion.setter
    def shutdown_before_deletion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "shutdown_before_deletion", value)

    @property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        SSH key IDs or names which should be injected into the server at creation time. Once the server is created, you can not update the list of SSH Keys. If you do change this, you will be prompted to destroy and recreate the server. You can avoid this by setting lifecycle.ignore_changes to `[ ssh_keys ]`.
        """
        return pulumi.get(self, "ssh_keys")

    @ssh_keys.setter
    def ssh_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ssh_keys", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        (string) The status of the server.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud-Init user data to use during server creation
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)


class Server(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_deprecated_images: Optional[pulumi.Input[bool]] = None,
                 backups: Optional[pulumi.Input[bool]] = None,
                 datacenter: Optional[pulumi.Input[str]] = None,
                 delete_protection: Optional[pulumi.Input[bool]] = None,
                 firewall_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 ignore_remote_firewall_ids: Optional[pulumi.Input[bool]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 iso: Optional[pulumi.Input[str]] = None,
                 keep_disk: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerNetworkArgs']]]]] = None,
                 placement_group_id: Optional[pulumi.Input[int]] = None,
                 public_nets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerPublicNetArgs']]]]] = None,
                 rebuild_protection: Optional[pulumi.Input[bool]] = None,
                 rescue: Optional[pulumi.Input[str]] = None,
                 server_type: Optional[pulumi.Input[str]] = None,
                 shutdown_before_deletion: Optional[pulumi.Input[bool]] = None,
                 ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an Hetzner Cloud server resource. This can be used to create, modify, and delete servers. Servers also support provisioning.

        ## Example Usage

        ### Basic server creation

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_hcloud as hcloud

        # Create a new server running debian
        node1 = hcloud.Server("node1",
            image="debian-11",
            public_nets=[hcloud.ServerPublicNetArgs(
                ipv4_enabled=True,
                ipv6_enabled=True,
            )],
            server_type="cx11")
        ```
        <!--End PulumiCodeChooser -->
        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_hcloud as hcloud

        ### Server creation with one linked primary ip (ipv4)
        primary_ip1 = hcloud.PrimaryIp("primaryIp1",
            datacenter="fsn1-dc14",
            type="ipv4",
            assignee_type="server",
            auto_delete=True,
            labels={
                "hallo": "welt",
            })
        server_test = hcloud.Server("serverTest",
            image="ubuntu-20.04",
            server_type="cx11",
            datacenter="fsn1-dc14",
            labels={
                "test": "tessst1",
            },
            public_nets=[hcloud.ServerPublicNetArgs(
                ipv4_enabled=True,
                ipv4=primary_ip1.id,
                ipv6_enabled=False,
            )])
        ```
        <!--End PulumiCodeChooser -->
        ### Server creation with network
        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_hcloud as hcloud

        network = hcloud.Network("network", ip_range="10.0.0.0/16")
        network_subnet = hcloud.NetworkSubnet("network-subnet",
            type="cloud",
            network_id=network.id,
            network_zone="eu-central",
            ip_range="10.0.1.0/24")
        server = hcloud.Server("server",
            server_type="cx11",
            image="ubuntu-20.04",
            location="nbg1",
            networks=[hcloud.ServerNetworkArgs(
                network_id=network.id,
                ip="10.0.1.5",
                alias_ips=[
                    "10.0.1.6",
                    "10.0.1.7",
                ],
            )],
            opts=pulumi.ResourceOptions(depends_on=[network_subnet]))
        ```
        <!--End PulumiCodeChooser -->

        ### Server creation from snapshot

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_hcloud as hcloud

        packer_snapshot = hcloud.get_image(with_selector="app=foobar",
            most_recent=True)
        # Create a new server from the snapshot
        from_snapshot = hcloud.Server("fromSnapshot",
            image=packer_snapshot.id,
            server_type="cx11",
            public_nets=[hcloud.ServerPublicNetArgs(
                ipv4_enabled=True,
                ipv6_enabled=True,
            )])
        ```
        <!--End PulumiCodeChooser -->

        ## Primary IPs

        When creating a server without linking at least one ´primary_ip´, it automatically creates & assigns two (ipv4 & ipv6).
        With the public_net block, you can enable or link primary ips. If you don't define this block, two primary ips (ipv4, ipv6) will be created and assigned to the server automatically.

        ### Examples

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_hcloud as hcloud

        # Assign existing ipv4 only
        server_test_server = hcloud.Server("serverTestServer", public_nets=[hcloud.ServerPublicNetArgs(
            ipv4_enabled=True,
            ipv4=hcloud_primary_ip["primary_ip_1"]["id"],
            ipv6_enabled=False,
        )])
        #...
        # Link a managed ipv4 but autogenerate ipv6
        server_test_index_server_server = hcloud.Server("serverTestIndex/serverServer", public_nets=[hcloud.ServerPublicNetArgs(
            ipv4_enabled=True,
            ipv4=hcloud_primary_ip["primary_ip_1"]["id"],
            ipv6_enabled=True,
        )])
        #...
        # Assign & create auto-generated ipv4 & ipv6
        server_test_hcloud_index_server_server = hcloud.Server("serverTestHcloudIndex/serverServer", public_nets=[hcloud.ServerPublicNetArgs(
            ipv4_enabled=True,
            ipv6_enabled=True,
        )])
        #...
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Servers can be imported using the server `id`:

        ```sh
        $ pulumi import hcloud:index/server:Server myserver id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_deprecated_images: Enable the use of deprecated images (default: false). **Note** Deprecated images will be removed after three months. Using them is then no longer possible.
        :param pulumi.Input[bool] backups: Enable or disable backups.
        :param pulumi.Input[str] datacenter: The datacenter name to create the server in. `nbg1-dc3`, `fsn1-dc14`, `hel1-dc2`, `ash-dc1` or `hil-dc1`
        :param pulumi.Input[bool] delete_protection: Enable or disable delete protection (Needs to be the same as `rebuild_protection`). See "Delete Protection" in the Provider Docs for details.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] firewall_ids: Firewall IDs the server should be attached to on creation.
        :param pulumi.Input[bool] ignore_remote_firewall_ids: Ignores any updates
               to the `firewall_ids` argument which were received from the server.
               This should not be used in normal cases. See the documentation of the
               `FirewallAttachment` resource for a reason to use this
               argument.
        :param pulumi.Input[str] iso: ID or Name of an ISO image to mount.
        :param pulumi.Input[bool] keep_disk: If true, do not upgrade the disk. This allows downgrading the server type later.
        :param pulumi.Input[Mapping[str, Any]] labels: User-defined labels (key-value pairs) should be created with.
        :param pulumi.Input[str] location: The location name to create the server in. `nbg1`, `fsn1`, `hel1`, `ash` or `hil`
        :param pulumi.Input[str] name: Name of the server to create (must be unique per project and a valid hostname as per RFC 1123).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerNetworkArgs']]]] networks: Network the server should be attached to on creation. (Can be specified multiple times)
        :param pulumi.Input[int] placement_group_id: Placement Group ID the server added to on creation.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerPublicNetArgs']]]] public_nets: In this block you can either enable / disable ipv4 and ipv6 or link existing primary IPs (checkout the examples).
               If this block is not defined, two primary (ipv4 & ipv6) ips getting auto generated.
        :param pulumi.Input[bool] rebuild_protection: Enable or disable rebuild protection (Needs to be the same as `delete_protection`).
        :param pulumi.Input[str] rescue: Enable and boot in to the specified rescue system. This enables simple installation of custom operating systems. `linux64` or `linux32`
        :param pulumi.Input[str] server_type: Name of the server type this server should be created with.
        :param pulumi.Input[bool] shutdown_before_deletion: Whether to try shutting the server down gracefully before deleting it.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_keys: SSH key IDs or names which should be injected into the server at creation time. Once the server is created, you can not update the list of SSH Keys. If you do change this, you will be prompted to destroy and recreate the server. You can avoid this by setting lifecycle.ignore_changes to `[ ssh_keys ]`.
        :param pulumi.Input[str] user_data: Cloud-Init user data to use during server creation
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Hetzner Cloud server resource. This can be used to create, modify, and delete servers. Servers also support provisioning.

        ## Example Usage

        ### Basic server creation

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_hcloud as hcloud

        # Create a new server running debian
        node1 = hcloud.Server("node1",
            image="debian-11",
            public_nets=[hcloud.ServerPublicNetArgs(
                ipv4_enabled=True,
                ipv6_enabled=True,
            )],
            server_type="cx11")
        ```
        <!--End PulumiCodeChooser -->
        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_hcloud as hcloud

        ### Server creation with one linked primary ip (ipv4)
        primary_ip1 = hcloud.PrimaryIp("primaryIp1",
            datacenter="fsn1-dc14",
            type="ipv4",
            assignee_type="server",
            auto_delete=True,
            labels={
                "hallo": "welt",
            })
        server_test = hcloud.Server("serverTest",
            image="ubuntu-20.04",
            server_type="cx11",
            datacenter="fsn1-dc14",
            labels={
                "test": "tessst1",
            },
            public_nets=[hcloud.ServerPublicNetArgs(
                ipv4_enabled=True,
                ipv4=primary_ip1.id,
                ipv6_enabled=False,
            )])
        ```
        <!--End PulumiCodeChooser -->
        ### Server creation with network
        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_hcloud as hcloud

        network = hcloud.Network("network", ip_range="10.0.0.0/16")
        network_subnet = hcloud.NetworkSubnet("network-subnet",
            type="cloud",
            network_id=network.id,
            network_zone="eu-central",
            ip_range="10.0.1.0/24")
        server = hcloud.Server("server",
            server_type="cx11",
            image="ubuntu-20.04",
            location="nbg1",
            networks=[hcloud.ServerNetworkArgs(
                network_id=network.id,
                ip="10.0.1.5",
                alias_ips=[
                    "10.0.1.6",
                    "10.0.1.7",
                ],
            )],
            opts=pulumi.ResourceOptions(depends_on=[network_subnet]))
        ```
        <!--End PulumiCodeChooser -->

        ### Server creation from snapshot

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_hcloud as hcloud

        packer_snapshot = hcloud.get_image(with_selector="app=foobar",
            most_recent=True)
        # Create a new server from the snapshot
        from_snapshot = hcloud.Server("fromSnapshot",
            image=packer_snapshot.id,
            server_type="cx11",
            public_nets=[hcloud.ServerPublicNetArgs(
                ipv4_enabled=True,
                ipv6_enabled=True,
            )])
        ```
        <!--End PulumiCodeChooser -->

        ## Primary IPs

        When creating a server without linking at least one ´primary_ip´, it automatically creates & assigns two (ipv4 & ipv6).
        With the public_net block, you can enable or link primary ips. If you don't define this block, two primary ips (ipv4, ipv6) will be created and assigned to the server automatically.

        ### Examples

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_hcloud as hcloud

        # Assign existing ipv4 only
        server_test_server = hcloud.Server("serverTestServer", public_nets=[hcloud.ServerPublicNetArgs(
            ipv4_enabled=True,
            ipv4=hcloud_primary_ip["primary_ip_1"]["id"],
            ipv6_enabled=False,
        )])
        #...
        # Link a managed ipv4 but autogenerate ipv6
        server_test_index_server_server = hcloud.Server("serverTestIndex/serverServer", public_nets=[hcloud.ServerPublicNetArgs(
            ipv4_enabled=True,
            ipv4=hcloud_primary_ip["primary_ip_1"]["id"],
            ipv6_enabled=True,
        )])
        #...
        # Assign & create auto-generated ipv4 & ipv6
        server_test_hcloud_index_server_server = hcloud.Server("serverTestHcloudIndex/serverServer", public_nets=[hcloud.ServerPublicNetArgs(
            ipv4_enabled=True,
            ipv6_enabled=True,
        )])
        #...
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Servers can be imported using the server `id`:

        ```sh
        $ pulumi import hcloud:index/server:Server myserver id
        ```

        :param str resource_name: The name of the resource.
        :param ServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_deprecated_images: Optional[pulumi.Input[bool]] = None,
                 backups: Optional[pulumi.Input[bool]] = None,
                 datacenter: Optional[pulumi.Input[str]] = None,
                 delete_protection: Optional[pulumi.Input[bool]] = None,
                 firewall_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 ignore_remote_firewall_ids: Optional[pulumi.Input[bool]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 iso: Optional[pulumi.Input[str]] = None,
                 keep_disk: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerNetworkArgs']]]]] = None,
                 placement_group_id: Optional[pulumi.Input[int]] = None,
                 public_nets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerPublicNetArgs']]]]] = None,
                 rebuild_protection: Optional[pulumi.Input[bool]] = None,
                 rescue: Optional[pulumi.Input[str]] = None,
                 server_type: Optional[pulumi.Input[str]] = None,
                 shutdown_before_deletion: Optional[pulumi.Input[bool]] = None,
                 ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerArgs.__new__(ServerArgs)

            __props__.__dict__["allow_deprecated_images"] = allow_deprecated_images
            __props__.__dict__["backups"] = backups
            __props__.__dict__["datacenter"] = datacenter
            __props__.__dict__["delete_protection"] = delete_protection
            __props__.__dict__["firewall_ids"] = firewall_ids
            __props__.__dict__["ignore_remote_firewall_ids"] = ignore_remote_firewall_ids
            __props__.__dict__["image"] = image
            __props__.__dict__["iso"] = iso
            __props__.__dict__["keep_disk"] = keep_disk
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["networks"] = networks
            __props__.__dict__["placement_group_id"] = placement_group_id
            __props__.__dict__["public_nets"] = public_nets
            __props__.__dict__["rebuild_protection"] = rebuild_protection
            __props__.__dict__["rescue"] = rescue
            if server_type is None and not opts.urn:
                raise TypeError("Missing required property 'server_type'")
            __props__.__dict__["server_type"] = server_type
            __props__.__dict__["shutdown_before_deletion"] = shutdown_before_deletion
            __props__.__dict__["ssh_keys"] = ssh_keys
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["backup_window"] = None
            __props__.__dict__["ipv4_address"] = None
            __props__.__dict__["ipv6_address"] = None
            __props__.__dict__["ipv6_network"] = None
            __props__.__dict__["primary_disk_size"] = None
            __props__.__dict__["status"] = None
        super(Server, __self__).__init__(
            'hcloud:index/server:Server',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_deprecated_images: Optional[pulumi.Input[bool]] = None,
            backup_window: Optional[pulumi.Input[str]] = None,
            backups: Optional[pulumi.Input[bool]] = None,
            datacenter: Optional[pulumi.Input[str]] = None,
            delete_protection: Optional[pulumi.Input[bool]] = None,
            firewall_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            ignore_remote_firewall_ids: Optional[pulumi.Input[bool]] = None,
            image: Optional[pulumi.Input[str]] = None,
            ipv4_address: Optional[pulumi.Input[str]] = None,
            ipv6_address: Optional[pulumi.Input[str]] = None,
            ipv6_network: Optional[pulumi.Input[str]] = None,
            iso: Optional[pulumi.Input[str]] = None,
            keep_disk: Optional[pulumi.Input[bool]] = None,
            labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerNetworkArgs']]]]] = None,
            placement_group_id: Optional[pulumi.Input[int]] = None,
            primary_disk_size: Optional[pulumi.Input[int]] = None,
            public_nets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerPublicNetArgs']]]]] = None,
            rebuild_protection: Optional[pulumi.Input[bool]] = None,
            rescue: Optional[pulumi.Input[str]] = None,
            server_type: Optional[pulumi.Input[str]] = None,
            shutdown_before_deletion: Optional[pulumi.Input[bool]] = None,
            ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            user_data: Optional[pulumi.Input[str]] = None) -> 'Server':
        """
        Get an existing Server resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_deprecated_images: Enable the use of deprecated images (default: false). **Note** Deprecated images will be removed after three months. Using them is then no longer possible.
        :param pulumi.Input[str] backup_window: (string) The backup window of the server, if enabled.
        :param pulumi.Input[bool] backups: Enable or disable backups.
        :param pulumi.Input[str] datacenter: The datacenter name to create the server in. `nbg1-dc3`, `fsn1-dc14`, `hel1-dc2`, `ash-dc1` or `hil-dc1`
        :param pulumi.Input[bool] delete_protection: Enable or disable delete protection (Needs to be the same as `rebuild_protection`). See "Delete Protection" in the Provider Docs for details.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] firewall_ids: Firewall IDs the server should be attached to on creation.
        :param pulumi.Input[bool] ignore_remote_firewall_ids: Ignores any updates
               to the `firewall_ids` argument which were received from the server.
               This should not be used in normal cases. See the documentation of the
               `FirewallAttachment` resource for a reason to use this
               argument.
        :param pulumi.Input[str] ipv4_address: (string) The IPv4 address.
        :param pulumi.Input[str] ipv6_address: (string) The first IPv6 address of the assigned network.
        :param pulumi.Input[str] ipv6_network: (string) The IPv6 network.
        :param pulumi.Input[str] iso: ID or Name of an ISO image to mount.
        :param pulumi.Input[bool] keep_disk: If true, do not upgrade the disk. This allows downgrading the server type later.
        :param pulumi.Input[Mapping[str, Any]] labels: User-defined labels (key-value pairs) should be created with.
        :param pulumi.Input[str] location: The location name to create the server in. `nbg1`, `fsn1`, `hel1`, `ash` or `hil`
        :param pulumi.Input[str] name: Name of the server to create (must be unique per project and a valid hostname as per RFC 1123).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerNetworkArgs']]]] networks: Network the server should be attached to on creation. (Can be specified multiple times)
        :param pulumi.Input[int] placement_group_id: Placement Group ID the server added to on creation.
        :param pulumi.Input[int] primary_disk_size: (int) The size of the primary disk in GB.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerPublicNetArgs']]]] public_nets: In this block you can either enable / disable ipv4 and ipv6 or link existing primary IPs (checkout the examples).
               If this block is not defined, two primary (ipv4 & ipv6) ips getting auto generated.
        :param pulumi.Input[bool] rebuild_protection: Enable or disable rebuild protection (Needs to be the same as `delete_protection`).
        :param pulumi.Input[str] rescue: Enable and boot in to the specified rescue system. This enables simple installation of custom operating systems. `linux64` or `linux32`
        :param pulumi.Input[str] server_type: Name of the server type this server should be created with.
        :param pulumi.Input[bool] shutdown_before_deletion: Whether to try shutting the server down gracefully before deleting it.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_keys: SSH key IDs or names which should be injected into the server at creation time. Once the server is created, you can not update the list of SSH Keys. If you do change this, you will be prompted to destroy and recreate the server. You can avoid this by setting lifecycle.ignore_changes to `[ ssh_keys ]`.
        :param pulumi.Input[str] status: (string) The status of the server.
        :param pulumi.Input[str] user_data: Cloud-Init user data to use during server creation
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerState.__new__(_ServerState)

        __props__.__dict__["allow_deprecated_images"] = allow_deprecated_images
        __props__.__dict__["backup_window"] = backup_window
        __props__.__dict__["backups"] = backups
        __props__.__dict__["datacenter"] = datacenter
        __props__.__dict__["delete_protection"] = delete_protection
        __props__.__dict__["firewall_ids"] = firewall_ids
        __props__.__dict__["ignore_remote_firewall_ids"] = ignore_remote_firewall_ids
        __props__.__dict__["image"] = image
        __props__.__dict__["ipv4_address"] = ipv4_address
        __props__.__dict__["ipv6_address"] = ipv6_address
        __props__.__dict__["ipv6_network"] = ipv6_network
        __props__.__dict__["iso"] = iso
        __props__.__dict__["keep_disk"] = keep_disk
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["networks"] = networks
        __props__.__dict__["placement_group_id"] = placement_group_id
        __props__.__dict__["primary_disk_size"] = primary_disk_size
        __props__.__dict__["public_nets"] = public_nets
        __props__.__dict__["rebuild_protection"] = rebuild_protection
        __props__.__dict__["rescue"] = rescue
        __props__.__dict__["server_type"] = server_type
        __props__.__dict__["shutdown_before_deletion"] = shutdown_before_deletion
        __props__.__dict__["ssh_keys"] = ssh_keys
        __props__.__dict__["status"] = status
        __props__.__dict__["user_data"] = user_data
        return Server(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowDeprecatedImages")
    def allow_deprecated_images(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable the use of deprecated images (default: false). **Note** Deprecated images will be removed after three months. Using them is then no longer possible.
        """
        return pulumi.get(self, "allow_deprecated_images")

    @property
    @pulumi.getter(name="backupWindow")
    def backup_window(self) -> pulumi.Output[str]:
        """
        (string) The backup window of the server, if enabled.
        """
        warnings.warn("""You should remove this property from your terraform configuration.""", DeprecationWarning)
        pulumi.log.warn("""backup_window is deprecated: You should remove this property from your terraform configuration.""")

        return pulumi.get(self, "backup_window")

    @property
    @pulumi.getter
    def backups(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable or disable backups.
        """
        return pulumi.get(self, "backups")

    @property
    @pulumi.getter
    def datacenter(self) -> pulumi.Output[str]:
        """
        The datacenter name to create the server in. `nbg1-dc3`, `fsn1-dc14`, `hel1-dc2`, `ash-dc1` or `hil-dc1`
        """
        return pulumi.get(self, "datacenter")

    @property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable or disable delete protection (Needs to be the same as `rebuild_protection`). See "Delete Protection" in the Provider Docs for details.
        """
        return pulumi.get(self, "delete_protection")

    @property
    @pulumi.getter(name="firewallIds")
    def firewall_ids(self) -> pulumi.Output[Sequence[int]]:
        """
        Firewall IDs the server should be attached to on creation.
        """
        return pulumi.get(self, "firewall_ids")

    @property
    @pulumi.getter(name="ignoreRemoteFirewallIds")
    def ignore_remote_firewall_ids(self) -> pulumi.Output[Optional[bool]]:
        """
        Ignores any updates
        to the `firewall_ids` argument which were received from the server.
        This should not be used in normal cases. See the documentation of the
        `FirewallAttachment` resource for a reason to use this
        argument.
        """
        return pulumi.get(self, "ignore_remote_firewall_ids")

    @property
    @pulumi.getter
    def image(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> pulumi.Output[str]:
        """
        (string) The IPv4 address.
        """
        return pulumi.get(self, "ipv4_address")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> pulumi.Output[str]:
        """
        (string) The first IPv6 address of the assigned network.
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter(name="ipv6Network")
    def ipv6_network(self) -> pulumi.Output[str]:
        """
        (string) The IPv6 network.
        """
        return pulumi.get(self, "ipv6_network")

    @property
    @pulumi.getter
    def iso(self) -> pulumi.Output[Optional[str]]:
        """
        ID or Name of an ISO image to mount.
        """
        return pulumi.get(self, "iso")

    @property
    @pulumi.getter(name="keepDisk")
    def keep_disk(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, do not upgrade the disk. This allows downgrading the server type later.
        """
        return pulumi.get(self, "keep_disk")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        User-defined labels (key-value pairs) should be created with.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location name to create the server in. `nbg1`, `fsn1`, `hel1`, `ash` or `hil`
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the server to create (must be unique per project and a valid hostname as per RFC 1123).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Optional[Sequence['outputs.ServerNetwork']]]:
        """
        Network the server should be attached to on creation. (Can be specified multiple times)
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> pulumi.Output[Optional[int]]:
        """
        Placement Group ID the server added to on creation.
        """
        return pulumi.get(self, "placement_group_id")

    @property
    @pulumi.getter(name="primaryDiskSize")
    def primary_disk_size(self) -> pulumi.Output[int]:
        """
        (int) The size of the primary disk in GB.
        """
        return pulumi.get(self, "primary_disk_size")

    @property
    @pulumi.getter(name="publicNets")
    def public_nets(self) -> pulumi.Output[Optional[Sequence['outputs.ServerPublicNet']]]:
        """
        In this block you can either enable / disable ipv4 and ipv6 or link existing primary IPs (checkout the examples).
        If this block is not defined, two primary (ipv4 & ipv6) ips getting auto generated.
        """
        return pulumi.get(self, "public_nets")

    @property
    @pulumi.getter(name="rebuildProtection")
    def rebuild_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable or disable rebuild protection (Needs to be the same as `delete_protection`).
        """
        return pulumi.get(self, "rebuild_protection")

    @property
    @pulumi.getter
    def rescue(self) -> pulumi.Output[Optional[str]]:
        """
        Enable and boot in to the specified rescue system. This enables simple installation of custom operating systems. `linux64` or `linux32`
        """
        return pulumi.get(self, "rescue")

    @property
    @pulumi.getter(name="serverType")
    def server_type(self) -> pulumi.Output[str]:
        """
        Name of the server type this server should be created with.
        """
        return pulumi.get(self, "server_type")

    @property
    @pulumi.getter(name="shutdownBeforeDeletion")
    def shutdown_before_deletion(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to try shutting the server down gracefully before deleting it.
        """
        return pulumi.get(self, "shutdown_before_deletion")

    @property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        SSH key IDs or names which should be injected into the server at creation time. Once the server is created, you can not update the list of SSH Keys. If you do change this, you will be prompted to destroy and recreate the server. You can avoid this by setting lifecycle.ignore_changes to `[ ssh_keys ]`.
        """
        return pulumi.get(self, "ssh_keys")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        (string) The status of the server.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[str]]:
        """
        Cloud-Init user data to use during server creation
        """
        return pulumi.get(self, "user_data")

