"""Mapping templates for GBD covariates.

This code is automatically generated by gbd_mapping_generator/covariate_builder.py

Any manual changes will be lost.
"""
from .base_template import GbdRecord, ModelableEntity
from .id import cov_id


class Covariate(ModelableEntity):
    """Container for covariate GBD ids and metadata."""
    __slots__ = ('name', 'kind', 'gbd_id', 'by_age', 'by_sex', 'dichotomous', )

    def __init__(self,
                 name: str,
                 kind: str,
                 gbd_id: cov_id | None,
                 by_age: bool,
                 by_sex: bool,
                 dichotomous: bool, ):
        super().__init__(name=name,
                         kind=kind,
                         gbd_id=gbd_id)
        self.name = name
        self.kind = kind
        self.gbd_id = gbd_id
        self.by_age = by_age
        self.by_sex = by_sex
        self.dichotomous = dichotomous


class Covariates(GbdRecord):
    """Container for GBD covariates."""
    __slots__ = ('legality_of_abortion', 'absolute_value_of_average_latitude',
                 'antenatal_care_1_visit_coverage_proportion', 'antenatal_care_4_visits_coverage_proportion',
                 'age_specific_fertility_rate', 'tobacco_cigarettes_per_capita',
                 'coastal_population_within_10km_proportion', 'contraception_modern_prevalence_proportion_by_age',
                 'contraception_modern_prevalence_proportion', 'cumulative_cigarettes_10_years',
                 'cumulative_cigarettes_15_years', 'cumulative_cigarettes_20_years', 'cumulative_cigarettes_5_years',
                 'diabetes_fasting_plasma_glucose_mmol_l_age_standardized_25_and_up',
                 'diabetes_age_standardized_prevalence_proportion', 'dtp3_coverage_covid_free_proportion',
                 'education_years_per_capita', 'gold_production_binary',
                 'proportion_of_households_using_iodized_salt_adjusted',
                 'hib3_vaccine_coverage_covid_free_proportion', 'hiv_prevalence_unadjusted_proportion',
                 'hospital_beds_per_1000', 'in_facility_delivery_proportion', 'landlocked_nation_binary',
                 'average_latitude', 'ldi_income_per_capita', 'live_births_thousands', 'mean_bmi',
                 'low_density_lipoprotein_mmol_l', 'systolic_blood_pressure_mmhg',
                 'population_weighted_mean_temperature', 'measles_vaccine_coverage_covid_free_proportion',
                 'mortality_rate_due_to_death_shocks_in_last_10_years_per_1_person',
                 'live_births_35_and_up_proportion', 'live_births_40_and_up_proportion', 'pigs_per_capita',
                 'indoor_air_pollution_all_cooking_fuels', 'outdoor_air_pollution_pm_2_5',
                 'latitude_under_15_proportion', 'elevation_over_1500m_proportion', 'population_15_to_30_proportion',
                 'latitude_15_to_30_proportion', 'latitude_30_to_45_proportion', 'latitude_over_45_proportion',
                 'elevation_500_to_1500m_proportion', 'population_density_150_300_ppl_sqkm_proportion',
                 'population_density_300_500_ppl_sqkm_proportion', 'population_density_500_1000_ppl_sqkm_proportion',
                 'population_density_over_1000_ppl_sqkm_proportion',
                 'population_density_under_150_ppl_sqkm_proportion', 'population_over_65_proportion',
                 'elevation_under_100m_proportion', 'rainfall_population_weighted_mm_yr', 'rainfall_quintiles_4_5',
                 'rainfall_quintile_1_proportion', 'rainfall_quintile_2_proportion',
                 'rainfall_quintile_5_proportion', 'religion_binary_greater_than_50_percent_muslim',
                 'sahel_region_of_africa_binary', 'sanitation_proportion_with_access',
                 'skilled_birth_attendance_proportion', 'smoking_prevalence',
                 'smoking_prevalence_reproductive_age_standardized',
                 'ninetieth_percentile_climatic_temperature_in_the_given_country_year',
                 'tetanus_toxoid_maternal_protection_at_birth', 'total_fertility_rate',
                 'vehicles_2_and_up4_wheels_per_capita', 'vehicles_2_wheels_per_capita',
                 'vehicles_4_wheels_per_capita', 'vehicles_2_wheels_fraction_proportion',
                 'mortality_rate_due_to_war_shocks_per_1_person', 'improved_water_source_proportion_with_access',
                 'malaria_lysenko_pfpr_1_holoendemic', 'malaria_pfpr_rate',
                 'significant_leishmaniasis_endemicity_binary', 'year', 'birth_prevalence_of_chd',
                 'birth_prevalence_of_congenital_chromosomal_anomalies',
                 'hemoglobinopathies_prevalence_x_excess_mortality', 'age_standardize_prevalence_of_severe_anemia',
                 'maternal_care_and_immunization', 'neonatal_mortality_rate_per_1000',
                 'pcv3_coverage_covid_free_proportion', 'presence_of_leishmaniasis_binary', 'under_5_hiv_death_rate',
                 'syphilis_prevalence_proportion', 'population_weighted_probability_of_dengue_transmission',
                 'dengue_outbreaks_binary', 'proportion_of_the_population_living_in_the_classic_monsoon_region',
                 'proportion_of_the_population_living_in_the_classic_monsoon_region_low_income_countries',
                 'hemoglobinopathies_prevalence_x_excess_mortality_excluding_g6pd_deficiency',
                 'alcohol_binge_drinker_proportion_age_standardized',
                 'smoking_prevalence_age_standardized_both_sexes',
                 'proportion_of_the_population_living_in_the_indian_ocean_monsoon_belt',
                 'vitamin_a_deficiency_prevalence_age_standardized', 'prevalence_of_obesity',
                 'prevalence_of_overweight_and_obesity', 'prevalence_of_obesity_age_standardized',
                 'maternal_education_years_per_capita', 'chagasprevpaho',
                 'enhanced_vegetation_index_long_term_average_2000_2012_mean', 'log_transformed_sev_scalar_tb',
                 'log_transformed_sev_scalar_oth_hiv', 'log_transformed_sev_scalar_diarrhea',
                 'log_transformed_sev_scalar_lri', 'log_transformed_sev_scalar_uri',
                 'log_transformed_sev_scalar_otitis', 'log_transformed_sev_scalar_meningitis',
                 'log_transformed_sev_scalar_measles', 'log_transformed_sev_scalar_malaria',
                 'log_transformed_sev_scalar_mat_hem', 'log_transformed_sev_scalar_mat_sepsis',
                 'log_transformed_sev_scalar_mat_htn', 'log_transformed_sev_scalar_mat_indir',
                 'log_transformed_sev_scalar_mat_late', 'log_transformed_sev_scalar_oth_mat',
                 'log_transformed_sev_scalar_hep', 'log_transformed_sev_scalar_hep_b',
                 'log_transformed_sev_scalar_hep_c', 'log_transformed_sev_scalar_esophag_c',
                 'log_transformed_sev_scalar_stomach_c', 'log_transformed_sev_scalar_liver_c',
                 'log_transformed_sev_scalar_liver_c_hepb', 'log_transformed_sev_scalar_liver_c_hepc',
                 'log_transformed_sev_scalar_oth_liver_c', 'log_transformed_sev_scalar_larynx_c',
                 'log_transformed_sev_scalar_lung_c', 'log_transformed_sev_scalar_breast_c',
                 'log_transformed_sev_scalar_uterus_c', 'log_transformed_sev_scalar_prostate_c',
                 'log_transformed_sev_scalar_colorect_c', 'log_transformed_sev_scalar_lip_oral_c',
                 'log_transformed_sev_scalar_nasoph_c', 'log_transformed_sev_scalar_oth_phar_c',
                 'log_transformed_sev_scalar_gallblad_c', 'log_transformed_sev_scalar_pancreas_c',
                 'log_transformed_sev_scalar_ovary_c', 'log_transformed_sev_scalar_kidney_c',
                 'log_transformed_sev_scalar_bladder_c', 'log_transformed_sev_scalar_thyroid_c',
                 'log_transformed_sev_scalar_mesothel', 'log_transformed_sev_scalar_leukemia',
                 'log_transformed_sev_scalar_ihd', 'log_transformed_sev_scalar_stroke',
                 'log_transformed_sev_scalar_isch_stroke', 'log_transformed_sev_scalar_intrahem_stroke',
                 'log_transformed_sev_scalar_cmp', 'log_transformed_sev_scalar_a_fib',
                 'log_transformed_sev_scalar_aort_an', 'log_transformed_sev_scalar_pad',
                 'log_transformed_sev_scalar_copd', 'log_transformed_sev_scalar_asthma',
                 'log_transformed_sev_scalar_cirr_hepb', 'log_transformed_sev_scalar_cirr_hepc',
                 'log_transformed_sev_scalar_pancreatit', 'log_transformed_sev_scalar_idiopathic_epilepsy',
                 'log_transformed_sev_scalar_schizo', 'log_transformed_sev_scalar_depression',
                 'log_transformed_sev_scalar_mdd', 'log_transformed_sev_scalar_bipolar',
                 'log_transformed_sev_scalar_anxiety', 'log_transformed_sev_scalar_eating',
                 'log_transformed_sev_scalar_bulimia', 'log_transformed_sev_scalar_conduct',
                 'log_transformed_sev_scalar_id', 'log_transformed_sev_scalar_osteoarth',
                 'log_transformed_sev_scalar_back_pain', 'log_transformed_sev_scalar_gout',
                 'log_transformed_sev_scalar_sense', 'log_transformed_sev_scalar_cataract',
                 'log_transformed_sev_scalar_hearing', 'log_transformed_sev_scalar_sids',
                 'log_transformed_sev_scalar_road_inj', 'log_transformed_sev_scalar_pedest',
                 'log_transformed_sev_scalar_cyclist', 'log_transformed_sev_scalar_mot_cyc',
                 'log_transformed_sev_scalar_mot_veh', 'log_transformed_sev_scalar_oth_road',
                 'log_transformed_sev_scalar_oth_trans', 'log_transformed_sev_scalar_falls',
                 'log_transformed_sev_scalar_drown', 'log_transformed_sev_scalar_fire',
                 'log_transformed_sev_scalar_poison', 'log_transformed_sev_scalar_mech',
                 'log_transformed_sev_scalar_mech_gun', 'log_transformed_sev_scalar_oth_mech',
                 'log_transformed_sev_scalar_animal', 'log_transformed_sev_scalar_venom',
                 'log_transformed_sev_scalar_non_ven', 'log_transformed_sev_scalar_f_body',
                 'log_transformed_sev_scalar_f_body_asp', 'log_transformed_sev_scalar_oth_f_body',
                 'log_transformed_sev_scalar_oth_unint', 'log_transformed_sev_scalar_self_harm',
                 'log_transformed_sev_scalar_violence', 'log_transformed_sev_scalar_viol_gun',
                 'log_transformed_sev_scalar_viol_knife', 'log_transformed_sev_scalar_oth_viol',
                 'log_transformed_sev_scalar_disaster', 'log_transformed_sev_scalar_mat_hiv',
                 'log_transformed_age_standardized_sev_scalar_tb',
                 'log_transformed_age_standardized_sev_scalar_oth_hiv',
                 'log_transformed_age_standardized_sev_scalar_diarrhea',
                 'log_transformed_age_standardized_sev_scalar_lri',
                 'log_transformed_age_standardized_sev_scalar_uri',
                 'log_transformed_age_standardized_sev_scalar_otitis',
                 'log_transformed_age_standardized_sev_scalar_measles',
                 'log_transformed_age_standardized_sev_scalar_mat_hem',
                 'log_transformed_age_standardized_sev_scalar_mat_sepsis',
                 'log_transformed_age_standardized_sev_scalar_hep',
                 'log_transformed_age_standardized_sev_scalar_hep_b',
                 'log_transformed_age_standardized_sev_scalar_hep_c',
                 'log_transformed_age_standardized_sev_scalar_esophag_c',
                 'log_transformed_age_standardized_sev_scalar_stomach_c',
                 'log_transformed_age_standardized_sev_scalar_liver_c',
                 'log_transformed_age_standardized_sev_scalar_liver_c_hepb',
                 'log_transformed_age_standardized_sev_scalar_liver_c_hepc',
                 'log_transformed_age_standardized_sev_scalar_oth_liver_c',
                 'log_transformed_age_standardized_sev_scalar_larynx_c',
                 'log_transformed_age_standardized_sev_scalar_lung_c',
                 'log_transformed_age_standardized_sev_scalar_breast_c',
                 'log_transformed_age_standardized_sev_scalar_uterus_c',
                 'log_transformed_age_standardized_sev_scalar_prostate_c',
                 'log_transformed_age_standardized_sev_scalar_colorect_c',
                 'log_transformed_age_standardized_sev_scalar_lip_oral_c',
                 'log_transformed_age_standardized_sev_scalar_nasoph_c',
                 'log_transformed_age_standardized_sev_scalar_oth_phar_c',
                 'log_transformed_age_standardized_sev_scalar_gallblad_c',
                 'log_transformed_age_standardized_sev_scalar_pancreas_c',
                 'log_transformed_age_standardized_sev_scalar_ovary_c',
                 'log_transformed_age_standardized_sev_scalar_kidney_c',
                 'log_transformed_age_standardized_sev_scalar_bladder_c',
                 'log_transformed_age_standardized_sev_scalar_thyroid_c',
                 'log_transformed_age_standardized_sev_scalar_mesothel',
                 'log_transformed_age_standardized_sev_scalar_leukemia',
                 'log_transformed_age_standardized_sev_scalar_ihd',
                 'log_transformed_age_standardized_sev_scalar_stroke',
                 'log_transformed_age_standardized_sev_scalar_isch_stroke',
                 'log_transformed_age_standardized_sev_scalar_intrahem_stroke',
                 'log_transformed_age_standardized_sev_scalar_cmp',
                 'log_transformed_age_standardized_sev_scalar_a_fib',
                 'log_transformed_age_standardized_sev_scalar_aort_an',
                 'log_transformed_age_standardized_sev_scalar_pad',
                 'log_transformed_age_standardized_sev_scalar_copd',
                 'log_transformed_age_standardized_sev_scalar_asthma',
                 'log_transformed_age_standardized_sev_scalar_cirr_hepb',
                 'log_transformed_age_standardized_sev_scalar_cirr_hepc',
                 'log_transformed_age_standardized_sev_scalar_pancreatit',
                 'log_transformed_age_standardized_sev_scalar_idiopathic_epilepsy',
                 'log_transformed_age_standardized_sev_scalar_depression',
                 'log_transformed_age_standardized_sev_scalar_mdd', 'log_transformed_age_standardized_sev_scalar_id',
                 'log_transformed_age_standardized_sev_scalar_osteoarth',
                 'log_transformed_age_standardized_sev_scalar_back_pain',
                 'log_transformed_age_standardized_sev_scalar_gout',
                 'log_transformed_age_standardized_sev_scalar_sense',
                 'log_transformed_age_standardized_sev_scalar_cataract',
                 'log_transformed_age_standardized_sev_scalar_hearing',
                 'log_transformed_age_standardized_sev_scalar_road_inj',
                 'log_transformed_age_standardized_sev_scalar_pedest',
                 'log_transformed_age_standardized_sev_scalar_cyclist',
                 'log_transformed_age_standardized_sev_scalar_mot_cyc',
                 'log_transformed_age_standardized_sev_scalar_mot_veh',
                 'log_transformed_age_standardized_sev_scalar_oth_road',
                 'log_transformed_age_standardized_sev_scalar_oth_trans',
                 'log_transformed_age_standardized_sev_scalar_falls',
                 'log_transformed_age_standardized_sev_scalar_drown',
                 'log_transformed_age_standardized_sev_scalar_fire',
                 'log_transformed_age_standardized_sev_scalar_poison',
                 'log_transformed_age_standardized_sev_scalar_mech',
                 'log_transformed_age_standardized_sev_scalar_mech_gun',
                 'log_transformed_age_standardized_sev_scalar_oth_mech',
                 'log_transformed_age_standardized_sev_scalar_animal',
                 'log_transformed_age_standardized_sev_scalar_venom',
                 'log_transformed_age_standardized_sev_scalar_non_ven',
                 'log_transformed_age_standardized_sev_scalar_f_body',
                 'log_transformed_age_standardized_sev_scalar_f_body_asp',
                 'log_transformed_age_standardized_sev_scalar_oth_f_body',
                 'log_transformed_age_standardized_sev_scalar_oth_unint',
                 'log_transformed_age_standardized_sev_scalar_self_harm',
                 'log_transformed_age_standardized_sev_scalar_violence',
                 'log_transformed_age_standardized_sev_scalar_viol_gun',
                 'log_transformed_age_standardized_sev_scalar_viol_knife',
                 'log_transformed_age_standardized_sev_scalar_oth_viol', 'education_age_standardized',
                 'meningitis_belt_proportion', 'gdp_per_capita_base_2010', 'urbanicity_binary',
                 'age_and_sex_specific_sev_for_unsafe_water', 'age_and_sex_specific_sev_for_unsafe_sanitation',
                 'dengue_reporting_trends_transformed_into_relative_risks_relative_to_that_countrys_mean_incidence',
                 'echinococcosis_endemicity', 'socio_demographic_index',
                 'japanese_encelphalitis_endemic_area_binary', 'calcium_unadjusted_g', 'fiber_unadjusted_g',
                 'fruits_unadjusted_g', 'milk_unadjusted_g', 'nuts_seeds_unadjusted_g', 'pufa_adjusted_percent',
                 'pulses_legumes_unadjusted_g', 'red_meats_unadjusted_g', 'sugar_unadjusted_g',
                 'vegetables_unadjusted_g', 'energy_unadjusted_kcal', 'hiv_mortality_females_10_54',
                 'hiv_age_standardized_prevalence', 'log_transformed_age_standardized_sev_scalar_maternal',
                 'log_transformed_age_standardized_sev_scalar_cvd',
                 'log_transformed_age_standardized_sev_scalar_chr_resp',
                 'log_transformed_age_standardized_sev_scalar_cirrhosis',
                 'log_transformed_age_standardized_sev_scalar_digestive',
                 'log_transformed_age_standardized_sev_scalar_msk',
                 'log_transformed_age_standardized_sev_scalar_trans_inj', 'log_transformed_sev_scalar_maternal',
                 'log_transformed_sev_scalar_cvd', 'log_transformed_sev_scalar_chr_resp',
                 'log_transformed_sev_scalar_cirrhosis', 'log_transformed_sev_scalar_digestive',
                 'log_transformed_sev_scalar_msk', 'log_transformed_sev_scalar_trans_inj', 'vitamin_a_unadjusted_iu',
                 'vitamin_a_rae_unadjusted_ug', 'dietary_zinc_unadjusted_mg',
                 'proportion_of_total_population_covered_by_menafrivac_initiative_meningitis_meningococcal_type_a_vaccine',
                 'malaria_incidence_adjusted_for_antimalarial_coverage_and_drug_effectiveness',
                 'rotavirus_coverage_covid_free_proportion', 'proportion_of_cirrhosis_due_to_alcohol',
                 'proportion_of_cirrhosis_due_to_hepatitis_b', 'proportion_of_cirrhosis_due_to_hepatitis_c',
                 'proportion_of_cirrhosis_due_to_other_causes',
                 'proportion_of_liver_cancer_due_to_alcohol_age_standardized',
                 'proportion_of_liver_cancer_due_to_hepatitis_b_age_standardized',
                 'proportion_of_liver_cancer_due_to_hepatitis_c_age_standardized',
                 'proportion_of_liver_cancer_due_to_other_causes_age_standardized', 'major_depressive_disorder',
                 'proportion_of_population_involved_in_agricultural_activities', 'health_expenditure_per_capita',
                 'fraction_of_oop_health_expenditure', 'universal_health_coverage',
                 'maternal_alcohol_consumption_during_pregnancy_proportion', 'healthcare_access_and_quality_index',
                 'age_standardized_proportion_adult_underweight', 'ors_oral_rehydration', 'antibiotics_for_lri',
                 'live_births_by_sex', 'age_standardized_melanoma',
                 'measles_vaccine_coverage_2_doses_covid_free_proportion', 'schisto_cumulative_treatments',
                 'health_worker_density', 'iron_energy_unadjusted_mg', 'malaria_incidence_map',
                 'antimalarial_effective_treatment_map', 'rubella_vaccine_coverage_covid_free_proportion',
                 'tuberculosis_infection_risk_weighted_prevalence_age_standardized',
                 'ten_year_lag_distributed_energy_per_capita', 'folic_acid_unadjusted_ug',
                 'smooth_outphase_of_leaded_gasoline', 'no_access_to_handwashing_facility', 'residential_radon',
                 'zinc_deficiency', 'diet_high_in_trans_fatty_acids', 'diet_high_in_sodium',
                 'tuberculosis_prevalence_age_standardized', 'low_bone_mineral_density',
                 'age_standardized_bone_mineral_density_among_population_age_60_and_up_years',
                 'malnutrition_shock_mortality_rate', 'mean_war_mortality_rate_in_the_previous_ten_years',
                 'log_transformed_age_standardized_sev_scalar_for_both_sexes_combined_tb', 'secondhand_smoke',
                 'asbestos_consumption_metric_tons_per_year_per_capita', 'zinc_treatment_for_diarrhea',
                 'fortification_standard_including_folic_acid',
                 'demand_for_contraception_satisfied_with_modern_methods',
                 'demand_for_contraception_satisfied_with_modern_methods_by_age',
                 'polio_3_dose_coverage_covid_free_proportion', 'hepatitis_b_3_dose_coverage_covid_free_proportion',
                 'composite_fortification_standard_and_folic_acid_inclusion',
                 'intravenous_drug_use_proportion_by_age', 'intravenous_drug_use_age_standardized_proportion',
                 'alcohol_consumption_age_standardized_in_grams_per_day',
                 'alcohol_drinker_proportion_age_standardized',
                 'proportion_of_liver_cancer_due_to_nash_age_standardized', 'proportion_of_cirrhosis_due_to_nash',
                 'muslim_religion_proportion_of_population', 'tb_strain_prevalence_weighted_transmission_rr',
                 'age_and_sex_specific_sev_for_child_underweight', 'age_standardized_sev_for_child_underweight',
                 'age_and_sex_specific_sev_for_child_stunting', 'age_standardized_sev_for_child_stunting',
                 'age_and_sex_specific_sev_for_child_wasting', 'age_standardized_sev_for_child_wasting',
                 'fortification_standard_including_iron', 'pelvic_inflammatory_disease_age_standardized_prevalence',
                 'nafld_nash_prevalence', 'hepatitis_b_3_dose_coverage_lagged_5_years_covid_free_proportion',
                 'hepatitis_b_3_dose_coverage_lagged_ten_years_covid_free_proportion',
                 'age_and_sex_specific_sev_for_alcohol_use', 'age_standardized_sev_for_alcohol_use',
                 'underweight_women_age_specific', 'log_transformed_sev_scalar_group_i',
                 'log_transformed_sev_scalar_drug_sus_tb', 'log_transformed_sev_scalar_mdr_tb',
                 'log_transformed_sev_scalar_xdr_tb', 'log_transformed_sev_scalar_hiv',
                 'log_transformed_sev_scalar_drug_sus_hiv_tb', 'log_transformed_sev_scalar_mdr_hiv_tb',
                 'log_transformed_sev_scalar_xdr_hiv_tb', 'log_transformed_sev_scalar_encepha',
                 'log_transformed_sev_scalar_nn_enceph', 'log_transformed_sev_scalar_nn_sepsis',
                 'log_transformed_sev_scalar_nn_hemol', 'log_transformed_sev_scalar_oth_nn',
                 'log_transformed_sev_scalar_ncd', 'log_transformed_sev_scalar_lymphoma',
                 'log_transformed_sev_scalar_myeloma', 'log_transformed_sev_scalar_all',
                 'log_transformed_sev_scalar_cll', 'log_transformed_sev_scalar_aml',
                 'log_transformed_sev_scalar_cml', 'log_transformed_sev_scalar_oth_leukemia',
                 'log_transformed_sev_scalar_oth_cmp', 'log_transformed_sev_scalar_pud',
                 'log_transformed_sev_scalar_gall_bile', 'log_transformed_sev_scalar_alzheimers',
                 'log_transformed_sev_scalar_ms', 'log_transformed_sev_scalar_rheu_arth',
                 'log_transformed_sev_scalar_glaucoma', 'log_transformed_sev_scalar_macular',
                 'log_transformed_sev_scalar_injuries', 'log_transformed_sev_scalar_self_firearm',
                 'log_transformed_sev_scalar_self_other', 'log_transformed_sev_scalar_sex_viol',
                 'log_transformed_age_standardized_sev_scalar_group_i',
                 'log_transformed_age_standardized_sev_scalar_drug_sus_tb',
                 'log_transformed_age_standardized_sev_scalar_mdr_tb',
                 'log_transformed_age_standardized_sev_scalar_xdr_tb',
                 'log_transformed_age_standardized_sev_scalar_hiv',
                 'log_transformed_age_standardized_sev_scalar_drug_sus_hiv_tb',
                 'log_transformed_age_standardized_sev_scalar_mdr_hiv_tb',
                 'log_transformed_age_standardized_sev_scalar_xdr_hiv_tb',
                 'log_transformed_age_standardized_sev_scalar_meningitis',
                 'log_transformed_age_standardized_sev_scalar_encepha',
                 'log_transformed_age_standardized_sev_scalar_nn_enceph',
                 'log_transformed_age_standardized_sev_scalar_nn_sepsis',
                 'log_transformed_age_standardized_sev_scalar_nn_hemol',
                 'log_transformed_age_standardized_sev_scalar_oth_nn',
                 'log_transformed_age_standardized_sev_scalar_lymphoma',
                 'log_transformed_age_standardized_sev_scalar_myeloma',
                 'log_transformed_age_standardized_sev_scalar_all',
                 'log_transformed_age_standardized_sev_scalar_cll',
                 'log_transformed_age_standardized_sev_scalar_aml',
                 'log_transformed_age_standardized_sev_scalar_cml',
                 'log_transformed_age_standardized_sev_scalar_oth_leukemia',
                 'log_transformed_age_standardized_sev_scalar_oth_cmp',
                 'log_transformed_age_standardized_sev_scalar_pud',
                 'log_transformed_age_standardized_sev_scalar_gall_bile',
                 'log_transformed_age_standardized_sev_scalar_alzheimers',
                 'log_transformed_age_standardized_sev_scalar_ms',
                 'log_transformed_age_standardized_sev_scalar_rheu_arth',
                 'log_transformed_age_standardized_sev_scalar_glaucoma',
                 'log_transformed_age_standardized_sev_scalar_macular',
                 'log_transformed_age_standardized_sev_scalar_sids',
                 'log_transformed_age_standardized_sev_scalar_injuries',
                 'log_transformed_age_standardized_sev_scalar_self_firearm',
                 'log_transformed_age_standardized_sev_scalar_self_other',
                 'log_transformed_age_standardized_sev_scalar_sex_viol',
                 'opioids_per_million_population_per_day_ten_year_lag', 'occupation_professionals',
                 'health_industry_workers', 'education_years_per_capita_aggregated_by_age_15_and_up_and_sex',
                 'total_physical_activity_met_min_week_age_specific',
                 'total_physical_activity_met_min_week_age_standardized',
                 'bacille_calmette_guerin_bcg_vaccine_coverage_covid_free_proportion',
                 'hepatitis_b_vaccine_coverage_aged_through_time_covid_free_proportion',
                 'adolescent_birth_rates_10_19_years_of_age', 'log_total_health_expenditure_per_capita',
                 'pigs_raised_in_extensive_agricultural_systems_per_capita', 'physicians_per_capita',
                 'nurses_and_midwives_per_capita', 'pharmacists_per_capita', 'hiv_mortality_rate',
                 'dentists_per_capita', 'net_reproduction_rate', 'log_transformed_coal_production_per_capita',
                 'systolic_blood_pressure_mmhg_us_r_e', 'low_density_lipoprotein_mmol_l_us_r_e',
                 'mean_bmi_kg_m2_us_r_e', 'education_years_per_capita_us_r_e', 'ldi_income_per_capita_us_r_e',
                 'fasting_plasma_glucose_us_r_e', 'total_physical_activity_met_min_week_age_specific_us_r_e',
                 'total_physical_activity_met_min_week_age_standardized_us_r_e', 'alcohol_liters_per_capita_us_r_e',
                 'smoking_prevalence_us_r_e', 'outdoor_air_pollution_pm_2_5_us_r_e', 'fruits_unadjusted_g_us_r_e',
                 'vegetables_unadjusted_g_us_r_e', 'education_relative_inequality_gini',
                 'proportion_of_the_population_with_at_least_6_years_of_education_maternal',
                 'proportion_of_the_population_with_at_least_12_years_of_education_maternal',
                 'mmr_due_to_maternal_hemorrhage', 'mmr_due_to_maternal_hypertensive_disorders',
                 'mmr_due_to_sepsis_and_other_maternal_infections', 'mmr_due_to_obstructed_labor',
                 'age_standardized_sev_for_unsafe_water', 'age_standardized_sev_for_unsafe_sanitation',
                 'age_and_sex_specific_sev_for_handwashing', 'age_standardized_sev_for_handwashing',
                 'age_and_sex_specific_sev_for_ambient_particulate_matter',
                 'age_standardized_sev_for_ambient_particulate_matter',
                 'age_and_sex_specific_sev_for_household_air_pollution',
                 'age_standardized_sev_for_household_air_pollution', 'age_and_sex_specific_sev_for_ozone',
                 'age_standardized_sev_for_ozone', 'age_and_sex_specific_sev_for_radon',
                 'age_standardized_sev_for_radon', 'age_and_sex_specific_sev_for_lead',
                 'age_standardized_sev_for_lead', 'age_and_sex_specific_sev_for_occupational_asbestos',
                 'age_standardized_sev_for_occupational_asbestos',
                 'age_and_sex_specific_sev_for_occupational_arsenic',
                 'age_standardized_sev_for_occupational_arsenic',
                 'age_and_sex_specific_sev_for_occupational_benzene',
                 'age_standardized_sev_for_occupational_benzene',
                 'age_and_sex_specific_sev_for_occupational_beryllium',
                 'age_standardized_sev_for_occupational_beryllium',
                 'age_and_sex_specific_sev_for_occupational_cadmium',
                 'age_standardized_sev_for_occupational_cadmium',
                 'age_and_sex_specific_sev_for_occupational_chromium',
                 'age_standardized_sev_for_occupational_chromium',
                 'age_and_sex_specific_sev_for_occupational_diesel', 'age_standardized_sev_for_occupational_diesel',
                 'age_and_sex_specific_sev_for_occupational_formaldehyde',
                 'age_standardized_sev_for_occupational_formaldehyde',
                 'age_and_sex_specific_sev_for_occupational_nickel', 'age_standardized_sev_for_occupational_nickel',
                 'age_and_sex_specific_sev_for_occupational_pah', 'age_standardized_sev_for_occupational_pah',
                 'age_and_sex_specific_sev_for_occupational_silica', 'age_standardized_sev_for_occupational_silica',
                 'age_and_sex_specific_sev_for_occupational_sulfuric_acid',
                 'age_standardized_sev_for_occupational_sulfuric_acid',
                 'age_and_sex_specific_sev_for_occupational_trichloroethylene',
                 'age_standardized_sev_for_occupational_trichloroethylene',
                 'age_and_sex_specific_sev_for_occupational_asthmagens',
                 'age_standardized_sev_for_occupational_asthmagens',
                 'age_and_sex_specific_sev_for_occupational_particulates',
                 'age_standardized_sev_for_occupational_particulates',
                 'age_and_sex_specific_sev_for_occupational_noise', 'age_standardized_sev_for_occupational_noise',
                 'age_and_sex_specific_sev_for_occupational_ergonomic',
                 'age_standardized_sev_for_occupational_ergonomic',
                 'age_and_sex_specific_sev_for_non_exclusive_breastfeeding',
                 'age_standardized_sev_for_non_exclusive_breastfeeding',
                 'age_and_sex_specific_sev_for_discontinued_breastfeeding',
                 'age_standardized_sev_for_discontinued_breastfeeding',
                 'age_and_sex_specific_sev_for_short_gestation', 'age_standardized_sev_for_short_gestation',
                 'age_and_sex_specific_sev_for_low_birth_weight', 'age_standardized_sev_for_low_birth_weight',
                 'age_and_sex_specific_sev_for_iron_deficiency', 'age_standardized_sev_for_iron_deficiency',
                 'age_and_sex_specific_sev_for_vitamin_a_deficiency',
                 'age_standardized_sev_for_vitamin_a_deficiency', 'age_and_sex_specific_sev_for_zinc_deficiency',
                 'age_standardized_sev_for_zinc_deficiency', 'age_and_sex_specific_sev_for_smoking',
                 'age_standardized_sev_for_smoking', 'age_and_sex_specific_sev_for_chewing_tobacco',
                 'age_standardized_sev_for_chewing_tobacco', 'age_and_sex_specific_sev_for_secondhand_smoke',
                 'age_standardized_sev_for_secondhand_smoke', 'age_and_sex_specific_sev_for_drug_use',
                 'age_standardized_sev_for_drug_use', 'age_and_sex_specific_sev_for_low_fruit',
                 'age_standardized_sev_for_low_fruit', 'age_and_sex_specific_sev_for_low_vegetables',
                 'age_standardized_sev_for_low_vegetables', 'age_and_sex_specific_sev_for_low_legumes',
                 'age_standardized_sev_for_low_legumes', 'age_and_sex_specific_sev_for_low_whole_grains',
                 'age_standardized_sev_for_low_whole_grains', 'age_and_sex_specific_sev_for_low_nuts_and_seeds',
                 'age_standardized_sev_for_low_nuts_and_seeds', 'age_and_sex_specific_sev_for_low_milk',
                 'age_standardized_sev_for_low_milk', 'age_and_sex_specific_sev_for_high_red_meat',
                 'age_standardized_sev_for_high_red_meat', 'age_and_sex_specific_sev_for_high_processed_meat',
                 'age_standardized_sev_for_high_processed_meat',
                 'age_and_sex_specific_sev_for_high_sweetened_beverages',
                 'age_standardized_sev_for_high_sweetened_beverages', 'age_and_sex_specific_sev_for_low_fiber',
                 'age_standardized_sev_for_low_fiber', 'age_and_sex_specific_sev_for_low_calcium',
                 'age_standardized_sev_for_low_calcium', 'age_and_sex_specific_sev_for_low_omega_3',
                 'age_standardized_sev_for_low_omega_3', 'age_and_sex_specific_sev_for_low_pufa',
                 'age_standardized_sev_for_low_pufa', 'age_and_sex_specific_sev_for_high_trans_fat',
                 'age_standardized_sev_for_high_trans_fat', 'age_and_sex_specific_sev_for_high_sodium',
                 'age_standardized_sev_for_high_sodium', 'age_and_sex_specific_sev_for_intimate_partner_violence',
                 'age_standardized_sev_for_intimate_partner_violence',
                 'age_and_sex_specific_sev_for_childhood_sexual_abuse',
                 'age_standardized_sev_for_childhood_sexual_abuse', 'age_and_sex_specific_sev_for_bullying',
                 'age_standardized_sev_for_bullying', 'age_and_sex_specific_sev_for_low_physical_activity',
                 'age_standardized_sev_for_low_physical_activity',
                 'age_and_sex_specific_sev_for_high_fasting_plasma_glucose',
                 'age_standardized_sev_for_high_fasting_plasma_glucose', 'age_and_sex_specific_sev_for_high_ldl',
                 'age_standardized_sev_for_high_ldl', 'age_and_sex_specific_sev_for_high_blood_pressure',
                 'age_standardized_sev_for_high_blood_pressure', 'age_and_sex_specific_sev_for_high_body_mass_index',
                 'age_standardized_sev_for_high_body_mass_index',
                 'age_and_sex_specific_sev_for_low_bone_mineral_density',
                 'age_standardized_sev_for_low_bone_mineral_density',
                 'age_and_sex_specific_sev_for_impaired_kidney_function',
                 'age_standardized_sev_for_impaired_kidney_function',
                 'log_transformed_age_standardized_sev_scalar_obst_labor', 'log_transformed_sev_scalar_obst_labor',
                 'log_transformed_age_standardized_sev_scalar_ectopic_preg',
                 'log_transformed_sev_scalar_ectopic_preg', 'log_transformed_age_standardized_sev_scalar_neonatal',
                 'log_transformed_sev_scalar_neonatal', 'log_transformed_age_standardized_sev_scalar_liver_c_nash',
                 'log_transformed_sev_scalar_liver_c_nash', 'log_transformed_age_standardized_sev_scalar_sub_hem',
                 'log_transformed_sev_scalar_sub_hem', 'log_transformed_age_standardized_sev_scalar_upper_digest',
                 'log_transformed_sev_scalar_upper_digest', 'log_transformed_age_standardized_sev_scalar_blindness',
                 'log_transformed_sev_scalar_blindness', 'log_transformed_age_standardized_sev_scalar_inj_pois_co',
                 'log_transformed_sev_scalar_inj_pois_co',
                 'log_transformed_age_standardized_sev_scalar_inj_pois_oth',
                 'log_transformed_sev_scalar_inj_pois_oth',
                 'log_transformed_age_standardized_sev_scalar_heat__and_up_cold',
                 'log_transformed_sev_scalar_heat__and_up_cold',
                 'log_transformed_age_standardized_sev_scalar_mat_htn',
                 'log_transformed_age_standardized_sev_scalar_mat_indir',
                 'log_transformed_age_standardized_sev_scalar_mat_late',
                 'log_transformed_age_standardized_sev_scalar_oth_mat',
                 'log_transformed_age_standardized_sev_scalar_ncd',
                 'log_transformed_age_standardized_sev_scalar_anxiety',
                 'log_transformed_age_standardized_sev_scalar_disaster',
                 'log_transformed_age_standardized_sev_scalar_mat_hiv',
                 'log_transformed_age_standardized_sev_scalar_mat_abort', 'log_transformed_sev_scalar_mat_abort',
                 'proportion_of_the_population_with_0_years_of_education_maternal',
                 'stillbirth_28_weeks_to_live_birth_ratio', 'proportion_pnn_pop_aged_1_5_mo',
                 'proportion_1_4_pop_aged_1_year', 'gallup_negative_experience_index',
                 'proportion_of_the_population_working_in_mining_with_20_year_lag',
                 'gold_production_kg_per_capita_smoothed_with_20_year_lag',
                 'diabetes_fasting_plasma_glucose_mmol_l_by_age',
                 'hepatitis_a_seroprevalence_anti_hav_age_standardized',
                 'hepatitis_b_seroprevalence_hbsag_age_standardized',
                 'hepatitis_c_seroprevalence_anti_hcv_age_standardized',
                 'hepatitis_e_seroprevalence_anti_hev_age_standardized', 'bac_law_general_population_quartile',
                 'bac_law_youth_drivers_quartile', 'bac_law_professional_drivers_quartile',
                 'speed_limit_law_urban_quartile', 'speed_limit_law_rural_quartile',
                 'liters_of_alcohol_consumed_per_capita', 'live_births_by_childs_sex_and_maternal_age',
                 'population_15_to_30_males_proportion', 'max_trachoma_population_at_risk',
                 'schistosomiasis_prevalence_results', 'who_sth_mda_coverage',
                 'bcg_lagged_five_year_coverage_covid_free_proportion',
                 'dtp3_lagged_five_year_coverage_covid_free_proportion',
                 'mcv1_lagged_five_year_coverage_covid_free_proportion',
                 'mcv2_lagged_five_year_coverage_covid_free_proportion',
                 'polio3_lagged_five_year_coverage_covid_free_proportion',
                 'rcv1_lagged_five_year_coverage_covid_free_proportion',
                 'hib3_lagged_five_year_coverage_covid_free_proportion',
                 'pcv3_lagged_five_year_coverage_covid_free_proportion',
                 'rotac_lagged_five_year_coverage_covid_free_proportion',
                 'hepb3_lagged_five_year_coverage_covid_free_proportion',
                 'proportion_of_population_vulnerable_to_venomous_snakebites',
                 'mean_number_of_venomous_snake_species', 'tfr_u20_us_r_e', 'dengue_all_age_csmr',
                 'education_years_per_capita_aggregated_by_age_15_and_up_and_sex_us_r_e',
                 'age_and_sex_specific_sev_for_high_temperature', 'age_and_sex_specific_sev_for_low_temperature',
                 'age_standardized_sev_for_high_temperature', 'age_standardized_sev_for_low_temperature',
                 'inpatient_utilization_envelope', 'chronic_hepatitis_c_age_standardized',
                 'vaccine_adjusted_hbsag_serporevalence_age_standardized',
                 'hib3_transformed_population_level_coverage_including_indirect_effects_proportion',
                 'age_standardized_daily_smoking_prevalence_both_sexes', 'log_transformed_sev_scalar_oth_cirr',
                 'log_transformed_age_standardized_sev_scalar_oth_cirr', 'log_transformed_sev_scalar_burkitt',
                 'log_transformed_age_standardized_sev_scalar_burkitt', 'log_transformed_sev_scalar_oth_lymphoma',
                 'log_transformed_age_standardized_sev_scalar_oth_lymphoma',
                 'log_transformed_sev_scalar_osteoarth_hip',
                 'log_transformed_age_standardized_sev_scalar_osteoarth_hip',
                 'log_transformed_sev_scalar_osteoarth_knee',
                 'log_transformed_age_standardized_sev_scalar_osteoarth_knee', 'sheep_density',
                 'total_fertility_rate_under_25', 'caesarean_section', 'full_maternal_care',
                 'proportion_in_correctional_facility', 'proportion_in_correctional_facility_by_race_ethnicity',
                 'alcohol_availability_per_capita', 'alcohol_availability_per_capita_smoothed',
                 'alcohol_places_per_capita', 'alcohol_stores_per_capita', 'tobacco_stores_per_capita',
                 'tobacco_stores_per_capita_smoothed', 'proportion_with_ba_and_up',
                 'proportion_with_ba_and_up_by_race_ethnicity', 'proportion_with_hs_and_up',
                 'proportion_with_hs_and_up_by_race_ethnicity', 'proportion_foreign_born',
                 'proportion_foreign_born_by_education', 'proportion_foreign_born_by_race_ethnicity',
                 'proportion_hispanic', 'personal_income_per_capita', 'average_income_per_capita_by_race_ethnicity',
                 'mds_per_capita', 'mds_per_capita_state', 'median_household_income', 'median_property_value',
                 'log_of_population_density', 'population_density', 'proportion_in_college',
                 'proportion_in_poverty_by_education', 'proportion_in_poverty_by_race_ethnicity',
                 'proportion_land_in_reservations', 'proportion_land_in_federal_reservations',
                 'proportion_land_in_state_reservations', 'proportion_black', 'proportion_other_race',
                 'proportion_white', 'proportion_non_hispanic_aian', 'proportion_non_hispanic_api',
                 'proportion_non_hispanic_black', 'proportion_non_hispanic_white', 'proportion_rural',
                 'proportion_unemployed', 'proportion_unemployed_by_education',
                 'proportion_with_health_insurance_by_education', 'population_by_age_and_sex',
                 'population_by_education', 'population_by_race_ethnicity_1977_omb_standard',
                 'population_by_race_ethnicity_1997_omb_standard',
                 'bacille_calmette_guerin_bcg_vaccine_coverage_covid_inclusive_proportion',
                 'dtp3_coverage_covid_inclusive_proportion', 'measles_vaccine_coverage_covid_inclusive_proportion',
                 'measles_vaccine_coverage_2_doses_covid_inclusive_proportion',
                 'polio_3_dose_coverage_covid_inclusive_proportion',
                 'rubella_vaccine_coverage_covid_inclusive_proportion',
                 'hib3_vaccine_coverage_covid_inclusive_proportion', 'pcv3_coverage_covid_inclusive_proportion',
                 'rotavirus_coverage_covid_inclusive_proportion',
                 'hepatitis_b_3_dose_coverage_covid_inclusive_proportion',
                 'bcg_lagged_five_year_coverage_covid_inclusive_proportion',
                 'dtp3_lagged_five_year_coverage_covid_inclusive_proportion',
                 'mcv1_lagged_five_year_coverage_covid_inclusive_proportion',
                 'mcv2_lagged_five_year_coverage_covid_inclusive_proportion',
                 'rcv1_lagged_five_year_coverage_covid_inclusive_proportion',
                 'hib3_lagged_five_year_coverage_covid_inclusive_proportion',
                 'pcv3_lagged_five_year_coverage_covid_inclusive_proportion',
                 'rotac_lagged_five_year_coverage_covid_inclusive_proportion',
                 'hepb3_lagged_five_year_coverage_covid_inclusive_proportion',
                 'hepatitis_b_3_dose_coverage_proportion_lagged_5_years_covid_inclusive',
                 'hepatitis_b_3_dose_coverage_proportion_lagged_ten_years_covid_inclusive',
                 'hepatitis_b_vaccine_coverage_proportion_aged_through_time_covid_inclusive',
                 'polio3_lagged_five_year_coverage_covid_inclusive_proportion', 'sugar_sweetened_beverages_g_us_r_e',
                 'processed_meat_g_us_r_e', 'coverage_of_postnatal_care_visit', 'socio_demographic_index_us_r_e',
                 'college_enrollment_by_race_ethnicity', 'proportion_in_each_primary_race_multiracial',
                 'unemployment_rate_by_race_ethnicity', 'k_12_spending_per_student', 'dummy_covariate',
                 'proportion_of_owner_occupied_homes',
                 'proportion_of_owner_occupied_homes_by_race_ethnicity_of_householder', 'proportion_in_poverty',
                 'probability_of_homozygous_sickle_cell_disease_at_birth_ss',
                 'probability_of_hemoglobin_sc_disease_at_birth',
                 'probability_of_homozygous_sickle_cell_disease_ss_and_g6pd_deficiency_at_birth',
                 'probability_of_hemoglobin_sc_disease_sc_and_g6pd_deficiency_at_birth',
                 'probability_of_g6pd_deficiency_at_birth', 'population_by_marital_status',
                 'domestic_health_expenditure_per_capita', 'proportion_non_hispanic_aian_by_educational_attainment',
                 'proportion_non_hispanic_api_by_educational_attainment',
                 'proportion_non_hispanic_black_by_educational_attainment',
                 'proportion_non_hispanic_white_by_educational_attainment',
                 'proportion_hispanic_by_educational_attainment', 'age_specific_cohort_cumulative_fertility_ccf',
                 'mobility_during_covid_19_pandemic', 'mask_use', 'leprosy_prevalence_age_specific',
                 'stillbirth_20_weeks_to_live_birth_ratio', 'age_and_sex_specific_sev_for_no2_pollution',
                 'age_standardized_sev_for_no2_pollution', 'stillbirth_20_weeks', 'stillbirth_28_weeks',
                 'stillbirth_rate_20_weeks', 'stillbirth_rate_28_weeks',
                 'major_depressive_disorder_age_standardized',
                 'proportion_of_full_population_covered_by_menafrivac_initiative_meningitis_meningococcal_type_a_vaccine_risk_group_model',
                 'proportion_of_high_risk_population_covered_by_menafrivac_initiative_meningitis_meningococcal_type_a_vaccine_risk_group_model',
                 'log_transformed_sev_scalar_myocarditis', 'log_transformed_age_standardized_sev_scalar_myocarditis',
                 'log_transformed_age_standardized_sev_scalar_malaria',
                 'intermediate_age_specific_hiv_mortality_rate_demographics_team_only',
                 'log_transformed_sev_scalar_all_causes', 'log_transformed_age_standardized_sev_scalar_all_causes',
                 'log_transformed_sev_scalar_ntd_and_upmalaria',
                 'log_transformed_age_standardized_sev_scalar_ntd_and_upmalaria',
                 'log_transformed_sev_scalar_nutr_def', 'log_transformed_age_standardized_sev_scalar_nutr_def',
                 'log_transformed_sev_scalar_neoplasms', 'log_transformed_age_standardized_sev_scalar_neoplasms',
                 'log_transformed_sev_scalar_neuro', 'log_transformed_age_standardized_sev_scalar_neuro',
                 'log_transformed_sev_scalar_mental', 'log_transformed_age_standardized_sev_scalar_mental',
                 'log_transformed_sev_scalar_oth_ncd', 'log_transformed_age_standardized_sev_scalar_oth_ncd',
                 'log_transformed_sev_scalar_unint_inj', 'log_transformed_age_standardized_sev_scalar_unint_inj',
                 'log_transformed_sev_scalar_self_harm_and_ipv',
                 'log_transformed_age_standardized_sev_scalar_self_harm_and_ipv',
                 'log_transformed_sev_scalar_hiv_aids_and_upstis',
                 'log_transformed_age_standardized_sev_scalar_hiv_aids_and_upstis',
                 'log_transformed_sev_scalar_resp_and_uptb',
                 'log_transformed_age_standardized_sev_scalar_resp_and_uptb',
                 'log_transformed_sev_scalar_enteric_infect',
                 'log_transformed_age_standardized_sev_scalar_enteric_infect',
                 'log_transformed_sev_scalar_other_and_updiseases',
                 'log_transformed_age_standardized_sev_scalar_other_and_updiseases',
                 'log_transformed_sev_scalar_mat_and_upneonat',
                 'log_transformed_age_standardized_sev_scalar_mat_and_upneonat',
                 'log_transformed_sev_scalar_diabetes_and_upckd',
                 'log_transformed_age_standardized_sev_scalar_diabetes_and_upckd', 'who_sth_mda_coverage_by_age',
                 'normal_hemoglobin', 'covid_19_age_standardized_death_rate',
                 '_legality_of_abortion__and_up_fetal_impairment', 'hiv_art_coverage_from_unaids_reports',
                 'covid_19_crude_death_rate', 'covid_19_age_specific_death_rate',
                 'covid_19_reproductive_age_crude_death_rate', 'island_binary', 'all_risk_paf',
                 'antipsychotic_use_rates_in_schizophrenia', 'hiv_epidemic_start_year',
                 'latent_tuberculosis_infection_prevalence_age_sex_specific', 'population_by_latino_origin',
                 'population_by_race_ethnicity_and_fips_1977_omb_standard',
                 'population_by_race_ethnicity_and_fips_1997_omb_standard',
                 'varicella_years_since_introduction_of_universal_vaccination',
                 'varicella_post_vaccine_incidence_scalar', 'flu_positivity_rate', 'dengue_outbreaks_magnitude',
                 'log_transformed_sev_scalar_self_hang', 'log_transformed_age_standardized_sev_scalar_self_hang',
                 'log_transformed_sev_scalar_self_fire', 'log_transformed_age_standardized_sev_scalar_self_fire',
                 'log_transformed_sev_scalar_self_pest', 'log_transformed_age_standardized_sev_scalar_self_pest',
                 'log_transformed_sev_scalar_self_harm_by_non_pesticide_poisoning',
                 'log_transformed_age_standardized_sev_scalar_self_harm_by_non_pesticide_poisoning',
                 'log_transformed_age_standardized_sev_scalar_schiz',
                 'log_transformed_age_standardized_sev_scalar_bipolar',
                 'log_transformed_age_standardized_sev_scalar_eating',
                 'log_transformed_age_standardized_sev_scalar_bulimia',
                 'log_transformed_age_standardized_sev_scalar_conduct', 'proportion_white_alone',
                 'proportion_black_alone', 'proportion_aian_alone', 'proportion_api_alone', 'proportion_multiracial',
                 'rural_urban_continuum_code_2023', 'rural_urban_continuum_code_2013',
                 'rural_urban_continuum_code_2003', 'rural_urban_continuum_code_1993', )

    def __init__(self, **kwargs):
        super().__init__()
        self.legality_of_abortion = kwargs.get('legality_of_abortion')
        self.absolute_value_of_average_latitude = kwargs.get('absolute_value_of_average_latitude')
        self.antenatal_care_1_visit_coverage_proportion = kwargs.get('antenatal_care_1_visit_coverage_proportion')
        self.antenatal_care_4_visits_coverage_proportion = kwargs.get('antenatal_care_4_visits_coverage_proportion')
        self.age_specific_fertility_rate = kwargs.get('age_specific_fertility_rate')
        self.tobacco_cigarettes_per_capita = kwargs.get('tobacco_cigarettes_per_capita')
        self.coastal_population_within_10km_proportion = kwargs.get('coastal_population_within_10km_proportion')
        self.contraception_modern_prevalence_proportion_by_age = kwargs.get('contraception_modern_prevalence_proportion_by_age')
        self.contraception_modern_prevalence_proportion = kwargs.get('contraception_modern_prevalence_proportion')
        self.cumulative_cigarettes_10_years = kwargs.get('cumulative_cigarettes_10_years')
        self.cumulative_cigarettes_15_years = kwargs.get('cumulative_cigarettes_15_years')
        self.cumulative_cigarettes_20_years = kwargs.get('cumulative_cigarettes_20_years')
        self.cumulative_cigarettes_5_years = kwargs.get('cumulative_cigarettes_5_years')
        self.diabetes_fasting_plasma_glucose_mmol_l_age_standardized_25_and_up = kwargs.get('diabetes_fasting_plasma_glucose_mmol_l_age_standardized_25_and_up')
        self.diabetes_age_standardized_prevalence_proportion = kwargs.get('diabetes_age_standardized_prevalence_proportion')
        self.dtp3_coverage_covid_free_proportion = kwargs.get('dtp3_coverage_covid_free_proportion')
        self.education_years_per_capita = kwargs.get('education_years_per_capita')
        self.gold_production_binary = kwargs.get('gold_production_binary')
        self.proportion_of_households_using_iodized_salt_adjusted = kwargs.get('proportion_of_households_using_iodized_salt_adjusted')
        self.hib3_vaccine_coverage_covid_free_proportion = kwargs.get('hib3_vaccine_coverage_covid_free_proportion')
        self.hiv_prevalence_unadjusted_proportion = kwargs.get('hiv_prevalence_unadjusted_proportion')
        self.hospital_beds_per_1000 = kwargs.get('hospital_beds_per_1000')
        self.in_facility_delivery_proportion = kwargs.get('in_facility_delivery_proportion')
        self.landlocked_nation_binary = kwargs.get('landlocked_nation_binary')
        self.average_latitude = kwargs.get('average_latitude')
        self.ldi_income_per_capita = kwargs.get('ldi_income_per_capita')
        self.live_births_thousands = kwargs.get('live_births_thousands')
        self.mean_bmi = kwargs.get('mean_bmi')
        self.low_density_lipoprotein_mmol_l = kwargs.get('low_density_lipoprotein_mmol_l')
        self.systolic_blood_pressure_mmhg = kwargs.get('systolic_blood_pressure_mmhg')
        self.population_weighted_mean_temperature = kwargs.get('population_weighted_mean_temperature')
        self.measles_vaccine_coverage_covid_free_proportion = kwargs.get('measles_vaccine_coverage_covid_free_proportion')
        self.mortality_rate_due_to_death_shocks_in_last_10_years_per_1_person = kwargs.get('mortality_rate_due_to_death_shocks_in_last_10_years_per_1_person')
        self.live_births_35_and_up_proportion = kwargs.get('live_births_35_and_up_proportion')
        self.live_births_40_and_up_proportion = kwargs.get('live_births_40_and_up_proportion')
        self.pigs_per_capita = kwargs.get('pigs_per_capita')
        self.indoor_air_pollution_all_cooking_fuels = kwargs.get('indoor_air_pollution_all_cooking_fuels')
        self.outdoor_air_pollution_pm_2_5 = kwargs.get('outdoor_air_pollution_pm_2_5')
        self.latitude_under_15_proportion = kwargs.get('latitude_under_15_proportion')
        self.elevation_over_1500m_proportion = kwargs.get('elevation_over_1500m_proportion')
        self.population_15_to_30_proportion = kwargs.get('population_15_to_30_proportion')
        self.latitude_15_to_30_proportion = kwargs.get('latitude_15_to_30_proportion')
        self.latitude_30_to_45_proportion = kwargs.get('latitude_30_to_45_proportion')
        self.latitude_over_45_proportion = kwargs.get('latitude_over_45_proportion')
        self.elevation_500_to_1500m_proportion = kwargs.get('elevation_500_to_1500m_proportion')
        self.population_density_150_300_ppl_sqkm_proportion = kwargs.get('population_density_150_300_ppl_sqkm_proportion')
        self.population_density_300_500_ppl_sqkm_proportion = kwargs.get('population_density_300_500_ppl_sqkm_proportion')
        self.population_density_500_1000_ppl_sqkm_proportion = kwargs.get('population_density_500_1000_ppl_sqkm_proportion')
        self.population_density_over_1000_ppl_sqkm_proportion = kwargs.get('population_density_over_1000_ppl_sqkm_proportion')
        self.population_density_under_150_ppl_sqkm_proportion = kwargs.get('population_density_under_150_ppl_sqkm_proportion')
        self.population_over_65_proportion = kwargs.get('population_over_65_proportion')
        self.elevation_under_100m_proportion = kwargs.get('elevation_under_100m_proportion')
        self.rainfall_population_weighted_mm_yr = kwargs.get('rainfall_population_weighted_mm_yr')
        self.rainfall_quintiles_4_5 = kwargs.get('rainfall_quintiles_4_5')
        self.rainfall_quintile_1_proportion = kwargs.get('rainfall_quintile_1_proportion')
        self.rainfall_quintile_2_proportion = kwargs.get('rainfall_quintile_2_proportion')
        self.rainfall_quintile_5_proportion = kwargs.get('rainfall_quintile_5_proportion')
        self.religion_binary_greater_than_50_percent_muslim = kwargs.get('religion_binary_greater_than_50_percent_muslim')
        self.sahel_region_of_africa_binary = kwargs.get('sahel_region_of_africa_binary')
        self.sanitation_proportion_with_access = kwargs.get('sanitation_proportion_with_access')
        self.skilled_birth_attendance_proportion = kwargs.get('skilled_birth_attendance_proportion')
        self.smoking_prevalence = kwargs.get('smoking_prevalence')
        self.smoking_prevalence_reproductive_age_standardized = kwargs.get('smoking_prevalence_reproductive_age_standardized')
        self.ninetieth_percentile_climatic_temperature_in_the_given_country_year = kwargs.get('ninetieth_percentile_climatic_temperature_in_the_given_country_year')
        self.tetanus_toxoid_maternal_protection_at_birth = kwargs.get('tetanus_toxoid_maternal_protection_at_birth')
        self.total_fertility_rate = kwargs.get('total_fertility_rate')
        self.vehicles_2_and_up4_wheels_per_capita = kwargs.get('vehicles_2_and_up4_wheels_per_capita')
        self.vehicles_2_wheels_per_capita = kwargs.get('vehicles_2_wheels_per_capita')
        self.vehicles_4_wheels_per_capita = kwargs.get('vehicles_4_wheels_per_capita')
        self.vehicles_2_wheels_fraction_proportion = kwargs.get('vehicles_2_wheels_fraction_proportion')
        self.mortality_rate_due_to_war_shocks_per_1_person = kwargs.get('mortality_rate_due_to_war_shocks_per_1_person')
        self.improved_water_source_proportion_with_access = kwargs.get('improved_water_source_proportion_with_access')
        self.malaria_lysenko_pfpr_1_holoendemic = kwargs.get('malaria_lysenko_pfpr_1_holoendemic')
        self.malaria_pfpr_rate = kwargs.get('malaria_pfpr_rate')
        self.significant_leishmaniasis_endemicity_binary = kwargs.get('significant_leishmaniasis_endemicity_binary')
        self.year = kwargs.get('year')
        self.birth_prevalence_of_chd = kwargs.get('birth_prevalence_of_chd')
        self.birth_prevalence_of_congenital_chromosomal_anomalies = kwargs.get('birth_prevalence_of_congenital_chromosomal_anomalies')
        self.hemoglobinopathies_prevalence_x_excess_mortality = kwargs.get('hemoglobinopathies_prevalence_x_excess_mortality')
        self.age_standardize_prevalence_of_severe_anemia = kwargs.get('age_standardize_prevalence_of_severe_anemia')
        self.maternal_care_and_immunization = kwargs.get('maternal_care_and_immunization')
        self.neonatal_mortality_rate_per_1000 = kwargs.get('neonatal_mortality_rate_per_1000')
        self.pcv3_coverage_covid_free_proportion = kwargs.get('pcv3_coverage_covid_free_proportion')
        self.presence_of_leishmaniasis_binary = kwargs.get('presence_of_leishmaniasis_binary')
        self.under_5_hiv_death_rate = kwargs.get('under_5_hiv_death_rate')
        self.syphilis_prevalence_proportion = kwargs.get('syphilis_prevalence_proportion')
        self.population_weighted_probability_of_dengue_transmission = kwargs.get('population_weighted_probability_of_dengue_transmission')
        self.dengue_outbreaks_binary = kwargs.get('dengue_outbreaks_binary')
        self.proportion_of_the_population_living_in_the_classic_monsoon_region = kwargs.get('proportion_of_the_population_living_in_the_classic_monsoon_region')
        self.proportion_of_the_population_living_in_the_classic_monsoon_region_low_income_countries = kwargs.get('proportion_of_the_population_living_in_the_classic_monsoon_region_low_income_countries')
        self.hemoglobinopathies_prevalence_x_excess_mortality_excluding_g6pd_deficiency = kwargs.get('hemoglobinopathies_prevalence_x_excess_mortality_excluding_g6pd_deficiency')
        self.alcohol_binge_drinker_proportion_age_standardized = kwargs.get('alcohol_binge_drinker_proportion_age_standardized')
        self.smoking_prevalence_age_standardized_both_sexes = kwargs.get('smoking_prevalence_age_standardized_both_sexes')
        self.proportion_of_the_population_living_in_the_indian_ocean_monsoon_belt = kwargs.get('proportion_of_the_population_living_in_the_indian_ocean_monsoon_belt')
        self.vitamin_a_deficiency_prevalence_age_standardized = kwargs.get('vitamin_a_deficiency_prevalence_age_standardized')
        self.prevalence_of_obesity = kwargs.get('prevalence_of_obesity')
        self.prevalence_of_overweight_and_obesity = kwargs.get('prevalence_of_overweight_and_obesity')
        self.prevalence_of_obesity_age_standardized = kwargs.get('prevalence_of_obesity_age_standardized')
        self.maternal_education_years_per_capita = kwargs.get('maternal_education_years_per_capita')
        self.chagasprevpaho = kwargs.get('chagasprevpaho')
        self.enhanced_vegetation_index_long_term_average_2000_2012_mean = kwargs.get('enhanced_vegetation_index_long_term_average_2000_2012_mean')
        self.log_transformed_sev_scalar_tb = kwargs.get('log_transformed_sev_scalar_tb')
        self.log_transformed_sev_scalar_oth_hiv = kwargs.get('log_transformed_sev_scalar_oth_hiv')
        self.log_transformed_sev_scalar_diarrhea = kwargs.get('log_transformed_sev_scalar_diarrhea')
        self.log_transformed_sev_scalar_lri = kwargs.get('log_transformed_sev_scalar_lri')
        self.log_transformed_sev_scalar_uri = kwargs.get('log_transformed_sev_scalar_uri')
        self.log_transformed_sev_scalar_otitis = kwargs.get('log_transformed_sev_scalar_otitis')
        self.log_transformed_sev_scalar_meningitis = kwargs.get('log_transformed_sev_scalar_meningitis')
        self.log_transformed_sev_scalar_measles = kwargs.get('log_transformed_sev_scalar_measles')
        self.log_transformed_sev_scalar_malaria = kwargs.get('log_transformed_sev_scalar_malaria')
        self.log_transformed_sev_scalar_mat_hem = kwargs.get('log_transformed_sev_scalar_mat_hem')
        self.log_transformed_sev_scalar_mat_sepsis = kwargs.get('log_transformed_sev_scalar_mat_sepsis')
        self.log_transformed_sev_scalar_mat_htn = kwargs.get('log_transformed_sev_scalar_mat_htn')
        self.log_transformed_sev_scalar_mat_indir = kwargs.get('log_transformed_sev_scalar_mat_indir')
        self.log_transformed_sev_scalar_mat_late = kwargs.get('log_transformed_sev_scalar_mat_late')
        self.log_transformed_sev_scalar_oth_mat = kwargs.get('log_transformed_sev_scalar_oth_mat')
        self.log_transformed_sev_scalar_hep = kwargs.get('log_transformed_sev_scalar_hep')
        self.log_transformed_sev_scalar_hep_b = kwargs.get('log_transformed_sev_scalar_hep_b')
        self.log_transformed_sev_scalar_hep_c = kwargs.get('log_transformed_sev_scalar_hep_c')
        self.log_transformed_sev_scalar_esophag_c = kwargs.get('log_transformed_sev_scalar_esophag_c')
        self.log_transformed_sev_scalar_stomach_c = kwargs.get('log_transformed_sev_scalar_stomach_c')
        self.log_transformed_sev_scalar_liver_c = kwargs.get('log_transformed_sev_scalar_liver_c')
        self.log_transformed_sev_scalar_liver_c_hepb = kwargs.get('log_transformed_sev_scalar_liver_c_hepb')
        self.log_transformed_sev_scalar_liver_c_hepc = kwargs.get('log_transformed_sev_scalar_liver_c_hepc')
        self.log_transformed_sev_scalar_oth_liver_c = kwargs.get('log_transformed_sev_scalar_oth_liver_c')
        self.log_transformed_sev_scalar_larynx_c = kwargs.get('log_transformed_sev_scalar_larynx_c')
        self.log_transformed_sev_scalar_lung_c = kwargs.get('log_transformed_sev_scalar_lung_c')
        self.log_transformed_sev_scalar_breast_c = kwargs.get('log_transformed_sev_scalar_breast_c')
        self.log_transformed_sev_scalar_uterus_c = kwargs.get('log_transformed_sev_scalar_uterus_c')
        self.log_transformed_sev_scalar_prostate_c = kwargs.get('log_transformed_sev_scalar_prostate_c')
        self.log_transformed_sev_scalar_colorect_c = kwargs.get('log_transformed_sev_scalar_colorect_c')
        self.log_transformed_sev_scalar_lip_oral_c = kwargs.get('log_transformed_sev_scalar_lip_oral_c')
        self.log_transformed_sev_scalar_nasoph_c = kwargs.get('log_transformed_sev_scalar_nasoph_c')
        self.log_transformed_sev_scalar_oth_phar_c = kwargs.get('log_transformed_sev_scalar_oth_phar_c')
        self.log_transformed_sev_scalar_gallblad_c = kwargs.get('log_transformed_sev_scalar_gallblad_c')
        self.log_transformed_sev_scalar_pancreas_c = kwargs.get('log_transformed_sev_scalar_pancreas_c')
        self.log_transformed_sev_scalar_ovary_c = kwargs.get('log_transformed_sev_scalar_ovary_c')
        self.log_transformed_sev_scalar_kidney_c = kwargs.get('log_transformed_sev_scalar_kidney_c')
        self.log_transformed_sev_scalar_bladder_c = kwargs.get('log_transformed_sev_scalar_bladder_c')
        self.log_transformed_sev_scalar_thyroid_c = kwargs.get('log_transformed_sev_scalar_thyroid_c')
        self.log_transformed_sev_scalar_mesothel = kwargs.get('log_transformed_sev_scalar_mesothel')
        self.log_transformed_sev_scalar_leukemia = kwargs.get('log_transformed_sev_scalar_leukemia')
        self.log_transformed_sev_scalar_ihd = kwargs.get('log_transformed_sev_scalar_ihd')
        self.log_transformed_sev_scalar_stroke = kwargs.get('log_transformed_sev_scalar_stroke')
        self.log_transformed_sev_scalar_isch_stroke = kwargs.get('log_transformed_sev_scalar_isch_stroke')
        self.log_transformed_sev_scalar_intrahem_stroke = kwargs.get('log_transformed_sev_scalar_intrahem_stroke')
        self.log_transformed_sev_scalar_cmp = kwargs.get('log_transformed_sev_scalar_cmp')
        self.log_transformed_sev_scalar_a_fib = kwargs.get('log_transformed_sev_scalar_a_fib')
        self.log_transformed_sev_scalar_aort_an = kwargs.get('log_transformed_sev_scalar_aort_an')
        self.log_transformed_sev_scalar_pad = kwargs.get('log_transformed_sev_scalar_pad')
        self.log_transformed_sev_scalar_copd = kwargs.get('log_transformed_sev_scalar_copd')
        self.log_transformed_sev_scalar_asthma = kwargs.get('log_transformed_sev_scalar_asthma')
        self.log_transformed_sev_scalar_cirr_hepb = kwargs.get('log_transformed_sev_scalar_cirr_hepb')
        self.log_transformed_sev_scalar_cirr_hepc = kwargs.get('log_transformed_sev_scalar_cirr_hepc')
        self.log_transformed_sev_scalar_pancreatit = kwargs.get('log_transformed_sev_scalar_pancreatit')
        self.log_transformed_sev_scalar_idiopathic_epilepsy = kwargs.get('log_transformed_sev_scalar_idiopathic_epilepsy')
        self.log_transformed_sev_scalar_schizo = kwargs.get('log_transformed_sev_scalar_schizo')
        self.log_transformed_sev_scalar_depression = kwargs.get('log_transformed_sev_scalar_depression')
        self.log_transformed_sev_scalar_mdd = kwargs.get('log_transformed_sev_scalar_mdd')
        self.log_transformed_sev_scalar_bipolar = kwargs.get('log_transformed_sev_scalar_bipolar')
        self.log_transformed_sev_scalar_anxiety = kwargs.get('log_transformed_sev_scalar_anxiety')
        self.log_transformed_sev_scalar_eating = kwargs.get('log_transformed_sev_scalar_eating')
        self.log_transformed_sev_scalar_bulimia = kwargs.get('log_transformed_sev_scalar_bulimia')
        self.log_transformed_sev_scalar_conduct = kwargs.get('log_transformed_sev_scalar_conduct')
        self.log_transformed_sev_scalar_id = kwargs.get('log_transformed_sev_scalar_id')
        self.log_transformed_sev_scalar_osteoarth = kwargs.get('log_transformed_sev_scalar_osteoarth')
        self.log_transformed_sev_scalar_back_pain = kwargs.get('log_transformed_sev_scalar_back_pain')
        self.log_transformed_sev_scalar_gout = kwargs.get('log_transformed_sev_scalar_gout')
        self.log_transformed_sev_scalar_sense = kwargs.get('log_transformed_sev_scalar_sense')
        self.log_transformed_sev_scalar_cataract = kwargs.get('log_transformed_sev_scalar_cataract')
        self.log_transformed_sev_scalar_hearing = kwargs.get('log_transformed_sev_scalar_hearing')
        self.log_transformed_sev_scalar_sids = kwargs.get('log_transformed_sev_scalar_sids')
        self.log_transformed_sev_scalar_road_inj = kwargs.get('log_transformed_sev_scalar_road_inj')
        self.log_transformed_sev_scalar_pedest = kwargs.get('log_transformed_sev_scalar_pedest')
        self.log_transformed_sev_scalar_cyclist = kwargs.get('log_transformed_sev_scalar_cyclist')
        self.log_transformed_sev_scalar_mot_cyc = kwargs.get('log_transformed_sev_scalar_mot_cyc')
        self.log_transformed_sev_scalar_mot_veh = kwargs.get('log_transformed_sev_scalar_mot_veh')
        self.log_transformed_sev_scalar_oth_road = kwargs.get('log_transformed_sev_scalar_oth_road')
        self.log_transformed_sev_scalar_oth_trans = kwargs.get('log_transformed_sev_scalar_oth_trans')
        self.log_transformed_sev_scalar_falls = kwargs.get('log_transformed_sev_scalar_falls')
        self.log_transformed_sev_scalar_drown = kwargs.get('log_transformed_sev_scalar_drown')
        self.log_transformed_sev_scalar_fire = kwargs.get('log_transformed_sev_scalar_fire')
        self.log_transformed_sev_scalar_poison = kwargs.get('log_transformed_sev_scalar_poison')
        self.log_transformed_sev_scalar_mech = kwargs.get('log_transformed_sev_scalar_mech')
        self.log_transformed_sev_scalar_mech_gun = kwargs.get('log_transformed_sev_scalar_mech_gun')
        self.log_transformed_sev_scalar_oth_mech = kwargs.get('log_transformed_sev_scalar_oth_mech')
        self.log_transformed_sev_scalar_animal = kwargs.get('log_transformed_sev_scalar_animal')
        self.log_transformed_sev_scalar_venom = kwargs.get('log_transformed_sev_scalar_venom')
        self.log_transformed_sev_scalar_non_ven = kwargs.get('log_transformed_sev_scalar_non_ven')
        self.log_transformed_sev_scalar_f_body = kwargs.get('log_transformed_sev_scalar_f_body')
        self.log_transformed_sev_scalar_f_body_asp = kwargs.get('log_transformed_sev_scalar_f_body_asp')
        self.log_transformed_sev_scalar_oth_f_body = kwargs.get('log_transformed_sev_scalar_oth_f_body')
        self.log_transformed_sev_scalar_oth_unint = kwargs.get('log_transformed_sev_scalar_oth_unint')
        self.log_transformed_sev_scalar_self_harm = kwargs.get('log_transformed_sev_scalar_self_harm')
        self.log_transformed_sev_scalar_violence = kwargs.get('log_transformed_sev_scalar_violence')
        self.log_transformed_sev_scalar_viol_gun = kwargs.get('log_transformed_sev_scalar_viol_gun')
        self.log_transformed_sev_scalar_viol_knife = kwargs.get('log_transformed_sev_scalar_viol_knife')
        self.log_transformed_sev_scalar_oth_viol = kwargs.get('log_transformed_sev_scalar_oth_viol')
        self.log_transformed_sev_scalar_disaster = kwargs.get('log_transformed_sev_scalar_disaster')
        self.log_transformed_sev_scalar_mat_hiv = kwargs.get('log_transformed_sev_scalar_mat_hiv')
        self.log_transformed_age_standardized_sev_scalar_tb = kwargs.get('log_transformed_age_standardized_sev_scalar_tb')
        self.log_transformed_age_standardized_sev_scalar_oth_hiv = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_hiv')
        self.log_transformed_age_standardized_sev_scalar_diarrhea = kwargs.get('log_transformed_age_standardized_sev_scalar_diarrhea')
        self.log_transformed_age_standardized_sev_scalar_lri = kwargs.get('log_transformed_age_standardized_sev_scalar_lri')
        self.log_transformed_age_standardized_sev_scalar_uri = kwargs.get('log_transformed_age_standardized_sev_scalar_uri')
        self.log_transformed_age_standardized_sev_scalar_otitis = kwargs.get('log_transformed_age_standardized_sev_scalar_otitis')
        self.log_transformed_age_standardized_sev_scalar_measles = kwargs.get('log_transformed_age_standardized_sev_scalar_measles')
        self.log_transformed_age_standardized_sev_scalar_mat_hem = kwargs.get('log_transformed_age_standardized_sev_scalar_mat_hem')
        self.log_transformed_age_standardized_sev_scalar_mat_sepsis = kwargs.get('log_transformed_age_standardized_sev_scalar_mat_sepsis')
        self.log_transformed_age_standardized_sev_scalar_hep = kwargs.get('log_transformed_age_standardized_sev_scalar_hep')
        self.log_transformed_age_standardized_sev_scalar_hep_b = kwargs.get('log_transformed_age_standardized_sev_scalar_hep_b')
        self.log_transformed_age_standardized_sev_scalar_hep_c = kwargs.get('log_transformed_age_standardized_sev_scalar_hep_c')
        self.log_transformed_age_standardized_sev_scalar_esophag_c = kwargs.get('log_transformed_age_standardized_sev_scalar_esophag_c')
        self.log_transformed_age_standardized_sev_scalar_stomach_c = kwargs.get('log_transformed_age_standardized_sev_scalar_stomach_c')
        self.log_transformed_age_standardized_sev_scalar_liver_c = kwargs.get('log_transformed_age_standardized_sev_scalar_liver_c')
        self.log_transformed_age_standardized_sev_scalar_liver_c_hepb = kwargs.get('log_transformed_age_standardized_sev_scalar_liver_c_hepb')
        self.log_transformed_age_standardized_sev_scalar_liver_c_hepc = kwargs.get('log_transformed_age_standardized_sev_scalar_liver_c_hepc')
        self.log_transformed_age_standardized_sev_scalar_oth_liver_c = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_liver_c')
        self.log_transformed_age_standardized_sev_scalar_larynx_c = kwargs.get('log_transformed_age_standardized_sev_scalar_larynx_c')
        self.log_transformed_age_standardized_sev_scalar_lung_c = kwargs.get('log_transformed_age_standardized_sev_scalar_lung_c')
        self.log_transformed_age_standardized_sev_scalar_breast_c = kwargs.get('log_transformed_age_standardized_sev_scalar_breast_c')
        self.log_transformed_age_standardized_sev_scalar_uterus_c = kwargs.get('log_transformed_age_standardized_sev_scalar_uterus_c')
        self.log_transformed_age_standardized_sev_scalar_prostate_c = kwargs.get('log_transformed_age_standardized_sev_scalar_prostate_c')
        self.log_transformed_age_standardized_sev_scalar_colorect_c = kwargs.get('log_transformed_age_standardized_sev_scalar_colorect_c')
        self.log_transformed_age_standardized_sev_scalar_lip_oral_c = kwargs.get('log_transformed_age_standardized_sev_scalar_lip_oral_c')
        self.log_transformed_age_standardized_sev_scalar_nasoph_c = kwargs.get('log_transformed_age_standardized_sev_scalar_nasoph_c')
        self.log_transformed_age_standardized_sev_scalar_oth_phar_c = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_phar_c')
        self.log_transformed_age_standardized_sev_scalar_gallblad_c = kwargs.get('log_transformed_age_standardized_sev_scalar_gallblad_c')
        self.log_transformed_age_standardized_sev_scalar_pancreas_c = kwargs.get('log_transformed_age_standardized_sev_scalar_pancreas_c')
        self.log_transformed_age_standardized_sev_scalar_ovary_c = kwargs.get('log_transformed_age_standardized_sev_scalar_ovary_c')
        self.log_transformed_age_standardized_sev_scalar_kidney_c = kwargs.get('log_transformed_age_standardized_sev_scalar_kidney_c')
        self.log_transformed_age_standardized_sev_scalar_bladder_c = kwargs.get('log_transformed_age_standardized_sev_scalar_bladder_c')
        self.log_transformed_age_standardized_sev_scalar_thyroid_c = kwargs.get('log_transformed_age_standardized_sev_scalar_thyroid_c')
        self.log_transformed_age_standardized_sev_scalar_mesothel = kwargs.get('log_transformed_age_standardized_sev_scalar_mesothel')
        self.log_transformed_age_standardized_sev_scalar_leukemia = kwargs.get('log_transformed_age_standardized_sev_scalar_leukemia')
        self.log_transformed_age_standardized_sev_scalar_ihd = kwargs.get('log_transformed_age_standardized_sev_scalar_ihd')
        self.log_transformed_age_standardized_sev_scalar_stroke = kwargs.get('log_transformed_age_standardized_sev_scalar_stroke')
        self.log_transformed_age_standardized_sev_scalar_isch_stroke = kwargs.get('log_transformed_age_standardized_sev_scalar_isch_stroke')
        self.log_transformed_age_standardized_sev_scalar_intrahem_stroke = kwargs.get('log_transformed_age_standardized_sev_scalar_intrahem_stroke')
        self.log_transformed_age_standardized_sev_scalar_cmp = kwargs.get('log_transformed_age_standardized_sev_scalar_cmp')
        self.log_transformed_age_standardized_sev_scalar_a_fib = kwargs.get('log_transformed_age_standardized_sev_scalar_a_fib')
        self.log_transformed_age_standardized_sev_scalar_aort_an = kwargs.get('log_transformed_age_standardized_sev_scalar_aort_an')
        self.log_transformed_age_standardized_sev_scalar_pad = kwargs.get('log_transformed_age_standardized_sev_scalar_pad')
        self.log_transformed_age_standardized_sev_scalar_copd = kwargs.get('log_transformed_age_standardized_sev_scalar_copd')
        self.log_transformed_age_standardized_sev_scalar_asthma = kwargs.get('log_transformed_age_standardized_sev_scalar_asthma')
        self.log_transformed_age_standardized_sev_scalar_cirr_hepb = kwargs.get('log_transformed_age_standardized_sev_scalar_cirr_hepb')
        self.log_transformed_age_standardized_sev_scalar_cirr_hepc = kwargs.get('log_transformed_age_standardized_sev_scalar_cirr_hepc')
        self.log_transformed_age_standardized_sev_scalar_pancreatit = kwargs.get('log_transformed_age_standardized_sev_scalar_pancreatit')
        self.log_transformed_age_standardized_sev_scalar_idiopathic_epilepsy = kwargs.get('log_transformed_age_standardized_sev_scalar_idiopathic_epilepsy')
        self.log_transformed_age_standardized_sev_scalar_depression = kwargs.get('log_transformed_age_standardized_sev_scalar_depression')
        self.log_transformed_age_standardized_sev_scalar_mdd = kwargs.get('log_transformed_age_standardized_sev_scalar_mdd')
        self.log_transformed_age_standardized_sev_scalar_id = kwargs.get('log_transformed_age_standardized_sev_scalar_id')
        self.log_transformed_age_standardized_sev_scalar_osteoarth = kwargs.get('log_transformed_age_standardized_sev_scalar_osteoarth')
        self.log_transformed_age_standardized_sev_scalar_back_pain = kwargs.get('log_transformed_age_standardized_sev_scalar_back_pain')
        self.log_transformed_age_standardized_sev_scalar_gout = kwargs.get('log_transformed_age_standardized_sev_scalar_gout')
        self.log_transformed_age_standardized_sev_scalar_sense = kwargs.get('log_transformed_age_standardized_sev_scalar_sense')
        self.log_transformed_age_standardized_sev_scalar_cataract = kwargs.get('log_transformed_age_standardized_sev_scalar_cataract')
        self.log_transformed_age_standardized_sev_scalar_hearing = kwargs.get('log_transformed_age_standardized_sev_scalar_hearing')
        self.log_transformed_age_standardized_sev_scalar_road_inj = kwargs.get('log_transformed_age_standardized_sev_scalar_road_inj')
        self.log_transformed_age_standardized_sev_scalar_pedest = kwargs.get('log_transformed_age_standardized_sev_scalar_pedest')
        self.log_transformed_age_standardized_sev_scalar_cyclist = kwargs.get('log_transformed_age_standardized_sev_scalar_cyclist')
        self.log_transformed_age_standardized_sev_scalar_mot_cyc = kwargs.get('log_transformed_age_standardized_sev_scalar_mot_cyc')
        self.log_transformed_age_standardized_sev_scalar_mot_veh = kwargs.get('log_transformed_age_standardized_sev_scalar_mot_veh')
        self.log_transformed_age_standardized_sev_scalar_oth_road = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_road')
        self.log_transformed_age_standardized_sev_scalar_oth_trans = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_trans')
        self.log_transformed_age_standardized_sev_scalar_falls = kwargs.get('log_transformed_age_standardized_sev_scalar_falls')
        self.log_transformed_age_standardized_sev_scalar_drown = kwargs.get('log_transformed_age_standardized_sev_scalar_drown')
        self.log_transformed_age_standardized_sev_scalar_fire = kwargs.get('log_transformed_age_standardized_sev_scalar_fire')
        self.log_transformed_age_standardized_sev_scalar_poison = kwargs.get('log_transformed_age_standardized_sev_scalar_poison')
        self.log_transformed_age_standardized_sev_scalar_mech = kwargs.get('log_transformed_age_standardized_sev_scalar_mech')
        self.log_transformed_age_standardized_sev_scalar_mech_gun = kwargs.get('log_transformed_age_standardized_sev_scalar_mech_gun')
        self.log_transformed_age_standardized_sev_scalar_oth_mech = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_mech')
        self.log_transformed_age_standardized_sev_scalar_animal = kwargs.get('log_transformed_age_standardized_sev_scalar_animal')
        self.log_transformed_age_standardized_sev_scalar_venom = kwargs.get('log_transformed_age_standardized_sev_scalar_venom')
        self.log_transformed_age_standardized_sev_scalar_non_ven = kwargs.get('log_transformed_age_standardized_sev_scalar_non_ven')
        self.log_transformed_age_standardized_sev_scalar_f_body = kwargs.get('log_transformed_age_standardized_sev_scalar_f_body')
        self.log_transformed_age_standardized_sev_scalar_f_body_asp = kwargs.get('log_transformed_age_standardized_sev_scalar_f_body_asp')
        self.log_transformed_age_standardized_sev_scalar_oth_f_body = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_f_body')
        self.log_transformed_age_standardized_sev_scalar_oth_unint = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_unint')
        self.log_transformed_age_standardized_sev_scalar_self_harm = kwargs.get('log_transformed_age_standardized_sev_scalar_self_harm')
        self.log_transformed_age_standardized_sev_scalar_violence = kwargs.get('log_transformed_age_standardized_sev_scalar_violence')
        self.log_transformed_age_standardized_sev_scalar_viol_gun = kwargs.get('log_transformed_age_standardized_sev_scalar_viol_gun')
        self.log_transformed_age_standardized_sev_scalar_viol_knife = kwargs.get('log_transformed_age_standardized_sev_scalar_viol_knife')
        self.log_transformed_age_standardized_sev_scalar_oth_viol = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_viol')
        self.education_age_standardized = kwargs.get('education_age_standardized')
        self.meningitis_belt_proportion = kwargs.get('meningitis_belt_proportion')
        self.gdp_per_capita_base_2010 = kwargs.get('gdp_per_capita_base_2010')
        self.urbanicity_binary = kwargs.get('urbanicity_binary')
        self.age_and_sex_specific_sev_for_unsafe_water = kwargs.get('age_and_sex_specific_sev_for_unsafe_water')
        self.age_and_sex_specific_sev_for_unsafe_sanitation = kwargs.get('age_and_sex_specific_sev_for_unsafe_sanitation')
        self.dengue_reporting_trends_transformed_into_relative_risks_relative_to_that_countrys_mean_incidence = kwargs.get('dengue_reporting_trends_transformed_into_relative_risks_relative_to_that_countrys_mean_incidence')
        self.echinococcosis_endemicity = kwargs.get('echinococcosis_endemicity')
        self.socio_demographic_index = kwargs.get('socio_demographic_index')
        self.japanese_encelphalitis_endemic_area_binary = kwargs.get('japanese_encelphalitis_endemic_area_binary')
        self.calcium_unadjusted_g = kwargs.get('calcium_unadjusted_g')
        self.fiber_unadjusted_g = kwargs.get('fiber_unadjusted_g')
        self.fruits_unadjusted_g = kwargs.get('fruits_unadjusted_g')
        self.milk_unadjusted_g = kwargs.get('milk_unadjusted_g')
        self.nuts_seeds_unadjusted_g = kwargs.get('nuts_seeds_unadjusted_g')
        self.pufa_adjusted_percent = kwargs.get('pufa_adjusted_percent')
        self.pulses_legumes_unadjusted_g = kwargs.get('pulses_legumes_unadjusted_g')
        self.red_meats_unadjusted_g = kwargs.get('red_meats_unadjusted_g')
        self.sugar_unadjusted_g = kwargs.get('sugar_unadjusted_g')
        self.vegetables_unadjusted_g = kwargs.get('vegetables_unadjusted_g')
        self.energy_unadjusted_kcal = kwargs.get('energy_unadjusted_kcal')
        self.hiv_mortality_females_10_54 = kwargs.get('hiv_mortality_females_10_54')
        self.hiv_age_standardized_prevalence = kwargs.get('hiv_age_standardized_prevalence')
        self.log_transformed_age_standardized_sev_scalar_maternal = kwargs.get('log_transformed_age_standardized_sev_scalar_maternal')
        self.log_transformed_age_standardized_sev_scalar_cvd = kwargs.get('log_transformed_age_standardized_sev_scalar_cvd')
        self.log_transformed_age_standardized_sev_scalar_chr_resp = kwargs.get('log_transformed_age_standardized_sev_scalar_chr_resp')
        self.log_transformed_age_standardized_sev_scalar_cirrhosis = kwargs.get('log_transformed_age_standardized_sev_scalar_cirrhosis')
        self.log_transformed_age_standardized_sev_scalar_digestive = kwargs.get('log_transformed_age_standardized_sev_scalar_digestive')
        self.log_transformed_age_standardized_sev_scalar_msk = kwargs.get('log_transformed_age_standardized_sev_scalar_msk')
        self.log_transformed_age_standardized_sev_scalar_trans_inj = kwargs.get('log_transformed_age_standardized_sev_scalar_trans_inj')
        self.log_transformed_sev_scalar_maternal = kwargs.get('log_transformed_sev_scalar_maternal')
        self.log_transformed_sev_scalar_cvd = kwargs.get('log_transformed_sev_scalar_cvd')
        self.log_transformed_sev_scalar_chr_resp = kwargs.get('log_transformed_sev_scalar_chr_resp')
        self.log_transformed_sev_scalar_cirrhosis = kwargs.get('log_transformed_sev_scalar_cirrhosis')
        self.log_transformed_sev_scalar_digestive = kwargs.get('log_transformed_sev_scalar_digestive')
        self.log_transformed_sev_scalar_msk = kwargs.get('log_transformed_sev_scalar_msk')
        self.log_transformed_sev_scalar_trans_inj = kwargs.get('log_transformed_sev_scalar_trans_inj')
        self.vitamin_a_unadjusted_iu = kwargs.get('vitamin_a_unadjusted_iu')
        self.vitamin_a_rae_unadjusted_ug = kwargs.get('vitamin_a_rae_unadjusted_ug')
        self.dietary_zinc_unadjusted_mg = kwargs.get('dietary_zinc_unadjusted_mg')
        self.proportion_of_total_population_covered_by_menafrivac_initiative_meningitis_meningococcal_type_a_vaccine = kwargs.get('proportion_of_total_population_covered_by_menafrivac_initiative_meningitis_meningococcal_type_a_vaccine')
        self.malaria_incidence_adjusted_for_antimalarial_coverage_and_drug_effectiveness = kwargs.get('malaria_incidence_adjusted_for_antimalarial_coverage_and_drug_effectiveness')
        self.rotavirus_coverage_covid_free_proportion = kwargs.get('rotavirus_coverage_covid_free_proportion')
        self.proportion_of_cirrhosis_due_to_alcohol = kwargs.get('proportion_of_cirrhosis_due_to_alcohol')
        self.proportion_of_cirrhosis_due_to_hepatitis_b = kwargs.get('proportion_of_cirrhosis_due_to_hepatitis_b')
        self.proportion_of_cirrhosis_due_to_hepatitis_c = kwargs.get('proportion_of_cirrhosis_due_to_hepatitis_c')
        self.proportion_of_cirrhosis_due_to_other_causes = kwargs.get('proportion_of_cirrhosis_due_to_other_causes')
        self.proportion_of_liver_cancer_due_to_alcohol_age_standardized = kwargs.get('proportion_of_liver_cancer_due_to_alcohol_age_standardized')
        self.proportion_of_liver_cancer_due_to_hepatitis_b_age_standardized = kwargs.get('proportion_of_liver_cancer_due_to_hepatitis_b_age_standardized')
        self.proportion_of_liver_cancer_due_to_hepatitis_c_age_standardized = kwargs.get('proportion_of_liver_cancer_due_to_hepatitis_c_age_standardized')
        self.proportion_of_liver_cancer_due_to_other_causes_age_standardized = kwargs.get('proportion_of_liver_cancer_due_to_other_causes_age_standardized')
        self.major_depressive_disorder = kwargs.get('major_depressive_disorder')
        self.proportion_of_population_involved_in_agricultural_activities = kwargs.get('proportion_of_population_involved_in_agricultural_activities')
        self.health_expenditure_per_capita = kwargs.get('health_expenditure_per_capita')
        self.fraction_of_oop_health_expenditure = kwargs.get('fraction_of_oop_health_expenditure')
        self.universal_health_coverage = kwargs.get('universal_health_coverage')
        self.maternal_alcohol_consumption_during_pregnancy_proportion = kwargs.get('maternal_alcohol_consumption_during_pregnancy_proportion')
        self.healthcare_access_and_quality_index = kwargs.get('healthcare_access_and_quality_index')
        self.age_standardized_proportion_adult_underweight = kwargs.get('age_standardized_proportion_adult_underweight')
        self.ors_oral_rehydration = kwargs.get('ors_oral_rehydration')
        self.antibiotics_for_lri = kwargs.get('antibiotics_for_lri')
        self.live_births_by_sex = kwargs.get('live_births_by_sex')
        self.age_standardized_melanoma = kwargs.get('age_standardized_melanoma')
        self.measles_vaccine_coverage_2_doses_covid_free_proportion = kwargs.get('measles_vaccine_coverage_2_doses_covid_free_proportion')
        self.schisto_cumulative_treatments = kwargs.get('schisto_cumulative_treatments')
        self.health_worker_density = kwargs.get('health_worker_density')
        self.iron_energy_unadjusted_mg = kwargs.get('iron_energy_unadjusted_mg')
        self.malaria_incidence_map = kwargs.get('malaria_incidence_map')
        self.antimalarial_effective_treatment_map = kwargs.get('antimalarial_effective_treatment_map')
        self.rubella_vaccine_coverage_covid_free_proportion = kwargs.get('rubella_vaccine_coverage_covid_free_proportion')
        self.tuberculosis_infection_risk_weighted_prevalence_age_standardized = kwargs.get('tuberculosis_infection_risk_weighted_prevalence_age_standardized')
        self.ten_year_lag_distributed_energy_per_capita = kwargs.get('ten_year_lag_distributed_energy_per_capita')
        self.folic_acid_unadjusted_ug = kwargs.get('folic_acid_unadjusted_ug')
        self.smooth_outphase_of_leaded_gasoline = kwargs.get('smooth_outphase_of_leaded_gasoline')
        self.no_access_to_handwashing_facility = kwargs.get('no_access_to_handwashing_facility')
        self.residential_radon = kwargs.get('residential_radon')
        self.zinc_deficiency = kwargs.get('zinc_deficiency')
        self.diet_high_in_trans_fatty_acids = kwargs.get('diet_high_in_trans_fatty_acids')
        self.diet_high_in_sodium = kwargs.get('diet_high_in_sodium')
        self.tuberculosis_prevalence_age_standardized = kwargs.get('tuberculosis_prevalence_age_standardized')
        self.low_bone_mineral_density = kwargs.get('low_bone_mineral_density')
        self.age_standardized_bone_mineral_density_among_population_age_60_and_up_years = kwargs.get('age_standardized_bone_mineral_density_among_population_age_60_and_up_years')
        self.malnutrition_shock_mortality_rate = kwargs.get('malnutrition_shock_mortality_rate')
        self.mean_war_mortality_rate_in_the_previous_ten_years = kwargs.get('mean_war_mortality_rate_in_the_previous_ten_years')
        self.log_transformed_age_standardized_sev_scalar_for_both_sexes_combined_tb = kwargs.get('log_transformed_age_standardized_sev_scalar_for_both_sexes_combined_tb')
        self.secondhand_smoke = kwargs.get('secondhand_smoke')
        self.asbestos_consumption_metric_tons_per_year_per_capita = kwargs.get('asbestos_consumption_metric_tons_per_year_per_capita')
        self.zinc_treatment_for_diarrhea = kwargs.get('zinc_treatment_for_diarrhea')
        self.fortification_standard_including_folic_acid = kwargs.get('fortification_standard_including_folic_acid')
        self.demand_for_contraception_satisfied_with_modern_methods = kwargs.get('demand_for_contraception_satisfied_with_modern_methods')
        self.demand_for_contraception_satisfied_with_modern_methods_by_age = kwargs.get('demand_for_contraception_satisfied_with_modern_methods_by_age')
        self.polio_3_dose_coverage_covid_free_proportion = kwargs.get('polio_3_dose_coverage_covid_free_proportion')
        self.hepatitis_b_3_dose_coverage_covid_free_proportion = kwargs.get('hepatitis_b_3_dose_coverage_covid_free_proportion')
        self.composite_fortification_standard_and_folic_acid_inclusion = kwargs.get('composite_fortification_standard_and_folic_acid_inclusion')
        self.intravenous_drug_use_proportion_by_age = kwargs.get('intravenous_drug_use_proportion_by_age')
        self.intravenous_drug_use_age_standardized_proportion = kwargs.get('intravenous_drug_use_age_standardized_proportion')
        self.alcohol_consumption_age_standardized_in_grams_per_day = kwargs.get('alcohol_consumption_age_standardized_in_grams_per_day')
        self.alcohol_drinker_proportion_age_standardized = kwargs.get('alcohol_drinker_proportion_age_standardized')
        self.proportion_of_liver_cancer_due_to_nash_age_standardized = kwargs.get('proportion_of_liver_cancer_due_to_nash_age_standardized')
        self.proportion_of_cirrhosis_due_to_nash = kwargs.get('proportion_of_cirrhosis_due_to_nash')
        self.muslim_religion_proportion_of_population = kwargs.get('muslim_religion_proportion_of_population')
        self.tb_strain_prevalence_weighted_transmission_rr = kwargs.get('tb_strain_prevalence_weighted_transmission_rr')
        self.age_and_sex_specific_sev_for_child_underweight = kwargs.get('age_and_sex_specific_sev_for_child_underweight')
        self.age_standardized_sev_for_child_underweight = kwargs.get('age_standardized_sev_for_child_underweight')
        self.age_and_sex_specific_sev_for_child_stunting = kwargs.get('age_and_sex_specific_sev_for_child_stunting')
        self.age_standardized_sev_for_child_stunting = kwargs.get('age_standardized_sev_for_child_stunting')
        self.age_and_sex_specific_sev_for_child_wasting = kwargs.get('age_and_sex_specific_sev_for_child_wasting')
        self.age_standardized_sev_for_child_wasting = kwargs.get('age_standardized_sev_for_child_wasting')
        self.fortification_standard_including_iron = kwargs.get('fortification_standard_including_iron')
        self.pelvic_inflammatory_disease_age_standardized_prevalence = kwargs.get('pelvic_inflammatory_disease_age_standardized_prevalence')
        self.nafld_nash_prevalence = kwargs.get('nafld_nash_prevalence')
        self.hepatitis_b_3_dose_coverage_lagged_5_years_covid_free_proportion = kwargs.get('hepatitis_b_3_dose_coverage_lagged_5_years_covid_free_proportion')
        self.hepatitis_b_3_dose_coverage_lagged_ten_years_covid_free_proportion = kwargs.get('hepatitis_b_3_dose_coverage_lagged_ten_years_covid_free_proportion')
        self.age_and_sex_specific_sev_for_alcohol_use = kwargs.get('age_and_sex_specific_sev_for_alcohol_use')
        self.age_standardized_sev_for_alcohol_use = kwargs.get('age_standardized_sev_for_alcohol_use')
        self.underweight_women_age_specific = kwargs.get('underweight_women_age_specific')
        self.log_transformed_sev_scalar_group_i = kwargs.get('log_transformed_sev_scalar_group_i')
        self.log_transformed_sev_scalar_drug_sus_tb = kwargs.get('log_transformed_sev_scalar_drug_sus_tb')
        self.log_transformed_sev_scalar_mdr_tb = kwargs.get('log_transformed_sev_scalar_mdr_tb')
        self.log_transformed_sev_scalar_xdr_tb = kwargs.get('log_transformed_sev_scalar_xdr_tb')
        self.log_transformed_sev_scalar_hiv = kwargs.get('log_transformed_sev_scalar_hiv')
        self.log_transformed_sev_scalar_drug_sus_hiv_tb = kwargs.get('log_transformed_sev_scalar_drug_sus_hiv_tb')
        self.log_transformed_sev_scalar_mdr_hiv_tb = kwargs.get('log_transformed_sev_scalar_mdr_hiv_tb')
        self.log_transformed_sev_scalar_xdr_hiv_tb = kwargs.get('log_transformed_sev_scalar_xdr_hiv_tb')
        self.log_transformed_sev_scalar_encepha = kwargs.get('log_transformed_sev_scalar_encepha')
        self.log_transformed_sev_scalar_nn_enceph = kwargs.get('log_transformed_sev_scalar_nn_enceph')
        self.log_transformed_sev_scalar_nn_sepsis = kwargs.get('log_transformed_sev_scalar_nn_sepsis')
        self.log_transformed_sev_scalar_nn_hemol = kwargs.get('log_transformed_sev_scalar_nn_hemol')
        self.log_transformed_sev_scalar_oth_nn = kwargs.get('log_transformed_sev_scalar_oth_nn')
        self.log_transformed_sev_scalar_ncd = kwargs.get('log_transformed_sev_scalar_ncd')
        self.log_transformed_sev_scalar_lymphoma = kwargs.get('log_transformed_sev_scalar_lymphoma')
        self.log_transformed_sev_scalar_myeloma = kwargs.get('log_transformed_sev_scalar_myeloma')
        self.log_transformed_sev_scalar_all = kwargs.get('log_transformed_sev_scalar_all')
        self.log_transformed_sev_scalar_cll = kwargs.get('log_transformed_sev_scalar_cll')
        self.log_transformed_sev_scalar_aml = kwargs.get('log_transformed_sev_scalar_aml')
        self.log_transformed_sev_scalar_cml = kwargs.get('log_transformed_sev_scalar_cml')
        self.log_transformed_sev_scalar_oth_leukemia = kwargs.get('log_transformed_sev_scalar_oth_leukemia')
        self.log_transformed_sev_scalar_oth_cmp = kwargs.get('log_transformed_sev_scalar_oth_cmp')
        self.log_transformed_sev_scalar_pud = kwargs.get('log_transformed_sev_scalar_pud')
        self.log_transformed_sev_scalar_gall_bile = kwargs.get('log_transformed_sev_scalar_gall_bile')
        self.log_transformed_sev_scalar_alzheimers = kwargs.get('log_transformed_sev_scalar_alzheimers')
        self.log_transformed_sev_scalar_ms = kwargs.get('log_transformed_sev_scalar_ms')
        self.log_transformed_sev_scalar_rheu_arth = kwargs.get('log_transformed_sev_scalar_rheu_arth')
        self.log_transformed_sev_scalar_glaucoma = kwargs.get('log_transformed_sev_scalar_glaucoma')
        self.log_transformed_sev_scalar_macular = kwargs.get('log_transformed_sev_scalar_macular')
        self.log_transformed_sev_scalar_injuries = kwargs.get('log_transformed_sev_scalar_injuries')
        self.log_transformed_sev_scalar_self_firearm = kwargs.get('log_transformed_sev_scalar_self_firearm')
        self.log_transformed_sev_scalar_self_other = kwargs.get('log_transformed_sev_scalar_self_other')
        self.log_transformed_sev_scalar_sex_viol = kwargs.get('log_transformed_sev_scalar_sex_viol')
        self.log_transformed_age_standardized_sev_scalar_group_i = kwargs.get('log_transformed_age_standardized_sev_scalar_group_i')
        self.log_transformed_age_standardized_sev_scalar_drug_sus_tb = kwargs.get('log_transformed_age_standardized_sev_scalar_drug_sus_tb')
        self.log_transformed_age_standardized_sev_scalar_mdr_tb = kwargs.get('log_transformed_age_standardized_sev_scalar_mdr_tb')
        self.log_transformed_age_standardized_sev_scalar_xdr_tb = kwargs.get('log_transformed_age_standardized_sev_scalar_xdr_tb')
        self.log_transformed_age_standardized_sev_scalar_hiv = kwargs.get('log_transformed_age_standardized_sev_scalar_hiv')
        self.log_transformed_age_standardized_sev_scalar_drug_sus_hiv_tb = kwargs.get('log_transformed_age_standardized_sev_scalar_drug_sus_hiv_tb')
        self.log_transformed_age_standardized_sev_scalar_mdr_hiv_tb = kwargs.get('log_transformed_age_standardized_sev_scalar_mdr_hiv_tb')
        self.log_transformed_age_standardized_sev_scalar_xdr_hiv_tb = kwargs.get('log_transformed_age_standardized_sev_scalar_xdr_hiv_tb')
        self.log_transformed_age_standardized_sev_scalar_meningitis = kwargs.get('log_transformed_age_standardized_sev_scalar_meningitis')
        self.log_transformed_age_standardized_sev_scalar_encepha = kwargs.get('log_transformed_age_standardized_sev_scalar_encepha')
        self.log_transformed_age_standardized_sev_scalar_nn_enceph = kwargs.get('log_transformed_age_standardized_sev_scalar_nn_enceph')
        self.log_transformed_age_standardized_sev_scalar_nn_sepsis = kwargs.get('log_transformed_age_standardized_sev_scalar_nn_sepsis')
        self.log_transformed_age_standardized_sev_scalar_nn_hemol = kwargs.get('log_transformed_age_standardized_sev_scalar_nn_hemol')
        self.log_transformed_age_standardized_sev_scalar_oth_nn = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_nn')
        self.log_transformed_age_standardized_sev_scalar_lymphoma = kwargs.get('log_transformed_age_standardized_sev_scalar_lymphoma')
        self.log_transformed_age_standardized_sev_scalar_myeloma = kwargs.get('log_transformed_age_standardized_sev_scalar_myeloma')
        self.log_transformed_age_standardized_sev_scalar_all = kwargs.get('log_transformed_age_standardized_sev_scalar_all')
        self.log_transformed_age_standardized_sev_scalar_cll = kwargs.get('log_transformed_age_standardized_sev_scalar_cll')
        self.log_transformed_age_standardized_sev_scalar_aml = kwargs.get('log_transformed_age_standardized_sev_scalar_aml')
        self.log_transformed_age_standardized_sev_scalar_cml = kwargs.get('log_transformed_age_standardized_sev_scalar_cml')
        self.log_transformed_age_standardized_sev_scalar_oth_leukemia = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_leukemia')
        self.log_transformed_age_standardized_sev_scalar_oth_cmp = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_cmp')
        self.log_transformed_age_standardized_sev_scalar_pud = kwargs.get('log_transformed_age_standardized_sev_scalar_pud')
        self.log_transformed_age_standardized_sev_scalar_gall_bile = kwargs.get('log_transformed_age_standardized_sev_scalar_gall_bile')
        self.log_transformed_age_standardized_sev_scalar_alzheimers = kwargs.get('log_transformed_age_standardized_sev_scalar_alzheimers')
        self.log_transformed_age_standardized_sev_scalar_ms = kwargs.get('log_transformed_age_standardized_sev_scalar_ms')
        self.log_transformed_age_standardized_sev_scalar_rheu_arth = kwargs.get('log_transformed_age_standardized_sev_scalar_rheu_arth')
        self.log_transformed_age_standardized_sev_scalar_glaucoma = kwargs.get('log_transformed_age_standardized_sev_scalar_glaucoma')
        self.log_transformed_age_standardized_sev_scalar_macular = kwargs.get('log_transformed_age_standardized_sev_scalar_macular')
        self.log_transformed_age_standardized_sev_scalar_sids = kwargs.get('log_transformed_age_standardized_sev_scalar_sids')
        self.log_transformed_age_standardized_sev_scalar_injuries = kwargs.get('log_transformed_age_standardized_sev_scalar_injuries')
        self.log_transformed_age_standardized_sev_scalar_self_firearm = kwargs.get('log_transformed_age_standardized_sev_scalar_self_firearm')
        self.log_transformed_age_standardized_sev_scalar_self_other = kwargs.get('log_transformed_age_standardized_sev_scalar_self_other')
        self.log_transformed_age_standardized_sev_scalar_sex_viol = kwargs.get('log_transformed_age_standardized_sev_scalar_sex_viol')
        self.opioids_per_million_population_per_day_ten_year_lag = kwargs.get('opioids_per_million_population_per_day_ten_year_lag')
        self.occupation_professionals = kwargs.get('occupation_professionals')
        self.health_industry_workers = kwargs.get('health_industry_workers')
        self.education_years_per_capita_aggregated_by_age_15_and_up_and_sex = kwargs.get('education_years_per_capita_aggregated_by_age_15_and_up_and_sex')
        self.total_physical_activity_met_min_week_age_specific = kwargs.get('total_physical_activity_met_min_week_age_specific')
        self.total_physical_activity_met_min_week_age_standardized = kwargs.get('total_physical_activity_met_min_week_age_standardized')
        self.bacille_calmette_guerin_bcg_vaccine_coverage_covid_free_proportion = kwargs.get('bacille_calmette_guerin_bcg_vaccine_coverage_covid_free_proportion')
        self.hepatitis_b_vaccine_coverage_aged_through_time_covid_free_proportion = kwargs.get('hepatitis_b_vaccine_coverage_aged_through_time_covid_free_proportion')
        self.adolescent_birth_rates_10_19_years_of_age = kwargs.get('adolescent_birth_rates_10_19_years_of_age')
        self.log_total_health_expenditure_per_capita = kwargs.get('log_total_health_expenditure_per_capita')
        self.pigs_raised_in_extensive_agricultural_systems_per_capita = kwargs.get('pigs_raised_in_extensive_agricultural_systems_per_capita')
        self.physicians_per_capita = kwargs.get('physicians_per_capita')
        self.nurses_and_midwives_per_capita = kwargs.get('nurses_and_midwives_per_capita')
        self.pharmacists_per_capita = kwargs.get('pharmacists_per_capita')
        self.hiv_mortality_rate = kwargs.get('hiv_mortality_rate')
        self.dentists_per_capita = kwargs.get('dentists_per_capita')
        self.net_reproduction_rate = kwargs.get('net_reproduction_rate')
        self.log_transformed_coal_production_per_capita = kwargs.get('log_transformed_coal_production_per_capita')
        self.systolic_blood_pressure_mmhg_us_r_e = kwargs.get('systolic_blood_pressure_mmhg_us_r_e')
        self.low_density_lipoprotein_mmol_l_us_r_e = kwargs.get('low_density_lipoprotein_mmol_l_us_r_e')
        self.mean_bmi_kg_m2_us_r_e = kwargs.get('mean_bmi_kg_m2_us_r_e')
        self.education_years_per_capita_us_r_e = kwargs.get('education_years_per_capita_us_r_e')
        self.ldi_income_per_capita_us_r_e = kwargs.get('ldi_income_per_capita_us_r_e')
        self.fasting_plasma_glucose_us_r_e = kwargs.get('fasting_plasma_glucose_us_r_e')
        self.total_physical_activity_met_min_week_age_specific_us_r_e = kwargs.get('total_physical_activity_met_min_week_age_specific_us_r_e')
        self.total_physical_activity_met_min_week_age_standardized_us_r_e = kwargs.get('total_physical_activity_met_min_week_age_standardized_us_r_e')
        self.alcohol_liters_per_capita_us_r_e = kwargs.get('alcohol_liters_per_capita_us_r_e')
        self.smoking_prevalence_us_r_e = kwargs.get('smoking_prevalence_us_r_e')
        self.outdoor_air_pollution_pm_2_5_us_r_e = kwargs.get('outdoor_air_pollution_pm_2_5_us_r_e')
        self.fruits_unadjusted_g_us_r_e = kwargs.get('fruits_unadjusted_g_us_r_e')
        self.vegetables_unadjusted_g_us_r_e = kwargs.get('vegetables_unadjusted_g_us_r_e')
        self.education_relative_inequality_gini = kwargs.get('education_relative_inequality_gini')
        self.proportion_of_the_population_with_at_least_6_years_of_education_maternal = kwargs.get('proportion_of_the_population_with_at_least_6_years_of_education_maternal')
        self.proportion_of_the_population_with_at_least_12_years_of_education_maternal = kwargs.get('proportion_of_the_population_with_at_least_12_years_of_education_maternal')
        self.mmr_due_to_maternal_hemorrhage = kwargs.get('mmr_due_to_maternal_hemorrhage')
        self.mmr_due_to_maternal_hypertensive_disorders = kwargs.get('mmr_due_to_maternal_hypertensive_disorders')
        self.mmr_due_to_sepsis_and_other_maternal_infections = kwargs.get('mmr_due_to_sepsis_and_other_maternal_infections')
        self.mmr_due_to_obstructed_labor = kwargs.get('mmr_due_to_obstructed_labor')
        self.age_standardized_sev_for_unsafe_water = kwargs.get('age_standardized_sev_for_unsafe_water')
        self.age_standardized_sev_for_unsafe_sanitation = kwargs.get('age_standardized_sev_for_unsafe_sanitation')
        self.age_and_sex_specific_sev_for_handwashing = kwargs.get('age_and_sex_specific_sev_for_handwashing')
        self.age_standardized_sev_for_handwashing = kwargs.get('age_standardized_sev_for_handwashing')
        self.age_and_sex_specific_sev_for_ambient_particulate_matter = kwargs.get('age_and_sex_specific_sev_for_ambient_particulate_matter')
        self.age_standardized_sev_for_ambient_particulate_matter = kwargs.get('age_standardized_sev_for_ambient_particulate_matter')
        self.age_and_sex_specific_sev_for_household_air_pollution = kwargs.get('age_and_sex_specific_sev_for_household_air_pollution')
        self.age_standardized_sev_for_household_air_pollution = kwargs.get('age_standardized_sev_for_household_air_pollution')
        self.age_and_sex_specific_sev_for_ozone = kwargs.get('age_and_sex_specific_sev_for_ozone')
        self.age_standardized_sev_for_ozone = kwargs.get('age_standardized_sev_for_ozone')
        self.age_and_sex_specific_sev_for_radon = kwargs.get('age_and_sex_specific_sev_for_radon')
        self.age_standardized_sev_for_radon = kwargs.get('age_standardized_sev_for_radon')
        self.age_and_sex_specific_sev_for_lead = kwargs.get('age_and_sex_specific_sev_for_lead')
        self.age_standardized_sev_for_lead = kwargs.get('age_standardized_sev_for_lead')
        self.age_and_sex_specific_sev_for_occupational_asbestos = kwargs.get('age_and_sex_specific_sev_for_occupational_asbestos')
        self.age_standardized_sev_for_occupational_asbestos = kwargs.get('age_standardized_sev_for_occupational_asbestos')
        self.age_and_sex_specific_sev_for_occupational_arsenic = kwargs.get('age_and_sex_specific_sev_for_occupational_arsenic')
        self.age_standardized_sev_for_occupational_arsenic = kwargs.get('age_standardized_sev_for_occupational_arsenic')
        self.age_and_sex_specific_sev_for_occupational_benzene = kwargs.get('age_and_sex_specific_sev_for_occupational_benzene')
        self.age_standardized_sev_for_occupational_benzene = kwargs.get('age_standardized_sev_for_occupational_benzene')
        self.age_and_sex_specific_sev_for_occupational_beryllium = kwargs.get('age_and_sex_specific_sev_for_occupational_beryllium')
        self.age_standardized_sev_for_occupational_beryllium = kwargs.get('age_standardized_sev_for_occupational_beryllium')
        self.age_and_sex_specific_sev_for_occupational_cadmium = kwargs.get('age_and_sex_specific_sev_for_occupational_cadmium')
        self.age_standardized_sev_for_occupational_cadmium = kwargs.get('age_standardized_sev_for_occupational_cadmium')
        self.age_and_sex_specific_sev_for_occupational_chromium = kwargs.get('age_and_sex_specific_sev_for_occupational_chromium')
        self.age_standardized_sev_for_occupational_chromium = kwargs.get('age_standardized_sev_for_occupational_chromium')
        self.age_and_sex_specific_sev_for_occupational_diesel = kwargs.get('age_and_sex_specific_sev_for_occupational_diesel')
        self.age_standardized_sev_for_occupational_diesel = kwargs.get('age_standardized_sev_for_occupational_diesel')
        self.age_and_sex_specific_sev_for_occupational_formaldehyde = kwargs.get('age_and_sex_specific_sev_for_occupational_formaldehyde')
        self.age_standardized_sev_for_occupational_formaldehyde = kwargs.get('age_standardized_sev_for_occupational_formaldehyde')
        self.age_and_sex_specific_sev_for_occupational_nickel = kwargs.get('age_and_sex_specific_sev_for_occupational_nickel')
        self.age_standardized_sev_for_occupational_nickel = kwargs.get('age_standardized_sev_for_occupational_nickel')
        self.age_and_sex_specific_sev_for_occupational_pah = kwargs.get('age_and_sex_specific_sev_for_occupational_pah')
        self.age_standardized_sev_for_occupational_pah = kwargs.get('age_standardized_sev_for_occupational_pah')
        self.age_and_sex_specific_sev_for_occupational_silica = kwargs.get('age_and_sex_specific_sev_for_occupational_silica')
        self.age_standardized_sev_for_occupational_silica = kwargs.get('age_standardized_sev_for_occupational_silica')
        self.age_and_sex_specific_sev_for_occupational_sulfuric_acid = kwargs.get('age_and_sex_specific_sev_for_occupational_sulfuric_acid')
        self.age_standardized_sev_for_occupational_sulfuric_acid = kwargs.get('age_standardized_sev_for_occupational_sulfuric_acid')
        self.age_and_sex_specific_sev_for_occupational_trichloroethylene = kwargs.get('age_and_sex_specific_sev_for_occupational_trichloroethylene')
        self.age_standardized_sev_for_occupational_trichloroethylene = kwargs.get('age_standardized_sev_for_occupational_trichloroethylene')
        self.age_and_sex_specific_sev_for_occupational_asthmagens = kwargs.get('age_and_sex_specific_sev_for_occupational_asthmagens')
        self.age_standardized_sev_for_occupational_asthmagens = kwargs.get('age_standardized_sev_for_occupational_asthmagens')
        self.age_and_sex_specific_sev_for_occupational_particulates = kwargs.get('age_and_sex_specific_sev_for_occupational_particulates')
        self.age_standardized_sev_for_occupational_particulates = kwargs.get('age_standardized_sev_for_occupational_particulates')
        self.age_and_sex_specific_sev_for_occupational_noise = kwargs.get('age_and_sex_specific_sev_for_occupational_noise')
        self.age_standardized_sev_for_occupational_noise = kwargs.get('age_standardized_sev_for_occupational_noise')
        self.age_and_sex_specific_sev_for_occupational_ergonomic = kwargs.get('age_and_sex_specific_sev_for_occupational_ergonomic')
        self.age_standardized_sev_for_occupational_ergonomic = kwargs.get('age_standardized_sev_for_occupational_ergonomic')
        self.age_and_sex_specific_sev_for_non_exclusive_breastfeeding = kwargs.get('age_and_sex_specific_sev_for_non_exclusive_breastfeeding')
        self.age_standardized_sev_for_non_exclusive_breastfeeding = kwargs.get('age_standardized_sev_for_non_exclusive_breastfeeding')
        self.age_and_sex_specific_sev_for_discontinued_breastfeeding = kwargs.get('age_and_sex_specific_sev_for_discontinued_breastfeeding')
        self.age_standardized_sev_for_discontinued_breastfeeding = kwargs.get('age_standardized_sev_for_discontinued_breastfeeding')
        self.age_and_sex_specific_sev_for_short_gestation = kwargs.get('age_and_sex_specific_sev_for_short_gestation')
        self.age_standardized_sev_for_short_gestation = kwargs.get('age_standardized_sev_for_short_gestation')
        self.age_and_sex_specific_sev_for_low_birth_weight = kwargs.get('age_and_sex_specific_sev_for_low_birth_weight')
        self.age_standardized_sev_for_low_birth_weight = kwargs.get('age_standardized_sev_for_low_birth_weight')
        self.age_and_sex_specific_sev_for_iron_deficiency = kwargs.get('age_and_sex_specific_sev_for_iron_deficiency')
        self.age_standardized_sev_for_iron_deficiency = kwargs.get('age_standardized_sev_for_iron_deficiency')
        self.age_and_sex_specific_sev_for_vitamin_a_deficiency = kwargs.get('age_and_sex_specific_sev_for_vitamin_a_deficiency')
        self.age_standardized_sev_for_vitamin_a_deficiency = kwargs.get('age_standardized_sev_for_vitamin_a_deficiency')
        self.age_and_sex_specific_sev_for_zinc_deficiency = kwargs.get('age_and_sex_specific_sev_for_zinc_deficiency')
        self.age_standardized_sev_for_zinc_deficiency = kwargs.get('age_standardized_sev_for_zinc_deficiency')
        self.age_and_sex_specific_sev_for_smoking = kwargs.get('age_and_sex_specific_sev_for_smoking')
        self.age_standardized_sev_for_smoking = kwargs.get('age_standardized_sev_for_smoking')
        self.age_and_sex_specific_sev_for_chewing_tobacco = kwargs.get('age_and_sex_specific_sev_for_chewing_tobacco')
        self.age_standardized_sev_for_chewing_tobacco = kwargs.get('age_standardized_sev_for_chewing_tobacco')
        self.age_and_sex_specific_sev_for_secondhand_smoke = kwargs.get('age_and_sex_specific_sev_for_secondhand_smoke')
        self.age_standardized_sev_for_secondhand_smoke = kwargs.get('age_standardized_sev_for_secondhand_smoke')
        self.age_and_sex_specific_sev_for_drug_use = kwargs.get('age_and_sex_specific_sev_for_drug_use')
        self.age_standardized_sev_for_drug_use = kwargs.get('age_standardized_sev_for_drug_use')
        self.age_and_sex_specific_sev_for_low_fruit = kwargs.get('age_and_sex_specific_sev_for_low_fruit')
        self.age_standardized_sev_for_low_fruit = kwargs.get('age_standardized_sev_for_low_fruit')
        self.age_and_sex_specific_sev_for_low_vegetables = kwargs.get('age_and_sex_specific_sev_for_low_vegetables')
        self.age_standardized_sev_for_low_vegetables = kwargs.get('age_standardized_sev_for_low_vegetables')
        self.age_and_sex_specific_sev_for_low_legumes = kwargs.get('age_and_sex_specific_sev_for_low_legumes')
        self.age_standardized_sev_for_low_legumes = kwargs.get('age_standardized_sev_for_low_legumes')
        self.age_and_sex_specific_sev_for_low_whole_grains = kwargs.get('age_and_sex_specific_sev_for_low_whole_grains')
        self.age_standardized_sev_for_low_whole_grains = kwargs.get('age_standardized_sev_for_low_whole_grains')
        self.age_and_sex_specific_sev_for_low_nuts_and_seeds = kwargs.get('age_and_sex_specific_sev_for_low_nuts_and_seeds')
        self.age_standardized_sev_for_low_nuts_and_seeds = kwargs.get('age_standardized_sev_for_low_nuts_and_seeds')
        self.age_and_sex_specific_sev_for_low_milk = kwargs.get('age_and_sex_specific_sev_for_low_milk')
        self.age_standardized_sev_for_low_milk = kwargs.get('age_standardized_sev_for_low_milk')
        self.age_and_sex_specific_sev_for_high_red_meat = kwargs.get('age_and_sex_specific_sev_for_high_red_meat')
        self.age_standardized_sev_for_high_red_meat = kwargs.get('age_standardized_sev_for_high_red_meat')
        self.age_and_sex_specific_sev_for_high_processed_meat = kwargs.get('age_and_sex_specific_sev_for_high_processed_meat')
        self.age_standardized_sev_for_high_processed_meat = kwargs.get('age_standardized_sev_for_high_processed_meat')
        self.age_and_sex_specific_sev_for_high_sweetened_beverages = kwargs.get('age_and_sex_specific_sev_for_high_sweetened_beverages')
        self.age_standardized_sev_for_high_sweetened_beverages = kwargs.get('age_standardized_sev_for_high_sweetened_beverages')
        self.age_and_sex_specific_sev_for_low_fiber = kwargs.get('age_and_sex_specific_sev_for_low_fiber')
        self.age_standardized_sev_for_low_fiber = kwargs.get('age_standardized_sev_for_low_fiber')
        self.age_and_sex_specific_sev_for_low_calcium = kwargs.get('age_and_sex_specific_sev_for_low_calcium')
        self.age_standardized_sev_for_low_calcium = kwargs.get('age_standardized_sev_for_low_calcium')
        self.age_and_sex_specific_sev_for_low_omega_3 = kwargs.get('age_and_sex_specific_sev_for_low_omega_3')
        self.age_standardized_sev_for_low_omega_3 = kwargs.get('age_standardized_sev_for_low_omega_3')
        self.age_and_sex_specific_sev_for_low_pufa = kwargs.get('age_and_sex_specific_sev_for_low_pufa')
        self.age_standardized_sev_for_low_pufa = kwargs.get('age_standardized_sev_for_low_pufa')
        self.age_and_sex_specific_sev_for_high_trans_fat = kwargs.get('age_and_sex_specific_sev_for_high_trans_fat')
        self.age_standardized_sev_for_high_trans_fat = kwargs.get('age_standardized_sev_for_high_trans_fat')
        self.age_and_sex_specific_sev_for_high_sodium = kwargs.get('age_and_sex_specific_sev_for_high_sodium')
        self.age_standardized_sev_for_high_sodium = kwargs.get('age_standardized_sev_for_high_sodium')
        self.age_and_sex_specific_sev_for_intimate_partner_violence = kwargs.get('age_and_sex_specific_sev_for_intimate_partner_violence')
        self.age_standardized_sev_for_intimate_partner_violence = kwargs.get('age_standardized_sev_for_intimate_partner_violence')
        self.age_and_sex_specific_sev_for_childhood_sexual_abuse = kwargs.get('age_and_sex_specific_sev_for_childhood_sexual_abuse')
        self.age_standardized_sev_for_childhood_sexual_abuse = kwargs.get('age_standardized_sev_for_childhood_sexual_abuse')
        self.age_and_sex_specific_sev_for_bullying = kwargs.get('age_and_sex_specific_sev_for_bullying')
        self.age_standardized_sev_for_bullying = kwargs.get('age_standardized_sev_for_bullying')
        self.age_and_sex_specific_sev_for_low_physical_activity = kwargs.get('age_and_sex_specific_sev_for_low_physical_activity')
        self.age_standardized_sev_for_low_physical_activity = kwargs.get('age_standardized_sev_for_low_physical_activity')
        self.age_and_sex_specific_sev_for_high_fasting_plasma_glucose = kwargs.get('age_and_sex_specific_sev_for_high_fasting_plasma_glucose')
        self.age_standardized_sev_for_high_fasting_plasma_glucose = kwargs.get('age_standardized_sev_for_high_fasting_plasma_glucose')
        self.age_and_sex_specific_sev_for_high_ldl = kwargs.get('age_and_sex_specific_sev_for_high_ldl')
        self.age_standardized_sev_for_high_ldl = kwargs.get('age_standardized_sev_for_high_ldl')
        self.age_and_sex_specific_sev_for_high_blood_pressure = kwargs.get('age_and_sex_specific_sev_for_high_blood_pressure')
        self.age_standardized_sev_for_high_blood_pressure = kwargs.get('age_standardized_sev_for_high_blood_pressure')
        self.age_and_sex_specific_sev_for_high_body_mass_index = kwargs.get('age_and_sex_specific_sev_for_high_body_mass_index')
        self.age_standardized_sev_for_high_body_mass_index = kwargs.get('age_standardized_sev_for_high_body_mass_index')
        self.age_and_sex_specific_sev_for_low_bone_mineral_density = kwargs.get('age_and_sex_specific_sev_for_low_bone_mineral_density')
        self.age_standardized_sev_for_low_bone_mineral_density = kwargs.get('age_standardized_sev_for_low_bone_mineral_density')
        self.age_and_sex_specific_sev_for_impaired_kidney_function = kwargs.get('age_and_sex_specific_sev_for_impaired_kidney_function')
        self.age_standardized_sev_for_impaired_kidney_function = kwargs.get('age_standardized_sev_for_impaired_kidney_function')
        self.log_transformed_age_standardized_sev_scalar_obst_labor = kwargs.get('log_transformed_age_standardized_sev_scalar_obst_labor')
        self.log_transformed_sev_scalar_obst_labor = kwargs.get('log_transformed_sev_scalar_obst_labor')
        self.log_transformed_age_standardized_sev_scalar_ectopic_preg = kwargs.get('log_transformed_age_standardized_sev_scalar_ectopic_preg')
        self.log_transformed_sev_scalar_ectopic_preg = kwargs.get('log_transformed_sev_scalar_ectopic_preg')
        self.log_transformed_age_standardized_sev_scalar_neonatal = kwargs.get('log_transformed_age_standardized_sev_scalar_neonatal')
        self.log_transformed_sev_scalar_neonatal = kwargs.get('log_transformed_sev_scalar_neonatal')
        self.log_transformed_age_standardized_sev_scalar_liver_c_nash = kwargs.get('log_transformed_age_standardized_sev_scalar_liver_c_nash')
        self.log_transformed_sev_scalar_liver_c_nash = kwargs.get('log_transformed_sev_scalar_liver_c_nash')
        self.log_transformed_age_standardized_sev_scalar_sub_hem = kwargs.get('log_transformed_age_standardized_sev_scalar_sub_hem')
        self.log_transformed_sev_scalar_sub_hem = kwargs.get('log_transformed_sev_scalar_sub_hem')
        self.log_transformed_age_standardized_sev_scalar_upper_digest = kwargs.get('log_transformed_age_standardized_sev_scalar_upper_digest')
        self.log_transformed_sev_scalar_upper_digest = kwargs.get('log_transformed_sev_scalar_upper_digest')
        self.log_transformed_age_standardized_sev_scalar_blindness = kwargs.get('log_transformed_age_standardized_sev_scalar_blindness')
        self.log_transformed_sev_scalar_blindness = kwargs.get('log_transformed_sev_scalar_blindness')
        self.log_transformed_age_standardized_sev_scalar_inj_pois_co = kwargs.get('log_transformed_age_standardized_sev_scalar_inj_pois_co')
        self.log_transformed_sev_scalar_inj_pois_co = kwargs.get('log_transformed_sev_scalar_inj_pois_co')
        self.log_transformed_age_standardized_sev_scalar_inj_pois_oth = kwargs.get('log_transformed_age_standardized_sev_scalar_inj_pois_oth')
        self.log_transformed_sev_scalar_inj_pois_oth = kwargs.get('log_transformed_sev_scalar_inj_pois_oth')
        self.log_transformed_age_standardized_sev_scalar_heat__and_up_cold = kwargs.get('log_transformed_age_standardized_sev_scalar_heat__and_up_cold')
        self.log_transformed_sev_scalar_heat__and_up_cold = kwargs.get('log_transformed_sev_scalar_heat__and_up_cold')
        self.log_transformed_age_standardized_sev_scalar_mat_htn = kwargs.get('log_transformed_age_standardized_sev_scalar_mat_htn')
        self.log_transformed_age_standardized_sev_scalar_mat_indir = kwargs.get('log_transformed_age_standardized_sev_scalar_mat_indir')
        self.log_transformed_age_standardized_sev_scalar_mat_late = kwargs.get('log_transformed_age_standardized_sev_scalar_mat_late')
        self.log_transformed_age_standardized_sev_scalar_oth_mat = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_mat')
        self.log_transformed_age_standardized_sev_scalar_ncd = kwargs.get('log_transformed_age_standardized_sev_scalar_ncd')
        self.log_transformed_age_standardized_sev_scalar_anxiety = kwargs.get('log_transformed_age_standardized_sev_scalar_anxiety')
        self.log_transformed_age_standardized_sev_scalar_disaster = kwargs.get('log_transformed_age_standardized_sev_scalar_disaster')
        self.log_transformed_age_standardized_sev_scalar_mat_hiv = kwargs.get('log_transformed_age_standardized_sev_scalar_mat_hiv')
        self.log_transformed_age_standardized_sev_scalar_mat_abort = kwargs.get('log_transformed_age_standardized_sev_scalar_mat_abort')
        self.log_transformed_sev_scalar_mat_abort = kwargs.get('log_transformed_sev_scalar_mat_abort')
        self.proportion_of_the_population_with_0_years_of_education_maternal = kwargs.get('proportion_of_the_population_with_0_years_of_education_maternal')
        self.stillbirth_28_weeks_to_live_birth_ratio = kwargs.get('stillbirth_28_weeks_to_live_birth_ratio')
        self.proportion_pnn_pop_aged_1_5_mo = kwargs.get('proportion_pnn_pop_aged_1_5_mo')
        self.proportion_1_4_pop_aged_1_year = kwargs.get('proportion_1_4_pop_aged_1_year')
        self.gallup_negative_experience_index = kwargs.get('gallup_negative_experience_index')
        self.proportion_of_the_population_working_in_mining_with_20_year_lag = kwargs.get('proportion_of_the_population_working_in_mining_with_20_year_lag')
        self.gold_production_kg_per_capita_smoothed_with_20_year_lag = kwargs.get('gold_production_kg_per_capita_smoothed_with_20_year_lag')
        self.diabetes_fasting_plasma_glucose_mmol_l_by_age = kwargs.get('diabetes_fasting_plasma_glucose_mmol_l_by_age')
        self.hepatitis_a_seroprevalence_anti_hav_age_standardized = kwargs.get('hepatitis_a_seroprevalence_anti_hav_age_standardized')
        self.hepatitis_b_seroprevalence_hbsag_age_standardized = kwargs.get('hepatitis_b_seroprevalence_hbsag_age_standardized')
        self.hepatitis_c_seroprevalence_anti_hcv_age_standardized = kwargs.get('hepatitis_c_seroprevalence_anti_hcv_age_standardized')
        self.hepatitis_e_seroprevalence_anti_hev_age_standardized = kwargs.get('hepatitis_e_seroprevalence_anti_hev_age_standardized')
        self.bac_law_general_population_quartile = kwargs.get('bac_law_general_population_quartile')
        self.bac_law_youth_drivers_quartile = kwargs.get('bac_law_youth_drivers_quartile')
        self.bac_law_professional_drivers_quartile = kwargs.get('bac_law_professional_drivers_quartile')
        self.speed_limit_law_urban_quartile = kwargs.get('speed_limit_law_urban_quartile')
        self.speed_limit_law_rural_quartile = kwargs.get('speed_limit_law_rural_quartile')
        self.liters_of_alcohol_consumed_per_capita = kwargs.get('liters_of_alcohol_consumed_per_capita')
        self.live_births_by_childs_sex_and_maternal_age = kwargs.get('live_births_by_childs_sex_and_maternal_age')
        self.population_15_to_30_males_proportion = kwargs.get('population_15_to_30_males_proportion')
        self.max_trachoma_population_at_risk = kwargs.get('max_trachoma_population_at_risk')
        self.schistosomiasis_prevalence_results = kwargs.get('schistosomiasis_prevalence_results')
        self.who_sth_mda_coverage = kwargs.get('who_sth_mda_coverage')
        self.bcg_lagged_five_year_coverage_covid_free_proportion = kwargs.get('bcg_lagged_five_year_coverage_covid_free_proportion')
        self.dtp3_lagged_five_year_coverage_covid_free_proportion = kwargs.get('dtp3_lagged_five_year_coverage_covid_free_proportion')
        self.mcv1_lagged_five_year_coverage_covid_free_proportion = kwargs.get('mcv1_lagged_five_year_coverage_covid_free_proportion')
        self.mcv2_lagged_five_year_coverage_covid_free_proportion = kwargs.get('mcv2_lagged_five_year_coverage_covid_free_proportion')
        self.polio3_lagged_five_year_coverage_covid_free_proportion = kwargs.get('polio3_lagged_five_year_coverage_covid_free_proportion')
        self.rcv1_lagged_five_year_coverage_covid_free_proportion = kwargs.get('rcv1_lagged_five_year_coverage_covid_free_proportion')
        self.hib3_lagged_five_year_coverage_covid_free_proportion = kwargs.get('hib3_lagged_five_year_coverage_covid_free_proportion')
        self.pcv3_lagged_five_year_coverage_covid_free_proportion = kwargs.get('pcv3_lagged_five_year_coverage_covid_free_proportion')
        self.rotac_lagged_five_year_coverage_covid_free_proportion = kwargs.get('rotac_lagged_five_year_coverage_covid_free_proportion')
        self.hepb3_lagged_five_year_coverage_covid_free_proportion = kwargs.get('hepb3_lagged_five_year_coverage_covid_free_proportion')
        self.proportion_of_population_vulnerable_to_venomous_snakebites = kwargs.get('proportion_of_population_vulnerable_to_venomous_snakebites')
        self.mean_number_of_venomous_snake_species = kwargs.get('mean_number_of_venomous_snake_species')
        self.tfr_u20_us_r_e = kwargs.get('tfr_u20_us_r_e')
        self.dengue_all_age_csmr = kwargs.get('dengue_all_age_csmr')
        self.education_years_per_capita_aggregated_by_age_15_and_up_and_sex_us_r_e = kwargs.get('education_years_per_capita_aggregated_by_age_15_and_up_and_sex_us_r_e')
        self.age_and_sex_specific_sev_for_high_temperature = kwargs.get('age_and_sex_specific_sev_for_high_temperature')
        self.age_and_sex_specific_sev_for_low_temperature = kwargs.get('age_and_sex_specific_sev_for_low_temperature')
        self.age_standardized_sev_for_high_temperature = kwargs.get('age_standardized_sev_for_high_temperature')
        self.age_standardized_sev_for_low_temperature = kwargs.get('age_standardized_sev_for_low_temperature')
        self.inpatient_utilization_envelope = kwargs.get('inpatient_utilization_envelope')
        self.chronic_hepatitis_c_age_standardized = kwargs.get('chronic_hepatitis_c_age_standardized')
        self.vaccine_adjusted_hbsag_serporevalence_age_standardized = kwargs.get('vaccine_adjusted_hbsag_serporevalence_age_standardized')
        self.hib3_transformed_population_level_coverage_including_indirect_effects_proportion = kwargs.get('hib3_transformed_population_level_coverage_including_indirect_effects_proportion')
        self.age_standardized_daily_smoking_prevalence_both_sexes = kwargs.get('age_standardized_daily_smoking_prevalence_both_sexes')
        self.log_transformed_sev_scalar_oth_cirr = kwargs.get('log_transformed_sev_scalar_oth_cirr')
        self.log_transformed_age_standardized_sev_scalar_oth_cirr = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_cirr')
        self.log_transformed_sev_scalar_burkitt = kwargs.get('log_transformed_sev_scalar_burkitt')
        self.log_transformed_age_standardized_sev_scalar_burkitt = kwargs.get('log_transformed_age_standardized_sev_scalar_burkitt')
        self.log_transformed_sev_scalar_oth_lymphoma = kwargs.get('log_transformed_sev_scalar_oth_lymphoma')
        self.log_transformed_age_standardized_sev_scalar_oth_lymphoma = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_lymphoma')
        self.log_transformed_sev_scalar_osteoarth_hip = kwargs.get('log_transformed_sev_scalar_osteoarth_hip')
        self.log_transformed_age_standardized_sev_scalar_osteoarth_hip = kwargs.get('log_transformed_age_standardized_sev_scalar_osteoarth_hip')
        self.log_transformed_sev_scalar_osteoarth_knee = kwargs.get('log_transformed_sev_scalar_osteoarth_knee')
        self.log_transformed_age_standardized_sev_scalar_osteoarth_knee = kwargs.get('log_transformed_age_standardized_sev_scalar_osteoarth_knee')
        self.sheep_density = kwargs.get('sheep_density')
        self.total_fertility_rate_under_25 = kwargs.get('total_fertility_rate_under_25')
        self.caesarean_section = kwargs.get('caesarean_section')
        self.full_maternal_care = kwargs.get('full_maternal_care')
        self.proportion_in_correctional_facility = kwargs.get('proportion_in_correctional_facility')
        self.proportion_in_correctional_facility_by_race_ethnicity = kwargs.get('proportion_in_correctional_facility_by_race_ethnicity')
        self.alcohol_availability_per_capita = kwargs.get('alcohol_availability_per_capita')
        self.alcohol_availability_per_capita_smoothed = kwargs.get('alcohol_availability_per_capita_smoothed')
        self.alcohol_places_per_capita = kwargs.get('alcohol_places_per_capita')
        self.alcohol_stores_per_capita = kwargs.get('alcohol_stores_per_capita')
        self.tobacco_stores_per_capita = kwargs.get('tobacco_stores_per_capita')
        self.tobacco_stores_per_capita_smoothed = kwargs.get('tobacco_stores_per_capita_smoothed')
        self.proportion_with_ba_and_up = kwargs.get('proportion_with_ba_and_up')
        self.proportion_with_ba_and_up_by_race_ethnicity = kwargs.get('proportion_with_ba_and_up_by_race_ethnicity')
        self.proportion_with_hs_and_up = kwargs.get('proportion_with_hs_and_up')
        self.proportion_with_hs_and_up_by_race_ethnicity = kwargs.get('proportion_with_hs_and_up_by_race_ethnicity')
        self.proportion_foreign_born = kwargs.get('proportion_foreign_born')
        self.proportion_foreign_born_by_education = kwargs.get('proportion_foreign_born_by_education')
        self.proportion_foreign_born_by_race_ethnicity = kwargs.get('proportion_foreign_born_by_race_ethnicity')
        self.proportion_hispanic = kwargs.get('proportion_hispanic')
        self.personal_income_per_capita = kwargs.get('personal_income_per_capita')
        self.average_income_per_capita_by_race_ethnicity = kwargs.get('average_income_per_capita_by_race_ethnicity')
        self.mds_per_capita = kwargs.get('mds_per_capita')
        self.mds_per_capita_state = kwargs.get('mds_per_capita_state')
        self.median_household_income = kwargs.get('median_household_income')
        self.median_property_value = kwargs.get('median_property_value')
        self.log_of_population_density = kwargs.get('log_of_population_density')
        self.population_density = kwargs.get('population_density')
        self.proportion_in_college = kwargs.get('proportion_in_college')
        self.proportion_in_poverty_by_education = kwargs.get('proportion_in_poverty_by_education')
        self.proportion_in_poverty_by_race_ethnicity = kwargs.get('proportion_in_poverty_by_race_ethnicity')
        self.proportion_land_in_reservations = kwargs.get('proportion_land_in_reservations')
        self.proportion_land_in_federal_reservations = kwargs.get('proportion_land_in_federal_reservations')
        self.proportion_land_in_state_reservations = kwargs.get('proportion_land_in_state_reservations')
        self.proportion_black = kwargs.get('proportion_black')
        self.proportion_other_race = kwargs.get('proportion_other_race')
        self.proportion_white = kwargs.get('proportion_white')
        self.proportion_non_hispanic_aian = kwargs.get('proportion_non_hispanic_aian')
        self.proportion_non_hispanic_api = kwargs.get('proportion_non_hispanic_api')
        self.proportion_non_hispanic_black = kwargs.get('proportion_non_hispanic_black')
        self.proportion_non_hispanic_white = kwargs.get('proportion_non_hispanic_white')
        self.proportion_rural = kwargs.get('proportion_rural')
        self.proportion_unemployed = kwargs.get('proportion_unemployed')
        self.proportion_unemployed_by_education = kwargs.get('proportion_unemployed_by_education')
        self.proportion_with_health_insurance_by_education = kwargs.get('proportion_with_health_insurance_by_education')
        self.population_by_age_and_sex = kwargs.get('population_by_age_and_sex')
        self.population_by_education = kwargs.get('population_by_education')
        self.population_by_race_ethnicity_1977_omb_standard = kwargs.get('population_by_race_ethnicity_1977_omb_standard')
        self.population_by_race_ethnicity_1997_omb_standard = kwargs.get('population_by_race_ethnicity_1997_omb_standard')
        self.bacille_calmette_guerin_bcg_vaccine_coverage_covid_inclusive_proportion = kwargs.get('bacille_calmette_guerin_bcg_vaccine_coverage_covid_inclusive_proportion')
        self.dtp3_coverage_covid_inclusive_proportion = kwargs.get('dtp3_coverage_covid_inclusive_proportion')
        self.measles_vaccine_coverage_covid_inclusive_proportion = kwargs.get('measles_vaccine_coverage_covid_inclusive_proportion')
        self.measles_vaccine_coverage_2_doses_covid_inclusive_proportion = kwargs.get('measles_vaccine_coverage_2_doses_covid_inclusive_proportion')
        self.polio_3_dose_coverage_covid_inclusive_proportion = kwargs.get('polio_3_dose_coverage_covid_inclusive_proportion')
        self.rubella_vaccine_coverage_covid_inclusive_proportion = kwargs.get('rubella_vaccine_coverage_covid_inclusive_proportion')
        self.hib3_vaccine_coverage_covid_inclusive_proportion = kwargs.get('hib3_vaccine_coverage_covid_inclusive_proportion')
        self.pcv3_coverage_covid_inclusive_proportion = kwargs.get('pcv3_coverage_covid_inclusive_proportion')
        self.rotavirus_coverage_covid_inclusive_proportion = kwargs.get('rotavirus_coverage_covid_inclusive_proportion')
        self.hepatitis_b_3_dose_coverage_covid_inclusive_proportion = kwargs.get('hepatitis_b_3_dose_coverage_covid_inclusive_proportion')
        self.bcg_lagged_five_year_coverage_covid_inclusive_proportion = kwargs.get('bcg_lagged_five_year_coverage_covid_inclusive_proportion')
        self.dtp3_lagged_five_year_coverage_covid_inclusive_proportion = kwargs.get('dtp3_lagged_five_year_coverage_covid_inclusive_proportion')
        self.mcv1_lagged_five_year_coverage_covid_inclusive_proportion = kwargs.get('mcv1_lagged_five_year_coverage_covid_inclusive_proportion')
        self.mcv2_lagged_five_year_coverage_covid_inclusive_proportion = kwargs.get('mcv2_lagged_five_year_coverage_covid_inclusive_proportion')
        self.rcv1_lagged_five_year_coverage_covid_inclusive_proportion = kwargs.get('rcv1_lagged_five_year_coverage_covid_inclusive_proportion')
        self.hib3_lagged_five_year_coverage_covid_inclusive_proportion = kwargs.get('hib3_lagged_five_year_coverage_covid_inclusive_proportion')
        self.pcv3_lagged_five_year_coverage_covid_inclusive_proportion = kwargs.get('pcv3_lagged_five_year_coverage_covid_inclusive_proportion')
        self.rotac_lagged_five_year_coverage_covid_inclusive_proportion = kwargs.get('rotac_lagged_five_year_coverage_covid_inclusive_proportion')
        self.hepb3_lagged_five_year_coverage_covid_inclusive_proportion = kwargs.get('hepb3_lagged_five_year_coverage_covid_inclusive_proportion')
        self.hepatitis_b_3_dose_coverage_proportion_lagged_5_years_covid_inclusive = kwargs.get('hepatitis_b_3_dose_coverage_proportion_lagged_5_years_covid_inclusive')
        self.hepatitis_b_3_dose_coverage_proportion_lagged_ten_years_covid_inclusive = kwargs.get('hepatitis_b_3_dose_coverage_proportion_lagged_ten_years_covid_inclusive')
        self.hepatitis_b_vaccine_coverage_proportion_aged_through_time_covid_inclusive = kwargs.get('hepatitis_b_vaccine_coverage_proportion_aged_through_time_covid_inclusive')
        self.polio3_lagged_five_year_coverage_covid_inclusive_proportion = kwargs.get('polio3_lagged_five_year_coverage_covid_inclusive_proportion')
        self.sugar_sweetened_beverages_g_us_r_e = kwargs.get('sugar_sweetened_beverages_g_us_r_e')
        self.processed_meat_g_us_r_e = kwargs.get('processed_meat_g_us_r_e')
        self.coverage_of_postnatal_care_visit = kwargs.get('coverage_of_postnatal_care_visit')
        self.socio_demographic_index_us_r_e = kwargs.get('socio_demographic_index_us_r_e')
        self.college_enrollment_by_race_ethnicity = kwargs.get('college_enrollment_by_race_ethnicity')
        self.proportion_in_each_primary_race_multiracial = kwargs.get('proportion_in_each_primary_race_multiracial')
        self.unemployment_rate_by_race_ethnicity = kwargs.get('unemployment_rate_by_race_ethnicity')
        self.k_12_spending_per_student = kwargs.get('k_12_spending_per_student')
        self.dummy_covariate = kwargs.get('dummy_covariate')
        self.proportion_of_owner_occupied_homes = kwargs.get('proportion_of_owner_occupied_homes')
        self.proportion_of_owner_occupied_homes_by_race_ethnicity_of_householder = kwargs.get('proportion_of_owner_occupied_homes_by_race_ethnicity_of_householder')
        self.proportion_in_poverty = kwargs.get('proportion_in_poverty')
        self.probability_of_homozygous_sickle_cell_disease_at_birth_ss = kwargs.get('probability_of_homozygous_sickle_cell_disease_at_birth_ss')
        self.probability_of_hemoglobin_sc_disease_at_birth = kwargs.get('probability_of_hemoglobin_sc_disease_at_birth')
        self.probability_of_homozygous_sickle_cell_disease_ss_and_g6pd_deficiency_at_birth = kwargs.get('probability_of_homozygous_sickle_cell_disease_ss_and_g6pd_deficiency_at_birth')
        self.probability_of_hemoglobin_sc_disease_sc_and_g6pd_deficiency_at_birth = kwargs.get('probability_of_hemoglobin_sc_disease_sc_and_g6pd_deficiency_at_birth')
        self.probability_of_g6pd_deficiency_at_birth = kwargs.get('probability_of_g6pd_deficiency_at_birth')
        self.population_by_marital_status = kwargs.get('population_by_marital_status')
        self.domestic_health_expenditure_per_capita = kwargs.get('domestic_health_expenditure_per_capita')
        self.proportion_non_hispanic_aian_by_educational_attainment = kwargs.get('proportion_non_hispanic_aian_by_educational_attainment')
        self.proportion_non_hispanic_api_by_educational_attainment = kwargs.get('proportion_non_hispanic_api_by_educational_attainment')
        self.proportion_non_hispanic_black_by_educational_attainment = kwargs.get('proportion_non_hispanic_black_by_educational_attainment')
        self.proportion_non_hispanic_white_by_educational_attainment = kwargs.get('proportion_non_hispanic_white_by_educational_attainment')
        self.proportion_hispanic_by_educational_attainment = kwargs.get('proportion_hispanic_by_educational_attainment')
        self.age_specific_cohort_cumulative_fertility_ccf = kwargs.get('age_specific_cohort_cumulative_fertility_ccf')
        self.mobility_during_covid_19_pandemic = kwargs.get('mobility_during_covid_19_pandemic')
        self.mask_use = kwargs.get('mask_use')
        self.leprosy_prevalence_age_specific = kwargs.get('leprosy_prevalence_age_specific')
        self.stillbirth_20_weeks_to_live_birth_ratio = kwargs.get('stillbirth_20_weeks_to_live_birth_ratio')
        self.age_and_sex_specific_sev_for_no2_pollution = kwargs.get('age_and_sex_specific_sev_for_no2_pollution')
        self.age_standardized_sev_for_no2_pollution = kwargs.get('age_standardized_sev_for_no2_pollution')
        self.stillbirth_20_weeks = kwargs.get('stillbirth_20_weeks')
        self.stillbirth_28_weeks = kwargs.get('stillbirth_28_weeks')
        self.stillbirth_rate_20_weeks = kwargs.get('stillbirth_rate_20_weeks')
        self.stillbirth_rate_28_weeks = kwargs.get('stillbirth_rate_28_weeks')
        self.major_depressive_disorder_age_standardized = kwargs.get('major_depressive_disorder_age_standardized')
        self.proportion_of_full_population_covered_by_menafrivac_initiative_meningitis_meningococcal_type_a_vaccine_risk_group_model = kwargs.get('proportion_of_full_population_covered_by_menafrivac_initiative_meningitis_meningococcal_type_a_vaccine_risk_group_model')
        self.proportion_of_high_risk_population_covered_by_menafrivac_initiative_meningitis_meningococcal_type_a_vaccine_risk_group_model = kwargs.get('proportion_of_high_risk_population_covered_by_menafrivac_initiative_meningitis_meningococcal_type_a_vaccine_risk_group_model')
        self.log_transformed_sev_scalar_myocarditis = kwargs.get('log_transformed_sev_scalar_myocarditis')
        self.log_transformed_age_standardized_sev_scalar_myocarditis = kwargs.get('log_transformed_age_standardized_sev_scalar_myocarditis')
        self.log_transformed_age_standardized_sev_scalar_malaria = kwargs.get('log_transformed_age_standardized_sev_scalar_malaria')
        self.intermediate_age_specific_hiv_mortality_rate_demographics_team_only = kwargs.get('intermediate_age_specific_hiv_mortality_rate_demographics_team_only')
        self.log_transformed_sev_scalar_all_causes = kwargs.get('log_transformed_sev_scalar_all_causes')
        self.log_transformed_age_standardized_sev_scalar_all_causes = kwargs.get('log_transformed_age_standardized_sev_scalar_all_causes')
        self.log_transformed_sev_scalar_ntd_and_upmalaria = kwargs.get('log_transformed_sev_scalar_ntd_and_upmalaria')
        self.log_transformed_age_standardized_sev_scalar_ntd_and_upmalaria = kwargs.get('log_transformed_age_standardized_sev_scalar_ntd_and_upmalaria')
        self.log_transformed_sev_scalar_nutr_def = kwargs.get('log_transformed_sev_scalar_nutr_def')
        self.log_transformed_age_standardized_sev_scalar_nutr_def = kwargs.get('log_transformed_age_standardized_sev_scalar_nutr_def')
        self.log_transformed_sev_scalar_neoplasms = kwargs.get('log_transformed_sev_scalar_neoplasms')
        self.log_transformed_age_standardized_sev_scalar_neoplasms = kwargs.get('log_transformed_age_standardized_sev_scalar_neoplasms')
        self.log_transformed_sev_scalar_neuro = kwargs.get('log_transformed_sev_scalar_neuro')
        self.log_transformed_age_standardized_sev_scalar_neuro = kwargs.get('log_transformed_age_standardized_sev_scalar_neuro')
        self.log_transformed_sev_scalar_mental = kwargs.get('log_transformed_sev_scalar_mental')
        self.log_transformed_age_standardized_sev_scalar_mental = kwargs.get('log_transformed_age_standardized_sev_scalar_mental')
        self.log_transformed_sev_scalar_oth_ncd = kwargs.get('log_transformed_sev_scalar_oth_ncd')
        self.log_transformed_age_standardized_sev_scalar_oth_ncd = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_ncd')
        self.log_transformed_sev_scalar_unint_inj = kwargs.get('log_transformed_sev_scalar_unint_inj')
        self.log_transformed_age_standardized_sev_scalar_unint_inj = kwargs.get('log_transformed_age_standardized_sev_scalar_unint_inj')
        self.log_transformed_sev_scalar_self_harm_and_ipv = kwargs.get('log_transformed_sev_scalar_self_harm_and_ipv')
        self.log_transformed_age_standardized_sev_scalar_self_harm_and_ipv = kwargs.get('log_transformed_age_standardized_sev_scalar_self_harm_and_ipv')
        self.log_transformed_sev_scalar_hiv_aids_and_upstis = kwargs.get('log_transformed_sev_scalar_hiv_aids_and_upstis')
        self.log_transformed_age_standardized_sev_scalar_hiv_aids_and_upstis = kwargs.get('log_transformed_age_standardized_sev_scalar_hiv_aids_and_upstis')
        self.log_transformed_sev_scalar_resp_and_uptb = kwargs.get('log_transformed_sev_scalar_resp_and_uptb')
        self.log_transformed_age_standardized_sev_scalar_resp_and_uptb = kwargs.get('log_transformed_age_standardized_sev_scalar_resp_and_uptb')
        self.log_transformed_sev_scalar_enteric_infect = kwargs.get('log_transformed_sev_scalar_enteric_infect')
        self.log_transformed_age_standardized_sev_scalar_enteric_infect = kwargs.get('log_transformed_age_standardized_sev_scalar_enteric_infect')
        self.log_transformed_sev_scalar_other_and_updiseases = kwargs.get('log_transformed_sev_scalar_other_and_updiseases')
        self.log_transformed_age_standardized_sev_scalar_other_and_updiseases = kwargs.get('log_transformed_age_standardized_sev_scalar_other_and_updiseases')
        self.log_transformed_sev_scalar_mat_and_upneonat = kwargs.get('log_transformed_sev_scalar_mat_and_upneonat')
        self.log_transformed_age_standardized_sev_scalar_mat_and_upneonat = kwargs.get('log_transformed_age_standardized_sev_scalar_mat_and_upneonat')
        self.log_transformed_sev_scalar_diabetes_and_upckd = kwargs.get('log_transformed_sev_scalar_diabetes_and_upckd')
        self.log_transformed_age_standardized_sev_scalar_diabetes_and_upckd = kwargs.get('log_transformed_age_standardized_sev_scalar_diabetes_and_upckd')
        self.who_sth_mda_coverage_by_age = kwargs.get('who_sth_mda_coverage_by_age')
        self.normal_hemoglobin = kwargs.get('normal_hemoglobin')
        self.covid_19_age_standardized_death_rate = kwargs.get('covid_19_age_standardized_death_rate')
        self._legality_of_abortion__and_up_fetal_impairment = kwargs.get('_legality_of_abortion__and_up_fetal_impairment')
        self.hiv_art_coverage_from_unaids_reports = kwargs.get('hiv_art_coverage_from_unaids_reports')
        self.covid_19_crude_death_rate = kwargs.get('covid_19_crude_death_rate')
        self.covid_19_age_specific_death_rate = kwargs.get('covid_19_age_specific_death_rate')
        self.covid_19_reproductive_age_crude_death_rate = kwargs.get('covid_19_reproductive_age_crude_death_rate')
        self.island_binary = kwargs.get('island_binary')
        self.all_risk_paf = kwargs.get('all_risk_paf')
        self.antipsychotic_use_rates_in_schizophrenia = kwargs.get('antipsychotic_use_rates_in_schizophrenia')
        self.hiv_epidemic_start_year = kwargs.get('hiv_epidemic_start_year')
        self.latent_tuberculosis_infection_prevalence_age_sex_specific = kwargs.get('latent_tuberculosis_infection_prevalence_age_sex_specific')
        self.population_by_latino_origin = kwargs.get('population_by_latino_origin')
        self.population_by_race_ethnicity_and_fips_1977_omb_standard = kwargs.get('population_by_race_ethnicity_and_fips_1977_omb_standard')
        self.population_by_race_ethnicity_and_fips_1997_omb_standard = kwargs.get('population_by_race_ethnicity_and_fips_1997_omb_standard')
        self.varicella_years_since_introduction_of_universal_vaccination = kwargs.get('varicella_years_since_introduction_of_universal_vaccination')
        self.varicella_post_vaccine_incidence_scalar = kwargs.get('varicella_post_vaccine_incidence_scalar')
        self.flu_positivity_rate = kwargs.get('flu_positivity_rate')
        self.dengue_outbreaks_magnitude = kwargs.get('dengue_outbreaks_magnitude')
        self.log_transformed_sev_scalar_self_hang = kwargs.get('log_transformed_sev_scalar_self_hang')
        self.log_transformed_age_standardized_sev_scalar_self_hang = kwargs.get('log_transformed_age_standardized_sev_scalar_self_hang')
        self.log_transformed_sev_scalar_self_fire = kwargs.get('log_transformed_sev_scalar_self_fire')
        self.log_transformed_age_standardized_sev_scalar_self_fire = kwargs.get('log_transformed_age_standardized_sev_scalar_self_fire')
        self.log_transformed_sev_scalar_self_pest = kwargs.get('log_transformed_sev_scalar_self_pest')
        self.log_transformed_age_standardized_sev_scalar_self_pest = kwargs.get('log_transformed_age_standardized_sev_scalar_self_pest')
        self.log_transformed_sev_scalar_self_harm_by_non_pesticide_poisoning = kwargs.get('log_transformed_sev_scalar_self_harm_by_non_pesticide_poisoning')
        self.log_transformed_age_standardized_sev_scalar_self_harm_by_non_pesticide_poisoning = kwargs.get('log_transformed_age_standardized_sev_scalar_self_harm_by_non_pesticide_poisoning')
        self.log_transformed_age_standardized_sev_scalar_schiz = kwargs.get('log_transformed_age_standardized_sev_scalar_schiz')
        self.log_transformed_age_standardized_sev_scalar_bipolar = kwargs.get('log_transformed_age_standardized_sev_scalar_bipolar')
        self.log_transformed_age_standardized_sev_scalar_eating = kwargs.get('log_transformed_age_standardized_sev_scalar_eating')
        self.log_transformed_age_standardized_sev_scalar_bulimia = kwargs.get('log_transformed_age_standardized_sev_scalar_bulimia')
        self.log_transformed_age_standardized_sev_scalar_conduct = kwargs.get('log_transformed_age_standardized_sev_scalar_conduct')
        self.proportion_white_alone = kwargs.get('proportion_white_alone')
        self.proportion_black_alone = kwargs.get('proportion_black_alone')
        self.proportion_aian_alone = kwargs.get('proportion_aian_alone')
        self.proportion_api_alone = kwargs.get('proportion_api_alone')
        self.proportion_multiracial = kwargs.get('proportion_multiracial')
        self.rural_urban_continuum_code_2023 = kwargs.get('rural_urban_continuum_code_2023')
        self.rural_urban_continuum_code_2013 = kwargs.get('rural_urban_continuum_code_2013')
        self.rural_urban_continuum_code_2003 = kwargs.get('rural_urban_continuum_code_2003')
        self.rural_urban_continuum_code_1993 = kwargs.get('rural_urban_continuum_code_1993')
