"""Mapping templates for GBD etiologies.

This code is automatically generated by gbd_mapping_generator/etiology_builder.py

Any manual changes will be lost.
"""

from .base_template import GbdRecord, ModelableEntity
from .id import rei_id


class Etiology(ModelableEntity):
    """Container for etiology GBD ids and metadata."""

    __slots__ = (
        "name",
        "kind",
        "gbd_id",
    )

    def __init__(
        self,
        name: str,
        kind: str,
        gbd_id: rei_id | None,
    ):
        super().__init__(name=name, kind=kind, gbd_id=gbd_id)
        self.name = name
        self.kind = kind
        self.gbd_id = gbd_id


class Etiologies(GbdRecord):
    """Container for GBD etiologies."""

    __slots__ = (
        "cholera",
        "non_typhoidal_salmonella",
        "shigella",
        "enteropathogenic_e_coli",
        "enterotoxigenic_e_coli",
        "campylobacter",
        "entamoeba",
        "cryptosporidium",
        "rotavirus",
        "aeromonas",
        "clostridium_difficile",
        "norovirus",
        "adenovirus",
        "influenza",
        "respiratory_syncytial_virus",
        "group_b_streptococcus",
        "acinetobacter_baumannii",
        "chlamydia_spp",
        "enterobacter_spp",
        "escherichia_coli",
        "haemophilus_influenzae",
        "klebsiella_pneumoniae",
        "legionella_spp",
        "listeria_monocytogenes",
        "mycoplasma",
        "other_bacterial_and_viral_pathogens",
        "pseudomonas_aeruginosa",
        "staphylococcus_aureus",
        "streptococcus_pneumoniae",
        "neisseria_meningitidis",
        "aspergillus_spp",
        "other_acinetobacter_species",
        "citrobacter_spp",
        "other_fungi",
        "other_gram_negative_bacteria",
        "other_klebsiella_species",
        "morganella_spp",
        "other_mycobacterium_species_non_tb_non_leprosy",
        "proteus_spp",
        "serratia_spp",
        "group_a_streptococcus",
        "candida_spp",
        "coagulase_negative_staphylococci",
        "non_polio_enteroviruses",
        "other_streptococcus_species",
        "other_viral_etiologies_of_meningitis",
    )

    def __init__(
        self,
        cholera: Etiology,
        non_typhoidal_salmonella: Etiology,
        shigella: Etiology,
        enteropathogenic_e_coli: Etiology,
        enterotoxigenic_e_coli: Etiology,
        campylobacter: Etiology,
        entamoeba: Etiology,
        cryptosporidium: Etiology,
        rotavirus: Etiology,
        aeromonas: Etiology,
        clostridium_difficile: Etiology,
        norovirus: Etiology,
        adenovirus: Etiology,
        influenza: Etiology,
        respiratory_syncytial_virus: Etiology,
        group_b_streptococcus: Etiology,
        acinetobacter_baumannii: Etiology,
        chlamydia_spp: Etiology,
        enterobacter_spp: Etiology,
        escherichia_coli: Etiology,
        haemophilus_influenzae: Etiology,
        klebsiella_pneumoniae: Etiology,
        legionella_spp: Etiology,
        listeria_monocytogenes: Etiology,
        mycoplasma: Etiology,
        other_bacterial_and_viral_pathogens: Etiology,
        pseudomonas_aeruginosa: Etiology,
        staphylococcus_aureus: Etiology,
        streptococcus_pneumoniae: Etiology,
        neisseria_meningitidis: Etiology,
        aspergillus_spp: Etiology,
        other_acinetobacter_species: Etiology,
        citrobacter_spp: Etiology,
        other_fungi: Etiology,
        other_gram_negative_bacteria: Etiology,
        other_klebsiella_species: Etiology,
        morganella_spp: Etiology,
        other_mycobacterium_species_non_tb_non_leprosy: Etiology,
        proteus_spp: Etiology,
        serratia_spp: Etiology,
        group_a_streptococcus: Etiology,
        candida_spp: Etiology,
        coagulase_negative_staphylococci: Etiology,
        non_polio_enteroviruses: Etiology,
        other_streptococcus_species: Etiology,
        other_viral_etiologies_of_meningitis: Etiology,
    ):
        super().__init__()
        self.cholera = cholera
        self.non_typhoidal_salmonella = non_typhoidal_salmonella
        self.shigella = shigella
        self.enteropathogenic_e_coli = enteropathogenic_e_coli
        self.enterotoxigenic_e_coli = enterotoxigenic_e_coli
        self.campylobacter = campylobacter
        self.entamoeba = entamoeba
        self.cryptosporidium = cryptosporidium
        self.rotavirus = rotavirus
        self.aeromonas = aeromonas
        self.clostridium_difficile = clostridium_difficile
        self.norovirus = norovirus
        self.adenovirus = adenovirus
        self.influenza = influenza
        self.respiratory_syncytial_virus = respiratory_syncytial_virus
        self.group_b_streptococcus = group_b_streptococcus
        self.acinetobacter_baumannii = acinetobacter_baumannii
        self.chlamydia_spp = chlamydia_spp
        self.enterobacter_spp = enterobacter_spp
        self.escherichia_coli = escherichia_coli
        self.haemophilus_influenzae = haemophilus_influenzae
        self.klebsiella_pneumoniae = klebsiella_pneumoniae
        self.legionella_spp = legionella_spp
        self.listeria_monocytogenes = listeria_monocytogenes
        self.mycoplasma = mycoplasma
        self.other_bacterial_and_viral_pathogens = other_bacterial_and_viral_pathogens
        self.pseudomonas_aeruginosa = pseudomonas_aeruginosa
        self.staphylococcus_aureus = staphylococcus_aureus
        self.streptococcus_pneumoniae = streptococcus_pneumoniae
        self.neisseria_meningitidis = neisseria_meningitidis
        self.aspergillus_spp = aspergillus_spp
        self.other_acinetobacter_species = other_acinetobacter_species
        self.citrobacter_spp = citrobacter_spp
        self.other_fungi = other_fungi
        self.other_gram_negative_bacteria = other_gram_negative_bacteria
        self.other_klebsiella_species = other_klebsiella_species
        self.morganella_spp = morganella_spp
        self.other_mycobacterium_species_non_tb_non_leprosy = (
            other_mycobacterium_species_non_tb_non_leprosy
        )
        self.proteus_spp = proteus_spp
        self.serratia_spp = serratia_spp
        self.group_a_streptococcus = group_a_streptococcus
        self.candida_spp = candida_spp
        self.coagulase_negative_staphylococci = coagulase_negative_staphylococci
        self.non_polio_enteroviruses = non_polio_enteroviruses
        self.other_streptococcus_species = other_streptococcus_species
        self.other_viral_etiologies_of_meningitis = other_viral_etiologies_of_meningitis
